/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture3D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class TextureGeneratorWood
extends TextureGenerator {
    protected static final int TEX_SIN = 0;
    protected static final int TEX_SAW = 1;
    protected static final int TEX_TRI = 2;
    protected static final int TEX_BAND = 0;
    protected static final int TEX_RING = 1;
    protected static final int TEX_BANDNOISE = 2;
    protected static final int TEX_RINGNOISE = 3;
    protected static final int TEX_NOISESOFT = 0;
    protected static final int TEX_NOISEPERL = 1;
    protected static WaveForm[] waveformFunctions = new WaveForm[3];

    public TextureGeneratorWood(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    protected Texture generate(Structure tex, int width, int height, int depth, BlenderContext blenderContext) {
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        TexturePixel texres = new TexturePixel();
        int halfW = width >> 1;
        int halfH = height >> 1;
        int halfD = depth >> 1;
        float wDelta = 1.0f / (float)halfW;
        float hDelta = 1.0f / (float)halfH;
        float dDelta = 1.0f / (float)halfD;
        float[][] colorBand = this.computeColorband(tex, blenderContext);
        Image.Format format = colorBand != null ? Image.Format.RGBA8 : Image.Format.Luminance8;
        int bytesPerPixel = colorBand != null ? 4 : 1;
        WoodIntensityData woodIntensityData = new WoodIntensityData(tex);
        TextureGenerator.BrightnessAndContrastData bacd = new TextureGenerator.BrightnessAndContrastData(tex);
        int index = 0;
        byte[] data = new byte[width * height * depth * bytesPerPixel];
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j;
                for (int k = -halfD; k < halfD; ++k) {
                    texvec[2] = dDelta * (float)k;
                    texres.intensity = this.woodIntensity(woodIntensityData, texvec[0], texvec[1], texvec[2]);
                    if (colorBand != null) {
                        int colorbandIndex = (int)(texres.intensity * 1000.0f);
                        texres.red = colorBand[colorbandIndex][0];
                        texres.green = colorBand[colorbandIndex][1];
                        texres.blue = colorBand[colorbandIndex][2];
                        this.applyBrightnessAndContrast(bacd, texres);
                        data[index++] = (byte)(texres.red * 255.0f);
                        data[index++] = (byte)(texres.green * 255.0f);
                        data[index++] = (byte)(texres.blue * 255.0f);
                        data[index++] = (byte)(colorBand[colorbandIndex][3] * 255.0f);
                        continue;
                    }
                    this.applyBrightnessAndContrast(texres, bacd.contrast, bacd.brightness);
                    data[index++] = (byte)(texres.intensity * 255.0f);
                }
            }
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(1);
        dataArray.add(BufferUtils.createByteBuffer(data));
        return new Texture3D(new Image(format, width, height, depth, dataArray));
    }

    public float woodIntensity(WoodIntensityData woodIntData, float x, float y, float z) {
        float result;
        switch (woodIntData.woodType) {
            case 0: {
                result = woodIntData.waveformFunction.execute((x + y + z) * 10.0f);
                break;
            }
            case 1: {
                result = woodIntData.waveformFunction.execute((float)Math.sqrt(x * x + y * y + z * z) * 20.0f);
                break;
            }
            case 2: {
                result = woodIntData.turbul * NoiseGenerator.NoiseFunctions.noise(x, y, z, woodIntData.noisesize, 0, woodIntData.noisebasis, woodIntData.isHard);
                result = woodIntData.waveformFunction.execute((x + y + z) * 10.0f + result);
                break;
            }
            case 3: {
                result = woodIntData.turbul * NoiseGenerator.NoiseFunctions.noise(x, y, z, woodIntData.noisesize, 0, woodIntData.noisebasis, woodIntData.isHard);
                result = woodIntData.waveformFunction.execute((float)Math.sqrt(x * x + y * y + z * z) * 20.0f + result);
                break;
            }
            default: {
                result = 0.0f;
            }
        }
        return result;
    }

    static {
        TextureGeneratorWood.waveformFunctions[0] = new WaveForm(){

            public float execute(float x) {
                return 0.5f + 0.5f * (float)Math.sin(x);
            }
        };
        TextureGeneratorWood.waveformFunctions[1] = new WaveForm(){

            public float execute(float x) {
                int n;
                if ((x -= (float)(n = (int)(x * 0.15915494f)) * ((float)Math.PI * 2)) < 0.0f) {
                    x += (float)Math.PI * 2;
                }
                return x * 0.15915494f;
            }
        };
        TextureGeneratorWood.waveformFunctions[2] = new WaveForm(){

            public float execute(float x) {
                return 1.0f - 2.0f * FastMath.abs((float)Math.floor(x * 0.15915494f + 0.5f) - x * 0.15915494f);
            }
        };
    }

    protected static interface WaveForm {
        public float execute(float var1);
    }

    private static class WoodIntensityData {
        public final WaveForm waveformFunction;
        public final int noisebasis;
        public final float noisesize;
        public final float turbul;
        public final int noiseType;
        public final int woodType;
        public final boolean isHard;

        public WoodIntensityData(Structure tex) {
            int waveform = ((Number)tex.getFieldValue("noisebasis2")).intValue();
            if (waveform > 2 || waveform < 0) {
                waveform = 0;
            }
            this.waveformFunction = waveformFunctions[waveform];
            this.noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
            this.woodType = ((Number)tex.getFieldValue("stype")).intValue();
            this.noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
            this.turbul = ((Number)tex.getFieldValue("turbul")).floatValue();
            this.noiseType = ((Number)tex.getFieldValue("noisetype")).intValue();
            this.isHard = this.noiseType != 0;
        }
    }
}

