/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture3D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class TextureGeneratorVoronoi
extends TextureGenerator {
    public TextureGeneratorVoronoi(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    protected Texture generate(Structure tex, int width, int height, int depth, BlenderContext blenderContext) {
        float voronoiWeight1 = ((Number)tex.getFieldValue("vn_w1")).floatValue();
        float voronoiWeight2 = ((Number)tex.getFieldValue("vn_w2")).floatValue();
        float voronoiWeight3 = ((Number)tex.getFieldValue("vn_w3")).floatValue();
        float voronoiWeight4 = ((Number)tex.getFieldValue("vn_w4")).floatValue();
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        float outscale = ((Number)tex.getFieldValue("ns_outscale")).floatValue();
        float mexp = ((Number)tex.getFieldValue("vn_mexp")).floatValue();
        int distm = ((Number)tex.getFieldValue("vn_distm")).intValue();
        int voronoiColorType = ((Number)tex.getFieldValue("vn_coltype")).intValue();
        TexturePixel texres = new TexturePixel();
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        int halfW = width >> 1;
        int halfH = height >> 1;
        int halfD = depth >> 1;
        int index = 0;
        float wDelta = 1.0f / (float)halfW;
        float hDelta = 1.0f / (float)halfH;
        float dDelta = 1.0f / (float)halfD;
        float[][] colorBand = this.computeColorband(tex, blenderContext);
        Image.Format format = voronoiColorType != 0 || colorBand != null ? Image.Format.RGBA8 : Image.Format.Luminance8;
        int bytesPerPixel = voronoiColorType != 0 || colorBand != null ? 4 : 1;
        TextureGenerator.BrightnessAndContrastData bacd = new TextureGenerator.BrightnessAndContrastData(tex);
        float[] da = new float[4];
        float[] pa = new float[12];
        float[] hashPoint = voronoiColorType != 0 ? new float[3] : null;
        float[] voronoiWeights = new float[]{FastMath.abs(voronoiWeight1), FastMath.abs(voronoiWeight2), FastMath.abs(voronoiWeight3), FastMath.abs(voronoiWeight4)};
        float sc = voronoiWeights[0] + voronoiWeights[1] + voronoiWeights[2] + voronoiWeights[3];
        if (sc != 0.0f) {
            sc = outscale / sc;
        }
        byte[] data = new byte[width * height * depth * bytesPerPixel];
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i / noisesize;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j / noisesize;
                for (int k = -halfD; k < halfD; ++k) {
                    texvec[2] = dDelta * (float)k;
                    NoiseGenerator.NoiseFunctions.voronoi(texvec[0], texvec[1], texvec[2], da, pa, mexp, distm);
                    texres.intensity = sc * FastMath.abs(voronoiWeight1 * da[0] + voronoiWeight2 * da[1] + voronoiWeight3 * da[2] + voronoiWeight4 * da[3]);
                    if (texres.intensity > 1.0f) {
                        texres.intensity = 1.0f;
                    } else if (texres.intensity < 0.0f) {
                        texres.intensity = 0.0f;
                    }
                    if (colorBand != null) {
                        int colorbandIndex = (int)(texres.intensity * 1000.0f);
                        texres.red = colorBand[colorbandIndex][0];
                        texres.green = colorBand[colorbandIndex][1];
                        texres.blue = colorBand[colorbandIndex][2];
                        texres.alpha = colorBand[colorbandIndex][3];
                    } else if (voronoiColorType != 0) {
                        texres.blue = 0.0f;
                        texres.green = 0.0f;
                        texres.red = 0.0f;
                        texres.alpha = 1.0f;
                        for (int m = 0; m < 12; m += 3) {
                            float weight = voronoiWeights[m / 3];
                            this.cellNoiseV(pa[m], pa[m + 1], pa[m + 2], hashPoint);
                            texres.red += weight * hashPoint[0];
                            texres.green += weight * hashPoint[1];
                            texres.blue += weight * hashPoint[2];
                        }
                        if (voronoiColorType >= 2) {
                            float t1 = (da[1] - da[0]) * 10.0f;
                            if (t1 > 1.0f) {
                                t1 = 1.0f;
                            }
                            t1 = voronoiColorType == 3 ? (t1 *= texres.intensity) : (t1 *= sc);
                            texres.red *= t1;
                            texres.green *= t1;
                            texres.blue *= t1;
                        } else {
                            texres.red *= sc;
                            texres.green *= sc;
                            texres.blue *= sc;
                        }
                    }
                    if (voronoiColorType != 0 || colorBand != null) {
                        this.applyBrightnessAndContrast(bacd, texres);
                        data[index++] = (byte)(texres.red * 255.0f);
                        data[index++] = (byte)(texres.green * 255.0f);
                        data[index++] = (byte)(texres.blue * 255.0f);
                        data[index++] = (byte)(texres.alpha * 255.0f);
                        continue;
                    }
                    this.applyBrightnessAndContrast(texres, bacd.contrast, bacd.brightness);
                    data[index++] = (byte)(texres.intensity * 255.0f);
                }
            }
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(1);
        dataArray.add(BufferUtils.createByteBuffer(data));
        return new Texture3D(new Image(format, width, height, depth, dataArray));
    }

    private void cellNoiseV(float x, float y, float z, float[] hashPoint) {
        int xi = (int)Math.floor(x);
        int yi = (int)Math.floor(y);
        int zi = (int)Math.floor(z);
        NoiseGenerator.NoiseMath.hash(xi, yi, zi, hashPoint);
    }
}

