/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture3D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class TextureGeneratorMagic
extends TextureGenerator {
    private static NoiseDepthFunction[] noiseDepthFunctions = new NoiseDepthFunction[10];

    public TextureGeneratorMagic(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    protected Texture generate(Structure tex, int width, int height, int depth, BlenderContext blenderContext) {
        float[] xyz = new float[3];
        int noisedepth = ((Number)tex.getFieldValue("noisedepth")).intValue();
        float turbul = ((Number)tex.getFieldValue("turbul")).floatValue() / 5.0f;
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        TexturePixel texres = new TexturePixel();
        int halfW = width >> 1;
        int halfH = height >> 1;
        int halfD = depth >> 1;
        int index = 0;
        float wDelta = 1.0f / (float)halfW;
        float hDelta = 1.0f / (float)halfH;
        float dDelta = 1.0f / (float)halfD;
        float[][] colorBand = this.computeColorband(tex, blenderContext);
        TextureGenerator.BrightnessAndContrastData bacd = new TextureGenerator.BrightnessAndContrastData(tex);
        byte[] data = new byte[width * height * depth * 4];
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j;
                for (int k = -halfD; k < halfD; ++k) {
                    float turb = turbul;
                    texvec[2] = dDelta * (float)k;
                    xyz[0] = (float)Math.sin((texvec[0] + texvec[1] + texvec[2]) * 5.0f);
                    xyz[1] = (float)Math.cos((-texvec[0] + texvec[1] - texvec[2]) * 5.0f);
                    xyz[2] = -((float)Math.cos((-texvec[0] - texvec[1] + texvec[2]) * 5.0f));
                    if (colorBand != null) {
                        texres.intensity = FastMath.clamp(0.3333f * (xyz[0] + xyz[1] + xyz[2]), 0.0f, 1.0f);
                        int colorbandIndex = (int)(texres.intensity * 1000.0f);
                        texres.red = colorBand[colorbandIndex][0];
                        texres.green = colorBand[colorbandIndex][1];
                        texres.blue = colorBand[colorbandIndex][2];
                        texres.alpha = colorBand[colorbandIndex][3];
                    } else {
                        if (noisedepth > 0) {
                            xyz[0] = xyz[0] * turb;
                            xyz[1] = xyz[1] * turb;
                            xyz[2] = xyz[2] * turb;
                            for (int m = 0; m < noisedepth; ++m) {
                                noiseDepthFunctions[m].compute(xyz, turb);
                            }
                        }
                        if (turb != 0.0f) {
                            xyz[0] = xyz[0] / (turb *= 2.0f);
                            xyz[1] = xyz[1] / turb;
                            xyz[2] = xyz[2] / turb;
                        }
                        texres.red = 0.5f - xyz[0];
                        texres.green = 0.5f - xyz[1];
                        texres.blue = 0.5f - xyz[2];
                        texres.alpha = 1.0f;
                    }
                    this.applyBrightnessAndContrast(bacd, texres);
                    data[index++] = (byte)(texres.red * 255.0f);
                    data[index++] = (byte)(texres.green * 255.0f);
                    data[index++] = (byte)(texres.blue * 255.0f);
                    data[index++] = (byte)(texres.alpha * 255.0f);
                }
            }
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(1);
        dataArray.add(BufferUtils.createByteBuffer(data));
        return new Texture3D(new Image(Image.Format.RGBA8, width, height, depth, dataArray));
    }

    static {
        TextureGeneratorMagic.noiseDepthFunctions[0] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[1] = -((float)Math.cos(xyz[0] - xyz[1] + xyz[2])) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[1] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[0] = (float)Math.cos(xyz[0] - xyz[1] - xyz[2]) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[2] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[2] = (float)Math.sin(-xyz[0] - xyz[1] - xyz[2]) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[3] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[0] = -((float)Math.cos(-xyz[0] + xyz[1] - xyz[2])) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[4] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[1] = -((float)Math.sin(-xyz[0] + xyz[1] + xyz[2])) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[5] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[1] = -((float)Math.cos(-xyz[0] + xyz[1] + xyz[2])) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[6] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[0] = (float)Math.cos(xyz[0] + xyz[1] + xyz[2]) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[7] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[2] = (float)Math.sin(xyz[0] + xyz[1] - xyz[2]) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[8] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[0] = -((float)Math.cos(-xyz[0] - xyz[1] + xyz[2])) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[9] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[1] = -((float)Math.sin(xyz[0] - xyz[1] + xyz[2])) * turbulence;
            }
        };
    }

    private static interface NoiseDepthFunction {
        public void compute(float[] var1, float var2);
    }
}

