/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture3D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class TextureGeneratorClouds
extends TextureGenerator {
    protected static final int TEX_NOISESOFT = 0;
    protected static final int TEX_NOISEPERL = 1;
    protected static final int TEX_DEFAULT = 0;
    protected static final int TEX_COLOR = 1;

    public TextureGeneratorClouds(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    protected Texture generate(Structure tex, int width, int height, int depth, BlenderContext blenderContext) {
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        TexturePixel texres = new TexturePixel();
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        int noiseDepth = ((Number)tex.getFieldValue("noisedepth")).intValue();
        int noiseBasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
        int noiseType = ((Number)tex.getFieldValue("noisetype")).intValue();
        boolean isHard = noiseType != 0;
        int sType = ((Number)tex.getFieldValue("stype")).intValue();
        int halfW = width >> 1;
        int halfH = height >> 1;
        int halfD = depth >> 1;
        int index = 0;
        float wDelta = 1.0f / (float)halfW;
        float hDelta = 1.0f / (float)halfH;
        float dDelta = 1.0f / (float)halfD;
        float[][] colorBand = this.computeColorband(tex, blenderContext);
        Image.Format format = sType == 1 || colorBand != null ? Image.Format.RGBA8 : Image.Format.Luminance8;
        int bytesPerPixel = sType == 1 || colorBand != null ? 4 : 1;
        TextureGenerator.BrightnessAndContrastData bacd = new TextureGenerator.BrightnessAndContrastData(tex);
        byte[] data = new byte[width * height * depth * bytesPerPixel];
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j;
                for (int k = -halfD; k < halfD; ++k) {
                    texvec[2] = dDelta * (float)k;
                    texres.intensity = NoiseGenerator.NoiseFunctions.turbulence(texvec[0], texvec[1], texvec[2], noisesize, noiseDepth, noiseBasis, isHard);
                    texres.intensity = FastMath.clamp(texres.intensity, 0.0f, 1.0f);
                    if (colorBand != null) {
                        int colorbandIndex = (int)(texres.intensity * 1000.0f);
                        texres.red = colorBand[colorbandIndex][0];
                        texres.green = colorBand[colorbandIndex][1];
                        texres.blue = colorBand[colorbandIndex][2];
                        this.applyBrightnessAndContrast(bacd, texres);
                        data[index++] = (byte)(texres.red * 255.0f);
                        data[index++] = (byte)(texres.green * 255.0f);
                        data[index++] = (byte)(texres.blue * 255.0f);
                        data[index++] = (byte)(colorBand[colorbandIndex][3] * 255.0f);
                        continue;
                    }
                    if (sType == 1) {
                        texres.red = texres.intensity;
                        texres.green = NoiseGenerator.NoiseFunctions.turbulence(texvec[1], texvec[0], texvec[2], noisesize, noiseDepth, noiseBasis, isHard);
                        texres.blue = NoiseGenerator.NoiseFunctions.turbulence(texvec[1], texvec[2], texvec[0], noisesize, noiseDepth, noiseBasis, isHard);
                        texres.green = FastMath.clamp(texres.green, 0.0f, 1.0f);
                        texres.blue = FastMath.clamp(texres.blue, 0.0f, 1.0f);
                        this.applyBrightnessAndContrast(bacd, texres);
                        data[index++] = (byte)(texres.red * 255.0f);
                        data[index++] = (byte)(texres.green * 255.0f);
                        data[index++] = (byte)(texres.blue * 255.0f);
                        data[index++] = -1;
                        continue;
                    }
                    this.applyBrightnessAndContrast(texres, bacd.contrast, bacd.brightness);
                    data[index++] = (byte)(texres.intensity * 255.0f);
                }
            }
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(1);
        dataArray.add(BufferUtils.createByteBuffer(data));
        return new Texture3D(new Image(format, width, height, depth, dataArray));
    }
}

