/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.SpatialTrack;
import com.jme3.scene.Node;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.animations.IpoHelper;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.ogre.AnimData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class ObjectAnimationModifier
extends Modifier {
    private static final Logger LOGGER = Logger.getLogger(ObjectAnimationModifier.class.getName());
    private AnimData animData;
    private Long objectOMA;

    public ObjectAnimationModifier(Structure objectStructure, BlenderContext blenderContext) throws BlenderFileException {
        LOGGER.warning("Object animation modifier not yet implemented!");
        Pointer pIpo = (Pointer)objectStructure.getFieldValue("ipo");
        if (pIpo.isNotNull()) {
            String objectAnimationName = null;
            List<FileBlockHeader> actionBlocks = blenderContext.getFileBlocks(1094909952);
            for (FileBlockHeader actionBlock : actionBlocks) {
                Pointer pChannelIpo;
                Structure action = actionBlock.getStructure(blenderContext);
                List<Structure> actionChannels = ((Structure)action.getFieldValue("chanbase")).evaluateListBase(blenderContext);
                if (actionChannels.size() != 1 || !(pChannelIpo = (Pointer)actionChannels.get(0).getFieldValue("ipo")).equals(pIpo)) continue;
                objectAnimationName = action.getName();
                break;
            }
            String objectName = objectStructure.getName();
            if (objectAnimationName == null) {
                objectAnimationName = objectName;
            }
            IpoHelper ipoHelper = (IpoHelper)blenderContext.getHelper(IpoHelper.class);
            Structure ipoStructure = pIpo.fetchData(blenderContext.getInputStream()).get(0);
            Ipo ipo = ipoHelper.createIpo(ipoStructure, blenderContext);
            int fps = blenderContext.getBlenderKey().getFps();
            SpatialTrack track = (SpatialTrack)ipo.calculateTrack(-1, 0, ipo.getLastFrame(), fps);
            Animation animation = new Animation(objectAnimationName, ipo.getLastFrame() / fps);
            animation.setTracks(new SpatialTrack[]{track});
            ArrayList<Animation> animations = new ArrayList<Animation>(1);
            animations.add(animation);
            this.animData = new AnimData(null, animations);
            this.objectOMA = objectStructure.getOldMemoryAddress();
        }
    }

    public Node apply(Node node, BlenderContext blenderContext) {
        if (this.invalid) {
            LOGGER.log(Level.WARNING, "Armature modifier is invalid! Cannot be applied to: {0}", node.getName());
        }
        if (this.animData == null) {
            return node;
        }
        ArrayList<Animation> animList = this.animData.anims;
        if (animList != null && animList.size() > 0) {
            List<Constraint> constraints = blenderContext.getConstraints(this.objectOMA);
            HashMap<String, Animation> anims = new HashMap<String, Animation>();
            for (int i = 0; i < animList.size(); ++i) {
                Animation animation = animList.get(i).clone();
                if (constraints != null && constraints.size() > 0) {
                    for (Constraint constraint : constraints) {
                        constraint.affectAnimation(animation, 0);
                    }
                }
                anims.put(animation.getName(), animation);
            }
            AnimControl control = new AnimControl(null);
            control.setAnimations(anims);
            node.addControl(control);
        }
        return node;
    }

    public String getType() {
        return "ObjectAnimationModifierData";
    }
}

