/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.animation.Track;
import com.jme3.math.Matrix4f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.ArmatureHelper;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.meshes.MeshContext;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import com.jme3.scene.plugins.ogre.AnimData;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArmatureModifier
extends Modifier {
    private static final Logger LOGGER = Logger.getLogger(ArmatureModifier.class.getName());
    private static final int MAXIMUM_WEIGHTS_PER_VERTEX = 4;
    private AnimData animData;
    private Long armatureObjectOMA;
    private Long meshOMA;
    private int boneGroups;
    private VertexBuffer verticesWeights;
    private VertexBuffer verticesWeightsIndices;

    ArmatureModifier() {
    }

    public ArmatureModifier(Structure objectStructure, Structure modifierStructure, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pArmatureObject;
        if (this.validate(modifierStructure, blenderContext) && (pArmatureObject = (Pointer)modifierStructure.getFieldValue("object")).isNotNull()) {
            ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
            ArmatureHelper armatureHelper = (ArmatureHelper)blenderContext.getHelper(ArmatureHelper.class);
            Structure armatureObject = pArmatureObject.fetchData(blenderContext.getInputStream()).get(0);
            this.armatureObjectOMA = armatureObject.getOldMemoryAddress();
            Structure armatureStructure = ((Pointer)armatureObject.getFieldValue("data")).fetchData(blenderContext.getInputStream()).get(0);
            Structure bonebase = (Structure)armatureStructure.getFieldValue("bonebase");
            List<Structure> bonesStructures = bonebase.evaluateListBase(blenderContext);
            for (Structure boneStructure : bonesStructures) {
                ArmatureHelper.BoneTransformationData rootBoneTransformationData = armatureHelper.readBoneAndItsChildren(boneStructure, null, blenderContext);
                armatureHelper.addBoneDataRoot(rootBoneTransformationData);
            }
            Matrix4f armatureObjectMatrix = objectHelper.getTransformationMatrix(armatureObject);
            Matrix4f inverseMeshObjectMatrix = objectHelper.getTransformationMatrix(objectStructure).invert();
            Matrix4f additionalRootBoneTransformation = inverseMeshObjectMatrix.multLocal(armatureObjectMatrix);
            Bone[] bones = armatureHelper.buildBonesStructure(0L, additionalRootBoneTransformation);
            Structure meshStructure = ((Pointer)objectStructure.getFieldValue("data")).fetchData(blenderContext.getInputStream()).get(0);
            this.meshOMA = meshStructure.getOldMemoryAddress();
            this.readVerticesWeightsData(objectStructure, meshStructure, blenderContext);
            ArrayList<Animation> animations = new ArrayList<Animation>();
            List<FileBlockHeader> actionHeaders = blenderContext.getFileBlocks(1094909952);
            if (actionHeaders != null) {
                for (FileBlockHeader header : actionHeaders) {
                    Structure actionStructure = header.getStructure(blenderContext);
                    String actionName = actionStructure.getName();
                    Track[] tracks = armatureHelper.getTracks(actionStructure, blenderContext);
                    float maximumTrackLength = 0.0f;
                    for (BoneTrack boneTrack : tracks) {
                        float length = boneTrack.getLength();
                        if (!(length > maximumTrackLength)) continue;
                        maximumTrackLength = length;
                    }
                    Animation boneAnimation = new Animation(actionName, maximumTrackLength);
                    boneAnimation.setTracks(tracks);
                    animations.add(boneAnimation);
                }
            }
            this.animData = new AnimData(new Skeleton(bones), animations);
        }
    }

    @Override
    public Node apply(Node node, BlenderContext blenderContext) {
        if (this.invalid) {
            LOGGER.log(Level.WARNING, "Armature modifier is invalid! Cannot be applied to: {0}", node.getName());
        }
        if (this.animData == null) {
            return node;
        }
        List geomList = (List)blenderContext.getLoadedFeature(this.meshOMA, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        for (Geometry geom : geomList) {
            Mesh mesh = geom.getMesh();
            if (this.verticesWeights == null) continue;
            mesh.setMaxNumWeights(this.boneGroups);
            mesh.setBuffer(this.verticesWeights);
            mesh.setBuffer(this.verticesWeightsIndices);
        }
        ArrayList<Animation> animList = this.animData.anims;
        if (animList != null && animList.size() > 0) {
            List<Constraint> constraints = blenderContext.getConstraints(this.armatureObjectOMA);
            HashMap<String, Animation> anims = new HashMap<String, Animation>();
            for (int i = 0; i < animList.size(); ++i) {
                Animation animation = animList.get(i).clone();
                if (constraints != null && constraints.size() > 0) {
                    for (Constraint constraint : constraints) {
                        Long boneOMA = constraint.getBoneOMA();
                        Bone bone = (Bone)blenderContext.getLoadedFeature(boneOMA, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
                        int targetIndex = bone == null ? 0 : this.animData.skeleton.getBoneIndex(bone);
                        constraint.affectAnimation(animation, targetIndex);
                    }
                }
                anims.put(animation.getName(), animation);
            }
            SkeletonControl skeletonControl = new SkeletonControl(this.animData.skeleton);
            AnimControl control = new AnimControl(this.animData.skeleton);
            control.setAnimations(anims);
            node.addControl(control);
            node.addControl(skeletonControl);
        }
        return node;
    }

    private void readVerticesWeightsData(Structure objectStructure, Structure meshStructure, BlenderContext blenderContext) throws BlenderFileException {
        ArmatureHelper armatureHelper = (ArmatureHelper)blenderContext.getHelper(ArmatureHelper.class);
        Structure defBase = (Structure)objectStructure.getFieldValue("defbase");
        Map<Integer, Integer> groupToBoneIndexMap = armatureHelper.getGroupToBoneIndexMap(defBase, blenderContext);
        int[] bonesGroups = new int[]{0};
        MeshContext meshContext = blenderContext.getMeshContext(meshStructure.getOldMemoryAddress());
        VertexBuffer[] boneWeightsAndIndex = this.getBoneWeightAndIndexBuffer(meshStructure, meshContext.getVertexList().size(), bonesGroups, meshContext.getVertexReferenceMap(), groupToBoneIndexMap, blenderContext);
        this.verticesWeights = boneWeightsAndIndex[0];
        this.verticesWeightsIndices = boneWeightsAndIndex[1];
        this.boneGroups = bonesGroups[0];
    }

    private VertexBuffer[] getBoneWeightAndIndexBuffer(Structure meshStructure, int vertexListSize, int[] bonesGroups, Map<Integer, List<Integer>> vertexReferenceMap, Map<Integer, Integer> groupToBoneIndexMap, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pDvert = (Pointer)meshStructure.getFieldValue("dvert");
        FloatBuffer weightsFloatData = BufferUtils.createFloatBuffer(vertexListSize * 4);
        ByteBuffer indicesData = BufferUtils.createByteBuffer(vertexListSize * 4);
        if (pDvert.isNotNull()) {
            List<Structure> dverts = pDvert.fetchData(blenderContext.getInputStream());
            int vertexIndex = 0;
            for (Structure dvert : dverts) {
                int totweight = ((Number)dvert.getFieldValue("totweight")).intValue();
                Pointer pDW = (Pointer)dvert.getFieldValue("dw");
                List<Integer> vertexIndices = vertexReferenceMap.get(vertexIndex);
                if (totweight > 0 && pDW.isNotNull() && groupToBoneIndexMap != null) {
                    int weightIndex = 0;
                    List<Structure> dw = pDW.fetchData(blenderContext.getInputStream());
                    for (Structure deformWeight : dw) {
                        Integer boneIndex = groupToBoneIndexMap.get(((Number)deformWeight.getFieldValue("def_nr")).intValue());
                        if (weightIndex == 4) {
                            LOGGER.log(Level.WARNING, "{0} has more than 4 weight on bone index {1}", new Object[]{meshStructure.getName(), boneIndex});
                            break;
                        }
                        if (boneIndex != null) {
                            float weight = ((Number)deformWeight.getFieldValue("weight")).floatValue();
                            if (weight == 0.0f) {
                                weight = 1.0f;
                                boneIndex = 0;
                            }
                            for (Integer index : vertexIndices) {
                                weightsFloatData.put(index * 4 + weightIndex, weight);
                                indicesData.put(index * 4 + weightIndex, boneIndex.byteValue());
                            }
                        }
                        ++weightIndex;
                    }
                } else {
                    for (Integer index : vertexIndices) {
                        weightsFloatData.put(index * 4, 1.0f);
                        indicesData.put(index * 4, (byte)0);
                    }
                }
                ++vertexIndex;
            }
        } else {
            for (List<Integer> vertexIndexList : vertexReferenceMap.values()) {
                for (Integer index : vertexIndexList) {
                    weightsFloatData.put(index * 4, 1.0f);
                    indicesData.put(index * 4, (byte)0);
                }
            }
        }
        bonesGroups[0] = this.endBoneAssigns(vertexListSize, weightsFloatData);
        VertexBuffer verticesWeights = new VertexBuffer(VertexBuffer.Type.BoneWeight);
        verticesWeights.setupData(VertexBuffer.Usage.CpuOnly, bonesGroups[0], VertexBuffer.Format.Float, weightsFloatData);
        VertexBuffer verticesWeightsIndices = new VertexBuffer(VertexBuffer.Type.BoneIndex);
        verticesWeightsIndices.setupData(VertexBuffer.Usage.CpuOnly, bonesGroups[0], VertexBuffer.Format.UnsignedByte, indicesData);
        return new VertexBuffer[]{verticesWeights, verticesWeightsIndices};
    }

    private int endBoneAssigns(int vertCount, FloatBuffer weightsFloatData) {
        int maxWeightsPerVert = 0;
        weightsFloatData.rewind();
        for (int v = 0; v < vertCount; ++v) {
            float w0 = weightsFloatData.get();
            float w1 = weightsFloatData.get();
            float w2 = weightsFloatData.get();
            float w3 = weightsFloatData.get();
            if (w3 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 4);
            } else if (w2 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 3);
            } else if (w1 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 2);
            } else if (w0 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 1);
            }
            float sum = w0 + w1 + w2 + w3;
            if (sum == 1.0f || sum == 0.0f) continue;
            weightsFloatData.position(weightsFloatData.position() - 4);
            float sumToB = 1.0f / sum;
            weightsFloatData.put(w0 * sumToB);
            weightsFloatData.put(w1 * sumToB);
            weightsFloatData.put(w2 * sumToB);
            weightsFloatData.put(w3 * sumToB);
        }
        weightsFloatData.rewind();
        return maxWeightsPerVert;
    }

    @Override
    public String getType() {
        return "ArmatureModifierData";
    }
}

