/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.materials;

import com.jme3.material.MatParam;
import com.jme3.material.MatParamTexture;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.IAlphaMask;
import com.jme3.scene.plugins.blender.materials.MaterialContext;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.shader.VarType;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaterialHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(MaterialHelper.class.getName());
    protected static final float DEFAULT_SHININESS = 20.0f;
    public static final String TEXTURE_TYPE_3D = "Texture";
    public static final String TEXTURE_TYPE_COLOR = "ColorMap";
    public static final String TEXTURE_TYPE_DIFFUSE = "DiffuseMap";
    public static final String TEXTURE_TYPE_NORMAL = "NormalMap";
    public static final String TEXTURE_TYPE_SPECULAR = "SpecularMap";
    public static final String TEXTURE_TYPE_GLOW = "GlowMap";
    public static final String TEXTURE_TYPE_ALPHA = "AlphaMap";
    public static final Integer ALPHA_MASK_NONE = 0;
    public static final Integer ALPHA_MASK_CIRCLE = 1;
    public static final Integer ALPHA_MASK_CONE = 2;
    public static final Integer ALPHA_MASK_HYPERBOLE = 3;
    protected final Map<Integer, IAlphaMask> alphaMasks = new HashMap<Integer, IAlphaMask>();
    protected RenderState.FaceCullMode faceCullMode;

    public MaterialHelper(String blenderVersion) {
        super(blenderVersion);
        this.alphaMasks.put(ALPHA_MASK_NONE, new IAlphaMask(){

            public void setImageSize(int width, int height) {
            }

            public byte getAlpha(float x, float y) {
                return -1;
            }
        });
        this.alphaMasks.put(ALPHA_MASK_CIRCLE, new IAlphaMask(){
            private float r;
            private float[] center;

            public void setImageSize(int width, int height) {
                this.r = (float)Math.min(width, height) * 0.5f;
                this.center = new float[]{(float)width * 0.5f, (float)height * 0.5f};
            }

            public byte getAlpha(float x, float y) {
                float d = FastMath.abs(FastMath.sqrt((x - this.center[0]) * (x - this.center[0]) + (y - this.center[1]) * (y - this.center[1])));
                return (byte)(d >= this.r ? 0 : 255);
            }
        });
        this.alphaMasks.put(ALPHA_MASK_CONE, new IAlphaMask(){
            private float r;
            private float[] center;

            public void setImageSize(int width, int height) {
                this.r = (float)Math.min(width, height) * 0.5f;
                this.center = new float[]{(float)width * 0.5f, (float)height * 0.5f};
            }

            public byte getAlpha(float x, float y) {
                float d = FastMath.abs(FastMath.sqrt((x - this.center[0]) * (x - this.center[0]) + (y - this.center[1]) * (y - this.center[1])));
                return (byte)(d >= this.r ? 0.0f : -255.0f * d / this.r + 255.0f);
            }
        });
        this.alphaMasks.put(ALPHA_MASK_HYPERBOLE, new IAlphaMask(){
            private float r;
            private float[] center;

            public void setImageSize(int width, int height) {
                this.r = (float)Math.min(width, height) * 0.5f;
                this.center = new float[]{(float)width * 0.5f, (float)height * 0.5f};
            }

            public byte getAlpha(float x, float y) {
                float d = FastMath.abs(FastMath.sqrt((x - this.center[0]) * (x - this.center[0]) + (y - this.center[1]) * (y - this.center[1]))) / this.r;
                return d >= 1.0f ? (byte)0 : (byte)((-FastMath.sqrt((2.0f - d) * d) + 1.0f) * 255.0f);
            }
        });
    }

    public void setFaceCullMode(RenderState.FaceCullMode faceCullMode) {
        this.faceCullMode = faceCullMode;
    }

    public Material toMaterial(Structure structure, BlenderContext blenderContext) throws BlenderFileException {
        LOGGER.log(Level.INFO, "Loading material.");
        if (structure == null) {
            return blenderContext.getDefaultMaterial();
        }
        Material result = (Material)blenderContext.getLoadedFeature(structure.getOldMemoryAddress(), BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        if (result != null) {
            return result;
        }
        MaterialContext materialContext = new MaterialContext(structure, blenderContext);
        LOGGER.log(Level.INFO, "Material's name: {0}", materialContext.name);
        if (materialContext.textures.size() > 0) {
            LOGGER.log(Level.WARNING, "Attetion! Many textures found for material: {0}. Only the first of each supported mapping types will be used!", materialContext.name);
        }
        Texture.Type colorTextureType = null;
        HashMap<String, Texture> texturesMap = new HashMap<String, Texture>();
        TextureHelper textureHelper = (TextureHelper)blenderContext.getHelper(TextureHelper.class);
        for (Map.Entry<Number, Texture> entry : materialContext.loadedTextures.entrySet()) {
            int mapto = entry.getKey().intValue();
            Texture texture = entry.getValue();
            if ((mapto & 1) != 0) {
                colorTextureType = texture.getType();
                if (materialContext.shadeless) {
                    texturesMap.put(colorTextureType == Texture.Type.ThreeDimensional ? TEXTURE_TYPE_3D : TEXTURE_TYPE_COLOR, texture);
                } else {
                    texturesMap.put(colorTextureType == Texture.Type.ThreeDimensional ? TEXTURE_TYPE_3D : TEXTURE_TYPE_DIFFUSE, texture);
                }
            }
            if (texture.getType() != Texture.Type.TwoDimensional) continue;
            if ((mapto & 2) != 0 && !materialContext.shadeless) {
                texturesMap.put(TEXTURE_TYPE_NORMAL, texture);
            }
            if ((mapto & 0x40) != 0) {
                texturesMap.put(TEXTURE_TYPE_GLOW, texture);
            }
            if ((mapto & 4) != 0 && !materialContext.shadeless) {
                texturesMap.put(TEXTURE_TYPE_SPECULAR, texture);
            }
            if ((mapto & 0x80) == 0 || materialContext.shadeless) continue;
            texturesMap.put(TEXTURE_TYPE_ALPHA, texture);
        }
        if (colorTextureType == Texture.Type.ThreeDimensional) {
            result = new Material(blenderContext.getAssetManager(), "Common/MatDefs/Texture3D/tex3D.j3md");
        } else {
            if (materialContext.shadeless) {
                result = new Material(blenderContext.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
            } else {
                result = new Material(blenderContext.getAssetManager(), "Common/MatDefs/Light/Lighting.j3md");
                result.setBoolean("UseMaterialColors", Boolean.TRUE);
                result.setBoolean("Minnaert", materialContext.diffuseShader == DiffuseShader.MINNAERT);
                if (!materialContext.transparent) {
                    materialContext.diffuseColor.a = 1.0f;
                }
                result.setColor("Diffuse", materialContext.diffuseColor);
                result.setBoolean("WardIso", materialContext.specularShader == SpecularShader.WARDISO);
                result.setColor("Specular", materialContext.specularColor);
                result.setColor("Ambient", materialContext.ambientColor);
                result.setFloat("Shininess", materialContext.shininess);
            }
            if (materialContext.vertexColor) {
                result.setBoolean(materialContext.shadeless ? "VertexColor" : "UseVertexColor", true);
            }
        }
        for (Map.Entry<Number, Texture> entry : texturesMap.entrySet()) {
            result.setTexture((String)((Object)entry.getKey()), entry.getValue());
        }
        result.getAdditionalRenderState().setFaceCullMode(this.faceCullMode);
        if (materialContext.transparent) {
            result.setTransparent(true);
            result.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        }
        blenderContext.setMaterialContext(result, materialContext);
        blenderContext.addLoadedFeatures(structure.getOldMemoryAddress(), structure.getName(), structure, result);
        return result;
    }

    public Material getNonTexturedMaterial(Material material, int imageType) {
        String[] textureParamNames = new String[]{TEXTURE_TYPE_DIFFUSE, TEXTURE_TYPE_NORMAL, TEXTURE_TYPE_GLOW, TEXTURE_TYPE_SPECULAR, TEXTURE_TYPE_ALPHA};
        HashMap<String, Texture> textures = new HashMap<String, Texture>(textureParamNames.length);
        for (String textureParamName : textureParamNames) {
            MatParamTexture matParamTexture = material.getTextureParam(textureParamName);
            if (matParamTexture == null) continue;
            textures.put(textureParamName, matParamTexture.getTextureValue());
        }
        if (textures.isEmpty()) {
            return material;
        }
        for (Map.Entry textureParamName : textures.entrySet()) {
            String name = ((Texture)textureParamName.getValue()).getName();
            try {
                int type = Integer.parseInt(name);
                if (type != imageType) continue;
                material.clearParam((String)textureParamName.getKey());
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "The name of the texture does not contain the texture type value! {0} will not be removed!", name);
            }
        }
        Material result = material.clone();
        for (Map.Entry textureEntry : textures.entrySet()) {
            material.setTexture((String)textureEntry.getKey(), (Texture)textureEntry.getValue());
        }
        return result;
    }

    public Material getParticlesMaterial(Material material, Integer alphaMaskIndex, BlenderContext blenderContext) {
        MatParam glowColor;
        Material result = new Material(blenderContext.getAssetManager(), "Common/MatDefs/Misc/Particle.j3md");
        MatParam diffuseMap = material.getParam(TEXTURE_TYPE_DIFFUSE);
        if (diffuseMap != null) {
            Texture texture = ((Texture)diffuseMap.getValue()).clone();
            Image image = texture.getImage();
            ByteBuffer sourceBB = image.getData(0);
            sourceBB.rewind();
            int w = image.getWidth();
            int h = image.getHeight();
            ByteBuffer bb = BufferUtils.createByteBuffer(w * h * 4);
            IAlphaMask iAlphaMask = this.alphaMasks.get(alphaMaskIndex);
            iAlphaMask.setImageSize(w, h);
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    bb.put(sourceBB.get());
                    bb.put(sourceBB.get());
                    bb.put(sourceBB.get());
                    bb.put(iAlphaMask.getAlpha(x, y));
                }
            }
            image = new Image(Image.Format.RGBA8, w, h, bb);
            texture.setImage(image);
            result.setTextureParam(TEXTURE_TYPE_3D, VarType.Texture2D, texture);
        }
        if ((glowColor = material.getParam("GlowColor")) != null) {
            ColorRGBA color = (ColorRGBA)glowColor.getValue();
            result.setParam("GlowColor", VarType.Vector3, (Object)color);
        }
        return result;
    }

    public boolean hasTexture(Material material) {
        if (material != null) {
            if (material.getTextureParam(TEXTURE_TYPE_3D) != null) {
                return true;
            }
            if (material.getTextureParam(TEXTURE_TYPE_ALPHA) != null) {
                return true;
            }
            if (material.getTextureParam(TEXTURE_TYPE_COLOR) != null) {
                return true;
            }
            if (material.getTextureParam(TEXTURE_TYPE_DIFFUSE) != null) {
                return true;
            }
            if (material.getTextureParam(TEXTURE_TYPE_GLOW) != null) {
                return true;
            }
            if (material.getTextureParam(TEXTURE_TYPE_NORMAL) != null) {
                return true;
            }
            if (material.getTextureParam(TEXTURE_TYPE_SPECULAR) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean hasTexture(Material material, String textureType) {
        if (material != null) {
            return material.getTextureParam(textureType) != null;
        }
        return false;
    }

    public Material[] getMaterials(Structure structureWithMaterials, BlenderContext blenderContext) throws BlenderFileException {
        List<Structure> materialStructures;
        Pointer ppMaterials = (Pointer)structureWithMaterials.getFieldValue("mat");
        Material[] materials = null;
        if (ppMaterials.isNotNull() && (materialStructures = ppMaterials.fetchData(blenderContext.getInputStream())) != null && materialStructures.size() > 0) {
            MaterialHelper materialHelper = (MaterialHelper)blenderContext.getHelper(MaterialHelper.class);
            materials = new Material[materialStructures.size()];
            int i = 0;
            for (Structure s : materialStructures) {
                Material material = (Material)blenderContext.getLoadedFeature(s.getOldMemoryAddress(), BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
                if (material == null) {
                    material = materialHelper.toMaterial(s, blenderContext);
                }
                materials[i++] = material;
            }
        }
        return materials;
    }

    public void rgbToHsv(float r, float g, float b, float[] hsv) {
        float cmax = r;
        float cmin = r;
        cmax = g > cmax ? g : cmax;
        cmin = g < cmin ? g : cmin;
        cmax = b > cmax ? b : cmax;
        cmin = b < cmin ? b : cmin;
        hsv[2] = cmax;
        if ((double)cmax != 0.0) {
            hsv[1] = (cmax - cmin) / cmax;
        } else {
            hsv[1] = 0.0f;
            hsv[0] = 0.0f;
        }
        if ((double)hsv[1] == 0.0) {
            hsv[0] = -1.0f;
        } else {
            float cdelta = cmax - cmin;
            float rc = (cmax - r) / cdelta;
            float gc = (cmax - g) / cdelta;
            float bc = (cmax - b) / cdelta;
            hsv[0] = r == cmax ? bc - gc : (g == cmax ? 2.0f + rc - bc : 4.0f + gc - rc);
            hsv[0] = hsv[0] * 60.0f;
            if (hsv[0] < 0.0f) {
                hsv[0] = hsv[0] + 360.0f;
            }
        }
        hsv[0] = hsv[0] / 360.0f;
        if (hsv[0] < 0.0f) {
            hsv[0] = 0.0f;
        }
    }

    public void hsvToRgb(float h, float s, float v, float[] rgb) {
        h *= 360.0f;
        if ((double)s == 0.0) {
            rgb[1] = rgb[2] = v;
            rgb[0] = rgb[2];
        } else {
            h = h == 360.0f ? 0.0f : (h /= 60.0f);
            int i = (int)Math.floor(h);
            float f = h - (float)i;
            float p = v * (1.0f - s);
            float q = v * (1.0f - s * f);
            float t = v * (1.0f - s * (1.0f - f));
            switch (i) {
                case 0: {
                    rgb[0] = v;
                    rgb[1] = t;
                    rgb[2] = p;
                    break;
                }
                case 1: {
                    rgb[0] = q;
                    rgb[1] = v;
                    rgb[2] = p;
                    break;
                }
                case 2: {
                    rgb[0] = p;
                    rgb[1] = v;
                    rgb[2] = t;
                    break;
                }
                case 3: {
                    rgb[0] = p;
                    rgb[1] = q;
                    rgb[2] = v;
                    break;
                }
                case 4: {
                    rgb[0] = t;
                    rgb[1] = p;
                    rgb[2] = v;
                    break;
                }
                case 5: {
                    rgb[0] = v;
                    rgb[1] = p;
                    rgb[2] = q;
                }
            }
        }
    }

    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return (blenderContext.getBlenderKey().getFeaturesToLoad() & 3) != 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpecularShader {
        COOKTORRENCE,
        PHONG,
        BLINN,
        TOON,
        WARDISO;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiffuseShader {
        LAMBERT,
        ORENNAYAR,
        TOON,
        MINNAERT,
        FRESNEL;

    }
}

