/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Animation;
import com.jme3.animation.BoneTrack;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.ConstraintType;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;

class ConstraintSizeLimit
extends Constraint {
    private static final int LIMIT_XMIN = 1;
    private static final int LIMIT_XMAX = 2;
    private static final int LIMIT_YMIN = 4;
    private static final int LIMIT_YMAX = 8;
    private static final int LIMIT_ZMIN = 16;
    private static final int LIMIT_ZMAX = 32;

    public ConstraintSizeLimit(Structure constraintStructure, Long boneOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        super(constraintStructure, boneOMA, influenceIpo, blenderContext);
    }

    public void affectAnimation(Animation animation, int targetIndex) {
        BoneTrack track = (BoneTrack)this.getTrack(animation, targetIndex);
        if (track != null) {
            int flag = ((Number)this.data.getFieldValue("flag")).intValue();
            Vector3f[] scales = track.getScales();
            int maxFrames = scales.length;
            for (int frame = 0; frame < maxFrames; ++frame) {
                float zmax;
                float zmin;
                float ymax;
                float ymin;
                float xmax;
                float xmin;
                float influence = this.ipo.calculateValue(frame);
                if ((flag & 1) != 0 && scales[frame].x < (xmin = ((Number)this.data.getFieldValue("xmin")).floatValue())) {
                    scales[frame].x -= (scales[frame].x - xmin) * influence;
                }
                if ((flag & 2) != 0 && scales[frame].x > (xmax = ((Number)this.data.getFieldValue("xmax")).floatValue())) {
                    scales[frame].x -= (scales[frame].x - xmax) * influence;
                }
                if ((flag & 4) != 0 && scales[frame].y < (ymin = ((Number)this.data.getFieldValue("ymin")).floatValue())) {
                    scales[frame].y -= (scales[frame].y - ymin) * influence;
                }
                if ((flag & 8) != 0 && scales[frame].y > (ymax = ((Number)this.data.getFieldValue("ymax")).floatValue())) {
                    scales[frame].y -= (scales[frame].y - ymax) * influence;
                }
                if ((flag & 0x10) != 0 && scales[frame].z < (zmin = ((Number)this.data.getFieldValue("zmin")).floatValue())) {
                    scales[frame].z -= (scales[frame].z - zmin) * influence;
                }
                if ((flag & 0x20) == 0 || !(scales[frame].z > (zmax = ((Number)this.data.getFieldValue("zmax")).floatValue()))) continue;
                scales[frame].z -= (scales[frame].z - zmax) * influence;
            }
            track.setKeyframes(track.getTimes(), track.getTranslations(), track.getRotations(), scales);
        }
    }

    public ConstraintType getType() {
        return ConstraintType.CONSTRAINT_TYPE_SIZELIMIT;
    }
}

