/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.animations.IpoHelper;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.ConstraintFactory;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ConstraintHelper.class.getName());

    public ConstraintHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion);
    }

    public Map<Long, List<Constraint>> loadConstraints(Structure objectStructure, BlenderContext blenderContext) throws BlenderFileException {
        if (this.blenderVersion >= 250) {
            LOGGER.warning("Loading of constraints not yet implemented for version 2.5x !");
            return new HashMap<Long, List<Constraint>>(0);
        }
        IpoHelper ipoHelper = (IpoHelper)blenderContext.getHelper(IpoHelper.class);
        HashMap constraintsIpos = new HashMap();
        Pointer pActions = (Pointer)objectStructure.getFieldValue("action");
        if (pActions.isNotNull()) {
            List<Structure> actions = pActions.fetchData(blenderContext.getInputStream());
            for (Structure action : actions) {
                Structure chanbase = (Structure)action.getFieldValue("chanbase");
                List<Structure> actionChannels = chanbase.evaluateListBase(blenderContext);
                for (Structure actionChannel : actionChannels) {
                    HashMap<String, Ipo> ipos = new HashMap<String, Ipo>();
                    Structure constChannels = (Structure)actionChannel.getFieldValue("constraintChannels");
                    List<Structure> constraintChannels = constChannels.evaluateListBase(blenderContext);
                    for (Structure constraintChannel : constraintChannels) {
                        Pointer pIpo = (Pointer)constraintChannel.getFieldValue("ipo");
                        if (!pIpo.isNotNull()) continue;
                        String constraintName = constraintChannel.getFieldValue("name").toString();
                        Ipo ipo = ipoHelper.createIpo(pIpo.fetchData(blenderContext.getInputStream()).get(0), blenderContext);
                        ipos.put(constraintName, ipo);
                    }
                    String actionName = actionChannel.getFieldValue("name").toString();
                    constraintsIpos.put(actionName, ipos);
                }
            }
        }
        HashMap<Long, List<Constraint>> result = new HashMap<Long, List<Constraint>>();
        Pointer pPose = (Pointer)objectStructure.getFieldValue("pose");
        if (pPose.isNotNull()) {
            List<Structure> poseChannels = ((Structure)pPose.fetchData(blenderContext.getInputStream()).get(0).getFieldValue("chanbase")).evaluateListBase(blenderContext);
            for (Structure poseChannel : poseChannels) {
                ArrayList<Constraint> constraintsList = new ArrayList<Constraint>();
                Long boneOMA = ((Pointer)poseChannel.getFieldValue("bone")).getOldMemoryAddress();
                String name = blenderContext.getFileBlock(boneOMA).getStructure(blenderContext).getFieldValue("name").toString();
                List<Structure> constraints = ((Structure)poseChannel.getFieldValue("constraints")).evaluateListBase(blenderContext);
                for (Structure constraint : constraints) {
                    Ipo ipo;
                    String constraintName = constraint.getFieldValue("name").toString();
                    Map ipoMap = (Map)constraintsIpos.get(name);
                    Ipo ipo2 = ipo = ipoMap == null ? null : (Ipo)ipoMap.get(constraintName);
                    if (ipo == null) {
                        float enforce = ((Number)constraint.getFieldValue("enforce")).floatValue();
                        ipo = ipoHelper.createIpo(enforce);
                    }
                    constraintsList.add(ConstraintFactory.createConstraint(constraint, boneOMA, ipo, blenderContext));
                }
                result.put(boneOMA, constraintsList);
                blenderContext.addConstraints(boneOMA, constraintsList);
            }
        }
        List<Structure> constraintChannels = ((Structure)objectStructure.getFieldValue("constraintChannels")).evaluateListBase(blenderContext);
        for (Structure constraintChannel : constraintChannels) {
            System.out.println(constraintChannel);
        }
        if (!result.containsKey(objectStructure.getOldMemoryAddress())) {
            List<Structure> constraints = ((Structure)objectStructure.getFieldValue("constraints")).evaluateListBase(blenderContext);
            ArrayList<Constraint> constraintsList = new ArrayList<Constraint>(constraints.size());
            for (Structure constraint : constraints) {
                Ipo ipo;
                String constraintName = constraint.getFieldValue("name").toString();
                String objectName = objectStructure.getName();
                Map objectConstraintsIpos = (Map)constraintsIpos.get(objectName);
                Ipo ipo3 = ipo = objectConstraintsIpos != null ? (Ipo)objectConstraintsIpos.get(constraintName) : null;
                if (ipo == null) {
                    float enforce = ((Number)constraint.getFieldValue("enforce")).floatValue();
                    ipo = ipoHelper.createIpo(enforce);
                }
                constraintsList.add(ConstraintFactory.createConstraint(constraint, null, ipo, blenderContext));
            }
            result.put(objectStructure.getOldMemoryAddress(), constraintsList);
            blenderContext.addConstraints(objectStructure.getOldMemoryAddress(), constraintsList);
        }
        return result;
    }

    @Override
    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return true;
    }
}

