/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.BlenderKey;
import com.jme3.light.Light;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderLoader;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlenderModelLoader
extends BlenderLoader {
    private static final Logger LOGGER = Logger.getLogger(BlenderModelLoader.class.getName());

    public Spatial load(AssetInfo assetInfo) throws IOException {
        try {
            this.setup(assetInfo);
            BlenderKey blenderKey = this.blenderContext.getBlenderKey();
            Node modelRoot = new Node(blenderKey.getName());
            for (FileBlockHeader block : this.blocks) {
                if (block.getCode() != 1329725440) continue;
                Object object = this.toObject(block.getStructure(this.blenderContext));
                if (object instanceof Node) {
                    LOGGER.log(Level.INFO, "{0}: {1}--> {2}", new Object[]{((Node)object).getName(), ((Node)object).getLocalTranslation().toString(), ((Node)object).getParent() == null ? "null" : ((Node)object).getParent().getName()});
                    if (((Node)object).getParent() != null) continue;
                    modelRoot.attachChild((Node)object);
                    continue;
                }
                if (!(object instanceof Light)) continue;
                modelRoot.addLight((Light)object);
            }
            this.blenderContext.dispose();
            return modelRoot;
        }
        catch (BlenderFileException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }
}

