/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender;

import com.jme3.asset.AssetLoader;
import com.jme3.asset.BlenderKey;
import com.jme3.light.AmbientLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.Camera;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.cameras.CameraHelper;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.lights.LightHelper;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.meshes.MeshHelper;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBlenderLoader
implements AssetLoader {
    private static final Logger LOGGER = Logger.getLogger(AbstractBlenderLoader.class.getName());
    protected BlenderContext blenderContext;

    AbstractBlenderLoader() {
    }

    public Node toScene(Structure structure) {
        if ((this.blenderContext.getBlenderKey().getFeaturesToLoad() & 0xFFFF) == 0) {
            return null;
        }
        Node result = new Node(structure.getName());
        try {
            List<Structure> base = ((Structure)structure.getFieldValue("base")).evaluateListBase(this.blenderContext);
            for (Structure b : base) {
                Pointer pObject = (Pointer)b.getFieldValue("object");
                if (!pObject.isNotNull()) continue;
                Structure objectStructure = pObject.fetchData(this.blenderContext.getInputStream()).get(0);
                Object object = this.toObject(objectStructure);
                if (object instanceof Spatial && ((Spatial)object).getParent() == null) {
                    result.attachChild((Spatial)object);
                    continue;
                }
                if (!(object instanceof Light)) continue;
                result.addLight((Light)object);
            }
        }
        catch (BlenderFileException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return result;
    }

    public Camera toCamera(Structure structure) throws BlenderFileException {
        CameraHelper cameraHelper = (CameraHelper)this.blenderContext.getHelper(CameraHelper.class);
        if (cameraHelper.shouldBeLoaded(structure, this.blenderContext)) {
            return cameraHelper.toCamera(structure);
        }
        return null;
    }

    public Light toLight(Structure structure) throws BlenderFileException {
        LightHelper lightHelper = (LightHelper)this.blenderContext.getHelper(LightHelper.class);
        if (lightHelper.shouldBeLoaded(structure, this.blenderContext)) {
            return lightHelper.toLight(structure, this.blenderContext);
        }
        return null;
    }

    public Object toObject(Structure structure) throws BlenderFileException {
        ObjectHelper objectHelper = (ObjectHelper)this.blenderContext.getHelper(ObjectHelper.class);
        if (objectHelper.shouldBeLoaded(structure, this.blenderContext)) {
            return objectHelper.toObject(structure, this.blenderContext);
        }
        return null;
    }

    public List<Geometry> toMesh(Structure structure) throws BlenderFileException {
        MeshHelper meshHelper = (MeshHelper)this.blenderContext.getHelper(MeshHelper.class);
        if (meshHelper.shouldBeLoaded(structure, this.blenderContext)) {
            return meshHelper.toMesh(structure, this.blenderContext);
        }
        return null;
    }

    public Material toMaterial(Structure structure) throws BlenderFileException {
        MaterialHelper materialHelper = (MaterialHelper)this.blenderContext.getHelper(MaterialHelper.class);
        if (materialHelper.shouldBeLoaded(structure, this.blenderContext)) {
            return materialHelper.toMaterial(structure, this.blenderContext);
        }
        return null;
    }

    public BlenderKey.WorldData toWorldData(Structure structure) {
        BlenderKey.WorldData result = new BlenderKey.WorldData();
        AmbientLight ambientLight = new AmbientLight();
        float ambr = ((Number)structure.getFieldValue("ambr")).floatValue();
        float ambg = ((Number)structure.getFieldValue("ambg")).floatValue();
        float ambb = ((Number)structure.getFieldValue("ambb")).floatValue();
        ambientLight.setColor(new ColorRGBA(ambr, ambg, ambb, 0.0f));
        result.setAmbientLight(ambientLight);
        return result;
    }
}

