/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.niftygui;

import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.niftygui.NiftyJmeDisplay;
import de.lessvoid.nifty.spi.render.RenderFont;

public class RenderFontJme
implements RenderFont {
    private NiftyJmeDisplay display;
    private BitmapFont font;
    private BitmapText text;
    private float actualSize;

    public RenderFontJme(String name, NiftyJmeDisplay display) {
        this.display = display;
        this.font = display.getAssetManager().loadFont(name);
        if (this.font == null) {
            throw new RuntimeException("Font not loaded:" + name);
        }
        this.text = new BitmapText(this.font);
        this.actualSize = this.font.getPreferredSize();
        this.text.setSize(this.actualSize);
    }

    public BitmapText createText() {
        return new BitmapText(this.font);
    }

    public BitmapText getText() {
        return this.text;
    }

    public int getHeight() {
        return (int)this.text.getLineHeight();
    }

    public int getWidth(String str) {
        if (str.length() == 0) {
            return 0;
        }
        int result = (int)this.font.getLineWidth(str);
        return result;
    }

    public int getCharacterAdvance(char currentCharacter, char nextCharacter, float size) {
        return Math.round(this.font.getCharacterAdvance(currentCharacter, nextCharacter, size));
    }

    public void dispose() {
    }
}

