/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic;

import com.jme3.asset.AssetManager;
import com.jme3.cinematic.MotionPathListener;
import com.jme3.cinematic.events.MotionTrack;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Spline;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Curve;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MotionPath
implements Savable {
    private Node debugNode;
    private AssetManager assetManager;
    private List<MotionPathListener> listeners;
    private Spline spline = new Spline();
    private float eps = 1.0E-4f;

    public void interpolatePath(float tpf, MotionTrack control) {
        TempVars vars = TempVars.get();
        Vector3f temp = vars.vect1;
        Vector3f tmpVector = vars.vect2;
        switch (this.spline.getType()) {
            case CatmullRom: {
                float val = tpf * (this.spline.getTotalLength() / control.getDuration());
                control.setCurrentValue(control.getCurrentValue() + this.eps);
                this.spline.interpolate(control.getCurrentValue(), control.getCurrentWayPoint(), temp);
                float dist = this.getDist(control, temp, tmpVector);
                while (dist < val) {
                    control.setCurrentValue(control.getCurrentValue() + this.eps);
                    this.spline.interpolate(control.getCurrentValue(), control.getCurrentWayPoint(), temp);
                    dist = this.getDist(control, temp, tmpVector);
                }
                if (!control.needsDirection()) break;
                tmpVector.set(temp);
                control.setDirection(tmpVector.subtractLocal(control.getSpatial().getLocalTranslation()).normalizeLocal());
                break;
            }
            case Linear: {
                float val = control.getDuration() * this.spline.getSegmentsLength().get(control.getCurrentWayPoint()).floatValue() / this.spline.getTotalLength();
                control.setCurrentValue(Math.min(control.getCurrentValue() + tpf / val, 1.0f));
                this.spline.interpolate(control.getCurrentValue(), control.getCurrentWayPoint(), temp);
                if (!control.needsDirection()) break;
                tmpVector.set(this.spline.getControlPoints().get(control.getCurrentWayPoint() + 1));
                control.setDirection(tmpVector.subtractLocal(this.spline.getControlPoints().get(control.getCurrentWayPoint())).normalizeLocal());
                break;
            }
        }
        control.getSpatial().setLocalTranslation(temp);
        vars.release();
    }

    private float getDist(MotionTrack control, Vector3f temp, Vector3f tmpVector) {
        tmpVector.set(temp);
        return tmpVector.subtractLocal(control.getSpatial().getLocalTranslation()).length();
    }

    private void attachDebugNode(Node root) {
        if (this.debugNode == null) {
            this.debugNode = new Node();
            Material m = this.assetManager.loadMaterial("Common/Materials/RedColor.j3m");
            for (Vector3f cp : this.spline.getControlPoints()) {
                Geometry geo = new Geometry("box", new Box(cp, 0.3f, 0.3f, 0.3f));
                geo.setMaterial(m);
                this.debugNode.attachChild(geo);
            }
            switch (this.spline.getType()) {
                case CatmullRom: {
                    this.debugNode.attachChild(this.CreateCatmullRomPath());
                    break;
                }
                case Linear: {
                    this.debugNode.attachChild(this.CreateLinearPath());
                    break;
                }
                default: {
                    this.debugNode.attachChild(this.CreateLinearPath());
                }
            }
            root.attachChild(this.debugNode);
        }
    }

    private Geometry CreateLinearPath() {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", ColorRGBA.Blue);
        Geometry lineGeometry = new Geometry("line", new Curve(this.spline, 0));
        lineGeometry.setMaterial(mat);
        return lineGeometry;
    }

    private Geometry CreateCatmullRomPath() {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", ColorRGBA.Blue);
        Geometry lineGeometry = new Geometry("line", new Curve(this.spline, 10));
        lineGeometry.setMaterial(mat);
        return lineGeometry;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.spline, "spline", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule in = im.getCapsule(this);
        this.spline = (Spline)in.readSavable("spline", null);
    }

    public void addWayPoint(Vector3f wayPoint) {
        this.spline.addControlPoint(wayPoint);
    }

    public float getLength() {
        return this.spline.getTotalLength();
    }

    public Vector3f getWayPoint(int i) {
        return this.spline.getControlPoints().get(i);
    }

    public void removeWayPoint(Vector3f wayPoint) {
        this.spline.removeControlPoint(wayPoint);
    }

    public void removeWayPoint(int i) {
        this.removeWayPoint(this.spline.getControlPoints().get(i));
    }

    public Iterator<Vector3f> iterator() {
        return this.spline.getControlPoints().iterator();
    }

    public Spline.SplineType getPathSplineType() {
        return this.spline.getType();
    }

    public void setPathSplineType(Spline.SplineType pathSplineType) {
        this.spline.setType(pathSplineType);
        if (this.debugNode != null) {
            Node parent = this.debugNode.getParent();
            this.debugNode.removeFromParent();
            this.debugNode.detachAllChildren();
            this.debugNode = null;
            this.attachDebugNode(parent);
        }
    }

    public void disableDebugShape() {
        this.debugNode.detachAllChildren();
        this.debugNode = null;
        this.assetManager = null;
    }

    public void enableDebugShape(AssetManager manager, Node rootNode) {
        this.assetManager = manager;
        this.attachDebugNode(rootNode);
    }

    public void addListener(MotionPathListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<MotionPathListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(MotionPathListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public int getNbWayPoints() {
        return this.spline.getControlPoints().size();
    }

    public void triggerWayPointReach(int wayPointIndex, MotionTrack control) {
        if (this.listeners != null) {
            for (MotionPathListener listener : this.listeners) {
                listener.onWayPointReach(control, wayPointIndex);
            }
        }
    }

    public float getCurveTension() {
        return this.spline.getCurveTension();
    }

    public void setCurveTension(float curveTension) {
        this.spline.setCurveTension(curveTension);
        if (this.debugNode != null) {
            Node parent = this.debugNode.getParent();
            this.debugNode.removeFromParent();
            this.debugNode.detachAllChildren();
            this.debugNode = null;
            this.attachDebugNode(parent);
        }
    }

    public void clearWayPoints() {
        this.spline.clearControlPoints();
    }

    public void setCycle(boolean cycle) {
        this.spline.setCycle(cycle);
        if (this.debugNode != null) {
            Node parent = this.debugNode.getParent();
            this.debugNode.removeFromParent();
            this.debugNode.detachAllChildren();
            this.debugNode = null;
            this.attachDebugNode(parent);
        }
    }

    public boolean isCycle() {
        return this.spline.isCycle();
    }
}

