/*
Midbar
Distributed under the MIT License
© Copyright Maxim Bortnikov 2023
For more information please visit
https://sourceforge.net/projects/midbar/
https://osdn.net/projects/midbar/
https://github.com/Northstrix/Midbar
Required libraries:
https://github.com/zhouyangchao/AES
https://github.com/peterferrie/serpent
https://github.com/ddokkaebi/Blowfish
https://github.com/Northstrix/DES_and_3DES_Library_for_MCUs
https://github.com/ulwanski/sha512
https://github.com/Bodmer/TFT_eSPI
https://github.com/intrbiz/arduino-crypto
https://github.com/GyverLibs/EncButton
https://github.com/techpaul/PS2KeyAdvanced
https://github.com/techpaul/PS2KeyMap
https://github.com/adafruit/SdFat
*/
// Photo is taken from: https://unsplash.com/photos/NflJmUuaYVI
#include <TFT_eSPI.h> // Hardware-specific library
#include <SPI.h>

TFT_eSPI tft = TFT_eSPI();       // Invoke custom library
TFT_eSprite mvng_bc = TFT_eSprite(&tft);

const uint16_t Denver PROGMEM [320][241] = {
{46877,48989,48989,48989,51069,51069,51069,40506,36248,46811,51036,40441,40409,38329,38328,36183,38264,40344,40344,40344,40344,42424,42424,42424,42424,42424,42424,42424,44504,44536,46584,48664,48664,48664,48664,34005,27667,33907,29779,44277,44308,19313,15087,13007,12974,12974,10861,10828,10828,8748,21360,21360,12908,6569,12875,19149,17036,19116,17101,19149,23376,25618,25651,14956,14956,19214,12875,10795,12908,21328,25586,19214,12907,12972,19212,29713,38199,36085,33939,27600,27600,27600,25519,25552,25520,25488,17166,4454,4487,36150,44537,42391,31825,38197,38197,33874,27535,29810,34003,27665,33939,33939,33907,33939,33939,33940,33908,33939,33972,21327,21258,21162,8485,21130,14824,19212,25421,25487,29712,23439,31794,27632,29713,25488,19084,23309,29680,27632,21261,19246,23504,23505,21326,21294,19083,19182,31957,12778,21002,18823,25325,18953,25227,20807,18955,166,10763,31794,38230,21394,21392,19279,17199,15119,25487,40211,44437,40179,35921,42324,38066,12841,14954,38066,44404,31468,29257,31305,22919,35822,44371,31402,29127,29127,29127,29127,31207,29159,29127,29127,31175,29126,29127,29223,31369,31304,31369,33938,35953,27079,31468,27308,33678,40049,29191,33514,41999,33547,37837,40112,46550,46583,44471,36020,27630,29710,42292,38066,23277,14792,23374,44601,48860,40377,27503,21257,4684,4489,6532,10724,6531,6499,4418,10756,8643,2337,224,4385,224,128,64,129,0,0,0,32,128,96,0,0,255},
{44796,48990,48990,51070,51070,51070,51069,44732,36249,46812,51037,42554,40409,38361,38296,36183,36216,38296,40344,40344,42392,42424,42424,42424,42424,42424,42424,42424,44504,44504,46584,48664,48664,48664,50744,38165,29715,29747,27699,46357,42196,17201,13007,12974,12974,12974,10860,12909,8748,10796,21360,23441,12908,14956,31793,27600,27567,25487,23374,21229,25553,23506,25619,23408,23473,23440,17134,17069,15021,23473,27731,15020,10663,8681,12807,29746,38231,36085,31858,27600,27600,27600,25519,25552,25520,25552,15085,4487,261,29811,48763,38198,25455,29680,25454,29452,31597,21260,33971,31826,31859,21358,25552,33940,33939,33940,33939,33939,33940,19150,21196,17035,14695,12679,21033,10663,25323,17035,27501,12711,33807,19050,23373,25356,31662,35921,31727,21260,25487,17132,23439,21358,19310,19310,19213,27699,27667,12810,21001,18791,16840,16807,23081,37839,19051,133,19149,33906,34069,38331,38200,21328,12908,10763,31793,42324,46517,46517,46549,46517,38066,25357,27502,38098,35985,40179,33873,31662,31631,44339,40113,29192,29127,29159,31208,31207,31240,29159,31207,29159,31207,31207,31207,29127,29126,29126,29159,29191,31272,29127,31564,33840,40178,35888,29584,29388,35920,44145,35692,37902,46484,48663,44503,40277,8584,14856,42323,38098,35920,29646,34003,46714,48828,46682,42490,31761,25517,8846,296,2276,6469,8615,12873,8678,4451,2305,192,2273,128,2275,128,32,64,0,0,0,32,32,0,0,255},
{44764,48990,49022,51070,51070,51102,51102,46876,36281,46779,53085,46714,40409,38361,36248,36184,36216,38296,40344,40344,42424,42424,42424,42424,42424,42424,42424,42424,44504,44536,46584,48664,48664,50712,46583,38133,31827,27699,29747,48437,40116,15120,13007,13007,10894,12974,10860,12973,8748,10828,21393,19247,10828,17133,29712,23374,27567,25454,23374,23374,33940,25619,27699,21392,21425,21393,21392,23441,21360,27699,23538,12874,10695,12744,10694,33971,38231,38165,29777,27567,27568,25519,25519,23439,25519,25552,10793,2374,2310,21359,48763,33939,33906,38132,35889,31629,33677,16970,31891,36052,29746,2343,19181,33972,33939,33939,33939,33939,31859,21230,35921,8615,16872,8356,25193,10599,23276,14825,17002,23178,23308,25259,8551,33742,17033,38098,35985,38001,23308,25454,21294,6503,12809,10860,15021,29844,21295,16938,20936,16711,16775,18920,20968,35854,33776,8552,25455,38099,15020,36216,46781,29813,12843,19149,38099,44437,46550,48598,46517,46517,44404,48598,44372,40179,40146,42357,19181,6567,31791,46484,44340,33549,29095,29159,31240,31240,31240,31207,31207,31207,31207,31207,31207,31207,29159,29159,29159,29127,29126,29126,29094,31401,40146,29386,31628,33678,40146,48532,33514,35626,39916,44371,44471,31826,165,31727,42324,38066,31726,29712,40376,48827,48828,46747,46747,40279,29479,25449,6730,2343,4357,19148,29713,17035,4420,2306,2306,2307,4388,6469,129,128,193,2210,2177,0,2209,0,0,32,255},
{46877,49022,49022,51102,51102,51102,51102,46876,36281,46812,53117,50843,42489,40441,36216,36184,38264,40344,40344,40344,42424,42424,42424,42456,42456,42424,42424,42424,44504,46584,46584,48664,50744,48664,38100,35988,33908,27667,29747,50517,35988,15120,15055,12974,15087,21296,10861,12973,10828,10828,23473,19215,12973,19246,31793,25486,31760,29648,27567,25487,36084,29877,27732,19247,21328,19247,19247,19247,17102,21425,21393,27568,21228,19148,14922,19342,29843,38198,29713,25519,31793,36020,33939,31858,27600,12938,4486,261,261,12938,46682,31859,25487,29713,31727,23276,23243,12777,21358,36084,27633,6472,25455,36020,36052,36052,36020,36052,31794,21229,40081,14825,10566,12420,16807,18985,14922,23179,8584,33743,16937,31695,14792,33840,16872,23373,19083,31759,19050,29648,25390,12712,14825,12810,17004,15021,10762,21098,20903,27372,21034,21033,20871,18790,46419,27470,29681,38099,25391,34134,40443,21459,10795,23375,40212,44404,29775,33969,46517,40211,27630,31888,38098,40179,44372,44469,31728,21163,33840,42291,44437,42163,37775,35597,33386,31273,31240,31208,31208,31208,31240,31240,31239,31207,31207,31239,31207,31207,29159,29159,29126,35790,37968,24966,27046,35889,44471,33807,27079,29095,29126,31531,42422,17003,8518,40243,40243,38065,31693,36083,50941,50940,48860,46714,48860,29616,12545,20995,18915,18981,14823,29745,29745,14922,8615,6469,4421,8582,6501,2274,128,160,193,4418,8610,2272,8610,2272,0,0,255},
{48990,49022,49022,51102,51102,51102,51102,48925,38426,46812,53117,52922,42522,40442,36184,36184,38296,40344,40344,40344,40376,42424,42424,42456,42456,42424,42424,42456,44504,46584,46584,48664,50744,48664,33940,35988,31827,27667,31827,50517,33908,15120,15087,12974,17167,19215,12909,12941,10893,15022,29811,25586,15118,21359,33906,27567,29712,29712,27567,25487,29811,31957,25619,19247,21328,19247,19247,19247,17134,29812,27699,27698,23505,25618,17133,325,19180,38165,29713,27600,33874,44438,36018,31825,27599,6566,2309,229,164,6598,29711,31597,31630,33743,27437,21164,21098,23081,12777,17067,19083,23244,23438,36053,36052,36052,38100,38165,27601,27470,40081,29582,6438,20903,6405,23243,12777,25421,14858,27566,23210,25421,27404,23308,29582,14889,27502,21227,27470,21261,31728,21066,16905,12745,19148,14923,14890,21033,18823,18920,16840,23113,18758,16710,35952,50678,35954,33840,38099,23472,23602,17200,23343,35954,40178,42259,21196,23308,46517,31760,14857,10728,31792,40179,44404,29679,27598,29678,42258,46517,40276,40276,46517,46518,46485,46356,42065,37807,35596,33386,31272,31240,31207,31207,31240,31240,31207,31207,31239,31207,31240,40114,33613,27079,29192,40180,42423,33612,29257,16873,25129,31630,38164,4325,23308,44404,40211,33839,29646,46714,53021,46714,48828,48827,48795,14792,8419,4193,2113,12742,19146,21325,12905,6533,4421,4421,163,131,2210,4418,128,160,2337,10722,8673,6496,10722,4449,4353,64,255},
{48990,49022,49022,51102,51102,51102,51102,48957,40506,46844,55165,50842,42554,40442,34103,36184,38296,40344,40344,42392,42424,42424,42424,42456,42456,42424,42424,42456,44504,46584,46616,50744,50744,46583,33939,33908,33940,27699,33908,52565,33875,15120,17168,13006,12974,12941,12941,12941,15054,19247,33972,29812,12973,19247,31858,31792,31792,31792,29712,29680,27665,27731,25618,23473,25521,23441,21360,19248,17167,36085,27666,23441,15054,10828,10827,2374,14987,38197,33874,38067,35986,42357,35986,29680,27599,10728,8616,2310,2277,8581,23211,25226,23016,25096,27111,27176,20967,10597,6502,10696,10629,12742,8711,17262,15116,19342,25616,25616,21295,31695,40081,38001,14858,18985,21099,25421,14792,17002,25323,21195,33710,16937,35856,16937,33840,14825,23341,23211,31728,23276,42228,42130,33776,23212,21163,23179,12712,18888,18791,18888,21001,23081,18694,21001,29647,40179,35953,33873,40178,35955,10730,15020,44405,42259,44307,48564,48500,46419,46452,42226,40081,31695,38099,40211,42260,17003,6503,21260,44404,46517,36019,31858,40244,48598,27663,36017,48630,48598,46518,46453,44243,39985,37774,35532,33386,31240,31240,31207,31240,31207,33515,42227,31565,21162,29517,42358,38066,31370,29224,25128,27306,38099,25454,2179,36018,42324,38098,33839,27632,42520,38230,34002,50940,53053,38133,6371,10532,1,14987,17164,8744,6631,4453,2340,2308,2340,6499,8611,6530,12931,8673,6561,8674,8674,4481,6529,6529,6530,8609,4352,255},
{49022,49022,49054,51102,51102,51102,51102,48957,42619,51005,55165,48762,42554,40409,34103,34103,40376,40376,40344,42424,42424,42424,42424,42456,42456,42424,42424,44504,44504,46584,48664,50744,50744,46519,33907,35988,38068,29779,38036,52597,31827,13040,15087,13006,12974,10893,10860,15054,17134,19247,29811,25586,10860,15053,25553,12939,15020,15020,19246,15085,15020,12908,19280,23473,19344,19344,21425,21425,23505,40278,27698,21360,10860,21360,17069,8648,4455,12971,29713,36018,31793,42324,38132,29680,27567,14954,8616,4390,4485,6501,17099,31630,33547,37675,39755,37674,31434,21032,6404,164,6500,6597,261,228,2373,6597,6630,4550,14891,37968,40113,40081,25389,10696,29614,21228,23178,10664,31662,21098,33840,18985,29646,25259,19147,25356,10696,29582,23308,33841,50810,48565,46484,46453,21130,37838,25259,18888,35532,20904,25129,29225,20742,21066,21227,31760,35921,33873,33872,29746,23375,14988,36019,33872,42324,44437,46517,48630,48565,44371,48564,46419,40179,42259,46550,42260,27535,33807,44404,44405,46518,46550,46517,48598,33841,35954,48630,40244,33972,44437,48598,44469,46550,48566,46453,44243,39952,35630,33419,31273,37903,40081,23210,17034,33938,44471,37936,29192,29159,29095,29354,40278,14859,14857,44436,40211,36017,29646,38230,42521,29843,25616,50940,53021,23276,8451,12644,6338,17130,8745,4486,8647,228,2276,2307,12868,15043,17123,12898,15042,12866,10786,10754,10818,6561,8673,8642,6497,6496,6497,255},
{49022,49023,49055,51102,51102,51102,53150,48925,42619,51069,55132,48762,40474,40409,34071,34103,40376,40376,40344,42424,42424,42424,42424,42456,42456,42424,42424,44504,44504,46584,48632,50744,50776,42358,33907,33907,38068,31860,42196,52597,29715,13007,15087,15054,12974,12941,10861,12941,10860,19280,25586,23473,10827,15054,23505,10795,10795,8715,10828,6634,8715,4522,10763,14989,4488,8747,8780,6633,12875,38133,29811,19248,167,17134,8745,6600,2342,230,29713,38099,29648,36051,42325,35986,33906,29680,19116,8616,8647,4421,4422,10762,21098,31499,41868,35562,27241,23048,23081,12646,8516,8645,228,196,228,4453,6565,4453,17003,40081,31727,35887,35921,6503,19018,2181,21130,12679,25421,25259,19180,29517,19115,33775,10630,31727,10631,27567,19050,35953,57215,50744,48499,50613,33710,29386,48012,41641,50417,29290,25258,46160,20935,35759,23179,27436,35823,25388,38100,31794,40213,21262,42259,40146,33937,29744,19308,23502,33937,35985,40243,48597,42259,35822,40112,40113,23309,40179,44436,38099,33972,40277,48630,44437,46550,48631,48630,46550,44406,46550,44437,31891,38132,48630,38130,38162,48630,48631,48566,44276,40179,33547,31272,29322,42292,48697,35661,29257,21000,22983,33808,38132,35986,40244,42324,38098,35985,23342,40342,40376,21327,29810,53053,44537,10533,14725,8387,8419,8517,10859,4519,2341,6502,4389,6531,17092,15011,15010,12866,10785,10786,4480,4480,10786,12898,10786,6561,224,8577,8577,255},
{49023,49023,51103,51103,51102,51102,53150,46877,42619,53117,55132,48795,42522,40409,34071,34071,38296,40344,40344,42424,42424,42424,42424,42456,42456,42424,42456,44504,44504,46584,48664,50744,50776,40245,31859,33907,33908,33908,44277,52597,25554,15055,15087,15087,12974,12973,10861,12941,12909,19247,21360,19247,8715,17167,19247,12908,12940,12940,10860,10828,10860,4490,10796,14989,12908,10828,17200,8683,4424,29746,27731,21328,12812,15053,6567,4422,27502,35922,33906,36051,36019,25520,25585,27698,29811,27731,27634,23408,10759,227,4455,6635,4523,6603,14890,31466,39755,37675,29322,21000,10693,6564,227,196,164,164,6597,6534,23244,40114,23374,29581,40113,14922,14824,6374,10729,21066,14955,29550,6470,31695,10631,27566,16904,21260,25356,14954,27470,35955,59294,52956,48500,46419,44274,21000,43720,52009,52009,43559,31141,50091,31272,29451,39691,35595,44177,18952,31694,38000,46484,31695,42259,40179,25486,27664,10759,8678,27599,21260,17066,35985,38001,29192,31370,27144,27308,46452,44404,44405,42357,44405,48598,31793,31793,46550,44469,38163,46517,50711,50711,48631,48598,50711,33842,29680,48630,40244,31889,40244,40146,29257,31273,33647,46517,42260,31305,29419,8616,19180,40278,27535,12774,42324,40211,38066,29679,21294,48763,34037,15085,36149,53086,31761,6371,10565,4226,10564,14758,29713,19214,2342,4421,6501,15013,21349,12898,8673,8673,10754,6594,2368,8706,10753,12899,4417,2337,2305,8578,6497,255},
{49023,49023,51103,51103,51102,51102,53182,46812,42587,53117,53085,48827,42522,40377,34071,34071,38296,40344,40344,42392,42424,42424,42424,42456,42456,42424,42456,44504,44504,46584,48664,50744,50744,38133,31827,33908,33908,35988,46325,52565,23473,15055,17168,15054,12974,12941,10861,15022,10860,15054,19247,17101,8714,10860,15053,14988,17101,14989,12908,10828,10828,2442,14989,19182,25456,10860,15086,10796,4392,25521,25618,21360,17134,10826,6534,10663,33905,50776,33939,17101,17101,21295,19182,12908,14988,15021,17134,14988,12875,6470,4488,6635,6603,6603,6570,6570,14760,37610,31402,21095,10692,4451,227,131,99,99,4421,6470,27470,42162,25455,29614,40113,29615,6406,16841,10633,25291,10697,27567,12712,17035,21066,12809,29549,8583,33808,8519,25486,48698,46584,44338,46419,57017,56985,44275,42065,50288,50092,46029,52010,49962,39626,37349,49896,52009,52139,29062,29256,37707,37966,52790,38033,42292,33873,25454,12840,12872,29712,21195,21195,40179,35693,31435,23341,21131,44307,46485,44404,44404,48597,48630,46550,48598,46518,48630,42325,31793,42292,48631,29745,31856,50711,46582,48630,50711,50711,46518,38100,40179,38001,27568,35987,48665,48695,35790,29192,29289,23048,29648,42358,14824,19049,42324,38066,33904,27566,33939,50875,42392,31893,46650,44504,16872,10564,2147,34,2212,21098,33906,25520,14987,10759,15013,15044,17156,14979,8705,10818,10786,8674,8674,6561,4448,6562,2337,4417,6497,6465,6465,255},
{49055,51103,51103,51103,51103,51134,53182,44699,42554,53117,53117,46747,40442,38296,32023,34071,40344,40344,40344,42392,42392,42424,42424,42456,42456,42456,42456,44504,44536,46584,48664,50776,50744,33972,29779,29747,31828,35988,48405,50517,21394,15088,15120,13006,12974,10893,12941,12973,12973,15054,17134,17069,6602,12973,12941,10827,15021,12940,12973,15021,12909,2409,15021,19247,23310,8715,10827,10794,2279,19247,25586,19247,10795,8682,8714,17101,23407,29811,25553,14956,12843,21327,17102,10762,10730,10730,10698,8650,10730,14955,10763,6603,6603,6571,6571,4523,10632,27143,27208,23047,18886,10661,2371,227,163,67,2212,8551,33776,42194,35856,31694,40081,38001,8551,19018,14697,21196,19018,15020,21098,2245,29549,6438,29646,12711,23405,21131,14922,53021,40245,31759,33906,55002,63421,48695,57082,61243,54839,61113,58870,54644,54579,56432,50353,50125,52139,48044,49929,47881,43850,50580,38033,46485,46518,42292,38066,35953,33873,25421,27566,42292,33483,31564,31891,27697,42291,42324,40113,31402,33515,35725,40015,44306,46517,46549,50711,50743,48631,48631,40148,38099,50711,33906,23471,46517,48631,42389,44469,42259,33516,27337,14986,21260,40115,25032,25292,23309,23179,31793,36019,10500,31759,38131,33905,31759,29647,48762,50876,53021,50908,55134,42359,23080,23144,8387,6372,8485,27502,33939,23406,21293,19241,15012,12932,15012,12899,12867,10786,10786,8674,6530,4449,4417,6529,8675,4449,224,2272,4385,255},
{51103,51103,51103,51103,51135,53182,53182,42619,40474,53117,53053,42554,38361,36216,32023,36184,40377,40376,42392,42392,42392,42392,42424,42456,42456,42456,44504,44504,44536,46584,48664,52824,48664,31859,33907,33908,33908,38036,50485,54677,21393,23506,17200,13006,12974,10893,12909,12941,12909,19247,21327,23408,8747,12941,12908,10763,8715,6602,8650,6602,8715,4489,8746,19150,23213,8748,12940,12874,4360,15021,25618,17167,10796,12876,10796,21295,27601,23473,17134,14957,12843,21360,15021,10763,12811,10731,10731,10730,12875,23439,8715,4490,4522,6570,8618,10665,12680,20838,16709,12517,10469,4228,4389,4389,8550,8551,19050,21197,38034,58999,52726,40048,40080,38000,21196,10664,19051,10697,29484,6470,23243,2180,23340,18953,17066,27436,12775,33808,21197,55102,38100,31792,40278,50842,63389,46550,36050,31888,44502,46647,46615,50840,59260,52856,61178,54318,45768,45898,54154,52302,52238,50124,44177,48533,38098,40210,42323,42356,42292,46485,42260,40114,31273,33547,29321,33709,46452,40049,29192,29192,29192,29160,31240,31305,31369,33547,37838,40080,42258,46517,50743,50743,48663,48599,46486,48630,44470,27600,33905,40179,21002,16967,12904,17068,35759,29225,23342,15117,27665,38165,25356,21032,35822,33774,29646,27501,36019,53053,50940,57247,53053,53086,35922,27439,21032,16836,21095,21064,33906,31825,23403,23433,17158,15045,12964,12899,15076,8707,8706,17189,8674,6530,4449,4449,8675,8643,6563,2368,4417,6530,255},
{51103,51103,51103,51103,51135,53182,53182,44699,40442,51005,50940,42522,38329,36184,32023,38264,42425,42392,42392,42392,42392,42392,42424,42424,42456,42456,44504,44504,44536,46616,48664,52825,44471,33907,38068,35988,33908,42196,52565,50549,19313,15119,15087,15054,13006,10893,12941,12941,10861,23473,23441,29745,6666,12941,10860,17134,17166,17102,17134,17102,10828,2409,2375,16970,21100,8780,12907,12809,8651,13071,10860,8779,12940,17102,19149,14955,25553,23408,17102,14956,14924,23408,14957,10762,10763,10730,12843,17068,8649,12939,8649,8617,8650,10730,14858,20936,22951,20870,20870,20870,18758,16678,12680,12745,29615,23309,23341,27567,35953,52758,61177,50613,40113,35855,29615,2245,14825,4326,25388,12679,14921,16840,10728,29549,6470,31759,18951,27598,38067,53021,35987,33873,44536,55035,59228,54937,31695,14856,33904,23341,21292,33970,21324,38195,46679,50548,35530,23080,37512,31239,37576,43720,41705,48109,37904,29484,31629,31694,38099,31727,40244,37839,31435,19017,16775,35823,46549,35693,29160,29192,31273,31273,33353,31273,31240,31240,31240,31272,31305,33450,35660,37870,40113,44403,48598,48630,50744,50744,42260,35823,20968,23341,21583,27598,33483,29225,27209,21098,29713,40278,23310,19050,29517,33547,27338,21162,42454,44569,46714,57214,55134,53021,27406,27600,12837,17062,14982,21322,31855,19241,19270,21383,19206,17158,12932,10851,12931,4449,10787,12931,8643,6530,224,8675,10820,6530,4417,4417,6530,6497,255},
{51103,51103,51103,51102,53150,53182,53182,46812,38394,48924,50907,42522,38297,34103,34071,38296,42425,42424,42392,42392,42392,42392,42424,42424,42456,42456,44504,44504,46584,46616,50744,52825,44406,33908,38068,35988,40116,44276,52597,48437,17233,15087,15087,15055,12974,10861,12941,17134,15021,17167,21328,36051,8715,15054,10828,8747,8747,8715,6634,8715,8715,4489,6601,6504,16971,21295,23147,16841,16809,16874,14760,8486,8519,10729,6534,2374,12939,23407,19182,14989,17069,21360,12876,14858,16938,23310,25422,19148,12777,12777,21197,21229,19116,17003,18887,18757,18725,18757,16709,16710,18790,18822,6374,23245,27404,29615,21229,19051,33808,38099,46551,38164,44340,40081,21164,166,8487,34,10631,4293,4390,21066,8421,27534,10567,23308,23243,10696,46616,52956,35921,36019,48697,57148,57116,63356,52727,35856,40049,35888,27404,29549,21066,23340,29744,44437,44274,25226,33579,35693,18919,37610,18855,29288,42032,33743,31629,35986,46551,50712,44405,33515,33677,16937,15020,42292,46452,31371,29160,29193,29225,31241,31273,31273,31273,31240,31272,31273,31273,33321,31273,31240,31272,31337,33515,35725,40048,42226,40211,31370,27111,9103,6796,31631,31273,29160,25096,10795,23407,36084,31989,21360,29681,42066,41868,37838,35888,42390,50875,53021,57279,44472,25325,25581,15045,15045,8708,12966,15014,10787,21382,23496,21415,17190,15045,12964,12932,6562,6595,10788,8675,6531,225,6562,12900,10755,8675,6530,2337,2337,255},
{51103,51135,51102,51102,53183,53182,53182,48957,42587,48892,48827,42522,36249,34103,34071,38296,42457,42424,42392,42392,42392,42392,42424,42424,42424,44504,44504,44504,46584,46616,50745,52825,46519,33907,36020,38100,44277,44244,54645,46357,17233,15087,15087,15087,15054,10861,12941,12973,12973,17167,23441,36052,15021,21393,21426,21394,19281,17200,15055,15022,12909,14989,8682,19084,18987,23342,23115,18921,18889,23082,23082,16841,16874,8583,228,196,228,17197,19183,14956,21295,27569,27535,31695,33482,37969,35986,29648,29647,29647,29680,27600,27600,29583,35824,33711,31565,29420,23114,21001,14728,16808,14793,21230,21001,33775,21229,29584,40081,40213,44504,33841,44438,44406,12810,4359,4294,101,12681,3,6406,16744,12453,25357,12550,18986,23179,10632,50843,48762,33873,40245,52922,57149,57182,59228,61308,52856,61341,57082,50744,61179,46453,42194,46420,44405,46420,37740,39884,42194,29289,44241,31565,25161,44177,38034,27436,31726,31921,55034,42194,29225,35563,31305,29386,46484,42129,33679,33908,33581,31273,31436,31339,31273,31240,31240,31240,31272,31273,33321,31273,33353,33353,33353,31273,31240,31208,35726,42195,29290,25129,8647,19051,33581,31370,25292,23211,14989,33939,31827,21392,19148,38166,42327,39790,41738,39690,35855,48794,55101,57247,29584,27568,21320,17190,17158,15046,15045,8708,8739,17157,23495,19238,15013,15045,10787,6595,4483,8676,8676,6595,2337,161,2337,15044,10787,2337,160,128,128,255},
{51103,51135,51103,53150,53183,53182,53182,51069,42619,46780,48795,40442,36249,34071,34071,40344,42457,42424,42392,42392,40344,42392,42424,42424,42424,44504,44504,44504,46584,48664,50744,52824,48632,33908,31828,31827,40116,42196,54645,42228,15120,13039,13039,15087,13006,10861,12941,12973,12941,23408,29747,29811,10828,19346,19379,19411,19411,21524,21459,21492,25718,21427,4489,17035,31535,27535,16873,10568,12616,16874,16809,6374,6374,4390,261,14792,12744,17068,19214,17068,19213,23407,21359,19181,23016,29582,33906,29647,25421,23341,25421,25421,23341,23341,38164,44439,42358,42325,40213,38132,38068,38100,29583,18986,14792,31662,25422,33840,40147,42293,44470,42226,44406,38132,8617,8520,4293,6569,14826,35,12713,16646,12615,27438,12549,25325,14793,14891,53021,44504,31760,42390,55003,57181,57247,57148,63389,42357,31824,36050,48728,44567,48728,57115,59260,52824,61244,48403,27273,27468,46094,29515,42096,37674,42258,44308,31630,29516,29516,31759,27436,29484,31435,25129,39919,48565,35726,35954,38328,33548,33483,36149,38068,31273,33549,31500,33418,31273,31273,31273,31273,33353,33321,33353,33353,31273,31305,42195,40049,25389,25454,42294,40050,29257,31467,25289,23275,27634,36051,29743,27634,31827,46650,44537,42293,54808,50485,37905,38164,55133,50843,25419,21355,21352,19335,17190,15046,8708,4516,8708,15047,21352,15045,10819,19238,8708,8708,4483,10821,6595,2370,128,160,4417,12932,4482,192,225,2338,2338,255},
{51135,51135,51103,53150,53183,53183,53182,53150,42619,44667,48827,40442,36249,34071,34103,42457,44505,42424,42392,40344,40344,40344,42424,42424,42456,44504,44504,44504,46584,48664,50776,52824,48631,31828,33908,35988,40116,44277,54645,40148,15120,13007,17168,13006,13006,10861,12941,12941,10861,23473,29779,29844,10860,23539,19379,19411,19411,19443,19346,21492,25783,23572,6569,16970,33777,23407,23212,23017,18824,18856,18856,12551,10502,2341,164,21033,27307,23212,23440,17134,12811,6537,4489,6537,12550,25390,40212,38067,33841,31728,29615,27534,25422,23276,33906,44504,44471,44471,42390,42358,42358,42358,35955,21066,10664,31662,33776,29614,42227,42293,33906,38066,38066,31728,4392,10633,67,8617,12713,166,19019,16710,16906,27373,12550,27438,10503,25456,53021,36117,21293,38131,57083,57213,59327,57182,59260,52824,44308,35856,40211,27436,25453,36116,23502,40341,48728,52791,33677,12710,42225,25291,27468,39854,21097,42097,40018,29517,31629,35954,42260,33776,42227,33807,50710,46485,39952,31370,31468,31273,33580,36019,37871,31305,33938,36116,35564,35662,33875,33581,33385,31370,31273,33353,31273,31240,33548,44340,35726,25357,29713,52955,42227,31305,29257,29224,37709,42358,29615,14790,31859,46650,48795,42392,36117,50939,61407,57214,48698,52988,40148,23402,19304,19304,19271,8771,2402,2338,6597,17127,34026,29833,15044,12900,10820,8676,6595,6596,12998,6628,226,129,193,6596,6595,2370,8644,6563,2370,4451,255},
{51135,51103,51102,53182,53183,53182,53182,53150,44699,42554,46779,38361,36216,34071,34103,42457,44537,42424,40312,40312,40312,40344,42424,42456,44504,44504,44504,44504,46584,48664,50777,52825,46551,33940,33908,33908,35988,44277,52565,35988,15120,13039,17200,15086,12974,12973,15022,10860,10861,23440,25553,25651,10827,10925,17232,25586,27699,19313,13071,11023,13104,17233,6537,10762,27470,17101,25456,27308,23082,25162,23049,25195,25292,8583,16938,25259,23049,18888,12647,10698,25489,17070,12843,12745,16743,27536,40310,50777,46584,46552,44471,44439,42358,42293,38132,31858,31890,34003,36084,38197,38230,40310,38165,21066,10599,23276,35920,25422,44339,42260,23341,27534,29680,23277,2214,10665,35,10697,6374,4359,14858,100,17003,14793,14695,27438,8519,42327,48730,19247,21294,48664,59228,59261,59327,57214,44503,44502,52856,40244,42388,54905,40114,46550,33809,31694,38099,48630,39788,16775,25290,31402,14758,35822,12646,29613,44307,21162,27436,29647,36115,46616,38196,50645,46484,40211,31695,18823,29225,31273,29192,31305,31305,33385,33580,35758,33353,37969,32021,35694,35531,19116,29550,33418,33549,29388,40049,42163,29193,31306,35988,48699,35825,31274,29258,20936,31760,40212,33841,35987,40279,46650,48763,40279,44537,38230,40276,46647,53019,50843,27469,27662,19304,19336,19271,12900,12933,10821,15014,17127,29801,23464,12932,12965,8676,12934,8676,6596,8741,6596,2403,193,4483,6628,6628,8676,6596,2337,289,290,255},
{51135,51103,53118,53183,53183,53182,53182,53182,46844,44667,46780,38329,36216,34103,34103,42489,46585,42424,40312,38264,38264,40344,42424,42456,44504,44504,44504,44504,46584,48664,50777,52825,46551,33908,38068,38036,35956,40149,44309,29780,15152,15088,17200,13006,12974,10893,15054,12941,10861,19312,23473,21360,15021,4521,14956,17068,25293,21067,8649,328,263,4490,8553,17003,14891,15021,25455,21034,23082,25194,23114,31630,23341,14955,33776,31631,27209,25097,14630,12680,19246,19215,21327,19149,23277,23342,35986,48697,46584,46584,46584,46584,46584,46584,44471,25454,21260,21260,21260,21261,21261,21293,23406,25325,18953,21098,38000,29615,40146,40278,23407,23407,21229,14858,2213,12680,133,12713,2213,8585,12713,101,19084,4229,18954,23180,8552,48730,52988,33875,44471,42456,52922,61374,59327,59295,48598,40113,42324,29549,21194,44501,29646,36049,52889,35985,52856,52889,42226,35725,25127,46126,25161,23112,23080,16839,29385,16872,25324,29484,27468,31791,21162,44403,48597,42291,35824,18922,31468,31468,14695,25161,33418,27144,27080,31273,33353,33418,33483,33418,33515,25356,37871,35499,33906,34004,44405,40116,29649,33647,48764,42456,33516,33613,21294,19083,35986,38131,38131,40278,40311,48828,46650,46650,46683,31794,18953,27272,25387,29549,25355,23500,12965,17190,19303,15077,15046,10853,10821,8676,17158,12965,15045,19303,12933,15046,8708,6628,4548,4515,2371,6596,8709,2402,6563,10821,6596,193,224,258,255},
{53183,53150,55166,53183,53183,53182,53182,53182,51037,48892,44731,36249,34136,34103,36151,42489,44505,42392,38231,38264,38264,40344,42424,42456,44504,44504,44504,44504,46616,48665,50777,52857,42358,29779,38068,33908,35956,38101,42262,25619,15120,15088,15120,12974,12974,10893,15054,10893,12909,12941,21360,19280,6634,4521,6634,12875,25456,19052,6568,328,263,4457,10665,23342,4359,16971,27503,21001,23082,25194,33710,38001,10728,17100,33744,19051,27210,20969,14663,10470,6309,2181,133,2214,12811,27601,33873,46551,42390,42390,44471,44503,46552,46584,46584,33841,23309,23341,23309,21228,21196,19116,19083,25357,25259,23244,35920,35921,29648,31891,19246,21360,16971,8487,4228,6374,2181,12713,2213,14923,10600,2310,19116,6277,25260,16841,17004,52956,36117,36084,48730,46683,42423,59228,59262,59327,55003,48500,44339,38033,19050,35919,37838,16936,38098,27338,29711,38098,23113,43851,27142,29548,43884,33514,46322,23048,27371,29485,31663,25323,29549,33840,40083,31727,31727,31759,25290,27208,31369,29322,25129,29355,33483,18986,16906,35597,25129,16678,31338,31305,31273,33385,33386,33450,31565,38034,44372,33971,29811,31761,48861,35953,33386,33645,27599,29615,40245,38131,38067,38198,40311,48861,46651,50941,42392,27536,20904,27111,20870,20903,18985,25514,17159,19303,17191,8740,10885,6660,4548,15015,4419,290,17127,19271,8740,8740,10885,8740,4515,4483,4484,8741,4483,258,258,8708,4516,290,257,257,255},
{53183,53183,53150,53183,53183,53182,53182,53182,51037,46812,44699,36217,34103,34103,36184,44537,44505,40344,38199,38231,38264,40344,42424,42424,44504,44504,44504,44504,46584,48697,50777,52825,38165,29780,29747,29715,33940,33908,40150,25587,13072,15120,15120,13006,10893,12941,15054,12941,12941,21295,21360,23506,8683,4521,2441,4521,15053,14923,2408,327,263,4456,19084,25455,8455,29389,31664,21002,21001,27307,37936,31792,4488,17068,31696,18856,16808,14696,12583,10470,8390,6309,4197,2084,16874,23341,29647,35953,31727,29647,29680,31792,31825,33906,36051,35986,35922,33809,29648,27567,25454,23341,21261,25422,25292,23179,35921,40246,25488,19181,33808,29615,23277,4326,6374,2148,6407,10567,133,19116,6406,8648,16938,10469,29486,10567,29681,59230,38165,33939,46682,46683,42424,52921,59229,59327,59295,50646,42194,37968,25323,23177,48077,20838,35757,35662,10664,42128,20936,27338,37838,18790,39723,39690,35594,43753,37675,44046,40049,31663,27436,27631,38261,46519,38164,42326,25390,21162,29546,14790,27404,27339,33581,29290,31403,33451,23081,18824,33548,27307,8454,25194,35499,25064,27112,37937,40049,31370,29355,31794,44602,35758,31273,29160,29225,38034,40212,35986,36019,36085,40311,48828,46715,48796,38166,21164,25031,29225,27177,20968,21194,25546,21416,19271,12998,10853,10853,6629,8710,6564,162,2339,12935,10822,2370,4483,15046,15079,8708,4483,6629,4548,2435,2403,2371,4484,2371,2403,2371,2338,255},
{53183,53183,53183,53183,53183,53182,53182,53182,51005,46812,44699,34136,32023,34103,36184,44570,44537,40312,38199,38232,38264,40344,42424,42424,44504,44504,44504,44536,46616,50745,52825,50777,38101,31860,29747,31827,35988,33908,31861,25587,13072,15120,13039,12974,12973,10861,12941,12941,12941,15022,17167,25618,12908,8682,8682,6602,4553,6601,4488,295,231,4489,14988,19182,8423,29389,29518,20969,21034,27372,27566,6664,165,23407,23245,8422,6374,4326,6407,10600,6342,6374,8455,8455,23245,27535,27534,40114,31662,27502,27501,27501,27469,27501,27469,31760,46584,46551,46519,44406,42326,40213,38100,38068,29485,23113,31728,38231,38166,19149,44307,40049,29582,6439,12680,4229,8584,8454,132,16971,2180,12842,14792,14695,29486,8455,42359,50908,40344,36118,42424,48763,44537,48696,61341,61374,61375,52858,52792,50711,42259,19017,33612,33516,20935,37708,18855,33513,31272,16903,41998,27047,33709,41999,16774,42128,29321,23080,39983,46486,27436,25258,23307,38163,21227,38196,40245,33842,29647,14857,17034,25486,38099,25390,23276,27438,25194,25162,29290,29258,23017,33516,31403,14761,14826,42260,27340,18790,14762,19116,33937,33516,35792,33712,42261,44438,33938,29582,35987,36020,42457,48796,48828,42457,33972,20969,25096,23114,25227,16840,16901,27625,19304,12966,12966,17192,8741,4516,10855,6629,259,195,4451,8741,6628,4516,6628,10821,8773,8773,8773,4515,4515,290,290,2371,193,192,225,225,255},
{53183,53183,53150,53183,53150,53150,53182,53182,51005,48892,42587,34136,32023,34103,36216,44569,42457,38264,38231,38264,38264,40344,42424,42456,44504,44504,44504,44536,48665,50745,52825,48664,33972,31860,29747,31828,44309,40149,40182,25587,13040,15120,15055,12974,12974,12941,10861,12941,12909,12941,12941,21425,8715,10795,6601,6569,6634,10828,6601,328,263,2408,12875,12843,12584,35727,29486,20969,21001,27308,23308,4422,6503,23374,14729,8389,6374,4326,6374,8551,8520,6407,6374,8520,25423,27567,27502,42260,33808,29582,29550,29549,27501,27501,27501,29582,44471,48664,48664,48664,46584,44504,44504,44504,35856,25194,27404,38100,38133,21261,44274,40048,25389,6471,12648,2213,10665,6341,4326,16938,6406,19083,16905,19019,25325,16938,55036,42391,27731,36217,36117,46650,48763,42391,48795,52988,59326,57182,57181,52889,46517,37969,38001,48403,23146,33839,39887,14791,42096,23145,23047,39690,27175,39690,29159,35724,37708,12711,40081,46420,33776,27403,29549,29581,29484,25420,29646,31760,31727,38034,19017,23341,33906,23341,23341,29681,25487,16970,14858,19050,21065,16872,18855,22984,31533,40179,25228,10470,12712,29550,33774,35531,38230,38262,42293,40277,38132,33875,25421,36084,46715,48828,44569,40311,23310,22983,25161,23374,23343,10567,21096,31821,15078,8773,10918,10854,4484,4517,6597,4484,4453,4485,2307,6628,10853,6628,4483,4515,2402,8773,8709,2403,160,193,161,192,160,192,192,224,255},
{53215,53183,53183,53183,53150,53150,53182,53182,48924,48860,38394,34136,31991,34104,38264,42457,40377,38231,38231,38264,38264,42392,42424,42456,44504,44504,44504,46584,48665,50745,52825,46519,31827,33940,33875,33876,42229,44277,50518,23507,13040,19281,15120,13006,12974,12974,10861,10861,12941,15054,23440,25455,8747,8714,6601,14988,10827,10828,2408,2408,327,2376,29616,12811,16809,33647,27340,16873,18953,23147,33776,27534,12841,14923,16842,14729,6374,6374,4293,8454,4326,4294,6342,6407,25455,25422,27502,42358,50680,44373,44340,42228,40114,38002,35921,33808,42325,46583,46584,46616,46584,46584,44504,44536,42293,29419,25227,35920,38000,25389,44340,42260,17003,8584,10567,6406,12745,3,6374,10600,10730,21196,68,14890,23244,27503,57182,48698,33938,42457,29779,42457,48731,50876,40344,40278,59262,59327,59359,57148,54970,61341,48696,38131,36050,42325,44308,31695,42226,39887,23146,42096,23048,23210,41999,18822,33579,22983,25095,37675,46453,29517,27403,27436,29581,29517,27372,23211,23243,36017,19018,17001,29648,23309,27568,31794,29713,23310,14890,14890,19082,12809,2342,196,6534,12841,27340,23147,14924,44437,35694,31337,31532,33645,40147,38164,44504,42426,27602,29811,48796,44569,40311,31827,21034,29192,29191,27144,21001,8486,31693,42257,23467,12966,12999,10854,8679,6598,8742,8742,8742,12967,12998,12934,10854,4516,289,2370,160,2305,6596,4419,64,64,96,128,160,192,224,4515,255},
{53215,53183,53183,53183,53150,53182,55230,55230,46812,44699,36281,34136,31991,34104,38296,40409,40344,36183,38231,38264,38264,42392,42424,42456,44504,44504,44504,46584,48665,50777,52857,42358,31860,38100,35988,35988,33908,46357,48470,21427,13040,21394,17168,12974,13006,19248,12941,10861,10861,19280,27860,31826,15021,6634,6601,10762,4553,6634,4520,359,327,2376,27601,12811,18922,31631,25227,14955,17100,25487,31760,12905,4455,12778,14859,12746,4261,6374,6374,6406,8552,6374,4294,8487,25422,25389,27534,40213,52890,50744,48664,48664,48664,48664,48664,48664,40212,31695,31760,33873,33905,33938,33971,36084,38165,29485,25226,33776,42226,27501,38165,40213,10665,10632,6341,6471,16873,2,10600,4326,14989,19052,68,21164,12680,33907,57215,55036,38164,50810,33972,36117,48796,46715,40343,44439,59262,59327,57247,59326,52890,57147,57083,44405,38034,40179,31825,29712,36050,33938,36018,42324,35921,31760,44275,25292,27501,39887,12711,35920,48533,35921,25290,18985,19114,44438,25422,33808,31696,25389,31696,16970,21260,23308,33906,40245,27600,19149,19116,14922,17002,21130,12777,4455,6471,6503,12874,16970,23309,31728,35629,29486,25163,31501,42293,36051,44570,48763,27666,34037,44537,40311,46683,27569,20935,29192,29159,25063,27339,31630,27597,38065,27597,15079,8806,4548,4485,2372,2437,10887,19337,19368,19303,10853,8773,6596,258,225,160,128,128,96,96,96,128,160,192,224,256,353,255},
{53215,53183,53183,53183,53182,53182,55230,55230,46780,42587,36249,34104,31991,36184,38297,42457,38296,36183,38264,38264,38264,42424,42456,44504,44504,44504,44536,46584,48697,50777,52857,42358,33940,33908,38068,38068,40117,50517,48438,19346,15088,19313,15087,15055,15086,15086,12941,12941,10861,13006,23634,21327,8714,8714,4521,6601,4489,4521,4520,2408,4456,6569,23375,25390,29454,31599,23147,12875,12907,23439,31728,10728,2342,4391,8422,8422,6407,8454,8519,8487,8520,8487,6374,12745,25487,29615,35888,42292,50777,50745,48631,48664,48632,48664,48664,48696,44438,29582,27469,27469,25389,23308,23276,21228,21261,29485,25259,29517,35952,27567,29745,38066,6439,8488,2180,8552,16808,3,12713,100,17069,12778,2278,23310,4327,42359,52988,40375,42456,50843,31827,29746,46682,48764,42392,50842,59262,59327,55102,59359,55035,52889,59260,48696,48728,59261,48664,48599,52825,42293,38034,40179,31760,29712,33970,29712,33970,40147,29648,38033,46322,46421,35856,42228,29485,21259,21163,25485,31825,14857,27534,29583,21097,25454,38133,40278,29714,10762,19148,19083,14890,19083,19018,10697,12842,8648,4422,10696,33969,37904,31370,27340,27471,40181,40148,31761,40376,48730,31859,34004,42456,40311,38230,21132,25064,27210,25129,23080,37999,44305,8550,17034,21291,17161,8773,8742,4549,324,2436,10854,17224,17255,12997,6692,12998,4547,2403,2403,4451,323,193,64,96,128,128,160,224,256,320,353,255},
{53215,53215,53183,53183,53183,53182,53182,55230,48892,44667,36249,34136,31991,38297,40409,42457,38264,36183,38264,38264,40312,42424,42456,44504,44504,44536,44536,46584,48697,50777,52857,44439,33940,27667,27667,33940,40149,52566,46389,19346,15120,15088,15087,13006,12973,12973,15087,12973,10861,12941,10893,23408,10795,6666,4553,6634,6601,12908,2408,4488,27535,27535,36020,38133,29486,31599,23147,12907,12907,27600,31760,17067,8680,2375,8586,8422,6439,6406,10633,8552,6407,8487,6439,19084,21195,27468,33872,40211,44503,44536,44503,46551,46551,46551,46551,46551,46519,35921,29614,29614,27501,23308,23276,21196,19115,27437,29420,29452,23178,27633,23374,31792,2278,8520,100,10665,6341,68,12680,100,19181,6407,6504,23245,10633,50811,57182,36020,36052,55069,44440,31827,46683,48828,44570,40278,59261,61375,55069,57246,59294,52857,57148,57115,44502,55067,52890,46616,57148,44503,50809,57084,44438,50712,50712,38099,40115,38034,25454,29712,31792,31857,46583,46616,48631,37969,38002,31695,31695,31663,25357,38131,37966,23340,36085,27567,27600,8585,10729,21261,17003,14922,21163,16938,8648,6568,6535,6502,8647,18984,27469,29420,31500,44373,33809,31761,38231,44538,29746,31891,44603,44505,31762,20936,25161,29746,29649,23306,35950,21193,6533,23437,25550,15080,10886,6629,4516,2436,4549,8807,17256,19335,15142,15142,10885,8741,10886,6628,2403,290,257,160,161,161,160,192,257,321,386,418,255},
{53215,53215,53183,53183,53183,53182,53182,55230,51037,42554,36216,34104,31991,40377,42457,42457,38264,36183,38264,38264,40312,42424,42456,44504,44536,46584,44536,46584,48697,50777,52857,42358,33940,29747,25587,25619,36021,52565,46389,17266,15120,19281,15087,12974,12974,10893,12974,12973,12974,19280,10861,19247,12940,6602,8746,4521,6601,12907,4520,8714,31793,29713,40245,40213,23245,29584,21099,12907,12940,29713,31728,12874,4486,4487,12681,8454,8520,8454,12714,8520,6374,4326,4359,19149,23341,19049,33775,42227,36085,31892,27698,31860,31892,31924,34005,36085,36117,33971,33907,33906,33874,33841,31761,29680,25422,27470,29452,23210,10727,6599,17067,17068,2246,8455,2181,12745,35,4261,8519,68,17003,133,12810,16939,19117,57149,40376,36117,48697,52955,59262,57117,50843,48763,46618,44504,57181,61407,59294,55101,61439,55003,52922,59229,50777,48794,50907,44471,55035,52923,42390,55035,48664,46616,52922,42325,52922,50777,40244,52825,44405,38002,44373,36019,55035,44438,42390,55003,40244,42422,42294,36051,38035,12711,27534,31793,27534,27504,4358,14955,21229,14922,17003,16970,6502,4422,6502,6502,6503,16905,16969,40147,44373,42358,29518,33908,42457,36119,12940,29778,44537,40279,25358,25063,29224,29354,23179,31661,33870,8710,12871,15016,15016,6629,4516,291,292,324,6598,10791,19337,23561,15141,15143,4579,6628,6628,2403,323,4483,2403,291,2243,193,224,225,321,386,450,450,255},
{53215,53215,53183,53183,53183,53182,53182,55230,53117,40474,34136,34104,31991,42489,44570,42457,38264,36183,40312,40312,40312,42424,42456,44504,44536,46584,46584,46617,48697,50777,52857,44439,31892,31860,25619,27668,40149,56726,46389,17266,15120,21394,15087,13006,12974,10861,10861,12941,15022,15054,17135,21392,8780,10763,12875,6601,8681,6601,2440,4554,21327,17101,29746,40214,17101,27471,18921,16906,14858,29648,23373,4519,2405,4422,23211,8422,4326,8520,10632,6374,2180,133,101,10730,25455,19017,35920,42259,38166,31892,27601,27569,25521,23440,25488,25521,23408,21294,23407,23407,23440,25520,27633,27666,29746,29714,19050,6469,6597,2372,12937,10762,4359,6309,2245,12713,2,8487,4293,2180,16906,3,19051,8519,29713,59294,40213,38132,52956,40311,52955,61375,50876,48763,46715,42457,50809,61375,50907,57181,61439,48762,46584,57181,52890,38099,27631,42390,38229,34035,44503,46681,46648,42390,55035,48696,42390,55003,42390,48729,48696,42325,52922,42357,44502,52857,48664,52955,48631,46583,52890,40277,44504,33743,19049,25454,31793,33907,14922,6438,21261,19084,14923,12809,6502,4422,2341,4422,10696,19083,19018,40212,48664,35922,31697,36085,48796,36086,17102,38263,48764,36020,21002,27143,29159,27144,25258,29677,21257,10822,15080,12968,12968,6629,259,4485,2372,2340,12841,22953,14983,21481,10949,8838,2467,8774,322,258,2403,6661,2467,2500,2371,257,289,321,385,418,482,4610,255},
{53215,53183,53183,53183,53183,53182,53182,55198,53117,38394,34104,32024,31991,44570,46650,44505,38264,36183,40344,40344,40344,42424,42456,44504,46585,46585,46584,46617,50745,50777,52857,46552,31860,29780,25619,33908,46357,60854,42229,17266,17200,23474,15087,15054,12974,12941,10861,12974,15054,15054,17167,23440,17134,12908,27503,14988,6633,4488,2408,6666,23408,17069,27633,36085,17101,27471,20969,18889,18857,31695,12905,2405,2373,2341,19018,8454,6406,6439,10600,4293,100,133,165,12778,21294,14956,29614,38131,36086,33940,31860,31860,31827,29747,29746,29714,27633,23375,23343,23342,21262,23342,21294,21262,25521,25488,14761,19149,8775,4549,4550,4423,4390,4292,8583,10600,2,12712,2147,6438,12680,35,19084,165,31891,61375,46617,42358,52956,33907,40310,59294,50876,40376,46683,48796,40343,50940,38198,52922,59326,46649,42423,40375,38229,44535,40310,44503,44503,38067,42390,36019,29648,42390,33971,34035,42455,44568,42422,42422,52955,42357,44503,50809,40244,50777,48664,40342,46616,46616,48729,44471,36051,42293,14759,21228,27600,27600,31729,14794,27568,21196,17003,14922,19083,14890,6503,10728,17068,14923,12841,19212,27567,25324,31826,40344,48829,40312,40246,48828,48764,31762,22983,27176,27176,31466,23434,23466,17192,15015,12967,10886,15016,6630,2404,2404,4485,6534,8550,8324,12806,21449,12997,8805,2467,2435,290,354,4580,8837,2402,321,289,289,321,385,417,2530,4610,4674,255},
{53215,53183,53183,53183,53183,53182,53150,55230,53117,38394,32023,32023,34071,46650,50778,44537,38264,36184,40344,40344,40344,42424,42456,44504,46585,46617,46585,48665,50745,50777,52857,48664,31860,27700,27700,38069,46357,60886,35989,15186,17200,23442,15087,15087,12974,12973,12974,15087,15054,12941,17167,27699,21425,21262,23342,19149,14955,14955,10762,17069,21360,17102,17134,31859,31794,29551,18921,18921,21002,29614,6599,4518,2373,4357,14792,8520,6406,8487,10567,2148,68,2181,133,19084,21294,12908,21196,25487,38166,31860,31860,31860,31860,31859,31859,31859,29714,23407,23407,23407,25455,23407,23407,23407,25520,23375,14728,12809,4517,4517,324,228,163,2340,10760,10631,8486,19082,4517,21228,16971,12778,23309,4358,23471,59294,46617,46584,52923,29713,27632,57148,59295,50811,48828,46715,46650,48763,46651,44569,59262,48730,46617,38066,38034,40212,21260,19179,38099,31728,33970,42423,36084,42422,44438,33907,25520,23374,25552,31890,27664,36052,40342,40374,40245,46616,50809,33938,42422,40342,38197,52955,38100,35952,22886,25063,29517,33874,33841,40278,38133,23342,19116,16971,17003,23276,21261,10826,8713,10761,2406,6600,19049,31696,36020,48829,44570,36117,40311,46715,42457,23180,25064,25455,27696,23337,17128,15079,21353,17192,10853,6628,6596,4517,6597,2404,4518,2340,4420,163,6501,19273,17256,8837,8805,2435,2403,355,4580,6725,2434,289,289,321,354,418,482,2561,4674,4706,255},
{53215,53150,53183,53183,53183,51037,53085,55230,51037,38329,34071,31991,34103,48730,52858,46585,38264,38232,40344,40376,40344,42424,42457,44537,46585,46585,46617,48697,50777,50809,52857,50745,33973,31828,35989,40149,48438,58806,33941,15186,17200,29715,15087,13006,12974,10861,12974,17167,12941,19247,19247,17198,15086,21262,21196,19116,19149,19181,19181,25488,25586,17101,19084,25455,38165,29519,18921,20969,18921,25324,12840,2373,14824,23081,10534,8584,6374,8454,8519,4164,8390,10502,10502,29583,27536,17003,21196,23343,38198,31892,33941,33973,33941,33941,33941,31892,29747,27601,25521,25520,27569,25488,25487,25488,25488,23277,14695,12744,10824,292,196,4421,2308,2340,292,14951,19144,23372,8807,21357,21326,19246,27599,23440,17068,48794,59230,52956,46649,27568,23407,48762,63487,57182,52989,48764,46716,48828,46683,40278,55101,50843,52923,48598,42292,44437,38099,16904,29484,35694,23244,33678,29322,27469,35921,21098,31728,31762,21229,27568,27536,23375,23407,21261,27665,40277,38196,33938,21293,27664,36084,46681,48698,31728,23079,16838,27469,31760,31728,36051,31925,21263,21229,19084,17003,21196,21163,8680,4486,4487,2374,8681,25422,40278,48796,48796,36117,36085,40343,44537,38134,23017,27144,27241,29516,21258,10822,10822,15079,17192,15080,8741,6661,10854,8742,6629,6630,4549,4517,2340,2308,6598,15112,13063,8838,8773,6693,2403,289,2435,354,321,354,354,418,2530,2594,4706,6786,6818,255},
{53215,53151,55231,53183,55263,48925,51005,55230,51005,36281,34071,31991,36184,54938,54938,48665,38264,38232,40344,42425,42425,42425,44505,44537,46585,46617,46617,48697,50777,50777,52857,50745,33973,33941,38101,40149,48438,56758,29813,15186,15120,27634,15087,12974,15054,12942,12941,15054,15022,15054,15054,19214,10827,25487,29616,31729,29583,27503,25390,31761,23408,19117,27373,31695,38098,27373,20969,20970,18889,21001,25422,325,21130,29322,10469,20969,18856,18856,16775,16711,16743,16743,12582,31696,42358,25422,21163,25424,38166,33941,33973,33973,31892,31892,31892,31893,29714,27633,27633,27601,27601,27601,27601,25521,27601,21130,21031,18985,10791,260,195,10728,4486,260,227,8709,12935,21356,10887,19148,12874,8712,23405,12907,8617,29811,55100,57182,40278,25455,21327,34069,61407,59295,57182,48763,44569,48828,48796,40312,42456,52956,55036,57083,46452,44405,46551,27469,19115,42326,29682,21228,42194,20968,21130,37676,37643,35726,22984,29549,33776,18986,33873,31761,25487,38197,25389,21130,23178,25356,36051,38197,44568,33972,17002,6372,25388,33873,33873,31761,38133,17036,12810,21229,17003,17035,23276,16970,6567,2374,2309,8648,29811,38262,48861,38264,15054,25585,38198,42424,29584,25064,29160,31239,31465,21289,17128,15047,10854,15047,10854,8709,6629,4484,2371,4484,2404,2404,4453,162,195,2276,2371,4547,6660,4580,4612,2467,321,354,354,354,386,418,482,2627,6755,6819,8899,8898,255},
{53215,51102,55231,53183,55263,48957,50972,55230,51005,36281,32023,31991,38264,59130,54938,50745,40312,36184,40376,42457,42425,42457,44505,44537,46617,46617,46617,48697,50777,52825,52857,48664,33941,33941,33941,44310,50518,54679,29813,15153,15120,17200,15119,12974,12974,12941,17135,15022,15022,17134,19215,19247,8714,25553,31825,44471,44438,42390,42195,23211,14792,29387,31532,33709,33677,25194,18920,27274,27242,25162,27469,12742,27403,29354,14694,27241,27241,27210,27209,25161,25161,25129,23048,27470,44536,35987,21196,29682,36085,31892,31893,33973,33941,31893,33973,31892,27634,25553,27601,27601,27601,27601,27601,27601,25521,14791,25258,21033,23341,12841,2437,4485,260,163,227,12870,15015,15081,10823,21261,17132,8648,8647,8615,4391,17101,48729,57182,33939,27568,36053,27698,55068,61407,61439,50876,42391,50876,46715,48763,42424,55036,57181,61407,48631,44372,48696,46487,19050,35889,35694,12743,33873,27339,8518,33743,29257,23276,33581,12549,23178,33418,35627,33613,25128,35791,27372,21065,23211,25324,27437,27437,23308,19051,14792,19017,33741,21259,27599,29777,40310,23342,4391,17036,21197,17003,19116,25324,14922,6567,6535,8615,15052,31891,42488,40312,21231,31859,44537,40279,23114,27209,27373,27242,31596,15047,17192,17128,15047,15047,10822,4516,2404,4484,2404,2340,2340,259,195,195,2308,163,162,257,322,290,322,322,387,386,386,418,450,482,2563,4707,8899,6850,8931,8963,255},
{53215,53183,55231,53183,53183,51070,53053,55230,48924,36249,32024,31991,38297,59098,57018,48665,38264,38264,42425,42457,42457,42457,44537,46585,46617,46617,46617,50777,50777,52857,52858,44439,36021,33973,33973,44342,48470,52631,31861,15153,15120,15120,15087,15054,17167,17135,17167,19280,14989,17167,19215,19215,14924,23375,31825,44438,44438,44471,38001,23016,12550,27209,27209,27209,27209,23016,12582,31434,31402,29289,27241,27209,27274,27209,10469,20968,23049,23048,23016,23016,20936,18888,18855,23146,42424,36052,21196,29746,29779,29715,29747,29747,29747,29779,29779,29747,27634,27601,27601,27569,27569,27569,27601,25521,23407,12646,16872,23179,34038,8778,4517,260,163,132,259,10854,4517,259,10791,21294,19245,14986,19180,19051,6439,10730,36117,55068,31794,31826,31891,17069,40310,63487,53021,46683,63487,57182,46683,48796,36053,52955,61375,63487,57083,44404,38099,33906,19083,23146,44047,31273,35628,39822,20838,33678,33581,10566,31695,25162,8550,31533,25128,25356,37676,29354,31598,25194,19049,27599,38165,42325,29615,38002,29583,23308,36018,16968,14919,19114,31825,27535,4391,8552,25455,19116,19084,23276,23276,12842,14955,10793,6664,23471,36117,44602,42425,44537,46715,33843,22983,27274,23343,25356,23402,12935,10822,12934,8774,8774,2404,2372,10855,8710,6629,4485,194,194,227,260,259,162,130,258,290,290,354,386,419,451,451,483,515,2595,4675,4707,6850,8931,11011,11011,255},
{55263,55263,55263,53183,53182,53150,55133,57246,46780,36249,32024,32024,42458,57050,48729,44537,38297,38264,40377,42425,40377,42457,44537,44569,46649,46649,48697,50809,50810,52858,54938,44439,34006,33974,33974,42295,46423,52631,31893,15154,15120,21361,15119,15054,15054,12974,12941,17135,21328,17134,19215,23408,12875,23407,33906,44438,44439,44471,38001,27209,14662,29289,27209,27241,27209,25096,12549,29354,29354,27209,27209,27241,27209,25129,10502,18855,23048,21000,21000,21000,21001,21001,18888,18953,29713,27568,19084,31859,29779,29715,29715,29714,29714,27666,27634,27634,31860,31860,31859,31827,29747,29714,29714,27633,21262,12615,21033,25389,25554,10729,2373,2341,164,163,130,10759,10759,2339,12872,21327,21326,15018,12873,27600,8648,8552,23471,46649,29648,27666,27699,12778,25552,61407,46650,48730,57214,50908,48795,46683,46584,57181,61407,61439,61407,48598,40179,35986,27502,10664,35888,33580,14694,40017,45965,41837,39951,16775,23081,35693,10502,23179,21001,6438,29517,18855,14889,33711,21065,21130,19115,36051,31794,21358,42391,31859,27632,29614,14887,14888,23373,25486,25423,17037,17101,23374,19116,19116,25389,21164,14922,8712,17198,19278,25585,40343,46650,44505,44537,25261,27111,29191,31272,33546,31692,27532,17097,10855,6661,8742,6597,12968,15048,8742,4484,259,227,227,292,6566,2340,163,130,290,290,322,386,419,483,2563,515,2595,4707,4739,6819,8931,11011,11043,11043,11011,255},
{55263,55263,55263,55263,53182,53118,57148,57245,44667,36281,32089,34136,38165,44403,33840,33839,29614,29614,31661,29614,31694,31662,31759,31727,33872,33872,35920,35985,35985,38098,40178,35986,31761,31729,33842,38002,38035,46323,31795,21328,21296,27536,21295,19182,19182,17102,15021,15021,25521,27569,27536,27601,14924,29681,19247,23473,23505,23537,33808,27209,16742,27209,27209,27209,29321,27209,16775,29321,29354,29322,31370,29322,27274,27274,14695,16775,23049,21000,20968,20968,18920,18888,16808,16808,16840,25324,29616,31892,29747,29747,29747,29747,29714,29714,27666,29746,31892,31860,31860,31860,31860,31892,31892,31860,23310,14695,16776,19083,17036,19083,10664,4389,2309,2275,162,8647,23468,6660,14922,23406,21293,12906,10760,14987,8647,12744,12905,27665,38034,33939,23440,12745,21262,48795,44570,57181,53021,42457,46715,46715,46650,55101,57214,61375,63487,54970,44372,44470,44471,23244,21195,35856,14760,19115,37839,25193,31630,33451,12614,29550,33354,33483,31533,12517,21000,21001,6373,31662,31565,21097,23211,25356,23179,18952,29711,21228,12776,27599,27402,19016,23373,23341,23438,29715,17070,23342,23342,19116,21197,27469,17035,10793,17230,10826,10858,36150,48763,46618,36021,23017,29224,29224,33385,33547,52724,40178,27664,15019,17163,12969,6630,8742,10823,8742,2340,2372,2340,195,8679,19213,227,34,194,322,355,387,451,483,483,515,4676,2659,4771,8932,8931,8963,13156,13156,11075,11043,255},
{55263,55263,55263,53182,53182,51037,52988,55198,46812,34168,27600,35854,31563,33708,31531,31596,31563,29483,31596,31531,31596,31531,33676,31564,33644,33676,31563,31629,31564,33709,31564,31596,31564,31596,31628,33644,29484,31564,27403,31564,33677,27404,35725,27404,35758,29484,33645,31597,31630,35823,29549,35824,27470,37969,29582,29551,29583,27503,37903,33547,20968,31402,29354,29321,29321,29289,14694,27209,27208,29289,27241,27209,25096,23048,14727,12647,18888,16808,16776,16808,16775,14695,14695,14695,12647,29550,36019,33972,29747,29747,29747,29747,29746,29714,27666,29779,33940,31860,31860,31860,31860,31860,31859,31859,21132,14728,12647,16970,23277,29616,19085,14890,10599,16968,6565,8710,15048,8709,27438,25487,19211,10792,8615,6503,12744,16970,19116,17068,40277,37904,31598,42228,48502,44472,46683,59294,53021,38264,34003,48763,42457,46617,48796,50907,63487,61342,46518,42324,42358,35986,14889,35889,33614,25194,37969,23114,12809,38034,21001,16938,37741,23081,29517,27177,10566,27469,29160,31499,35758,23146,21130,25357,29582,31695,25323,23211,23211,21162,35984,19017,17002,25454,19147,27666,14989,12810,23374,21229,19116,25389,27437,12841,6599,4551,6633,19311,42521,44569,27471,24999,29550,29779,33614,40015,48531,33971,23440,21358,19243,8742,4517,8775,6662,2437,2372,4518,2373,195,17100,15018,226,194,290,354,451,451,515,515,547,4707,6820,6852,8964,11044,11043,13156,15269,15237,13156,13156,255},
{55263,55263,55263,55231,53150,48892,55036,55198,42552,33806,31498,40014,35724,37901,33676,31628,31628,31563,33709,31596,33709,33644,33709,33709,33677,33741,33644,33709,33644,33741,33677,33709,33677,33677,33741,35757,33709,31564,29452,31564,35725,29452,35757,27371,35757,31532,33677,33677,31564,35757,29452,37838,31532,33677,35725,31564,37838,33645,37870,31564,35758,35758,33645,39918,33645,39886,31500,37773,37773,37773,37805,35660,35692,31467,27242,20968,25161,23049,18888,18855,16743,14662,12582,10502,8421,27437,38165,31860,29779,29779,29779,29747,29747,29714,27666,31827,31892,31860,31860,31892,31860,31860,31860,33940,27340,16743,6437,6504,21197,31729,16971,16873,10663,12871,8709,6597,10790,10759,25390,19212,14953,12841,8615,12776,21164,21164,27503,17004,14988,17067,23437,36181,55101,52956,59295,59294,40408,31924,29778,46618,50909,52989,40344,46617,61407,63487,52825,44372,38001,33808,16905,25323,44210,54841,52760,44342,31663,38034,35759,25162,33711,25195,12777,35857,14695,16905,31435,16904,29550,27340,21065,27502,36117,44536,40245,42358,40180,29615,35954,23342,8583,25422,33874,21291,29616,8519,6503,23374,21229,23277,29582,21195,12808,10728,15087,10827,25649,27666,25227,27144,27241,29518,31565,50611,44404,38230,17132,21356,19243,8743,8710,4549,4485,2437,8711,4485,195,8648,12939,4516,290,322,354,419,483,483,2595,2627,4740,6820,6884,11045,11077,11076,11075,13156,15236,13156,11075,13156,255},
{55263,55263,55231,55263,48925,46714,55133,53085,31792,35854,31629,35887,33709,35821,35789,33676,35789,33644,35854,33676,33741,33709,35789,35789,33709,35822,33677,35822,33709,35790,35757,35789,35822,35790,35822,35757,35790,31564,31532,31564,33677,29516,35758,27371,35725,29452,33645,33677,29516,35758,29452,37806,29484,35757,33645,33645,37838,31597,39918,31532,37838,35725,33645,37870,31565,39983,31564,37838,37838,40016,42096,35790,39983,37838,39919,39951,35758,41999,35725,37838,35725,31532,31532,25259,27275,31598,40213,33940,25553,27666,29714,27666,29714,29714,27666,31860,31892,31860,31827,25488,33744,35857,33841,38002,31501,20904,12613,12647,23277,31697,25293,23211,14984,6597,4420,2373,29614,33676,31694,29581,27436,19082,19082,12712,14890,25422,31729,19116,17036,12841,6598,29777,52923,57214,55134,57214,48632,27633,25488,50876,48828,50876,44537,55036,61407,63487,59229,46518,44405,46518,33808,18887,41803,50776,61375,50875,46649,59197,52890,50680,50648,48599,33744,35889,33581,23082,29550,16840,10729,33743,23178,23210,21195,29744,40310,25519,40342,40311,27697,31826,23309,23308,31825,27566,40245,14794,100,19148,25422,21229,25422,31662,21196,17035,14924,6470,10727,4389,14792,25162,25097,23113,16904,31824,21262,21358,23406,25518,10856,8775,8710,6662,6630,4485,8744,2373,227,19245,21325,354,354,387,419,483,515,2595,4708,6820,6820,6852,8964,11044,8996,11076,13156,13188,13188,15268,13188,11076,255},
{55263,55263,55230,53183,48925,42522,50972,50972,17264,12941,12941,8747,12940,29516,37934,33709,37902,33708,35854,35757,35789,35822,35821,37902,35789,37934,35757,37935,35790,35822,35822,35790,35855,37870,35855,37870,35822,31597,31597,31564,35725,29516,37806,27403,35757,29484,33645,33645,31564,37806,29452,37838,31532,35757,33645,33677,37838,29516,37838,29484,37838,33645,35725,37838,31564,39950,31564,37838,35757,39983,39983,35822,39983,33709,37871,37838,35790,39951,33677,39983,35758,35758,35790,29485,33710,29582,38198,33972,27602,27634,27634,25489,25488,25489,25456,25521,27601,27634,27601,19019,27176,29288,31467,33482,29256,27209,29289,29321,27339,25227,25227,25356,12871,2372,2372,4422,40213,46386,27467,44273,46321,31661,44241,35790,33709,40081,38034,29550,23277,23309,17001,36116,48762,59359,50844,55101,59262,52891,48665,55069,48828,48731,36085,57149,61407,61439,63487,50712,46485,46615,44406,19083,29614,44405,57214,44536,42423,46714,44601,42423,57182,48762,44536,57117,50777,48600,46389,23179,4293,25389,33776,21098,25291,29549,27436,23178,27566,27535,16905,23309,33905,23275,19179,23308,23469,25422,8454,6536,23374,23342,23342,27502,10697,197,8584,33227,22921,10502,19116,23277,23212,23342,21067,14923,17101,33940,33939,23373,10759,4485,6631,14953,10792,10792,17164,2405,2373,17165,12968,418,419,451,2563,515,2595,4707,6852,8932,6852,8964,11077,11077,8996,11108,13156,13188,15269,15236,15236,13124,255},
{55263,53150,55230,51037,48957,40409,50972,48924,17297,10861,10861,6602,10796,14890,33806,35789,40047,37869,37934,37902,37870,37935,37870,37967,37870,40015,35822,37967,37902,37935,37903,37870,37935,37902,37935,37902,35822,31597,33677,31565,35758,29484,37838,27404,35758,29484,33677,33645,29484,37806,29452,37838,29452,35757,31564,33677,37838,31564,37870,29484,39918,31597,35757,35758,33645,39918,31597,39950,35757,39983,39951,37903,42031,33645,39951,35758,35790,39918,35725,42031,33677,39918,33678,29517,33710,27404,31696,27535,27568,27600,25520,29681,27601,29682,29714,29747,29747,29747,29747,29682,31565,33482,37676,37642,35498,22983,23080,31434,31402,29387,29322,25128,14822,4420,2340,6568,38100,52660,33741,33806,48467,31628,42225,42160,31596,46451,31694,27501,44274,31694,31694,38033,50843,55134,48795,59294,55102,46682,36149,52988,50941,50909,46650,55100,61407,63487,63487,57083,48565,40179,36083,25454,19115,40212,46681,48632,38164,25454,21391,44536,29810,31988,44504,42521,42488,40342,54971,33484,6276,8550,33711,27437,21098,25389,31695,37969,27469,25291,27437,27436,25386,27434,14919,17065,12872,15050,25455,6439,14923,25455,23309,25422,10665,8716,14760,25099,41550,23019,27568,31697,25423,27601,25553,14923,23407,40344,40311,40278,35987,17067,17066,27502,21261,25455,10793,2405,12938,19245,10919,2563,2499,483,2564,515,2627,6853,8933,8932,8932,8964,11077,8996,8996,11076,13156,13156,11076,11108,13188,19465,255},
{53215,51038,55230,53118,51037,36248,46779,50972,17265,10861,12942,8683,10828,6570,17199,27534,29614,33742,35854,35854,35822,40015,35789,40047,37870,40048,37902,40015,37935,37935,37935,37903,37967,39951,40016,39950,35790,33678,35758,31565,35790,29484,37838,27404,35757,31564,33645,33645,31564,37838,29484,37838,29484,37838,31564,33677,37806,31597,39918,31532,39951,31565,35790,35757,33645,39918,31564,42031,37903,39983,37871,37871,39983,33710,42031,35758,39951,37870,35758,42031,33645,39983,31597,31630,31597,29517,31597,23211,25292,23179,21066,23211,16938,21131,16970,19019,19116,19084,21229,21295,29714,42000,39690,41770,39690,37610,35595,23080,21163,16905,21033,16807,18887,12743,4421,14890,33939,52791,42127,31661,48499,35822,33806,46419,27468,35952,40081,23275,38033,31694,27501,40114,57149,48796,38165,55068,55134,50844,36019,55003,53021,52989,40312,46616,63455,63487,63487,61407,52759,46387,38034,33808,16937,23243,29647,57116,31793,19115,14922,31923,25487,17100,40343,27568,19278,42456,44536,37937,14792,4292,23049,21100,19017,27469,38229,44601,44439,40245,46551,31696,25453,27565,14854,12807,12807,8679,21292,10665,10698,27568,25422,25390,23277,12843,12745,17002,35470,16907,31826,44439,29616,23342,27633,29714,36086,40343,44537,50876,40246,21261,29615,23342,27568,31826,21294,21325,25552,19245,10952,2595,515,4677,2595,2627,6788,8965,8933,6852,8932,11045,8996,8996,11076,13157,13156,11076,11107,13188,11077,38356,255},
{55263,53183,55230,53150,48957,34104,44634,53052,19345,10861,12974,8683,12909,6570,19313,23571,19313,15087,17134,19180,16905,21227,19050,23308,23178,25388,25356,25388,27469,25388,29582,27436,31694,29516,33775,29549,33710,31629,33678,31597,33678,29549,35758,31565,35758,33645,33645,35758,31565,37838,29516,37838,29484,37838,31564,35757,35757,31597,39918,29484,39951,29484,37838,33677,35725,37870,31564,39951,33710,42064,37871,39951,37903,35758,42031,35758,39983,35758,39918,42031,33645,39951,31565,35758,29485,27437,29517,25291,27404,21099,23211,23179,18985,21098,16873,18953,16873,14728,14792,12744,29681,46389,41770,43883,43851,39690,41739,39691,29224,25031,18855,12582,16775,14792,10598,23277,29746,48663,48434,31629,44338,44208,27467,46419,35887,27534,42226,25356,31695,35856,23210,40212,57247,50843,44570,46681,59294,57214,55004,59261,50908,50876,48763,46650,59294,63487,63487,63487,57018,50613,46518,46518,31631,23244,35921,50906,48567,33777,21099,21196,27535,12745,19246,23277,8584,27795,27697,40278,33711,18953,12744,25292,25291,25323,23276,25453,46648,31858,36181,48730,36052,25453,23308,17033,16968,17034,8711,27567,25423,31826,25455,25390,25422,27469,25259,21196,23342,25455,27567,40245,27535,27535,33939,42392,42457,42457,46682,48763,29714,23341,29615,21262,29713,29681,27567,44504,36117,10951,4741,4676,2596,4676,4676,6788,8933,8965,8964,8964,8964,8996,11044,11076,11108,13189,13156,13156,17349,13189,23660,50971,255},
{55263,55263,55230,53118,46877,32023,46779,53052,19313,12942,12974,8683,10829,6570,19345,25652,19346,13072,15119,12973,10567,10664,10599,10664,12712,12777,12744,12712,12745,12712,12777,12680,12777,10600,8551,12679,10631,14791,14792,12744,14792,12744,14825,14857,16905,16970,19018,21098,21130,23211,23244,25291,25356,29484,29517,29517,31597,31597,33710,31597,37838,33677,35790,35758,35790,37870,33677,39951,33677,44144,35823,39984,37903,37838,39983,33677,42063,35758,42031,39951,37838,39984,33678,37903,29517,31598,29517,25292,27405,21099,23212,19050,19018,21098,16873,18986,16873,14792,14792,12712,27535,40082,41803,39821,33449,37610,37610,35530,35562,33482,27208,27209,20968,14727,16841,27504,29714,42358,52725,31661,33806,50547,29548,38032,42194,23308,40146,31629,23275,38033,23243,44471,57214,50909,42392,48730,59327,50842,61342,61375,52989,48796,48828,40312,50842,65535,63487,63487,61342,50678,48597,50809,44405,21131,40146,48663,63487,54971,40245,52793,52826,38100,33776,40116,25357,17003,21228,31923,36019,31598,31402,35921,33841,21130,25291,31630,31695,27371,27469,36051,25454,19018,33874,23275,12775,25454,29648,42358,46617,40280,31761,27503,25390,27502,31695,27469,21229,25455,27535,36019,29648,27599,40245,44504,44537,46682,50843,44504,23375,27534,23374,25455,31794,25487,36084,46650,27728,6788,6789,4708,2628,2627,4708,6853,11045,13125,11045,8964,11044,8996,11076,13189,11108,15237,13189,15269,15269,15239,44632,55133,255},
{53215,55231,53150,53118,44732,31991,42522,48892,17233,12974,12974,8716,10829,6570,19346,25684,19345,13040,13007,12940,10600,10632,12680,12745,14793,14857,14825,14825,14825,12712,12745,14760,14825,12680,10567,12679,10599,10567,12680,10566,14728,10567,12680,10534,12679,12647,12647,12647,8486,12680,10534,14728,10534,12647,12647,12680,12680,10631,14760,12712,16873,14825,16905,19018,19018,21131,23211,25292,25356,27436,29517,31630,33743,33710,35823,35790,39951,35791,39983,37903,39951,39984,35791,39984,29518,35791,29518,27437,27437,23211,25324,19018,21131,19018,18954,18986,16905,10664,10632,12712,21229,52858,50483,48403,33449,39723,27208,22983,20935,16840,14662,18888,12614,18920,19050,31762,29714,33940,54871,42095,29580,48498,35854,31693,44306,25356,33807,37968,21098,33807,33743,52923,61375,50876,42424,57181,55101,38132,61374,63487,55069,46650,48796,52956,44569,61374,63487,63487,63487,54905,50613,40178,38033,19050,27501,42259,59261,63390,54970,61342,59229,46519,57116,57116,42325,48600,50713,38164,48599,37839,31403,21261,29550,19050,25291,29549,31727,35856,33775,27436,29484,29581,31662,44371,25290,25324,40213,27696,29939,27700,31892,27535,27535,23374,27535,33775,23309,21196,27567,38067,31728,29680,44537,44570,46682,50843,50681,35955,23342,31695,21261,27601,31761,27568,44569,44537,19371,8933,6821,4708,4708,6820,6820,8965,11077,11045,11044,8964,11077,11077,13189,13157,13157,15269,15270,15269,13157,32050,48826,50939,255},
{48990,53118,55230,51102,36281,31991,42490,50940,17233,12974,15055,10796,10828,4490,19346,27797,21458,13040,13039,12941,10600,10665,12680,12777,12712,14825,12745,14793,14825,12745,14825,14793,14858,12712,12712,12680,12680,12647,14760,10567,14760,10599,14760,12680,14728,14760,12680,14760,10599,14793,12680,16840,12647,14760,14728,12680,14760,10567,16808,10599,14761,12615,14728,12647,12615,14728,10567,14728,10535,14760,10599,14728,12680,12680,14793,14825,16905,16970,21098,23244,25324,25389,25389,27470,27470,27470,27502,27437,25390,25325,25357,21131,23212,19018,19018,16906,14923,21197,10664,12745,29517,52694,44242,44308,29289,35530,33417,37578,35530,27144,29256,23016,27275,21000,23179,31826,29714,27634,50744,48434,29580,42225,44208,27435,44338,33710,27469,42194,23275,25388,40114,59294,59262,44569,38198,59295,50810,31793,55036,65535,63487,57149,50877,48796,42359,59229,63487,63487,63487,59228,52726,48533,48533,35823,18919,45768,50548,65535,57083,44535,61342,59229,52987,61309,57051,59229,59229,44438,52923,50712,29485,10566,27534,40049,29517,27436,40277,48762,52826,38067,46584,40147,27534,40277,25422,17002,36018,31727,10856,12843,29748,25487,29680,23375,25422,29615,29517,19245,25585,35987,33808,38197,48763,46682,50876,52956,46520,25487,23374,25422,23375,31762,27568,38132,48762,44536,15177,6853,6821,4708,6820,6820,8965,8965,11045,11044,11077,8996,11076,11076,15269,15269,15269,15269,15269,15269,25708,50907,50875,52955,255},
{44699,53118,55263,46877,34136,29943,40377,55067,17233,12974,12974,8748,10828,6570,19346,29877,23539,15153,15119,12973,10632,12745,12680,14825,14793,14857,12745,12745,14858,12745,14826,14793,14858,14793,12745,14760,14760,12679,14760,10600,14760,12647,14760,12680,12680,14760,12680,14760,12680,14792,12648,14760,12680,14760,14760,12680,16841,12680,16841,12648,14792,12648,14728,14760,12647,14760,10599,16841,14760,16841,14728,14760,14760,12647,16841,12647,16841,12647,16840,14728,14760,14792,14760,14792,12744,14793,14857,14793,12745,16938,16938,14858,14858,14890,16906,16938,14891,31860,23311,35791,44274,50614,40049,33744,20935,23016,18887,23015,25064,27144,27144,27177,29419,20935,27406,31794,29714,27633,44471,52692,33676,35886,50547,27435,37999,44306,25356,38033,33743,23275,44405,63487,61342,38165,48762,61375,44439,27601,40343,65535,63487,59294,52956,48763,48763,46616,61407,59326,63487,63487,54872,48565,50743,48598,21098,31499,42096,61341,61309,55003,61374,59261,48599,59261,61309,44503,57148,59229,50907,57116,42228,18986,12809,44373,37969,23211,29582,25551,46648,48730,38327,52988,44472,38164,40245,25422,29647,42325,19178,13002,33940,14955,25520,29648,27535,29616,35855,27631,23472,31761,31761,40278,40344,42489,52989,50876,33907,21294,23407,21262,27600,31761,29648,46617,46649,44536,13096,8933,6820,6820,6852,11013,11045,8965,11077,13157,13125,13157,13157,13189,15269,15270,15301,15302,13157,17352,46713,53020,52987,55133,255},
{48893,53150,55263,44732,34104,29911,42425,55067,17233,12974,13007,8748,12909,6570,21426,29877,23571,15153,15152,15086,10632,14825,12712,14858,16873,16906,14793,14793,16938,12745,14825,14793,12778,14793,12745,14760,14760,10567,14760,12680,14761,12680,12712,12680,12680,14760,12648,16841,10632,14793,12680,14760,14728,14728,14793,12712,16841,12680,16841,12680,14793,14760,14760,16841,12680,16841,12680,16873,14760,14760,14760,14760,16873,14760,18921,12680,16841,14728,16840,16840,14793,16906,12680,14793,12680,14793,12745,12712,12712,14825,14825,8519,10600,8454,10567,6407,14956,27666,31729,56984,42161,40146,44307,48532,46289,40016,42031,37870,35693,33547,31402,27209,27209,20936,29583,29681,29714,27633,36085,56952,40014,27435,50579,37967,29613,46419,27501,31727,40049,23243,42357,65535,61375,46584,55036,59262,38132,29681,27697,59294,63487,61342,52956,50909,48763,55004,55069,46649,59261,63487,59163,52693,48565,46518,29583,21130,40049,48729,57083,42390,36181,27794,52955,52955,48794,55035,59261,59261,46551,57116,50647,27079,22950,37903,31533,21098,29484,33710,35953,35921,27501,42422,36019,19083,36051,42359,25486,31792,38099,12871,31889,12810,10794,31794,29615,27535,29647,35822,25357,27568,44439,50843,46552,46682,50908,40278,23375,23342,23375,23374,31793,29680,36019,48762,44569,40342,13095,8933,6852,6852,6852,8965,11077,11077,11077,11077,13125,13157,13156,15237,15237,17382,17381,13157,13159,42486,55101,53020,53020,55101,255},
{55263,55231,55231,42619,32024,29911,44537,53019,17265,12974,13006,8748,12909,6570,21426,29845,23571,15153,17200,15086,10632,12745,12712,14858,14825,14857,14825,14825,16938,14793,14858,14793,14826,12745,12745,14760,14792,12680,14760,10632,14793,12712,14760,14760,12680,14793,10599,14793,10631,14761,12680,14760,14760,12680,14793,12712,14793,12648,16841,12680,14760,14792,12680,16841,12680,16873,12712,16841,16840,14793,16841,14760,16873,12712,16873,14760,16841,14792,16840,16841,12680,16905,14760,14793,10600,14793,14793,12680,12712,14793,14825,10567,10600,10567,10567,8520,17069,25488,40149,54970,44241,38033,42161,50645,52725,42193,50580,40113,46420,38033,44339,38033,44307,48534,44406,25422,27601,31827,31827,52824,50514,27467,42160,46353,29581,44338,33742,25355,42226,29582,31792,63454,59262,46585,59262,55068,33907,29714,25553,48794,65535,61374,59262,52957,53021,57247,42457,40278,50842,63455,63455,52791,50645,52791,48566,25292,33743,42226,61277,44373,33873,12873,29809,40244,17035,38229,40277,25648,46713,52988,54970,43851,43720,43623,37545,33808,25323,31629,35888,33742,35855,35855,31629,31630,33775,40179,35886,25355,42325,25453,21356,25423,8649,27600,33873,29616,27535,31695,33742,25454,42423,50843,50681,50908,42391,27600,23342,23375,23342,27633,31858,29680,48697,46682,44569,42390,13095,6884,6852,6885,8965,8965,11077,11077,11109,11077,11076,13157,15237,15270,19430,19430,17382,15207,36211,52988,53020,55100,48794,48826,255},
{55295,55263,53150,40507,32024,27831,44537,52987,17233,12941,12974,10764,12909,6570,21394,29877,23571,15153,15119,13005,10632,10665,12712,16938,16905,16938,14825,14793,14890,14793,14858,14793,12745,14793,12745,16906,16874,12713,14793,10665,16873,14825,12680,14760,12680,16873,10600,14793,10599,14793,12712,12712,14793,12647,16841,12647,14793,12647,16808,14760,14760,14792,12680,16873,12680,16873,14760,16840,16873,14760,14793,12680,16841,12680,16841,14760,14760,16841,16807,18921,12680,18986,16937,14761,14760,12712,14793,10600,14761,10600,14793,10600,10568,12680,8487,10633,21295,31827,52923,50810,42226,35984,46420,42258,56983,40145,50645,44371,50678,44372,48565,42259,48631,40343,40213,27469,23342,29714,27633,44471,54773,35789,37967,50547,31596,40048,44274,23243,35952,37968,25453,52922,61375,55069,61375,48697,31826,25521,21360,34037,65535,63487,61407,55069,53021,55102,33973,25553,34004,55067,63487,57050,52758,50678,50743,33775,25258,46029,48630,59131,46518,35856,21228,48631,31630,23341,40179,25324,23438,38165,42422,40082,31467,18822,27533,31727,21130,27404,36018,48729,57083,40147,38034,44340,33775,40211,42357,31758,29679,42293,38163,29777,25391,25553,31761,31761,25454,27535,35887,35986,29745,36149,42456,38197,27600,23375,23342,25455,23374,31826,31826,36019,50875,46649,46681,46617,17257,6852,6884,6884,8964,8997,11077,11077,11077,11077,11077,13156,15269,15270,19430,15269,19431,38291,52988,52988,55133,55132,48761,38229,255},
{51070,55263,46877,36314,32024,27863,40345,48827,17265,12941,15055,10796,12941,6570,21426,29877,23603,15185,15119,15086,10632,12713,14792,14890,16906,16938,12745,14825,14890,14793,14858,14793,14858,14825,14793,14858,14826,12745,14793,12713,16873,14793,12712,14760,12648,14793,12648,16841,12680,14760,14760,14760,14793,10567,16841,12648,14760,12680,14760,14792,12680,14793,12712,16841,12680,16873,16873,16841,16905,14760,18921,14728,16841,12680,14793,14793,14760,18921,16808,16873,14728,18986,18986,14728,14793,12680,16873,12648,14793,12713,12713,12680,10567,12712,10568,10665,25488,38166,57247,50778,35822,33742,37968,38033,42226,40081,38065,38033,40211,40146,42324,35953,44404,40212,48566,48500,31695,27600,27633,38165,56952,40047,31629,52660,35854,27468,48500,27501,27566,40114,25421,40309,63455,59294,61439,40278,35987,36052,31859,19247,57149,65535,63487,61375,48763,48763,36053,19181,40311,54970,61374,61342,54839,46387,37968,31597,18919,40015,42291,63389,54905,54873,35823,44437,46388,21130,46582,48567,19050,40244,38164,48566,35791,25161,14824,29452,25291,25291,31662,34036,42520,57149,46649,55101,46552,44438,48664,29711,25421,40212,38099,10920,42455,36151,33908,31761,29648,27503,29648,31793,33907,27600,27567,25487,25455,23342,25423,23374,27568,33874,29681,44471,48762,46649,48729,50810,29774,6852,8965,8964,8964,8965,11046,15272,11077,11077,13157,15237,15237,15237,15237,17351,40404,55068,53020,55100,55133,55133,55133,55101,255},
{48925,51070,40507,34136,32024,29911,38264,46747,17266,12942,15055,10796,12909,6570,21426,29877,23571,15153,15152,15086,10632,12745,14792,16970,16873,16938,14825,14825,14890,14825,14858,14826,14858,14825,12777,16906,14826,12778,14825,12745,14825,14793,12713,14793,12648,16841,10600,16841,12680,12680,14760,14760,16873,12648,16873,12680,14760,12680,14728,16841,14728,16873,12712,16841,12680,18953,16905,14792,16905,14760,16873,12680,14760,14760,14793,16873,14792,18953,16840,18921,14760,18954,18986,12680,14793,10600,14793,12648,12713,12713,12648,12680,10567,12713,10568,12778,25521,40312,50876,57150,52726,40080,46321,44241,50580,48467,37936,35790,29516,33742,27501,31694,27534,31793,44438,42259,38000,25455,27633,31827,54905,48499,27501,44306,46354,29613,46419,37936,29549,42259,27437,29647,59293,61407,57214,36052,38100,40245,25520,14728,46486,65535,63487,61375,48731,48763,42392,36053,40311,48663,59261,63487,54937,54838,52726,52694,31597,29386,48142,57115,65535,59228,55035,63357,59164,52760,52824,57083,40049,40211,46518,46550,48435,39854,16807,33646,37806,31597,29516,31597,29646,44535,29647,36180,55101,36149,29745,52825,42325,35953,42357,19177,19404,38166,33974,31826,33841,29615,27535,31761,33972,33907,27503,25487,23374,23342,25455,23374,31761,33842,33874,46552,46649,46649,46617,46648,40276,13062,8964,8964,8964,8965,11143,21581,11046,11046,13158,19399,25609,11077,21514,44567,55133,55100,55133,55133,57214,57213,55165,55101,255},
{51070,44732,38362,34104,32024,29943,36217,44668,17298,12941,12974,10763,12941,6570,21426,29877,23603,15153,17200,15086,10632,10632,12712,14857,16938,16938,14825,14857,14923,14825,14858,14825,14858,14825,14825,16938,14825,12778,14793,14826,14826,14825,12713,14793,12680,16873,12648,16841,12713,12680,14793,12680,16873,12680,16841,12712,14793,14760,12680,16873,14728,16841,14760,16873,14760,16873,16873,16873,18986,14792,16873,14760,14760,14793,12680,16873,14760,18953,18920,16905,16873,16873,18986,12712,16873,12648,14761,12681,12680,14793,8551,12681,10599,12712,8552,14891,27634,46618,50811,57182,52792,44240,50677,48532,50645,52758,38033,50613,42226,48532,40146,46355,38033,33906,40245,46387,50548,29615,29681,29714,46584,54805,37935,38032,50547,35822,42226,44306,29582,40114,38033,25453,50809,63487,52923,35987,31827,33940,17004,20937,37905,63487,63487,63487,59230,48796,48829,44603,40278,50744,63455,65535,59196,52758,50677,52856,46452,23178,42128,46582,65535,61309,52824,65535,61277,46615,63422,63422,52955,61277,61276,57116,59033,44014,41673,43851,48175,46324,27404,31597,25324,33840,50646,29581,38066,40082,27468,42357,38067,27533,25517,31758,12935,34100,38035,31793,46519,46552,33842,33907,38133,27568,25455,25455,23374,25455,25455,25487,33874,31793,42358,48730,46649,46649,46616,46584,48696,33871,15110,11013,11045,11077,11077,11077,11078,13158,13159,21514,25610,27693,50874,55101,55133,57246,55133,55100,57246,55133,55133,55133,255},
{55295,44732,36282,34104,31992,29944,42457,48828,19346,12909,12941,8715,12909,6570,21426,29877,25651,15153,15119,13005,10632,14825,14760,14857,16938,16970,14825,14825,14890,14825,14858,16874,16906,14825,14825,16939,14825,12778,16874,12745,14793,14793,12681,14793,12680,16873,12680,14761,14760,12680,14793,12680,16873,12712,16873,14760,14793,16873,12680,16905,14760,16873,14760,16841,16841,16873,18953,16873,18954,14793,14793,14760,14760,16873,12680,16873,14760,18953,21001,16841,16905,14793,19018,14857,18954,14793,14793,16905,14760,14825,12680,14793,12712,12712,10600,19117,27601,52890,55003,59263,54938,46321,37999,42193,44371,56951,46452,52790,48532,52758,44306,50678,38001,33939,40278,54838,54805,35888,29681,29714,38165,56952,42096,33774,52692,37870,31596,50612,31629,29549,42227,27501,38196,65535,46552,35987,36053,33940,12810,23148,33810,59262,63487,63487,55101,48763,46683,36151,46650,46650,50842,63487,63422,54872,56919,56984,56952,31565,33514,44045,52986,59229,57148,57181,57213,61309,63455,65535,54905,61309,63422,44438,57148,54808,45899,48077,42097,42130,27437,29452,35953,42422,55101,48599,46583,57083,33743,27534,48599,29517,23242,40211,33840,31890,44568,21423,34165,42455,33939,40278,33939,27535,25455,25487,25455,27568,23374,29713,35987,35954,50875,44568,44568,42488,44536,46616,46648,48696,38033,21322,13126,8997,8997,11110,11110,13158,15239,25644,42421,50842,55101,55133,57213,52987,53020,55132,59327,55165,57246,57213,255},
{55295,44732,36282,32056,29943,32024,46618,48827,19346,12909,12942,8715,12909,6570,21426,31957,25652,15185,17200,13006,10632,14857,14825,16938,18986,16938,14825,16874,16939,14825,14858,14858,16906,14826,14825,16938,14826,12778,14826,12713,14793,14825,12712,14793,12712,16873,12680,14760,14760,12680,14793,12648,16873,14793,16905,14793,14793,16873,14793,18986,16873,16905,16905,16905,18953,18986,18986,16873,18954,14792,14793,16841,12712,18953,12680,16841,14760,18985,18953,14793,18954,14793,18986,14793,14793,14761,12680,14825,12712,16906,12712,12713,12712,18986,39919,44145,31501,54970,59098,59262,50810,38034,42259,48501,48565,52791,44339,48565,42226,46484,44371,46485,44372,36019,38165,52791,54805,42227,29680,31794,31859,54905,48434,27468,44305,48434,29483,44306,42096,29484,42227,31597,29647,59294,42326,31827,29780,25586,17036,23213,38167,52988,65535,63487,50908,48796,42490,38198,48763,48698,50810,65535,65535,59163,54839,52758,52791,46323,25161,41704,35950,61276,50711,42260,21325,42422,46616,36148,53019,59261,55100,59261,63422,65405,50190,49994,47914,41706,37839,33710,33677,33742,38098,44470,40309,52987,52955,48729,48696,40180,25422,33872,44470,38164,38262,13069,6728,23566,44472,36019,31761,25423,23342,25455,25487,27536,27536,35987,35954,38163,34099,15146,15210,15209,17355,34099,44568,46616,46616,44439,31856,21450,19369,19370,23564,31952,42454,50907,55101,55133,57214,57181,48596,42290,53019,55132,59359,57246,59359,59326,255},
{51102,40539,38362,34104,29944,36217,50843,42587,19346,12942,15022,10796,12909,6570,21426,31925,25652,15185,17232,17231,10632,14825,14825,14858,19018,16938,14825,16873,16939,14825,14890,14825,14826,14826,14826,14858,14826,12778,14826,14793,14826,16906,12713,14793,12712,16873,12680,14728,14761,12680,14793,12680,16873,14793,16873,16873,14793,18953,16841,18986,16873,18953,18954,16873,16905,18986,18986,18953,18986,16873,14793,16873,12680,16873,12647,16841,14760,21001,21034,14793,18954,14760,18986,16905,14760,14793,10600,14793,12648,14760,10600,10600,12648,14825,31760,35824,31534,57083,61243,61374,48665,23374,15020,29746,25585,36052,31923,40278,40310,44470,46518,46551,48599,33874,33874,46583,56951,50646,31728,29714,29714,44439,40178,42194,44339,46387,39918,46354,46386,29386,37968,40049,21097,44471,42294,31859,25619,14989,14988,27634,46651,40376,59294,63487,57149,46682,38264,48730,50876,55102,40344,57149,65535,63422,54871,52758,57017,56952,27437,35659,43851,57147,54937,59130,35823,31792,54872,25291,33970,54970,31728,36116,52890,52954,48501,50189,50125,44210,54774,48469,31597,35888,38034,35855,35855,35953,38033,40210,42259,40244,31824,31727,42324,46583,23534,6728,6662,27792,52794,40115,31729,25455,21261,21261,23342,21262,27600,29745,33905,21388,6694,6661,8805,12998,6661,10918,21484,40374,42390,44503,46616,48729,48729,48762,50875,52988,55101,55133,57214,57246,55035,48563,50544,46352,44337,48629,61439,59326,55067,48629,255},
{44797,36249,36249,34105,32024,36282,55068,42555,17298,12909,12974,10796,12909,6570,19346,29877,27732,17266,17232,15119,10632,12745,14793,16938,18986,19018,14858,14825,16939,14826,14890,14825,14826,14826,16906,14858,14826,14826,14826,14794,12745,16874,12713,14793,12680,14793,14793,12680,14793,12680,16841,12680,16873,14825,18954,18986,16873,18986,14792,18953,16873,18953,18954,16873,18986,16905,18986,18986,16905,16873,14793,16873,12680,16873,14760,14792,16841,21001,21034,14761,16873,14761,19018,18986,14761,16874,12712,14793,12712,12680,12680,10567,12680,10600,10697,21295,25456,57148,61210,57116,40245,25389,23276,27503,21164,38035,21293,31826,19245,29778,25584,31923,23504,29714,36019,40278,54805,52692,35889,29681,31827,38133,25421,19115,27534,31760,29712,31792,35954,35986,38066,38034,35888,35986,38099,40180,33906,12744,21066,31762,50909,29779,50842,65535,63487,52956,38263,48795,50908,50908,40278,57181,65535,65535,59098,52758,50743,50841,40114,25323,44242,48663,61276,57082,50679,23308,55034,52727,27534,55034,50582,25453,55002,48663,52661,47816,51977,52075,52238,56855,35823,31597,35855,37968,37935,35888,37968,35920,31793,35823,31662,29614,33872,48631,25484,13000,10952,42455,50680,42261,33841,25487,23342,25423,27568,25487,31793,19274,17225,15081,6597,10822,12935,8709,10790,10789,10886,17322,38163,42423,46681,50875,50907,52988,52988,52988,55133,59327,57246,50776,48498,50577,50577,48432,44207,48498,52888,48531,48465,48432,255},
{40539,34136,34137,34104,34137,38362,55068,42555,17298,10861,12942,8748,12941,6570,19346,29877,25652,17233,17200,15086,10632,14793,14793,16938,16906,16906,16938,16873,14890,14826,14858,14826,14826,12745,16906,16939,14826,14826,16874,16906,14793,16906,12713,16873,12712,14825,14825,12713,16873,12680,16873,12680,16905,14825,16905,18986,16905,18953,14792,18954,16873,18953,18954,14793,18953,16873,18986,18986,16873,18953,14792,16873,14728,16841,14792,14760,18921,18921,18953,14792,16906,16938,16906,18986,12712,14825,12745,12712,12712,10632,12712,10600,12680,10632,10698,12876,29649,57149,61210,61276,35954,14793,19083,16971,21229,40212,33907,35954,33841,35986,36018,38099,33808,36019,36052,38197,54871,56853,42194,27600,33940,38099,25323,16837,29549,27502,6502,25389,27502,14888,25454,27567,19148,27535,29648,27535,29647,29583,31663,33907,38296,38198,40375,65535,63487,57182,52890,50777,57149,46682,48762,61375,65535,65535,52858,40244,42389,48663,44405,21163,37741,42129,59261,48663,52921,31662,36115,48728,23308,40309,57115,27437,40309,57083,50808,50222,45703,33222,45769,54481,48502,31564,33742,40146,40081,40049,40081,35855,31727,37936,35920,46450,31662,38131,40179,17226,21453,46649,48730,44438,29648,21261,23277,25423,25455,29713,23468,10886,8741,6596,10822,8774,8677,2371,6532,6596,8742,8806,21452,42423,48762,52988,55101,55134,57214,57214,57246,52954,46483,50545,50545,46384,48497,48465,48465,48497,46352,48432,50545,54770,255},
{38362,34136,34137,34104,36217,38330,55035,40475,19379,12909,15022,10796,12909,6570,19346,31925,25652,17233,17200,15086,10632,14825,16905,19051,19018,18986,16938,16906,14890,14826,14890,14858,14858,14826,16906,16938,16906,14826,14826,14826,12745,16906,12713,16841,12713,14793,14793,12713,16873,12680,16873,14760,16873,16905,16873,16905,14792,16905,14793,16873,16873,16841,18953,14760,16873,14792,18986,18986,16873,18986,16841,16873,14760,14793,16841,14760,18921,18920,18954,14793,16906,19019,16873,18954,12680,12712,10599,10567,10599,8487,10599,8486,10600,10600,6505,8585,33808,55101,59163,57082,40048,33644,42129,40017,35856,31663,14825,21163,10664,21196,10730,21261,23341,27600,36020,38165,42358,44372,38098,27600,36085,35954,29582,29582,33840,29583,25324,33808,29550,21129,29647,23276,8517,27534,21196,8550,25454,23341,10761,25422,27534,29614,27600,59294,61375,46650,65535,65535,59295,40279,48729,63487,65535,65535,44406,33906,27698,34037,25520,12712,29290,41967,52956,40310,53052,42293,25421,48663,37968,21293,44534,40147,23373,48728,42390,54807,48175,29322,23178,50092,54741,35856,35758,42357,52954,61309,42292,42292,52759,40179,42259,50808,29614,31694,46486,31857,33970,40310,48697,48698,27664,15083,21163,25422,25422,19274,12999,10886,12967,12967,6661,8709,10822,4483,8677,10822,6629,8710,10886,38261,48794,55133,52987,50808,48695,46549,44338,46384,50513,52690,52626,31596,33772,50545,50545,50545,50578,50611,54770,56883,255},
{38394,34104,34104,34104,36217,38330,55035,40443,19379,12909,12974,10829,12909,6570,19314,31925,25684,17265,17200,13005,10632,12745,16873,16970,18986,16938,16938,16906,16938,14825,14858,14858,16874,14858,16906,14858,16906,14858,14794,14826,12713,16874,12713,16873,14761,14793,14793,12680,14825,12680,14793,14793,14793,16874,14793,16905,14792,16873,16873,14793,16873,14760,18953,14792,18953,16841,21066,18986,16873,18986,16841,16873,14792,14760,16873,12680,18953,18953,16873,16873,14825,18986,16906,16873,14793,12712,12680,12680,12680,10567,10599,10567,10567,8520,6504,27372,48534,55069,48696,52890,48566,37903,38000,37968,44307,37968,25291,25259,21033,19019,16872,19050,16904,25422,36020,40246,36053,36086,29714,27600,38165,31695,16741,21032,31728,14890,21260,33841,21293,25454,33873,29648,29615,33873,29583,25324,31728,23276,14824,27535,31726,35919,27502,44568,65535,61342,59294,52988,52989,50745,57116,65535,65535,59261,38132,38067,38165,36117,21229,12777,25423,42359,46618,17134,23602,15021,21359,42521,36052,17068,46681,42358,14922,40244,46518,48761,42325,35888,12744,42292,46551,33841,29517,35888,40211,46615,50777,46616,57246,52922,48696,48696,33938,21293,40179,44438,46616,48697,48763,48829,42456,31891,27535,19083,21229,19275,6661,10854,8774,6662,8742,12999,4516,6597,8709,4483,10855,12967,10887,31954,46682,52955,44273,46352,46319,46320,48432,50577,54771,54771,54836,50711,42225,50578,50577,52690,54969,42323,48496,58963,255},
{40475,32024,32024,34137,34137,36249,55035,40474,21427,12909,15022,10829,12909,6570,17233,29845,25684,17298,17200,13038,10632,14825,16906,19018,19018,16938,19018,16906,16939,14826,14858,14858,14794,14826,16906,16906,16906,14858,14793,16906,12713,16841,12680,16873,14761,16841,21067,14761,21034,14760,18921,14793,16841,18921,14793,16873,16873,16873,16873,14760,16873,14792,18953,14792,16873,16873,14793,18953,16873,16905,16873,14793,16873,14792,18953,12680,21033,21001,16873,18954,14761,18986,16938,14792,12679,10567,12647,12647,10567,10567,10567,10567,10599,8487,6504,35921,52891,55070,46519,50778,36019,33905,42293,44405,44406,44405,44340,46388,46355,42130,42128,37935,42096,33808,38133,40278,38133,33972,23407,29714,40213,31695,27306,29484,31663,14759,21162,29647,2243,12744,29648,4421,17002,31760,17034,23374,33841,25486,27567,31793,29680,31728,31696,33971,63487,65535,52956,40311,42358,48761,59228,63487,65535,50810,38100,40213,44439,40213,14858,29127,39724,52891,38166,33939,25520,10697,27697,33971,23276,12875,21424,29812,12843,29941,38328,44537,35596,37546,22918,35758,42130,25292,29550,29583,31695,31695,33743,31694,33872,38131,40180,38066,46583,48566,35921,42325,48697,48730,46650,46716,46748,50974,46651,14827,23375,29744,10823,8774,2404,292,4517,8742,2404,10823,10823,4516,10855,6694,13002,21424,46649,48630,46351,48464,48465,52658,54770,54803,52722,54803,54803,44372,29613,44304,50577,54869,46583,25484,29674,44334,255},
{38394,32024,31991,36217,36217,34137,52955,40507,21459,12909,15022,10829,12877,6570,17233,29812,25651,17265,17200,15086,12712,16938,16906,19051,19018,16938,19019,16906,16939,14826,14858,14826,14826,12745,16906,14858,14826,14826,14825,16874,12713,16841,12680,14793,14761,25227,31566,25227,29453,27308,29485,25421,27405,29550,21131,27372,18986,25259,18954,23147,23211,21098,18986,21034,25227,21034,21033,21066,18986,18921,21034,16841,18954,14793,18921,14728,18921,18921,16905,21067,19018,19018,16938,27405,29550,25357,23211,21130,18985,16872,12679,12679,12712,6438,6472,12843,52955,55004,46519,50811,33874,16970,25421,17036,27568,23342,27600,38197,34004,40278,38197,44471,44503,40181,38133,40278,33874,27535,23342,33907,38132,19148,12874,31728,29615,25454,33808,31728,27502,31663,31728,21162,29550,31696,16904,23309,31727,14855,19114,25454,10760,27535,27535,17101,50940,59295,46651,38230,59131,40212,63389,63422,65535,44406,40180,38100,36085,31794,14825,31370,37742,52956,36117,48763,21327,19117,50843,42457,19181,31794,38198,27601,17003,23376,29812,40311,19148,35759,43754,39854,35596,25259,27469,23407,19311,44504,38165,29713,38034,35921,27502,35889,48630,50740,33710,33840,46616,50843,48796,44636,40474,40506,33941,10729,27600,33874,25485,12935,6629,4516,6597,4484,4517,8742,4517,4516,8742,6468,6500,21453,48762,48564,48464,48465,48465,48464,54771,56851,54771,52722,56851,48401,40046,46352,52658,52690,48433,44239,35850,31657,255},
{36249,34104,31959,36249,36217,34104,50875,42587,21459,10828,12942,10829,10796,6570,17200,27731,23539,17265,17200,13006,12712,16938,16906,19051,18986,16938,19051,16906,16939,14826,16906,14858,14826,14826,16906,14826,14858,14858,12745,14825,12681,14825,12745,12713,14761,25260,31533,27308,29421,29421,29518,29744,27469,27598,25356,29582,14825,25291,19050,31565,29712,27404,19018,27404,31630,25388,31630,29647,33711,31695,29452,21066,25259,23147,23211,27339,23179,27340,18986,29420,27404,23179,25292,35954,38034,38034,38034,35921,35921,33808,31695,29582,29615,23276,12712,16971,50842,57117,52891,44504,29648,12810,23342,23341,40180,29517,35889,44406,44373,40148,40116,40245,40245,40246,35988,38133,29648,23342,21262,36053,35987,14792,6404,31695,16808,6470,31728,12841,4454,31728,21229,17067,31761,27567,27535,33841,31760,29615,33808,29615,21130,31696,25357,10599,38230,46683,36118,27731,57213,52792,52922,65503,59261,40212,31858,38230,38230,25423,18953,35694,46520,46585,31728,42359,25455,25487,42456,27633,19246,46682,48763,19182,40278,48666,44537,31664,31728,39822,44048,38296,25455,27404,27469,25553,23505,50909,23473,29779,50941,27699,12876,29745,38295,23470,29648,23276,38164,46682,44635,46748,44700,46748,27307,16938,31761,31793,50777,40211,17128,8742,10855,4549,4549,4517,4485,2436,8581,10532,8709,15148,44601,48629,46416,52626,50611,48496,54803,56851,54803,54803,56884,52658,48465,48432,52657,54706,52593,58963,58897,40141,255},
{36249,34104,31991,38330,36217,34072,55003,48795,23572,19215,23376,23376,21295,15022,15152,25619,23506,17233,17199,15086,12712,14825,16938,19051,19018,19018,19051,16938,16938,14858,14858,14858,14858,14826,16906,12778,14858,16906,12713,14825,12713,16842,12713,14793,16873,25292,31533,25227,29421,29388,29485,21325,25356,25356,27469,29679,16840,25259,25453,31630,25485,27404,18953,27501,31759,25356,31630,21195,31598,29744,29485,19018,23179,23179,23276,29582,29744,33711,16970,31630,31695,25292,29550,31793,35888,25389,33776,31792,31728,31793,29680,33841,29583,31728,25325,21165,40278,59294,55102,44439,27502,18986,23212,31696,40213,33873,44406,52858,50810,50810,52858,50778,52858,46552,35987,38133,25423,19116,23407,38133,33808,29550,29582,33841,29550,29518,33841,23211,19049,33841,14760,12678,31760,6439,6374,31761,17034,19147,31793,19180,23341,33874,27568,29616,46552,61342,48665,40213,48762,59229,50810,65535,52858,40180,33874,38296,34070,17036,14956,25521,55101,52891,57051,54938,38002,46420,48566,27470,27469,38164,38133,17035,36149,44569,44505,29193,39464,43591,43754,41870,25292,27405,38035,44439,46617,48698,31794,40310,46650,23472,21262,38197,21262,17134,17165,33939,44472,46715,42522,46781,42555,44438,39849,25357,27567,33970,50875,42356,17223,8870,8806,4613,8775,2436,2436,2436,4420,10693,8805,13035,40343,48695,48464,52724,48696,48432,56883,56851,56883,56916,56884,54771,54904,50645,46353,50545,56851,56882,54672,27656,255},
{38330,34104,31991,36249,36249,31992,55003,42554,31992,40313,46618,46585,44538,27700,13007,25553,23506,17200,15119,15118,12712,19018,16938,19050,19051,16938,16906,16906,16939,16906,14858,14858,16874,14826,16906,14858,16906,16906,12745,16874,12745,14793,12713,12680,21132,29518,31533,27275,29453,29420,29453,16872,29517,31791,21131,23276,19018,27404,25421,31630,23308,29517,23308,31598,31792,27469,33775,25421,33711,29712,31598,16937,25292,21098,25292,29550,29712,33776,16970,31598,31759,25292,23244,27502,31663,19050,29517,25486,27502,27567,23406,27535,21035,25260,23148,18955,25455,52988,55102,44407,25357,21196,23341,25487,31793,19181,42391,48697,50778,50778,50810,50810,52858,50778,38133,36020,25422,21229,27601,40213,29517,16676,23211,29582,14823,29517,29679,21228,29615,33841,27502,31696,35921,27470,29518,33873,25388,25389,31760,14790,19050,29648,2278,17036,55069,55069,48762,61277,40277,42423,57182,65535,44438,40213,40245,42358,29746,14760,31436,42262,55135,53054,50973,55134,57215,59295,57182,52859,57051,59164,44374,42163,48567,46584,38068,27307,39496,43852,41968,31305,25292,29550,52956,59327,57247,55134,55037,55102,50811,44407,29648,40311,33939,27601,17035,33938,48763,44603,42490,42587,42522,19117,12745,29648,27567,42390,44503,25580,13093,11013,10981,13062,8838,6725,6660,2467,355,2532,8869,17355,48794,52889,48432,50577,46385,52690,56883,56883,56883,56884,54803,54803,52954,46551,33807,46384,58931,52592,37996,21445,255},
{36282,34104,31991,36217,36217,31991,52923,38329,29944,40377,46682,44570,42490,38264,21360,21360,21393,15120,15087,17166,12745,16938,16906,19019,19019,16938,16971,16938,14858,16906,14858,14826,14826,12746,16906,16906,16906,16906,12745,16873,12713,14793,14761,12680,14793,23180,29453,27275,29453,29388,29518,27631,29549,29646,25324,27469,27469,33743,21163,29549,27534,31630,25421,31598,31792,23244,25356,27534,33775,27566,31630,14857,27372,16938,29582,31760,29647,33808,16938,29518,29647,29453,23244,27437,27502,21131,29518,19115,27437,23309,25422,27600,21035,25293,21035,21100,21164,52956,55037,40213,35857,42162,37969,33776,40147,33744,40245,31826,40278,29746,44503,38229,46617,42456,40278,31826,31761,25455,31827,38100,31662,29452,33775,31663,25193,31630,29517,20934,29582,27437,12613,27502,27502,16904,29647,27535,25454,29680,27600,31728,35921,33809,27437,38035,57181,40343,44471,63487,50777,44471,61342,59261,40212,33874,27568,27568,14955,20838,41610,52793,57215,42489,27731,50941,50941,34167,46748,57215,48893,50974,57247,59327,59295,57150,38036,33743,41674,41869,37807,25195,31630,36019,53087,57247,57247,57279,57279,57247,57247,55070,42358,55003,50810,23406,17001,40245,48763,42457,44603,44667,36118,4359,21197,27600,33873,50842,46517,19272,13094,13126,13126,13126,17255,15110,6756,4612,4612,4677,11014,13226,42520,55100,46417,46319,52658,56884,56915,58964,56915,56851,56916,54803,50676,42422,29647,44337,58898,48366,27657,23557,255},
{36282,34072,31991,36249,36217,31959,52923,38329,31991,42490,44570,44570,42490,42490,40377,29812,23473,17199,17102,17166,12744,16938,16905,16970,16938,16906,16906,14825,12777,14825,14793,12778,14793,12745,14825,14793,14826,16874,12745,16873,14761,14793,14793,12681,14761,23180,31533,25227,29421,27308,29485,25486,29549,29646,29549,31760,27501,31759,27501,33743,27663,33743,27663,31630,31792,25259,23178,29614,33808,27534,33743,16970,29485,16970,29582,31792,29582,33840,19051,29485,31825,33711,21228,27405,27437,27470,31663,19083,29518,29745,27502,27632,23147,27373,21003,25228,16938,55036,46650,25487,23439,29746,31859,42358,38197,36084,40278,38165,42358,42293,44471,42358,46519,42358,48665,38034,29648,23375,36021,35954,25388,25388,31760,29582,31727,35921,33840,31695,35922,31695,29550,35921,27501,25225,33808,12745,16971,14889,10696,29681,38067,21195,17003,46584,63423,44438,48697,48794,57116,48665,63455,52858,40180,29714,36117,29779,12810,14890,29714,46682,50909,46682,44536,57215,48730,33972,52989,50876,27730,42489,55134,34135,38361,55134,36052,40181,41739,31859,25488,23276,33808,29713,34134,55167,44700,44700,57279,51006,53119,46617,40343,38424,42554,12938,25454,46617,42423,29874,38359,42522,19182,6503,25455,27534,42390,50809,38096,15143,13127,15207,13094,13094,23530,19273,6724,6724,8837,8901,11110,8904,32020,57214,52757,48432,52658,56851,56883,56915,56915,54803,54835,54803,54771,46484,37934,52658,54639,40076,25606,27750,255},
{36314,34072,31991,42522,36281,29911,55003,40442,31991,40377,42522,44570,42490,42457,40410,38330,38297,40344,40278,36053,31762,33842,33809,33841,35857,33776,33809,31664,29519,27438,25326,23278,21165,21165,25261,23213,21133,16971,14891,16906,14826,16874,21066,18954,18954,27438,29453,25227,29453,27307,29485,19082,27372,16937,27469,31759,27469,31695,27534,33776,23341,31598,27534,31630,31792,29517,27501,27502,31695,29647,33840,16937,29453,16905,29517,29711,27405,25324,21131,25292,31760,35824,19050,31663,33937,29518,29615,25389,29582,27600,29583,27632,25260,23180,21035,25260,14761,46616,40278,19083,19115,14858,19149,27600,14954,19149,14988,14988,19214,19214,25487,21327,27730,25585,34004,31892,25521,27601,36053,33808,23209,21130,33776,14694,19017,33808,23112,23210,31760,19050,27469,33841,25389,29680,31728,6407,17036,6438,19050,40245,33874,27404,25356,52955,63455,57116,61310,42358,42391,55036,63487,44438,38099,38198,42489,31827,16938,27438,25391,31370,27763,23571,35793,34005,32152,42392,46715,46780,44537,53054,50908,33940,44602,50648,35368,41609,43689,41935,27406,25356,29518,33808,33840,33938,33841,33971,42489,29843,36248,42391,29779,15150,27730,6631,36084,42487,27661,17225,19306,23534,8616,17003,27535,29647,48729,46551,25450,15175,15239,17255,13030,8838,10918,10885,10885,8805,8869,11045,15270,15207,34132,52987,48498,52658,54771,54803,56851,58996,56916,54803,56883,56883,52690,52626,52657,52592,44205,25608,25637,25702,255},
{36249,34072,34071,46715,38362,31959,52891,40442,32023,36184,44602,44570,44570,42457,40377,38297,38297,42522,46682,42490,42522,44570,44570,46618,46650,48698,48730,46618,40279,40247,38135,34007,29847,33975,44343,42264,29911,21525,17266,19314,21394,31729,50613,50613,46452,29681,29453,27275,29453,27308,29485,23372,27405,16905,29517,29711,27436,29614,27534,33807,25421,33711,27599,31630,27599,31598,31792,29517,31662,29614,33872,23243,31598,16937,29485,27599,27372,21033,25259,23179,31727,35888,21163,31663,31889,31663,29679,29550,31727,23309,27470,23406,27405,21067,23115,23180,14761,36019,36052,35987,40180,38068,38133,35954,33809,33874,29551,27535,23277,23309,19018,23342,21294,23342,21326,17069,25521,31827,40214,31695,29581,31695,33808,29550,31695,33841,29484,31630,31728,21000,29549,31663,16709,25356,27503,8454,14857,4227,27501,40245,27567,21294,40180,59197,48762,50908,59294,50777,44471,61374,59229,40212,36020,40375,40376,23375,23277,42261,31697,14792,31664,23212,18791,25358,17102,25097,31696,29974,35890,33777,27862,38231,46552,31794,35564,43657,41674,39496,23113,27405,31728,29647,31727,29614,29582,29582,31662,33743,31727,33938,27535,29712,19212,10856,34034,27693,19239,15079,19240,10854,10823,23404,25485,36018,48696,38065,17126,21515,19368,21417,12966,8741,10821,12934,12967,6660,4644,11013,17319,19399,27919,40211,46351,54771,54803,54770,54803,54738,54802,52690,54771,56883,54771,54803,52592,42028,31755,21477,27782,29863,255},
{34169,34072,36152,50876,40442,31991,50810,38329,32023,36184,44602,44570,44570,42457,40377,36217,38297,42490,46650,42457,42457,42489,44537,44569,46617,46650,48730,46585,38166,38135,36022,31894,29846,38135,42263,40216,29879,19412,15185,17266,21426,31794,50710,48630,46582,23375,18954,18986,21067,25228,29485,27630,29485,14889,27437,27631,27469,29647,27501,31727,25388,33743,16970,29485,23341,29517,23341,29517,27534,29582,33873,25421,33743,16905,29485,29711,31598,25323,27372,21098,31695,35953,23276,31631,21196,31630,31792,31631,29647,29615,31760,27632,29615,18954,23180,18987,16874,23310,27470,25325,25358,25358,25390,27536,25455,27601,23440,27666,36020,33907,33972,33972,36052,38100,36052,35956,29714,31892,40181,29548,21096,27501,23179,10533,29583,23276,14824,31728,27534,25357,33873,31728,29615,35889,33841,31695,33743,29549,31760,38100,21131,8615,44471,63455,46551,42326,44569,52988,52923,65535,52858,40180,29713,36215,31924,17003,27665,35922,16841,19018,39953,29518,14858,31729,27504,12680,31793,38133,21066,29518,27537,25195,25130,17134,31567,37611,21295,27503,25292,27437,34069,31827,33808,23407,21262,31728,31761,25454,31695,29614,29614,27565,15015,19305,23466,19304,12966,12967,19241,8708,12934,15078,15047,27663,42357,27498,17191,17256,17191,12966,12902,8741,10854,10886,6661,6564,6627,8901,15239,19367,21448,40274,50545,54771,54803,50641,52722,54771,56915,54835,56916,58996,56883,50479,42028,33771,23558,27815,29895,29863,255},
{34136,34104,34104,50876,42522,31991,52923,40442,32024,38264,46650,44570,44570,42457,40377,38265,38297,44602,48762,42457,42457,42489,44537,46617,46618,46650,48730,46585,38134,38134,36022,29813,33974,42295,38135,38167,29879,19379,15153,17233,17200,31761,48468,44242,40081,16972,6375,8423,6408,16809,31533,27630,29485,16905,27339,16905,23211,21163,19018,21131,19018,27372,19050,29485,23340,31598,25421,29453,21131,29550,31824,27437,31695,18986,27404,23340,33711,29744,31566,19018,31662,35985,23244,27437,29582,33775,31824,31631,27502,29582,29680,27535,29648,21002,25260,18954,21067,21132,27373,27341,25260,23179,23147,25260,21034,19019,10600,10664,25422,23276,19149,14988,23374,35953,33874,42294,38100,36021,35954,29646,31662,33808,29517,25259,33808,25259,20968,33776,18888,12581,31728,12679,12679,33873,17035,27568,35987,23407,29680,27600,29680,33776,50810,59327,57116,61342,42325,40278,57214,65535,44406,42261,42326,40311,27568,14858,29681,19279,6503,23504,27731,10860,17166,36183,29682,12810,31599,33680,12712,29583,38003,16906,23310,31761,16873,25357,31729,25357,27404,29582,35921,33840,33808,29615,29615,31728,29811,27633,31728,19213,19276,21385,15078,19271,21384,15111,10885,17159,15047,10821,10821,8773,10789,15049,31726,17062,10981,17223,15079,10822,6629,8709,8678,10822,8709,10725,8612,8901,15239,21511,25607,29901,50709,52690,52690,52722,52690,48464,54738,58996,58996,59028,52624,41996,33804,23558,27781,27783,23557,21478,255},
{36184,34104,34104,48795,42587,34072,55003,44634,36216,38297,44602,44570,42490,42457,40377,38265,38297,46650,48762,42457,42457,44537,44537,46617,46617,48698,48730,44537,38134,36086,33941,29781,42263,40215,38135,36087,27766,19347,15120,17201,17200,29681,48468,46355,40049,16972,8423,8455,8455,16809,31533,25550,31630,29743,29485,18920,27405,25389,23147,23146,25356,31630,19018,29453,27598,33711,23373,29517,23211,31598,29744,29582,33873,21066,25292,27566,33775,29744,33711,19018,31630,33969,25324,25324,31728,35888,27631,33744,31857,31630,27599,27502,29712,23115,29453,21035,25261,16906,23244,21099,21099,21099,21067,21099,19019,21099,14728,10630,31695,29582,19116,14890,25422,35888,33775,38100,42293,38133,31728,17001,25356,31695,19049,25356,33841,23341,29615,33873,27535,31695,33873,29517,29549,31728,8487,31794,27568,8617,21196,6535,12844,40246,59229,42456,44634,59294,50745,44439,63455,59229,40212,35987,29713,29680,14923,22821,39463,23017,16710,35498,21035,4293,23179,25487,12745,10762,23571,21198,10762,23440,21067,8551,31892,36085,12777,23211,33679,23212,31663,27534,31728,38001,33776,31662,31662,33743,33808,31695,31728,23373,21321,17191,21352,17190,17158,12966,8740,15079,8741,10822,12903,12967,10854,19178,12806,8740,8869,13095,10918,10854,10854,8742,6630,10854,10822,8548,6499,6820,17351,23624,25672,27753,36273,52724,48431,50511,52624,54737,56850,59029,59029,54738,42060,35917,17286,25734,27750,21477,19366,10948,255},
{36184,34104,36217,48828,42555,36184,61211,52955,40410,42457,42490,42490,42490,42457,40377,36216,38297,46682,50810,42457,42457,44537,44537,44569,46617,48698,48730,46585,38134,36054,31828,33941,42262,38102,42263,36055,29846,17266,15120,17201,17135,31728,48467,44274,40049,16972,6375,8455,6375,8455,12713,10665,14858,17100,16906,16841,16906,14858,16874,18922,21196,27502,16906,25260,25422,29583,14793,27405,29712,29582,29711,27372,21131,25260,25259,27566,33808,25421,33711,19050,31630,33937,29517,21163,31695,35986,27534,33776,29712,33743,25454,29583,31890,25228,27373,21067,27373,18922,21099,18954,18986,19019,16906,14793,14793,18954,16840,12679,27470,35954,21197,14890,25454,40114,31727,35954,46487,42294,31695,27436,29582,31663,20967,25291,29550,10404,23243,27438,8356,25389,27470,12744,29648,21164,10600,38100,19051,12810,19051,4390,21230,46584,63455,44438,40245,59262,55036,52923,65535,52858,40180,29714,31859,23342,10664,31663,44081,39496,35433,41642,35271,29062,39463,29127,16678,33320,33387,14631,23114,25261,6439,8584,17135,10827,6536,23407,25390,27437,31696,33907,33907,50876,31826,29681,44407,27568,25454,33776,31728,27533,23401,21352,23497,19271,17191,15079,15078,17127,10789,10758,12903,12935,8741,10758,6531,6627,8805,8901,8901,13031,6661,4516,10887,10854,6628,4419,2499,8933,17351,19431,23592,29898,25737,38288,42061,39915,46220,48333,48398,50577,52625,42093,35981,19366,17316,27783,21413,17253,13028,17254,255},
{34136,36217,40410,50908,44699,40409,55035,48795,42457,44570,40409,40377,44538,42457,38297,36184,38329,48762,50810,42457,42457,44505,44537,44537,46617,46650,48730,46585,36053,33973,31828,36021,36022,36022,42263,36055,29814,19346,17200,25489,21263,29648,44275,42194,40082,16940,6343,10536,8455,12648,8455,2213,8584,15117,8519,8551,8487,8551,6374,6374,12843,14956,10631,14793,4423,12713,8519,12745,10664,14826,19116,14826,14826,18954,21066,19051,25357,16971,25325,19018,27437,27664,29518,21099,31663,33906,31695,35953,29679,35888,29679,33743,29777,29454,25261,25228,27341,18955,16938,19019,21099,19051,16906,18987,16906,16906,25225,10534,27502,38066,23309,14858,25390,44372,33907,29648,44471,40180,23276,23275,31728,27502,25389,33841,31728,29582,33841,31663,27372,33808,29485,20935,31728,21130,23309,38067,12680,12712,12679,4261,27568,52891,63487,52858,44471,59262,50745,57181,63455,44438,38099,38198,40343,25521,17035,27730,38100,37546,25553,33940,43755,42163,42261,41707,35466,39660,39529,33191,39464,35271,16580,33223,33418,8485,18856,27405,21164,27437,33907,44667,52989,55102,44569,46649,50908,33939,21197,40213,19116,14954,21322,21384,21417,10886,15079,17159,19240,8708,10822,12902,8741,8741,8709,6628,6564,6628,6661,6692,6723,6724,6758,4679,15050,8774,354,354,2595,13126,17383,19463,23656,23623,27784,31913,36013,37868,39883,41995,39883,35723,35853,29803,21511,15203,21542,27815,21446,17221,12996,10916,255},
{34104,36184,36249,42587,44635,44602,46682,38361,40377,48730,42489,38296,44537,42457,38264,36184,40409,52955,48730,44537,44505,44505,44537,44569,46617,46650,48730,46585,36021,33973,33909,33941,29781,38102,42231,33974,27734,17234,17200,21327,25487,33841,42162,44210,40082,16907,6342,10536,12681,14794,8455,6470,10633,15052,6407,8519,8551,14857,4326,8487,15053,14989,6438,12745,6471,10600,4357,8520,4358,12778,19344,8487,8551,10729,17002,10827,17069,2278,12681,12776,12746,10600,12746,12778,14891,19214,14859,19084,17036,23245,19116,23310,21294,25358,23181,25293,27374,25228,16939,23180,23212,21099,21067,21132,16906,16874,27307,8454,19115,38067,25423,19051,25389,40114,29682,29583,44439,35922,23210,21129,31727,16840,12646,31728,10696,8584,33809,14857,19051,33841,19181,27503,33874,29647,33841,35954,31728,33776,33776,29550,35987,57149,63487,48730,52923,61310,65535,63455,59229,40212,38100,44504,42457,19150,27535,40213,25325,25291,36019,29616,33515,38198,36118,39627,27568,25683,43853,37872,36020,43885,39724,39887,39723,33287,39529,27177,23244,29485,25585,27764,51006,38329,27830,53086,44667,44667,40246,44537,42358,23341,23403,23466,12998,10886,8709,12967,15047,8709,8709,8741,6596,4484,6596,6564,6531,6532,8612,2403,8643,10787,8935,6923,10824,10822,2467,2499,4676,13126,19431,21510,21543,19399,23591,31913,31849,31884,37997,35884,35885,33933,23593,19397,19396,19428,23622,23623,17253,15173,15141,10949,255},
{34071,34071,36152,44635,42555,44603,44602,38329,40377,52923,42457,38264,44537,42425,38264,36184,42489,52987,50810,44537,44505,42457,44537,44569,46617,46650,48730,46585,33973,33973,33908,31828,25620,40182,42263,33942,27733,17233,15120,23441,25488,33842,44242,44242,42162,16907,6342,10536,6375,12713,8487,8551,8552,10729,6407,10632,6439,12712,6439,10633,8682,12778,6438,12713,10729,10633,8616,10665,14923,10730,17166,12745,14922,6439,12745,6504,12746,6472,14794,14921,14794,12809,12680,10631,12908,19376,6439,10697,6472,12713,4294,10601,4262,12681,10536,12681,12681,12714,10601,16907,16907,14826,16939,18987,14826,16874,25228,10470,12712,35986,21229,21229,25357,35921,38001,31695,35987,31728,33775,33808,33841,31663,31663,33808,25292,27372,31728,20968,23179,31695,8485,21131,27502,8484,25389,25422,6599,27600,27567,17100,33906,61342,63487,59197,55004,52890,65535,65535,50777,38099,31826,36182,25618,8649,33841,40018,16873,21099,39985,23245,19083,46487,33842,19018,33972,29714,27242,35987,31859,35564,33841,29909,41838,40018,36182,25390,27405,29550,33808,35954,40278,31794,31892,46747,29811,29908,40310,31955,34068,19244,23465,19304,15078,10886,8741,17160,10854,8741,6628,4516,4451,2371,4484,6564,4452,4451,8644,10789,19176,21191,17095,17226,21354,15015,6692,4643,8869,13126,21544,23623,19462,25641,25608,31912,33961,29800,29801,29833,29864,23622,19428,21509,23589,23589,21509,23622,19398,19367,13062,8837,255},
{34039,34104,36217,42522,44667,44603,42522,44570,40377,44602,40409,38264,44505,40377,38264,36184,46650,55035,52858,46585,42457,44505,44537,44537,46617,46650,48730,44504,36021,36054,29780,25620,25620,33942,42231,33942,23573,17233,19248,29779,21294,35921,42194,40049,42130,16907,4294,12649,10568,14794,6407,8486,6439,10631,8552,12810,6406,12713,4358,10632,6471,12713,8550,12680,14987,12778,17198,10665,14988,8552,12778,6439,12778,6439,12713,6471,12713,8584,12745,14922,12745,14956,12745,17003,8650,14956,8584,14826,8552,12746,6504,12714,6504,10601,10569,10568,12682,10536,8487,10600,12681,10600,10568,10633,8488,8520,33744,25196,10536,31761,21197,23310,27438,27502,38066,31695,33775,33775,31662,31662,31695,29615,29582,38001,42326,46454,39983,35856,35986,29648,27567,31760,31696,29517,33841,27470,21065,33841,19018,8518,29647,55035,65535,61407,52890,40245,63455,63455,44406,40148,40245,38230,17069,14923,31892,33842,10567,15021,29616,14728,23407,40115,23114,16938,37905,29454,12745,40050,33745,16874,42326,38101,23082,40213,36085,23309,29517,31695,35953,31695,27469,31663,33776,31695,33776,33873,48663,33839,27567,27532,23465,21385,15047,10854,17159,12966,10822,8741,6564,4516,8677,8677,8709,4452,6500,14950,14950,23434,23434,17095,17031,19209,19209,15047,10854,10820,8836,13093,21543,25768,21575,17350,21511,29864,33993,31912,29864,27751,25670,23589,23621,25702,23621,25702,21541,25734,25735,19398,8836,4644,255},
{31959,36216,36217,38329,48860,46715,48763,52923,46650,42522,40377,38232,44537,42425,38264,36216,48762,55003,50778,44537,42457,42457,44537,44537,46617,46650,48730,44537,36021,36053,31828,25588,25620,31861,40150,31862,27668,17233,17167,17134,21262,33808,42194,40049,38002,16907,4262,10568,8487,14794,10600,10632,12745,14858,10633,14826,10762,14891,8519,12713,8584,12713,14954,12680,12842,14891,19344,8552,12745,6504,12778,6471,12745,4358,12681,10794,14827,17231,12777,14922,12811,17101,6439,12746,8584,14794,8552,14826,8552,12746,10698,10633,12778,10568,14762,10536,14762,8488,10600,12681,14793,14761,12680,10633,10568,10600,27503,18858,12649,31729,21197,23342,38002,31629,12809,29647,50646,46485,48468,42194,46355,40048,44175,46355,50810,52859,44142,35756,21226,10694,4421,4422,6471,8616,10729,21228,25488,25455,33809,35921,33808,44503,65535,61375,46519,35987,59261,61277,40212,42325,44438,36020,8584,27014,41642,25065,14662,33451,29356,12647,27536,35956,14760,15021,29714,16841,17133,38100,25163,14922,38002,29454,12713,40115,33810,27405,31663,31728,35921,31630,29615,31728,29518,29550,29582,40180,38228,31694,27469,29612,27693,19242,8774,15047,15047,10822,8773,6628,6596,8709,6596,4484,4452,2404,17128,23434,17096,19208,19176,12902,19209,17096,19209,12870,8677,12902,12901,10981,15238,21575,19495,19431,21542,27815,29896,27783,25703,23622,27815,25734,27815,25735,25702,23654,23622,23622,25703,23591,17254,10949,255},
{31926,38329,40442,38362,42522,48828,61276,55003,48763,46682,38297,38232,44537,42425,38264,36184,48794,50874,48698,42457,42457,42457,44537,44537,46617,48698,48730,46617,33973,38101,31860,25588,25620,35990,40182,31861,27700,17168,17134,21295,14956,29615,42162,40081,37937,14795,4262,10601,4262,10601,2148,6342,6699,6537,2148,6407,4359,6407,6375,10666,10828,8552,8552,10762,12811,10665,12810,10633,12778,8520,14826,8519,14794,10697,14826,14988,10665,12875,12810,19148,6504,14858,8584,12778,10794,14859,6439,12681,8519,10633,10697,8553,12778,10569,16907,10569,16875,8455,14761,12648,12713,14793,12681,10633,14794,21100,23114,12713,14858,25390,19116,27534,46552,35887,16937,23308,52759,48598,50646,42226,52823,46549,52758,38065,52759,44502,42161,40079,35821,27434,25322,23112,18888,14694,12614,16839,12680,14793,27567,38132,31793,27664,63455,63423,40213,33874,50842,54938,42293,35954,33938,27568,14630,37286,35206,14565,29029,39398,18726,18757,39497,31274,14663,35434,33484,12647,27405,33842,14761,21327,31957,10600,17165,36085,25357,31598,25390,21294,42359,42293,27535,38035,33840,29647,33808,42391,25422,19148,23406,40212,40375,25646,15048,15016,8742,6661,4516,4484,4516,4516,6565,227,2307,6629,21354,23435,15016,19241,12870,15015,19209,15015,12935,8710,8677,12741,16869,8868,11045,17350,19463,21576,21575,23655,23623,19462,17349,19429,25735,25733,25766,25735,21509,21542,23654,21541,21541,21543,21479,13093,255},
{29878,38297,42555,40442,36217,46715,63356,61243,48730,44602,40377,38232,44537,42425,38264,38264,48762,50842,46617,42457,42457,42457,44537,44537,46617,48697,48730,46617,33973,38101,35988,31828,29781,35989,38070,29813,27733,15120,15087,19313,21296,38034,40114,37969,35889,14794,6342,12649,6342,12649,2213,8487,2310,6407,2245,4294,4293,2214,6375,4359,6602,2245,6374,6570,8618,4294,6440,2278,6407,2246,6407,4327,6407,8519,4327,10601,8585,12778,6439,12746,10730,16939,8584,14794,12713,12746,12811,12714,12745,10698,14891,10730,17004,12617,16875,12649,14794,8455,14793,12712,12680,14793,12713,8488,12681,21197,16741,6341,16875,27535,19149,33840,52955,42194,21097,19018,46485,40114,50678,38098,48565,46517,50678,44371,46517,48629,44306,36017,38065,29581,31726,35920,33839,37935,37903,35822,16905,8584,14988,23406,31793,25421,52987,59164,38100,38067,42391,44438,42358,40180,25389,12810,12810,31695,39757,37482,39790,37547,27015,37449,35629,33777,35857,50485,31533,21034,43885,33451,14696,37514,29355,8454,29388,29649,25357,27437,31892,38296,55134,44602,38230,53054,36053,23376,31793,36020,35953,35953,31760,42423,31858,25518,25486,19211,15014,6596,291,4484,4517,4549,4516,2371,8677,6597,17161,23435,21290,12935,10822,19242,21354,15016,10758,8678,8645,8516,10660,8835,11076,15302,19463,21576,21608,19495,19430,17382,17349,19461,21574,21541,21541,21573,19461,21574,23687,21541,21541,23655,21543,15141,255},
{29878,38297,38329,40442,34104,44570,63356,61243,44570,48730,40377,38264,44505,40345,38232,38264,48762,50842,44537,42457,42457,42457,44537,44537,46617,48697,48730,46585,36021,40182,33908,29748,29748,33909,38070,33974,23540,15120,13039,15087,19248,38035,42162,40082,33776,21099,21034,23180,8488,10601,4326,10601,6601,8520,6407,8520,8520,4359,8488,6504,10762,2245,8519,10892,10730,4293,8488,4294,8520,10762,6439,8585,4326,8520,2182,14794,12712,12778,8552,14794,12907,14858,8649,12746,12810,10633,10665,12843,17036,15119,17102,15118,16972,10537,12714,12649,12681,10568,14826,14794,12713,14794,14826,12713,14761,21164,8389,6374,21068,25390,21197,35954,57182,46486,25323,23340,44404,52791,52791,52726,52791,50678,52758,46419,46452,50678,42258,37903,33742,37935,33709,38000,33807,37968,35855,37935,25291,4293,4423,8681,31924,33809,42390,52825,40212,42293,40245,25585,17296,36053,33874,10600,21066,31729,41804,42033,31958,42000,44016,36085,44472,52924,46748,48828,44407,48698,52989,35955,35955,52728,29551,23212,46063,29355,27405,27438,21229,34005,48796,23538,40474,48893,36281,38198,29615,27535,29615,29517,29582,36019,29648,25454,29648,27532,29735,17126,10790,4484,2404,4484,4517,2372,2404,2372,8711,12936,15049,10823,10823,10823,10823,8711,8710,6533,6501,8613,10725,6723,8963,15270,19463,21576,21575,19495,17382,17382,19429,19494,19461,19461,21574,19493,21541,23654,23654,21573,21574,21574,21543,15173,255},
{31991,40410,38297,40410,34104,48730,63323,59163,46650,50810,40345,40344,44537,40344,36184,38264,46682,50842,42489,42425,42457,42457,44537,44537,46617,48698,48730,46585,38101,38101,29748,27668,29781,35989,42230,36022,21459,15120,15087,17168,19248,35955,40082,40082,33744,23179,23212,25325,12649,6375,4326,6407,6569,4262,4262,6537,8650,2214,10601,8617,12811,4326,12713,10925,12778,8486,8520,6374,10730,17166,4262,8455,10859,12810,4327,14794,8487,12713,8552,14794,13005,12746,10697,12713,12810,10665,14858,6504,12746,13038,17005,13136,14827,12682,12649,14762,10569,12648,12680,12713,12681,10600,14793,12713,12713,29419,14597,10569,23213,23277,23276,40180,59262,52825,29549,19147,33873,46485,44405,48598,42356,50678,44437,50710,46549,50711,48598,40048,33774,37967,35855,38000,35887,37968,33774,33774,31597,12679,8552,6536,21327,33841,25518,38197,38165,40278,38165,34038,25684,31892,23213,12550,37285,43624,43591,45802,43820,43689,45998,33745,52989,50908,29778,42488,53021,29909,38329,52989,40474,44700,48666,48763,50941,27470,27372,31760,35922,42391,42392,33712,44602,40279,19149,21229,25488,25554,27569,29582,33906,42294,31794,27502,23341,35979,33926,27623,21318,8676,4517,2436,4517,4453,195,2308,259,4453,15049,12936,8679,4517,6630,6598,6630,4485,4452,8613,8548,4610,8964,15270,17383,21608,21575,19495,19462,19494,19494,21575,21574,19493,21574,21541,21541,19460,23654,23654,23687,21574,21542,19365,255},
{34071,42522,38297,38329,38264,52955,61275,57083,46650,44602,40345,40345,44505,40344,36184,38264,46682,52955,46650,42457,42457,42457,44537,44537,46617,48698,48730,46585,38101,35988,29747,27668,29748,38069,44278,36022,23508,17168,15087,17168,17167,40148,44275,40082,31664,23211,21099,23276,12714,6407,4326,4359,6472,4294,6407,6471,8584,4357,8520,6504,10633,12843,10633,8585,8553,8552,8553,10633,10698,12778,8552,12713,8650,12779,6440,14794,4326,12713,12875,12713,8617,10665,12843,10665,14891,6505,14859,8585,14827,8585,12779,12843,12681,14762,10569,14794,10536,14761,14761,14793,14793,12681,12713,12713,14858,27241,12581,10569,21198,44308,37936,46519,59230,55036,33775,18985,23308,48598,40212,50678,46485,48598,42324,48566,44372,48598,42324,40081,31629,35855,31662,35855,35823,33775,33774,33710,33710,21195,8551,67,4390,23372,17000,12905,12873,12907,15020,42099,46586,27569,14728,18726,41446,45639,45607,45639,45639,43590,45607,42066,57215,55069,50778,55101,50876,36020,48763,50844,27601,42457,55102,31989,25618,27437,29518,31663,31662,29615,33807,33808,33938,36019,35889,29582,27502,25488,27567,29582,42391,46650,29681,25390,27564,35977,31783,27590,19205,17090,14980,6597,2404,4485,227,4485,227,195,8678,15049,8711,8678,12904,6598,2436,4485,8710,8580,4419,2594,8964,13190,17415,19495,21575,19494,19462,21575,21575,21575,21574,21542,23687,21574,21542,21541,21573,21574,23655,19461,19461,19462,255},
{36184,46780,38362,36217,42490,55035,59163,57083,40409,40377,40377,40312,42457,40344,36184,36184,46650,55035,46650,44569,42425,44505,44537,44537,46617,48698,48730,46552,36021,33908,31828,31828,33909,40150,44311,31862,23540,17168,15087,17167,19215,40148,42227,42163,31663,23212,21099,23244,14794,10601,10729,8520,8519,6439,8520,8551,10600,8616,8520,2278,8617,15086,6374,8520,6407,10568,2246,8488,10730,8552,4327,8488,8552,4327,8488,16875,8552,12713,8617,12778,17036,10665,14858,8617,16939,6471,12714,4359,12681,6440,8553,10666,10569,16843,10568,16875,8488,14793,12681,14761,14794,12713,12713,14794,19052,18921,12680,10536,14893,44406,50582,52891,59229,55004,40082,27501,29711,44404,40146,48598,42291,46517,35920,42227,38066,40179,40179,29646,35887,35952,35887,33807,35887,35887,35855,33742,33742,25323,14792,8453,8550,25453,23274,10661,14855,6469,8616,33549,50811,31697,10600,27340,41609,45639,41837,43722,45639,45769,41642,48665,55102,53054,57215,57215,57215,59295,57215,57182,55004,57182,53021,44439,29583,31630,29680,31761,42293,35922,27502,33776,31662,31630,31663,40177,46418,31598,14921,25519,46650,40279,27535,21229,31693,38089,40167,38085,31748,29700,21347,10787,6628,6563,259,2340,195,162,4453,8711,10791,8710,12968,8743,2437,6630,10823,4484,2435,2595,11045,17350,21576,19494,17382,19494,21542,21574,21575,19461,21542,23655,21574,21574,21574,21574,21541,21573,21574,19429,19461,21606,255},
{40377,46780,38297,38329,50843,63355,59131,57083,40409,40345,40377,38232,40377,38264,36184,36216,46650,46682,44569,44569,42425,44505,44537,44537,46617,48698,48730,46552,35988,29780,27667,27668,35989,44278,42230,29781,23540,15120,15088,15119,17167,40115,44308,44276,31696,25325,23244,23277,25325,23212,21099,23244,21132,21067,23180,21099,21067,18987,21067,16874,16906,16971,14793,10601,4358,8520,4358,8552,13005,8585,6471,6504,10730,10762,12844,10763,10666,12875,10698,12811,12779,10665,14859,8520,14826,12746,16940,12746,12746,12746,10665,16907,10569,16875,10601,14794,8455,14825,14761,12681,14793,14793,10632,12746,21197,8520,8585,6408,14925,38100,50712,57117,59262,59230,46453,23340,19213,38099,38066,42292,44372,42324,42227,31824,44372,35986,44372,31727,33839,29743,33775,23340,31694,31792,33743,33742,33742,33742,31662,31629,25323,27534,33873,23307,19146,10662,10663,19082,46422,27406,14793,39822,35498,33255,41870,41609,41511,41935,37808,55102,42424,44602,55102,44635,48828,55102,53022,53054,55167,55167,57247,50876,27470,29550,42424,44602,55167,38166,27633,50844,38198,34004,40147,31825,31792,23340,12840,29744,27729,25455,23341,21196,27532,36008,40231,38118,36006,33896,21285,17093,19207,14983,6533,4388,195,2308,6598,2340,4388,4419,2500,4582,2437,4549,6661,2403,354,4707,11045,15270,19496,17414,19462,21575,23656,21607,21574,21542,21542,21542,21542,19493,19461,19493,21573,21574,21574,17413,21541,23654,255},
{44602,46715,36184,46683,57148,65435,61242,59195,40377,40345,40377,36183,40344,38264,36184,38264,42489,40409,44537,44537,42425,44537,44537,44537,46617,48697,48730,44472,35988,29748,25587,25587,38069,44278,42230,29781,19346,15088,15088,15087,19247,35987,38067,38068,29616,25389,23277,23309,27470,23309,21196,23309,23277,23212,23277,25358,23212,23244,23309,23244,23180,25325,27470,16875,10632,14761,10632,14761,12875,10665,10697,6439,10568,13038,12844,6666,10666,8844,6569,10763,8488,6472,6407,8488,6439,10601,8617,10666,12908,10666,8553,12682,12649,14762,14794,12682,10568,14794,14794,12713,14794,14826,14762,14826,21165,8520,10601,6408,19183,31826,50745,57182,59262,59262,52825,27436,16937,31760,46518,44405,46517,42292,46453,42227,46453,38033,46453,31695,33807,27468,33742,27468,31662,29614,31630,25290,23145,25258,25258,25291,23210,18984,25487,33873,25487,19050,17001,19049,35564,16809,23342,42391,25423,16938,44406,35857,18920,35629,42261,57182,46617,46683,46748,44537,48795,55134,42423,48763,55135,44602,48828,38101,27404,25357,23570,38393,48893,32087,46747,53086,44732,42456,44504,31891,29810,17032,19209,23435,15016,15018,17066,21320,25510,23397,27589,38087,33864,33869,23403,19210,17097,19178,10727,8647,8614,8646,6566,2275,4291,4483,2532,6661,4613,4549,4581,355,2498,6820,11077,15238,17350,19495,21575,21575,21607,21606,21574,21575,21574,21542,17381,19461,21542,21606,23654,21574,21542,19493,21574,19493,255},
{52923,52988,36184,44570,59196,65499,63322,61275,40409,40377,40377,36151,40344,38264,36184,38264,40409,40377,44537,44569,42457,44537,44505,46617,46617,48697,48730,44439,33940,29780,27667,27635,40117,42165,42198,29781,19314,13040,15087,15087,21328,25586,19444,17169,19150,19117,19116,19149,21230,19149,19116,19149,21229,19116,19117,21262,21197,19084,19117,21197,19084,17004,19149,19149,17003,17004,16971,16907,12745,16971,16971,16938,16906,14891,14859,12713,19052,14956,19117,12779,8520,6472,4262,8487,4359,10665,6538,10666,10796,8618,12844,6376,10601,6343,16908,10601,10600,12681,12713,12681,10600,14794,12714,14827,14859,6440,8521,8553,23408,27633,50811,59230,59263,59262,57117,35855,14889,19116,46485,40212,46485,33872,46453,36018,44405,36018,42292,42325,33872,29614,29646,31662,29614,31662,29582,29549,29615,33872,35888,33775,27436,23178,25422,38132,27500,19113,21225,14921,29388,14761,25585,29779,10534,14988,31956,23180,17068,33874,50843,50876,44602,38198,17166,40375,36118,25715,44601,42489,40441,48763,50876,29583,27372,29549,29484,38132,33875,17002,42489,33973,13038,29779,34006,25716,29810,23433,21320,15046,10821,12870,14982,23428,29732,23426,25474,36037,31783,19208,8775,17098,17065,17098,12840,8647,14953,8679,2372,130,6371,2499,2564,6725,4612,4580,2499,450,4707,11045,15206,17350,17382,21575,19494,19494,21607,21541,19493,19494,21542,19493,19461,21542,23686,25767,23654,23688,21575,21574,19493,19429,255},
{55036,59293,38329,38297,48762,63355,65403,55035,38296,40377,40344,36151,40344,38264,36184,38264,40409,38296,42457,44537,42457,44537,44537,46617,46617,46649,48730,42359,33908,31828,31828,33876,38069,40117,40118,29781,19314,13040,15087,15087,21328,25619,15381,23507,17037,17036,14923,14924,17037,17004,12843,17037,19149,14956,17004,19149,17037,17036,17036,19117,17004,10666,14956,8650,12778,12810,14858,10665,8553,8617,8617,8552,6504,8617,8584,6504,21294,25652,36184,19086,10600,12714,8488,12714,8520,12713,6407,12843,17166,6440,10633,8456,12682,6376,18989,10569,14859,12714,14826,14794,12681,12714,14794,14891,10601,2214,8488,12811,25521,31794,55036,57182,59262,59295,61343,42195,21130,14857,42325,33841,44372,35953,40179,38066,36018,44340,40244,44373,33873,29581,25453,29614,25453,31662,23405,29549,8551,2311,6569,23407,25486,10729,21260,31823,21225,21257,19144,12775,14890,18986,33548,23115,8487,27307,31631,16775,23341,31859,57182,38198,34134,29812,17133,34102,29779,15052,34134,29746,17134,44667,36086,25357,29517,31696,33776,33775,31662,33743,33840,33743,29484,40147,31630,19018,19146,25547,19239,10854,12901,23462,29700,29764,31843,25538,23394,23362,21314,8673,323,8710,15017,10792,10759,6534,10759,6534,4389,2179,4387,2563,4644,6756,8837,8805,8836,8836,10980,15238,15270,15270,19463,19494,17413,21574,21607,19493,19461,21574,21574,21542,21574,21605,23686,21573,23687,27916,23720,21574,19461,17316,255},
{53020,63454,48795,38297,42457,57050,63323,52923,38264,40345,38264,38199,40344,38264,36184,38264,40409,38264,40377,44569,44569,42457,46617,46649,46617,46649,48730,40246,33940,33941,29747,35988,40117,42165,42198,31861,17234,13040,15120,15087,21328,29747,19216,23473,14924,14924,14859,12811,14957,14924,12811,14892,17037,14924,12844,14957,14957,14892,12844,17005,14891,10698,17037,4423,21261,23374,25455,25422,21164,21229,21196,19116,14922,14890,12810,12745,21294,23604,34169,25554,8521,10569,23180,10600,12714,10698,12746,10731,12876,10698,14859,10569,14795,8456,18988,10601,19085,10633,10666,12714,10633,10633,12714,21165,16842,16810,14794,17037,27569,38165,57117,57116,57149,61375,61375,46518,25323,16906,38066,44405,44405,46452,44405,44340,40179,44405,40179,44373,29582,31662,27436,31662,27469,31662,27468,29581,16872,35,100,14922,14825,12808,21161,23306,23370,25419,21194,16968,17003,31695,23146,14826,21196,37837,21034,23245,48435,48600,55101,42391,38296,21295,27698,34004,21263,19149,27698,12810,17166,36215,27568,29518,35921,27601,42456,44504,27633,44439,35954,29647,33776,35984,42257,31662,27563,19272,12934,12933,25542,31845,31844,23458,27683,25539,31844,21283,17123,10820,4483,4419,2338,4420,4452,4485,6598,4485,4486,4355,6627,8804,10917,17224,12998,10917,10917,10884,11012,17318,19430,17350,19463,19462,23687,23656,19462,19429,19461,21574,21606,23654,23654,23686,21573,25801,32108,21575,19494,21542,19461,15237,255},
{50940,63486,50940,36249,46585,65403,63290,48730,38264,40377,38232,36151,42392,40344,36184,38264,40409,38264,40377,50810,48762,42457,48730,46617,46617,46649,48698,38166,31860,31860,27667,40117,48406,38037,40118,27733,17234,13040,15088,15087,21328,27667,19216,19248,14892,14924,14891,12811,14924,14957,14892,12844,17037,14924,12843,14924,14957,12811,12811,14956,12843,10731,14989,4359,14923,17036,19181,21229,17035,17035,19116,19116,17035,14922,12843,14891,23407,21425,32024,29748,8456,14762,25260,6439,12713,4423,10632,4359,6439,4359,2279,4359,2246,12682,16875,10633,19085,14794,12714,12746,12746,10601,10633,25359,18956,23181,18956,33809,27568,46585,57149,57117,48729,59295,59295,52858,27469,19083,35986,44340,38098,46485,40243,44405,31792,44373,33906,42325,42325,33840,29549,31694,31630,31662,29582,29581,25291,68,68,17068,38034,31661,27498,27498,25386,25387,23275,19081,19082,38001,35823,27437,29582,35920,31695,38035,59196,59196,57083,35954,10828,14956,21294,21360,12843,27666,29779,16939,38133,36085,25357,29517,31924,42521,55134,44667,44602,55167,44537,36053,31695,23341,21325,27534,25483,17191,15078,27654,38182,33923,27618,29731,19233,23426,27653,17093,10789,8677,8645,8645,2339,4420,4355,6499,386,2499,419,4579,17191,10885,8773,10918,12998,8772,6692,4611,6723,13030,17094,13158,15302,19463,21575,21575,21543,19462,19461,21542,23655,25799,23685,23686,27882,29996,21575,19462,19462,21607,21607,17317,255},
{44634,61406,44635,36184,46617,65531,63322,46682,38264,40377,38232,36119,42392,42392,36184,38264,40377,38264,40377,52954,48762,44537,50810,46617,46617,46649,48697,42294,33908,31828,33908,44277,44277,38005,38070,27701,17233,15088,15088,15087,21328,29747,19280,19248,12811,14924,14891,12811,14892,17005,14892,12812,14957,14924,12811,12844,14956,14924,12811,14956,17005,12811,17004,8585,12874,21261,25455,25455,19115,23277,27535,25389,19116,14955,14923,17003,25520,19214,21393,23376,6376,14859,25292,6407,6504,4391,8552,2311,6472,4359,4359,4359,2246,8520,8553,6440,8553,10601,12714,14859,12779,16907,14827,25391,18956,23213,27472,48633,29616,55004,59230,57149,57084,59294,61375,57117,33743,21260,29745,44405,29711,46485,38164,44405,40211,44405,40179,42292,42293,35986,27469,25421,29614,23405,29614,23406,27469,6341,68,2311,25485,33805,25353,23273,25355,27500,25386,23272,12774,29646,42227,33841,31629,46486,50744,50743,55002,59228,54937,27503,12745,17003,25227,16808,21002,25194,14728,25455,42293,19084,27405,29485,27437,31793,42424,25552,38327,44602,32054,31956,31793,40375,38100,17034,19178,23434,19242,19238,33989,33955,27618,29763,29763,23458,19236,8709,6596,10789,8645,6565,4452,6500,4291,8579,2530,2595,4643,6755,12998,8806,6692,4612,10918,12934,10821,4676,8901,12965,14950,13190,17350,19463,19462,21607,21542,19430,21542,23655,23719,25766,23686,27882,27915,25769,19462,21574,19494,21575,21574,19462,255},
{44602,59293,42554,36184,52825,65530,63386,48730,40344,40377,38232,36119,42424,42424,36183,38296,40377,36216,40377,55002,50842,46617,52922,48697,46617,46649,48698,40246,33908,31828,42229,40117,40117,40085,35989,27700,17234,15087,15087,17135,19248,27699,19248,21361,12811,14924,14891,12779,14892,17005,14892,12811,14956,17004,12811,12811,14924,14892,12779,14924,10763,10730,12811,10697,10697,19148,21294,19149,14923,21229,23407,21228,14955,12810,12810,12842,25520,17133,25619,23343,8488,19052,27438,8552,8552,6472,8552,4359,6472,2279,4359,4327,2278,4359,134,2246,134,68,4327,10666,8553,17004,12713,10633,4327,23181,35955,48665,40180,57182,52955,46519,59229,61343,61375,57182,40114,19050,16970,44373,44405,48598,46485,46518,42324,44405,42260,38066,44372,31759,33743,27469,31695,25388,31662,27469,29582,14760,36,133,19113,27466,23273,19016,27501,29709,21193,21225,14854,19211,40212,31695,33742,52889,40244,46550,50777,57115,44373,19084,21164,19083,31468,37676,35563,33613,37872,38066,44373,29518,31565,40115,33841,27568,25487,27503,33906,33874,29550,29582,40079,31727,25390,14888,33906,31890,17195,17191,29766,31845,29795,29796,25540,25570,17090,8675,6629,8709,4484,2372,2339,2307,6339,8644,4611,6756,8836,8772,10885,12998,10886,8773,15046,19175,12965,6852,8997,11045,13125,15270,17350,17382,17382,25802,21543,19430,21542,21575,23655,23687,27914,27882,21608,19462,19494,23655,23655,17382,21542,19462,255},
{46715,59294,42554,36184,61242,65531,63354,48730,38296,40377,38264,36119,48633,42424,36151,40376,40409,36216,42457,57115,50874,48730,52922,48729,46617,46649,46649,38101,33908,29748,33908,29747,38037,48470,29781,25620,19314,13039,15120,15087,19215,21393,23441,23441,14924,17037,25390,19149,17004,17069,17004,12843,14956,14956,14924,12843,14924,14924,12843,14956,4359,2278,4359,8552,12842,19181,19181,17068,17068,19149,19182,21197,19148,19116,19084,14923,21327,17101,27732,21230,4295,23278,31599,10632,2343,6504,6504,4391,6472,2279,6439,4327,4391,4391,2246,4359,2214,4294,6407,6472,12779,19117,19020,10633,10633,31827,36052,44472,54971,52989,40277,42292,57148,61343,61407,59230,46486,25356,25486,40244,42325,42357,44405,38163,44340,29745,46485,36019,44405,40212,33808,29614,33775,29581,31695,31630,29582,23211,68,101,21228,35983,27499,25420,25451,25450,19080,19080,12742,12840,23406,25454,40212,57082,50712,38066,50776,54970,33744,14890,21196,25260,35628,39788,33450,42195,52890,48599,48632,48631,48599,46551,44438,35889,14662,12680,23375,19181,21294,31891,31922,21228,27502,33775,40311,31892,12935,17159,21383,31878,31908,31876,29763,23458,17123,4418,161,291,2371,6596,6596,12869,12870,10854,12902,10853,10886,6661,6628,6659,6723,10884,19207,10981,6819,6883,8996,11109,15302,17383,17382,17382,19495,25803,21543,19462,19494,21543,23655,25833,27882,23656,19494,19462,19494,23655,25767,17382,17382,21542,255},
{46715,55101,44635,38264,61274,65531,61242,48730,40344,40345,40344,34039,52793,44504,36152,40377,42457,36184,44537,57115,50842,46649,54970,50777,46617,46649,46617,36021,33908,29748,29715,29747,42165,50582,33909,25588,17233,15087,15120,15087,17167,15054,15054,15054,17134,15054,40180,35987,19149,10697,10664,4327,2279,2247,2246,2247,2215,2247,2247,12713,4423,4358,4359,10633,12810,21229,19116,19116,19084,17035,17003,17004,16971,14955,14923,12842,21326,14988,29812,25358,14729,27438,33712,14761,4391,10600,6471,6439,8520,4391,8585,4391,8552,4423,4358,4359,2214,4326,2181,4326,8520,14956,19052,4359,12747,31827,42424,57085,52858,50876,46650,46551,52923,61343,61407,61375,52858,29549,27631,36083,48631,40309,48630,42324,48566,38034,46485,38066,46453,38066,33840,29711,23340,31759,29809,31663,25421,29549,4293,100,10728,31725,27499,19112,21193,21224,16966,12774,8549,6469,12775,12839,29745,54969,59163,38099,44437,46519,23278,17003,19084,29420,39788,37675,33548,46551,50777,48632,52857,50777,48664,46551,46551,42196,20903,18790,16840,23342,19148,25520,27503,19083,31859,42391,44537,29810,15015,10822,17096,21383,12996,27685,29828,19300,12933,8707,4515,2370,10789,12902,15015,12967,8741,12934,15015,8676,6629,4483,290,2403,2465,6691,10916,8900,6884,8996,11077,11109,17383,17415,15334,17415,21609,25770,21576,21543,21575,21575,23721,27882,25801,21575,19494,19462,19462,21574,23687,21542,15301,19430,255},
{40441,46715,44602,40377,61275,65499,59130,50810,42457,40344,40344,34039,52793,46552,36151,40344,40377,38232,44537,57147,48762,48697,57050,50810,46617,46617,46617,36021,35988,35989,31796,31828,40085,50518,42198,23540,17201,15088,15088,15087,17167,17167,15022,12974,15054,17135,38100,38101,19149,6471,8552,8552,4359,3,36,3,3,3,2084,29451,6471,2310,4391,10665,8617,17068,17036,17036,17036,17068,17036,17068,17068,17068,19116,19116,21294,17101,38198,38166,23376,31599,35856,16873,2181,10568,4262,8519,6439,6439,10697,8617,10600,4327,8520,6439,6407,8488,4262,6342,2181,8487,8553,19052,21134,31892,29778,46584,48632,61277,52857,42359,50810,59262,61375,61375,59229,37936,23275,25422,42292,36051,42325,38131,44405,33873,40212,42325,42325,42324,25454,33742,27436,33775,27534,31695,25388,31662,14728,68,14919,33772,27498,23240,23272,23272,14822,8517,10597,10629,10661,14919,21323,48663,59195,40212,44405,35954,14891,19083,21163,33548,33548,33482,33646,50745,48664,48632,52858,52858,48697,50745,46584,50712,29451,23080,21065,27534,25422,29648,35954,31728,40310,46617,46650,27567,21259,21225,21228,21292,14983,27685,27686,19271,8772,15078,12933,15046,15047,10853,10821,10821,8741,10854,6628,4516,8677,6596,4419,4451,6498,4610,8867,8964,11077,13157,13157,13222,17382,17382,15302,17415,23690,23689,19495,19462,19495,19495,25834,25802,23720,19462,19462,19494,21543,19494,19494,21574,19494,15269,255},
{38297,42522,44570,42457,57083,65436,57082,52890,44537,40344,40344,34039,50713,44504,38232,38296,40345,38232,46649,57115,48762,48729,55002,52890,46617,46617,48697,36053,35988,36021,31795,31796,46326,46358,40118,25588,17233,15088,15088,15087,17167,17167,15054,17102,12941,21296,31795,33908,19182,10698,12745,23310,8520,101,133,133,101,68,8487,31629,6472,230,4359,10633,12778,25390,21197,19116,19116,19116,19084,19084,19083,19084,19051,21197,21294,19181,40343,38265,15055,31632,35889,23147,6342,12648,6342,12648,8486,8422,8455,4229,10535,2116,8455,4229,6310,6374,2148,6374,2116,8455,6406,14858,23343,29811,29648,46518,46518,55068,55069,42358,52955,57116,57149,59229,61375,42194,23178,16904,33742,29517,25323,25389,21196,27502,27567,27567,27568,29680,33809,29582,25388,29582,27469,31695,29550,29582,23211,4293,25418,27530,33836,27498,23272,16935,19080,16935,10629,14823,19081,21193,21258,42325,57050,50711,46518,27503,16970,19083,27340,35595,23081,29387,42163,50712,48599,52825,52890,52857,52858,50777,52890,52890,42194,35822,35855,33807,35921,33841,40245,38066,38132,44569,40246,25422,25454,29614,23342,25488,23466,27719,27751,21381,6723,13029,17159,15046,10853,12966,10821,6596,8676,6629,10822,8677,4516,4484,6532,4451,6499,6626,6819,8963,13157,13157,13189,15270,17382,17382,17383,19463,23690,21609,19495,19495,19527,21608,23721,25769,23688,19461,17381,17381,19462,19462,19494,19462,21574,19430,255},
{36216,42489,46682,48730,61308,63356,59130,54970,44537,40312,40312,34039,50713,42424,40312,38264,38296,38264,48729,57114,52922,52890,54970,52890,46617,46617,48697,38133,38068,33908,31828,38004,46358,40117,40118,25588,17233,15088,15087,13006,17167,15054,12974,15054,15022,23376,33843,23473,23408,25521,23408,17101,14567,12486,2214,2278,4326,2214,8487,27501,6504,2246,4359,14826,6504,19149,16971,14923,14955,14955,14923,17004,17068,19149,19116,17003,12842,19214,34005,34104,12909,31664,33842,25293,4262,12648,4262,12648,4262,12616,8455,8455,10568,6342,12648,6374,10568,10568,8455,10568,6309,21001,35692,29516,31663,31761,29681,48599,48631,46650,46650,36052,40376,48762,48697,52857,63455,46453,35822,33774,44339,50613,46452,46387,42194,42129,40081,35822,31565,27436,31630,25324,25356,21162,23276,19082,21195,25389,29517,14823,23305,25450,27562,23273,19080,21160,19080,19048,10662,14823,21162,21194,23339,36084,52824,59196,48599,16971,19083,21164,31467,39789,35595,31499,48632,50712,46518,50744,54970,52890,52858,52890,55003,54970,50711,40081,42225,44339,44405,46485,44437,44405,36019,38197,29648,23342,25454,23309,25455,29650,27657,25607,21445,17219,19332,19334,12966,10821,12902,12902,6628,8709,6564,6596,10822,6596,4452,4484,8677,4484,6532,4482,4738,8996,13157,13157,13189,15270,17383,15302,17383,21576,21609,21576,19463,19462,19462,23689,23689,23688,21606,17381,17349,17382,17382,19462,19494,21575,19462,19462,255},
{36184,42425,50843,44570,50842,63356,61211,54970,44505,40312,40312,34039,44472,40344,38264,38296,38296,38232,50810,59195,57114,55002,54970,54970,46617,46617,48698,38101,33908,33908,29715,38036,35957,35957,40118,23540,17233,15088,12975,12974,17135,17167,15054,17134,14989,23408,25554,14956,25489,27699,17167,14956,12519,12454,2246,2278,2246,4294,6407,21197,6471,2278,4391,14924,8617,23374,21197,21197,21261,21229,19149,21196,21197,21197,19116,23341,25422,17101,25618,32023,12909,29552,29649,27372,12616,16777,10470,16776,6309,14696,6310,10535,8422,6309,10535,2148,12616,4262,8487,6375,6342,21163,52757,50743,59030,42227,31761,48599,48631,36020,50810,33972,27698,34037,44471,48631,61374,52825,35855,31727,38098,46518,40211,48566,31760,48566,36018,46485,40212,42292,48566,40147,33774,33872,31662,27468,27468,23340,31662,14791,19080,29642,23336,21160,16935,19080,16935,19048,14887,14855,21193,19081,17001,21358,46583,59163,40148,16938,19115,23211,35628,37708,33514,35725,52858,50745,46518,48664,54970,52857,50744,54938,57083,57083,57018,46419,48532,44306,46517,52824,48630,46519,40213,33906,23342,23374,29615,21229,27601,19116,27719,25638,19333,21508,23525,10948,8774,10854,12935,6628,6596,8709,4388,4452,10854,4516,2371,4484,6596,2339,2307,4418,4706,11044,13157,13189,15269,15269,17415,19495,17382,23657,23689,21576,21576,19463,19462,21608,25801,25800,21574,19462,19462,19462,17382,17381,19494,19494,17349,17348,255},
{36152,40344,57083,48730,52890,65436,59163,52922,42457,42392,38231,36086,40312,38264,38232,40344,38296,38264,52890,59195,57115,57082,57050,52890,48697,46617,46649,36021,31828,31828,33876,35956,40085,38005,40118,23507,17201,15088,13007,12974,15054,15054,15022,15054,12941,17135,23441,25456,27634,23441,17134,12907,14859,8585,2213,2214,2214,2278,4391,27535,8617,198,2278,6505,2247,10698,8585,8617,8650,8618,8650,10762,12811,12811,12875,17133,21327,19149,12908,17232,8780,25390,33777,31631,12680,12648,10600,16874,8487,18954,8519,16873,10567,14728,14729,10536,16842,10567,16874,10535,14729,23244,42259,52823,59096,40114,27633,40278,38197,31826,57149,36020,21165,35922,54872,56985,61309,59197,38000,29581,27534,50679,36051,48598,46485,48598,44340,46485,44307,40179,46486,36018,35888,29776,33807,23438,31727,17002,25421,25291,17000,31755,27530,21192,16935,19048,19048,23243,16968,14855,16999,17032,17001,12874,36116,54969,23342,19083,21164,29387,39756,35595,33482,37839,52858,50744,50744,52792,57116,59229,52889,54970,57115,57083,54937,40113,40146,38033,40178,48664,50744,44471,40245,29648,25422,27535,29582,23342,31729,21164,29769,21446,17253,21445,17220,6723,10886,10854,10822,10854,8709,6597,4452,4452,8742,8710,2404,6597,6597,4451,2275,4451,4706,11044,11108,13189,15302,17350,19495,21543,21543,25770,23689,23657,23657,21511,23624,25769,25800,25799,23687,21573,21606,21542,19429,19461,19494,17381,17381,17381,255},
{36152,38232,61243,61243,63388,65500,52890,50778,42425,42392,38199,36119,44440,38232,38232,38296,38264,38264,55002,59195,57114,57082,57082,50777,46617,48697,44537,33908,35956,38069,40084,35924,40117,38005,42198,23507,15120,15088,15087,12974,17103,19215,15054,15022,14989,25424,27602,23408,27602,21328,13039,8650,12811,10698,2181,2213,2246,68,2149,25423,4458,199,199,4360,8489,19150,14956,10763,12844,12779,10731,10731,10699,10666,6537,8554,8586,8618,6505,6473,6505,23246,42130,33712,6439,12713,4390,14858,4391,17004,4456,12778,8520,12810,12745,6472,14826,6439,19019,6472,21067,27535,35986,54903,55002,48663,25488,23440,21262,23407,50843,46584,50712,57083,57017,59097,61244,61342,42194,35822,31694,48598,44340,50679,46550,46518,46518,42324,46485,31825,48566,38164,33840,29549,31727,31630,29582,31630,29549,31598,8518,27531,27530,23338,23241,16936,21162,29614,23274,16967,14855,19081,17001,10727,25616,38132,19051,19115,23244,33515,39788,35627,35595,33548,46486,50777,54938,57083,59262,63487,57116,59164,57115,57083,48631,40146,31662,35921,38132,44536,44472,40278,40278,25487,25423,29647,27568,27633,40245,27502,38127,23528,17253,15204,10979,8867,12997,10854,10887,10822,4516,2404,8710,8709,10822,4484,4484,4484,8710,6564,4387,2402,6819,11044,13189,13189,17350,17382,17349,19495,21575,23722,23689,23657,23656,25672,25736,25768,25768,25767,25767,23686,25767,21574,19494,21542,19494,17381,19494,21542,255},
{34071,36152,59195,52922,63388,65531,50810,46618,42425,40312,36119,38199,50713,38264,36183,38296,38264,40344,55034,59195,57114,57082,57082,50777,46617,48697,44472,31828,33908,33908,35956,33876,42197,40085,42198,21459,17201,15087,15087,12974,15054,19248,19247,17134,17102,27602,29682,10828,29682,23344,37,37,12810,12810,2213,2213,2246,101,2149,25422,4457,199,232,4328,4327,12876,12876,14956,12876,12844,12844,12876,12941,12909,12812,12812,12876,12908,12845,12844,10796,19085,42130,27438,2246,14826,4390,14826,6504,14923,8649,10697,12778,6601,14923,4327,14794,6407,14891,6569,21131,29649,31794,52789,52889,54937,27568,25488,23375,23375,42359,46584,57149,57181,54937,59065,61243,61342,46485,35855,27501,42324,40212,38131,48598,38131,50711,46550,50711,44437,48631,46518,40179,35855,35920,35823,31695,35888,31662,35855,10535,12840,23305,21193,23307,14855,16969,27599,33872,27565,12775,19081,17001,10727,19210,19116,21164,21164,27307,37708,37708,37676,37676,29387,33906,50777,54938,57083,61375,61342,57116,59196,59196,59228,44372,37968,33742,38066,40246,40213,42391,46584,38133,25422,27503,29615,23342,40376,44667,38098,40242,19304,8868,13061,17285,19365,10979,12998,6694,6629,4484,4516,6565,8710,8709,2372,4484,6564,6564,4452,4354,2466,8867,11076,13189,15237,15301,19462,19495,21543,21575,23689,23689,23657,23657,25736,27816,23687,25768,25767,25767,25767,25767,21606,21542,19494,19494,19494,19494,19494,255},
{34071,36152,59163,54970,63355,65499,52890,44537,40344,38231,38199,40247,52825,40312,36183,38296,36216,40376,57082,59195,57114,57082,57050,48697,46617,48697,44472,31828,31828,25587,25554,35956,44245,35957,40118,21427,17201,15120,15087,15022,17135,17135,15022,12941,14989,31729,38035,14989,36019,25488,2214,2214,14956,10697,2181,69,101,36,101,19116,2312,199,232,2247,8456,14859,10666,8617,8585,10666,10601,8553,6505,8585,8521,6505,6538,8586,6473,6505,8586,14924,40050,23245,2214,14826,4423,12778,8584,12907,12907,6569,14891,4488,16971,4294,14761,8584,10730,10730,21164,31794,29649,52790,59195,59130,35986,25521,25488,25455,25553,44504,57116,59262,46551,48598,52857,61375,52825,37935,31694,38034,50646,44404,50678,40146,50711,42324,48598,35953,40179,42260,25422,35920,31986,31727,10696,29582,31824,33840,21066,2277,17064,23305,29516,25387,23274,23308,31792,29678,17000,17001,17002,14952,23372,19083,19116,25357,31468,39789,37708,37676,37676,27308,23342,50744,54938,54970,52890,57148,61309,61309,59228,52857,40146,33775,40114,40213,39986,37905,44471,48730,31729,25423,31728,25390,27633,38361,29843,31855,25581,6661,2500,2532,13093,19397,10978,10949,8774,10855,4549,2436,2371,2372,4517,2404,10822,8677,2339,4355,4386,2562,8899,11076,15269,15269,17382,21575,21575,21543,21576,25738,23689,23656,23656,25769,25736,23655,25767,25767,25799,25799,25767,23655,19493,19494,21574,21575,21574,21542,255},
{34039,36151,59162,65435,65435,65530,59162,46650,40344,38231,38199,42359,52825,38264,36184,38264,38232,40376,55034,59194,57114,57082,52922,46617,46617,48697,42424,31828,31828,29715,27635,40117,38037,35957,40150,21427,17201,15088,15055,15022,17103,19280,12973,12909,23376,40115,38035,21262,40180,29714,14989,19116,17036,8585,133,4,4,3,101,14923,232,199,232,4296,12746,17005,14892,10763,12779,14860,12811,10763,12747,12780,12779,10698,10667,10699,10698,8586,10634,17004,35857,21100,4262,12778,6504,10633,10697,10795,14956,4488,17004,4520,12746,6375,10600,12777,6569,14858,23277,31794,29649,50645,50776,59062,40113,25488,27601,33907,27601,38295,55036,61375,46551,44373,50745,61407,57116,40048,29549,27469,50679,33873,48598,33873,42292,48631,44470,50679,42325,50679,40180,35888,29614,33807,27404,31662,31727,29647,29517,133,165,12906,40212,33808,31760,33840,31825,35953,25322,14888,17035,14922,12873,21196,17003,29485,39854,41901,39789,39789,39821,21067,21197,48631,52857,57116,54937,55003,61309,61341,59228,46453,40113,40114,40179,40277,46419,44439,46617,42391,27534,23405,25486,21261,34005,38166,23499,15111,8805,8774,6693,2468,4580,8804,8803,386,2467,4613,4548,4581,6597,2404,6597,4517,4516,6629,2436,2371,2434,4708,11012,13157,15302,19462,21575,21543,21543,21543,21543,23657,23657,21544,21544,23656,23655,23655,25735,25799,25799,25799,25767,23655,21574,21575,21575,21542,19494,19494,255},
{34039,36151,61242,65531,65499,65530,57082,50778,42457,38231,40247,42392,48665,38232,38232,38264,38232,40344,50842,59195,57114,57082,50809,44537,46617,48698,42424,31828,31828,29747,38004,44245,35956,38005,40118,19379,15153,15088,15055,12974,15054,15054,12941,12941,23441,33907,25488,14989,42294,27634,21263,21294,14988,6504,2213,4,4,36,69,10698,232,199,232,2183,6440,10633,8585,6473,6441,6473,6473,6506,6441,6505,6506,6474,6473,8586,6538,8554,6506,17069,35825,14826,6374,10665,10665,6440,14826,4521,17036,4521,14988,8617,10633,12680,8519,17003,6602,16907,29583,35955,29681,38131,40309,52822,42226,25456,31795,40246,31892,38231,42358,55036,46486,44405,52858,63455,59230,33808,31695,33775,48598,52792,52824,50646,50679,50711,48598,50711,40179,50711,31663,33775,31662,33775,33743,29549,35855,29549,33743,8486,100,165,19148,29615,10728,19179,19212,29679,27436,6406,12810,19084,14890,27666,21196,33581,37741,37741,39789,37741,35694,18954,23244,44405,54970,63487,59229,57083,61309,63390,57083,42259,38000,42292,35954,42258,42225,46649,46617,27629,21321,12966,15047,17129,23567,27760,21386,17159,12934,6693,4581,291,323,355,2435,354,354,450,4644,4613,2468,355,324,2469,2468,2436,2468,419,2531,6820,11045,15269,17350,21575,21542,19462,21575,19494,19462,21576,23656,23656,23624,23623,25735,23655,25767,25798,25799,25799,23687,23655,21574,19494,19494,19494,19462,19462,255},
{34039,38199,63354,65531,65531,65499,48729,54970,46617,38231,38199,42392,40344,38232,38264,38264,38232,40344,48729,59195,59162,57082,50809,44537,46617,48698,42392,33908,33908,31795,42164,40117,35956,38005,38070,19347,15121,15087,15087,12974,15022,17167,12941,12973,19215,25521,29714,19182,36052,21392,14988,23310,8552,6439,4326,4294,2213,4294,4261,8585,200,167,2280,4295,14891,14923,16972,16972,16907,12778,12779,14827,12746,10666,10666,10634,10601,8553,8553,8521,6440,17102,31664,10633,8520,6472,12778,4359,14891,4488,14923,8714,10730,10698,8584,16939,6471,17004,8682,19019,46485,52824,33874,10730,4423,25390,23310,23375,33940,42359,25520,36150,46552,48664,44406,42260,55003,63487,52924,27502,25389,27502,42293,44439,44439,46519,46519,46519,48599,48599,50712,48664,50745,44373,35856,37969,37969,40049,38001,37968,37936,23178,19018,16937,23244,21131,12839,10726,8614,19114,21163,6407,10600,21197,14954,17196,38035,39952,33613,37806,37774,37774,31533,21067,31630,42293,59228,63487,57116,59196,59229,63422,50679,40146,38065,42292,35987,31758,40179,46616,36050,21353,15078,15078,17191,10885,10885,15047,21353,17159,10853,6661,323,2404,2404,2436,2436,2275,2402,2530,4708,6821,6789,6757,2500,6693,4644,6693,4612,483,4675,6884,11077,17350,21575,21543,19462,19461,21575,21574,21575,23655,23688,23656,23655,23623,25735,25735,25767,27847,27879,25798,23654,23654,23622,23654,21574,19494,17381,17382,255},
{34039,38199,61242,65531,65531,59227,44505,57050,48698,38232,38199,42392,38231,38232,38264,38232,38232,40344,48729,57114,59162,57114,50777,44537,46617,48698,42359,31828,31860,38004,42164,38004,33876,40085,35989,19347,17201,17200,13007,15022,15022,19280,12941,17102,19183,25553,31827,19183,33874,17134,14923,21229,10664,10632,8519,8584,8519,10664,10697,8585,199,199,2312,2182,10665,8586,10666,10699,10666,8618,10699,10699,10698,8650,12779,14859,12811,10699,12780,12811,10698,19215,25391,8552,14793,6439,14826,4295,14891,8649,10697,12778,6569,14858,4423,14923,6536,14891,10697,19083,50678,63256,44306,12778,23112,23178,21033,25423,38134,38166,17069,25552,46650,40213,44471,44471,57181,63487,44439,27469,25389,31728,46487,46487,44438,44438,46486,46487,46487,46487,46519,44439,46520,38003,29550,29550,27469,29550,29550,29550,29550,29550,44438,48631,46486,44340,33839,10694,8614,21293,25324,12712,10665,21197,14953,6599,40408,44472,23343,44440,29616,38100,33842,25357,25389,38132,57051,57149,55003,61342,59228,61277,44372,38001,46485,38066,31825,27566,42357,31855,21321,19207,17126,17159,15078,10821,8772,15079,23498,17192,12934,6628,2436,4517,323,259,291,4227,2371,2595,4740,8965,11045,8933,6853,4740,4708,4740,4708,4708,6820,8964,11077,15270,19462,19462,19430,19429,21575,21575,23655,21607,23655,23688,23688,25735,25735,25767,27847,27879,27879,25799,23687,23655,23654,25767,23687,19462,19430,17382,255},
{36119,36119,57081,65531,65531,59227,42425,52825,52858,40280,38199,42392,38232,38232,38264,38232,38264,40344,46649,55002,59162,59162,50809,44537,46585,46617,42327,31796,29748,42197,35956,35924,33844,40085,38037,17299,17233,19281,15055,17135,15022,17167,14989,17102,17134,17167,23440,19182,38067,23343,12875,17036,10600,6471,6439,8552,6471,6471,10632,10632,6439,6471,14826,6376,17036,14859,12747,14859,14858,12778,12746,12778,10665,12746,12746,12746,8618,6505,6473,6505,6472,17134,23441,29845,31893,19313,6602,2279,10665,4424,17004,27437,19051,25389,19116,14891,8617,10665,12746,21196,48565,52723,40080,14890,52692,50677,56786,33808,38134,31795,17036,29648,38133,40278,46585,50778,57149,61407,35987,27469,25389,38034,46487,44439,44438,46486,44438,46487,46487,46487,46519,44439,44439,31696,29550,29518,27437,29517,27437,27437,25324,31760,36019,38100,38100,38100,38132,31728,25421,19213,27469,27436,14891,19084,23309,23274,23502,25584,19310,25618,27665,34102,36019,27502,25389,35921,54904,52825,55003,61309,61341,54937,40146,40146,46518,35987,36018,33905,38130,21353,17126,21384,19271,15045,6627,4547,6660,8805,21385,10886,12967,8742,2404,291,291,324,291,4291,4547,4675,4740,11045,13126,11045,8964,6820,6820,4772,4771,6852,8964,11077,13157,15237,17381,21543,19494,17381,21574,23655,23687,21574,23655,23687,25767,25767,25767,25734,27847,27879,25799,23655,21574,21542,21574,25800,25768,19462,19462,17382,255},
{36119,38199,59130,65531,65531,63452,44537,48633,50778,40312,40247,42392,38232,38232,38264,38264,38264,40344,44537,52890,59162,59162,50810,44537,46585,48666,42359,31828,33876,38036,33843,40052,35892,40085,33909,17299,17201,17201,15087,15054,17134,17134,12941,14989,19183,23408,23408,25521,27633,21327,17036,14956,12777,16938,21099,16906,12680,12648,21132,21196,23276,23276,19085,4328,17069,17005,14924,17036,14988,14925,17005,17037,19117,23342,21198,19149,17134,14957,12779,12811,12810,19182,21426,31991,29910,25620,4555,4424,10665,198,19084,40049,27502,31794,38133,25455,8519,8486,8520,27535,48466,44272,44274,14858,52725,59162,61142,54740,52725,46354,46354,44275,40180,31892,31891,52924,61342,57150,31728,27469,27469,42293,46519,46519,46487,46519,46487,46519,46487,46519,46487,44439,42261,27469,27469,27405,27437,27437,25356,25356,23244,23244,23276,25357,25389,25422,25454,27567,23341,2276,19116,29517,21197,14890,27564,27530,21224,19112,14887,10694,14855,23439,40279,19149,19051,38001,48663,57082,55003,61309,63422,48566,40081,46485,40147,33906,31792,38163,27628,19207,23464,19303,12932,6627,6660,12934,10853,8773,15080,12968,8775,356,291,2469,2436,355,354,2466,4675,6787,6884,11078,13125,11045,8965,8964,8964,8932,8932,8964,11076,11076,13189,15269,19494,23655,21542,19462,21575,21542,23655,23654,23687,23687,25799,25767,25767,25734,25767,27848,23719,21607,21607,23655,23655,27848,27816,21575,21543,17382,255},
{38199,40279,61274,65530,65531,65532,54970,50745,46617,40312,40247,42392,38232,38232,38264,38264,38264,40344,44505,50810,59162,57082,50810,44537,46585,48698,42392,31828,33908,33875,33843,46293,33844,40085,31829,17299,17169,19281,13006,12942,15022,17102,14989,17102,14989,33907,27601,29746,17037,10795,14955,14987,17035,42193,44275,38066,29615,25454,25291,21065,38035,19149,10698,4327,12811,14859,14827,12778,10698,10665,10666,10666,10730,16971,14891,10762,12876,12844,6473,8553,12811,17134,23539,31958,29845,25619,2409,6504,8584,2311,25358,37968,23277,27601,38165,29649,14825,14792,12712,35856,50578,37999,44404,29584,48532,63355,63256,63190,63222,63190,63190,61109,54837,35986,42326,57182,61407,42359,27470,25389,29583,44407,46487,46519,46519,46519,46519,46519,46519,46552,46519,46487,35922,25356,25324,25324,25324,25291,25291,23211,21130,23146,21065,18985,18985,16937,16905,14824,21195,10758,10759,25387,21131,4359,25483,21224,19145,19145,14888,6501,12742,19082,25520,8683,23244,40114,44405,59131,54970,59229,57084,42259,38000,46517,33776,29614,29743,25547,17127,23465,19303,17158,8772,10853,12933,15111,12966,10886,10854,2468,4549,323,258,4581,2501,387,418,2594,4707,6852,11045,13157,13157,11077,11077,13158,11076,11045,11045,13125,13157,13189,15269,17349,21542,21607,21574,21542,21542,21574,21606,23687,23687,23654,25799,27848,25767,25734,25767,27880,23719,23687,23655,23687,23687,25768,25769,25769,21543,19463,255},
{38232,40279,63386,65530,65498,61275,54970,59098,46617,40280,40279,40344,38232,38232,38264,38264,38264,40344,42425,50777,59130,54970,50810,44537,46617,48698,44472,33876,33876,31763,35924,48373,35892,40085,31829,19347,15120,17168,15054,12974,15022,19248,15054,15021,17070,31795,25554,27666,25357,19117,14923,17101,19182,35921,40180,40180,31760,27502,33645,35726,35986,16938,8552,6505,17070,19085,17037,17036,17069,19085,19052,14956,19117,23310,23342,14956,14956,17038,12714,10666,14923,19214,23571,31991,29846,21394,134,6504,6472,2311,29583,35855,21196,17101,27635,31730,12712,10599,14760,44209,54771,35854,38067,27601,44372,61274,63289,63189,63190,61109,61109,61077,54838,59197,55035,61375,59262,33809,25356,23243,35922,40180,40148,40148,38067,40213,40148,42293,40213,42326,42294,42294,29551,23243,23243,23211,23211,23178,23211,19050,21130,39885,31337,18823,23016,20935,25096,20968,19113,12870,8676,10726,10664,4293,25482,21224,19080,21225,17001,8582,10630,16969,25422,6439,33808,40114,38034,57050,57050,61276,50679,40113,40146,40146,35987,38099,27660,19239,15046,19272,21384,12933,8805,21384,12933,4547,4548,8741,8774,2436,323,258,161,226,420,418,2563,4707,6819,8965,13190,15238,15270,15238,13190,13158,13157,13189,13157,13157,13189,15269,17350,19430,21543,23688,21574,21542,19494,21574,23687,23687,21606,23687,27847,27880,25767,25767,25767,25800,25767,23687,21575,21575,21574,21575,25769,27849,19495,19462,255},
{40312,42360,65434,65530,65466,54970,46585,59098,46585,40312,42360,40344,38232,38232,38264,38264,38264,40344,42424,48697,54970,57017,54938,46585,46617,48698,42392,31828,33875,27635,37972,46293,35924,40085,29749,17266,15120,19249,15054,12974,15022,21361,12941,10796,17070,27570,25456,25488,29552,27536,19182,14956,10796,27503,38068,33908,31761,31631,31565,35758,42261,23276,16808,10600,12714,12745,10665,10697,12778,12810,10730,10730,12811,14891,17036,14924,14957,12877,8618,8618,19182,23407,23571,31991,29878,17167,69,6472,4391,6472,33743,31630,21229,14924,23376,29714,16905,12680,21098,48467,48499,33774,38001,29583,38066,54968,57114,59029,59061,61110,59029,58997,54904,57149,57149,63487,52956,29615,23244,21164,40213,33907,40213,38100,40180,42293,40213,42261,40180,38100,35987,33875,31696,29550,27502,25324,25324,21131,21098,16937,25323,44209,33449,12549,14760,16742,35595,21063,12837,8677,6596,2403,2244,8519,23402,25451,23273,21225,19145,12807,12774,17001,25453,29582,40082,40114,40114,57050,59130,57083,44340,38001,44405,33840,40245,42358,29709,19207,12934,19239,15046,10820,10853,17191,10886,10821,6661,2435,2403,10855,2371,291,162,225,419,483,2627,4771,8932,11078,15238,13190,15270,15271,15238,13157,13157,15270,15238,15270,15269,15301,19462,19462,21575,25800,23687,23687,21574,21574,23687,23687,21606,23687,27847,29960,25767,25767,25800,25800,25767,23720,23655,21575,21575,23688,27850,25736,19495,19462,255},
{40344,48632,65498,65531,65466,54970,42424,52858,46617,42392,42424,40344,38232,38232,38264,38264,38264,40344,40376,46617,54938,54970,52857,46585,46617,48698,42360,31796,33875,29683,50421,48405,35924,35957,27668,17266,15088,17200,13006,12942,15054,17135,14989,19215,17069,29682,29649,25488,35955,33810,19182,10762,10763,27536,31794,27602,38100,40083,31436,29485,29714,14825,14792,14760,12679,12679,12647,12679,10599,10599,10599,10599,10599,10599,10599,10599,10600,8519,8487,8552,27634,23440,25685,31958,27798,12941,101,6472,2311,10697,37904,27469,27535,31762,17037,31794,19083,12712,21196,40179,42226,31661,39982,31662,38034,42325,44405,42258,40145,44306,38032,44306,50778,57116,57116,63487,46585,27502,23276,29583,42326,35987,42293,35987,40180,40212,38132,42293,38165,40181,31859,35987,31761,33842,33809,31761,31696,29616,27502,19051,31597,42194,41933,33514,27274,29289,33514,27304,16934,10693,6532,6501,6436,10566,10697,27564,27595,23369,23305,14887,6501,16904,25387,42259,40114,42194,40082,48663,61243,52792,42226,35920,42260,25454,25618,31892,40244,29677,19209,17159,15111,19272,15046,10853,8741,12967,6629,10854,4452,2436,226,97,129,290,451,2627,4739,6884,11076,15238,15238,15237,13158,13190,17351,15270,15270,15270,15270,15302,17350,19463,21575,21543,23655,25800,23687,23719,25768,23687,23687,23687,23687,25767,27880,29992,23719,25767,25800,25800,23719,25768,23656,21575,21575,23656,25769,21575,21543,19462,255},
{46617,50745,65531,65498,65466,54970,40344,46553,48665,42360,42392,40344,38264,38264,38296,38264,38264,40344,40344,46617,54938,52857,52825,44537,46617,48698,42392,31796,33875,35923,48373,40085,35924,38005,27668,17266,15120,19248,15054,15022,15022,17134,12941,17134,19150,33843,27537,23375,38035,40083,19149,14923,12875,27535,29649,29714,36085,31794,37905,29681,12713,10599,10567,10567,10567,10567,8487,8487,8487,8519,8487,8519,8519,8519,8487,8487,8519,8520,8487,12778,31860,21328,27798,29878,27765,10796,166,4391,4358,21196,35856,23244,33873,40212,17003,29681,21131,10599,16938,38067,44372,40047,48433,27438,40179,40213,46517,38032,44306,40113,40112,44372,52957,50810,59229,59230,38100,27502,17035,33842,25488,23407,35987,23407,40180,25520,40181,31859,36052,36020,31826,42260,33809,33841,46420,42194,35693,27274,33613,27339,35758,42097,46127,35693,33645,33547,27469,33547,29515,25321,18983,12808,16970,14824,6538,19179,29708,27564,25387,14888,2180,14824,23306,40211,42227,42194,40082,44340,61243,46453,38033,29484,29517,23310,14793,27535,46617,35987,31728,25515,15079,17192,15079,10885,6661,4548,4516,6629,291,258,291,194,193,386,515,2691,4804,8997,13190,15270,15270,13157,13157,15238,17383,15303,13190,13189,17350,17382,17350,19462,21575,19495,21607,23720,25768,25800,27913,25833,23720,23720,25735,25800,27848,25799,25767,25768,27881,25768,25767,25768,23655,23656,21575,21543,21576,21575,19494,21543,255},
{57050,50745,65434,65402,65434,59162,42424,48633,48665,42392,42424,40344,38264,38264,40377,38264,38264,40345,40344,46585,54905,52825,52825,46585,48665,48698,44472,31828,31763,38004,38004,35924,35924,40118,27701,17266,17201,23474,12974,12941,15022,19247,12941,12909,15021,29650,23408,25488,27536,25455,17101,12842,8681,21294,23375,25618,29779,19215,29778,19084,12679,12647,10599,10599,10567,8487,8486,8486,8454,6406,6406,6374,4326,4294,2214,2214,2214,2214,2181,8618,29780,21393,29911,29910,25652,10731,2247,2279,6439,29616,31728,21163,25455,35987,25455,29649,25389,19018,21131,35954,52824,44372,29485,27503,44340,44470,48532,40080,44305,38000,37999,48663,57149,52891,61375,57182,33809,27502,27502,42293,40180,42228,42261,35954,42260,29583,42228,27502,33906,23310,29615,56918,37903,29549,50613,29549,39853,22886,23145,27144,23048,27209,35627,39788,27112,29257,27209,35530,37772,31499,33742,8581,14889,21065,10601,16939,31791,29645,23275,21164,16971,19083,19145,40212,46453,42226,42195,42259,52824,44307,35823,35855,33742,42325,40180,44503,42358,29648,31729,29709,19272,12999,15112,10854,6662,6629,6726,2371,4548,4516,4515,2371,226,450,2659,4771,8964,11077,13158,15270,13190,13157,15270,17318,17351,15270,15238,15302,17350,19462,19462,17382,19495,21575,23656,23688,27881,27881,27881,25801,27881,27881,27848,27879,29928,25767,25767,25800,25800,25800,25768,25768,21607,21575,21575,21543,21575,21575,19462,23655,255},
{65435,61178,65402,65370,65402,57050,44472,54873,52825,44504,44472,40344,38264,40312,40377,38264,38264,40344,40344,44505,52857,50745,52825,46585,48697,48698,44472,33876,33843,38004,35892,44245,35924,38037,27668,19346,17200,19313,12974,15022,19216,21328,12941,12909,15021,27569,21327,23375,29681,31728,14955,10762,10762,19084,23310,38068,27666,17102,14956,29518,38035,21229,12745,12777,10665,12745,19084,12713,10632,10600,8519,6439,4326,4294,4294,4294,2182,37,69,8488,23440,23539,29911,31958,25619,10730,2279,2246,6471,29681,25487,14857,19214,33907,23311,33874,33809,14793,12712,29647,48665,44407,23083,31761,44340,40244,44338,35887,44273,31726,40080,52890,61407,61310,61375,52891,29615,23276,23309,42261,29648,42294,31794,40245,38100,40213,42326,38133,42326,36020,33841,44339,48533,46387,54839,44209,44143,35562,31531,31401,25129,27274,31402,41835,18660,23081,16678,33547,29289,14662,31694,27403,12776,31629,29386,29583,29615,29615,25389,25422,27471,25357,27533,46486,46420,35920,42259,42259,42195,40081,40081,40146,38066,44439,38164,50810,38100,29616,31729,33903,21418,15081,12967,8774,10855,4516,4581,6661,13000,6661,4580,2403,290,482,4739,8964,11044,13157,13157,17351,15270,15270,17350,17351,17350,15270,17351,17350,17350,19462,19495,19495,21575,21608,23688,23655,27881,27881,27881,25801,27881,32041,29928,27848,29961,25768,25800,25800,25800,27881,25800,23688,23656,21543,21543,19462,21543,21543,21543,23656,255},
{65531,65466,65402,65402,65434,57050,44440,59065,59098,46552,44472,40344,40312,42425,44537,38264,38264,40345,40344,42425,52825,48665,52793,46585,48697,48698,42392,33908,35956,31795,35956,38004,33844,38038,27668,19347,15120,15120,15022,15022,17135,23441,15021,12941,15021,27601,23408,23343,29681,33809,12875,10762,14955,21196,33841,35986,25554,17102,17070,35987,40279,25488,21229,21229,19117,19149,21295,19149,17101,17069,17069,17069,19149,17037,10698,10730,8521,2182,2150,21034,16906,21459,29944,27733,25619,4425,4327,6407,8552,29681,19116,12744,21197,40180,29714,27601,31728,23243,27371,42096,48697,38100,23245,35954,42324,46584,42390,42325,44405,38099,40179,52955,61375,61343,61407,46552,27469,27502,35921,46519,46454,46486,44341,44406,42228,42261,40180,35954,38100,27503,29615,33742,29615,33808,46453,54904,42259,52661,33775,50548,44177,46224,44111,44111,41933,33579,31337,33515,35498,18789,25355,23339,6598,8646,25323,33841,29615,29648,25422,25422,29583,29616,33808,48599,48598,40113,42227,44307,42194,40082,46420,42195,33840,33841,42391,48762,33841,29648,29710,23435,17161,19273,15079,8806,10887,355,355,8807,6694,6662,6694,2467,386,2595,6852,11045,13157,13190,15238,17318,17350,17350,17383,17350,17350,17351,17351,19431,19463,19463,21543,21575,21575,23688,25769,23655,27848,29897,25769,27849,29929,32009,29961,27816,25736,25768,25767,25767,25800,27913,25768,23688,23656,23656,23656,23623,21575,21510,21542,21542,255},
{65531,65498,65466,65498,65498,59130,44440,59065,59098,46552,44472,40312,40312,44505,44537,38264,38264,40377,42425,42425,52825,48665,52825,46585,48697,48698,42392,35956,33876,29683,25555,27603,31796,33909,25620,19347,15120,15087,12974,12974,15022,17134,12941,12908,12909,25489,25554,27568,40181,27536,12842,10730,14923,14923,29681,21295,23408,17134,19182,35955,33874,27568,25423,25390,33484,29518,33808,29583,23375,23376,23375,25488,23440,21327,12908,10795,14924,12519,6277,6440,12746,35955,25553,21361,21393,23212,37871,27404,35823,38002,35823,29517,37968,44406,38035,33647,38033,27403,37966,61109,36018,29681,29681,40179,42292,46584,40212,42325,38132,36019,36019,42423,61375,59230,61375,38100,27469,23309,40148,40245,44406,44406,44439,46487,46519,46519,46552,46487,44406,33875,25455,50613,50645,52726,52791,59065,52758,56952,44243,54871,50678,50678,48402,40049,50613,31662,37708,31630,33580,37870,17065,4485,2340,259,12776,27666,27503,29648,27503,27503,31696,31729,35922,44406,40146,44339,44275,44307,44307,42227,44372,44308,35888,35953,52955,48665,31728,29679,27659,17127,10854,8742,13000,13001,10855,2436,2436,2436,195,291,323,290,419,4740,11044,13157,17351,15270,15238,17383,17383,17350,17382,17350,17350,17383,17351,19431,21543,19495,19495,21575,21575,23656,23688,23655,25768,29897,29897,32041,29929,32041,29961,27848,25735,23655,25735,23719,25800,27880,23687,23655,23656,21576,23655,21575,21575,23656,21575,21575,255},
{65531,65531,65530,65530,65498,59130,42360,56985,59098,46552,44472,42392,40344,44505,42457,38264,38264,40377,40377,44505,52858,46617,52825,46617,48665,48698,42359,35956,31796,29683,29683,31764,31764,33877,25588,19347,15120,15087,12974,12974,15054,15021,12908,12908,19182,27569,29715,31794,44472,29649,10794,12843,8682,10762,21360,12974,27601,27567,25422,38099,35954,33907,21262,21164,31339,31534,40115,33776,29648,27633,27601,27536,23310,14955,8584,14890,21197,14632,18920,12647,27504,44439,33709,29581,12841,31695,48533,25421,46485,40114,50711,44372,52791,42260,52791,42259,52791,42259,46451,56916,31727,29616,31761,38099,46616,27698,44471,29811,40278,36020,38100,42390,61407,59262,55069,33777,29550,25389,42293,35922,40180,38035,38067,40148,31794,42293,31762,40213,40180,27536,21295,38099,29614,31760,31760,56952,44373,50678,52823,48630,56984,50711,56919,50645,54871,50645,44079,33483,33450,39887,21162,8548,4388,227,4324,14792,27502,31696,29583,27503,29648,33841,38035,38001,31725,40178,44307,44307,42227,46420,42227,42259,40146,42325,55101,46519,29679,23433,21384,15078,10821,4548,6629,6630,8774,2403,290,291,66,194,290,386,483,4740,13125,15302,15270,13189,15270,17383,17350,17383,17383,17383,19463,17383,17383,19463,21543,19462,19494,21575,21575,21575,23688,23688,23688,27816,34089,34089,29929,32041,29961,29993,25768,25767,25768,25768,25800,25799,23688,23655,21575,23655,23655,21575,23623,23655,23655,21575,255},
{65531,65531,65530,65530,65466,57050,40311,54905,61178,48632,46584,42392,40312,42457,40376,38264,40344,42425,40345,44505,52858,46585,46617,46585,48665,48698,44439,38036,35956,23475,44213,37972,31764,33877,23540,19346,15120,15087,12974,15022,15054,17102,12908,12941,15022,25457,23441,25488,42359,31730,14956,10762,12842,10762,19280,13039,27698,25520,23310,38132,38067,35987,29550,27502,29356,29518,27600,23342,19149,12874,10762,12875,12972,12939,19213,21391,17100,14954,12874,17003,21392,25617,23373,23438,19114,33808,50645,33807,42291,44372,46517,48533,46517,46452,48630,44372,50711,44372,48597,46385,27501,29648,33874,29648,48697,19149,40278,19149,33972,27600,29778,40245,59262,57181,46617,29582,14923,21261,35987,23408,42326,33972,42326,36020,40213,40213,38100,42294,31794,21197,23376,23408,42259,48500,46355,54904,50646,50581,50580,42194,52791,42324,52726,35888,46485,48630,37935,39821,37871,37708,33709,33677,27403,8517,14857,27403,27307,21100,31696,29583,29583,33841,38035,35920,29580,40146,44339,44307,44307,44372,44308,42227,42227,50810,57149,42325,23402,15045,19271,19239,10854,10855,8742,6629,2403,355,322,193,130,322,386,482,2627,8900,13157,15270,13157,13189,15302,17382,17382,17382,17350,19431,19463,19463,19463,19463,19463,21575,23688,23688,23656,23656,23688,25768,25768,25736,27816,31976,32009,27880,25800,29928,25768,27848,27848,25768,25767,25735,23687,23655,23655,23656,21575,23623,23655,23623,21575,19462,255},
{65531,65531,65530,65530,65466,57018,40279,52793,63258,50713,48665,42392,40312,42457,40344,38264,40344,42457,40345,44505,48697,44537,46617,46617,48666,46618,38133,35956,33876,25555,48374,40053,31764,33877,23508,19346,15120,15119,12942,15054,19215,23343,15021,12973,19215,25489,21328,23375,38101,31729,19214,8714,12810,10762,19183,19214,15184,12941,21230,31826,31827,44308,52693,46420,31696,29648,21261,17034,19115,21196,19082,17066,17131,19180,25552,21358,14954,14954,14954,10794,17229,19310,8746,6666,8714,31761,50678,33807,38001,46452,44307,52791,44372,50678,44372,48598,46485,48566,44469,42259,29582,31761,33809,29485,48632,23310,33907,27503,25488,36019,25552,40246,55004,61343,42326,27469,25324,35890,42196,33775,44374,36116,42293,27535,38035,25422,29681,33907,14956,21295,23376,21263,38002,48467,35888,44372,48532,33808,39820,31466,39884,31500,31565,33580,42031,46257,35726,37676,33613,37643,35855,31693,35952,27532,23308,21129,23016,18760,29583,29583,27503,31729,35955,40179,25419,40113,48532,44307,46388,44340,46420,42194,44373,55069,55036,38130,21319,21351,21384,15047,8742,10856,15048,4548,2435,2467,4483,193,290,387,2499,4675,6819,8964,13157,15270,15302,15238,19463,19495,19463,17382,17382,19463,19463,19463,19463,19430,19463,21543,23656,27881,21575,23655,25768,25768,25736,23656,23656,23656,27849,27848,27881,29961,27848,27848,27880,25767,25768,23655,23655,23655,23655,23656,23623,21575,23688,21575,21575,19494,255},
{65531,65531,65530,65498,65466,52857,40279,52792,63258,52825,50745,40344,40312,42457,40344,38264,40344,42457,40345,44505,48665,44537,46585,46617,46650,44505,35956,33908,29748,29683,40085,33876,31764,35990,23507,21427,15120,15087,12974,15022,15022,19150,12941,10828,12876,25456,21327,21263,31860,23375,15021,12842,14955,8682,19117,21230,21295,12973,21262,23407,25456,48567,50678,42260,33808,25454,25389,23277,21293,21261,21293,21261,21293,21294,21326,23471,21325,19213,19181,19213,27664,23439,17068,15020,19149,33874,50646,42227,42259,48565,42291,52824,44339,52759,44339,50711,44372,50711,44405,44405,31662,33874,31532,31337,33515,31402,31435,31436,29355,31533,25227,31631,48665,61343,35922,25389,21261,38068,29746,40245,36052,40213,42326,42326,44439,42326,44406,38068,14924,21328,21263,23408,44340,54805,33742,31694,50612,33644,44013,27207,37834,25096,25258,25226,33644,39756,23178,27339,23080,39788,29449,17030,15015,10790,10757,16999,21000,14599,27470,29583,27503,31696,38132,42456,29613,35919,44371,42226,35921,27535,44340,40114,48665,55069,48696,29740,19271,15045,15046,6660,6597,15048,17160,6693,6628,2435,4548,225,290,2435,4643,6787,8932,13125,15205,17350,17383,17350,19528,21576,21576,19463,19463,19495,19463,19495,19495,21544,19495,21575,23656,25736,21575,23688,27849,25768,23688,23688,23656,23655,27848,32009,29960,29961,27848,27848,27848,27848,23687,23623,23623,23655,23655,25735,23655,23623,25736,23623,21542,21542,255},
{65499,65498,65530,65498,65466,54970,40311,52793,63257,56985,52825,40344,40344,44537,38296,38264,42425,44505,40345,42457,46617,46585,44537,46617,46618,40311,31828,31828,29716,31796,33876,40085,33844,40118,25588,21427,15088,15055,15054,15022,12941,15021,12909,12876,15022,25456,25488,21230,33907,25456,10827,8682,12810,8649,19084,29616,19149,17069,21230,25456,29714,50745,40179,29647,31727,23374,23341,23342,21229,21293,23374,23374,25455,23342,25454,27567,27568,27535,25487,25455,27600,23407,19246,19214,25390,31761,48501,46485,38099,48565,38001,57017,42227,56984,40147,54904,42291,54904,42259,48598,31727,31728,37838,33385,33417,33418,31337,31305,29257,29224,29224,25063,44341,57149,29583,25421,27535,40180,27470,38067,27534,33873,29680,27633,31794,21294,38133,29713,17036,14989,19150,29681,35954,54806,31564,33710,48565,48565,44112,37578,33418,39788,39724,35530,37707,46061,33482,31467,23048,37708,27368,12869,12870,8644,4452,8677,10565,21098,31696,29615,27503,29583,36052,46683,35953,35854,44339,42258,19182,12811,40114,42227,52923,52923,38162,23464,17190,10885,15046,12966,15081,19274,8741,4581,2435,2371,6564,225,322,419,4675,8900,11045,13158,15271,17351,15270,17350,19463,19495,19495,19463,17382,19463,19463,21576,19463,19495,19463,21576,21576,23655,23656,23656,23688,23688,23656,23655,23688,23656,25768,27880,27880,27848,25768,25736,25767,25799,25767,25735,23623,23623,23655,25735,25736,23655,23655,23623,23623,23655,255},
{65498,65466,65530,65498,65466,59130,42392,52793,65337,61177,56985,42392,42425,46618,40344,38264,42457,44505,40377,42425,44537,44537,44537,44537,46618,40279,31796,31796,29748,33844,38004,48374,33876,33909,23540,21427,15088,15087,15055,12941,17102,15021,12908,12908,14989,23376,27601,23343,31859,21327,8681,10794,17101,12810,23309,31826,17036,19149,21229,25520,35954,50712,38099,40146,31728,16971,19083,12809,10631,10760,12777,12745,12809,8681,8681,12842,12875,12874,10794,12843,14988,12908,8682,21229,54772,52660,48500,46485,35953,48565,40081,56985,42227,56985,42194,57017,42259,57017,42226,52856,33774,33776,35694,18758,25292,48566,46420,44275,42130,42097,37904,35758,42260,48730,27469,25388,33808,46519,46519,46486,46486,46486,44406,44406,44341,42261,42326,38100,19117,19117,21295,23342,29681,50646,52694,50613,46388,40017,31402,24966,25031,27144,27079,27177,27274,44046,39821,33612,41804,37772,27368,21191,10757,6532,2339,6500,8420,27404,33808,29615,29583,27535,33841,38231,25455,29612,33872,46518,10698,17036,44307,46551,52923,48665,31791,21384,17159,10885,12998,10886,10854,15048,6693,6694,6661,290,129,194,2435,483,4707,8932,11045,13190,13157,13189,15270,17350,17383,17382,19463,21543,19495,19463,19495,19463,19495,21576,21543,21576,21576,21575,21575,23688,23656,21575,23656,21575,23655,23688,21575,23687,25736,25768,23655,23655,25736,23655,27848,27815,23655,23623,25703,25735,21542,21542,25768,23655,23655,23655,255},
{65466,65466,65530,65498,65466,63290,44439,54873,65369,61177,56985,42424,46585,46650,38296,38264,42457,44505,42425,42425,44505,44537,44537,44537,46618,42424,31828,29748,33908,33843,44213,46326,29716,29749,23508,21427,15087,15055,15054,12941,17102,17102,10828,10828,17102,21295,21295,25488,29779,23407,19214,8682,8682,10730,31729,25488,21197,31729,27568,23408,40114,48565,38099,46420,33808,17002,27502,17035,19083,19147,19148,21164,21195,21260,19180,21228,21260,19180,17100,17068,21391,19245,12906,25455,58997,58998,48532,46420,35953,50645,40081,54904,44307,54872,42259,54872,44340,52824,42259,50711,38033,35921,31436,14792,11086,48762,50842,50810,50745,50745,48664,48632,46584,38100,27437,27437,40115,46519,46487,46486,44438,46486,46519,46487,46519,46487,44439,35955,31729,54774,31729,17069,38100,48533,42195,50646,44340,44242,33483,31337,29192,33450,27047,29225,25097,41999,41901,31500,39821,37968,27401,21192,21193,21095,6500,8679,14824,29516,36085,27567,29615,27503,33874,33841,10665,19179,31760,44407,21165,29582,42259,50842,50810,40213,44404,27626,17192,10854,10821,8773,8774,10855,10854,2468,2468,291,161,226,2499,483,4740,11013,13125,15270,15238,15238,15270,17383,19463,17382,19463,19463,19463,19495,21576,19495,21576,21576,21576,21576,21575,21543,21575,23656,23688,23688,21575,21575,23688,23687,21575,21607,23688,25768,23655,23655,23655,23687,25800,25735,25703,25703,23655,25735,23655,23623,25735,23655,21543,19462,255},
{65466,65466,65498,65466,65402,63257,44439,52793,65369,61177,56953,46553,48697,44569,38296,38264,42457,44505,42425,42457,44505,44537,44537,46618,46650,44505,33909,31828,33876,35924,50454,46326,27636,33909,23507,21394,15087,15055,15022,12974,21295,23408,12909,12908,19183,25488,23375,27569,25554,21327,10860,10795,8682,10763,21262,27535,33841,42326,33972,23407,42227,44340,38067,40147,33841,29614,29647,25422,25390,25421,25422,23341,23309,25422,23374,23341,23309,21261,19245,19180,19181,19149,14987,29714,54838,56950,48532,48532,38065,50645,42161,52791,46452,52824,46388,52791,46452,52824,42292,50744,42226,35920,27406,8519,17101,36118,40312,40344,40311,40311,40279,40246,38166,29648,27502,27534,38100,42326,42326,42326,44406,44406,44406,44406,46487,44406,46487,29585,31762,59064,42194,21197,42228,46356,46355,44308,46356,37773,29289,29160,31305,31402,27014,31402,25064,44242,46061,29257,29354,29354,33578,35626,25192,29515,17032,12711,21163,38002,36183,25455,31696,29583,31696,33842,19150,17035,44334,44403,46453,35919,40243,52956,46617,38100,63454,36047,17159,15112,12967,17161,12967,8742,2500,2435,4580,2338,193,354,2499,515,6852,13125,13157,15238,15238,15270,15270,17351,17350,17350,17382,19463,19463,19463,19463,19495,21576,19496,21576,19495,19462,19495,21575,19495,21607,23688,21607,23655,23655,23655,21542,21575,21574,23688,21607,23655,25768,23655,25735,23654,23655,25735,25736,25735,25703,23655,21542,21543,21542,19430,255},
{65434,65434,65466,65433,65369,61177,44439,48664,61177,61145,54905,44504,48697,42489,38296,38296,42457,42457,42457,42457,44505,44537,44537,46618,46618,44537,33941,33876,35956,33844,46326,44278,25556,33910,23540,21394,15088,13007,12974,12941,19215,17134,14989,12909,17102,23375,23407,27536,23408,17102,2409,10763,12811,14923,15020,29648,33808,44406,27600,31762,46421,40050,38067,33808,31760,17003,23309,17068,17004,19116,19181,21261,21262,23342,23374,21294,23374,23375,23407,23407,23407,23375,23342,33874,40146,38001,38033,50613,33840,46452,44307,48533,50645,48565,48566,48565,48597,48598,46485,46518,46485,35887,27438,21034,25390,34071,36119,36151,36119,34038,31893,31893,29780,29780,29779,25456,16841,21002,21067,14987,23406,48697,48665,48633,46520,46520,44407,29649,31794,52791,54774,29550,33451,27111,25096,25096,25129,27241,24966,24966,27111,22886,24966,22853,25194,46420,50319,31337,25323,23146,35757,37643,8355,10629,14953,21164,33841,44373,44341,33809,33776,31696,27535,31761,25424,23276,61028,48724,48730,31726,46616,55036,42358,48664,63455,42488,29775,10886,6661,10887,15048,10887,2500,6693,8774,225,289,2499,2531,4707,8964,11044,13189,15270,17318,15270,15270,17318,17350,17350,17350,19431,19463,19463,17382,19495,19495,19495,19495,19462,17382,19462,21575,21575,21607,23655,23688,21607,21607,21575,21543,19494,21575,21607,21575,23655,25768,23655,23655,23654,25735,25735,23623,23655,23623,23623,23655,21542,21543,19462,255},
{65370,65402,65466,65401,65369,61177,44471,46552,61145,63193,54904,42424,48730,44602,38264,40344,42457,42457,42457,42457,44505,44537,44537,46618,46618,46650,38166,38037,35956,25555,29716,29748,25556,29749,21427,19346,15087,15055,12974,12909,23376,19182,12941,10860,17070,23376,25488,27536,27601,23375,19117,17069,14956,10762,14956,31696,37837,46518,31793,29713,50712,38034,38066,44307,38001,19018,25325,14922,12841,12841,12841,14922,14857,12809,12841,12874,12874,12874,10761,10761,10794,12843,10795,38034,52725,42161,27502,50645,38066,48533,46420,44372,52791,46420,52759,46420,52791,44405,50679,44372,50711,25357,39985,29550,31794,38232,36184,36152,36151,34006,31861,31893,29747,27667,29747,21165,14663,16776,16840,12776,14920,46617,52924,48731,44537,46618,33875,27602,29746,44373,54904,35889,46127,33482,29224,25064,20870,21033,14564,14759,18790,14662,18790,18564,27406,42227,41998,37643,33418,31337,33514,37610,31369,23113,25356,27469,33905,42325,50712,46421,37970,29615,27503,31696,31729,35921,44334,44503,52923,44438,52923,55036,40213,59229,42421,25680,19307,8709,6629,12936,8742,6629,10919,4580,2403,225,386,2498,4643,6820,11013,13093,15205,15270,15270,15270,17318,15237,17318,17351,17350,17383,19431,17382,17382,21576,19495,19495,21609,19495,19462,19495,21575,21607,21607,21575,23656,21574,21542,21542,21542,21542,19494,21575,21608,21607,21607,23687,23687,23623,23687,23655,21575,23655,23623,23655,23655,23591,21543,19462,255},
{65370,65370,65434,65401,65369,63322,44472,46552,63225,65305,54904,42424,50842,46682,38264,40345,40377,42457,42457,42457,44505,44537,46617,46618,46618,46618,38134,38036,31795,21426,23475,35925,25556,23540,23507,19346,15087,15054,12974,15022,25489,19215,12941,10828,17134,27537,21262,27601,29682,38165,23407,8715,4521,6601,12778,27437,35757,44405,35954,35954,52857,44372,38066,46452,40146,19083,25422,19148,19115,21196,19148,21261,21196,21228,21260,21293,23373,21293,19180,19148,19180,19115,19084,33874,52725,48499,31630,50646,31727,35888,48533,42226,54871,44307,52791,44340,52791,44340,50711,42292,50743,27404,46289,42096,33973,27766,31958,31958,31926,31893,29812,31860,27666,29747,29780,18987,16776,18824,14760,8616,8583,38197,50843,46650,42392,46618,27536,21263,33940,48566,46486,25455,48631,48240,41901,41836,39723,41868,37611,31370,33449,29256,29257,20741,25161,35790,31370,24998,22918,20838,27111,24999,25064,23015,31597,35821,27404,33906,35921,44307,42228,31696,27502,29583,33841,40213,42293,33905,52955,52988,55036,50745,33906,48760,25548,15048,8742,2403,2404,10887,8741,2403,6693,2468,258,225,418,2531,4675,8932,11045,13125,13157,15270,15237,17350,17318,17350,15270,15270,17350,17350,19431,17350,17350,19463,19462,21543,21576,19463,19462,19495,23656,21608,19527,21575,23656,21575,21575,21575,21575,21575,21542,21575,21575,21543,21575,21575,23655,23655,23655,23623,21543,21543,21542,21543,21543,21510,21543,21511,255},
{65370,65338,65402,65369,65369,63321,44439,48600,65337,65369,52824,42425,52890,46682,40377,40377,42457,42457,42490,42490,44538,46618,46618,46618,46650,46618,33941,33909,33876,29715,35924,44278,31829,25588,21459,19314,13007,12974,12941,12942,25489,17102,17102,17134,14989,25456,25423,31729,25456,42358,23439,8714,4521,8682,19084,33742,33840,42325,42358,46518,48631,48566,44340,38067,35953,29615,29583,31663,29583,27567,27567,27535,29551,27534,27534,25454,27503,25422,23341,21293,21262,21261,21262,27600,54838,54838,33808,50613,33710,29549,50646,40081,59097,40114,59097,42259,57017,42259,57017,40146,46486,31598,46321,42129,34006,8684,29747,15022,23474,21361,19215,23409,12844,27634,10699,20938,12647,16776,10631,4389,2309,33939,46618,40213,38132,48633,29519,17068,33907,52792,38068,21197,29714,50450,44241,44111,48338,46419,46094,40081,43949,37676,39788,41804,35693,37805,27143,22950,22885,27111,24933,25031,25030,25128,40114,42194,33774,40179,33612,40015,44373,35889,27503,27503,31728,38067,38066,33774,44536,55069,55068,40213,29615,36083,25483,12934,10822,12902,2435,4516,4484,4484,354,195,161,322,2498,2563,6788,10981,13125,15205,15237,17350,17318,17318,15270,17351,17351,15270,17350,17351,19431,15270,15270,19463,19430,19495,19495,19495,19462,21543,21608,21575,19527,21607,23656,21575,21575,23687,23655,21542,21543,21543,19494,19462,17382,19462,23655,23655,21542,19462,21542,21575,21543,21542,21543,21510,21510,19430,255},
{63290,65338,65434,65369,65369,65401,44471,46552,65305,65369,48566,33907,36051,36019,33939,33939,33972,33972,36020,36052,36052,38132,38133,38165,40213,40245,35955,35890,35890,38002,42131,40051,38003,35955,29682,27569,23375,23375,23343,21294,27536,27568,21230,19182,21262,29616,27568,31761,29616,40180,29746,17035,17035,10762,25357,35822,31727,42293,42324,44406,48696,48630,44340,35921,38001,27470,23309,14922,17035,17035,17036,19116,19148,19181,19181,21261,21229,21261,19181,23342,23374,21294,27568,31728,50645,52725,25291,48501,42161,33775,50645,40146,54904,42259,54872,42259,54904,44340,52856,42129,33450,37838,48402,42195,29780,10699,31925,6506,27699,17069,25488,17070,19150,21263,6342,18857,4262,16905,10823,4486,2309,33906,46618,44406,40180,40116,27438,17069,33940,38100,25488,19149,27633,48436,39724,39756,41869,41934,46094,41966,43884,39756,39724,43982,35790,31402,25031,22853,22821,27209,29191,37576,31336,33612,40114,44340,38000,35920,35757,35822,46453,35922,29615,27470,29648,33874,38066,35855,44470,55037,52890,31729,33808,25517,23467,15015,10790,8742,15047,4483,194,130,161,34,130,386,2498,2563,8869,10948,13061,13125,15237,17351,17351,15270,15270,15237,13157,17350,17383,17383,17350,17350,15270,19463,19463,19495,21543,19462,19462,19462,21575,21607,21607,23688,23656,21575,21575,23687,23655,21575,21607,21575,19462,17349,17349,19462,21575,23655,21542,21543,19462,21543,23623,23623,23623,21542,21510,19462,255},
{63258,65338,65402,65369,65369,65338,46519,46520,65273,65305,42292,29549,25356,29549,29549,29549,29549,29549,29549,29582,31662,31630,31629,33710,33742,35790,37903,39983,42063,44175,46223,46256,44175,44176,46256,42064,37935,35823,31663,31695,33775,31663,31695,29615,31663,29615,29583,29615,31696,29648,29583,29583,31663,29583,29615,31695,31728,31761,31793,33874,38067,42260,38067,35921,33906,25422,29614,19147,19115,19083,19115,17034,17067,17099,17002,17002,14954,14922,12810,12874,10794,10794,27567,35986,50645,56918,33710,46420,42194,23275,50613,38033,56985,44307,54904,44372,54904,44405,52824,46355,33450,37773,48402,40180,21362,14957,29780,8618,29812,12811,29714,10731,25489,12811,14696,12616,8423,16904,8678,4453,10630,29712,46617,50811,48731,31534,23114,21295,27700,25521,19181,19117,29681,42064,24998,24999,24999,25031,29256,27078,27046,29224,27046,29159,31305,27112,22886,20708,20741,18660,39853,39786,18757,33710,40146,44340,37968,35855,42227,29614,46518,38066,29615,25357,25487,29745,33873,31760,48665,56987,42358,29648,31728,25516,23434,12902,12871,15015,21320,6596,2307,2307,291,65,226,2498,6691,8836,10917,8836,8803,11013,13125,15238,15270,15270,15270,15270,13189,15237,17350,15270,15270,17350,17350,17350,19463,21543,19463,19430,19494,21575,21607,21575,21607,21607,21575,21575,21575,21607,21607,21575,21575,21575,19495,19495,17382,19430,23656,23655,21542,21543,19430,19462,23623,21542,19430,21542,21510,19430,255},
{63258,65338,65402,65337,65337,63257,44439,48600,65305,63225,42259,29549,25388,31662,29582,29582,31662,31662,29582,31662,31695,31662,31662,33742,35823,37903,35822,42096,44175,46256,46288,46256,44175,46256,42063,46256,40016,33775,31663,31663,33775,31663,29582,29583,29615,29582,27502,29550,31663,29583,29550,29583,29615,29583,29583,29615,29615,27502,25390,25390,31696,40082,35954,31761,31761,14891,27503,19116,17035,19148,17132,17099,17132,17132,17068,19180,19212,19180,19180,21293,19148,21261,33807,35954,52725,59063,33774,42194,48500,33742,50613,42226,52759,46420,50711,46484,50711,46485,48663,44242,23050,31565,46322,38133,14958,23409,23474,17069,27667,12812,29780,10763,29715,8553,18889,6342,12583,8486,6630,12774,23272,19144,40310,48730,48666,33516,23017,23343,25554,27765,19149,23408,27601,46387,22885,27339,20903,18790,27241,18725,27176,29159,24998,24934,22918,24998,18660,20741,16547,18725,37837,44045,16676,33775,42226,40147,33841,31760,44373,37935,40276,48664,35889,29583,27503,31696,33842,44439,52826,50778,35955,31760,25483,19273,10789,8677,15015,19207,15014,4515,14953,17065,2435,226,4515,15078,19271,19239,10853,8772,8739,6755,11012,13157,15238,13125,15206,15237,13156,15269,17350,15270,15237,13156,13156,17350,19431,19430,19463,19495,21575,21575,23688,21575,21607,21575,19495,21575,21575,19494,21575,23655,21607,19462,19430,19462,19494,19495,25768,23655,21543,19462,21543,21542,23655,21542,19429,19462,19430,17350,255},
{63258,65338,65402,65337,65337,65369,44439,48600,65273,61112,35921,29549,25356,31630,31662,31662,31662,31662,29582,31662,31662,33742,31662,33742,35823,35823,35822,40015,42095,46256,44175,48336,46224,46256,44176,44176,39984,35791,31662,31663,33775,31663,29550,29583,29615,29583,27502,29582,31663,29583,29583,29583,31663,29615,31663,31663,29615,29551,27471,27471,31696,40082,35954,33873,27601,8552,19149,6472,6472,21196,21163,17002,17034,17034,16938,14889,14921,14857,12809,10794,10696,10761,38000,38034,48532,56983,40048,40081,50613,25388,46420,42259,46485,50646,46484,50678,46485,50646,44405,46388,29419,31565,46354,36086,8651,29780,17102,25521,23376,23310,23441,14989,27634,10632,18857,4229,14728,4421,4485,27433,25352,21191,33970,48698,48731,35694,27242,25422,23441,17102,23343,25488,23441,44373,31499,23276,25194,20968,44209,25128,39983,45997,33417,37707,35497,43883,39625,35433,33320,35530,41965,44013,41801,39821,37903,31630,25356,27502,44405,33741,40244,48730,33809,31696,29583,29583,33874,42391,42326,38165,35987,29710,19175,15015,12902,19240,23433,21319,14981,10789,19243,14984,6628,2370,10821,10853,15079,10853,6596,2370,2467,4611,10980,11044,13124,15205,17318,13157,15237,17382,19463,17318,15205,15172,15204,17350,17382,19430,17382,19462,19494,19462,21575,21607,21575,19463,17350,19430,23721,21575,19462,21575,21543,19462,19462,19494,19462,21575,25800,23688,21575,19430,21511,19462,21542,23622,21510,17349,17317,19398,255},
{63258,65338,65402,65337,65337,65370,46551,48600,65305,61145,40180,29517,25356,29582,31630,29582,31695,31662,29582,31662,31662,31694,33710,33774,35823,35854,37935,40015,42095,46256,44208,48336,44175,44144,44176,44144,37936,35791,33743,31663,31695,31631,29582,29583,29615,29583,29550,29583,31663,29583,29583,29583,31663,29615,31695,29615,29615,29583,27503,27503,31728,38066,33874,31793,27568,12777,23342,6439,8552,23374,23342,21294,23375,25455,23407,25455,27535,27535,29615,29648,27567,27534,40178,31728,40179,44372,38033,40179,50646,27436,42259,48500,46452,52791,46452,54872,44372,52824,42259,52824,38099,33743,44275,29813,10699,31925,14956,31859,17037,29649,17037,21295,19150,10503,14696,4294,12775,2404,10726,27433,21127,12774,25518,50811,44472,31403,27242,27438,23408,23376,23375,25521,23408,38132,44209,29353,33613,46420,58999,46256,37934,46029,25095,29549,25096,41966,43787,16806,25291,27176,44078,37610,27176,31402,31369,39820,10890,25258,40081,46453,40081,42326,38002,31728,29615,27503,35987,40245,33874,33906,31823,23401,17062,14982,17095,23466,17127,17127,12934,10822,17098,12902,12965,17159,17126,15013,15014,8708,8676,2338,4418,6627,8867,11012,11044,15205,15206,13125,15238,17350,15270,15270,13125,15205,15237,17350,17382,17382,17349,19462,19462,17382,19462,21575,21575,17350,13157,17350,21576,19463,17350,19430,19462,19430,17349,17349,17349,19462,21607,19494,21608,21575,19429,19429,19429,21542,19461,17317,15237,17317,255},
{63258,63258,65370,65337,65337,63289,44471,48600,65273,59032,38002,29517,25324,29582,31662,31630,33743,31662,29582,31630,31662,31662,31662,31694,33742,35854,35822,42063,42063,44208,46256,46256,46256,46224,42063,44144,37903,35823,33743,31662,31695,31663,29583,29583,29615,29583,29551,29583,31663,29583,29550,29583,31663,29615,31663,29583,29583,29550,27470,27503,31760,38034,31761,33874,25520,14955,21261,10632,10665,12810,6408,4327,4359,4391,2376,4360,4457,4425,4489,4457,4425,8585,35919,38034,31761,35987,23277,29583,52758,29615,38034,50613,42259,54904,42259,54872,42259,54872,40179,48664,36019,35856,40180,25554,17070,29813,27633,40213,35922,31762,38067,33874,31697,31663,25325,27437,25388,17033,23338,16967,23241,16935,27501,50811,42196,27177,25194,35857,23408,25489,23343,25489,25488,27666,48598,48174,42064,33874,52758,54838,52693,52530,44046,41999,39820,44078,45996,31563,29483,31402,39885,43883,27241,31597,21000,41966,13003,4520,23309,50712,35888,42292,50744,38034,29583,27535,38133,35955,31729,29678,25513,21255,23433,21320,17095,14983,12935,12935,8709,8677,6597,15047,21352,19239,15046,17159,15014,12901,10821,10757,10595,12675,8835,11012,13092,13125,13125,15206,13158,15237,15238,13093,13061,13028,15205,15269,17317,17349,17349,19430,19462,17382,17382,19495,21544,15238,15238,15270,19463,17383,17350,19430,19462,17382,19430,17349,17349,19463,21542,19462,21575,21542,19462,19429,19461,23622,21541,19430,17317,17349,255},
{61178,63258,65338,65305,65337,65369,48600,48632,61113,56985,40115,29549,25356,31662,31662,31630,31694,31662,31662,31662,31694,33775,31662,33742,33775,37935,37935,42095,42095,44208,46288,44176,44144,46256,42096,44176,37968,35823,31662,31663,33775,31695,29583,29583,29615,29583,29550,29551,31663,31631,29550,29583,31663,31663,31663,29583,31663,29615,29551,27503,33841,35986,31794,35987,21262,14956,23407,17036,19084,19117,19116,19084,17068,19116,19084,19052,17036,17004,17004,14891,14891,16939,37999,44438,33874,33906,21196,29615,52726,31694,33807,52726,40114,59098,40146,59130,40146,59098,40179,54937,38067,35954,36053,15023,25489,23474,31892,48599,40180,38035,44406,33842,40180,38100,31761,40213,31761,31761,36020,25389,25419,21259,25421,44504,37807,27177,31534,42327,25488,21295,19149,25488,25488,23376,38132,52498,33874,35954,42227,46615,44437,48630,56919,42259,58999,44176,52660,52595,44209,54611,44176,48272,44046,41901,37675,43981,27371,17033,33612,42162,27437,29711,52890,50680,29615,29648,36020,31729,27535,27598,27594,23400,21288,19176,14983,12902,10789,6597,6597,6597,15047,19240,15014,21320,15046,15014,12901,10756,10756,6563,10692,10659,10787,8835,10979,13092,15237,13125,15206,15239,17223,17159,15078,10883,13092,15237,17317,17349,17349,19462,19462,17382,19430,19463,17383,15238,15238,15238,15238,15270,15238,15270,17349,17349,19430,19430,17317,19462,19462,19494,19462,19429,19462,21542,21542,21542,19429,17349,17317,17317,255},
{61178,63258,63258,65305,65305,65466,50712,48632,59033,54905,35954,29550,25356,31662,31662,31662,33743,31662,31662,31662,31662,33743,31662,33742,33774,35855,37935,39983,44144,46256,44176,46256,44144,46256,44144,46256,37968,35823,31662,31663,33776,31695,29583,29583,29615,29583,29582,29550,31663,31631,29582,29583,31663,31663,31663,29615,31663,29583,29583,27503,35889,33841,25455,33906,35922,27502,21229,21131,19051,17036,17004,16939,14923,17004,17036,16939,14923,14924,14956,14923,14924,14923,38131,40212,35954,31794,17003,29616,52759,40113,31727,50678,40146,54904,44307,54904,44372,54904,44339,50744,42292,35986,33941,12812,29780,17168,40312,52858,40180,44405,44406,38099,46486,38099,38067,44405,33873,40147,35987,31630,27533,17032,12871,35954,33483,27177,29421,46585,29681,17069,23342,25520,27601,23375,36020,48338,23213,38100,56886,59097,59032,56952,61145,50645,61145,50482,52694,56886,42194,59032,33807,42096,48435,44306,44046,42227,35822,6826,21098,35856,31565,25485,48697,54971,33841,36019,33874,27568,27567,25515,23401,19207,12902,15015,12870,17127,10789,8710,6564,6564,6597,12902,17127,17095,10821,10821,8676,8676,10756,8676,8708,10756,8676,6658,8834,10979,17318,19368,17224,17160,17095,17127,14917,10755,10979,15237,17350,17317,17316,19463,19463,19430,19463,19431,17318,15238,13157,15206,15238,15270,15238,17350,17350,17350,19430,19463,19430,21574,21542,19462,19429,19462,21542,23654,21509,21542,19396,19397,15236,15236,255},
{61178,61178,61145,61145,63225,65466,52792,48600,56985,50712,31695,29582,25356,31662,31662,31662,31694,31630,31662,31662,31694,31694,33742,33742,35823,37935,37935,40015,44176,46288,46256,46289,46256,44176,42096,46289,37968,35823,31662,31695,33775,31695,29583,29583,31663,29583,29583,29550,31663,31663,29583,29583,31695,31663,31663,29583,31631,31663,29551,29551,35921,33809,27471,29617,29681,21294,21262,19182,19182,19182,21262,21262,21262,21262,21294,21262,21295,23343,23342,21294,21294,21229,33906,29714,31826,27535,29615,27568,50678,40081,19082,52758,38033,59065,44307,56984,44372,54872,46452,50711,44373,42358,38068,31729,33842,25423,46618,55003,38067,46518,40244,40212,44470,35986,42292,40245,38034,42325,35986,35889,31663,31727,14920,19082,27209,27209,25194,44473,35955,17004,25521,25553,23375,25489,42261,37871,21230,31860,48630,48696,44405,42292,61145,52791,54904,61177,54904,63225,56952,61145,61112,56853,48304,44047,43884,41999,41934,12937,21129,35757,37936,27502,54971,55004,42261,35987,31729,29616,29648,27596,19208,21288,14982,12838,6596,17095,8676,6597,4451,2371,15015,17094,12934,10788,8643,8675,14982,17095,17063,15015,12869,10756,10757,10756,6657,10980,21449,19240,15015,17063,12870,17031,14853,12740,10915,13124,15237,15204,17317,19430,19430,19430,19430,17350,17350,15238,15205,13125,13157,13157,15238,15270,17318,17350,19462,17350,15269,19429,19430,17349,19429,21541,21573,23621,21541,21509,17348,17317,15204,15204,255},
{61178,59097,59065,59033,61145,65402,50712,48632,54872,46454,31663,29550,25388,31662,31662,31662,31694,31662,29582,31662,31662,31662,33742,33742,35855,35855,37935,42063,42095,46256,46288,46256,46256,44176,42095,40015,37935,35823,31662,31695,31695,31663,29582,29582,31663,31663,29551,29551,31663,31663,29583,29583,29615,31663,31663,29583,31663,31664,29583,29551,35921,33809,29551,27471,29616,21327,19149,10763,12843,14924,12843,12876,12908,14924,14924,12876,12876,14924,14957,14956,14989,12908,23342,36019,31794,29648,27535,25423,48533,46420,27533,50646,42226,54871,46452,52791,48565,50711,48566,48566,46486,40245,40148,31761,50680,50712,57084,48730,33841,42325,33906,38099,40213,33873,42325,35986,36019,40245,33906,38099,31761,38066,21227,21163,23242,31662,29615,38264,38101,23343,27602,21295,19117,27633,38100,35889,25488,27602,33940,55002,52823,42194,59032,44274,44340,63258,48597,59097,42226,46453,59097,44437,48304,37903,41934,44079,44176,25420,17162,31565,37936,42195,55003,55036,46552,35954,29648,29648,31760,25515,23400,17094,19207,15015,8709,12902,12870,12902,2371,2371,15047,14982,10789,12869,12869,15014,12901,12902,15015,10789,10789,12902,8676,10724,8674,15078,21386,17095,12838,6467,10725,12902,14885,16899,10882,13060,11012,13092,15205,15237,17318,19398,19430,17317,17350,15237,15237,15205,11044,13124,13125,13157,15237,15237,15269,15237,17317,19430,17317,15237,17349,19461,21509,23622,25671,19397,17284,17285,15204,15172,255},
{59098,59065,56985,56953,61113,63258,48632,48632,56953,48632,31728,29582,27501,31662,33775,31694,33775,31694,31662,31694,31662,33743,33742,33742,35823,37903,37935,40016,42063,44176,46288,46288,46256,46288,42063,37903,37936,35823,31663,31663,33775,31695,29583,29583,31663,31663,29583,29550,31663,29615,29583,29550,29615,31631,29583,29583,29615,31663,29583,29551,35889,33809,29551,27470,27503,25423,19116,14858,16971,8617,4456,4489,4521,4424,4424,4424,4424,2344,4456,4456,4522,4489,8650,33939,33874,29648,21229,25455,46486,48533,19083,46452,44307,50646,52726,48565,54839,46485,52791,44340,52760,38067,44373,31794,55069,55036,57083,52825,48599,48599,46486,44373,44374,40147,40212,38067,35954,36019,31761,31826,29648,29712,21194,21196,21162,19081,14921,27732,40246,25423,27602,27601,23375,23440,23342,21230,27634,25521,23408,44341,54806,48533,50580,48175,39854,44144,44112,52498,50385,46225,54709,48468,50385,48371,44112,46160,44307,35758,4616,19082,35823,50712,52923,55036,44439,31761,29616,29649,29679,19176,17096,17128,17127,8710,2372,6629,15015,6532,4483,4451,6597,15015,17095,17127,19240,19208,12869,8708,17095,8644,6564,12870,8644,10757,8675,19273,19240,12934,10724,14949,21352,19206,19206,21316,17187,17252,10980,13124,15205,15237,17317,17350,19463,19431,17350,17350,17317,13156,13092,13092,15173,13124,15205,13125,13125,15238,17318,17382,15238,15238,17318,19429,23623,27722,25609,21414,17252,17253,17253,15172,255},
{59098,59066,56985,54905,59065,54938,44472,50680,59033,48632,31695,29582,27469,31630,33775,33775,33775,31694,31630,31694,31662,33743,33742,31662,33742,37935,37935,40016,40015,42128,46256,46288,44143,44176,42096,39984,37936,33775,31662,31663,33776,31663,29582,29551,29583,31663,29583,27502,31663,29615,29583,29583,31663,31663,31663,29583,29615,31663,31631,29551,35921,33809,29583,29583,29551,31632,29583,29551,29584,25423,25358,25390,23310,21229,21197,19116,19116,21261,17036,14923,17069,10762,12875,23440,33874,44242,37903,31728,40180,48598,29581,46420,46452,46485,54872,46453,57017,46453,59098,44307,57050,38034,52825,35988,53022,50843,52891,52890,54970,54970,54970,54970,54970,52857,52825,52857,50744,48664,46551,44438,44439,38067,29582,23275,14919,6532,6534,21392,44538,27536,25521,27634,23375,25456,33711,31664,29682,23408,27601,46387,52660,42129,44274,48109,23048,29549,27273,44078,43851,27274,35693,31467,48272,41869,29354,35628,35628,44014,15051,31595,35790,48599,52923,54906,42228,31728,29616,29616,25455,27533,19145,12903,14984,12870,4516,2340,10822,10822,10821,6564,17129,19240,17127,17127,17127,15014,10756,15015,10822,8677,8645,6532,4419,10757,12902,19240,21319,25577,23463,25576,23497,23465,17158,15109,17220,15139,13028,15172,17285,15205,15204,17318,17318,19398,19430,21478,27687,27622,21381,17221,13060,13093,13125,11044,13125,13157,15205,17318,15205,15238,17317,25705,29834,23497,25578,25577,21416,19303,17189,15140,255},
{59098,57017,56985,54905,56985,50777,40312,48632,54905,48665,38034,29549,27468,31662,33742,31694,33742,31662,31630,31662,31694,33775,33742,33742,33775,37935,37935,40015,40015,42096,46256,46256,42095,44176,40015,37936,37936,33775,31662,31695,33776,31695,31663,29551,29583,31631,29583,29551,29615,29615,29583,29551,29615,31663,31663,29583,29615,31663,31631,29583,37969,33809,31664,29583,29616,31696,29616,29551,29583,31664,29584,29616,27471,27471,27471,29519,23212,29681,18987,21165,23408,8520,12583,12583,29648,61078,63158,46387,31794,29746,27534,33874,31794,33939,38133,33907,40278,33939,42358,33907,44471,36019,42358,40279,46684,46683,57084,52857,57050,57051,55003,55003,54971,52890,52890,54970,52890,50777,48664,44503,44471,38100,27437,19049,12774,2372,2372,12940,29747,27503,27601,27601,21294,31826,61145,54806,23310,23376,33874,48533,63192,42128,42227,52433,37545,35563,37676,44014,52238,31369,31597,33547,44143,46029,23081,29517,27371,46224,19244,18986,25325,44339,52923,54971,42228,29648,29616,25455,27536,31793,23339,19209,12870,12871,8677,14982,21320,15014,12933,10822,19241,19240,12869,10821,12870,10789,8709,10790,4451,4420,4420,6564,6468,8677,17095,23464,25608,21415,19303,17189,13030,12966,6692,17191,12997,10915,13059,10946,13091,15204,15204,17350,19431,33929,35977,33864,35881,35881,27526,31719,15076,13060,15206,13125,11044,13125,13157,15237,15205,17286,17318,23593,25545,27658,27659,23466,17159,17158,17158,17191,255},
{59098,56985,56985,54873,56985,48665,40279,48632,52825,48665,38100,29517,27436,31630,31630,31662,33743,33742,31662,31694,31662,31695,31662,33742,33775,35855,35855,35855,37935,40048,42096,42128,42095,42096,35855,37903,35855,33743,31662,31662,33743,31695,29583,29583,29583,29583,29583,29583,29583,31663,29550,29550,31631,31663,29583,29583,29615,31663,29583,29583,37969,33808,31664,29583,29616,31696,31696,29615,29616,31664,31664,29583,25390,25326,27406,33778,25163,20969,16808,29617,21230,8423,10437,12550,29584,54903,61111,44339,31794,25456,10664,33875,23407,36053,31795,31827,36085,31827,36086,25521,40279,27601,38198,25553,29877,31892,59229,52858,50809,52923,55003,55003,55003,55003,55003,55003,52922,52890,50810,46584,42391,35954,23178,21097,16998,10725,6532,261,19182,35987,27569,27601,27536,31826,54872,58999,27502,23408,33842,33874,59031,46354,48467,41967,39724,37611,39691,41804,41804,43917,39756,43884,43982,48239,41869,41934,37741,44046,35725,23147,35726,44177,52923,55036,40148,29615,29616,25423,29649,31794,29647,23339,19208,19175,12932,21384,15046,12901,10853,17127,17159,17095,12902,12934,8677,8645,8645,6564,8645,2275,10726,8645,8613,6564,21384,21384,19239,17191,15047,8804,10917,6724,8772,12965,8805,15110,15140,13026,6753,13091,13156,15237,19431,36074,38026,27494,23334,37961,35848,33801,25413,15076,13061,11045,11012,11045,13125,15205,15205,15205,21448,25610,21353,25546,23433,19240,19207,17126,17127,12966,255},
{61178,56985,54905,52825,54905,46585,40279,48665,54873,50713,56888,48567,40279,38199,40279,42359,40311,48664,44471,42391,42359,42391,44439,44439,42391,40279,27634,29650,27602,29682,27602,29682,27634,27635,25521,21328,21295,19214,19182,25423,25455,21262,21294,21262,33809,35922,29616,27503,29616,29583,35922,25422,21229,25454,27470,27405,27438,37969,42162,38001,31760,31728,35889,33809,31696,31728,31729,31696,29616,31664,29551,27535,27471,25390,25390,29584,27340,29485,23180,27504,25553,8422,12485,12550,31697,38133,38133,29615,31794,27503,23244,35987,25455,40246,29649,38133,31794,36053,33940,36020,31892,31795,36021,27569,29649,36021,57182,48763,33973,38199,38198,38231,40279,40311,40311,40344,42424,42424,42424,42424,40246,33810,25292,18984,16998,6596,2372,259,10827,31826,23343,25521,36085,38101,48566,61113,40115,21262,19149,31794,54872,56985,54742,37644,31304,31337,31272,37676,35531,29192,27177,29192,37741,39789,31338,31370,33450,39724,35596,37709,41869,42097,52891,54874,35890,27568,27535,25423,29681,31729,31761,31791,25544,19206,15013,17158,12966,10822,6596,15047,17127,12934,12902,12934,10757,10725,10725,14983,8677,4452,10790,8613,8613,14982,25577,21414,17190,15046,8740,8805,12966,10917,12965,6627,6724,6724,13092,15108,6721,10978,17284,17286,17318,31881,31720,27462,29608,40042,35880,25382,27495,19206,10947,11013,11012,11044,13158,15205,15237,19399,29836,25578,23465,21320,21353,17127,19208,15047,10854,17127,255},
{59098,56985,54905,52825,54905,46585,40279,48665,54873,50713,63225,50745,40345,38297,40377,42457,42457,50874,46650,44538,42458,44538,46618,44570,44571,38232,27635,27603,27603,23475,29716,31797,25588,25621,21427,17201,15088,10894,10861,21327,19247,12941,12941,12876,27504,38003,27568,21197,25456,25326,29618,10795,6537,23245,18954,14728,18922,46519,54905,46486,23407,23374,35955,33874,35955,21327,10794,23277,27536,21262,31631,31664,29615,31696,25357,23212,12843,14956,8650,6537,12810,14826,21100,21067,38068,36020,29648,31793,31827,27502,27502,33939,31728,40279,27569,40278,29681,40246,29714,38165,29682,36053,29714,33907,36021,46585,57215,42425,38167,40312,40280,40312,40312,40312,42392,40344,40312,38231,38167,36086,33908,27536,23310,19050,14919,8645,2340,2276,6471,33939,25423,27601,31860,29747,42260,52759,35922,23375,19117,42293,54873,52792,46258,37806,37676,37676,44080,35531,35628,35596,37644,39854,39854,37741,33386,31402,33418,37676,8843,12679,22952,35889,52891,52793,29616,29616,25422,27535,29648,31729,36020,36050,31820,19206,10852,10853,10822,6597,6596,10854,12935,10822,12935,8709,10789,12902,10822,8709,6532,6532,8613,2339,8677,27657,23463,17157,6659,10885,8772,10885,8740,12999,10918,2371,2467,10916,6659,2338,2401,8899,17254,21384,25642,42219,35848,31687,29639,35881,23269,17028,23368,17062,6754,8931,11012,11044,15206,17286,25706,27723,27658,21320,27627,21352,17127,12902,10790,8741,10853,12934,255},
{59098,56985,54905,52825,52825,46585,38231,48633,54873,52793,63288,48665,40344,38264,40345,42457,42457,50842,44569,44537,42457,44506,46586,46618,44538,33974,29716,27603,25523,25555,27668,27636,25588,25620,21427,17201,17168,12974,10893,21295,19215,12909,10828,14989,27568,35954,29681,23342,25456,27470,31762,10763,6537,27437,23147,25162,25227,46519,52760,40212,21294,14955,19214,15021,27535,29615,14824,21163,21229,17004,29551,33810,27503,27503,25358,12680,2246,2213,4324,2245,8616,14857,17101,23310,36085,33875,31794,29681,31827,27468,31728,33875,33841,40311,25488,42391,27568,42424,27569,42392,25488,42392,25488,35988,46618,55070,50877,38167,21361,31893,25555,29781,31926,29812,36119,31894,34006,34006,31893,31893,29714,27503,27470,23243,12742,10726,6468,4389,6501,29746,31729,27667,29747,27569,46486,50679,25423,25456,29649,50712,57018,56953,41934,37676,35530,37611,37676,37611,37741,35563,37644,44112,41934,37774,35596,35629,39854,29387,6794,20934,29453,42227,44537,48633,29583,31663,25390,29648,27535,35987,40246,31825,27629,27595,15013,17158,19272,15015,17191,17127,15015,12935,8774,6597,10822,10790,8677,4452,2339,8645,12871,4419,8677,21417,23496,15014,8773,10853,10853,10854,6693,6693,2403,4516,6692,6724,2498,2402,2402,6787,13093,15174,19335,40171,33768,31655,23301,21222,23303,23302,14948,21189,10882,10979,15173,15205,23496,21416,27658,31787,29739,25513,21320,19240,17127,10789,6628,10821,15014,21352,255},
{59098,56985,56953,52825,52825,46585,38199,48633,52793,52793,63256,48633,40344,38264,40345,42425,40377,48730,44570,44505,42457,44505,44538,46618,40377,29781,29748,25523,25523,29716,29716,29717,25588,25588,21427,17201,15087,12974,12941,17134,17102,12909,12909,12908,21262,38035,29648,21262,25423,31696,38100,14988,6537,27470,21099,21034,23115,44406,52792,31793,19148,14955,21294,14956,17003,25389,16969,21195,21358,25391,23278,31729,21165,19084,19084,19117,23342,6504,6439,4391,8552,21164,21230,12746,31827,36019,33874,29714,31794,25454,33906,31762,36020,36053,31794,38166,31794,40246,31761,40279,29681,40279,27536,38133,48732,50909,46618,33973,19151,25555,25490,19151,29716,19151,25522,23409,19151,27602,19150,23345,21099,27405,25356,27404,18984,12741,8548,12741,8611,23406,35922,25488,29714,40148,54872,42228,19149,27634,38068,54873,56986,50549,39756,37611,37611,37579,35498,39756,37643,37579,37579,41902,44015,35563,35531,35499,35531,21130,12744,27274,40049,40181,44537,38068,31695,25390,27503,31761,29648,40246,40213,23373,12871,19239,23463,19270,15079,12967,19272,17127,8741,4517,8710,6597,4517,6598,4452,10790,8645,8677,6533,6597,17096,10757,19208,17127,15047,8774,8774,6628,2403,323,2403,2435,4580,8804,6691,4515,2401,6786,11013,13125,25608,35946,31721,33768,27494,23302,23270,14884,23270,23173,8738,8899,11012,13092,17254,15174,23496,33836,27626,27691,25546,21321,17128,8676,12902,14983,17127,25545,255},
{59098,57017,56953,52825,52825,44505,38199,48633,50713,50745,63224,48665,42424,38264,40377,40377,40377,46650,44537,44505,42457,42457,42458,44538,38199,29748,29781,25555,23475,25555,33877,29749,27668,25620,19379,17201,15087,15022,12941,17102,15021,12909,12876,17069,23343,38003,29649,25422,25455,35792,38132,15053,10729,27470,23114,18857,21002,42293,50744,29713,21261,19180,21262,12875,10728,33775,25389,17002,19213,25358,23278,29682,21230,19116,19052,21197,25489,12779,8586,8617,10698,23245,21132,10666,17037,31794,29649,33907,23408,10698,31827,25456,38133,31794,38101,31827,36020,36020,36020,33972,33940,33972,31795,42392,48796,44537,38166,27635,25490,21296,29748,19151,27602,25490,19216,29715,19182,27569,25489,14893,29517,27469,25389,27437,23145,16870,16903,12742,4323,12842,38067,25488,27634,36052,42358,27568,23342,27569,46519,52792,42292,39887,35694,31435,35531,27275,35531,39919,33548,35563,33548,41967,37741,33451,35531,35499,31467,553,10630,23178,35921,44471,48665,35922,29582,23277,29648,33841,36019,40213,33874,27536,31759,29675,17126,17126,10853,8772,12966,15047,8774,4485,2372,8710,8710,8678,6629,10790,10790,4484,8645,17096,17096,14886,19176,23466,12967,12935,10854,6661,4516,4516,10854,4580,4580,17159,6660,4547,2465,6786,11044,13093,27688,33866,31688,25447,25382,16996,10723,10723,19045,19013,6658,6787,11012,11012,15205,19399,25641,25546,27626,23434,25547,21321,12902,8709,8677,10789,27658,36077,255},
{59066,59066,56985,52825,52825,44505,38199,46585,48633,50713,63193,48665,42424,38264,42425,42457,40377,46650,42457,44505,42457,42457,42457,44538,40345,29749,31861,25587,23475,23475,31797,29717,25588,25621,21427,19281,15087,15055,15022,17102,14989,12909,15021,17101,27569,38035,25487,25455,29583,33744,38100,12940,10729,29486,18954,16873,21067,38100,50744,33938,23374,19148,21261,14955,8647,33743,14954,4422,17036,21197,23278,33875,25423,23245,23213,23310,27602,14892,12714,12842,23244,31599,23082,27210,27340,33842,29682,33940,17037,10633,33939,21230,42359,25488,42359,27569,40279,33939,42359,29746,38166,29715,36021,50844,46683,40342,40279,19184,29747,19183,27635,23409,21329,29780,21263,27602,23409,21231,27635,12780,39952,29582,25389,29550,31629,21097,14791,14790,6436,8551,35987,25455,23441,19215,21327,19182,21230,31826,52792,54906,52792,44080,41935,39822,39789,37709,39789,41967,37644,37676,35726,39886,31500,33516,29355,29356,25291,14952,25193,35791,40180,35922,27503,35954,25389,23342,31729,38067,42326,33874,33841,31762,27568,42325,31789,17095,8740,10852,10918,17159,8775,4549,2405,292,6598,8711,8710,4485,4517,6598,23434,23401,19176,16999,21257,17128,12903,15080,10887,4581,8774,15080,10854,2468,4548,4547,2435,386,4610,6819,11013,11012,31849,27559,29672,25415,27495,12803,19109,17028,19013,6338,2498,6787,10980,11044,13125,17352,27659,23401,19208,17096,12935,19209,15015,8613,6500,17127,33964,31852,255},
{56985,59066,56985,52793,52825,44505,38199,46552,48665,50745,63225,48665,40344,38264,40377,42457,40377,48762,42457,44505,42457,42457,42457,42490,40377,29781,31829,25555,21394,21395,21427,25588,25588,25621,21427,21394,15087,17135,17102,15054,12941,12909,15021,14956,27537,38068,25487,23342,27471,31728,40116,12908,8649,31631,19051,27405,35824,31762,46486,35986,21262,17068,21261,14987,12807,25421,23309,12808,25389,27502,33582,33810,33777,31696,29615,27535,23375,14891,23277,25388,31630,37871,37904,37870,39984,35954,29682,33908,19150,23310,33907,27536,40278,29617,40279,27569,40279,31761,40311,29681,40311,27569,40246,46618,42457,29746,34005,17071,27667,23408,21329,29715,19183,27667,23441,21264,27634,19118,23442,16940,46192,33710,23309,25324,31630,29516,16936,12709,10630,19051,29421,27471,23408,14924,25521,19149,21294,42293,56953,44308,50680,50679,46453,54840,44243,50614,50517,44276,52694,48469,41967,39886,35563,35531,35531,35628,8778,12743,27372,40115,40180,23212,21098,31663,23309,27503,38067,52824,42293,29649,42228,31729,27503,36019,44372,33838,25514,12933,4644,19306,15017,4549,4485,292,260,4485,6598,6565,2372,2405,10856,17128,14984,14984,17096,12870,10725,12935,15080,8741,6725,12999,4549,2500,6693,6692,451,2530,6787,8900,11012,13125,17286,21383,21351,31721,23334,14884,14917,12804,10691,4450,2562,6787,8932,11044,21447,21480,27691,25546,17095,12902,12934,17064,12870,10757,12870,23433,25546,29707,255},
{57018,59098,54905,52793,52825,44505,38199,46553,46553,48665,63225,48665,40312,38264,40345,42457,42425,50842,42457,44505,42457,42457,42457,42458,40345,29748,31861,27635,19314,19282,21427,23508,27636,27669,21427,21427,15087,17135,17102,23376,19215,14989,17070,14989,29617,33874,21262,19149,23278,33809,42326,21294,8649,25357,17003,29679,31598,25260,44373,35986,19181,17035,29549,29549,25355,27404,23211,33808,35921,31630,29485,29616,27503,27535,29550,27437,27504,23343,10696,8550,21131,17004,23278,16938,21131,31697,31795,31827,10634,23311,29714,29681,38166,29681,38166,29649,40246,31762,40278,31794,40246,27569,40246,36085,38165,36020,31861,19183,23441,27635,19183,29715,21329,21329,29715,19151,25522,23376,17071,27438,48272,37871,23277,25357,29582,33743,19047,14887,21097,35824,29258,27470,21328,25521,29747,17004,25488,48566,48599,48632,50712,48632,52760,52825,50712,54905,54840,52760,57051,48534,39854,37839,35661,35629,33613,27437,8811,14792,29582,42293,27503,10731,16938,27470,25423,29648,48598,54937,38035,33939,35922,33809,25455,29648,42293,48664,46485,27562,8804,29873,27597,12935,8774,6597,4517,6598,4485,8678,4484,2436,4549,10855,10855,8774,10855,4580,8742,6726,10918,4676,2595,8838,6757,6756,10918,8805,2595,4675,8868,8932,13093,11045,11045,11044,15173,29640,23238,12772,12804,10789,21222,6626,2594,6820,8932,13124,42318,23496,29772,25482,17127,21288,19208,12902,12838,10822,8709,8741,23433,36077,255},
{57018,59065,56953,52793,52825,46585,42360,46553,44505,48665,63225,46585,40312,38264,40377,42489,40377,50875,42489,44505,42457,42425,42457,42457,40377,27701,31829,25555,19314,23475,29749,27636,25588,27701,23508,21362,15087,23408,21296,21264,17102,12909,15021,17102,25456,33842,25423,21262,23278,31761,38165,25422,12842,16971,14955,27600,29421,31599,50679,36019,25454,33710,37806,37806,27437,23210,23210,25259,23211,23244,21163,29616,31696,18986,19051,14858,27470,27471,16937,8550,19018,14859,14826,23212,19051,25422,33907,29649,10664,29681,27536,36020,33940,35987,36020,33907,38133,35988,38166,35987,36053,31762,42424,31794,25456,33940,23442,25489,19183,29747,21264,23409,27635,19183,27667,21264,21264,27570,12748,35791,48239,42031,29647,31728,31663,29549,27467,25323,31696,40146,21226,23340,25488,29747,31827,23408,33907,46355,27470,35954,29582,25422,29583,27535,25455,33809,31761,31729,35987,35888,33645,29420,29387,31436,33549,25292,23146,29420,35954,40180,17005,2246,23211,25422,27536,35954,54905,56953,48534,38100,27535,38001,27535,25423,33874,50777,50777,46551,38130,31890,36019,27565,17096,8710,6598,6598,4517,4517,4580,2531,2531,2532,4612,6692,4580,2595,6724,4612,2563,515,2627,8869,10981,6819,8901,8868,6755,4707,6820,11012,11044,11012,13093,13092,17253,29673,25415,16996,17029,10788,19142,2530,4707,6852,11044,15205,29802,27690,27691,23369,21321,23434,17128,14983,12870,8677,6564,12902,25545,31883,255},
{54937,57017,54905,50713,50745,48633,46553,46553,44505,48665,61113,44505,38264,38264,42425,44570,40377,50842,42457,44505,42457,42425,42457,42458,40345,27700,29748,23442,21395,27636,31797,25588,27636,29749,23508,23474,15087,25489,25488,21263,12909,14989,17102,15021,27536,35955,25423,25455,21198,29681,31794,31728,14987,27502,27502,17036,18955,29584,54905,36051,21293,29550,35725,31565,31631,21196,23211,25291,23211,19051,14891,14761,16808,16776,21132,10697,21163,27405,23211,19017,21130,19018,19018,12777,8550,21196,33907,25456,17003,33907,27536,38133,29681,38100,31762,38101,31794,38101,33907,38133,31795,38101,33940,29680,18922,35858,17103,27635,17103,25522,25522,19151,27667,21296,23409,27602,19118,25489,14892,39951,46159,42096,29583,29616,27535,25422,27535,16971,21227,17095,12837,19178,25456,29747,29747,25488,44341,50515,48371,37968,35790,29453,33679,29387,23212,31565,23211,23211,19148,23276,12712,12874,27403,16937,19181,4553,4195,23244,42260,35921,19084,19018,23309,21229,27503,38099,50647,56922,50614,35922,25455,35921,31696,25455,27568,44471,57116,55003,52891,48632,44504,44471,40212,29678,19209,17096,10790,8742,8773,6693,6661,8807,8743,10855,4612,4676,8805,10949,6787,6788,6787,6820,11012,11012,8932,8900,8900,8932,13092,15205,13125,13093,13093,13092,15173,25543,27559,15044,19206,10787,8804,2627,4739,8932,11044,17285,25673,31884,23466,23402,17096,12935,17129,21321,15015,10789,8676,17127,31883,36076,255},
{52857,56985,54905,46585,50745,50713,48633,44505,42424,48665,59065,44505,38264,38264,40377,44537,42425,50842,42457,42457,42425,42425,42425,42458,38265,27700,27668,23442,23475,25556,25588,27636,27669,29781,25588,23474,17135,23409,19215,17134,10861,15022,14989,12941,25456,35955,25423,25456,21165,27568,29681,23375,8681,23310,27469,25259,23114,31598,44308,33840,25356,27404,29452,21033,29485,21099,29518,31533,25161,25161,23081,25129,25129,23081,23048,21001,21002,21033,21033,18953,18953,18921,18953,12679,10566,19051,33940,19149,16971,35988,25422,42327,23376,40279,27568,42359,29649,42359,29713,42359,27569,40279,27569,33907,25228,33876,17006,25522,23377,19183,29715,19183,25489,27602,19151,27602,21231,19119,23343,42031,46159,37806,25162,29420,27275,25227,23245,23440,19175,21288,14949,12903,25455,29747,17101,25520,50647,52760,52760,54840,52760,54807,50614,52694,50549,50614,44243,48469,39919,31436,23015,21000,25064,22952,17165,10791,14820,31728,42325,29615,25325,29550,23277,25422,33874,52792,54711,58873,50484,40115,29584,31728,35889,27503,27535,29681,46584,55003,55004,52923,48664,44504,46552,38100,40212,40146,35953,35986,35984,31791,27500,21258,21258,23306,17095,15079,17127,15078,10948,10948,8899,8932,11013,11013,11013,11047,21482,11014,13126,15206,15238,19367,13125,19398,19334,13060,13093,8900,15110,8836,6755,6787,8900,11045,11012,25772,31948,25514,19241,23466,21321,10854,12967,21321,19208,19208,15015,23433,33997,33964,255},
{52825,56985,54906,46585,52793,52793,48633,44472,42424,50745,61113,44505,38264,40312,40377,44537,40377,46650,42457,42425,40377,40377,42425,42457,40345,27701,27668,25523,25555,25556,27636,27701,29749,29749,25588,19314,15055,17135,15054,15022,12909,10828,12941,15021,23375,38003,27535,25455,21165,25423,29713,27536,17003,23244,27470,37903,33677,31597,33677,35790,35822,33710,35823,37871,37870,31662,42130,37643,20838,22983,27144,10469,12550,12582,12582,14662,14662,16711,16711,16743,16743,16743,16743,18855,18823,19018,29747,21197,25422,33907,29616,40246,29649,42359,29681,42359,29681,42424,31794,42424,29681,40311,27537,42392,33713,29715,21263,19183,27602,17070,25522,23409,17071,27635,19183,21296,25457,12845,31696,44079,48240,33482,27112,29258,29193,27144,29584,36148,17062,17094,10756,6596,23374,23441,17037,33874,54873,52727,50614,52793,46486,54873,48501,50680,54808,46453,59099,52793,42000,39854,35596,37709,35694,33516,19082,19111,21192,33808,31696,25390,27438,27470,21197,27503,44373,56953,54646,56531,56596,46388,31728,27536,37970,29648,27535,27536,31762,36020,48730,52923,50713,50745,48697,38099,42325,48599,46519,44439,48566,44372,40115,33808,33808,33775,37969,40113,40113,40145,40144,40144,35950,33901,31821,29741,25546,23531,21451,17192,15144,13031,17290,29741,13094,19336,23495,13092,13092,13092,8932,8900,8900,8932,11012,11044,13125,15238,17286,23498,17127,12934,17160,10822,8742,12935,8742,21354,17095,23498,27691,31884,255},
{54906,56986,54906,48633,54873,52793,46552,42392,42424,48698,56986,44505,38232,40312,42425,44570,40377,46650,44537,42425,40377,40377,40377,42457,40377,27701,29748,27603,25555,23475,25588,25589,27669,27701,23540,17201,15055,15087,15054,12941,12941,10828,12908,14989,25423,33842,27536,27503,21198,25390,27601,19214,23374,23212,16776,29420,23146,23146,27404,29516,27371,25323,25324,27404,31662,31663,40017,39755,18757,16742,25096,3,3,3,3,3,3,3,3,3,3,4,4,4,4,102,4393,6441,6506,8586,8619,21165,19085,17102,25488,27601,29681,33874,31762,31827,29681,33939,33874,36052,35988,23408,25522,17038,25554,21264,23376,29715,19118,25489,25488,17038,25490,17038,37937,46159,46159,31272,29258,31306,25097,20936,29715,29743,14980,12868,8677,6597,23341,23376,25456,46454,50647,46486,42065,35726,39822,39887,39920,44081,42065,44113,46259,44210,41967,37709,35564,37677,37709,21261,6600,18983,31662,40148,29583,23277,29550,23277,23309,29648,50712,54743,56597,60659,60757,52597,35922,27536,33777,33809,29616,27536,27536,29616,31762,33907,38133,38133,38165,40245,40213,44406,44406,44439,44406,44405,44406,42260,42260,42259,44307,44339,46452,46420,48532,46452,44339,46420,46420,44372,50678,52791,46516,46451,42257,40208,42322,40241,36014,31821,29771,23496,19367,17254,11044,13093,11012,8964,23693,15174,11046,13126,13126,19369,23433,15048,15047,12935,10823,12935,12934,23434,23401,15047,17159,23465,255},
{54906,56986,50777,46585,54905,50713,44472,42392,42424,48698,54906,42424,38232,40344,40377,44537,40377,46650,44537,40377,40345,40377,40377,42425,40409,29813,27668,27603,23475,21427,23508,25588,27701,25621,25620,17201,13007,15055,12974,12909,12909,12909,12908,19150,27536,29682,23343,27503,21165,27438,29616,17101,21294,23180,12582,27339,27339,31532,29452,31564,29452,29517,29485,31629,31761,23277,40017,39820,27079,22951,33384,14597,14597,12549,12517,12517,12517,12517,12485,10437,8357,8357,8357,8325,8325,6277,6245,4197,4197,4165,2084,14663,18954,12811,17069,16939,27437,25324,25292,14825,14857,23244,35921,31696,42195,38067,23408,14925,12846,17068,19149,14990,14990,19150,31827,27536,21263,23213,39919,46159,41966,27080,29323,29192,27144,29387,23310,27567,19208,19144,21193,10790,23340,23375,33940,52792,52727,44275,37709,35661,35563,37741,33580,37644,33548,35564,35661,35693,39919,33581,37677,35758,35564,31564,33611,33580,40115,40147,25389,25389,29518,21197,25422,31728,50679,56629,56629,58709,60790,56758,38035,29649,27536,31729,29681,29616,27536,27536,27568,27536,27568,25423,27503,29616,29616,29616,31729,31761,27503,27535,27568,27535,27567,31761,31696,33873,40212,42227,44339,42226,42226,40178,46485,44372,52824,52824,48598,52791,50711,50743,54969,54969,57050,54969,52888,54936,52790,48629,44435,40241,36047,31885,27724,23530,23529,19367,17288,19306,25578,13063,13063,12999,8806,15112,23466,21321,19241,17128,15047,8709,255},
{54905,56986,50777,42392,54873,48633,42424,42392,44473,54938,56986,44505,38232,40344,40344,42457,42425,48730,46650,40345,40377,40377,40377,40377,40410,31894,27636,23475,23475,23475,25556,23508,27669,25621,27668,17201,15055,15022,15022,12941,12909,12941,12876,12908,31729,31730,23311,25423,23277,27470,35954,12908,23310,21067,12583,29419,29452,29452,33677,33710,33677,29549,33678,33743,31827,21165,40016,41901,25030,12549,31369,2116,2116,2148,2149,4197,4197,4229,4229,4229,6309,6309,8390,8390,8390,8422,8422,10470,10503,10503,10470,14696,23212,12877,17102,27470,29551,29551,29518,29518,21066,21164,19083,33775,44274,44439,25358,12746,14829,12906,21423,14826,10699,12844,36052,33907,19084,27470,41999,46192,37676,27048,29258,27112,29290,31598,25325,29648,42391,29614,38001,31693,27534,21262,38133,56953,57018,48371,37676,37579,35498,35531,35563,39756,35531,35499,39789,41934,39789,35564,35564,35661,37709,39821,37773,40049,42261,27502,23277,29550,25357,25390,27503,31728,40180,48436,48436,52597,54645,50549,35954,33842,29616,27568,31729,29681,29649,27568,27536,27536,27536,29648,27536,27503,27503,27535,29616,27535,27535,27535,27535,27535,27535,27503,27535,27568,27567,29615,27601,29714,29746,33939,33873,38099,44438,44405,44405,48696,52889,54969,57050,57082,57082,54970,57082,57082,57050,57049,54969,54969,54969,57050,57017,54936,54936,54903,50742,46516,42354,38159,33998,31853,25578,21386,27659,21321,21321,12935,10758,8710,255},
{54906,59066,52857,40312,52793,46553,42392,42392,44505,61178,63225,46585,38264,40344,40344,44505,42425,48730,48730,40345,40377,40377,40377,40377,40410,31894,23475,21362,23475,29716,27669,21460,27669,25589,27701,17201,13007,12974,12973,15022,12909,12909,14989,10828,31794,33875,29616,31761,38002,35695,33842,10827,19084,21002,14631,29419,25226,25258,29516,29516,29484,25291,27371,27404,27503,27536,37904,41933,29191,16710,33449,6243,2083,2083,2084,2084,2051,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4230,23082,69,8650,23278,25390,29551,29551,31664,25325,21196,21195,42194,40081,42325,33452,20579,35363,19078,21357,19051,10698,12779,31762,31729,19084,29517,41934,46191,33418,27113,29192,29225,35629,27470,23277,25423,42457,33842,42195,42228,31761,27503,46486,54905,56921,41934,37643,35498,35498,35498,37676,37643,35466,35531,41902,41902,37611,35531,35499,35499,39822,37547,39400,40018,44537,25390,25357,27502,23310,25422,25390,35987,36019,38100,33873,38099,38067,40147,35987,33842,31729,27536,29649,29649,29681,31729,29649,29616,27568,27536,27503,27471,25422,27503,27536,27535,27536,27536,27568,29648,29648,29649,29649,29681,31729,31728,27634,27831,21557,44636,23310,29648,31761,33841,33841,33874,33906,35986,40212,42357,44438,46551,50776,52889,54969,55001,57050,57082,57082,57114,59163,59162,59163,59163,59163,48631,52889,59163,57050,57017,52856,48629,35983,36015,25483,14951,8711,10790,255},
{52825,56985,56986,42393,48665,44472,40312,42392,46553,63321,63353,48665,38264,40344,40344,44505,42425,50810,50810,40345,40345,40377,40377,40377,40410,31894,21362,19314,23475,25588,25588,23508,23541,25621,29781,17200,15055,12942,17103,17135,10861,12909,15021,10796,33874,33875,29584,31761,33906,31695,35955,10763,23245,21034,20969,33677,31564,33709,31597,33677,31597,33645,31597,33677,33710,27470,35791,39886,29191,22983,31337,22983,22983,22983,22983,22983,22983,22983,22983,22984,22984,22952,20904,20903,20903,18823,18791,16743,16711,14631,14630,16743,27210,12550,8390,6342,14728,27437,27502,27502,23211,16970,27531,42225,40017,44340,43855,30722,41537,29380,23436,25487,10698,19117,29649,25358,19083,33645,41901,46159,29192,27112,29225,27177,33645,23244,17005,25423,38199,29616,42195,44308,31696,38035,54872,50614,50549,37676,37676,35530,39854,35498,35628,37611,37644,41967,39854,41999,35531,33451,35531,37611,37708,31369,33580,44504,38199,23277,29583,25390,23310,23310,27535,31696,33842,29648,29616,31696,31761,33842,31761,31697,31729,29616,27568,29681,31729,31729,31762,31762,29649,29648,27536,27503,25455,25455,25455,27503,27503,27503,27503,27535,27568,29648,29649,31729,31761,31761,29681,21295,19280,27700,21230,33874,33874,35987,38035,38100,35954,33841,33874,33874,35954,35922,33841,31793,33906,35986,38099,42325,44470,48696,52889,54970,57083,59163,59195,57082,57082,57082,57082,57050,55002,54969,52856,50744,46518,29646,21291,19210,255},
{52825,56985,56985,44473,46585,42424,40312,40344,46553,63386,65434,50713,38264,40312,42425,46585,42425,59130,52890,40345,40345,40377,40377,40377,40410,31959,21362,21394,19314,17266,23508,23540,21460,23541,27701,15120,15055,12974,15022,15022,12941,12941,10860,12876,33906,31762,29551,21229,21327,19182,31827,14955,23310,18986,23082,33677,29484,29451,33710,33710,29516,29517,29517,31629,31662,25292,40017,37773,24998,10469,29289,4196,35,68,68,68,2116,2116,2149,2181,4261,4294,4294,6406,10535,10567,6375,8455,8455,8455,10535,12615,25162,12615,12615,10535,14663,27372,29583,29616,27437,25420,21288,40112,42162,44307,42229,12779,14921,8618,9010,25488,12746,21360,23343,23310,23277,37871,46192,41966,27112,29257,29192,29225,25259,23277,36053,25488,29747,40180,42194,46453,33809,35954,46519,48567,42032,37643,33482,33483,35596,35563,37708,37611,35596,41999,41902,39822,37611,35596,37612,39724,33482,29321,35791,46617,31763,23309,27501,19146,17065,23341,29615,25422,31728,25390,29583,29616,29648,31696,29648,29616,29649,29681,29681,29649,31729,29681,31762,31762,31762,38002,42161,40049,37937,33776,31664,29583,27503,27503,27503,27535,27536,29616,29648,29648,29649,31729,31761,29648,27536,25455,31729,35954,35954,35954,35987,38068,38067,35987,38100,35922,35987,38035,35954,33874,33841,33841,29615,31728,31761,31793,33874,33906,36019,38132,40245,42358,46551,50744,52889,54970,55002,57050,57050,54970,52858,48631,38065,27597,255},
{50745,56985,56985,48633,46553,42392,40312,40312,46553,63353,65401,48633,38264,40312,42457,46617,44505,61243,54970,40377,40345,40377,40377,40377,42458,34071,19314,21395,19314,19314,25556,21460,21460,25621,25620,15120,12975,12942,12941,15022,12941,12941,12909,12908,35955,33907,29583,25357,21230,23343,25488,10697,23343,21099,23082,29484,25226,27371,29452,31564,29451,25291,23210,29484,29485,23147,40017,31434,25031,12582,29290,2116,35,100,35,3,3,3,35,35,68,100,101,2181,6342,2214,101,133,37,69,101,2181,23050,2181,2214,2181,14662,35791,31664,33777,29518,21194,19174,38000,38001,42194,42390,6993,2865,6799,15378,27665,21230,23408,19181,25455,23374,40081,46224,37708,27145,31305,29193,29355,29517,29681,44570,31795,31827,35988,38002,42259,21225,21229,36054,31664,27208,29419,37741,25423,36021,29550,23210,16873,25291,21130,25227,23081,21033,25194,29387,29386,31433,29354,29551,27569,25390,25453,14981,12901,8740,10823,23309,27502,29582,25389,29615,29648,29648,29648,29648,29648,29649,29681,31762,29681,29681,29616,29649,29681,29681,31729,31729,33809,33841,35921,37968,37968,37968,37968,37936,35856,33776,31696,31696,29649,29648,31729,31729,31729,29681,31729,31761,31761,31761,31761,33841,33874,33874,35954,35987,33842,35954,35987,35987,35987,35987,33874,29648,33874,33906,33874,35954,33873,33874,33874,33842,33841,33809,33842,33906,35987,38067,38100,38164,42325,42390,46584,44437,40211,255},
{50745,56954,54905,48665,44505,40312,40312,40344,46585,63385,65433,48633,38264,38264,44505,46617,44505,59195,57050,42425,40345,40377,40377,40377,40410,34039,19282,19314,19314,29716,27668,23508,21460,27701,25588,15120,13007,12974,12909,15021,14989,12941,12909,12908,31794,27568,29615,27502,21197,21165,36019,12842,25456,23180,23082,35725,33645,35789,29484,31564,31597,31597,29485,31597,31597,27372,39985,37741,25030,16742,31337,8356,8356,10469,6308,4196,4196,4163,2115,2116,2116,4197,4197,4229,6374,101,37,2116,36,69,69,4262,23049,68,4294,133,16743,33742,29615,33777,29551,23338,17094,35919,44307,44275,46486,13299,4846,10863,25102,35827,31762,21295,19149,29681,35986,40049,46191,33418,29257,31240,29225,31533,21132,19215,36185,25521,31729,29682,29647,23338,16967,25455,33973,31696,31369,33580,41999,27536,34006,27502,23210,18985,23243,16904,18985,12744,10631,16938,25389,29485,35659,29451,16906,12616,25422,23370,19175,19206,10820,8676,14919,27468,29548,31695,35921,35954,35922,33842,31761,31761,31762,31794,31762,31762,31762,29681,29649,29616,29647,27566,25518,23405,27568,27568,25455,25455,27535,29615,33776,35888,38001,40081,42161,42161,40114,40082,38001,35921,33841,31761,31761,31761,31761,31761,31761,31761,33842,33842,33841,31761,33809,33841,33842,35922,33874,33841,33874,35954,35955,35987,35987,35987,35987,35987,35987,35954,35954,33874,35954,35986,35954,33841,31728,33841,29648,29648,27568,27568,255},
{50713,54905,54905,48665,44505,40312,38232,40344,46585,65465,65433,46585,40312,38264,46585,46617,44505,57082,59130,42425,40345,40377,40377,40377,40410,31926,21395,19282,25555,33909,27668,23540,23508,29781,23540,15120,13007,12974,12942,15022,12941,12941,12876,17102,40180,38003,21262,19117,14988,17036,19214,6569,23343,23148,23114,29485,27371,31564,27339,25291,27372,29484,25260,29516,29517,23212,42129,37708,25031,18823,31337,16710,16742,18855,16774,16742,16743,16742,18791,16743,18791,20904,20904,20904,23016,18824,16775,18823,16743,16743,16743,18856,27210,12582,14663,12550,18855,33678,29615,33777,33777,25451,17062,35919,44307,42227,48566,17426,6831,31245,39275,41744,40246,21230,19149,27536,35955,37937,44079,29225,31305,29160,29289,16906,8553,17005,25554,25325,31696,29616,23306,17161,25421,25488,33875,27536,25227,35889,35792,31762,31827,31534,31499,31564,27403,29484,27371,23178,21065,16873,27502,31729,40081,35824,12584,16907,27535,23369,21288,15013,10819,8707,6627,19175,19271,21417,31854,42227,27502,38033,40114,38034,35955,33874,31794,31794,33842,31794,31762,33841,31820,17126,17128,15046,21293,27503,23309,23277,23277,25390,25455,27503,27568,29649,31729,31761,33842,38002,40114,42194,42194,44274,44274,42194,40114,38002,35922,33842,33842,33842,31794,33841,33841,33841,33841,33842,33841,33841,33841,33841,33841,33874,35954,35954,35954,35987,35987,35987,38067,38067,38067,38067,36019,35954,33874,35954,29648,33874,31761,29680,255},
{48665,52825,56953,50713,46553,40312,38232,40345,48665,63353,65433,46585,40312,38264,46585,44537,44537,52922,54970,42425,40345,40377,40377,40377,40377,27701,25555,19282,25555,25588,27636,25589,23540,29781,21459,15120,13007,12974,12942,15022,12909,12941,12909,17102,40181,33939,12941,8715,10795,19214,12843,10697,10730,14858,25292,29484,27339,29451,27370,23146,25259,29418,23147,29484,29485,23179,46290,39821,22918,14662,29257,3,35,2148,68,35,36,4,4,4,68,100,100,101,2181,69,2084,2116,101,2181,2181,8455,23049,6373,8454,6373,16808,37936,31696,33809,35922,19177,17063,40081,44339,40082,48534,21621,10991,41518,35401,43917,35955,21197,19149,25423,40116,38002,37805,29225,31305,29225,33515,19052,16939,25390,19020,27504,25358,33711,23303,19208,23407,25456,36085,27568,21131,36053,31730,29649,33973,38069,37774,33741,33677,33710,33677,29451,27371,23178,27436,29615,35955,44374,29519,25390,31695,21320,12933,10852,10820,6659,10852,6596,4579,17254,27755,48565,42194,27658,29676,48467,46451,35986,31729,31762,31794,31762,31793,29710,25545,17125,15045,12965,14985,21260,23373,23277,23309,27470,23309,27503,27535,27568,29616,29648,29648,31729,31729,31761,31761,31794,33874,35953,38034,42194,44274,44306,46354,44274,42194,40082,38001,35921,33841,33841,33841,31794,33842,33842,33841,33841,33841,33841,33842,33841,33841,33841,33874,33874,33874,35954,35954,33874,33874,35955,33842,33874,33874,31794,255},
{48665,52793,54905,50745,46553,40312,38232,40345,54970,65433,63353,44505,40344,38264,44537,44537,44570,52955,50810,42425,40345,40377,40377,40378,31959,25556,25556,23475,21363,21395,25588,27669,25589,27701,21427,15088,15055,12975,12942,15022,15022,12909,17102,14989,29682,27601,12909,8683,21197,29648,10795,10729,6601,8617,37937,37903,40016,37968,35823,35791,37936,35855,35823,35823,33775,33711,46322,37708,27111,25031,31337,16709,16710,18791,18758,16678,16678,14630,14630,14598,14598,14598,12550,12550,12518,8357,8358,8325,8357,8389,6309,12583,23081,6309,6341,2148,12614,29484,31696,31728,29583,14951,23306,44275,46420,40081,50712,25911,4814,37454,33291,41613,37938,21229,19117,23375,40148,40082,33548,29193,29192,29225,27372,27536,25391,25292,16809,29682,27471,33676,19141,21387,19085,27601,33940,23310,21132,36053,38166,27569,36119,36118,37969,37969,37968,40114,40081,37936,31695,25291,31564,27405,29552,38165,29649,27503,29615,19241,15077,15078,10853,4515,8772,6532,4483,15142,27755,54937,48628,21415,21384,44404,42255,33936,29649,27567,27598,25549,25548,19240,17126,12933,10884,10821,12904,10822,10791,10632,16970,29583,27470,31728,33842,33842,33842,33809,31761,31729,29648,29648,29648,29648,29681,31729,31729,31761,33842,33874,35922,38002,38034,40113,42193,44274,44273,44306,42194,40114,40082,35921,33841,31793,33841,31794,33842,33842,33842,33841,33841,31793,31761,31793,31761,31761,31761,31761,31761,31793,31794,31794,255},
{48665,50713,54873,52793,46553,40312,38232,42425,57115,65433,63353,44505,40345,38264,42457,44537,44569,52954,52858,44505,40345,40345,40377,38297,25588,25556,27668,23443,29684,31797,25588,25621,25589,27701,23507,15088,12975,12974,12974,15022,12909,12909,12909,12909,21328,33842,14956,23310,40049,40113,21164,17003,14922,21099,42163,38066,40179,40245,42326,40213,40148,38035,42359,42359,42359,42294,46355,37676,20838,16775,27208,4228,4228,4261,6309,6309,6309,8389,8422,8422,8454,10502,10502,10535,10535,10535,10535,12583,12583,14695,14695,20936,27210,16743,18856,23017,12710,21129,33776,33809,31696,16969,29581,42227,46420,42194,46420,38166,32024,40248,40054,50552,40149,23310,23310,25455,33776,33742,25260,23113,29354,27274,21098,29616,25390,29518,29617,42490,29682,23337,21255,21455,21197,31827,29649,21359,15053,33940,38231,29616,31925,38132,38001,29648,38001,29680,33841,29615,19116,25389,29484,21162,33875,31762,25423,29615,27471,21290,8773,12934,6693,4516,6629,8613,10725,17158,25611,52857,40273,21447,19368,40373,36014,33935,29649,25519,25515,21352,19239,12966,12934,8740,10853,8740,4482,6628,6564,99,12744,25388,27469,31663,33809,35954,38035,38068,38067,38067,38035,35987,33874,31761,31729,29648,29616,29648,29649,31729,31729,31761,31761,31761,31761,31761,33809,33841,35921,38034,42194,44274,46354,46354,44273,42161,38001,35889,33809,31761,31761,31761,33842,33874,31794,31793,33842,31761,31729,29681,29648,29648,255},
{48633,48633,54873,52825,44505,40312,38232,42425,59196,65466,61241,42425,40312,38264,42457,44537,44537,55002,52858,44505,40345,40345,40377,40377,25620,25556,25588,21395,27636,23476,23508,23508,25621,27701,23507,15088,15055,12974,12941,12941,12941,12941,12908,12908,17069,29649,23375,27503,40048,40048,42161,42162,35920,35921,33873,31760,29647,29647,29615,27502,27469,25421,25422,25389,25389,25390,38034,37708,22918,20870,29257,6276,6276,6244,6277,4164,4163,4196,4228,4196,2148,2116,2148,68,36,69,68,68,68,68,68,8454,18921,2149,10535,20937,2180,21098,31696,35987,35922,16969,31695,35921,46452,44307,46355,50778,31797,38232,31894,44603,31795,17036,14923,21197,37969,35856,21099,25292,35823,35791,25324,25390,33776,31728,38199,31927,31892,23304,16996,17195,23504,31795,33973,31892,21229,33908,36151,33776,31860,38066,38034,31727,35823,21130,31629,23179,14858,29615,14919,23372,40181,27536,27471,29615,23310,23374,21258,10919,8773,4548,6598,23276,36019,46616,46484,52824,40240,29770,25545,44403,35916,31854,29713,25548,21354,21353,15013,10788,10788,6595,6562,12868,8675,6627,6530,10628,21191,23337,25451,27565,31759,35921,35954,38035,38035,38067,38067,29710,31792,35954,35954,33874,35954,33872,31791,27630,31728,31728,29615,27535,29583,29615,29616,31696,31729,31729,31761,31794,31794,33873,35921,38033,40112,42192,44240,44273,44241,40113,38001,35921,33841,31761,31761,31761,31761,31761,31793,31793,255},
{48665,48601,54873,52825,44473,40312,38232,42425,57148,65466,59097,42425,40345,38264,42425,46585,44537,52890,54938,44505,40345,40345,40377,38297,25588,25556,25556,21394,19314,21395,23540,23508,25621,27669,21427,15088,15055,15055,15022,17102,12941,14989,10828,12876,17069,40116,27601,31663,35855,27469,29517,38001,31695,33873,33873,29615,25389,25389,25422,27470,23309,23309,21131,21163,21196,19083,21132,27340,27209,29290,27242,27242,27242,25129,25162,27210,25096,23016,23016,22984,22984,20936,20936,20904,20871,20936,20936,20904,20936,18856,18823,22985,25129,16743,20936,25097,14631,25324,31729,35922,38068,23276,31663,31728,46420,44307,44307,46586,33942,33942,42425,48731,31859,21262,21197,25488,35922,31663,33776,33743,33776,40081,35856,31696,37969,33808,29682,27700,23436,14916,14884,17293,27632,27601,36119,36086,29451,33875,38167,38134,33972,40082,31760,27437,37968,27404,35823,38000,29582,29517,10725,25453,38068,25390,29616,27471,23310,25423,35954,31757,27596,17064,21291,25454,33904,38293,48631,54904,57083,55068,54838,54805,31819,23465,17128,21353,25578,27690,21319,15046,21318,21253,17060,12867,14980,17060,10755,19110,19174,17060,17124,17321,21449,19305,23499,33936,38098,40146,35983,23401,21321,25517,33809,33809,33872,23465,21383,17158,31824,35954,33841,33808,31728,31728,29647,29615,29615,29616,29648,29680,31729,31761,31729,29681,29648,29648,29648,31728,35888,38000,42161,44273,46353,46354,44273,40113,38001,33841,31761,31761,255},
{48665,48633,52793,52825,44473,40312,38232,40345,57147,65530,61209,42425,40345,40312,42425,44505,46617,52890,57050,44505,40345,40345,40377,40377,25620,23508,21395,19314,17234,19347,21428,23540,25621,27701,21395,15088,15055,15054,15022,17135,12941,15022,15021,19182,23343,31697,33842,33743,38000,31727,27437,40114,33776,35921,35986,31728,27502,27502,29648,27535,25422,27502,23309,25389,23277,25390,29485,20871,23017,14664,12583,12583,12648,12616,12584,10503,10503,10503,8390,8390,6310,6277,4229,6309,8390,6342,6341,6309,8422,6342,8422,10567,6374,4262,8520,10535,10535,27502,33841,35890,31729,27438,38002,29583,44339,42227,44373,38200,38199,31797,52925,42391,27601,25358,21262,27634,33809,29550,35890,33775,31662,40081,40049,33809,35888,31694,27567,21324,19145,17030,10788,10986,21424,27633,38198,36053,23211,29615,36118,36216,38067,33808,27470,31533,33776,25259,27535,4747,6503,25324,14886,21291,33842,25390,31663,25358,25358,29648,46486,54871,54871,46453,44373,35920,27467,31693,35919,46485,38129,40308,48597,42320,23433,17126,12933,12933,23497,23497,19207,17062,23431,23398,19140,17061,21285,19140,8643,8675,12868,10819,12867,8902,8934,10949,12997,17222,25608,29770,25480,19206,12966,15015,29679,33808,31788,25575,21382,23495,23465,23468,34004,38165,40212,35921,35921,35921,33873,33905,29709,25515,25516,29679,29680,29616,27535,27502,27502,27535,29615,27568,29648,29649,31729,33809,35921,40113,42225,46353,46386,44306,255},
{46585,46585,50713,52793,44473,40345,38264,40345,57115,65530,59097,42425,40345,40312,42425,42425,46617,52858,57050,44537,40345,40345,40377,40378,27701,23475,19314,19315,17234,17234,21428,23540,25589,27701,19314,15088,15055,15022,15054,21328,15022,17102,14989,12877,31762,29616,33808,33744,33776,31727,31695,35921,35921,33841,31760,31760,31728,29615,29648,27535,29648,29647,29648,27503,25422,31696,35857,25064,27210,8326,6245,4164,10568,8488,8423,6310,6375,6342,14793,16873,18986,21034,18954,19018,21065,16840,14728,10599,8486,6373,2181,4229,4228,133,2279,8552,19019,29550,33809,35955,31535,29389,40115,29648,46420,46420,50745,31862,40280,33942,48796,38068,29648,25423,23375,25488,31761,27568,33744,37969,33775,40081,44274,33841,29646,23403,19176,17062,12870,8676,8611,6500,15215,27633,38231,31762,15085,27568,33940,38199,38001,31761,33808,35856,31630,31598,27567,8876,12873,31727,25355,27534,29616,27502,29551,25390,25390,40148,52792,56984,54904,50679,50679,33939,23374,31696,44373,44373,40145,37999,40143,27625,15012,10822,10854,10853,15078,21352,17095,21319,25478,19205,12868,14917,14981,15012,15013,17125,12932,10851,15012,8739,10852,17157,17157,17221,23462,25543,23430,17093,8740,10916,23496,29770,33963,29800,21382,21382,12964,10951,27763,25650,38328,33808,31695,35951,33965,27721,19270,15076,17221,19303,21385,25547,27567,25422,25389,23309,25389,25422,27503,27535,29616,29648,31729,31729,29681,29681,31761,33841,255},
{44505,46553,48633,50713,44505,40344,38264,40345,54970,65498,59097,42425,40345,40344,42457,40344,46617,50778,54970,46617,40345,40345,40345,40410,31959,21395,19282,19315,19315,19347,23508,23541,23541,25621,19314,15088,15055,17135,15022,15022,12941,12909,10828,19150,38035,35889,31728,31663,31630,29615,31630,35889,35921,31728,31695,31728,31728,29583,27502,27502,31728,31696,29615,25422,25357,31728,35923,22984,23017,8325,8325,6245,12649,8455,6310,6342,4230,6310,21164,23244,27437,31663,31663,23244,25356,25357,18986,16840,16841,16841,14760,14728,12679,14793,14826,10665,19084,27503,25358,33841,29584,27438,38035,29583,46420,46421,48699,36086,40280,42360,42392,35922,29648,27536,25520,21263,25488,14859,35856,40049,33743,40114,42162,33840,23370,17096,14982,12868,10723,10755,8643,8611,23632,33809,36053,25488,31826,33842,31860,36019,35888,33776,35888,33743,33743,31662,27437,19050,6564,19244,40180,31728,27503,31664,27471,27503,29616,46518,54872,54904,50744,54872,54871,38035,21262,29615,46454,46422,48567,46452,31820,15045,23400,17095,14983,12934,8708,23399,17061,21286,21317,12900,10756,14885,14982,25576,23431,19238,15077,17126,12932,12900,17093,14981,12900,15076,19302,27688,31784,19206,15046,27752,31912,27719,25607,25640,15109,15109,10819,6595,10824,8680,15052,21163,29614,34027,25606,21413,21414,23494,25574,15107,17220,21413,25576,27565,27534,27502,27502,27502,27535,27535,27535,27535,27567,27568,27600,29648,29681,29681,255},
{44473,44473,44472,48633,46553,42393,38264,40344,57050,65530,59129,42393,40345,40377,42457,40344,46617,46649,57050,48665,40345,40345,40345,42426,34104,21363,21362,21363,21395,25556,25588,27669,23540,27701,19314,15088,15055,17135,12941,15022,12909,12941,12876,17069,31729,31761,31728,31663,29517,27501,31695,35889,33808,33776,33808,33808,29647,29615,29583,29582,27502,27502,25422,25390,25389,31728,35890,20871,22985,10438,10406,8357,12648,10438,8325,6310,10503,8390,23278,25357,27469,31695,31663,19018,25324,29714,21131,20936,21001,25195,25227,25194,23147,29616,21197,14891,16938,27470,25358,35922,21068,23245,23375,23277,46420,48566,40313,36087,33941,40280,31827,33841,25455,29648,27568,19117,23310,31631,40049,37969,33775,40082,40081,25451,15014,12838,14982,10788,10755,8675,10723,19108,17193,27697,29616,29714,36020,36052,33939,35921,23244,14857,35790,23145,33709,25291,23211,14822,6659,8742,31696,29615,27535,29583,25423,25390,38035,50711,56985,56985,52792,52856,56984,35889,23310,35922,46454,46422,46454,42258,23400,25517,40017,42097,38001,31759,27628,29640,27526,27558,14979,19237,23398,19174,19174,21319,17094,15014,10788,15014,15045,17126,17158,14981,19142,15045,15044,10946,25609,29674,21351,29832,29832,25639,21382,19270,10852,12964,12932,6562,6658,256,257,8740,27691,38251,34056,27750,27751,21445,23558,21413,15107,17220,15075,19209,25421,25421,27534,29615,31728,31728,31728,31729,31729,31728,29648,29648,27568,29616,255},
{42393,42393,44440,48601,46553,42393,38264,40312,59130,65529,59129,42425,40345,40377,40377,40344,44537,44569,55002,48665,40345,40345,40345,42457,36217,21427,21362,21395,25523,25588,27637,27701,23540,27701,19314,15087,15055,15055,12942,12941,12909,12941,12908,12876,27505,31763,23343,25390,27469,23276,27437,40114,33841,38002,35986,33841,31728,31728,29648,29648,33809,31760,27535,25422,25422,33841,37938,20903,25033,8358,8358,8357,16841,10503,8390,10535,10568,6310,14858,21132,23212,23277,23277,21163,25422,21197,21098,23114,25195,27340,27372,27307,25292,31696,25455,17037,8520,16906,27470,29584,12650,27471,31631,29518,42162,50745,33942,38199,33876,31861,27600,33939,27471,33842,38068,17036,19149,40147,35856,40049,35856,29389,29644,19175,14983,12870,12870,12868,8643,12835,19108,14916,12901,25617,23309,33973,36052,38198,40113,37870,27501,25290,35823,23178,35856,25324,27437,21193,4643,12903,23211,27503,31663,25422,23342,27535,46454,54872,57017,56985,54937,50744,50678,31762,19249,25455,46486,46454,46519,40374,31793,33972,42456,52989,50844,50844,36050,21320,29736,25510,19205,25607,29801,29770,31754,19174,19175,17062,8676,15014,17094,15013,14981,17063,40113,44338,40112,31755,31820,35948,29769,27720,21382,23495,19302,23494,12996,19334,25638,21380,23493,19269,12964,15075,29865,31945,31913,23493,25638,19300,17220,19333,12994,19301,10851,10853,19145,21163,25389,29582,31695,31695,31760,33874,33874,35954,35954,33874,33842,31761,255},
{42393,40312,42392,46553,46553,42393,38232,40312,59129,65529,59097,42425,40345,42425,40377,40344,44537,46617,54970,48697,40345,40345,40345,42425,38297,21460,19282,21363,25523,23475,27636,29749,23508,27733,21394,15088,13007,12975,12942,12941,12941,12908,14989,17037,23376,35988,23408,23310,29614,27469,29550,40146,33840,35921,33841,31728,31696,29648,29615,29648,35922,31728,31728,27502,25422,33841,37906,22951,25033,10406,10438,8358,16809,10503,10471,10535,8422,8390,6342,6277,4229,6278,4165,10567,16938,12745,21098,20969,23082,23147,25227,25194,25227,35955,36085,21230,12713,14793,27470,29583,23050,19051,33809,31696,35888,48697,33909,38167,36054,23310,25389,25552,21229,27600,33842,19117,17036,29714,31631,40049,29454,21001,21320,17063,15015,10790,12870,12868,10755,21253,19140,14916,14980,27696,31696,29746,27633,34069,46419,44241,44209,35855,35824,27404,37968,25324,31662,14983,4579,21195,25357,29583,29615,25390,23342,35954,50711,56984,57017,56985,57018,50646,40114,33840,25390,38035,46486,44373,46486,42357,27568,23441,46683,57215,57247,57247,38130,23431,25542,21285,17093,12901,21383,25576,27593,25417,25481,19175,17062,19239,17094,17094,12933,16999,29612,29742,38097,44372,48533,50645,46515,31913,21349,15014,19271,29832,21381,19333,23494,17188,15075,15108,17188,19364,31976,21412,23494,15108,17253,23493,21445,17220,15139,6690,6691,8770,12964,23305,23307,27501,29614,31695,33808,33873,35954,35954,35987,35987,36019,35987,255},
{40345,40312,42392,46553,44473,40345,38232,40312,59129,65529,59097,42425,40345,42457,42425,40345,44505,48730,54970,50777,40345,40345,40345,42457,36185,23508,17234,23443,25556,25524,29749,31862,25589,29781,21394,15088,15055,12974,15022,12974,12941,12909,14989,14956,23344,35988,19215,25390,29517,25324,27469,42259,40114,38001,33808,31728,33841,35921,29615,29648,35954,31696,33873,27535,27502,35922,35825,22952,25033,10406,10438,10438,14761,10503,10471,10503,8390,10471,8422,6277,6278,6278,6277,16808,19018,16905,23147,23081,25194,25195,27307,27339,27371,35987,31828,21263,27569,25291,29550,35857,29292,21132,33809,33776,35954,44473,38134,36021,40247,14826,31728,27535,25422,29681,33842,21197,12779,23309,37936,40049,31565,21224,21256,19144,14983,12870,8645,12870,17061,21285,14916,12804,15014,21455,27535,27569,27568,19442,31825,35920,31760,40147,33841,35921,35986,31728,25387,4579,12903,33744,29616,29615,27470,25390,27503,44406,54872,59065,59098,56985,59098,50679,40114,21262,23244,42228,46454,44373,46454,44340,33870,36085,50909,59327,59327,55069,35986,25544,19237,14982,16997,16965,27625,27657,25576,19175,21352,12901,17094,21287,17094,14982,10789,12772,12837,8772,12965,17191,33870,36049,40243,44433,27656,23496,31946,27686,23462,15044,19237,10883,12964,10851,10882,29864,34056,23493,19301,27752,17189,15141,17252,19300,17156,8770,2433,10883,12995,12931,17062,37966,25481,25548,29710,31759,35921,35954,38035,38067,38067,40180,255},
{40345,40312,42360,44473,44473,40312,38232,40345,61274,65529,59097,40345,40345,42457,42457,42425,44505,50842,54970,52826,40377,40345,40345,42458,34039,25588,23443,27603,27636,27636,31830,31862,25589,29782,19314,15088,15055,12974,15022,12941,12941,12909,14989,12908,23343,38036,25456,29649,31695,27437,29583,33873,29680,31793,29680,29647,29680,29680,29615,33808,33873,33808,31729,29583,27535,31728,27341,14598,18792,8325,8357,8358,14762,10503,8390,6277,6277,10535,8423,6245,6310,4230,4165,14728,19050,16938,25227,25161,25259,25292,27372,27372,27437,38035,27471,17036,29715,29518,27470,35922,37776,29551,40115,35889,35987,48764,46683,46618,48731,38068,31728,27470,29615,35954,31729,23278,17070,23310,42162,42130,33806,19208,14951,14984,14983,14951,6565,8677,17093,17028,10755,8579,10723,15116,21359,27601,29844,21522,35888,31727,31695,40114,33809,38001,31793,31695,14951,2563,23340,33776,29583,29583,25390,25390,33842,50712,57017,59065,56985,59098,59066,54840,44275,31663,23277,42260,44373,44341,44373,40114,42224,55069,59327,57247,48731,50778,31762,17066,19206,14981,16997,17029,23464,27657,25481,19143,17095,12902,17095,17126,17095,15014,8707,6595,6595,6596,10853,8772,21321,17126,15110,17255,25641,36139,25607,29800,23398,15013,27719,21381,10851,10819,8738,29864,32009,21413,17188,25607,17221,8803,6723,10884,6626,2433,4546,6691,6658,10786,14949,29546,17124,15076,15109,19303,23497,27660,29742,29742,33872,38067,255},
{42393,40312,40312,42425,42392,40312,38232,42393,61306,65529,54937,40345,40345,42457,42457,44505,42425,48698,54938,54906,42425,40345,40345,42458,27766,23540,21427,19282,19282,23476,27669,27701,25589,27734,19314,15088,15055,12974,19215,12942,12941,12909,12909,10796,25456,38036,23375,23376,25455,23310,21293,12874,6601,8682,12843,12841,6601,4488,12842,44439,25488,31531,31404,35922,25260,29518,25228,12615,16776,10406,10406,10438,14729,10503,8390,8325,8357,12584,12583,10405,10438,8358,12550,21033,23146,18986,25227,25129,25194,25227,25259,25291,27437,42358,29584,19018,25456,35889,27437,35922,38068,31664,38067,38002,33907,36021,33875,35988,31827,38068,33841,27470,33841,33809,29616,25390,17037,23310,44275,33839,17128,15015,10726,6533,12903,12838,6565,8645,17093,19141,10755,10723,10723,15148,27632,31859,23635,35921,35888,35888,42194,38001,40081,35888,33808,29549,4579,4612,19084,29583,31663,27502,27503,25423,42293,54872,59098,56952,48566,59098,52791,56985,46226,25164,29389,42260,44373,44341,42260,42194,44338,59229,52891,44570,48730,48730,29714,19211,23431,14981,21222,21222,27593,21351,19239,21288,19207,17127,12966,15015,12870,14982,10788,4548,4483,8708,8741,10757,23370,12965,12996,17220,27687,25607,25575,23463,23400,21320,23527,15012,15044,12931,12963,23591,25672,19301,17221,21414,17188,23429,19203,6594,4547,4578,6626,257,10819,21284,19173,21221,17092,21317,17156,15140,15108,13060,17286,29869,25577,27626,255},
{40345,40312,40312,42393,40312,38232,38232,42393,61274,65497,52857,40345,40377,42457,44505,46585,42425,48730,54905,56986,44473,40345,42425,42425,25653,23540,19314,17202,17234,19314,23508,25589,23540,25653,17233,15088,13007,12974,19248,15054,12941,12909,12941,10828,23375,35987,23342,29615,27503,21229,23405,10730,6569,10761,14922,10761,4455,2376,10698,38166,25553,31659,35755,40149,40018,33711,25293,25489,21101,8325,10406,10470,14761,10471,8358,8358,10470,23050,37870,35757,29451,33644,31564,37902,37903,31565,37871,35757,31564,35790,33709,33710,35822,38001,33711,31597,29517,35920,27469,31728,23278,25357,35954,42195,31729,29583,29583,29583,25389,38034,31728,29615,38034,25389,31729,29616,17036,23310,42194,21322,10854,14951,8645,8612,12838,12839,12838,8581,14917,14980,12836,12835,10755,15212,29712,29713,21555,33840,31727,29647,40082,29615,40081,35953,33808,19112,418,6600,14925,27503,31663,25422,27503,31729,46552,54872,59097,50646,48598,56952,46420,54872,44146,25196,25098,40147,46421,44373,42260,42193,48531,52792,44340,50810,46617,44471,29811,15277,19271,19206,17030,21255,25545,21352,17127,21321,17095,10789,15046,15014,17095,10789,10789,6596,2403,6596,8740,4482,21257,12932,10916,17253,29832,19237,23463,27689,25448,19206,15045,12901,6627,10884,12963,21446,29864,23493,17188,15141,27687,36039,36007,19171,14979,21317,21284,15010,17124,19172,19205,19204,19237,38059,25414,23464,21382,21414,23463,31950,33867,27528,255},
{40312,40312,40312,40312,38232,38232,36184,42393,61275,65530,50777,38264,40345,42457,46585,46585,42425,50778,54905,54906,44505,42393,42425,40377,25621,23540,21395,21363,25523,23476,23508,21460,23508,25621,17234,15120,15087,13007,15022,12942,12909,12909,12941,12876,23408,40180,25456,33809,31729,23310,23406,10698,10730,12842,14890,10729,8617,8617,12810,29681,17003,25356,29484,38035,52858,40147,25195,19052,21035,6245,8357,10471,16842,6277,6310,8390,10470,37805,42096,37903,29484,33710,27403,33710,33709,27404,37903,31597,31629,37903,29516,33677,35790,29484,31629,33677,27404,31662,17036,17035,29519,27438,35922,44308,31696,23309,19084,29583,31696,44340,31696,29615,38002,21196,29648,33874,17004,21229,38000,17128,8709,4420,19082,35820,33707,21192,19112,19015,16997,14948,12868,12868,10788,6596,17393,27991,25617,35888,29615,35921,31663,25389,38034,31794,29582,6628,4580,14956,14891,31663,29583,25390,25390,40181,48632,54905,57017,46486,42292,42259,40114,46419,46322,37936,33744,42260,44341,42260,40147,38033,42291,55070,55069,55070,55070,57117,27667,10990,15085,25416,23207,23305,25577,17159,12870,17096,14982,10789,8741,14982,15015,6597,4451,4452,2372,4484,4516,8612,23307,21223,8802,19398,29832,19205,19238,27721,27624,17061,10819,12900,10851,10883,12931,25607,25639,21446,15109,19237,36039,31782,31782,23397,31783,27622,25509,25477,21284,19173,14980,14980,17124,23367,17062,15078,15078,17254,27624,29705,33866,29512,255},
{40312,40312,40312,38232,36152,36152,36184,42393,61275,65466,46617,38264,40345,42457,44505,44505,42392,46617,56953,52825,44505,42425,42425,40377,25653,23508,23475,27604,27636,27636,25556,25621,23541,25653,17234,15120,17168,12975,15022,12942,12941,10860,12876,14989,23408,38003,25455,29648,27535,23310,17101,6569,10762,10762,14955,8616,8617,10795,12810,21230,19149,27503,31534,35825,38002,31695,25162,23049,29356,10405,12486,14599,18890,10438,10438,10471,12583,29453,42096,37935,31564,33645,27371,35790,31596,29452,37903,31597,31629,35822,29516,33709,33710,31564,33710,31597,27436,33743,19051,31662,42228,35793,33809,40147,33776,23244,19051,29616,35856,46421,33809,29583,31631,14858,25422,33842,17036,19117,31759,15015,8742,8678,25485,52627,48335,37935,40081,35756,21158,14948,10756,10788,12836,6564,15280,19278,21164,27567,35921,35888,25422,35888,27535,29582,23274,2467,8679,14859,25422,31695,25390,25390,29616,46519,50712,56985,50647,40344,44602,42292,42358,44437,52725,35856,38034,44341,42260,42228,42195,38034,42424,59263,59327,59263,57215,55070,25683,23764,29811,29581,35952,27467,29578,17159,12902,12871,14951,12805,4483,10822,10855,8711,4420,4356,10759,12838,8581,25387,23306,33806,23400,17286,27688,19269,23430,15045,21383,21286,25383,17092,19236,15076,17188,17157,23560,19334,12996,27622,33893,31781,23395,27622,29735,27590,23398,14948,17060,17061,12836,8675,12900,10787,8706,10819,10819,15012,15045,19239,29641,29577,255},
{40312,40312,38232,36152,36120,36120,36152,44473,61307,65433,46585,38264,40345,42425,44505,44505,40344,46585,59033,56985,46553,42393,40345,40377,27733,23508,19314,23443,29716,27669,27669,27701,23541,25653,17234,17168,17168,12975,14990,12942,12909,12909,12909,17070,19214,33713,27536,27536,27502,23310,17068,4488,4488,6569,23276,27567,8584,14793,14793,21164,10760,21228,33711,27308,27373,23083,23211,29582,33647,8292,10405,12551,16842,10470,10438,10503,8390,21035,42193,42128,42063,40015,37870,42095,37902,37870,42095,37870,37870,39983,35822,37903,35822,33709,37902,33709,33677,35855,21164,38001,40147,35857,33809,42163,35889,27502,25357,27470,31631,48567,35923,29615,33743,12746,23309,35954,19117,19117,27533,12935,8710,6565,17099,50612,42095,40080,40081,40014,25352,14948,12868,10755,10724,14982,17031,16966,10759,19213,29615,27502,19180,33808,19148,29550,14918,2405,6569,14859,29583,29583,25390,23342,38067,48599,52792,56985,44340,27536,27829,36541,32347,34395,32086,31695,38034,44308,42228,42195,42228,38034,44438,57214,59263,57215,57215,55037,25553,15248,21392,33678,40081,39983,37837,29610,15046,14950,15015,12870,8644,4452,2244,4358,2277,6439,14923,21261,29679,44404,35918,21192,25515,15076,27752,27720,19270,14981,21350,25511,25543,25575,15011,8739,19269,14980,12997,15142,23462,38088,36006,31781,21219,23429,31751,21253,19173,12868,12868,17093,8642,10724,17061,19141,21191,23271,21190,17061,10850,10883,27593,33802,255},
{38232,38232,38200,36119,34071,34071,36152,44505,63419,63353,46585,38265,40345,40345,46585,42457,40344,44505,56985,57017,46585,42425,40377,42425,27734,19347,15153,17234,21395,25556,27669,29750,23573,25621,17233,15120,17168,15055,12942,12941,12941,12909,10828,19214,25455,35826,27536,23343,37937,33745,29648,8681,4456,6569,21261,19181,12810,23115,16841,16970,14922,21195,39985,31533,25228,23018,21131,27470,31534,6212,8325,12518,14729,6245,8357,10439,23082,37838,42161,42128,42161,42193,42193,42193,44242,44241,42193,42193,42161,42161,42193,42161,42161,42193,42193,42161,42161,40113,29517,33743,35921,38002,35857,35791,29582,36054,23309,29583,35890,40214,21133,37969,31696,12778,19052,38034,23310,19117,25453,12934,10789,10726,19083,50711,52791,44339,31695,42095,31627,21223,17093,10755,10724,16998,14918,12773,6468,4324,4261,19214,16938,18985,12808,10760,4579,6632,6473,19117,31663,27470,25390,29616,50679,52760,54905,48533,42294,29648,25749,32413,28186,32314,17296,14858,25357,44308,42228,42228,42195,38034,44438,59295,59263,59295,59295,52891,23375,14989,17036,39853,43981,43981,41999,39950,27433,23337,17095,12902,10792,14890,16970,16970,14857,12712,14922,19149,29712,27534,31792,31792,23371,21382,25608,19302,12900,25576,27688,25575,23494,17189,15044,8643,8707,15077,4482,6692,27687,38088,31782,31782,21252,27590,25478,12836,12868,8643,10755,12868,8610,19141,14980,10787,21223,31595,27272,35756,35787,27496,29609,35785,255},
{38232,38232,36120,34039,34039,34039,36152,44538,63420,63322,42457,38264,38264,40345,46617,42425,40344,44505,59065,56986,48633,44473,42425,42425,27766,19347,15154,17234,15186,19347,25589,27701,25654,25654,17233,15120,19249,15055,15022,12941,12941,12941,12909,15021,27503,33778,27536,29648,46422,29583,27535,4521,2440,8649,10762,17069,25423,25228,18953,12777,6536,21196,37937,31566,27307,25130,23211,21196,16873,20937,23082,23115,23083,12551,16743,23017,40016,48434,46289,25488,27600,23440,25520,27568,21391,23535,21454,19406,23534,19406,21454,23534,21454,25582,25582,25518,31727,31727,29581,29549,29614,31728,31696,35921,40082,33908,25358,29583,44406,31829,23278,37969,25391,21198,14859,33809,27503,17037,23342,31693,19176,6566,23373,54905,57051,44405,48664,52725,33676,17063,17093,10756,12836,14886,10628,12773,10661,8549,4356,8584,10697,18985,16968,4644,4644,8745,14891,25390,27438,29713,23310,35987,54970,50678,52825,33907,38263,33874,25781,32348,28121,32249,23601,14760,25357,44308,42195,44308,42228,38032,42357,59327,59295,55070,59263,50811,25585,23569,25487,39853,44079,41901,35692,31532,27338,33709,25354,17131,21326,25487,27600,29746,33874,37741,35693,21197,31728,25258,25387,31596,29514,35852,33867,23464,27624,31913,23462,21382,15076,17189,8738,12964,10755,14981,4450,4547,19237,38055,35974,29636,19139,23398,19140,14916,14980,12899,12868,10755,12867,21253,12835,12868,19174,19110,19015,39983,46225,39951,46288,42092,255},
{38232,38200,36119,34039,31959,34039,36152,46618,63420,59098,40345,38232,38264,40344,48665,42425,40344,44505,56985,59098,50713,44505,42425,42425,27798,21428,15154,17234,17234,19347,25621,23541,25621,27734,17234,17168,21361,15087,15022,12941,12973,12909,12909,17102,27568,29585,19117,35955,42326,27471,29616,6569,8617,12843,8681,6601,23310,27276,18985,6536,4391,23342,29388,35758,33645,29355,27437,21196,8616,31598,33679,31663,31696,16939,23211,31564,46323,48369,46288,25520,27600,21391,23503,21454,19374,23534,21454,23502,27630,25517,29646,29614,29581,31662,31661,29549,31694,29581,29549,29549,27469,23050,29551,40147,42195,27470,29583,33809,48664,27537,29551,33776,25390,21197,12810,31695,31696,17036,21229,40114,37968,10759,31792,50744,52889,40180,40212,40147,29451,14950,17061,10756,14949,16998,12741,10629,14854,14854,4324,6404,6438,14792,14921,4612,10855,8650,19116,29583,27470,25455,27503,50679,40210,25482,27628,21289,23501,17064,21586,28122,26008,26008,34069,29582,33776,42227,42260,44308,40081,35886,44372,57182,59262,48698,59327,50778,21521,25878,29842,42097,42325,39950,25290,16904,21097,40016,44113,29616,29713,29746,31859,31826,33907,46095,50321,39984,42162,42064,42063,41998,41998,41998,37965,31850,27721,23527,25640,25574,17156,19237,6658,12964,10819,10756,2306,6563,19205,31783,31782,25476,21285,21253,23366,21221,14916,17093,17028,10691,12803,19141,14979,21317,14916,8674,8773,23435,38096,31724,48402,48337,255},
{38232,36152,36087,34039,31959,34039,36120,46618,63419,54970,38265,38232,38264,40345,52858,42457,40344,44505,54905,56985,52793,46553,44473,42425,27798,23508,17234,17234,19315,19347,25589,23541,23541,27734,19314,17200,23442,17135,15055,12941,12941,12909,12877,19182,27568,31730,23310,33842,35987,25422,33874,8682,6569,8649,4456,10730,27470,25228,18953,8648,10762,27536,31566,29453,27339,23082,23277,19084,10696,31630,31598,23179,23179,21131,21130,21098,44340,46353,46288,33807,31759,29678,33806,33806,33774,35854,33742,35822,35854,33741,35822,33742,31661,33742,31661,31629,33742,31629,31661,31661,25356,25194,29583,38067,40147,27502,29550,33841,29745,35922,48368,35760,23376,25358,17069,27503,35889,17004,19149,33874,29583,25420,46485,50778,42358,42293,50611,44207,21161,17094,15013,8644,17062,19078,14789,10565,12710,12741,4355,6437,8519,14825,19017,6661,25486,19084,25390,27470,25357,25390,33873,40210,23368,21255,21288,17095,8709,10822,19241,13067,19636,25975,23473,23440,31663,44308,42260,44243,44177,35920,33906,40312,53022,55134,59327,50746,19182,17069,27503,46029,43916,41835,37936,38000,25290,31597,39920,25358,29714,33907,33939,36052,33874,46062,48241,42129,42129,44177,44209,37805,50223,44047,35692,29642,27657,25544,23463,25607,19269,12996,12964,10852,8771,4483,2209,4322,25511,33895,23365,23333,17060,21253,25445,23333,14948,14948,14948,19141,12835,10755,10787,21285,19205,14980,10788,10888,25676,29805,46386,37900,255},
{38200,36152,34071,31959,31959,31991,34072,44570,63419,52890,38265,36184,38264,42425,52858,42457,40345,44505,56985,54905,56921,50713,44473,42425,29879,23541,19347,17234,25556,21428,19380,21460,23509,29782,19314,17200,25523,17135,12974,12942,14990,12909,10828,19182,29649,29584,25423,35922,35955,29616,27568,8649,2408,10698,8650,12909,31665,25228,8583,6567,4456,27568,37904,35791,35791,29420,23277,19051,10632,31630,31598,33646,18986,18953,16905,14824,40147,46321,46321,46289,46321,46321,46321,46354,46321,46321,46322,44241,44241,44241,44241,44241,42128,44209,44209,42128,44209,42161,37903,33774,35823,35823,38035,42260,38034,31696,31663,38067,23277,48633,52690,27630,12844,25292,14859,21164,33776,19117,23341,17004,19019,33775,50679,50777,36020,52891,54837,27433,12806,14982,12901,8644,17063,21191,14822,10597,16967,10661,6500,6436,4422,27469,29550,14953,38099,27502,27437,27503,33940,27535,29643,23369,21320,21287,15014,17095,8676,17159,17127,6565,13001,15311,15052,19018,31630,42195,42227,42293,31859,27634,23473,36183,57215,52957,48764,44538,21458,17264,23439,33547,33547,35627,29354,25291,23177,25323,21163,25455,23375,33972,33972,36085,42162,52271,48305,42161,44209,42129,40016,29419,48077,46095,39887,35725,27561,19270,17158,15076,8708,10820,8739,4515,8709,10759,19083,27531,29672,35943,25445,25444,19108,25446,27526,19108,8643,12835,19173,25414,19140,10755,15012,21285,19205,10755,10787,17130,29772,27659,25416,21127,255},
{38232,36152,36119,31959,31959,31991,34072,46650,61308,46618,38232,36184,38264,44505,52858,42457,40345,46585,59098,54905,56921,52761,42425,42425,31992,23541,21395,17234,21395,21428,19348,21460,23541,29782,19314,17201,23474,15088,15023,15022,15022,12909,12909,19182,31762,31633,23278,33809,40181,25455,19149,4456,2377,21262,8682,12843,25228,23082,16873,4455,16841,38002,40180,40179,44274,44307,27535,16971,6471,31598,31598,33679,18954,10599,8486,8454,31696,42128,40048,42128,42128,35855,40080,35855,37935,40048,37935,40048,37968,37903,42128,37904,40016,42129,37968,42128,42128,42128,35822,29549,37968,37968,35955,38067,38035,35856,33776,44439,35955,55069,50613,27631,16906,25357,18987,14761,18922,21034,29518,14825,25324,31695,44373,33841,35889,46617,57017,35659,14791,6501,12870,10789,17031,16998,12741,12709,12742,12742,19082,14857,10664,29648,35954,31761,42293,25357,27469,25455,27960,33971,27562,19144,23369,17094,17127,15014,10821,12902,10789,8710,12935,8680,134,12713,29549,40082,42227,40211,25616,27666,25456,38231,50844,44537,50844,38101,19376,11021,25584,31467,29450,41998,29354,23178,27403,23209,19115,29649,23375,33972,33939,33972,50451,54481,44210,42161,42129,40016,37904,31467,46029,44015,39887,37806,33931,25575,21350,19302,12932,6627,15078,6532,8615,14922,27600,46519,31690,31750,31749,29670,27526,25447,27591,25477,14915,17062,19141,25383,19077,16964,10755,14980,17092,10787,6595,17162,25546,27435,20967,16839,255},
{38232,38200,34071,31959,31959,31991,34072,48762,59228,44538,36184,38232,38264,44505,59129,42457,40345,44505,59098,54905,56921,50713,42425,42425,34072,23541,19347,17234,19315,21428,19380,23541,23541,27734,17234,17168,17201,15088,15023,12974,15022,12909,14957,17102,29682,31633,23310,31761,38100,29615,21262,4457,328,17069,17036,27373,31436,29322,21066,2343,6440,25423,36018,33873,40113,38033,27503,21229,17003,25357,27535,21197,19051,16970,14857,12713,23244,50546,40015,40015,37935,29484,35822,27404,33709,35790,31597,35855,31597,29517,35823,27404,33710,35822,27467,35822,31629,31629,33775,17100,44340,44339,31631,25390,38035,42261,33808,40213,29649,46650,54839,40113,23278,25356,14728,12648,18889,14663,12680,25357,31597,29582,46453,48599,40147,52923,48503,26985,27242,12679,12710,14918,14918,14918,19079,8549,8517,25356,38068,21197,17003,29681,38100,42359,40180,25325,25389,23310,29845,42357,29675,19143,23368,17095,14950,8646,15015,4420,2275,8743,10988,10925,2213,8454,27404,40114,31788,23432,15045,23502,33973,38165,42457,44537,44472,31762,17069,14989,27470,48109,48044,43916,43948,39852,21000,21196,25455,27568,21229,29681,29713,33907,33907,33678,44145,42097,39984,37903,37903,37773,50190,41968,39887,39887,35917,27656,23495,17093,19174,14981,12772,23048,25194,27372,35888,48532,27334,33831,31751,27526,25415,21254,23334,21254,17094,10692,14981,19206,19173,14916,12868,17093,12900,12900,10755,21291,25547,27403,20967,14822,255},
{38232,36152,34071,31959,31959,31991,34072,50843,59228,44537,36184,36184,38232,44505,59129,42425,40345,44505,57050,54905,59001,48633,42393,40377,31991,23541,21395,17202,17234,19347,21460,23541,23541,27734,19314,17201,19281,17136,15055,12974,12974,12941,23344,23440,27601,29553,21231,33874,35955,38034,15020,4488,2409,8649,19149,27406,23083,21002,16905,14889,16970,29616,38099,37968,37935,40082,23309,25422,23342,21229,21197,21229,21196,19116,19084,16971,23244,48369,42063,40015,35822,29516,35790,27371,35790,33677,31564,37935,29516,31629,35823,27436,35822,33742,27468,35854,31596,33742,33774,17099,27567,33807,37904,27438,33842,40214,38002,38100,29583,46584,48631,35887,19019,23277,14923,12875,33841,25422,14956,16971,33710,33743,44373,63455,46487,55003,37971,20841,39951,40015,37902,35821,31627,16966,12773,6500,16936,37969,46520,27503,19083,29681,42294,46553,33809,25357,25390,25390,31761,48565,27562,21256,19175,14951,10727,6566,4421,130,99,4520,10826,10761,12678,16838,31629,38064,27689,21319,12901,21355,44570,40278,33973,46617,42359,33907,17069,15021,29550,50124,48011,45995,31593,21191,17001,33776,40018,37840,21164,25454,35955,38165,40018,41967,42129,40016,37936,37904,37903,44080,39788,41968,44081,39887,33549,27403,23304,23111,27175,27336,23080,37515,37449,35336,41899,63254,54671,44270,38028,33833,21221,23303,19143,21256,17062,17094,10756,17126,14980,12901,10724,15013,14948,10788,12805,21130,25323,33644,23241,14983,255},
{38232,36152,36119,34039,31991,34039,34072,48795,59260,44537,36152,36184,38232,46585,54970,42425,40345,44505,59130,54905,59001,48633,42393,40377,29879,23541,23508,19282,17234,17267,21460,23508,23541,27734,17266,15121,17201,17168,17168,17135,17168,12974,17103,25553,29714,29585,17070,29714,35955,35986,10826,6633,2441,8650,25422,23245,12681,12648,14793,29549,40050,31630,42063,42095,35822,42128,23244,29647,33906,31825,31793,29713,29680,27600,27599,25487,27534,46354,42128,42128,40015,35790,37902,33677,39983,37870,35790,40015,33677,37903,40016,33645,40015,35822,33741,40015,35822,37903,37903,23308,25453,27501,44308,33842,29616,35889,33776,29583,27502,50778,33973,10764,10699,23278,16971,12811,31728,29583,14924,21229,42195,35889,42293,61342,57049,52793,23247,23310,46386,50547,48466,48466,44272,31627,31628,12806,12809,42260,48633,40213,23277,23375,38133,38101,29551,25357,25423,25390,40180,38096,25481,21224,14951,12903,12809,23146,23016,16709,12614,14954,19082,16936,23111,16806,19015,29674,25575,15076,10853,25517,42457,42391,35987,46617,48763,40278,17359,13069,35855,29386,27403,43981,29545,19176,21258,23307,29681,31794,31794,29682,36020,44179,50289,44177,40082,42162,37903,37903,35758,29321,31403,44081,39920,35661,33581,31468,27274,33481,35433,37417,33877,36021,39626,47915,54448,58803,54643,54741,52691,38059,23366,27529,23336,23434,33771,21224,12838,12933,14982,8644,10756,10756,10723,4450,6498,14918,21224,29578,17127,17191,255},
{38200,36120,36119,34039,34039,34039,34072,48795,59293,42490,36152,36152,38232,44505,54938,42425,40345,44505,59194,56985,61049,46553,40345,38297,25686,23573,23508,21395,19347,19347,23508,23508,23541,27669,12974,12877,12909,8586,12811,12876,12877,10763,10763,17037,23278,21197,21230,23375,21262,19149,10729,8616,6536,12778,19083,19084,23245,33743,27470,27470,31696,23276,29549,33742,31629,31597,16938,25422,25487,21261,21261,19181,23374,19181,21229,19148,17003,17003,17003,25356,27469,29549,29549,29581,29581,29581,29549,31662,31662,33742,37871,35823,35855,37968,37968,42129,37968,40048,40049,37935,38000,35823,44373,38068,35922,35889,33809,25390,29583,44472,23507,10829,10698,21198,17004,12778,29615,33809,19117,21295,38034,38001,36020,59228,59129,33841,23276,31663,40113,40080,37968,40048,44306,37967,40048,21163,12777,38067,48698,46585,27503,25423,23342,23277,29550,23277,23309,29649,46454,38031,23369,14951,10791,12874,17068,27503,37806,48109,52269,48174,46094,46158,43981,39820,33611,29705,19270,17157,10820,23470,44505,40279,48731,52891,57150,42294,15085,13037,33742,41931,29545,27433,25385,19208,21257,19177,29714,33907,31794,29682,29779,46323,54482,46323,40016,37903,37904,37904,33710,33514,44048,39920,35694,37839,39953,31501,31499,37707,41643,45868,39759,37743,37449,51979,51979,49899,47818,45738,43723,37706,27432,21256,21287,21353,40111,25354,6435,12741,14886,14885,8580,14885,21031,19016,8581,8708,21351,15045,15046,23496,255},
{38200,36152,36120,36119,34071,34039,34072,50875,57213,42490,36152,34104,38232,40345,52858,42425,40344,44505,61242,54937,50713,44473,40345,36185,23573,23573,21427,21363,25524,25589,25589,21428,23541,25556,12844,10698,10763,2213,6439,12778,10730,10665,10665,14891,19052,14858,27535,23277,12777,10665,8584,8551,8551,14825,21066,18953,33809,40114,23309,17003,14890,21131,21099,19018,19050,16970,25422,21196,16971,6439,12712,10600,8552,8552,12713,12582,2181,4293,6406,4294,4326,8552,8520,6407,6439,6439,2181,4358,4389,8519,25097,16904,19018,19018,19051,23309,29583,25357,19117,19116,27405,31501,31729,31729,29648,38034,29615,27405,33776,36085,12779,14761,19052,23343,19117,12778,23342,33809,17069,27569,33874,38034,33841,52890,57016,44306,46354,40081,33775,35855,33710,44241,37968,38001,33775,25391,14858,31729,48697,50778,33842,25487,21164,23277,25389,23277,23309,40180,46420,46420,37966,21224,10791,12906,23407,31859,33973,33907,40114,48434,54707,54708,52595,52626,44270,25479,19238,19270,4548,27697,46650,38166,40311,55102,57182,33908,19215,19216,35757,44010,29480,21191,23304,19144,19209,27600,31827,31827,29649,29714,27601,31859,48274,44113,40016,39984,37903,37904,33678,35595,42000,37807,37774,40018,44276,31468,33644,39821,43788,54612,48109,48141,48044,52012,52012,49899,49964,45770,41577,39561,35562,25481,29674,35982,37934,25289,21128,27369,18919,16901,10627,16838,29386,27404,16969,19177,25577,21319,15013,19270,255},
{38200,38200,36120,36120,34071,34039,36152,52956,57213,44538,36152,34104,36184,40345,48698,40344,40312,44505,61274,54937,48633,44473,40345,38265,23605,23573,21427,21363,23443,25589,27669,23508,23541,25556,10763,8650,10731,4294,6406,10730,10730,10698,8617,16939,16971,12810,23277,23310,12810,8617,8552,8551,8551,16938,18986,16873,33809,33841,23309,10697,10632,14825,14792,16873,23178,16905,23276,19018,17003,8519,12745,17003,8519,8584,14826,10566,2245,4293,8552,8519,6471,8552,10665,8520,8487,10503,6407,4262,4294,2116,6470,10661,17000,12744,14825,19018,23277,25390,19117,16971,16971,27502,35987,38100,40213,42261,44342,27340,35922,29683,14663,29421,29649,29747,29649,12778,14923,35889,12778,14891,35954,40115,29616,48697,50680,42161,50579,42096,46321,42096,44241,42160,46355,42194,33775,31795,29617,25389,46584,52891,40213,25455,21197,25358,23309,23309,27471,44405,44306,48501,48500,35918,29580,17035,27601,33972,38166,36118,36086,33776,37837,44078,46288,44303,27592,19205,17157,19271,19276,27698,31826,40343,44504,50876,55102,29681,15020,15020,35660,48043,39818,23304,19111,17033,29680,31794,31794,31794,25456,27601,29681,27633,33842,37872,37936,39984,39984,39984,31532,35596,41968,37774,37806,37807,37807,33581,37805,43949,47852,47884,41642,48143,47980,54060,51980,49899,54287,50061,45900,45933,37905,42321,50610,50642,39918,33612,33612,37805,37774,33676,35820,42063,42096,39982,31563,21193,25513,17063,8709,15046,255},
{36152,36152,36120,36120,34071,34039,36152,52988,61340,46618,36184,34104,36152,40345,44537,40344,40312,44537,61242,57017,48633,42393,40345,38297,25686,23573,21427,21395,23476,23508,25589,23508,23541,27538,21066,14793,18954,8455,6407,10632,6472,4359,4391,4359,2214,2181,4326,4326,2213,4326,4358,4358,2246,4358,6374,10567,12744,12745,14793,12680,8519,10632,10664,10599,14793,12712,10632,10599,8519,4326,8551,6471,4326,4326,6439,6374,2245,4261,4326,4326,4294,6407,6407,4327,14761,16776,12712,12712,8455,10567,6437,8613,6564,2340,12680,16905,16970,19084,19084,19052,17004,23277,40115,40213,35954,36019,40312,25358,33809,29423,12616,18987,19084,17070,23343,12810,17036,38034,23310,14891,31761,42227,29583,46584,38004,27244,48500,46353,48401,44208,46353,40015,44241,29516,25387,23309,23343,25389,46519,52923,42294,25423,23277,23278,25422,25390,31696,42227,38001,46388,48501,48533,48533,35889,29714,33940,38134,36053,40279,35823,41965,37837,44143,42159,27593,19237,17257,27763,29747,36118,34005,50843,46618,55102,44440,25616,25875,27762,35758,42258,35918,23240,12807,19245,31860,31795,31762,31762,27568,27601,29682,29714,33744,37904,39984,37936,40016,37903,31499,35660,44081,37774,37774,37774,37774,33581,37707,37577,47851,47819,45739,39530,41512,54060,54060,49899,47819,43625,41577,41578,35661,52886,56916,54771,39886,35661,37773,39886,39886,37805,50611,65500,65500,65500,59031,35918,35918,21191,16966,19173,255},
{36119,36120,36120,36120,34071,34039,36184,55100,61340,44538,36184,34104,36152,40345,44537,40345,40345,44537,61242,61146,54841,42393,40345,38297,25686,23573,19347,19315,21395,21428,21428,21460,23541,25392,27307,18986,27339,14760,10632,12778,10665,4359,6472,4327,68,68,68,68,3,4293,6471,2278,100,4325,4325,10599,10599,14890,14922,16937,14825,10664,10664,14857,8519,8519,10631,6471,6438,10599,10599,6406,2181,4326,4261,2181,2246,2213,2214,2213,6471,4261,4262,133,23277,27437,31630,29517,25356,25356,14856,8581,2371,2339,10597,14728,10632,16971,19116,21165,16971,23310,35922,29616,31729,33906,29747,27536,38134,27375,25358,21164,12584,8585,12778,12778,14923,38066,27471,16972,27536,38165,27470,42293,31566,33645,50580,50514,50546,50547,50546,48434,44306,27467,27469,21196,21229,23342,46519,48665,42229,25422,23310,23310,27503,27470,35922,48534,35889,44308,48501,48501,48501,33776,31827,38166,38199,40246,42327,35758,41998,23178,35823,37935,27563,23368,15046,17162,17230,29747,31892,48730,44504,57215,46520,21229,12907,15020,39788,43948,41835,35594,23145,19082,23375,29682,29714,31762,27601,29681,29682,29714,35955,42130,37904,39984,40016,50483,48240,44048,39921,37774,37774,37774,37775,33581,37707,37545,47851,47851,45771,41578,45739,54060,54060,54060,52012,50060,47915,45738,39822,46582,63355,61112,37838,44145,35693,35693,35693,33612,44240,61177,57048,59097,52694,48500,50580,44273,40047,31690,255},
{36120,36119,36119,34071,34071,34072,38265,55132,57148,42457,36185,34104,36152,40377,44538,40345,40345,44537,61242,61145,50713,42393,40345,38297,25686,23541,19347,19314,23475,21428,23508,21460,23540,23246,23146,16905,29452,12647,6407,14858,10665,2278,4391,4359,133,133,4325,8486,12712,12712,10632,4358,4326,6438,4358,6438,10632,12777,12777,14857,12712,14857,10664,12777,6438,6406,6406,6439,6438,8486,8487,6406,2245,4294,2148,100,4294,133,133,2214,10632,4262,4326,2213,29550,27470,27404,33743,31630,25356,25356,21130,10727,4420,4421,12777,12680,23244,19051,23212,21132,21164,25391,21132,29616,38067,31762,31599,23344,29748,36054,23278,8455,10730,12876,19117,17004,38002,29648,17004,23342,29613,16968,14887,19082,42193,50547,50546,50579,52659,50547,50580,37967,27532,23276,21229,21262,25422,44374,52859,40148,25422,23310,23277,23310,29583,44308,44340,37969,42194,37935,42226,48501,29583,31892,42457,42424,44472,40279,35822,48370,48401,48369,44272,33836,33835,21318,12932,4517,29844,42456,55069,46648,52955,42356,25451,10729,12809,37577,39592,37512,37577,37674,33548,21294,23440,31794,31795,25455,29682,31762,31827,39887,42032,39984,39984,39984,40049,35693,39822,37807,37774,37774,37775,39855,33613,39853,43852,49932,47819,45771,47851,47851,54092,52012,51979,52044,46387,48502,47884,39953,48662,65469,54742,31500,27306,27307,29419,29452,29451,44306,46321,35787,42225,52760,54808,54840,54872,56985,54871,255},
{36119,36087,36119,34039,34071,36152,40345,55132,55068,40377,38232,36152,36152,40377,42457,40345,40345,46585,61242,61177,52793,42393,40345,38297,25654,21460,19315,19282,21395,27637,27669,23509,25555,29453,27339,12745,29419,16840,8552,12777,8585,4391,6472,4391,2214,101,6406,14857,19083,19084,16938,10664,10664,8551,2245,6438,8584,6439,4358,10729,10729,10664,8616,10665,10664,8584,4423,6471,6503,8551,10599,8551,2213,4326,4326,2181,6406,133,2245,6374,8487,4261,4326,4325,35629,35792,27502,27437,35888,29549,27436,27404,21130,12743,8647,21066,21033,27502,23277,29259,23211,23277,25422,33810,37744,40181,27568,29388,16776,23507,29715,25358,14891,10665,8585,12811,12811,29616,35922,19084,25453,25386,16935,12774,10630,23275,38001,29549,33808,35855,29517,27437,25355,29614,21196,23277,23310,27471,38099,52891,38035,25390,23277,27535,33842,44308,52597,48501,44308,44340,44340,44308,44308,29584,36085,40312,36053,40279,38166,37870,48500,48401,48401,37995,21318,21318,17092,14981,8613,10858,44602,50841,31820,31885,27625,25512,23401,19209,31626,33642,33513,35659,52756,54869,33837,23407,31827,33908,29681,29649,29714,31795,41935,42032,37936,39984,37936,35823,27306,41837,39855,39855,37774,37775,37775,33612,46126,48045,49932,47819,52012,58286,54092,54060,54060,49899,43691,44015,48241,45803,35823,44435,44370,44176,35694,33613,27339,25227,25259,27371,37968,35823,40145,52791,52759,52727,54807,54839,59001,59033,255},
{34039,34039,34071,34039,36120,36152,40345,57148,52955,38297,38264,36152,36152,44537,44505,40345,40345,46585,61242,63225,56921,42425,40345,38297,25654,21460,19315,19314,23475,31797,21428,21428,25522,33612,27339,12745,29419,14728,8520,12777,8585,4391,8584,2246,36,68,4293,8552,10697,8584,12745,8584,2278,4326,165,6438,10696,8552,8519,12809,12810,8584,6406,8519,12809,8584,6471,8519,8616,10664,8486,4326,133,4326,2213,68,4358,2181,6439,6407,8551,6309,4294,4293,27242,35532,35824,25389,29550,33776,29550,29550,27469,23276,19051,16840,20969,21196,21197,31696,21164,25292,31663,42293,33324,31632,33874,31598,18791,19117,33974,21197,16971,10632,12778,16905,12778,27503,40148,21228,27530,21159,14854,10629,10597,10598,19050,12744,21196,25390,25324,23179,31695,25455,19148,21197,21229,25487,35986,52891,33842,23310,23309,33808,44406,57084,61147,48533,44274,40114,48566,44373,44308,31729,42326,36053,40279,40312,38166,37902,46420,40178,46288,31786,21350,19205,14980,14949,14918,15017,46647,38191,23401,21288,21351,27624,21318,15015,21319,21384,21190,27467,48596,54901,35916,21257,21291,19179,21294,21326,23408,29747,35791,37904,37936,37936,37903,35791,31466,45997,39855,37774,39855,37775,37775,35693,48175,47981,49900,52012,60301,56108,51979,54060,54060,51979,45738,43593,43626,45803,29484,16968,21259,37839,35726,33645,31565,29452,25259,21066,25226,25259,40113,52791,52694,54774,59000,61081,61081,59033,255},
{34039,34039,34039,34039,34071,36152,42490,55004,48730,38265,38232,36152,36152,48698,44505,40345,40345,46617,63290,65273,63161,44505,40345,38297,25654,21428,19315,19315,25523,31797,23508,21428,27570,33644,27339,14825,27339,14760,10632,12810,10665,4359,6504,4327,69,101,133,2213,2213,4326,10665,6471,4358,6439,132,4326,4391,4326,2246,4391,8584,6439,2245,4359,6439,2246,2181,2214,6439,8519,12712,8487,2213,2214,2213,2148,6439,4294,10632,8487,8519,6341,2246,4293,14825,16937,37645,27470,29583,31728,33808,31728,31728,21228,6534,261,8584,12777,21197,38002,35857,23277,29583,44341,27244,25358,38166,29551,16711,17004,17135,16971,14826,6439,12810,19182,10730,23277,40115,23307,21222,19078,12741,14822,10629,10629,21162,27469,27469,29615,33776,33808,40180,25390,21229,23310,23342,27567,48632,52858,29616,23310,23309,35888,35954,33841,46520,59229,52792,40048,42227,38067,40083,31728,42326,33941,38231,38199,38134,39950,48501,50547,50449,38029,23399,25447,19173,12901,27562,36013,36078,31818,21320,19239,19239,17125,12899,19206,23400,17060,19077,16741,19017,27595,25448,21287,17062,12837,8677,2372,2276,17101,23440,35856,37904,35823,37936,33710,35627,48110,41968,37774,37775,37775,37807,37838,48174,47948,49932,54126,54027,49866,51979,54060,54060,54060,52076,50190,48013,43723,42258,52691,35758,35693,35726,33645,33645,33613,31533,31532,31500,31565,29450,38001,61081,61113,61081,59000,56888,54840,255},
{34039,34039,34039,34039,34039,36120,44570,48795,40377,36185,36184,36152,36152,42457,42457,40345,40345,46617,63322,65241,61081,46553,42425,36185,23573,21460,19315,21363,33812,35926,23476,25556,29649,33644,25259,12713,29419,14792,10632,12778,8585,4391,6504,8585,4327,101,100,68,3,2246,8584,4326,2278,4326,68,2181,133,100,100,100,100,165,165,68,68,36,68,68,100,2180,8486,6406,2245,2246,4293,35,4262,6407,8487,4293,6374,4294,2246,6374,29484,10696,21098,27308,29647,31728,33841,33808,31760,14954,2308,2276,8518,14793,25422,35889,42195,38100,31729,33874,25326,25423,40246,25390,10534,14891,12942,27569,16971,23310,12778,29682,14923,23276,40082,25390,19144,12741,10629,14823,16935,16968,27502,31663,33743,31663,33808,38034,35987,23309,23310,23342,27503,35954,54971,44407,27503,23310,25390,33776,33841,31728,31729,55069,48698,40311,37969,33808,38035,29648,40278,38199,36085,36118,36053,39950,48500,52529,50449,50481,42094,39885,29481,21255,33930,29738,25513,21320,21288,19176,17094,14947,12836,17095,21287,23431,19141,16933,17030,12837,17061,19174,19142,14982,10790,4452,4453,23375,25456,35856,35823,35823,37904,33678,39788,50223,37775,37775,37774,37775,35726,39950,48109,47916,49900,45771,47787,43658,52012,54060,49932,49867,47948,31792,46291,43755,46451,44144,37839,35726,35726,35726,33645,33613,33645,33613,31533,29452,42258,58968,61048,58967,56888,52727,52726,52727,255},
{34039,34039,34039,34007,34039,36120,42490,42490,38265,36184,36184,36152,36184,40345,44505,42425,40345,48697,63322,61113,59001,48633,42425,31959,21493,23573,19315,27571,40053,38006,23508,25588,27635,31565,27339,14825,29419,12680,8487,10665,8617,6471,6472,8585,4359,2246,2246,4326,2246,2246,4358,2246,2245,2278,100,2181,2245,133,133,132,100,2213,2246,4326,6439,4293,10632,6374,6374,8486,6438,6439,2213,2213,8519,2245,4294,4326,8584,6471,8422,2213,133,12680,31630,25130,21163,25421,21163,29582,21196,21164,19083,6534,2340,2276,4325,12745,23309,31695,40116,35923,40180,40180,35954,33842,31795,23310,12646,21132,19215,27634,14891,19084,12778,31859,14891,19083,40082,27471,17067,19114,16934,12775,19016,27437,35922,23277,29582,33776,33776,40180,29615,23342,23310,25423,29583,44340,40115,31728,29551,23310,27471,38101,40148,29616,31761,55069,55004,42392,31729,35888,40082,33841,38133,40246,33972,38199,35987,42063,40082,31597,44176,33775,40016,40048,33677,31755,31817,33964,29737,25544,23335,19208,27594,21253,14949,14981,21256,23399,19109,16998,12901,10755,12868,14981,14917,17063,14982,6564,6565,19246,27634,42162,42096,37936,37903,31598,27274,35628,37872,39953,37807,37774,35694,37772,35659,45868,49900,45739,43723,41577,51980,54060,49964,50127,50060,50190,50191,41870,42129,35693,35693,35693,35693,33645,35726,33645,33645,33613,31532,27436,48630,63291,56854,50581,52726,54871,54903,54871,255},
{34039,34039,34039,34007,34007,34072,40377,38264,38233,36184,36152,36152,38232,40377,42457,42425,40345,50777,63354,61081,61081,48633,42425,25686,21493,23573,21427,33780,40053,38006,23508,23508,25621,27537,27339,12745,29419,16840,8552,10632,8584,6472,8552,8552,2278,2278,4359,4326,4359,2246,2245,2213,165,165,133,68,2246,133,100,100,100,2213,2246,10632,12810,12744,16905,12712,14792,12744,6438,6406,4293,4294,6407,2214,4326,6407,6439,6407,6342,8422,2181,8486,29549,27114,27275,27535,21097,29550,16906,16905,14857,14857,6469,4389,8485,12745,25357,29583,27470,33939,42261,48534,35890,31697,23310,23342,14759,33743,19215,14892,10633,16938,19116,21295,12745,14891,35889,31663,17004,23309,29712,23308,31662,35856,38002,23277,29582,38002,33841,40213,25422,23342,23310,25455,35888,46420,31664,31696,25390,23310,27503,35955,32154,21426,29648,57149,59295,42195,35856,44275,38034,36053,42326,42228,29713,40279,35922,42063,40016,31531,44143,31630,35789,31627,25353,38091,36042,31851,25513,19206,21319,23431,23431,27590,25477,17092,8644,8643,12836,12868,12868,12901,8676,6434,2145,12805,14982,10789,10757,10759,12907,33840,44210,46258,42097,33743,16905,27340,37873,40018,37840,37774,35661,37740,41868,47916,49900,47884,39497,39465,54028,54060,51980,54352,52173,52140,50093,39953,52789,41999,33581,33645,35693,35693,35693,33613,33645,31565,29420,29549,55067,65502,52727,50679,50679,50646,48565,48566,255},
{34007,34039,34039,34007,31959,34071,42458,38232,36152,36152,36152,36152,38232,40377,42457,44505,40312,50777,63322,56953,65240,50713,40345,23573,21493,23573,27636,35860,37973,33845,23476,23508,25556,21099,29419,12745,25259,12647,6439,12777,10697,6504,6472,6472,4359,2246,4326,2278,2246,165,2246,2213,2245,165,101,101,2246,2213,132,132,100,101,2213,8520,12777,10664,8519,8519,8519,12744,10599,8519,4326,2246,6407,165,133,4294,10665,10632,8487,19051,2181,10534,29485,27146,25227,25454,14825,29582,16938,16938,16938,16938,12744,10663,16871,16970,25390,27502,25357,23438,31696,37937,45771,39597,21230,25423,21099,38035,15022,14891,14891,16938,17004,17037,12778,14891,33776,33776,17036,23310,33841,31631,37937,31663,35857,31663,33776,38001,31728,31761,25422,23342,23342,27503,42195,40114,29616,31663,23310,25390,40114,38100,29879,19313,38133,57149,59262,42195,37936,44308,38002,29682,27504,33776,29616,31827,33777,35692,39885,46255,48369,46255,27400,21158,27528,42347,31817,23368,23368,23400,25512,19174,14948,10724,10755,6563,12869,10787,10788,12869,12901,10725,8676,10662,10663,17096,17062,8676,10725,8580,225,4548,23339,33840,42162,37937,12712,18953,35955,40018,35695,35694,33613,41933,43851,49964,51980,52207,50060,47851,54060,54060,51979,47786,43658,41610,41577,41838,57080,56820,33645,35725,35693,33613,31532,31532,33613,14857,23439,27566,53020,65437,52694,52727,52759,50647,50646,52760,255},
{34007,34039,34007,31926,31926,34072,42425,36119,36152,36152,34072,34072,38232,42457,40345,42425,38265,48665,63322,59033,63160,52761,40312,23573,21493,23573,29684,29652,27604,31797,23508,23540,23476,23179,29419,14825,29419,14792,8584,10632,10665,8584,10665,6439,4391,4359,6407,2246,2213,2213,4391,2278,2213,133,101,101,165,2213,165,133,101,100,2245,6407,12745,12745,6438,8487,8519,12744,8486,8551,4358,4358,6439,4326,2213,2246,10633,10633,6407,16971,6439,8486,29516,27210,27340,27535,18986,31663,14858,14857,16906,16938,14857,14793,18951,23244,23277,27535,27470,29550,27405,31598,44081,40019,23375,25455,19051,29616,25489,25522,17004,16939,16971,23149,21131,14890,27535,38002,19117,21230,40082,37969,33776,31663,33776,31631,33743,35888,29550,27502,25423,23375,25455,25390,40082,35889,33776,27470,23310,29615,46420,38098,31696,23276,31793,57149,59230,42194,40049,42194,42260,31959,31860,40147,42228,27535,27535,44242,42097,33709,33710,31595,23239,19078,27528,40268,31785,27657,25511,21256,19175,19207,8611,6531,10756,8675,12933,14980,14980,12868,19209,21324,19244,17066,17097,21224,17030,2275,2243,33,2370,15046,12902,12870,12840,14922,12776,19050,36150,44570,38132,37938,37839,37903,41967,49964,49900,47852,37449,43625,54060,54060,49899,47818,43625,39497,43690,41967,50774,56950,44176,33612,33613,35758,35725,31532,27339,16938,25421,31792,59294,63324,48468,48534,52727,52727,52792,54872,255},
{34007,34007,34007,31926,31926,36184,46618,34039,36152,34072,34040,34072,38232,42457,40377,40345,38265,46585,63290,61145,59000,54841,38200,21493,21525,23541,23411,23443,27604,31797,27637,25589,23508,23245,27339,16905,29419,12680,6439,12745,10665,10632,17003,6504,4391,4326,6407,4326,2246,165,4358,2245,133,133,133,133,133,101,2246,4391,165,165,2246,6439,8584,8519,6439,6439,8519,10631,8485,8550,4293,4326,2213,4325,4326,4326,6374,6406,6439,12745,4294,10567,25226,21131,27438,25454,21130,29582,16906,16905,16906,16938,16938,16937,18985,23244,25325,31663,29583,29550,31663,29550,44373,35988,23343,23375,16906,23276,34006,25457,12745,14891,16842,8552,21098,14890,25357,40082,21229,17004,33809,42162,38002,35921,35889,35889,35889,44274,35889,29583,25423,23375,25455,33808,46421,56852,58801,44143,29548,27530,29578,23304,23272,19079,29613,44503,52890,33710,35855,42194,44275,46486,38133,40115,42227,42195,44406,48631,40083,33776,25389,25353,23238,19110,14950,21319,29769,36075,27624,17030,23399,27591,19174,17093,21287,12869,14981,19207,14981,10789,21389,19244,17131,12905,12871,19175,12870,2243,131,4323,4515,13063,10854,8806,4452,194,12711,25291,48795,44570,31859,40344,52825,44307,50451,51980,49900,47852,35369,43626,54060,54060,54092,54157,52433,50255,45803,35662,19114,23373,40047,33580,29451,33612,35790,31661,31564,27306,27339,38065,63455,61178,48501,50614,50614,50614,48533,50646,255},
{31927,31959,31959,31926,31926,38232,50810,34006,36120,31991,31991,34072,38232,40377,40345,40345,38265,44537,61242,63225,56921,50681,34071,21493,23573,21460,17169,21363,29716,29717,25556,23508,25621,25458,27307,18985,29419,12680,8519,12777,12777,12777,17003,8584,4326,4326,4326,2246,165,165,165,165,133,133,133,101,101,101,2246,6472,4359,2246,4358,8520,6439,6440,167,2215,6438,14825,14826,12744,4325,4326,8519,6374,2213,6374,8552,8552,10632,12712,2181,12744,35596,18953,21292,23341,16905,27469,16938,16937,16906,16938,16938,19018,23177,23276,29454,29454,23310,29583,31663,35856,44373,40148,27536,23375,21098,21000,25521,33908,14858,16907,18631,4326,14791,14891,19084,40082,23277,14956,29583,40115,31663,37970,35857,33809,33808,42129,35921,29616,25455,25455,27535,46421,38035,37969,37936,33774,27465,19077,19045,19111,19079,12741,19047,25484,38100,20905,27308,42195,40081,44274,44307,44340,42227,40115,27503,31761,29549,29549,27436,25321,23303,14917,10725,12872,29742,31819,33930,21254,33961,31848,19173,23398,21319,19207,19208,19208,12902,25582,25583,21325,10760,12873,8679,10791,8614,6470,4325,14758,6594,4676,21225,14919,8646,6501,25193,27403,50875,50779,36085,50876,54970,48532,50418,49899,49899,45804,35304,45738,54060,51979,47818,47916,46485,48468,45803,42161,56982,44368,40046,31531,29515,35789,29547,25417,25354,23242,27598,57181,65535,59033,48501,52760,54840,52727,50613,54775,255},
{31927,31927,31926,31926,31927,36152,40345,31926,34039,31959,31959,34039,36184,40345,38297,38265,38265,46585,61242,61177,52760,48633,31959,21493,23573,19380,17201,23443,27636,25588,21396,25557,25621,23378,23114,16873,23146,12647,8551,12712,12745,12745,17003,10632,4359,4326,4326,198,165,165,165,133,101,133,101,100,133,68,2214,4359,6438,4326,4358,6472,4358,6440,232,231,6406,12745,10632,10664,2213,2213,8519,8518,4325,6406,8552,4391,6438,6406,36,10599,42129,27146,23211,27502,19018,29615,16938,16938,16938,16937,16905,18985,21032,21164,29583,21262,10731,21132,33743,35856,40115,40148,29681,25488,23244,16840,19150,27635,14858,21197,16841,6439,14824,14891,16971,38002,25390,14956,25455,25390,19019,35921,35889,31696,42227,52693,42161,29616,27503,27503,35888,48501,31696,31728,27503,27500,23302,16965,14885,19143,19079,14853,14886,14952,27599,21034,31565,42227,44242,48499,46420,44308,40114,33808,23212,23245,21196,27502,25356,27435,27401,16998,12969,21520,31925,42389,36012,25511,25512,27625,23366,12901,19175,8676,10821,10821,10821,21356,21325,17132,12873,14954,14954,8615,10728,6535,6470,16871,8642,8805,25289,27468,39821,37741,39789,29516,48565,52759,48599,50876,52824,46386,48273,47885,47819,43723,33190,47786,54060,51979,47819,43690,43820,47916,45771,44372,54967,48594,33837,29579,29643,27499,23273,23400,19207,19240,25678,61407,65535,54839,46355,50581,50581,46419,58935,56821,255},
{31926,31926,31926,31926,29846,36152,36152,31926,31991,31959,31959,34039,36152,40345,38297,38265,38265,46585,61242,63225,56888,50713,31927,21493,21525,19380,17202,17202,19282,25588,23476,23508,25621,21395,14990,17070,14957,12876,10764,12844,8683,8683,12876,17069,14892,19085,25423,21197,23374,17036,25357,29518,14923,8617,12810,4455,6504,16939,14892,14924,12876,14957,14957,19182,14924,14957,12876,8617,10731,4424,12680,12680,10567,10567,10567,10599,12615,10567,10535,12647,18952,16840,12647,25292,44340,44178,35500,27405,21131,29615,16938,16938,16938,16905,14857,16905,16904,21163,29583,29486,12747,12745,35888,31695,42227,40180,33908,25456,23311,17004,12876,25360,14761,21262,17036,8617,16971,14890,14923,33808,29583,17004,23310,23212,23244,33809,33776,33808,54937,52693,48499,29615,25422,25422,42195,42195,31664,33776,27500,25385,21190,21190,14884,21190,16965,16997,16998,19178,27568,23309,31630,42195,42194,46387,46453,44340,38001,19179,19083,25357,16971,16971,29615,44307,46387,31659,14949,14950,14987,25584,33964,31817,25513,19242,21321,14982,19209,8676,2370,6628,15014,17095,10824,17164,12938,10793,10728,6534,10760,6534,6535,29647,39853,33578,23175,33743,50354,43982,37643,35821,54838,52725,46386,37968,25357,23275,18951,37611,45868,39722,33447,49931,54060,54060,52011,49899,47819,47818,45836,31694,27564,33935,33868,25514,27530,23305,25450,23368,21255,15015,27856,61407,63422,52726,48501,52727,48500,35885,37998,35884,255},
{31894,31926,31927,31927,29846,38200,36152,31894,31959,29911,29911,34039,36152,40345,40345,38232,38265,46585,61242,63257,59000,50713,29879,21493,21525,19380,15153,15154,17234,23476,23508,23508,23541,21460,17233,17201,15088,17168,17136,12975,10861,10829,17135,23441,19182,23375,33940,19182,21296,17070,29649,42163,27535,17070,14956,6601,10730,23376,21296,21263,19216,25522,21361,25555,21329,17102,14924,10762,15021,10828,16873,18953,18953,18920,16872,16840,16840,14760,14727,18920,27371,23178,18985,33776,38066,33841,29420,25357,16906,29583,16938,16938,16906,14825,14825,16905,21096,19019,29518,27309,19117,21066,37936,31630,44307,48697,36053,29584,16941,10668,16939,23311,21099,12810,12779,8553,16971,19084,19182,29583,33776,17036,21197,40049,35856,31728,33776,42293,50744,44274,46354,31695,27535,31728,48501,33776,31696,29583,25353,21159,21159,19078,19077,14885,8548,17030,12804,12870,10696,17003,31662,42227,42193,46386,33871,25452,21226,17035,19018,19083,19084,16971,42325,54937,48631,46419,35918,27498,8612,21354,38158,23433,19209,19211,8677,15015,23401,12837,12870,12902,19209,14983,8708,6694,12905,14986,6632,6535,10760,10761,8647,21161,21129,31561,21094,40048,50387,44146,37708,37837,54773,50612,50644,39983,12679,14823,25351,31755,44302,40042,29543,31432,37675,39595,41675,47852,49899,49899,43788,46483,50674,50739,33836,25418,27594,25515,25513,19143,14983,15015,32149,65535,65502,52694,52759,52694,50549,40046,25351,21223,255},
{31894,31894,31926,31894,29879,38265,38232,29846,31959,29879,29911,34039,36152,40377,40377,38232,38265,46617,61242,63225,56920,48633,34071,21493,21525,19347,15153,15154,15154,21396,25556,23508,23541,21460,17201,17168,21329,17168,19216,15022,10828,10829,21328,25521,21263,23375,29714,19214,21328,17070,21295,23277,27535,14956,10763,10762,19116,17070,21264,21230,19183,23442,23441,23442,25554,17069,14989,10698,23309,29682,16905,18920,18920,18920,16872,16840,16840,14760,12679,18920,27306,21032,16905,33678,31663,19019,10632,21164,21131,29583,21098,21098,19018,14856,10694,10630,18952,19018,29550,35793,19183,31597,39984,31598,42260,50746,31730,33677,33416,14568,19018,21263,25391,16972,14957,19085,14956,14892,6439,25357,35889,19117,19117,38001,40082,33776,33809,57116,61308,48532,46453,40049,27502,38034,44275,29615,33776,27502,25419,25351,21127,19079,21222,12741,12806,12805,4420,12773,8550,19182,33807,44307,33805,33838,25450,10790,12807,16938,19018,19051,19051,19051,44438,44405,31826,52856,40179,40147,29549,14920,25482,25548,31888,25484,6564,10823,19177,21128,23208,19112,27499,25322,10693,2308,10727,21129,12871,14953,14954,12841,10565,16998,14986,31762,25453,48371,52500,57085,48305,46191,52660,50579,52692,39950,16805,29545,40075,35849,31688,35849,29543,21125,29450,27145,29226,29226,31371,37547,46192,44403,54901,42254,29707,29674,29707,25450,23400,19206,12838,8679,36343,65535,61244,52694,48499,40047,35918,35884,33737,25383,255},
{31894,31894,31894,31895,31927,38265,38265,29846,31959,29879,29911,31991,36152,42425,42458,38232,38265,46617,61242,63225,54840,48633,42393,23605,21525,19380,15153,15154,15154,19347,25588,23508,23508,21460,15153,17168,19281,17168,15022,12942,10828,10796,21296,23408,17069,35987,31859,21262,21328,17102,17069,12842,21230,14956,17101,8681,6568,17037,19215,14924,19216,21361,23442,23409,27634,17069,17069,12811,25423,29715,18953,18920,18920,16872,16840,16840,14760,14727,14727,18952,25225,21000,16938,33742,42227,21197,12680,25357,33808,35889,35888,35921,27469,8645,4452,10695,21164,33775,46386,42163,27536,31630,35855,33743,38002,42261,35987,31403,21167,14795,12778,14924,29682,17004,6472,12778,12778,10632,10633,25357,40114,21229,17004,33808,44275,31663,40148,63487,63454,50612,48598,44274,31663,44373,33776,31663,31663,27503,27467,23272,19078,16934,14950,12774,16999,12807,12871,14917,17033,25356,33775,35951,25417,23337,12871,6565,12807,14858,21164,19083,19083,21164,48630,54838,46550,54903,25356,36018,46420,31562,21193,17035,27598,25515,17065,12842,12842,18953,18920,18888,21001,23178,10534,4421,4484,10596,23242,33840,25324,8647,19079,19078,19245,31860,33972,54612,52435,50452,41999,37739,46289,48500,38035,38035,42127,40075,37994,42187,31688,31656,25318,18981,25191,41838,54191,33192,29388,33613,57048,38130,36050,46514,35980,33900,29643,21256,17095,23433,23369,12872,36279,65535,54903,44240,31658,23303,27497,23302,17030,21159,255},
{31926,31927,29846,31927,31959,38297,38233,29846,31959,29879,29911,34039,36152,40345,42457,38264,38265,46585,59130,63257,56888,48601,40345,23605,21525,21460,15154,15154,19282,23476,25556,21428,23508,21460,15121,15088,19249,21328,15022,12941,10796,10796,17102,17102,23311,42261,31827,33809,25521,23441,17036,10730,23407,21263,12908,2375,10729,17069,21263,19182,21328,21329,23442,27634,29746,17069,17069,17069,29582,27405,16840,16840,16840,16840,16840,16807,14759,14759,14727,18920,27338,21000,21164,37903,40179,27568,12713,31663,35889,35921,35953,38034,27533,8612,4452,10663,21197,19018,50580,46386,29583,31663,33743,31663,35889,44308,38068,25554,31505,18923,8552,21198,23343,12745,8584,16938,12811,19051,12810,23309,44307,23310,17004,29583,42195,31631,38133,61375,61374,50612,52791,48468,29648,34006,27503,31696,27502,27503,29647,33903,21158,14854,16999,10725,14950,17098,12870,12807,12843,35987,37936,27531,17095,14982,12871,21194,8615,12745,21196,16971,21164,21196,48695,38001,36018,52791,33678,37936,38000,42000,14957,10730,19149,19116,19116,23308,21196,19083,16938,14825,17003,19084,19051,10791,291,2210,19017,38002,27371,10758,21256,19049,27634,31860,38133,56693,52434,52305,48273,44208,44176,40016,27471,25554,36085,42191,35914,27528,27496,31689,21125,21094,29385,48144,60367,37385,35597,37839,61241,63288,59095,61175,38061,38095,35981,31756,21225,15015,19113,19016,25583,46486,37932,31625,29576,27496,27464,27431,16998,14885,255},
{31926,31927,29846,31927,34039,38297,36152,29846,31927,29879,29911,31991,34072,40345,44538,40345,40345,42425,57018,63225,54840,46553,40312,21525,21493,21460,15154,17202,23475,25588,23508,21427,23508,21428,15120,15088,21361,21296,12942,12909,12909,10861,10828,17069,23375,40181,31827,27568,21328,21295,19084,21197,23407,19181,17036,12841,10729,17037,19183,12843,19215,23245,19019,10698,14890,23342,27568,27568,35889,25358,18920,18920,19018,25291,27371,27339,27339,16872,14759,21098,25291,18986,19051,40016,42292,35954,16938,29517,29550,25324,29615,35889,33808,23307,10727,12712,19051,21099,46387,46451,29583,29550,33743,31696,35856,44341,40148,38067,40115,21131,14858,19084,16938,27206,12746,16971,12810,19051,14891,19084,42227,25422,17004,25422,42162,40082,50746,57181,59262,48500,46420,44373,31728,25456,25390,31696,25390,25422,35987,38034,21193,19112,14950,10758,14983,14984,23371,16968,12843,23309,35888,27563,15015,10757,10790,12808,4454,14857,19083,16938,19051,23309,52823,54838,52823,42260,25032,29128,35822,33744,10700,14891,21229,21197,23179,16871,21065,23211,16839,14791,16938,19051,19084,19115,17002,14759,14758,18985,12645,8644,21224,25321,29714,31892,40246,52499,52434,54417,54611,52725,54838,52629,33841,23441,38197,40108,29576,27463,27496,16964,19110,29480,27208,39757,48047,39692,35596,39984,63353,65401,61175,59094,40143,36014,38062,35917,44337,27531,25422,21163,19276,48665,48500,35853,35819,27464,14917,21223,23271,23336,255},
{31894,31927,29846,29846,34039,38265,36120,29846,29879,29879,29911,31991,34071,38232,42393,42425,42393,44473,57050,63225,50712,44473,40345,23605,21493,19412,17202,23443,25524,25556,21428,21395,23508,21428,15120,15088,17135,15054,15054,12941,12909,17101,19182,17069,21295,35923,38100,25358,17102,19214,19084,29616,19181,27567,27469,19082,8616,17037,17038,12844,19117,23015,14661,2214,4326,27469,38067,38100,35954,29518,21033,16808,12745,35921,42194,42193,42129,29517,18985,21196,19117,6471,16938,33710,42260,38067,29582,31629,31597,25324,29582,35889,35889,31695,17036,2181,14792,31663,48532,38033,19052,23244,33776,29615,33776,44340,42228,38068,40147,23244,16939,21230,21162,25157,12778,21131,12810,23212,16971,14923,40147,31663,17004,21229,42228,57116,61407,63487,63487,48599,46551,46551,35889,27503,29615,29583,25390,27503,40180,35955,33776,31727,29679,25453,31825,36052,40245,21131,14989,33940,31725,17095,17095,14950,8644,2308,10664,19017,19115,14890,21164,25422,54935,54903,52855,52758,44307,46452,35853,19147,8619,19084,25455,27535,33645,29420,27307,25161,25194,18986,10633,16905,25324,29518,29550,31630,27404,23146,21064,10789,23338,41999,29682,31828,42326,52467,52402,54418,54676,52692,56951,61146,33875,23441,40176,33769,35914,35914,27496,23271,29576,25383,23207,27272,33483,41903,43982,42162,63353,63320,61175,57014,48562,44401,50675,52724,50612,29579,19115,23276,12970,42391,52793,50680,37869,21223,23304,27529,23238,16997,255},
{31926,31926,29846,29814,34039,38265,34039,29846,29879,29879,29911,31991,34039,36152,40312,42393,42393,44505,59130,65305,54841,42425,42425,27798,21461,19380,19250,23443,25524,25556,23476,21395,23508,19347,17201,17168,17168,15055,12974,12941,10828,21262,31696,27568,31728,33809,33841,33808,35955,31728,25389,33841,31695,33808,33775,23244,23179,29648,27568,29616,23277,18854,6309,134,4326,25324,33874,35954,33841,29549,18952,18953,21098,33743,31662,33775,33775,23177,12679,8551,17004,10665,19051,39950,38034,33874,27469,33710,35791,29582,31695,35889,35921,31695,21164,12712,16905,33840,52692,40081,23147,23244,33776,31664,31728,44307,42261,38068,42260,27470,17004,21328,21263,14825,12778,19051,14858,23212,19051,14859,38001,35889,19085,21197,40245,48730,57149,61342,57116,31697,29616,35954,33841,27503,31696,25390,25390,31729,40180,35922,33809,35954,44341,38099,48763,52924,44406,21099,15022,21261,27531,17095,17063,10758,8646,14920,19114,21161,21194,16970,19050,25486,52791,27470,42356,35921,27015,33256,29514,19144,10663,14858,19116,25357,35726,35726,39821,33384,23210,23243,19016,21131,16905,16938,25324,35888,40049,44242,42031,25386,33871,41935,27601,29747,42293,50354,52402,54450,52595,50644,59097,61179,38036,27633,38028,25383,29642,27496,21223,25416,27528,29576,17029,19110,12741,18983,25226,42324,61241,61240,61207,56981,56949,56981,56981,46452,33839,21258,6533,14985,14986,38165,50713,52826,48533,35885,27465,19143,19143,29577,255},
{31894,31894,29846,29814,29879,36152,34039,29846,29878,29879,29911,31991,34040,36152,40312,42361,40313,42425,59130,65305,54840,42425,42393,36120,21493,17299,19282,23443,23476,23476,23508,19347,21460,19347,15120,21329,27602,12974,12942,12909,12876,31696,50580,48500,42226,44339,44339,44339,44339,44339,44307,42226,44307,44307,44307,38001,31469,42194,42259,42259,29484,27371,18953,8519,12712,29550,33841,23375,27340,25162,14727,31630,40146,29517,23243,25324,27404,18984,10566,8518,14891,10665,19083,39983,44340,38067,31662,35790,35855,31630,33775,35921,35921,35921,27436,31728,27535,33808,52725,42193,29517,23277,31630,29615,33776,42195,44406,35987,40148,33743,19116,16938,14892,10631,12778,16906,14858,16939,19051,12810,31728,38002,19117,21229,40213,40278,61342,63487,48664,21165,33775,35921,29615,29551,29615,25390,27503,38067,40148,33842,35921,38002,33874,38132,52988,55036,46453,21066,14988,25455,21256,21290,27566,21292,25422,23339,27499,23273,19178,31760,23275,21225,46449,42160,48564,38000,25194,37806,29546,21287,23336,19083,19116,31598,37806,37839,39821,33608,23304,16966,12772,23307,12709,10598,8521,14857,29550,44210,42129,31631,29680,48403,37937,29682,44341,48273,54482,52369,50483,54838,61178,61244,40149,27634,40174,29544,27465,23304,21191,21223,25449,29576,12708,14885,8547,6564,12837,19145,23307,27501,42291,48499,40175,33934,31822,33904,33903,17000,8646,12839,10694,17067,25552,40310,52826,48535,42227,37966,25384,23336,255},
{31894,29846,29846,29814,29846,31959,31959,29814,29846,29879,29911,31959,31991,36120,38232,40312,38264,40313,54905,65273,56953,44505,42393,40313,21525,17299,19282,19282,19282,15186,19315,19347,21428,19315,15120,19248,17168,12942,12942,12909,14989,33776,44307,44307,40081,40114,42226,42194,42194,40113,40113,40113,40081,40113,40114,40049,37807,38033,40114,40114,29549,40048,40049,35888,35888,37968,35888,27470,29420,29322,25226,35791,40146,29550,27436,27437,29517,23243,19083,21131,21163,19051,25324,33710,42227,35986,29549,35757,35855,31662,33808,35921,35921,35921,25324,31696,31696,27470,42226,37969,29517,25356,29517,29582,29582,35889,44373,35955,42260,37969,19019,14891,8585,10632,14858,14859,16938,14858,21132,12810,29615,40114,23310,44406,44471,38132,63487,61342,48666,44472,48697,35953,25390,29615,27502,25422,27535,40148,38067,33842,31728,33808,31728,42326,55069,55004,46355,23146,17005,21099,33774,36018,46617,42326,38132,38098,31758,21225,19112,21227,21227,21193,35852,25354,35984,35887,10729,44371,25353,27560,27531,19051,17003,27471,39920,39887,39787,35753,27465,16966,14853,14854,10628,14789,23177,12647,12745,33744,29582,23309,23342,29712,44340,48468,52596,52435,56530,50256,50483,56983,61211,59163,33842,25587,38098,37963,31689,21191,21191,21190,19078,16998,14917,23303,12740,10725,16998,8580,10663,6408,19019,38001,21257,12902,14984,14984,31758,21162,16936,21228,12776,6437,6502,12873,23504,50778,50713,48534,35886,25482,255},
{29846,29846,29846,27766,27766,29879,31927,29814,29846,29879,29879,31959,31959,34072,38232,38232,38232,38233,48633,63161,54873,44505,42393,38264,21525,17300,15121,15154,17234,15154,19347,21395,21428,19315,15120,17168,17136,12942,12942,12941,12909,23310,35856,44274,40081,40081,42226,42194,42194,38001,40081,40114,40081,42162,42194,40114,40082,40081,40146,40114,40048,44208,46289,33677,29483,31564,31564,31596,31596,31564,31596,31564,29516,29516,29516,29516,29516,27436,29484,29484,29484,27436,27404,35789,40114,35954,29549,33709,35823,31662,33808,35921,35921,35889,27436,29615,27502,21131,29616,35955,35889,25324,25324,38034,31630,37969,46389,38035,40180,40180,19019,14957,12811,16938,16938,14891,19051,14891,21132,12810,23309,37969,38099,59230,55036,42358,63487,55004,40280,36086,38101,31696,25390,31664,27470,25390,31761,42293,38067,33841,35921,33808,29648,44471,55069,57117,48533,27405,19150,25357,40082,44471,33871,35986,38165,38098,31725,21191,19079,16998,14887,23337,25386,19079,27531,29611,23307,33807,23241,27368,29547,21194,19178,17065,29549,39952,37675,27303,12869,17031,19047,12806,14885,14789,31564,37869,27370,12743,12711,23211,23244,25422,27503,31826,38002,35824,39984,39952,44275,50678,61211,59098,29681,27699,36020,46417,27497,25384,29609,23303,14917,19143,21256,29577,16966,8612,14886,12709,10499,6468,10692,31726,29676,29708,27563,23275,25388,19081,10695,19082,14888,14954,19115,12808,15214,57246,59197,44373,40178,27530,255},
{29846,29846,29846,27766,27766,29878,31927,27766,27798,29879,29911,29911,31991,34072,36152,38232,38232,38265,46521,65241,61113,44505,42393,36152,21493,17299,13073,15121,17202,21395,23508,21428,21428,19315,15120,17168,21361,12974,12941,12941,14989,14923,31663,40049,40114,40114,40114,42162,42195,42227,42194,40114,42162,42194,37904,37904,33582,31404,35694,39952,54772,46288,46289,40015,27338,31564,31531,31532,31532,31532,31564,31564,31564,31532,29484,29484,27404,27404,27404,27404,27404,27404,27404,29548,35888,23244,21097,33677,35823,31662,33808,35921,35953,35921,27436,35954,27502,23244,35889,42261,42293,23277,21131,35888,29550,35856,46388,40148,40148,35889,25423,31826,10697,14890,16971,14859,19051,14859,19084,14859,19084,40082,54905,61343,61375,59294,63455,44473,33941,33875,35856,25357,29583,29583,25390,25390,38068,40147,38067,31761,38001,35856,31728,46617,57182,57182,48565,27406,32023,38099,31628,44438,25418,21224,27598,33872,25450,16998,16999,14886,14886,29641,33738,37931,31720,27560,23239,14758,23209,29608,29579,29578,23399,15014,21223,27401,31468,20967,6467,8612,14886,16998,14885,31595,50448,50381,44175,29451,31627,33644,25258,25356,27535,29616,27567,27535,27535,27535,31696,35986,52890,50745,29649,19214,35955,50777,40243,36016,29610,21223,19143,19144,23336,25417,14918,8580,14757,12836,12771,14982,19239,23400,31852,29739,27627,36048,33806,10662,19179,29549,14856,12808,21130,12711,23601,59293,61309,35918,27531,27530,255},
{29846,29846,29814,27766,27766,29846,29846,27766,27798,29879,29911,29911,31959,34040,36152,38232,38232,38264,42393,61049,59001,44505,44473,34039,21493,17267,13073,13073,15154,25588,25589,23541,21460,19282,17201,17200,15055,15022,12876,12810,10730,14891,35856,40081,42130,42130,40049,37936,37969,37969,37937,35856,37937,35856,33678,35759,29323,27307,33581,35791,44242,40016,48434,48434,29484,31531,31531,31564,31532,31531,31532,31532,31532,31532,29484,29452,27404,27404,27404,27371,25323,27371,27404,29484,29516,27436,29517,37936,35790,31662,35920,38034,38034,35921,27436,33840,29583,19050,29647,42161,46454,33874,25357,33711,31566,33776,44308,40180,38067,40147,33907,33940,12778,14924,14858,14891,19083,14859,21163,16971,16971,38001,52824,63423,61407,63455,55037,44505,44505,46552,33776,25357,31664,27502,25390,27503,42294,38034,38035,31761,35921,35921,40148,48730,57182,55036,48501,21001,27535,33838,21159,31758,25385,16997,16999,21256,23336,16965,12773,14886,21191,33898,33833,33803,31720,25447,19141,35915,27560,25510,21255,23304,21286,19142,23238,17061,23306,21031,19079,25355,16966,16967,27369,48336,54575,50349,46191,46256,50482,44111,33644,40081,35888,29615,33809,35922,33841,33874,35987,40180,44438,42261,27601,31827,46552,53022,57279,55069,46484,44405,46453,31693,21192,12805,12773,16740,19143,15045,15110,27627,27626,25578,29771,25545,21255,23434,23369,14953,29842,52857,50711,46420,40081,38000,44535,63487,59131,37966,25449,25481,255},
{29846,29846,27766,27734,27766,29814,27766,27734,27798,29879,31959,31959,31959,34040,36152,36152,38232,38264,40313,59001,61080,44505,44473,34071,21493,17300,13073,15154,21395,23476,21395,21428,21460,17234,15120,19249,15055,12974,12877,10763,10731,14891,23310,31598,42097,42064,42064,27405,27437,29485,27405,27405,27405,27405,29485,29485,27405,29517,27437,35856,42195,38002,48402,50515,37903,27338,31532,31531,31532,31532,31532,31532,31532,29484,29484,29452,29452,27404,27371,27371,25323,25323,27404,29484,29484,27436,27404,35855,35823,31630,35856,35921,35921,35888,33873,35954,27502,19050,23340,35822,48436,40115,31663,31533,27243,35856,44308,42260,40115,42228,25423,31861,21164,10698,12745,14891,19051,14891,19083,16971,14891,33776,48599,63487,61407,61407,44505,31860,36053,40148,27437,27438,31696,25390,25390,31729,40180,35954,38067,33842,38067,33808,35921,38035,23375,29712,35854,20968,27498,29545,19077,21191,17030,12772,14918,21225,23336,17030,14886,19110,33864,35944,33928,27527,25479,23399,23462,29800,25544,17126,10757,6627,17157,12869,25287,27431,25447,23367,25480,29514,14949,15014,35788,50416,48303,48271,54775,48600,25390,40050,50680,50712,48533,46420,42194,31695,29615,35954,44374,44406,44406,38067,23440,33940,50779,55135,57247,52988,52858,52826,50745,33775,27403,29549,35599,28835,19241,15109,15078,21352,27594,21321,27626,31819,21256,17062,10789,12871,21422,52987,57181,57083,52792,46452,48729,63487,54905,35918,27562,27561,255},
{29814,29846,27766,27734,27766,27766,27766,27734,27798,29879,29911,31959,31959,34040,36120,36152,38232,38265,38233,56888,65240,46553,44473,34039,21461,19380,15153,19282,19315,19315,21395,21428,23541,17234,15088,19249,12975,12942,12942,12909,12876,12908,14923,27437,42032,39984,39984,27405,27437,27405,27372,25292,27372,27372,27372,27372,25324,25324,23211,31598,46356,38035,44242,50580,46322,31532,35725,35757,35757,35757,35757,35757,35757,35757,35757,33677,33677,31597,31597,31597,29549,29517,29517,31662,31630,29549,29549,31662,33775,31597,35888,35921,35888,33808,35922,35987,25324,16905,27502,27243,37936,33711,25390,29518,27405,33711,42227,42261,40148,40147,27503,29747,23277,12745,16938,14858,16971,14891,19051,16971,14923,31695,46485,61342,55036,57117,38134,33908,36020,31695,23277,29551,29583,25358,25390,35955,35954,33873,38035,33809,38099,33807,35888,33775,16969,27564,33707,23080,29578,27431,19044,21191,14885,8612,6500,14886,19111,17030,16999,16999,35947,40108,29704,29609,25479,21318,19206,17093,17095,17126,14981,12931,15044,6562,17062,35851,31752,19173,23270,27431,21284,17124,17029,46255,46223,50381,56984,44374,21197,25422,29615,42196,46421,46323,39949,25320,19050,27502,40180,44373,42358,42294,33907,42358,48600,52990,57247,52956,54938,54906,52793,35856,33710,45936,49742,34948,33679,23336,21352,25513,31820,25514,25514,23401,21289,12902,6565,4516,25712,57149,59261,63487,63455,61342,55003,55003,46452,31659,27562,25449,255},
{29846,29846,27766,27734,27766,27766,27766,27766,27798,29879,29911,31959,31991,34040,36152,36152,38232,40345,38232,52729,61049,44505,44473,29846,19413,19412,17202,19282,15154,15154,21395,21428,25621,17234,15120,23442,19248,10894,10861,10861,15021,14989,12908,25390,42064,42065,42097,27437,27437,27405,25292,25259,27372,27405,27373,25324,25324,27372,25292,27372,29550,27437,35823,42096,42096,40016,40016,40016,40016,40016,40016,40016,40048,40016,40048,40016,37936,37936,37936,37935,35855,35888,35888,35856,35888,35855,33775,33775,33775,35888,33775,33776,31695,29582,27469,27469,21099,18921,33808,22986,17066,21164,21164,27535,29615,31695,38002,42261,40148,40148,33775,17003,19083,14858,19051,14858,14891,17003,10600,12745,14891,27470,44340,57051,48600,50811,46618,46618,44439,29550,25357,31663,29583,25422,25390,33842,42293,38002,38035,33809,40212,35951,23372,25421,25356,37999,37967,31661,25383,23303,25351,19110,12805,2243,2243,14917,17030,16998,16999,14887,27593,33930,29673,27530,17094,17093,17092,15012,12837,19207,15013,12868,8707,12868,27590,29702,27559,23335,23301,17092,17124,8705,10787,42095,52461,46221,57018,38035,21230,23342,25357,43884,48110,46062,31432,19014,12678,14792,25392,35922,40147,40213,44407,44438,38002,33940,44603,55004,57051,57051,50712,31694,31661,43855,45581,37060,37905,40148,33902,27593,29707,27594,21321,21353,21353,14983,8678,8709,32018,57149,57181,61407,65535,65535,63487,59262,54970,44371,31755,27562,255},
{29814,29814,27734,27734,27766,27766,27734,27766,27766,27799,29911,31960,31992,34072,36152,36152,38232,40313,36184,48601,56889,44473,42425,27766,19413,21461,19315,17234,15154,19315,21395,23508,23508,17201,15120,25522,23441,12942,12942,10861,12909,12909,17070,27470,44145,42097,42097,27437,27437,27405,25324,25292,27405,27437,27405,25324,25292,35759,35791,35823,31597,31597,33742,35790,37903,16905,16840,18953,23211,21098,16840,18953,23211,23211,23211,18985,18952,21066,21131,19018,16905,19050,18986,16937,19050,16937,16905,16873,23275,35888,29582,31695,27501,12839,12839,21196,14792,21130,33841,33809,23178,21067,19084,23245,29615,29648,31728,40213,40148,40148,40081,19117,14826,12778,16939,14858,16939,19051,4261,14825,14859,21229,42194,59229,59230,40279,42229,42360,38034,23277,27438,31664,27470,25390,25422,29583,33809,44374,42261,33809,42325,44372,29645,21226,21162,37999,35854,33807,25416,25415,23270,16966,14885,2242,2306,4387,14917,19142,17062,14918,19175,21223,25481,29672,21285,23429,21317,8674,15013,12933,12901,10787,6595,12901,23461,25477,23366,19110,19110,21254,17092,10818,8611,19081,31561,31563,54971,33809,19084,17068,29518,50092,50027,49994,37674,19047,16966,27307,21066,25483,19085,31729,42358,40212,40213,38067,31729,44406,48664,48600,44373,29677,27500,39888,41452,39141,38002,42293,31855,33967,23433,25450,21193,12902,19176,15014,14983,19273,34067,52955,57181,61407,65535,65535,63487,63487,65535,63487,46516,29675,255},
{29814,27766,27734,27734,27766,27766,27734,27766,27766,27799,29911,31960,34072,34072,36120,36120,38232,40313,36184,48568,61049,44505,42425,29878,19413,21493,17234,13073,15154,23476,23476,21428,21460,17201,15088,23442,19248,12942,12941,12909,12876,14989,14989,25390,40016,42097,42097,29517,29518,27438,27405,25292,27372,27405,25292,25259,29485,35759,33678,35759,35823,37871,37936,37903,37935,27339,27371,29452,29517,29484,27371,27403,29549,29517,29517,29452,27403,27436,29517,27436,25356,27469,27437,25356,27436,25356,25356,25356,29549,31694,29582,31663,19113,6500,10630,12712,14760,21098,35889,33842,25194,14761,21131,23244,23309,27535,31728,44308,35857,40148,38034,10730,8552,14858,16938,16939,14858,19051,12745,16970,14859,19084,38001,57083,50811,42326,42260,38165,31695,25357,33808,31696,25390,25357,27503,29583,29583,33809,44406,35890,38033,35950,48564,31661,16903,33837,33676,23243,27497,21191,19079,21159,14885,6499,6499,12804,14949,17030,19142,12837,10757,19112,29611,29705,23398,19204,14979,8675,12900,12868,15013,12900,6627,6532,21284,19172,14947,19079,17063,23366,14979,12931,8579,16902,10662,19050,54972,29583,19116,17068,33678,52173,52140,50027,33546,27501,29548,38002,31761,29386,16839,29646,38067,33841,33808,33808,29583,27470,25422,25422,25422,19145,27532,44114,59853,31080,40148,46487,38196,27659,17063,25483,27498,12869,21353,21352,17191,15048,34035,52922,57181,61407,65535,63487,63487,63487,65535,65535,61309,42389,255},
{27766,27766,25685,27734,27766,27766,27734,27766,27766,27798,31960,31960,34072,34072,34072,34072,38232,40313,36184,46520,61081,44505,42425,31959,19413,19413,15122,15154,15154,21395,21428,21428,21428,15121,15120,21361,15087,12942,12942,10828,12909,12876,10796,21165,35759,35791,35791,25325,27438,25293,25293,25260,25292,25292,23212,23179,29517,35791,37839,37839,37871,42097,46257,37903,37903,37903,40048,42096,40048,40048,40048,40049,42097,40048,40048,40048,40049,40049,37968,38001,37968,37969,38001,35920,35888,35888,35888,35888,33775,29549,29582,31695,17000,8646,29452,29224,27177,25064,33548,33744,19051,14826,16776,18986,21196,23309,31695,31695,23018,38035,25390,8585,14890,14858,14858,16971,12778,16971,16939,23211,14858,16939,33776,38067,33908,38069,42294,40180,29583,29648,44406,29583,25357,25390,27535,29583,27503,27503,29615,27503,31758,37933,35886,42226,29419,21161,14888,16937,29545,23270,16965,19111,16998,8612,14918,8612,8612,14949,19142,12806,10725,23336,38059,33865,25478,14980,12900,17092,12899,12870,17062,14982,17066,10630,6562,4418,16997,19142,10691,10723,10819,10787,10595,16902,25257,27501,54971,25390,19116,17068,37806,52173,50060,50027,37675,33775,39984,35955,21911,34199,33808,27306,21099,16906,27567,33873,33873,35987,35954,31761,35986,38034,38034,42228,44147,42034,44341,46552,50875,29708,17096,27595,31788,25513,27658,21320,17160,15017,38229,55003,59294,63487,63487,63487,63487,65535,65535,65535,61310,50842,255},
{27766,27734,25653,27734,27766,27766,27734,27734,27766,27798,31992,31992,34072,34072,34072,34072,36152,40313,38232,46488,59001,44505,42425,34039,19413,19412,13073,15154,19315,19347,23476,25589,21428,15153,15120,23442,15055,15022,12942,10828,12909,10796,10796,23277,35791,33711,35791,25325,25325,23180,23212,23180,25260,23212,23179,21099,29485,37839,37871,39919,37838,39984,46322,39983,39984,37903,40048,40048,42097,42096,40048,40048,42096,40048,40048,40048,40048,40049,37968,38001,35920,35888,37968,35920,35920,35921,35888,35888,33775,29549,29582,31695,23308,8614,35856,29225,29257,35725,25260,18987,38035,27437,16875,10633,23277,23244,25389,29485,23083,35954,42195,19084,21003,16873,14858,16938,12778,16971,19019,21099,14858,14858,35889,31663,17004,25423,33711,33744,23277,35954,48665,27502,23309,27470,29583,27502,27502,29551,29583,29551,33808,40144,40046,40079,35919,25354,12807,23307,23272,23303,21158,17030,10693,8580,14853,6468,6500,17030,17063,14983,10757,14951,21255,23367,14948,8611,6531,12868,4387,15053,19144,25482,27630,23368,17030,14789,21159,19173,14915,8643,6530,8611,16836,19014,31529,29581,44374,21196,19149,19116,41934,52140,50059,49994,43786,39985,46259,33940,26169,28315,26137,46486,42032,33613,25324,19149,21230,31728,33874,35922,38067,44341,42260,40213,40213,42260,42293,44472,46713,27562,21288,27596,29707,23433,23465,12934,8742,17130,21390,48794,59294,63487,65535,63487,63487,63487,63487,63487,63455,61407,255},
{27766,27733,25653,27734,27766,27766,27734,25686,25686,27798,29911,31959,34040,34040,34072,36120,38200,38232,36152,44440,58969,46585,44473,36120,21493,19413,13074,13073,15154,19315,21428,23508,21395,15121,15120,21362,15055,12942,15022,12909,14989,19052,31599,31631,35791,33744,37872,23277,25293,23180,23212,23180,25260,25260,23212,23179,31598,37871,37871,39951,37839,29452,40016,39983,37935,35790,37903,37903,37903,37903,37935,37903,37903,37903,37903,35823,35855,35855,35823,33775,33743,33775,33743,33743,33775,33775,31695,31662,31694,29582,29582,31663,17001,2372,29549,29257,29322,33612,21099,8552,40115,25390,16971,12745,23244,25357,27437,37969,35955,38100,38067,16906,24937,16841,16971,16971,12746,16938,19019,23180,14890,12810,33776,35889,21262,21230,35825,31598,25357,46486,48567,27470,23277,25390,33777,29616,27503,29615,31664,29583,29615,38066,37999,42158,27562,29677,31725,38032,29577,14885,12805,12838,14886,12773,8581,4356,2243,6470,21259,19176,10789,14981,14949,17093,27560,21255,19175,14917,6533,21355,25480,25480,23401,29674,29546,29547,29514,16901,6498,8610,6498,10660,23144,37901,58864,33576,14790,16936,17003,19149,44014,52140,50027,39886,29419,37774,52468,29844,26202,28314,26169,61374,63389,52695,42064,31565,18986,23341,33841,31761,35954,38100,42293,42293,40180,38099,38099,38100,38131,25515,19175,27595,27626,21352,15014,10789,10887,17160,15180,50907,59294,59294,61374,63487,59295,59294,65535,63487,63487,65535,255},
{27734,27734,25685,25685,27734,27766,27734,25686,25686,27798,29911,31959,34040,34040,34072,36120,36152,36152,36152,44440,61049,50713,44473,38232,21493,19413,13074,13074,13074,17234,21428,21460,19347,15121,15121,21361,15023,12942,12941,10860,17102,19117,10763,23277,37839,35791,37840,25325,27373,23180,23180,23180,25260,25260,23180,23147,33743,35791,33645,33645,31533,18920,40048,37935,37935,14824,16840,21065,23178,21065,23211,16873,16872,18953,23243,23211,21097,18985,16905,16905,16840,21131,16905,14792,16937,16873,16905,16970,29582,33743,31662,31695,14888,4421,33775,29321,33580,23146,16937,16938,38034,23309,19084,19084,21196,23276,25357,40114,42293,35955,40115,27405,16874,16939,10665,14825,16939,21131,19051,17004,12713,12778,27502,40082,25455,19084,23277,27470,31695,52760,46487,27503,25422,33842,48599,35857,27503,29551,29583,29583,27470,27503,14891,25387,31723,29643,27530,38098,44307,23273,19110,19111,12838,12871,4421,4421,4421,12777,27565,31754,27561,29641,27528,31754,33865,23334,19174,19143,21320,21320,21287,23431,27625,25384,31722,25352,27466,23208,10660,17030,14820,16837,18918,27338,35822,48433,52590,23109,8549,10696,46062,54188,48045,15866,11412,31467,50387,23667,26201,26201,28185,63454,65535,65535,57018,42228,46453,48631,48567,35954,31728,33809,33873,38067,38100,40180,38100,33903,33904,27594,25481,31789,29707,23370,17095,12966,15080,19274,29842,57214,61407,48632,50875,65535,57182,52988,57182,59294,63487,63422,255},
{27766,27733,25685,25685,27734,27766,27734,25686,27734,27766,29911,29911,31992,34040,34040,34072,36120,36152,36152,48568,61080,52793,46553,40312,21493,19413,15154,15154,15154,15154,21395,21460,21395,15121,15120,19281,15055,12942,12941,10828,12908,12876,8747,21230,29486,31598,35791,23244,25293,23147,23180,23148,25228,23179,23179,23147,33711,33710,31565,31532,23082,12582,35790,37903,37903,25258,25258,27371,29484,27372,29484,27339,25291,27339,29517,29517,27404,27371,25323,25323,23211,25389,23243,25324,25356,25324,25324,25356,29582,29549,27469,27469,21196,10695,38066,37838,31434,33548,18951,21129,38034,21164,14858,19084,19084,21164,21164,35889,44308,35922,42260,35856,12811,10632,17004,21196,12778,14858,14890,10665,12713,12810,23244,40146,27503,17003,21197,25390,40147,52792,44341,27535,33810,40148,52890,50614,35921,29615,27503,27470,27438,27470,17135,14924,33774,31691,25287,25385,40178,48566,31759,23306,17033,14986,6534,6566,6533,10696,25452,33867,35947,31722,31723,29674,23335,14949,17031,23401,23368,19142,23399,27561,25481,25450,29642,16998,14949,14853,21255,16933,14852,18950,18918,27402,27404,33742,46320,33642,10660,4452,29417,25222,21257,7707,13460,25194,39952,36020,26039,24121,32313,65534,65534,65535,57017,48729,57149,54937,50680,46486,44309,27503,25422,33808,35921,38100,40180,36017,31789,25450,29742,33904,29678,23403,19209,12967,15082,31793,42423,59327,59229,55003,55100,59262,52956,52988,59327,63487,65535,57050,255},
{27734,27733,25653,25653,27734,27766,25686,25686,27734,27766,29911,29911,31992,34040,34040,34040,36120,36152,36152,48600,61080,52793,44472,44473,23606,19413,15154,15154,19315,15154,19315,21428,19347,15121,15120,17168,15055,15022,15022,10828,12908,17069,10828,19117,29518,29551,29551,19052,29550,35823,33710,35823,37871,37871,35791,35790,39984,40016,37903,33743,29549,27404,29582,29517,29517,29549,29549,27469,29517,27469,27469,27469,27437,27436,25356,25324,25324,23244,23244,23244,23244,21164,16970,25422,25357,25356,23276,23243,21131,14760,14792,6472,6472,8616,38034,40049,27177,29290,35527,46023,35987,16971,12713,21229,19084,19116,21164,31695,46486,33874,38002,37969,12745,14760,23375,27503,14825,12778,14858,12746,21164,12810,17003,40147,27471,17003,21197,29615,48566,52792,42260,25423,14957,38100,52825,52792,50679,37969,29583,27438,25389,27438,25357,25357,27568,19115,27401,31659,38097,54873,50778,44471,40278,29713,31826,23341,10661,23306,35982,33868,31786,31754,33835,25416,17029,21191,17029,23400,23400,14949,25545,29641,19143,29708,27497,14886,10692,14918,14982,12901,12901,14853,21031,29483,29484,31596,42129,33677,14918,8580,25354,21191,8773,13200,23309,37742,44146,44212,42229,27892,36343,65535,65534,65535,52759,42358,48632,48631,50679,44113,41740,33354,18954,21230,27471,33841,38067,40212,40245,31790,31857,38133,33873,27565,27502,23372,23340,31760,48729,63487,52857,44470,50875,57214,61407,63487,65535,59228,50775,33869,255},
{27733,25653,25653,25653,27734,27734,25654,25653,27734,27766,29911,29911,31992,34040,34040,34040,34072,36120,36152,52761,61081,54873,48633,46521,29846,19380,15154,15154,19347,17235,19315,21396,19347,15121,15121,15088,17135,15054,12941,10828,12876,12876,10796,14956,29551,29519,29551,16939,33776,37968,33742,31597,35823,39984,37903,37903,35823,35822,33710,29582,27470,25389,23309,23276,21196,21195,21131,21131,19083,19050,19050,19050,19050,17002,16970,16970,16970,14890,14922,16970,16970,14890,12777,19116,21228,21131,21131,19082,21131,14825,16873,10664,6472,19051,42227,37903,29257,31403,27241,29354,35922,16971,17004,21262,19116,19116,21197,27502,31663,25422,27502,40049,16939,12778,16971,25357,16905,12778,16938,12746,19051,12778,19116,40050,27405,17036,21197,35889,48566,52759,42195,27471,14924,42358,50712,48565,46484,46451,40082,25389,25357,23276,25325,27470,29648,19150,27470,33806,46516,50679,48599,50712,48665,44504,42359,27534,21128,27532,35948,33868,33868,29706,27592,21222,16998,16997,17029,25481,21288,17030,27562,27562,12772,23368,23335,14917,8612,10757,12869,19143,14949,6435,18918,41996,33643,29516,46290,27468,23272,10660,29583,39952,33644,18920,33613,50387,52532,42131,42098,48405,50777,65534,65502,65535,46420,35921,40082,42259,52792,56985,48436,44015,37579,33484,23147,14988,27535,38035,42359,33841,27599,33906,31793,31761,33842,31728,23308,31760,50939,65535,54971,36085,53020,65535,65535,65503,48662,33902,25512,23399,255},
{25653,25653,25653,25653,27734,25686,25653,25653,25686,27766,29879,29911,31992,31992,34040,34040,34072,34072,36152,54937,61113,59033,50713,44473,31959,19380,13074,15154,19315,17267,17267,19348,19347,15121,15120,17168,17135,15022,12941,8748,10796,12876,12940,8683,23343,19117,17036,19052,33776,35888,35823,31597,35855,37935,37903,35855,35855,37903,33742,31663,27502,25389,25357,23276,21196,21163,19083,19051,19050,16970,16970,16970,16970,16938,14890,14858,14857,14857,14857,12809,14857,14858,12777,17003,25422,19050,19050,19018,19050,12745,6373,19018,6407,19083,46419,33678,27177,29257,29387,29323,31534,25390,21230,12811,16972,19084,21197,25390,25227,21131,31631,42162,21164,15022,10665,19182,14826,12778,16970,14858,14957,10665,14858,35889,29486,19084,21197,40147,48566,50679,40114,25423,21229,44438,42192,31627,27497,27466,38032,35856,21131,23212,21163,25325,27470,27502,35889,33809,44373,50679,50679,50679,48632,44439,38132,21259,14919,23306,31789,31758,31788,27626,23368,23368,17062,10722,23367,23400,25481,19110,19143,25416,25416,23368,23335,19142,21223,14950,12837,12837,12870,14854,21063,48303,48303,33709,44242,29548,25352,14788,35921,33743,35790,27404,21033,29648,50679,44536,40081,39984,54938,65534,65502,65534,44372,50875,55002,44438,57148,65502,63421,59066,33352,22948,12644,4457,10701,31762,35921,33809,33874,35987,33906,35987,35954,35954,31728,27567,53053,65535,59229,48762,55101,63487,65535,63389,35917,25481,27560,27624,255},
{25653,25653,25653,25653,27734,25653,25653,25654,25686,27766,29879,29911,31992,31992,34040,34040,34072,34072,36152,54905,59097,59033,54873,44473,29879,19380,15154,15186,15154,17234,15186,19348,19347,15153,15121,27603,19248,12942,15022,10828,10796,12876,14924,12843,23375,19117,12843,14891,31696,38001,37936,33709,37903,40048,40048,40048,40048,40016,40016,37968,31728,29647,29615,27534,27502,25421,25389,25357,23277,23309,23276,23276,23276,23244,23244,21196,21196,21196,21163,21163,21163,21196,21164,21195,29582,19083,19018,19018,19018,19018,8454,14759,12778,8584,31695,37871,29257,31403,27176,31533,38002,25391,17036,16906,23343,21132,19116,23309,35921,33841,40148,46388,23245,12778,14858,8584,14825,12778,16938,16939,8487,16971,16971,31631,31663,19116,19084,42228,52759,52759,40082,25358,25390,37999,27463,25352,25384,21191,23272,31693,6406,14792,21163,21131,23276,25390,29615,33776,33841,42260,52760,52824,37966,27466,19079,17000,14886,14855,29611,36014,31757,21257,25483,31820,19142,19175,25513,17030,19175,21288,23368,21255,21287,23368,21287,25480,21255,10692,8580,6499,8612,8516,27305,50351,46190,48370,48404,39984,14854,8580,35790,40049,40113,44242,48468,52727,48631,44438,29451,25225,55002,65502,65470,65502,42292,52955,52857,46518,61341,63389,54936,40175,27399,12868,4579,12741,19050,36053,44275,38001,38034,38067,33906,38100,38100,38100,33906,31858,59326,65535,61374,55101,57149,59294,65535,59163,35950,29675,29738,29705,255},
{25653,25653,25653,25653,25653,25653,25653,25653,25686,25718,29911,29911,34040,31992,34040,34040,34040,34072,40312,54905,59065,59065,54873,44472,27766,17300,15154,17234,17234,15154,17267,21396,19347,17201,17201,31796,19216,15022,15022,10828,12876,17070,17069,12843,19149,25423,17004,14891,31696,33775,35823,54806,54774,46420,46355,44307,46355,44307,44275,42227,40147,40115,40147,38034,35954,33841,35889,33841,31761,31728,31728,31696,31696,29648,29647,29648,29615,29615,29615,29583,29550,29550,35889,29615,31630,27469,19018,21131,21130,21130,16905,12712,21131,12745,10697,31565,29224,29257,27144,27338,33842,19084,19084,14858,23342,19084,23277,21164,38002,40116,40148,40115,19019,25455,21163,10665,16906,12778,19050,12778,14858,12745,21099,35791,35824,19116,17004,40147,52759,52759,38002,25389,23305,27464,23271,21158,21158,19013,21127,27496,12708,12711,23211,21130,21099,23244,27438,29583,31696,33842,40180,48500,31659,16965,16934,21161,16966,6499,21291,40177,35951,29644,33904,36016,23401,29709,21255,14917,19207,19143,12837,23368,21255,21255,19143,25480,14982,6499,4354,12837,2209,65,31498,46125,41997,44177,44177,37871,29386,27338,31660,44210,35759,31500,33678,46421,56920,42129,33678,31596,57083,65469,65469,54902,31851,29804,27692,38195,50742,38191,31883,21414,21415,15142,8740,10788,15079,21259,35789,46322,40049,35921,33841,33841,33874,36019,40212,44470,63487,65535,65535,65535,63422,52988,63487,52856,31756,29709,29707,25511,255},
{25653,25621,25653,25653,25653,25653,23573,25654,25686,27766,29879,29911,34040,31991,34040,34040,34040,34039,46585,57017,56953,57017,52825,44472,25686,17300,13074,17235,17234,15186,19348,21428,19347,17201,19281,25522,19216,12942,12974,10828,10828,10828,12908,14956,19149,25455,12875,14891,27502,31694,33710,56919,54807,33743,29485,27438,29517,29517,29485,27470,27470,27470,27502,25389,25358,23245,25358,23245,23245,23276,23244,23277,21196,23277,21196,23245,23245,25357,25325,25292,23243,25324,29583,25357,31597,35856,23276,23243,23243,23243,23243,23243,21130,16937,8519,16971,23211,21098,18986,27469,33874,16972,25261,25293,19084,23244,25325,21196,33841,40148,40180,35922,27472,29519,21098,10665,16938,12778,16938,14858,10633,4261,19084,42163,35857,21197,19084,38035,52759,52759,35921,23309,25388,31690,25383,21158,19046,21190,27527,33799,27463,29514,27435,23210,21130,21131,23244,27470,29583,33907,33939,25353,27433,16966,14887,12806,12805,10724,23337,33900,27564,23371,29678,27597,27563,29644,21256,19175,21256,19079,17030,25513,21256,19143,17031,16998,10789,8580,21095,33675,31562,31563,39852,44012,37771,37936,42163,40116,42097,48110,39788,27307,31468,31468,29387,40017,48467,37871,37806,42064,59163,65501,61210,33931,23462,19302,17190,12998,17159,23558,21446,19366,8771,8804,8773,6628,6693,10758,27370,37871,42128,44274,38034,33808,31760,35987,54905,57050,63455,65535,65535,65535,65535,63455,63455,63422,44403,27563,29706,27592,255},
{25653,25653,25621,25621,25653,25653,23573,25654,25686,25718,27831,29911,34040,31992,34040,34040,34040,34040,40312,57017,54905,57017,54873,46552,25686,17300,13074,17234,17267,17234,21428,21460,19347,15153,17233,23442,19248,12974,15022,12909,12876,10796,14956,12876,23343,35890,14956,17004,27502,35888,39984,54807,54807,54774,54774,54806,54806,54806,54806,54806,50678,50646,48598,48598,48566,48566,48533,46485,46453,46453,46421,46421,44372,44372,44340,44340,46388,44340,44340,44339,44339,46452,44339,25324,25323,35888,33808,25356,29549,27469,27468,29549,29549,25291,19018,14858,16971,17003,14922,29648,38034,21197,19116,21164,19084,23244,25357,23245,29615,42228,31696,42228,31663,19018,21099,10698,19018,14858,14858,16971,12713,8551,27502,40049,33776,21164,17036,31761,52759,52759,35889,23309,27469,31755,25416,25351,21189,27526,29639,27494,23334,23271,23207,29516,23242,21163,23211,23276,27502,29616,33908,27565,19112,19080,12774,10693,14918,12837,16998,12773,4419,2340,6501,14951,21256,27466,23369,17095,17031,25450,19175,25481,23336,14917,2274,4387,4419,14887,48401,54675,50416,54707,56787,52528,44176,48503,50648,52696,50648,42064,31402,29387,29387,29387,29420,37936,33710,27241,24999,31564,37968,52857,63355,38093,21383,17190,15045,10916,19303,23527,21416,15110,8771,8805,21293,17066,6597,6629,27631,37903,33741,40081,46420,44275,35856,33808,35953,38099,48697,61342,65535,65535,65535,65535,65535,65535,63455,50710,29675,27657,255},
{25653,25653,25621,23573,25653,25653,23573,25686,25686,25718,27831,29912,34072,34072,34040,34040,34072,34040,40312,56985,54937,57017,54872,48600,27798,17300,13106,15154,15154,17234,21428,21460,19315,15153,15121,25522,21329,12942,15022,10828,12908,17102,17102,10795,23310,40180,23278,21197,29616,46387,52693,54774,54774,54806,54806,54806,54774,54806,54806,54806,52726,50646,48566,48565,48565,48533,48533,46485,46453,46452,46420,46420,44340,44372,44340,44339,44307,44307,44307,44307,44307,46420,38001,29486,21098,38034,42261,33776,35855,35855,33742,33742,31662,29549,27372,23276,16971,19084,19051,25422,35954,27535,17003,19116,19084,21196,23278,16939,27502,42228,16906,35954,42162,21263,21197,12745,16938,14858,14826,16938,6374,10665,38067,33776,31663,23277,19084,27535,50646,52759,33808,23310,27500,27497,23304,25416,29606,23300,19107,19075,21189,21255,16997,23176,31596,25258,23276,25324,25390,29583,29616,29647,21224,21226,19112,12838,17030,10692,14917,21193,17001,2307,131,12743,16967,14821,25418,27626,19175,23370,12870,17063,19207,16998,4419,4386,162,8549,35691,41997,48271,46190,48402,50516,48436,52729,50583,50583,50615,44146,31435,29387,29387,29387,29420,44274,50548,27176,29225,29483,23112,29647,48662,27593,19270,12965,19271,15077,17190,23592,27756,27627,15108,12965,23341,25454,10789,10919,44633,52890,46389,37904,42194,44274,44274,40081,35920,35920,38033,40244,50810,63455,65535,65535,65535,65535,65535,65535,50677,23431,255},
{25621,23573,23573,23573,25653,23573,23573,25686,25686,25718,27831,31992,34072,34072,34072,34040,34040,34040,44472,50713,52793,59065,48600,48600,25686,17300,15154,15154,15154,15154,19315,21428,19315,17201,15121,25522,21329,12974,12941,10828,10828,14989,17069,12844,27503,40148,27504,19117,27470,46355,52726,52726,54806,54806,54774,54774,54774,54774,54806,54773,50645,50645,48565,48565,48533,48533,48533,46485,46452,46452,46420,44372,46420,46420,46420,44307,44307,44307,44307,44307,46419,40146,23243,35888,33776,38034,44406,38034,40081,42194,40113,40081,37968,29516,25258,31696,21132,19083,19051,23277,31696,44307,27470,19116,19116,19116,23375,14859,25422,44308,21035,31696,37969,19116,21132,16906,16970,14858,16938,23277,10665,19116,35988,27438,35921,27470,21197,23310,46485,52759,33776,21195,25419,23335,16998,23303,29671,27590,23333,21221,21222,19109,16964,16933,23079,31499,16906,19051,29550,29583,29616,31729,27500,29646,19112,12774,19144,10725,10725,17032,31662,19050,10629,12771,12835,14851,21160,27531,19143,23404,19144,14982,12837,10757,12837,10693,259,19047,46158,46190,46191,44110,35724,27338,40082,52696,50583,50583,50550,50550,35726,29355,29387,29354,42195,54775,46030,31305,31467,27338,25225,36018,42353,29770,27687,17188,17221,15044,17158,15109,25642,19271,19334,17189,10790,8581,8708,13097,46682,52891,52891,48697,55035,54906,37937,29485,33775,35920,40081,35920,33840,40245,52988,65535,65535,65535,63487,63422,38061,23399,255},
{25621,23573,23573,23573,25653,23573,23573,25686,25686,27767,27831,32024,34072,34072,34040,34072,34040,34040,44472,50681,50713,59065,44440,48601,25718,17267,15154,15154,15187,15154,17235,21428,19315,15121,17201,25522,21329,12974,12941,10828,10828,10763,12876,12876,27471,31794,16972,14924,29615,44274,50613,52726,54774,54806,54774,54774,54774,54806,54806,54774,52726,50646,50645,50613,48565,48565,48565,48565,48533,48533,46453,46452,46420,46420,46420,46420,46387,46387,46419,46419,46452,40114,23277,42292,40147,33840,25357,33710,48533,48533,48533,44372,42259,38066,33775,27470,25390,21164,19051,21164,23309,33776,48467,35855,19083,19084,21230,27569,33808,42260,27504,27503,35888,27469,10600,12745,12810,12744,23244,33842,10665,23375,23212,27437,46453,33776,19116,19116,44340,50679,31695,21162,23275,27498,21190,23335,29704,25446,17028,14916,17029,19142,16997,19143,16901,18886,14793,10633,29550,31728,29648,31696,31728,31695,21225,14919,12838,14983,12838,2307,6468,14823,27497,21189,19075,10691,17032,12806,21225,23370,14950,15015,17030,14854,12806,12774,6468,29515,48271,46158,46190,39885,39982,35855,38067,48469,46357,46357,48470,46357,33548,29355,29387,29355,46518,65535,61049,43884,43819,31272,25129,27499,29801,27721,23431,23463,27751,19332,10915,15109,17190,17222,23527,10916,6564,291,8739,19470,50811,50810,50778,50843,63487,65535,63390,48502,31566,29485,35888,35888,35920,40146,33905,38197,55101,65535,59261,61309,42255,25479,255},
{23573,23573,23573,23573,23605,23573,23605,25686,25686,27767,27831,34105,34072,36152,34040,34072,34040,34040,44440,52728,50713,57017,44440,48633,27766,15187,17234,15154,15154,15154,19347,21428,19315,15121,17201,25554,19248,15054,12941,10828,10828,10828,10763,12843,25423,33907,17069,14891,29648,35856,35791,54807,54806,52726,52694,52694,52694,52693,52693,52693,50613,48565,48533,48533,46453,46453,46420,46420,44372,44340,44308,44307,42227,42195,42194,42194,42194,42162,42194,42194,44307,38033,31564,44274,40081,38067,27437,27371,50646,40212,38099,38099,35986,31793,31695,29550,29616,25390,19051,21196,21196,23277,33808,42194,37969,21196,17004,27601,29681,38067,38068,23309,35856,29583,8455,18986,10697,10598,14792,18953,12810,12779,14825,33808,50646,38001,19116,17003,38067,50679,31663,23309,29583,31725,21223,27528,27559,27526,21221,19110,19110,21255,12772,12805,14917,14757,16805,23209,35823,29583,31696,31761,29616,31728,25452,14951,4483,8613,6500,258,129,6434,23302,23303,19110,10723,8643,2306,23209,23337,12870,14918,10660,21097,23177,14823,12774,35756,48271,46158,44078,48436,50615,44374,42293,40148,44341,44243,42195,44211,31468,29419,29354,27274,50679,65502,65405,37513,35238,35238,20871,21226,27690,23495,23464,29740,27719,17155,6690,6691,10885,15078,17255,12965,10628,4451,14951,34068,52891,50810,50778,50843,65535,65535,65535,65535,61277,40050,25292,31662,42259,46485,44307,35920,31760,40310,57214,65535,52791,31755,255},
{23573,23540,23573,25621,23605,23573,23605,25686,25718,25718,27831,34105,34072,36152,34040,34040,34040,34040,44440,52728,48600,56985,46520,46521,25653,15187,17235,15186,15154,15154,21428,21428,19314,15121,15088,25554,19248,12942,12909,10796,8748,14989,10763,12844,25423,27569,17004,17004,25422,31663,33710,56887,52726,31663,27437,29452,27437,29485,27437,29485,25357,25325,23212,23212,23244,23211,21163,19084,23277,23277,21132,23212,21164,19083,19083,21132,21099,23179,23211,23211,27502,42259,37967,31499,37936,48599,38001,29516,48566,40212,38099,38099,35986,38067,29581,12774,14921,27535,21099,19083,23245,25422,23277,25389,44307,42226,23309,17004,23277,33874,35955,33777,37969,35987,16938,18986,14826,16905,12745,14825,27437,29485,23244,38001,48533,44339,23244,16971,33809,50646,29583,23309,29615,31695,17002,35917,27559,27526,21221,17029,14884,14949,12804,12772,10660,14853,14789,25352,40079,19120,17007,35922,31696,29615,25485,14983,4483,2371,2307,2307,4452,8611,19141,19109,19142,14949,10691,6499,23178,25290,19112,17063,12805,23209,29387,16873,14759,37804,48271,46256,52662,54808,52729,54841,54809,54841,42293,40148,29648,27502,29355,33581,31468,23146,54872,65470,54808,37610,35498,35531,27274,27339,27625,25639,23494,25576,19366,15108,17220,12996,8771,8804,10950,6660,17000,23307,29646,46584,52923,50842,50778,50875,65535,65535,65535,65535,65535,48631,42292,38032,35887,46420,44209,37935,38066,35954,31794,42391,48599,38033,255},
{23540,23540,23573,25621,23605,23573,25654,25718,25718,25719,27831,34105,34072,36152,34040,34040,34040,34072,44408,50649,44472,56985,44472,42393,21493,15187,15186,15154,17235,17235,23476,21428,17234,15121,15088,23442,19248,12942,12941,8748,8748,12876,10796,12844,27471,29617,21165,14955,25454,35921,37936,52726,52694,42194,42194,44242,44274,44307,44275,46322,44274,42194,42162,40114,40146,40114,40114,40147,38001,40049,38001,37969,35856,37936,37904,35823,33808,33743,33775,37936,35856,42226,35823,25258,40049,48599,42259,35823,48566,40180,38099,38067,38067,38033,12741,6531,8644,12773,23275,21163,21196,23309,23277,21164,27502,44308,44339,29582,23341,33809,35987,46388,54774,50613,40048,35855,37935,37967,37935,42160,44240,44240,44240,37934,35887,46420,27470,16971,27503,50646,31728,23277,31696,40015,29615,35986,29610,23302,21222,23335,21190,19110,12804,14854,17031,16966,14822,21126,29545,15019,14861,33776,33841,31696,29616,23339,10789,6595,4483,6567,12809,6501,6595,19141,17029,14949,10724,8644,10661,14823,23210,23337,19081,31531,27177,21066,21065,44078,48271,48403,56954,56922,56954,56953,59001,44308,25520,31760,31630,27340,27242,27274,25162,23178,50679,63324,35597,35792,44177,40050,38067,48664,44403,31852,23496,25577,21415,25640,19366,15140,12996,8772,4547,4580,2467,8646,33840,48730,52923,52891,48730,48762,57181,65535,65535,65535,65535,44404,40244,42358,42292,40145,42193,35855,42227,42259,42260,35921,29615,25455,255},
{23540,23541,23573,25621,25653,23573,25686,25686,25718,25719,29912,34137,34072,36153,31992,34040,34040,34072,40280,46520,44472,57017,46520,40313,19413,15187,15187,15154,17234,19315,23476,21428,17234,15121,15120,23442,19248,12942,12941,10828,10796,12908,12909,12876,25391,25488,21197,19148,23373,33841,35889,31761,35955,35921,40147,38100,29713,40180,35888,35888,33808,31727,31727,31695,31728,27502,27567,42392,27437,25194,23146,23276,16840,23146,25161,23048,18953,12647,12712,18921,23114,37968,29549,25259,42227,52758,50646,35855,46453,40179,38067,36019,35986,35952,8580,8612,10789,6563,10726,25324,23276,21196,23277,23277,25390,25422,38034,37968,33774,31663,40081,33743,56853,61078,52594,33742,33743,33775,31630,40080,48432,27500,27533,29581,23274,42259,33873,16938,21229,46421,31694,19082,29583,46453,38034,34005,31630,21160,14885,23303,23303,23304,14917,14886,16967,8515,19048,23273,23208,25321,23145,29549,35921,33809,29648,27535,25452,21258,10789,19148,12844,6438,14888,14948,12900,10756,6500,4420,4387,4387,4421,14922,17001,16999,23114,25259,21128,46190,46191,41965,42195,52728,52761,54841,44308,33905,31858,48565,44242,44177,39919,29387,25161,25259,55002,61146,33353,33842,29518,27305,27306,23112,27534,42226,29580,25449,15142,19367,15109,17189,10884,4579,4580,4580,2468,2435,27597,40277,48697,52923,46552,50907,65535,65535,65535,65535,59197,38066,38065,27534,42457,44470,40146,35920,42226,44307,42227,42259,42292,38034,255},
{23541,23541,23573,25621,25653,23605,25686,25686,25718,27799,29912,36185,34072,36152,31992,34040,31992,34040,38168,44440,44505,57017,46521,36120,19412,15186,17235,15186,15154,21395,19315,21395,17202,15121,15120,27635,17136,12942,10861,10828,10796,10795,12908,14956,14924,19117,23245,21197,25390,33841,29616,23278,31729,21262,21295,29746,29680,36020,31794,31826,31793,29713,29713,29713,29713,25389,27502,42425,33874,25226,25161,21131,10567,16775,18888,18856,10598,4356,4293,14696,18985,46419,35855,27371,31629,37969,46454,29485,46453,40179,38099,38066,38066,38034,12710,10629,12774,10757,8646,21162,35888,25357,21164,23245,23277,25390,25390,29583,40147,38001,37902,40048,58965,61046,56852,50481,52659,52660,52659,50514,52658,40047,29549,31596,37932,40048,29582,16874,17036,46453,33808,19082,29582,44407,42260,37903,33645,27371,23144,21191,21255,19078,12805,10724,12741,10629,6531,23274,29483,27403,18951,29581,44307,35889,33841,29648,29616,23307,19147,25455,23408,27699,21295,17032,8611,8611,6531,2306,2274,6468,4356,10696,19017,10661,23276,27436,25289,46223,46223,44045,35660,48470,46422,44341,40178,31792,29745,48403,44210,42065,39984,35693,33613,37969,61309,50484,31337,33776,27469,29484,35758,43852,44211,65535,56985,33869,23528,23560,15110,15078,12996,8773,8773,8773,2404,2467,21386,31694,17096,31955,48730,57213,65535,65535,65535,65535,61276,40211,38098,23374,44602,46617,42357,38066,38066,42226,42194,44307,44340,44372,255},
{23541,23573,23573,25653,25653,23605,25686,25686,25718,27799,29911,34137,34072,36152,31991,34040,31992,34040,36120,38232,46553,57017,44473,29879,19412,15187,15187,17234,17234,21395,19315,21395,17201,17201,15121,25522,17135,12942,12909,10828,10796,12908,12876,14957,19182,14956,27535,33808,27438,31794,27503,23245,27569,17069,17069,38132,44406,40146,38001,35921,33840,33808,33808,31727,29615,31728,25422,42425,38199,21033,25129,23114,6342,8421,12647,10469,6437,2212,6309,12681,16938,19082,29549,33644,27371,27372,44308,44308,46485,38099,36019,35986,38034,38001,31630,23242,14856,12838,14855,14855,31661,27469,23244,21164,21196,23277,25390,25390,31761,42129,35822,44274,58933,61078,61014,56787,61046,58998,61046,54772,52594,18985,4326,4358,21194,37968,31630,12777,12778,40114,35889,23309,25389,27470,38067,37936,37870,31531,29386,25353,21256,19078,14853,10660,6403,4355,321,6627,40080,40016,25258,35855,48500,42195,35921,33809,29616,27502,27535,27536,25390,27602,34169,27596,10755,14980,19205,8611,162,2275,6405,8583,12775,10597,16935,14983,19111,46223,50514,46094,33450,48503,46422,44309,46388,35953,21229,23016,27274,25161,31435,35628,31500,44373,65535,65470,48338,29257,29485,29550,33873,35790,44177,63421,65535,46355,25513,23496,17127,19209,23529,17127,10854,4580,323,4579,38063,48434,35886,27371,31565,36020,57181,65535,65535,65535,57083,40243,40146,31825,48861,50844,42293,42292,42325,35985,38001,42258,44339,44340,255},
{23541,23541,23573,25621,25653,23605,25654,25686,25686,25751,29912,34105,34072,36120,31991,31992,31992,34040,36120,36120,46553,56985,44441,25686,19412,15186,15187,17267,19315,19315,21395,19315,15121,17201,15120,21362,15055,12974,12941,10828,8716,12876,10796,12843,17069,23343,31696,52628,29486,27601,23279,25326,29714,27634,19182,33841,42260,40081,40081,38001,38001,35920,35888,35856,33775,31630,27502,44506,36087,21098,25258,21098,14792,18953,21033,18921,16937,16904,23113,16873,4357,4357,25356,35822,29451,25258,40049,54905,48566,38066,35986,35986,35954,33776,29613,12773,10662,17002,25358,12840,23274,29581,35888,27437,23244,21196,21164,23374,38065,37901,25258,29680,56885,63158,61078,56787,58965,61078,58998,56885,54706,37870,23178,25290,25323,31630,40114,16905,14858,38067,33809,27503,25390,19182,38067,33743,37806,35725,31531,29515,23144,18918,20999,21031,4290,4387,2435,27596,35789,37903,44274,40081,50646,48533,40081,33808,31728,29616,27535,27503,27471,27502,33904,29642,25478,25479,25477,12867,10694,10662,16968,12809,19049,12741,16934,8675,14982,46224,44078,37804,39984,50583,48502,44309,44245,42195,31532,27274,29387,29387,37774,29419,19147,48696,65503,65535,52499,35466,50778,55003,42228,19116,38099,63356,65502,42161,23176,25417,23241,12712,19178,16968,10726,2371,2372,10789,46386,50547,52628,50515,39886,35661,33486,44343,61375,65535,54937,40210,38000,36051,50909,52990,48698,38099,40213,46585,44471,35985,35952,44339,255},
{23541,23541,23573,25621,25653,25653,25654,25686,25686,25719,29912,34137,34072,34072,31992,31992,31992,34072,36152,34072,44505,56954,38200,21525,19413,15187,15154,17234,19315,21395,21395,19315,15121,15153,15121,19281,12975,12942,12909,10828,8716,8716,10796,12875,23310,19117,31631,48468,29486,27536,21230,21197,25455,19215,12876,12841,29582,29550,29550,27469,25357,25356,27437,25356,25389,29485,29453,44506,38199,33775,42193,23243,23211,21163,21163,21131,21130,21163,33709,25290,25323,29581,46419,44241,31564,25258,37969,52824,46453,38066,38034,35954,35954,33776,23242,10692,10598,14792,19149,21230,16840,23209,16967,25387,29582,27501,25389,21294,36082,42094,41997,34068,52757,54708,54805,50482,44241,44241,44242,42129,40048,42160,52659,44207,33644,35823,42227,21132,21164,29648,29615,29616,31662,37806,38035,29517,33644,33547,29386,25257,23047,27304,27305,21032,4290,6499,12903,27531,33806,25224,39984,48532,52726,52759,48500,35888,31695,29616,29616,27535,27503,33870,29674,25448,23335,23367,17028,12836,19143,14886,12774,14887,29549,23146,16935,8643,14917,39982,46191,39884,44210,50583,48502,46357,44309,42164,33613,29322,29354,29322,29355,17098,17164,50842,65470,65502,44177,38067,63422,59196,44308,16938,42259,63324,65470,40016,25259,27339,25291,16840,21065,12840,6566,2373,2308,25386,50547,50547,50547,52628,46290,39886,27112,25065,35986,55003,48631,44437,33839,38197,52990,50909,50844,38132,44537,46618,48763,44504,42357,40145,255},
{23541,23540,23541,23573,25653,23605,25653,25654,25686,25718,31992,36185,34072,34072,31992,31992,31992,34072,36152,34072,46585,52825,31959,19413,19445,15219,15154,19315,19315,21395,23476,21395,15121,15121,15121,15088,13007,12974,10861,10828,10828,12876,12908,12875,25391,19117,27470,40082,27406,29648,23376,23343,25390,21230,17003,10696,25357,23276,23276,25356,27502,25454,21196,21131,25356,42228,42260,36020,31860,31565,44306,25388,19050,19050,21130,19050,19018,19018,23211,14792,35790,44242,44339,50645,37902,27339,38001,54904,46485,38066,38034,35954,35954,31696,31694,12708,8550,14857,16971,29616,20938,10628,8612,8612,21225,21224,23338,25421,23535,35853,37933,34199,48564,44241,48467,46322,27469,25389,27502,25389,29615,25389,48499,37804,16806,38000,42162,25489,17071,25422,23309,29648,27469,35725,38035,29517,37805,33546,27304,14821,16805,25256,29546,21063,10563,19046,19079,6626,23434,21128,25258,40081,54839,54839,48501,42194,40113,33776,31696,29616,29615,31725,29674,23366,19174,17029,12837,14950,17062,21223,19110,17030,19143,25291,19048,10692,23207,25288,46224,41965,44243,50583,48502,46389,44277,44244,33548,29354,29354,29322,25161,19049,21325,54970,65502,65437,39984,40277,65535,65535,50647,46518,52823,63324,59131,44471,33841,21391,38165,23146,23177,14985,8744,17001,8517,37902,52628,50515,50515,50548,44144,35692,25096,14887,33805,37935,37968,38002,44438,46650,53022,52989,50811,40278,48763,46650,46683,42390,36048,29671,255},
{23541,23541,23541,23573,23605,23605,25653,25654,25718,25718,29944,34137,34072,34072,31992,31992,31992,34040,36152,34072,48697,48697,31992,19413,19445,15219,15154,19315,19315,21395,21427,19347,15121,15153,15121,15120,15055,10894,12909,12909,10828,8715,12876,12844,21230,17036,25389,31663,19019,29681,21262,23310,19116,25454,25389,12809,8647,8615,8648,17003,33842,31827,12842,12842,14921,12745,12680,23277,29648,25291,40049,31629,29484,21163,16937,16905,25324,18985,21098,16872,29451,46354,42161,50645,40016,25259,38001,52792,38002,38067,35953,38034,38034,33841,37969,27404,25324,25455,25423,23310,21066,8644,8613,8645,14917,12772,14918,31659,17096,23241,33741,30072,48564,52627,50580,50547,31662,31695,31663,29582,31695,27470,46419,44111,12548,29549,37969,33875,19249,25389,21196,29648,31695,33742,33841,31629,37837,27337,14853,12773,16869,27368,29513,27432,21157,31658,23272,6627,17159,14951,23178,33775,48501,54904,48533,42194,48533,42227,33809,27501,31754,27527,25447,27593,23336,21257,21193,14950,21224,27562,19143,19143,10723,12837,12837,14889,21128,23175,35821,39983,46356,48502,46389,44276,44244,42163,31467,29354,29354,29354,27274,25162,25291,46518,63357,65404,37546,46356,65535,65535,52857,59229,59065,63323,56985,48697,40213,34004,42293,23146,23145,19113,19146,46354,39983,44241,50580,50548,50515,50516,42031,37644,27079,19046,48530,48367,42128,31532,27404,42392,50909,52990,48763,42456,46683,48698,46615,38159,29705,29672,255},
{23541,23573,23541,23573,23573,23605,25654,23605,25686,25718,31992,36217,32024,34072,31992,31992,31992,31992,36152,34104,48665,52825,34072,19413,19413,17300,15154,17202,19315,21395,21395,21395,15121,15121,15121,17168,15055,12974,12909,10828,10796,12909,19182,10795,19085,12843,19116,40049,23180,29680,33810,29584,21261,25421,25422,8648,10759,6567,6535,8584,33808,33906,12842,12906,17034,12776,10664,21229,21229,27371,39984,27306,35791,31696,19083,19050,35823,18985,25259,21098,27437,42161,33807,46452,31695,31663,27437,48533,29452,37969,29517,35953,38066,38033,33775,33710,40049,29582,29648,25390,29582,19145,23307,21226,25420,23274,27500,33740,23238,25319,40081,30038,44272,48467,44307,52660,29582,29582,27502,27502,29582,25389,42226,48401,16741,23177,38001,46420,25423,23309,21164,27503,38033,33741,33809,35987,25419,16966,12806,12806,27270,44041,25318,25351,19109,19109,21189,14918,17095,25386,29451,35888,40082,48532,52758,46452,50646,54840,44307,33806,29640,19109,17029,21286,16997,14886,19080,19111,16998,14950,12838,14950,6530,14981,17126,14951,16968,19045,12802,14919,40115,46389,46389,46357,56953,52662,31435,29354,29355,29355,27274,27274,25227,40212,59131,63291,35661,50712,65535,65502,50777,57116,56984,59098,52857,48697,29680,27730,40147,10501,2179,19050,29516,48467,48435,44242,48467,46453,46485,48435,39918,35531,31369,23304,54837,63092,48435,33710,27437,38165,46585,48731,48763,46617,44471,40207,35975,29701,25509,25478,255},
{23541,23573,23541,23573,23573,23605,25654,23605,25686,25718,34104,36250,31992,34072,31992,31992,31992,31992,34072,34072,44505,54906,36152,19413,19413,17332,15154,19282,19315,19282,21395,21395,15089,15121,15121,19281,12975,12942,10861,10860,10796,12908,15021,23309,37871,35790,35790,44176,37870,37902,40016,40015,40015,39950,37869,33676,33676,35757,25386,29482,42030,42063,35757,35789,35789,35789,35789,35789,37869,33644,35790,37935,37936,40016,31662,35888,35888,37936,35887,37968,35887,40048,35790,40016,33742,40081,35888,40113,37968,40081,38000,40113,38033,40048,37968,42193,42226,33742,29613,35952,44339,35888,36017,40211,44404,35985,40113,36017,31757,25384,38000,31988,40048,54772,48467,54773,33743,31663,29550,29582,27502,25421,38001,52626,16708,18951,35952,46452,31728,23277,19083,27470,46387,37805,39985,40343,25485,14918,10757,23335,31688,29543,23238,16933,12805,16997,21221,2401,10820,19175,29547,33807,40114,42161,37967,52726,54872,56985,52758,42224,31690,25449,23335,19141,14949,12805,14919,17030,21255,14886,8644,8611,8676,14981,14950,12804,8485,12741,6529,2273,4356,14824,23243,31599,44308,44210,31435,29387,29355,29355,29322,27274,33743,59196,65502,59098,31760,52955,65535,63389,50777,57083,52726,59065,46485,50810,50778,50810,33776,8485,4292,8550,37968,52595,50515,50548,50548,46388,46453,46354,39885,33418,25095,19176,56917,61077,44373,44438,46551,46519,44438,44504,46585,46617,44436,31784,31749,23398,27559,23429,255},
{23573,23573,23541,23541,23573,25653,25654,23605,25686,25718,36217,36249,31992,34072,31992,31992,31992,31992,34072,34072,42425,50713,38232,19445,19413,19381,15154,15154,17202,17202,23444,21427,15121,15121,15121,17168,12975,12942,12941,12909,10828,12876,10828,31630,48335,44110,44143,44143,46223,46223,46191,46223,48303,46255,44174,46222,44142,42062,10823,27369,46223,44143,42030,42030,41997,39917,37869,39917,39949,35724,31565,37968,33839,37968,29614,31727,27436,37903,31597,35758,33677,37903,31564,31597,31564,37936,31596,33677,33677,37935,31564,31597,31564,37903,31499,31596,31564,35855,27500,27629,44404,38001,38130,40308,50743,38033,44340,40212,42356,40178,40145,36018,33774,52627,40113,54773,35855,33775,31630,31662,31662,31630,37968,54772,31433,23111,23306,37968,38034,21228,21164,23277,38001,39821,42098,40376,29615,19112,14983,27560,25447,19077,19078,12805,6435,8644,12869,385,8740,17126,21224,33775,38065,44242,37935,35854,52726,59065,50613,46387,35917,29675,23369,17030,14951,19144,17030,23369,27500,16999,21256,12804,10725,6499,14919,12805,4290,12677,16965,6498,161,2241,12742,14758,19017,27338,31435,31435,29355,29355,29322,27274,35889,61309,65535,54774,33613,57115,63356,61276,50810,52858,42226,57017,52791,29517,27404,27340,25161,21064,14854,14919,46354,50515,42129,44274,50548,50547,50515,46321,41901,35532,33549,31856,56950,44340,33971,33971,40310,50810,50809,46551,44438,44434,35975,33829,31783,29707,31784,29739,255},
{23573,23573,23541,23573,23605,25654,25654,25654,25718,25718,40378,36249,31992,34072,31992,31992,31992,31992,34072,34072,44473,46553,42393,23606,19413,19413,13106,13073,19282,19315,21363,23476,17201,17201,15153,15055,12975,12974,12942,12909,10860,10796,8715,27502,48336,42062,44142,44142,44110,44142,44143,44143,46223,46223,46223,46223,46255,29612,2405,25225,42094,42062,42063,42031,39950,39950,37901,37837,37837,33708,23211,37935,23502,35920,27662,25517,14792,31564,18854,23178,23111,31564,27306,23145,25193,33710,27338,25290,27402,33742,29418,25291,27370,35790,31564,29484,27338,37935,37903,33774,40113,46387,50613,48467,50612,46419,48532,44339,50612,52726,42192,42193,33774,58900,58998,61046,54707,56852,56885,56885,56885,54772,52626,52658,48400,39981,23242,44372,42260,21164,21164,21196,35889,39788,42130,40343,29550,19047,12838,12837,16998,8547,10692,10724,6467,6596,4483,2401,8740,17062,21194,35855,42162,42162,33743,31661,42194,59065,54839,44306,38031,27528,23336,27532,27467,29644,19110,25417,19111,14886,17063,19143,17029,10692,14887,14950,6434,12709,17030,19014,19014,25352,37901,27338,27403,31531,31435,33516,31435,31435,29322,27275,38001,50679,65502,50483,33613,57050,48598,59131,52922,52857,48533,65469,59000,25355,25551,29257,37480,27368,17127,17128,46322,46322,37969,50547,50580,50548,50548,37903,27307,40214,50809,50712,42293,33971,36052,36019,36019,36052,44503,50809,40173,35976,35909,31717,33863,31820,27595,27593,255},
{23573,23573,23573,23573,23605,25654,25654,25654,25718,25719,42458,36249,31992,31992,31992,31992,31992,31992,34104,34072,44473,46553,44473,27799,19413,19380,13106,15121,21363,19282,21395,23444,19282,15121,15121,17168,15055,12942,12909,12941,12908,10828,8748,25357,48368,42062,42062,44110,42029,42029,44110,44110,44142,44175,44143,46223,46255,19177,4452,19081,23372,21324,21291,21324,21291,21324,21324,19179,12808,21291,23437,37936,33807,37968,33774,33807,33807,37968,35823,31629,37935,35855,40048,35887,37936,33678,40081,35952,42161,38000,42161,38000,42161,35823,44242,40113,42161,35855,37870,25322,21162,27468,35887,38033,38065,38033,35920,38033,35887,37967,42160,37966,29579,52658,48467,52660,46289,35855,35823,35855,33742,33710,42193,42128,10632,19243,31855,46453,42292,21164,21196,25357,29647,27307,40115,40311,27469,12805,8677,8644,8644,14949,12837,12804,10660,8612,10725,2402,10821,12902,25487,35855,40114,40081,38002,35857,35888,44339,50645,48498,35916,31690,25416,29644,27562,27530,21191,14886,14885,14917,12804,10756,12868,4450,8677,17127,8580,10661,21222,27496,29544,29449,29515,29450,27436,37805,31467,31435,31468,31435,29355,29355,42292,54937,63356,48566,34003,63422,63357,54937,52923,54970,52823,65502,50548,27436,31727,31401,31303,21030,10757,19145,46354,33678,31663,50515,50548,50547,50547,35790,27372,35988,44437,38131,36019,38132,36084,36052,36052,36019,33939,40211,40236,33894,38053,31749,23366,25513,31821,21319,255},
{25686,23605,23605,23573,25653,25653,25654,25654,25718,25719,42490,36249,31992,31992,31960,31992,31960,31992,34072,34072,40345,46521,44441,34072,19413,17300,15154,17202,19282,19315,21363,21395,17201,15121,15088,17168,12975,12942,10861,10861,12908,10796,14989,29550,48336,44110,44110,44142,44110,44110,44142,44142,46223,46255,46223,46255,44175,12904,12936,23501,21453,21389,19276,23502,21421,21421,17228,21389,12840,19276,19276,35855,35822,35822,35758,31564,35822,35855,39984,31596,35790,35790,37935,33611,33645,35725,35822,35790,35822,33677,33709,33676,33742,31564,31597,33709,33710,31531,37935,40048,35919,38065,52758,48566,54936,50775,52856,50743,52757,48400,56819,44174,35855,52659,50548,50580,46354,29550,27502,29615,27502,27502,38033,46321,8519,12938,27727,46452,46388,23244,23244,23244,31630,33515,42228,40278,21322,10788,10822,8708,12901,14981,10756,8579,10692,8612,12870,8709,12870,12805,25456,33808,40081,44274,38134,31729,33775,25357,23308,44306,46418,38030,29610,21223,17093,27529,17029,8612,12805,21223,12867,10723,12869,6532,12902,17001,14855,12741,27527,29512,27399,27366,23206,19014,25354,29514,23176,10691,12804,16935,25225,27307,38164,63389,63356,44145,40180,65502,65535,52857,52923,54971,40113,52824,46387,27338,31595,29547,19144,12902,6597,21259,42129,33613,42096,50547,50547,50515,50547,39951,33483,25128,16999,27598,38166,38165,38165,38165,36084,36052,33971,36050,35977,27556,31782,27556,19172,21287,27594,19176,255},
{25686,25686,25654,23605,25653,25654,25654,25686,25718,27799,38362,36217,31992,34072,31960,31992,29911,31992,34072,34072,40345,44473,42393,40313,23606,17332,15154,17202,21362,21395,21395,19315,15121,15121,15088,15088,12975,12974,12942,10861,10828,10828,14957,42194,48369,44174,44174,46255,46255,46287,48368,48336,46288,46288,46255,46255,42127,10855,15081,23534,21453,21453,17195,21421,19340,21454,17260,21454,12873,17098,15050,31597,35692,23177,33677,16773,23112,25289,33709,25257,27435,23209,27500,16805,23178,25257,27468,27435,29581,27467,29516,27402,29549,29483,23210,31693,33839,29483,35887,44241,40047,46386,48499,52725,48500,54839,50613,54839,50612,50546,52659,48498,38064,48433,50547,46386,50547,29549,27437,27502,25357,27470,33775,48466,14760,14922,29840,44339,46420,25324,23244,21132,29550,37708,42293,40278,21289,12933,12933,17094,15046,10788,10724,12805,8516,19078,12805,8677,14984,10726,12811,29550,40081,40049,31695,27372,40049,21294,14988,35822,50580,46419,31723,27529,27561,23335,16997,14920,19144,21223,14917,14951,19114,21258,25385,23273,29577,31657,31688,29512,25320,27464,21158,21126,16901,16933,12709,8579,4513,321,12775,16969,40277,63357,63291,37513,44211,57050,61276,48599,48664,50712,44339,52824,59033,29418,19016,25386,23369,10757,8676,31726,50547,35889,46355,52660,52628,52628,50515,46322,33322,26983,14791,31628,42260,38198,38198,38197,38165,36084,36084,33972,31821,31783,31720,29671,25479,31785,27592,25479,255},
{25718,25718,25686,23605,23605,25654,25686,25686,25718,25719,40410,36249,31992,34072,31992,31992,29911,31992,34072,34072,38265,42393,40313,40345,25719,19413,17267,17202,21363,21363,21395,21395,15121,15089,15121,15088,12975,12942,12909,10828,10828,10796,12909,40049,48401,44175,44143,46255,46223,46255,46255,46255,46255,46255,46255,46223,42127,12936,25484,34001,36081,36082,33936,36049,36114,38162,36082,38162,35985,35952,40178,40113,48434,42225,48467,40048,44306,46419,48500,48499,48532,48532,48565,48564,48532,50612,48500,52790,50677,54871,50677,54839,50645,54903,48597,56984,50710,56984,50710,59064,50710,50743,50742,59129,48533,48598,50646,59130,50743,48663,48727,48727,46614,48465,54740,52660,54772,44241,46386,46386,46386,48467,46386,52692,44241,42160,48499,48499,46453,29550,19084,12714,27438,37741,42326,38198,23305,15046,15013,15014,8740,10789,10724,10757,8548,16934,12805,12870,17064,14984,16939,25356,40082,42162,25455,25325,37969,38002,23374,31694,44307,46418,33801,27529,27529,14917,19079,21226,19111,14917,17064,23310,27501,33772,25351,25351,31656,27431,29543,27464,19014,19077,21158,16933,21127,21159,14853,12740,4450,4418,16967,14984,44535,61276,59065,31304,44438,52759,54937,50744,57116,57082,54871,54936,56952,25193,8549,25289,29320,16967,8710,33806,48467,40049,50580,52628,50548,48500,46322,42064,33225,26951,12679,35821,44240,36020,36118,38230,38198,33971,33972,38199,33970,40202,35944,33896,33898,31818,29737,27624,255},
{27831,27767,25686,23605,23573,25654,25686,25686,25686,27799,44602,36249,31992,34072,31992,31992,29879,29911,31992,32024,36185,40345,40313,40345,27799,19413,15187,17170,19282,19282,23443,21363,15088,15089,17201,17168,13007,12974,12941,10861,12909,10828,21262,40081,46321,46223,44143,46223,44175,46223,46288,46287,46255,46288,46255,46255,46256,19145,44272,61112,50613,44371,44404,44403,44371,50581,52758,50548,54839,48532,54903,48597,56984,48565,56919,50677,56984,50613,56951,52726,54838,52758,52790,52790,52790,52758,52726,54839,52790,54871,52790,54871,52758,50678,52758,52758,50645,56952,52758,56952,52758,46452,48565,56984,52725,52791,50645,56952,50645,54904,50678,50678,46419,54772,58933,54740,56853,48434,48467,48467,46354,46386,42128,52659,35822,21163,35951,42258,46420,33743,14924,4427,29518,33678,40278,38133,27435,17063,12901,17094,15014,10821,12869,8677,6468,6468,8614,10789,2434,10726,16906,25389,46552,48666,23277,27437,40081,40114,33872,40112,44274,44303,31689,23271,21158,19111,23304,14918,14950,12837,17034,25390,29644,25383,23271,31753,27527,21158,21125,31593,25319,21157,21190,14820,19014,19046,14821,12741,6500,2370,16967,6660,44567,61276,56855,33288,50744,65470,61244,48664,57116,59130,56919,57017,48435,25226,23178,23114,18855,14759,12840,40081,48402,46322,48402,44241,48435,44340,46322,39951,31047,26951,19017,40048,42161,31761,29713,36085,38199,36085,31859,36085,36085,36012,31782,27559,29704,29704,25511,25511,255},
{29880,27799,25686,23605,23573,25654,25686,25686,25686,27767,46715,36250,31992,34105,31992,31992,29879,29911,31992,32024,36185,40345,38265,40313,25719,19413,15219,15121,13041,17202,23476,19314,15121,15121,15120,15088,12975,12974,12909,12909,10861,10796,35888,46386,46256,46255,44142,46255,46255,46255,46288,46256,46256,46288,46288,46256,46288,19179,33740,54741,44241,48500,54839,54871,56919,56952,46419,54773,46419,52692,48532,52660,50645,52627,54839,48434,54774,46354,50580,42128,58966,42096,56885,50612,50579,35854,54772,52725,52692,54838,52659,52693,50547,40081,48434,46354,48434,52758,48434,54838,48434,40048,42160,54870,48467,48564,42161,50612,42225,46452,37968,40113,38032,46353,52659,38000,52692,33775,27469,29550,27469,27534,25389,44241,23211,6536,15148,25550,38034,33743,14891,6475,33776,33776,40311,35987,31500,27403,12902,10821,12934,10756,8644,8612,8581,8613,8645,10757,4483,12969,25357,31662,42326,33842,33710,40081,40114,38066,36017,40081,44273,44272,33802,25382,27497,29610,25416,16999,21224,10756,23309,29617,27500,19079,23272,29575,29544,18981,16934,23207,27495,23238,19045,19078,12773,14886,10628,12742,21130,12710,14855,6564,15082,48696,52628,31272,54970,65470,59163,48696,57116,57017,61177,59097,46551,46584,48665,38034,12743,10696,14984,44241,48434,46289,46289,44177,48402,48370,46322,37774,37646,44146,46453,44405,35987,34004,29778,29681,33939,36085,38166,38165,40278,38130,33867,27559,27622,29702,27623,25511,255},
{27831,27799,25718,23605,23605,25654,25686,25686,25654,27767,46715,36250,32024,36185,34072,31992,29911,29911,31992,32024,36185,40345,38265,38233,23638,19413,17300,13041,13041,23443,25556,23475,13040,15121,15088,13007,13007,12974,10861,10861,10861,10796,33776,37935,39982,50449,44175,46255,46256,46255,46288,46288,46256,46255,46256,46223,46256,23373,21225,52561,52627,50579,50644,50612,50645,48467,44274,42095,37869,40014,42193,42159,46419,40079,44435,37999,40112,33708,35821,37966,42224,44338,35886,38097,38096,33903,29515,33806,38095,42387,35951,31823,23274,25322,31693,31791,27436,23275,31726,44370,33774,14791,29645,29808,33936,36210,31759,12776,27500,29808,23308,12776,29678,27531,56820,48467,54773,38001,29614,29582,29582,29582,27469,44274,31629,8875,19276,31856,44372,31695,19052,12747,35888,35856,40311,35954,25258,27502,31791,14983,17126,10788,10789,10789,10725,12807,10694,14921,19016,14856,27470,33743,40049,35823,35823,44242,42162,40082,38000,44241,40081,42194,38030,27497,44404,40143,25449,23368,25481,14951,25455,33809,27468,23306,29640,25414,27464,16900,21190,31689,31657,23303,21094,14788,6403,6403,8516,12709,16838,18952,16839,8581,6468,14986,35793,31728,59196,63422,57017,50777,57116,56984,63291,52824,50778,33808,25454,29708,17094,8676,14983,44241,46322,44209,46322,46289,48402,48369,46289,33678,42326,50777,48598,38100,36052,34004,34070,29778,27600,33971,33972,38231,46551,40213,36117,31857,29675,36045,29675,21287,255},
{29880,27799,25718,25686,23605,25654,25686,25686,25653,27766,48763,36249,32024,36153,34072,31992,29911,29911,31992,32024,34105,38265,38265,36185,23638,19413,19348,17169,19250,21363,25555,23442,13040,13041,15120,13007,12975,12942,19280,23472,19181,17069,33808,33808,33677,35757,25226,25258,25258,25226,25194,25226,25226,23146,25226,25226,25226,21229,15018,46287,56820,35918,27630,25581,29710,14791,25420,19016,44176,16968,29548,31757,44338,29645,34033,29678,25549,27500,14758,31628,25516,33904,23371,31855,31887,36016,21129,25419,33935,38291,31822,31920,23242,19049,31693,29678,29581,19049,31791,33838,35887,16872,31726,29775,36049,34065,36049,19017,27468,29775,33872,19049,33840,23177,52627,42194,50579,44241,33775,33743,35887,35855,33775,42193,44240,21227,27533,35920,38034,29582,16970,19083,38066,46519,40278,33841,31532,31695,44308,29419,17063,10853,12901,8676,8612,8613,12839,16970,8453,10632,14857,35856,40081,35824,42097,46387,42195,40114,38033,40081,40081,40114,42226,42192,48533,35918,38031,29644,21290,23340,29648,23370,27502,27503,33834,23302,19078,25382,25383,23239,19077,23239,14821,6467,6435,8451,8548,10628,8547,10628,4387,2371,4387,8614,16905,31632,61277,63389,52824,50842,57083,56951,63356,50744,50810,33809,31825,25451,12870,6563,19177,50515,46354,48434,48434,48402,48370,46289,44209,31532,40180,44405,38099,36020,36052,36052,36052,31891,29745,36052,36052,33972,42391,42357,38165,38198,38197,36019,25388,16935,255},
{29944,27831,25718,25686,23605,25654,25686,25686,25621,27766,48763,36249,32024,36153,34072,32024,29912,29911,31992,32024,34105,36185,38265,36185,23606,19413,19348,19250,19282,19250,25555,21362,13040,13040,13040,15088,12975,19215,38165,31858,25486,25454,40180,31761,37902,35757,23146,23114,25194,25194,23146,23146,23146,23146,23146,23146,23178,23309,8744,39980,54739,35919,27629,23403,29710,21129,29614,23177,31726,25322,25323,31725,33871,31725,29775,33806,29612,33741,23144,35822,27435,31661,29612,33903,40176,40177,31595,31693,38031,38193,35951,36048,35886,27371,35854,35886,37999,31661,42225,35951,40080,33741,42226,40177,44371,42322,42259,35855,29581,46451,46517,42226,44372,42226,52659,61046,58965,54739,56820,58933,56885,56885,56885,48466,52659,42193,46321,44207,33775,31630,19083,23244,42292,48666,38230,33809,37805,31598,33841,31499,27338,25321,12837,8676,6595,8645,17034,14857,2180,14859,21131,35888,42162,40049,40049,44307,42162,40081,42226,44273,37969,42195,42162,42194,29615,19146,42227,29615,23342,25455,27598,21224,25451,29612,33801,25319,21191,33832,25351,16901,10660,10596,12741,10627,14821,14820,12740,8611,8676,10788,4483,2371,6532,8581,14823,25323,29712,59164,52824,52923,57082,56984,63388,48631,48599,23277,23407,25452,17096,10757,12774,25225,33709,44209,48434,48370,48369,46256,42063,27306,31499,31533,35856,38197,38165,38132,38165,36052,33907,31826,27633,27600,29714,40278,35986,29746,36052,27501,10628,8581,255},
{32025,27831,25751,25686,23605,25653,25686,25686,23573,27766,50842,38297,34104,36185,34072,32024,29911,29911,31992,32024,34105,36185,38265,29912,19445,19445,19315,19282,21363,23443,27636,21394,15121,15121,15088,15088,15055,27633,44438,27567,19115,21195,40180,40212,46354,35757,25226,25194,25226,25226,25226,25226,23146,23146,25194,23146,29517,27469,6664,39915,54706,44337,42258,40177,44403,42226,42226,39982,42258,42095,40048,42127,46483,42225,50742,44273,50612,40080,50547,44241,50579,48532,48467,50645,50612,48532,46354,52791,48500,54871,48499,56951,48532,52693,40081,57016,48565,56984,48565,56984,46485,56952,40114,59065,50678,59065,48534,54904,44372,57017,50711,57017,52792,54904,50547,46322,48435,44241,37935,37936,37936,35856,33743,37935,42063,25357,23243,25485,38033,33775,19051,23244,40146,44439,40279,31728,27372,33840,42162,31467,29387,31467,23208,8677,8709,12838,10726,19082,16971,31859,29549,35888,42162,37936,42161,46355,42194,38001,42161,44274,42194,42195,42194,40081,33841,25421,44275,25423,21230,23342,27566,27402,27498,29641,27463,21126,21159,27496,27495,27368,16902,14854,27433,25351,16932,12708,12773,8644,10789,12869,8676,6531,4419,6501,12743,21096,16934,33841,40212,31794,50678,61210,65469,50613,29419,29484,27372,14760,16903,10789,19047,20966,21096,48402,46256,44144,41999,39886,35790,23081,22822,20806,27370,38066,38198,40278,38197,38165,38133,33939,31956,25649,23472,29713,31761,25421,23243,19082,12742,10629,255},
{29977,27831,27799,25718,23605,23605,25686,25686,25653,27767,52890,38297,34105,38233,34072,31992,29911,29911,31992,34072,34105,36185,38265,27831,19413,19413,19282,21330,23443,25524,25523,23442,15121,13041,15088,17201,21230,40147,46519,31761,23373,25421,27567,33808,46386,35757,25226,25194,25226,25226,23146,23146,23146,23146,23146,23146,31630,25324,6599,31562,44208,48468,56919,56952,54871,56952,46485,52693,48566,50613,48566,48533,52759,48533,54872,46453,54839,46485,54839,46453,52759,50679,50678,50711,50614,52759,48598,52791,48598,52791,48598,50711,48566,50647,48566,50678,48566,46518,48631,48630,48599,36019,38164,44405,50744,38228,36083,40147,50679,31793,36083,31825,36114,33905,48467,33775,42194,37936,25356,25357,25421,25421,25356,35887,35822,8520,8648,19243,38033,33775,16970,23244,42162,42260,40311,31663,23146,38066,44210,31499,25225,25226,31532,21096,21193,10725,12806,25389,27503,42424,33743,33743,40081,37968,42193,44307,42162,40081,42129,44274,42227,35857,21131,35855,50646,48500,44275,23342,21229,23375,36050,27499,40080,29610,23271,23270,21190,21190,19046,21159,19014,16934,23240,23239,12740,4323,4419,8676,10757,12869,10789,6563,2306,226,8550,21130,16902,10728,29778,33841,33516,50614,65502,46322,27306,29419,25226,10534,10628,17126,25353,25225,35757,50482,37904,27503,35694,35596,33613,31598,27437,27404,21032,25290,33939,38198,38231,38198,38133,31859,36182,34264,42586,31826,33939,31826,29647,23275,14888,14854,255},
{29944,27831,27799,25718,23605,23573,25686,25686,25654,27766,50810,38297,36185,38265,31992,31992,29879,29911,31992,34104,34137,36185,38265,27831,19413,17299,15089,17170,19282,21363,25555,23442,17201,15121,17169,19249,19215,40147,44341,31728,25454,27567,25422,31695,40016,33677,25259,27339,25291,25259,25259,27307,25258,25291,25291,25291,29582,21131,6599,31530,42129,33840,35985,31760,33807,27436,31792,25389,31760,23276,29679,23341,35953,42324,38099,44405,33840,46485,33711,54872,31792,50646,31825,50678,33775,48566,33873,48533,38098,46485,42324,44405,42260,44372,46517,46485,46486,42293,50711,46550,50679,38099,42389,46550,54937,44534,46550,48598,54937,48631,50776,50744,54937,50711,50547,52660,54773,48434,50579,52660,52660,52660,50580,46321,48466,42128,37934,25321,29613,31663,16970,23309,44341,44373,38230,31630,31533,35922,37904,27274,29386,29354,29419,29452,33710,25419,29549,31663,27437,35988,29550,31662,37968,35790,42194,46355,40114,40081,42161,46354,44307,35889,17167,25456,46421,50581,40114,23342,21229,23374,42325,48533,44210,29579,29609,31688,27463,16932,8515,16997,16933,8515,12708,14853,12708,8547,8612,12837,6563,10756,12901,4483,2306,4419,162,12711,27403,17031,4517,23341,33483,31370,44341,35791,23210,27438,23244,19051,29679,19113,27370,25225,35790,48370,33776,19279,29714,35759,35531,33484,25259,25357,23147,29615,29746,31826,36085,38198,36085,31826,33939,38295,36085,33939,33971,33907,33907,36052,29614,19081,255},
{29944,27831,27799,25718,23605,23573,25686,25686,25654,27766,48763,38329,40378,38265,31992,31992,29879,29911,31992,34104,34105,36185,36217,25751,19380,15122,17136,21327,21262,19149,19116,17036,14955,17003,21065,16904,16872,25192,14792,10631,8518,8518,8551,8518,8518,10598,10631,10598,10598,10598,10631,10598,10631,10599,12744,12679,27470,25390,4518,31562,44209,23373,21325,19212,23374,10566,21325,12777,23406,12842,23405,14986,31759,52791,50711,54872,52759,54872,52759,56985,54872,56953,54905,56985,56985,56985,56985,57017,57017,57017,57017,59065,57017,59065,57017,59065,56985,57017,56985,57017,57017,54904,52792,54905,54840,50678,48630,52824,52759,46486,46582,46583,44534,46485,52627,56853,54740,48369,52659,52660,50580,50548,46354,44241,44273,40014,35853,23241,27371,27405,19019,25390,42162,42260,42261,31630,35726,33809,27340,27306,29386,25193,25193,27402,33742,35921,33743,35888,29550,31630,35855,37969,40081,40048,44241,46355,42194,42194,42161,44275,42195,42195,33841,29649,46453,46387,38001,21262,19181,25455,31691,44241,46225,33643,31690,29576,21093,14788,16933,23240,21094,10628,12741,14853,16934,12740,12837,8643,8675,8611,8708,2273,4451,4451,162,129,14888,38033,21192,8581,27437,39885,31467,19084,8547,10759,19182,31793,23437,19146,27370,25257,44208,48337,27502,19247,23408,27634,31696,42130,48567,48599,42325,36051,33939,31794,29745,33972,34004,38165,40310,40277,36052,36052,36020,33939,31859,38067,25388,14887,255},
{29944,27831,27799,25718,23605,23573,25686,25686,23573,25718,50875,42458,42458,36185,31992,31992,27831,29911,31992,34072,34105,36185,36185,29912,17300,15089,10732,19018,35822,29548,37967,27468,37935,27468,37902,23177,37902,25257,33774,19050,35822,21098,35855,21130,35887,21130,37935,23242,37968,25290,37967,25323,40048,27403,38000,25356,40114,23342,4518,31530,42129,25421,23373,21358,25454,10534,19148,12744,21196,23567,21324,23568,31793,48565,48566,48533,46452,48534,42195,54807,38001,52759,38066,52791,40179,52726,37968,52726,38163,50711,35985,48566,36050,48598,40243,48598,38035,46453,42356,46517,46549,34002,31890,46485,46388,33905,33970,46517,48566,38131,40308,42389,42421,46484,48402,27436,46354,33710,27437,27437,25356,25357,19050,40080,25291,4294,12711,23210,37870,29550,19117,23309,35889,35922,34006,33809,38101,25358,29550,29517,23113,16871,33873,33840,33710,35855,33775,35888,31630,33743,40049,37969,44242,40049,40114,44275,42162,42162,40048,46387,44307,42162,37969,42194,50614,46420,38002,21229,23373,33806,31659,31661,48371,46257,40015,35851,23239,16966,21159,27401,25320,19046,12707,10659,16902,8580,12869,8675,8611,6563,8676,225,4451,2338,226,225,321,19209,33806,33807,35888,25225,33546,25355,8707,2529,25583,38099,10822,8742,21127,27338,42096,44209,23310,19215,21328,21295,25521,44275,50744,44405,36019,36084,36052,33939,29713,29713,36052,33939,40344,48631,38165,36085,33971,33939,38132,27435,16967,12741,255},
{29944,29912,27799,25718,23605,23573,25686,25686,23573,27766,50875,42458,42458,36185,31992,31992,29879,29911,31992,32024,34105,36185,36185,31992,19380,19282,8749,14694,46190,48335,52659,35886,50514,33806,48434,27501,48434,27501,46386,27436,48434,27404,46354,25323,46321,27403,46354,29516,46386,29484,46354,29451,44273,27403,42193,27436,46387,19148,4518,31530,42128,27566,25550,23502,25454,14792,27566,21228,31760,31889,33904,33969,44372,44404,46452,46452,44372,48533,44307,54774,44307,54839,44372,54839,48565,54839,48532,52758,50678,54839,52726,54871,52758,54839,54838,54871,52758,52726,52726,54871,54773,54838,52725,52758,52693,50581,50580,52758,48564,52758,50613,50711,48532,48500,48402,35855,50547,31630,25357,25357,23309,23341,21164,42193,19018,133,16872,29516,33548,21001,16971,25390,37969,33776,31795,33776,42391,40279,40181,29518,29550,27371,19051,25324,35856,37937,33808,37968,33711,35823,40114,37969,42194,42161,44241,44275,42162,42194,40048,44275,42194,42162,42193,46387,46452,44339,33841,21197,31788,58919,40179,31662,35823,42129,48371,39982,31660,35887,29578,25384,23206,19046,16901,14853,10629,12773,12836,12901,8675,8676,10788,4483,8675,6531,2306,289,320,2498,10918,29645,46485,25387,14822,29581,10851,6755,27662,19144,6628,6595,2305,21161,46289,42129,21262,21295,27602,19182,31794,44111,44080,38035,38197,38165,36084,36052,33939,31826,36084,33971,31859,42423,42325,36085,36053,42423,44438,21096,10661,10629,255},
{29977,29912,27831,27767,23605,23573,25686,25686,23573,27766,48827,40378,46618,36153,31992,31992,27831,29911,31992,32024,34105,36185,36185,34105,19413,17202,10830,16807,44077,48303,50546,29581,50514,31726,48466,29581,46321,27436,46386,25356,46386,27403,46354,25323,46321,25323,46354,27403,46386,27403,46321,27371,46354,29419,44274,27371,46386,21228,6566,33610,48434,52725,54839,50645,29581,42063,44176,50547,48467,50547,44274,48467,48532,48434,44176,44241,44306,42128,44306,37935,46355,42194,44241,42194,42161,40114,42193,35887,37935,38000,37967,35952,38032,38162,35919,36050,33839,31856,33839,34002,27468,25420,29614,23340,27534,16970,27533,27663,25453,21325,31824,29776,25485,29710,46289,29517,48435,27469,23244,23276,23244,23277,21131,42193,16873,133,18951,35789,29551,20970,16970,25422,35889,33776,33776,35888,40115,40278,40279,25357,31631,33776,38100,35889,33743,35856,35856,35888,35855,37968,42194,37969,42162,40049,40081,42227,42162,44242,42161,48434,37969,42162,38001,46388,46420,46387,33841,23342,21293,35949,33774,37935,42195,40146,42161,48370,44274,46420,40145,33837,29577,25353,27501,29613,23275,23307,12804,8643,8675,6531,10820,4482,4515,2306,193,4386,2401,4546,2530,8740,27532,42292,29581,25452,15078,15046,12870,8676,6596,6596,290,29613,48337,37904,23440,33972,31859,23375,40017,39755,37642,33547,38133,40278,38197,38165,36084,33939,31793,25455,25455,29713,40277,36051,33972,40343,44406,25420,8548,12742,255},
{29912,27831,27831,27799,23605,23573,25718,25718,23605,29847,50940,40410,48698,36153,31992,31992,27831,29911,29944,34104,36185,36185,36185,34072,21493,17267,12943,14726,44045,48336,50514,27468,50546,31726,48466,31693,46354,27436,46386,25356,46354,25356,46386,25323,46321,25323,46354,27403,46386,25323,48434,25323,46386,25291,46354,25291,44307,21196,4518,19015,29613,29743,31759,29744,21195,14727,18985,25420,21195,23404,23470,19147,25583,23372,23502,21259,25680,21292,19244,25518,12743,23244,14888,25485,10728,19180,21389,23373,14888,21260,19081,19114,25550,25615,21325,25745,27631,27663,25517,27760,19115,14985,25518,27825,23373,10728,25453,27825,25486,15019,27631,27760,25485,29710,48434,37968,50547,40048,42129,42194,42193,44274,40048,46353,35822,25356,35789,44240,31663,10633,16938,27503,35921,35856,35856,35888,37904,35889,38166,25358,25324,29583,27502,33743,33743,33743,37937,37968,37936,37968,42162,38001,37936,37968,42161,44275,42194,42194,42129,44242,40114,33710,37934,48500,48500,42194,33841,25487,25455,27534,33740,42096,42195,42227,40114,42194,50613,50678,54872,35918,27465,29579,31759,44503,35954,27469,19111,8676,12836,4450,6563,4482,6563,193,4454,6372,6564,4578,2562,6659,6659,21355,42324,42259,17063,8741,21323,10790,4483,2338,226,23307,44176,29517,21360,36118,31827,29747,39919,39755,37675,31368,29452,36118,40279,40278,38165,38165,36052,27602,19149,25487,31826,31760,25421,27600,40245,27500,14822,12806,255},
{27831,27831,29879,27799,25654,25653,27766,27767,25654,31959,53053,40378,46618,36185,34072,31992,27831,29911,29944,32024,34137,36185,36185,29911,19445,19380,15023,14727,41997,50448,52594,29613,50514,31693,50514,33741,48402,27436,46386,27436,46386,25355,46353,25323,46354,25323,46353,27371,46386,25323,48467,25323,48434,25291,46354,25291,46387,21229,4518,6566,17163,17261,17164,21454,16905,4293,16937,17162,14986,19244,23503,17066,21422,21292,23599,21260,21390,19147,19244,25518,19146,23340,19243,27696,17033,23405,21325,27664,19114,25519,21259,25518,23340,17035,21195,25551,25388,23373,25421,21292,21195,21292,23341,21292,23340,14889,19114,21293,23341,17035,23341,21293,23276,25356,52660,50547,52627,44209,46354,44242,44209,40048,29484,29484,27371,25323,29645,35951,35790,18986,16938,27535,31631,25324,35856,35889,37936,37969,40148,29649,23178,33710,29518,29550,27469,33776,35889,42129,42128,37903,42162,38001,42129,42161,40081,44275,42162,42227,40047,44241,38001,25390,31662,46387,44307,46452,29648,23374,27568,29614,35789,44177,42195,40179,40147,38034,46485,52791,50678,37902,31660,27498,27531,40407,46649,29582,25420,12805,12869,8676,6595,4419,2338,4486,25587,14793,4292,14983,8804,10853,4579,2498,15080,38195,44437,25516,17096,12934,4515,290,162,27500,46224,25325,23375,21327,23440,29714,39821,42064,39951,29223,27404,29713,36085,38198,38198,33907,36085,40312,29780,25455,31859,33971,33906,29615,27469,23242,12741,10661,255},
{29912,29912,29912,29879,25686,25686,27766,27799,27767,38232,55165,42458,48698,38233,34072,34072,29879,29911,29944,32024,36185,36153,36185,27799,19445,19348,12976,14727,44077,50481,52594,29581,50514,33806,50514,31661,48434,29549,46353,25388,48434,25356,48402,25323,48402,25323,46354,25323,48434,25291,48434,25323,48466,25291,46386,25323,44306,21229,4518,10759,19276,21422,21422,19147,21131,10663,21228,12776,21260,14824,21228,17034,21325,16969,17034,19050,12712,21163,19212,23341,10631,23309,12808,25454,14857,25421,16969,23374,14857,21260,14857,21228,14792,16938,16905,19083,16969,21196,23340,25518,19050,21131,23373,23438,21163,14889,16970,17035,21195,17003,21228,19114,23405,33871,39983,27469,46322,23276,23244,23309,23244,16971,133,165,133,165,13035,29711,42064,23146,14858,31663,29519,16971,33775,37937,35888,37968,37968,29648,21163,33743,29550,29550,31663,31695,35889,40114,42128,37935,40081,38001,40049,40081,42162,44307,42162,42194,40048,40081,29584,27602,29747,40147,44242,40113,27502,21229,25455,29614,33708,44209,42227,40115,40147,40147,42259,48566,52759,44177,37902,29579,25385,25450,31856,29582,29583,19145,12836,4450,2306,4453,8647,14923,23310,10633,4324,12870,12902,4516,2338,2433,2562,13031,36115,50745,44437,27564,10790,4453,260,21325,42064,29550,27601,29746,23440,27601,44145,44242,44210,37904,33906,29713,29713,33972,38166,36085,33971,38165,38231,36020,36052,36020,33939,33939,31728,21129,16967,16967,255},
{29911,31992,31992,29911,27798,25686,27799,27831,29944,40377,57277,42458,48698,36185,34104,34072,29911,29911,31992,32024,36217,36185,36185,25686,19445,17267,12976,12647,44077,50481,52594,27500,50514,35918,50514,29581,48434,27468,46321,25356,46354,25355,48401,25323,48402,25323,48402,25323,48434,25323,48402,25291,48467,25291,48467,23275,44274,21229,4518,12839,19276,23567,19277,8519,19051,8486,19083,8550,19115,10598,16970,19146,25551,12775,16936,14792,10631,19114,19179,21260,6469,21163,8647,23341,8615,21163,12808,21228,10727,19148,10760,17035,10695,17035,12743,14857,10695,19083,21227,23405,12776,14857,23372,27695,16937,14824,14856,17067,19146,17002,19115,23308,23340,38000,40016,33775,44274,29582,31662,31695,31695,29550,16905,14857,10696,10696,29646,40145,37806,25066,19085,31696,37969,27470,35823,37969,35857,35856,37936,35856,35823,35824,27502,31695,29583,31663,33808,42162,42096,37935,38001,38001,40049,44242,42161,44275,40081,40081,44241,40081,25488,29780,23244,48630,50646,38000,25390,19149,23310,29646,35789,46290,42195,40147,40147,40146,42227,42259,44307,46355,48371,35822,21224,21256,19175,25451,31695,27535,25453,17033,14921,19148,21229,21197,21164,19116,17164,15050,8645,4484,6597,385,2530,6755,10949,29840,46583,29677,8646,2373,228,10821,25452,19149,21295,21295,19247,31794,48664,52857,48631,40213,36052,33971,31826,29713,31859,33972,36085,42423,42326,38165,36084,36052,33939,36084,40180,27468,19113,21161,255},
{29944,34105,34072,31992,29879,25654,27766,27831,29912,40377,57245,40378,50778,38265,34105,34072,29911,29911,31992,34104,36185,36185,31992,23573,21493,17332,12976,12647,44143,48434,50514,27468,50514,38031,48434,27500,48434,27500,46321,25388,48402,25356,48434,27404,48401,25323,48402,25356,48402,25323,48401,25323,48434,23243,46386,23275,44306,21294,4518,8613,17098,19308,14986,4324,14857,4292,16937,8549,17001,6534,14857,17065,23437,12678,14856,16969,10663,19082,19211,21259,17001,25388,17066,25453,19049,21196,21227,27501,23340,29647,25420,27534,27533,31727,29581,27534,27468,33840,31694,35953,31662,33872,31694,35920,29582,33775,27501,38033,31662,38034,37903,40179,29582,44208,54773,54773,50547,50579,54805,54773,54773,52725,44241,48433,46385,44240,46321,46353,35532,18793,12843,33808,35856,37870,37903,37937,35889,37969,42195,37936,40015,40016,33710,31630,23307,31728,33808,35888,37936,40048,40081,40049,42129,40049,40081,42195,38001,40080,42129,42162,38002,38166,27437,48598,50613,38033,23342,19149,21261,31694,40047,44242,40081,40147,40147,40114,42227,42259,42227,40081,48404,48371,29546,21256,23337,21256,33804,31695,31728,31696,29616,25390,23277,23277,23277,23277,21262,19213,14952,17066,27631,19210,4611,4674,8867,8868,23467,31823,17033,2339,4451,6594,17130,21295,23407,19150,19215,33841,46421,46420,38099,38132,36084,38132,36020,31826,31826,36052,31859,42424,44438,36052,38165,36052,38164,44438,42325,33874,31727,23274,255},
{34105,36185,34072,34072,31960,25686,25686,27799,27767,42458,57277,42458,52858,38265,34105,34072,29911,29911,31992,34105,36217,36153,27766,23541,21493,19413,13008,12647,46288,54805,50514,27500,48401,37999,48434,31661,48434,25388,46321,25356,48434,25356,48402,27404,48401,27403,46321,25323,46321,23275,46354,25323,48434,25291,46354,23211,46354,25486,4518,21129,29614,31726,33775,29614,27501,25324,27436,27436,29582,27501,29582,29549,33840,27404,33840,27469,35888,29549,38001,29549,42226,35921,42194,38033,42162,35921,42161,31662,40081,33841,40049,25421,35887,25389,35855,31728,31694,27470,27469,29648,25356,33873,25454,31728,19051,27437,14857,35920,19115,35986,25193,31728,23211,42128,50547,50515,46289,46322,46354,48467,48467,48434,44176,46288,42128,33742,35854,40081,37905,25228,25227,33743,35823,35823,39983,37936,37969,37937,42163,37969,37936,37903,31596,29549,16904,29582,35857,33808,35823,40081,40082,38001,35856,33710,37936,42195,37936,35887,46354,40081,42162,35889,35888,50548,48467,40114,23310,21197,23374,31661,44177,46323,40146,38066,40115,42227,42259,44340,44340,42227,38033,40080,48403,33708,25385,31660,35884,27529,27534,27503,29615,29615,25357,23309,23309,25390,25390,25390,27502,31760,31728,33841,27597,8804,8835,10916,12933,15111,21322,21191,16933,12870,21325,23408,23375,23408,25520,37838,39755,35562,33775,38165,38133,38132,36052,33939,31858,36052,33907,31859,42423,40212,36085,38198,42423,44437,42357,38100,31695,23242,255},
{36153,36185,34105,36153,34072,27766,25686,27799,25686,40377,57277,40378,50746,38265,34105,34072,29911,29911,29912,34104,38265,34105,23606,23573,21493,19478,17202,12647,46191,54772,52594,33806,50482,37999,48401,33838,48434,27469,46321,27501,46321,25356,46321,25356,46353,27404,46321,25356,46353,25356,46322,25356,46321,25324,46321,23275,46354,25486,8711,23243,46355,27502,46419,27502,33807,23308,23276,23276,35953,25486,25356,19018,35921,19051,31727,16970,33808,21098,40081,25389,42161,31728,44274,33840,44274,31695,44274,29582,42161,29582,40048,25356,35887,23308,35855,29647,33774,29582,29582,29647,25389,33840,25324,33808,21196,33775,19083,38001,19083,37968,27403,29549,27404,25291,19017,16936,14857,21131,16905,25324,29615,35822,31564,29418,25259,12745,17003,33841,38001,27274,23080,31631,33711,35856,40048,42096,35888,35856,35857,35857,37936,33743,23274,33807,21130,21131,33776,35889,33776,35888,40082,42162,27405,16938,29517,42194,40049,37968,42161,40082,42162,40081,40081,50613,50580,38034,23309,21197,25455,38000,46290,46355,40179,38066,38034,40179,42260,44340,42259,42259,38001,21191,37935,46290,31595,25321,29482,21127,21192,31694,29583,31728,29583,25390,25390,25390,27503,27535,29616,31728,33808,29681,33971,27565,10917,8836,10884,4674,10916,25548,27368,12771,12905,23407,19181,25488,29713,39820,39755,35529,29288,31793,38198,38165,38132,36084,33971,29713,23342,23342,29745,40212,31792,33972,44504,44437,40245,31825,29582,23274,255},
{36185,36185,36152,36185,36153,27766,25686,27799,25718,40377,55197,38298,52826,38265,34105,34072,29911,29911,29911,34104,38265,34072,23573,23573,21493,21526,15219,12679,44110,52562,52594,35950,48434,40144,48401,33838,48401,31693,46289,29549,46321,27436,46288,25356,46321,27436,46321,27468,46288,27404,46289,25356,46289,25356,44241,25356,44274,25421,23371,23243,44242,25388,44306,25421,38000,23308,33807,21228,38033,25421,35888,23243,40081,19115,40114,19115,40114,21195,42194,21196,42193,23244,44274,23276,42193,23211,42193,21195,42161,21162,40080,23243,40048,23243,37936,27436,35855,27436,33775,27469,31662,29582,29549,31694,25388,33807,23276,33807,19083,35855,18952,14792,23373,19148,14890,14921,8551,10664,19148,16970,25389,33808,27437,25225,27370,23211,10697,25422,35889,23179,18954,27503,31630,33743,35855,40048,37936,35856,35889,35889,35856,33776,35856,38000,31694,25324,25324,33775,33743,33775,35921,40081,29485,25323,35888,40114,37936,40016,44274,37969,42195,37969,44274,50645,48532,35921,21229,21197,25455,46387,46322,44275,40147,40114,35953,40147,42260,44308,42227,42227,38000,21223,19175,37967,50484,39983,33739,29546,27466,33739,31726,31696,31696,29583,27470,25422,25422,27503,29616,31696,31696,36085,42489,40310,31759,17159,10916,10883,8771,6691,17094,19045,8548,17035,21261,21262,31728,41868,39722,33416,27142,25291,33972,38198,40278,38197,38132,38198,31827,21261,27567,31826,31728,25388,29745,44470,42292,38066,29614,23275,255},
{36185,34104,36152,40345,38265,29879,25686,27799,27767,40345,55197,38298,54906,38265,34105,34072,29943,29911,29943,34072,36185,31992,23573,23573,21525,19445,17300,12647,44110,52562,52594,33838,48401,40111,48433,31758,46320,29613,46321,27501,46288,27436,46289,27436,46256,27436,46289,27468,44208,27468,44208,27404,44208,27436,44241,25421,42161,27436,42161,27437,42129,25389,42194,25453,42194,25421,42161,25388,42193,25356,42194,25356,42161,23308,42194,23309,42194,21228,42226,21196,42194,21163,42194,21195,42161,21098,42194,21163,42193,21163,42193,21163,42161,21163,40048,23243,38000,25324,37968,25388,35855,27436,31694,29549,29581,29614,27437,31662,23276,33774,21065,10664,27599,21229,19117,14923,14923,12745,14824,14792,23275,33776,27404,23146,27337,29517,16938,23309,35922,21197,25002,31597,31630,31663,33743,37936,42096,35856,37936,37937,35857,33744,37969,40048,31695,33841,25357,27437,33775,33743,33776,40049,37903,35855,38001,40114,37968,37936,40081,40082,44307,40049,42194,48500,46387,33841,21197,21197,27535,46419,50548,42226,40147,40114,38001,40147,42259,42259,42195,40146,33805,23336,25449,25417,35886,52564,42127,31692,31660,27465,38031,46421,35921,33809,25389,27535,27503,27503,29583,31696,31664,29680,42423,42651,42292,27500,23400,10819,8675,12901,6626,8675,14822,6435,6436,14953,31661,35561,33514,29321,25259,29681,29680,31826,38165,38197,31826,38165,40311,31827,27600,36019,33971,33906,29615,29647,25357,19018,12711,14855,255},
{36185,34072,31959,40345,38297,31959,27734,27799,27767,40377,55197,36250,54938,38265,34105,34072,29911,29911,29944,32024,34105,34072,23605,23573,21525,19445,17300,10600,44110,52594,52594,33838,46320,35918,48401,31725,46288,29581,46256,27468,44208,27468,46289,29517,44176,27468,44208,27468,44176,27501,42128,27436,44176,27469,42128,27469,42129,29549,40048,29517,40016,27502,40113,27501,40080,27469,40048,27469,40081,25389,40049,25356,40048,25356,40081,23373,40081,23308,40113,23276,40081,21195,40081,21195,42161,21195,42194,21163,42161,19115,42161,19115,40113,19083,40081,21163,40081,21163,40048,21163,37968,23243,35855,25356,31662,25356,29550,27469,27469,29581,25291,8519,25454,23374,29681,29746,38100,31761,18920,16839,14791,31728,38068,29583,25225,31564,27437,23310,29583,27405,25033,29387,40049,31630,31598,35856,37870,39983,37936,37937,35857,33744,37968,37968,42260,50712,48599,48599,42260,29549,31695,33743,29581,35887,40081,42162,37969,42128,44242,38001,42227,40049,48499,46387,44275,31728,21229,19181,27534,37967,48435,42194,38033,35921,35921,40114,42227,42259,40114,40081,27531,19207,27498,29546,23337,37966,50516,44209,37901,27401,31724,50678,46486,50810,35954,25389,29615,27535,29583,29583,29616,29615,27535,40245,33906,25482,17029,10755,6530,8643,4514,288,8675,14886,6435,162,8614,44437,48631,46551,38100,33939,31794,29680,31793,33972,38133,36084,40246,40246,36084,36084,36019,31858,33971,38132,33873,29647,23307,14854,255},
{36185,34072,29879,40313,40377,31959,27766,27831,27799,40345,55165,36249,50746,38265,36153,32024,29911,29911,31992,31992,34105,34105,25686,23573,21493,19445,17332,8552,44110,52594,52594,29645,46288,31758,46321,29581,44208,29581,44176,25388,44176,27468,44208,27469,44176,27500,44176,29516,42127,27534,42095,29516,42063,29549,40015,27501,40048,29582,37935,29581,37903,27566,38000,29582,37967,29582,37968,29582,37968,29582,37935,27501,37936,25453,35920,25421,37968,25389,38033,25389,37968,23308,38000,23276,37968,21195,40081,21195,40048,21163,40081,21195,40081,19115,40113,21130,40081,21131,40081,19082,40049,19083,38000,21163,33775,23211,33775,23244,29582,25388,31629,14824,23276,23309,29714,29714,36020,40212,33776,23178,21033,25357,40213,31695,23178,33742,35791,27535,27373,16711,18791,16678,37871,35888,29583,33743,33710,39983,40016,37936,35888,33744,33774,29580,50548,50646,46486,50712,35889,16937,29550,29582,33710,37870,42194,40049,40082,37903,37936,35889,38033,35855,46387,46355,46355,29615,21229,21229,27534,33772,44274,42227,40146,38001,40114,40114,35856,29517,33775,35887,25384,17094,23304,31627,29611,23336,29643,44274,44306,31659,29612,48598,48598,57149,40182,33842,25422,31696,27535,27503,29583,29615,29616,29615,29647,21321,12835,8675,10819,10787,10787,6626,4546,4513,10756,23177,19149,42357,44372,38066,36019,36052,33939,31826,29648,29713,31826,36117,46583,38164,38165,36084,36052,33939,40278,42324,29613,23274,16934,10660,255},
{38265,34072,29879,40281,42425,31959,27766,27831,27831,42425,53117,36217,46618,38265,36153,34072,29911,29911,31992,31992,34104,34105,27799,21525,21525,19445,17332,8552,44078,54674,52626,31693,46288,33838,46288,31661,44176,29613,42095,27468,44175,29549,44176,29549,42063,29549,42095,29581,42063,31661,42063,31629,39983,31630,37902,29614,37936,31662,37903,29614,35822,31727,35920,31727,35855,29614,35855,31695,35822,27534,33775,29582,33774,27534,33775,29614,33775,27501,35887,25454,35855,25421,35888,25388,35855,23276,37968,23276,38000,23243,37968,21227,37968,19115,40113,21163,40080,21131,40081,19050,40081,19050,40048,19083,38001,19018,35855,19083,33775,21130,35822,16905,21130,23310,29714,29714,29682,38100,44340,31597,42259,21164,33776,40081,27436,27436,35790,29615,27405,27309,18792,14598,31564,31598,29518,31663,33710,37968,44241,40016,37969,38035,27501,17001,52563,50548,42260,48566,40115,38034,31630,29517,31630,31629,42194,38001,33841,33677,35823,35889,37969,35855,50581,44274,46355,27503,21197,21229,29647,40112,46322,44308,42227,38001,40146,40114,19019,68,4325,25355,23303,14981,19143,27498,27498,27530,21288,25450,46550,46451,35919,52791,48501,46452,21196,36117,25389,31696,31696,29583,27535,29583,29616,31696,29677,19174,10756,14948,19205,14979,6593,2368,6658,15108,15075,19141,16903,14856,14825,31826,38132,36084,36052,33939,29746,31826,33906,29746,42391,40212,33971,38165,36084,40278,44405,38131,29647,21128,16934,14886,255},
{40345,34072,31927,38200,42425,34039,27766,27831,29911,44538,51005,36185,52858,38265,34105,34072,29911,29911,31992,31992,34072,34105,29944,23573,21493,21493,17332,8552,44045,54641,52626,31693,46321,35919,44208,29581,44208,31694,42127,27500,42095,29581,42095,29581,42063,29581,42063,31661,39983,31662,37902,31662,37870,31662,35790,31662,35822,33742,35822,31695,33710,33840,35920,33840,33774,33807,33742,31727,31694,31695,31662,31694,31662,31695,29582,29646,31662,29614,31727,29614,31694,27534,33775,27501,33775,25389,33775,25421,35887,25388,35855,25388,35887,23308,37968,23243,38000,21163,38000,21131,40048,19082,40048,19050,40081,19050,37968,19050,35855,19018,35822,6438,12744,19084,29746,29746,29714,31826,38066,31629,37968,23276,21131,42227,42161,29484,31694,31793,27405,27408,16744,16646,29517,10535,25389,31663,31630,33874,37968,39983,37936,40213,25454,19050,46322,50548,48598,52760,50744,50712,38001,35856,33776,35888,37969,37969,31860,25587,29550,38001,40082,37936,50645,46419,42194,25422,19149,21229,31727,42193,46322,31726,38001,38033,33807,29614,21165,10568,8291,14661,21127,21190,23271,27434,23272,25385,23368,21256,27533,48566,50678,52759,48500,33708,31660,33840,27500,31696,31696,31696,29615,27535,27535,29648,29645,19176,19144,12900,15044,10818,4481,2336,12963,21381,17187,15074,10820,16968,21032,17034,33939,38165,38132,36084,33907,36117,44537,31793,29681,40245,35986,33971,38230,44471,44404,40180,33873,21161,16999,12806,255},
{40345,34072,31959,40280,42425,34039,27766,29879,32024,42489,48924,38265,52858,38265,36153,32024,29911,29911,31992,31992,34072,34104,32024,23606,21493,21525,17365,8552,41965,52562,52594,35918,44208,40143,46320,35919,42128,31726,40015,29613,40015,29613,39950,29581,39982,31662,39982,33742,39983,33774,37869,33742,35789,35822,35757,33742,33677,33742,33710,33807,31597,35888,33775,35921,31694,35920,31630,33807,31629,33807,29517,33775,29549,33840,29614,33808,29582,33807,31662,31727,29614,31727,31662,31694,31695,31695,31695,29614,31727,29614,33807,29582,33807,27501,33807,25356,35887,25356,35887,23243,37968,21163,37968,21131,38000,19018,37968,16969,37935,16937,37968,12678,12712,19149,29746,29747,29746,29714,29648,19116,10632,21196,14858,31695,44307,37870,35822,35986,27372,25424,14631,16678,31629,8551,23343,29550,31630,31794,29550,37870,40016,31728,27469,29583,46290,46355,50679,52792,50744,48631,37936,42130,33776,33808,35889,35856,37936,31925,27471,38001,38001,40080,46420,42259,44339,25390,21197,23310,31726,35852,31660,17032,31726,33839,19112,21259,25389,35465,41576,39624,23174,23207,27401,31628,23175,21191,19174,21256,27534,29582,48565,54839,46386,31692,31659,33771,37964,33806,35954,31696,31696,29616,29583,29615,29648,29679,23369,15044,23462,17123,4481,6529,17156,23493,19300,12962,6657,4546,19048,16935,14954,31826,38165,38132,36052,33939,38166,23310,21261,29713,33873,27534,31826,44438,42292,33873,23242,16934,19015,19016,255},
{40313,34040,34007,42393,42425,34039,27766,27831,34137,44570,48892,40345,54938,38265,34104,31992,29911,29911,31992,31992,34072,34104,32024,23605,21493,21493,17365,8552,39983,54741,52626,35918,44176,38031,46320,35951,42095,31726,42063,31662,37902,29581,37902,31662,37902,31694,37870,33774,37870,35855,35822,35854,33709,35855,33676,35855,29549,35855,31597,35888,29516,35920,29614,35953,29581,35920,29517,35920,27436,35920,25388,35888,27436,35920,25356,35888,25388,33840,27501,33840,25388,33840,27437,33743,27469,33808,27469,31662,29582,29614,29582,31695,29614,29582,29582,27469,33742,27468,33775,25324,35855,23243,35855,21163,35855,19018,37936,19050,35887,16937,37967,14759,12679,25455,31827,25488,25488,29747,29682,25520,19084,23276,27502,16906,40114,42128,40015,42194,27372,25359,14631,14597,10629,10694,14890,21130,29550,29615,31598,37903,40015,29582,27500,37936,50482,44275,44372,44372,46389,42260,29517,33710,31630,33743,33809,33776,31564,35823,35856,38001,40081,33776,48533,33808,38034,23342,21197,23342,27531,21191,21192,19145,23306,21225,19081,25453,21357,25453,35465,41640,29319,18949,16901,18982,14789,21191,17062,19176,29582,29583,38033,54839,50678,35918,33707,31627,44238,40109,50679,40147,31696,31728,31696,29616,29616,29646,19173,21381,21380,10849,12963,15044,21382,17220,15076,8770,8802,12931,14885,12741,8580,14952,31825,38165,36051,33939,38231,29746,23407,25519,31793,29679,23340,31826,40179,31694,18982,14821,10629,14856,255},
{36152,31959,31959,42393,42425,34039,27766,27799,32057,44603,46812,40345,57018,38265,34104,31992,29911,29911,31992,31992,34072,34072,31992,23605,21525,21525,17365,8552,39983,52660,52626,38031,44208,38031,44175,35919,42095,33774,39983,31694,37902,31694,37902,31694,37870,33775,37838,35855,35757,33775,33709,37935,33676,37968,31564,35887,29548,38000,29516,37968,29484,38033,27501,38033,27436,38033,27436,38033,25356,38001,23276,38000,25356,38033,23243,38001,23308,38001,25388,38001,23308,38001,23308,35888,25356,35888,23308,33807,25421,33775,25421,33775,25388,31695,27469,31662,29581,31662,29582,29549,31694,27469,31694,25356,35855,25324,35855,21163,33774,21098,33742,27404,25291,27503,31827,29647,25487,29746,31860,31761,23276,29680,38001,12778,21131,37968,40016,33711,27340,25359,14566,12517,8580,6532,8615,16904,29549,29517,31663,35791,35954,35955,25421,35822,52595,48533,48566,48501,46453,44307,37903,35855,31694,31630,27437,27470,25324,40016,40049,40114,46321,42160,48501,33808,35954,23310,21229,23374,27531,17030,14918,14951,21257,14951,17032,21259,23405,23438,27533,33417,41673,35463,23013,14724,12741,8677,6564,12839,27502,29615,27502,42226,46420,50646,42192,40013,40045,48431,50710,52792,42228,31728,31728,31696,29649,29645,21350,21381,19236,10817,15011,17156,12963,10882,12931,12963,12963,12900,14885,23333,8611,19142,25448,25487,33971,33939,38165,38231,29714,31826,33971,33906,33873,27501,23242,19047,14853,12708,6435,6469,255},
{34072,31959,31927,40313,42393,34039,27766,27799,32057,44603,46812,42425,54970,38265,34072,31992,29911,29911,31992,31992,34072,34072,29879,23573,23573,21525,19380,10698,39984,50548,52595,42224,46288,40144,44208,35951,42095,33774,39983,31694,37902,33774,35789,31694,35790,35855,33709,35855,33677,35855,33677,37968,31564,37968,29484,37968,27436,40048,29484,38001,27403,38000,27468,40114,25356,40113,23211,40113,25356,40081,21195,40081,21195,40113,23243,40081,21227,40113,23308,40113,21195,38001,21228,38001,23276,40081,23276,38001,23308,37968,23308,37968,25356,38000,25356,33775,27468,35887,27468,33742,29549,31630,29549,29517,29581,27404,31662,23243,31662,21098,6373,10631,10566,25422,31827,29746,29681,29746,29681,27568,23244,38068,40115,29682,14858,42194,46322,37936,27308,25359,14533,12517,12806,4451,14888,16872,29516,29517,31663,31663,46683,48763,27599,33710,52595,52727,52792,50711,48664,46486,37902,42128,42129,46355,38001,33776,31695,33776,37969,42227,46321,48401,50581,33808,35922,21261,21229,23374,33871,21224,19144,12870,12870,17031,16999,21292,23438,25550,25551,25421,33384,45801,43721,31304,23112,16935,12772,16968,25389,29583,27502,27470,25421,42227,54904,42191,35883,42190,50711,52825,52825,42227,19018,16970,29646,27625,25573,19236,15010,10849,15042,17187,8769,10915,15075,15108,10849,8642,19142,33926,21251,21254,29670,19142,23406,33939,38164,38132,38164,38164,36052,33939,33906,31727,21095,19015,16934,12741,12741,14854,255},
{31992,29911,31927,40281,40313,36120,27766,27831,34169,44603,48860,44505,57018,38232,34072,31992,31959,29911,31992,31992,34072,34072,25686,23573,23573,21526,17332,17202,21362,27570,48434,46416,48433,40144,44240,37999,42128,33807,40015,33807,39982,35887,37870,35887,33677,35855,33709,35888,31596,37967,31596,40048,29484,40048,27403,40081,25355,42161,27404,40113,27436,40113,25323,42161,25323,42161,23243,42194,23276,42162,21163,42161,21163,42193,21162,40081,21163,42194,21163,42162,21131,40081,21131,42161,21131,42161,21131,42162,21163,42161,21131,40049,21163,40081,21163,37968,23275,37968,23243,35855,25323,35823,25324,33710,25356,31597,27437,27469,27469,25323,4293,8518,10566,25455,33940,25554,27634,31795,29714,29648,23276,21164,17070,31828,12778,31695,48533,38001,23082,20970,12485,12517,4355,6403,12741,16871,25258,29484,31630,31663,48796,44570,38263,35986,42195,50679,52792,50711,48664,46486,27437,37902,44241,42194,44275,35888,27469,29550,31728,35987,42423,50513,48468,33809,33841,21229,21229,19177,21256,21224,25517,12838,10693,10693,21194,29679,25550,23438,23405,21324,27306,45801,45801,43753,31239,31500,23304,23274,27437,29550,29582,27534,27502,29615,42259,54904,44369,40143,50711,54905,54904,44304,16938,6535,23399,23460,21316,15043,15010,15074,17155,15075,8706,8771,15044,15108,12963,4483,23398,36005,25507,17059,21252,12898,21292,27568,31858,38098,27599,36052,38132,36052,38164,33807,16935,14822,14821,8548,10693,12773,255},
{34072,29911,29879,38200,40280,36119,27798,29911,34169,46715,50908,46617,55002,38232,36152,31992,31959,31992,31992,31992,34105,34105,27767,23573,23606,21526,17300,15121,19282,23376,48369,48497,46320,42224,42128,40079,40047,38000,39983,38000,37934,38000,35822,37968,33677,35887,33677,38000,31596,40048,31596,42161,29451,42193,27371,42193,25355,44241,27403,42226,27404,42226,23243,42194,23210,42193,21098,42226,19050,42194,19082,42194,19082,42194,19018,42193,19050,42161,19050,42194,19050,42194,19083,42194,19050,42161,19050,42162,19083,42194,19051,42161,21163,42161,21163,40081,21163,42129,21131,40016,23211,37968,23211,37903,23211,35823,23244,33743,23276,33710,12646,14727,16807,23212,25422,27568,29648,29616,29616,27470,23276,21196,19116,29682,14890,21164,44340,37969,23147,23115,27405,14822,12740,12677,14821,12774,19017,27371,29549,31663,48797,42457,40279,36085,33842,50679,52759,50711,48664,44438,14891,25357,44241,42194,42162,40016,35856,33744,31663,29615,33874,35920,27534,33808,31761,21228,19178,19176,17063,17063,17064,8644,10693,12775,19114,29712,29743,23405,21225,12837,16805,20836,25061,18821,14693,27370,23272,23242,27469,29615,29582,29615,29615,31696,29615,40114,56985,46484,48631,54938,52758,37998,25453,19246,21287,21382,23429,17155,15043,19204,15043,12931,6530,2337,2465,8771,8772,6627,29734,29701,21315,17122,8673,6594,25485,27535,19148,29646,27496,25418,31858,38197,42324,33807,12709,12741,14854,10628,10628,14887,255},
{34072,31959,29879,34007,38232,36120,29846,29911,32089,46715,48860,42425,52858,38264,36152,31991,29911,31992,31992,31992,34105,34105,29879,23573,23606,21558,19445,13074,19282,27536,46288,46384,46288,44337,42127,40112,40047,37999,37902,38000,37902,38000,33741,37968,31597,38000,31564,40081,29484,42161,29483,42161,27403,44274,25323,42193,23243,44274,25291,44274,25291,42226,23243,44274,21195,44274,21163,44306,21163,44306,19051,44242,21163,42193,21131,42194,21163,44242,21195,44274,21163,42194,21163,42194,21163,42162,21195,42194,19147,44274,21163,42161,21163,44242,21163,42161,21130,42194,19050,42128,21130,42129,21098,40049,21098,37968,21130,35888,21196,40048,16775,18920,21065,23178,25356,25389,25357,25389,27502,25356,23276,21164,21196,21263,17101,23310,35921,38002,23244,27437,37970,27500,14950,8612,8612,6564,19080,23178,29484,31728,48829,42424,33972,29648,33841,50679,50711,50679,50712,46486,16971,27437,39983,44208,37903,33710,29484,27372,25358,19084,21164,25454,15019,31728,31728,21260,19145,19144,19143,17063,12837,12837,14886,14855,21195,27566,25483,21224,14885,8612,8580,10692,8547,4451,6499,10628,16902,23275,27469,33775,33775,27469,29615,29615,31728,29615,35952,52792,50679,54937,46418,29642,40110,29548,16936,29707,25511,19237,21317,15042,12930,10819,10787,289,2402,6566,10660,10691,31815,23396,19268,19203,19139,23396,27524,25445,23334,29639,33798,27523,19141,31791,40113,31660,16901,12773,10628,10660,12709,12741,255},
{34040,31927,29847,31927,38200,36120,29846,29911,34169,44602,46779,38264,50778,38232,36152,31992,29911,31992,31992,31959,34072,34105,29912,23606,23606,21558,21558,13139,17234,21231,46255,44272,44208,42192,42095,40112,40015,38000,37902,40080,35822,38033,33709,40080,31564,40048,29484,40081,29484,42193,29451,44274,25323,46354,25291,44241,23178,46354,25258,44306,23210,44274,21163,44274,23243,44306,21163,44274,21163,44274,19083,44241,21163,42194,21163,42162,21163,44242,21228,44274,21195,42161,21195,42194,21196,42162,21196,42194,21195,42194,21163,42194,21163,42194,21163,42161,21163,42194,21163,42161,21163,42161,21099,42161,19050,40081,19050,40049,14792,27404,27306,25226,27306,27338,23211,25389,27502,27470,29648,27502,25390,21132,25423,25489,8552,14826,25422,38002,21164,23244,33808,25322,17000,10725,6499,2338,10694,21098,25291,33841,48796,36117,29648,37838,42161,50679,50679,50646,48632,44373,31630,33743,37968,40080,42129,42162,37936,37968,27504,21329,23310,33874,31759,31727,29615,21229,23341,19175,17062,17030,14982,10692,8612,14918,21195,23340,19175,16997,14916,8644,4418,6531,4450,10724,8644,4418,10628,23243,25357,31663,33775,29582,25389,27470,29583,31728,27502,40147,52760,52791,37932,31723,37997,35916,27498,31759,33870,23495,19236,17157,17124,10819,2401,4483,4483,8581,10564,21127,19110,19139,8673,14980,27557,31781,35909,31715,29635,31748,23331,23299,21218,27493,33800,31688,25348,12740,8548,6402,10628,12708,255},
{34040,29847,29846,31927,38200,36119,27798,29911,36217,40442,44667,38264,52858,38232,36152,31992,29911,31992,31992,29912,34072,34073,29879,23638,23639,21558,21559,15219,21395,21329,46289,46384,44208,42224,40047,40112,40015,40080,35822,38032,33709,38000,31628,40081,29516,40081,27436,42194,27403,42193,25323,44274,25291,46354,23210,44273,23210,46419,23210,46354,23210,46354,21131,44274,21227,44274,21195,44274,21196,44274,21163,42161,21195,42194,21163,42161,21228,42162,21163,42161,21196,42161,21196,42129,23243,42129,21228,40081,21163,40048,21163,42161,21195,42129,23211,42129,23276,42162,23243,42194,23243,42194,21163,42161,21131,42194,19083,42194,10566,6405,16838,16839,18951,21032,18985,21228,29647,27503,31729,29582,29386,19083,25455,21263,8584,19083,29647,35922,21196,19116,29614,16999,16999,8612,8644,10692,8613,23242,23177,33874,46715,19212,27632,33743,44274,50711,50679,50679,50744,46453,33775,37968,40049,37968,33774,42161,37968,40114,40114,33808,31729,40213,42325,35953,27503,21229,23340,21256,23337,23337,12805,8549,10726,12870,19111,21256,17062,12836,17061,10724,6498,4418,8644,10756,4450,6531,8483,21162,29549,27469,29582,33840,31695,23276,23308,31728,31728,33841,46518,54904,48532,31659,31659,33804,35885,35949,38030,29708,21352,12964,12932,8770,6658,8706,8769,4544,6595,27654,21220,14887,19241,29734,33860,38054,35877,25379,21218,23330,25444,29604,25379,25378,31718,31750,25412,10657,6467,8548,8548,10628,255},
{34040,29847,29846,34007,38200,36119,27766,32024,38362,40442,44667,38232,52826,36021,27536,27504,25423,25423,25391,25390,25390,25390,25358,21197,21197,23245,21164,21131,23179,21098,46256,48529,46320,46385,42160,42225,37935,40112,35822,40113,31629,38000,31596,42160,29484,42193,27404,44274,27371,44274,25323,46354,25323,46386,23210,48467,23210,46387,23211,46354,23211,46322,21130,44273,21227,44274,21163,44242,21163,42161,23243,42161,23243,42129,23244,40081,23308,40049,23308,40048,23308,40048,25389,40048,27437,40048,25389,40049,25357,37969,25389,40048,25389,38001,25356,40048,23276,40049,23244,40081,23211,40081,23211,40049,21099,42161,21163,40146,23178,16840,18985,23177,23145,23145,18985,19116,29648,29615,31761,29549,31401,19083,27568,21263,12778,21164,33776,35921,21196,21164,29647,17000,8644,6532,10724,12805,12805,12773,12774,31793,40343,12905,21325,27470,44308,52759,50679,50646,48599,42260,33710,35856,37969,42129,35855,40048,44274,40082,42162,33776,29615,40180,46552,42294,23342,21229,23310,33904,35918,19112,8612,4419,16968,23209,23304,17062,14949,14916,12836,12837,10723,8611,10789,12837,6499,4322,6371,19049,27469,29582,27534,29646,29581,12871,12807,19115,29648,29551,29616,42195,52725,50644,31658,29611,33805,33836,33804,38032,23369,10819,10884,12964,12963,10850,10850,6657,14885,29607,27590,25512,36008,40134,40133,37989,25411,25380,19106,19106,23364,25411,19106,16993,21187,23300,23299,14914,8579,4290,6403,6435,255},
{34040,29847,29846,34007,40280,36087,27766,32056,42587,42555,42554,38264,50810,31697,18887,18952,18952,20967,18919,18919,20999,18952,23080,20967,20999,25160,20999,23047,23079,18887,44143,50577,46320,46417,42160,42225,37902,40112,33742,38000,31629,40145,29516,42161,27403,42193,27371,44242,25291,46354,25323,46387,23210,48435,23178,46354,21098,46386,23211,46321,23210,46321,21163,44208,23308,44242,23308,42161,23308,42161,25356,40080,25389,40081,25389,40048,27501,37968,27502,37967,27501,37936,29582,35855,29550,37936,29582,35856,29582,35888,29550,35888,29582,35888,29517,35855,27469,37936,27469,37936,27404,37968,27404,37968,25292,40049,23276,38033,25291,10599,12744,21130,27403,29516,29581,27534,27600,29648,33842,31761,25456,21164,23277,17004,23408,23309,35986,33841,19084,21197,40147,27469,14951,14918,14918,12773,14854,10628,8613,23309,36085,25519,31695,40016,44340,33743,42228,31695,40114,33743,31630,29550,31663,37968,35888,33775,48434,42129,37936,37936,31695,40213,42294,38068,23309,19149,23309,33806,37967,17031,10725,10725,19080,25257,25418,17029,14949,21255,14917,10724,8643,10724,12869,17061,10724,2209,6371,16936,21163,25388,19113,14951,10725,4483,8709,12905,38232,42099,27535,29614,31694,46516,50677,35820,33740,29611,35918,35916,17125,8707,12964,15044,17156,10851,10850,8737,19173,33895,25477,42247,40132,35940,40101,29570,29603,27492,21251,17025,21251,27491,10753,19107,25411,23330,21187,14915,12772,8548,6435,8515,255},
{34040,29847,29846,34007,38168,34039,27766,34104,46747,42554,36249,40344,46650,27504,27207,29384,31431,29319,33544,27239,29319,31464,29320,29320,31399,27239,31399,33479,29319,29254,46158,46417,44207,46385,40047,40112,35789,44305,35854,40080,31596,42193,29516,44273,27403,44306,25291,44274,23210,46354,23210,46354,23178,46354,23178,48434,21130,46354,23243,46321,23243,44241,21195,42128,25388,42129,25389,40048,25356,40016,25389,37935,27469,37968,29550,37903,29614,35855,31663,35823,31695,35855,31695,33743,31663,33743,33775,33743,33775,33710,33775,33742,33743,33710,31662,33742,33742,33775,31662,35823,31662,35855,31630,35887,27436,35855,23243,31662,33742,29516,27404,29549,31629,29483,27435,27437,25389,29615,31794,31761,19084,21196,23277,21164,23277,23309,31760,29647,17003,21196,42259,40114,21195,21194,16998,12773,12741,8516,12743,18985,14890,21292,40049,50516,50679,46454,48567,46486,48566,35855,33775,29582,29550,29550,37969,35855,42129,40015,33775,40049,38001,46519,42326,35987,23309,19149,23342,33839,50581,35854,23370,14950,14952,19080,21159,21190,17062,17030,19045,10724,14917,10724,10724,12869,6499,2274,4291,19017,23276,23276,21226,25583,31890,27663,19308,15050,29647,33776,31696,25422,27535,33840,50678,52725,31724,31692,29579,27594,21318,12932,15044,12933,12868,10851,15012,10852,29705,38056,33865,44294,31715,29637,38054,31748,29635,25380,25380,19107,27492,29539,27555,27524,29604,23299,12834,14914,10692,8548,8515,6435,255},
{31959,29847,29846,31927,36088,34007,27766,34072,46747,40474,32024,38264,44570,25423,31367,33544,35623,31399,37736,29351,29351,35624,31400,29352,31399,29319,31432,33447,31399,29286,44110,46417,42127,46353,40047,44305,33741,48498,40079,42161,29548,44273,29484,46353,27403,46354,23242,46354,23242,48434,23242,48402,23178,48434,21130,48434,23211,46354,25291,46321,25324,44241,23308,42128,25421,40081,27469,40015,27469,37903,27469,35790,29549,35823,29582,33710,31630,31662,31662,31630,33776,29550,31663,29582,31695,27437,29582,27501,31727,25356,23243,19049,21098,16905,16937,14824,14824,19050,23243,21130,16969,19050,16969,12808,8615,17002,14856,10631,14759,16839,16872,21097,27403,12709,6468,12776,19083,29648,31729,21164,12778,16971,23309,23309,25422,25390,35921,27502,17003,23276,31727,42259,31695,21194,12740,12742,14854,12710,10597,21130,23308,25519,42162,48468,50647,48534,50711,50744,50679,35855,35856,33743,29550,27469,31630,33775,38034,29551,33710,35855,42161,48533,44439,35955,25390,21229,23375,40245,48500,42129,29581,17030,14887,31624,25317,21158,17062,19110,21158,10692,6531,10724,6467,2274,4387,4387,10564,19049,25389,27469,25389,40278,57214,55036,48763,40115,27437,29615,29648,25422,29583,29615,31727,46516,52790,33804,27498,23369,25480,19237,23431,14981,14981,21318,15044,12870,27532,35978,38026,38055,31748,23298,21186,27524,25411,19108,33766,21187,27492,25346,21218,23331,25411,12769,8609,19172,25444,12803,4354,6435,255},
{31959,29846,29846,29846,36120,31927,27766,32024,42522,48892,29944,38297,42522,25424,31399,33511,37703,33479,37703,29319,29319,33512,29319,29319,31367,29319,31432,29287,27239,29286,46158,48497,46320,46353,40015,44305,35822,46353,35822,42161,29516,42161,27371,44273,27403,46322,23210,44241,23210,44209,23210,44176,23210,42096,23178,39983,21098,35822,19050,31597,19050,29484,16970,25356,16970,23211,16905,19018,14857,16905,14825,14825,12744,12744,12712,10664,10631,12744,12745,17067,21326,12842,10729,19213,12906,10761,12841,17099,21260,12841,4421,6502,2277,2277,2245,4325,2212,6470,16937,14857,12776,12809,8583,6503,4455,10760,17001,21195,40081,38000,37935,40048,33774,12805,8613,12712,16970,27568,29648,6407,8553,19116,25390,25357,25389,25422,35954,38067,23342,25390,29582,44340,44340,25388,17000,12774,12806,12773,10628,14854,23275,27502,46322,50581,44308,38034,48566,46453,48565,37936,37968,35855,31662,29550,27404,33743,36086,23343,29484,37935,42162,48468,46486,35922,21197,23309,27600,42391,46355,31628,19145,14918,8580,27432,23172,19045,12740,10660,12772,6500,8676,17062,6499,129,4354,6403,14758,21130,25356,29550,27470,29648,55036,55004,44505,31827,27502,29615,29615,27502,29615,29583,29582,29614,42258,52790,35885,21223,25513,25480,21286,17093,15012,19238,12900,12903,27501,25418,23336,35974,31715,25476,29636,38021,31684,27492,31653,27460,27492,21154,14945,25379,21250,19138,17026,16994,14914,14882,8515,6435,255},
{29911,29847,29846,29846,36152,31927,27798,31992,38264,40212,27503,31631,31663,25227,31431,35624,37703,31431,37768,31399,31399,39817,29352,29319,31399,29351,33512,31367,29319,27238,25291,21228,21196,21196,17036,19084,17003,16971,12745,12809,10664,14792,8518,27338,37901,31564,18984,18984,16872,16904,16904,18920,16871,16904,16904,14792,10663,8584,8583,8551,6471,6471,6470,6470,4390,4358,6438,4358,4358,4326,4326,4390,4357,4358,4358,4358,4358,4326,8551,14922,19180,10696,10664,16970,12776,12744,10664,29712,29582,18985,18985,21033,21033,21033,18953,18953,18953,18920,21001,18953,16807,6373,12680,14890,10793,12938,14986,35920,44274,40015,27371,35855,27467,4451,6532,10631,14890,25455,29681,14891,21229,31794,23309,10632,21164,27470,38066,52785,40145,31729,25390,29615,48533,38001,21192,17031,16967,21194,19047,12805,23275,33776,48370,52661,35921,33808,46453,40146,48533,40016,37935,35823,37936,35856,31695,33743,33940,21262,35823,40048,42161,50581,44308,31728,19148,21197,29681,44472,33773,16999,14918,6532,2338,19110,25318,25383,16997,12739,14820,10660,8612,8612,4451,4387,4354,6338,14790,23210,25356,29550,33775,29517,33841,48731,36087,17233,29615,25422,31696,25422,29615,27502,27502,27502,25356,35887,48532,29612,29673,27593,29740,17092,10819,8741,6597,2275,14857,21196,17062,31781,27555,29669,42246,35909,29572,29572,23299,23299,23267,23332,29572,23299,17026,14945,17026,12833,10721,6497,10628,8548,255},
{31959,29879,29846,29846,36152,31926,29911,32024,29878,23113,23014,23047,25127,23047,31399,33543,39783,33511,37736,31399,31399,39816,31432,29351,33479,29319,33512,31399,29319,29319,12745,6602,8682,8683,8683,6602,8650,6536,4424,4423,4423,4358,4325,21032,37868,31531,16871,14791,14759,16871,18984,18984,18952,16872,16839,14791,12679,12711,12679,10599,14759,10566,12679,16839,12646,14791,16839,12678,18920,14759,14759,18952,12646,16839,18920,14759,21065,12615,16840,18920,21000,18887,18920,18887,18855,18887,14727,42293,40114,23081,25161,25161,23081,23049,23081,23081,21001,16840,16873,14728,14727,8421,10599,17003,15019,14986,21292,40113,44274,42128,42160,42128,29547,4451,258,4389,12777,25455,31761,33842,33874,33908,23277,10664,19051,25422,38099,31727,21164,19116,19117,21163,38033,44373,27468,23275,21196,23276,29549,29548,29517,35888,50515,50581,50679,50679,48598,50647,46453,42129,42095,37935,37968,40082,35889,29582,33907,27503,37936,35856,37969,52694,46355,29615,19148,21197,29681,44504,35985,16999,10758,6532,4387,25351,27398,25318,19109,12804,8514,6499,4419,8645,8644,8612,8548,10564,16871,23178,25356,29549,31695,33808,29582,40180,31696,21196,27469,27534,31728,27535,27502,27502,27502,27502,36182,44372,37966,52758,38031,31822,40274,15012,8707,6661,10828,8586,4260,17033,15014,27559,33829,31749,31717,31749,31684,31716,23298,19106,14914,25444,21218,21218,23298,14978,21250,14913,14913,19106,14915,10627,255},
{31959,29879,29847,27766,34072,29846,31992,32024,29715,20967,20934,23014,23047,23015,33447,33543,37671,33479,37736,31399,31431,35624,31399,31432,31399,29287,33544,27239,29319,31367,23112,23145,25225,21065,8486,8454,18920,18952,14791,18920,16807,18920,16807,16806,21000,16774,16807,18887,18854,25160,23112,25193,25225,18887,18887,20967,16774,21000,20967,18887,23081,18887,21000,23080,18887,23113,21000,18887,23113,18919,18952,23081,16774,20968,18887,14727,23081,12647,16839,20968,18919,16807,18919,16775,18887,18887,12679,42293,40212,27372,21033,21033,21033,21033,21033,21001,18921,16840,18921,18921,14728,10534,10501,16905,17099,15018,25453,42128,33677,21194,21194,35855,21160,2403,259,2308,12777,25455,27568,33907,35955,25358,25389,14858,8520,25357,38035,27470,19083,23342,17036,17003,19082,40180,16906,12713,23277,21164,31663,42097,37904,40017,52596,52661,40114,50711,40114,46421,50646,35890,33744,35822,40016,40081,38001,31663,33808,31663,35888,33775,40082,48468,44307,27535,19148,21229,31826,44472,44439,27532,12838,10758,6435,27430,31591,23238,19109,12804,4354,2242,4451,4355,12743,16936,12612,16838,18984,19082,23275,31662,29582,35888,33775,27437,29550,31695,31695,31696,31696,29615,29615,27502,27502,27535,42554,54938,25388,35919,52790,42225,29611,25449,21288,17127,21293,10665,6438,14985,14982,23334,33828,27587,23363,33830,31684,21218,21154,27492,31716,27491,21218,27524,19138,14946,14945,6560,19138,19105,17025,12803,255},
{29879,29879,29847,27766,34072,29814,34105,32024,33581,22982,23014,23047,25095,22982,31399,35592,37703,33479,37736,33512,31432,33544,31400,31432,33480,31400,35592,31400,33512,31432,29288,29352,25159,25160,10533,10501,20968,20967,18919,20967,14662,21000,18887,16774,21000,14694,16807,18855,14693,23048,23080,14694,18919,14662,18887,18855,14694,21000,16807,16807,23080,16807,20968,20968,14726,21000,18919,18887,21000,16807,18920,21000,16807,21000,18887,16807,23113,14727,16807,23080,18887,18919,23080,18887,18919,21032,16872,44406,38099,35856,18920,23114,23114,23113,21033,21001,18953,18953,18920,18920,14727,14727,12614,14791,15018,15018,27565,44241,25258,14985,17098,33774,29580,8644,259,4422,12809,23439,12974,33842,27503,10600,25423,23343,14826,23309,38035,25390,19051,29615,23245,14923,10631,29647,27634,14957,21164,21197,21164,33743,37904,40049,48403,50613,46453,50679,48566,48534,46388,33809,29389,29419,40048,37968,38001,35856,33808,29550,33743,35855,40114,46453,44341,25422,19116,21197,33907,44472,38131,19177,14984,10758,6532,21190,23270,25350,19142,10724,10692,6466,10659,6434,8452,14791,21031,18918,17001,33971,23178,29549,31662,33775,35856,31663,35856,37969,35889,33808,31728,29615,29615,29615,27534,34036,40473,42326,23277,29615,35919,50710,42289,27497,29578,33804,31723,23304,17000,29777,17063,14981,31780,27554,17058,25380,27460,25379,23267,23331,31748,19073,12865,23364,14913,17058,8673,10785,19170,19106,12866,14884,255},
{29879,29879,29879,29846,34007,27701,31991,29846,29420,20934,23014,23015,23047,22982,31399,35592,37704,31431,33544,37672,33544,31432,29319,29352,31399,29319,33544,29319,31400,33512,29320,29352,29320,25160,10501,10501,21000,18887,20968,23048,12613,18920,18887,16807,20968,14662,16807,16774,27305,23080,14694,14726,18887,14662,18887,16807,14694,21000,16807,18887,21000,18855,23080,20967,18855,23081,20968,20968,23113,18887,21000,21000,18919,23080,18919,18920,25161,14759,14759,27274,23113,18887,23081,16807,18920,21000,18985,44406,38067,40115,23082,25162,23114,21033,21001,25227,23146,18921,25259,25291,25258,27371,21130,21130,17066,17066,29646,44241,29484,17033,19179,35823,33741,12805,6598,12808,14920,21294,10992,31761,27503,12714,29747,21230,25357,27502,40115,25389,19084,29615,21196,21262,21197,21163,33841,40344,25423,21164,19051,23277,37936,44242,46322,50614,50679,50679,50679,48599,46421,33743,25195,25258,42128,40048,35856,40082,31663,27469,31695,33742,42260,55036,48633,23309,19116,21197,33940,44504,42358,40245,25419,8677,10757,23302,19077,27430,21222,12836,6499,4386,10691,4418,2275,6436,21063,21031,23374,38165,25323,33708,33742,35888,35888,35824,35888,40082,35856,31695,31696,31728,29615,27535,29583,44601,46681,38100,23309,27502,27535,29678,54904,46451,29578,31691,27530,25449,25482,33970,12870,17095,31718,25443,21250,29605,33701,23266,25412,27492,23298,16994,19139,14946,14946,19170,14978,14978,14914,12739,14851,19047,255},
{31959,31959,29911,27766,29846,25653,27831,27798,27602,23047,23015,25128,25128,23015,31399,35656,39784,33479,37736,33544,33512,33512,31400,33513,33480,31432,35625,31432,33512,33480,31432,35657,31433,27240,10534,10501,23080,18887,23080,25193,14694,21000,18888,18887,21000,16742,20967,20935,20999,25160,20967,16807,18887,14694,18887,16806,14694,20967,16774,18887,21000,16775,21000,18887,16775,21000,18887,20968,23113,18887,21032,21000,16807,21000,18855,18920,23081,16807,14727,23113,21000,21000,21033,16840,18952,18920,25259,44406,38034,40115,16808,16776,16808,14728,14696,27308,23179,33776,42227,40081,37967,40080,40080,33775,17067,14986,31726,44241,27403,14985,21259,40048,27403,19047,21162,25420,14920,23342,19247,29648,33841,19084,21328,19117,25390,27502,40147,23309,19084,27470,12778,33972,36053,25455,31728,44471,35955,23244,21164,19083,33711,42129,46355,48566,50679,50679,48599,48632,46453,33775,27275,27372,37968,42128,37968,40082,33775,27437,31695,27469,44373,50778,40213,21229,19149,23309,40343,50810,44439,42292,21257,12870,4387,4322,12740,23270,17062,8644,8643,6499,10691,12739,12807,21260,25323,18984,29746,44471,23243,40310,37968,35823,35856,33775,37936,46388,37937,29550,29582,29615,29647,29615,29648,42423,50875,31728,23341,27535,25422,29615,35921,52726,48532,31691,31724,27498,25483,44503,23404,10789,10724,25477,35908,33764,33764,27492,21187,21219,16994,8641,17059,17058,17059,14945,17122,14946,6434,10628,12708,21161,255},
{31991,31959,29879,27766,27766,25653,27831,27831,29780,23048,23047,25128,25127,25095,33479,37704,39784,33479,41928,33512,31432,33544,33480,35625,33544,33480,37673,35560,33512,33480,33512,39753,31401,27240,10501,8421,20968,18855,20967,23048,16774,20968,16807,18888,20968,14694,18887,18887,16774,20967,18855,16807,18887,14727,18887,16807,16807,18920,16775,18888,18920,16807,18888,16807,14694,16839,14726,16807,18919,14662,16807,14694,12582,16807,12582,12615,16808,8486,6406,16840,10502,14726,16840,10502,14759,14759,27372,46519,35954,40147,21034,18921,18921,18889,14760,23179,23113,44275,52726,48532,37903,35790,46354,35855,17098,14986,33839,44209,27403,14985,23340,35854,16967,6499,19081,19147,19146,21228,27535,29616,33842,25391,15021,21197,25390,27502,42195,23277,17003,29615,23277,40279,33940,25521,33842,44340,31663,10665,19083,17003,21164,31663,40081,48436,35855,27468,23275,21130,33807,37936,31662,33743,35855,40016,40048,38001,40049,29549,33808,29550,42260,44472,38068,19116,23276,23373,31759,29612,29677,23337,12869,8676,4418,4387,194,6563,10756,6563,14950,19112,25385,14853,14919,25386,23145,21065,23276,33744,23243,36052,35954,23308,33709,33742,37936,46388,37969,33776,29550,25389,29615,31728,29647,29648,35922,27470,27534,29615,29615,29615,31696,38001,52791,50677,35885,31659,29548,31726,25484,8678,10790,25477,27492,29604,35877,33796,21153,10817,19139,8608,12898,17058,10785,12898,14978,17030,12710,10660,14853,27533,255},
{34040,31959,29879,27766,27766,23605,27831,27831,25620,20967,20934,23047,25127,20935,20934,23014,23014,20934,20933,20934,18854,18822,20902,18822,20934,20935,18854,20935,18855,16742,20935,16774,16742,14694,8389,4228,14695,10501,14695,14662,10501,14727,10469,10534,14695,8421,12614,12582,10501,12614,10469,10534,12614,8453,14695,10534,10534,14727,8453,14727,14727,8421,14727,10566,8421,14695,12614,12614,16807,8453,12647,12614,8422,14727,8421,10533,16808,6406,6406,16840,10502,16774,18887,12614,14759,16808,27372,42227,38034,40147,21067,16873,12647,12615,10535,18986,23147,25193,39984,42097,35790,33710,35790,27469,17131,17099,35919,40015,23242,14953,23372,33773,10725,6500,16937,31760,23276,19148,27600,31794,35987,36019,27634,21197,25357,27502,40082,23244,17003,29647,33776,38166,42389,35980,40237,46448,35920,17101,19051,21164,21164,31695,42129,29515,6531,4483,4483,6468,33841,40147,35823,38101,35823,35823,40080,42161,37936,31662,33776,29582,42261,42327,33874,19084,21129,14952,21224,19141,14948,14949,10756,8643,8676,6564,2210,4386,4419,8612,19111,31691,33804,31659,31723,35885,27273,20968,21130,19018,27501,42358,42292,17068,29549,35822,40016,42130,40050,44308,37936,27502,27502,29615,31728,31696,27502,25389,29615,29582,29583,31696,29615,33808,35887,50677,52791,33773,31628,29547,25418,12903,8676,8676,4418,8643,23331,27524,17058,14946,17026,10722,8643,14979,17091,10754,8644,19018,29356,14824,19016,31727,255},
{34072,31992,31959,27766,25718,23573,29912,27863,25620,23048,23014,25095,27240,25128,14693,16741,12613,16774,14661,14726,16774,12613,16774,14661,16774,18855,12614,16807,16742,12614,18887,14694,14694,12582,2181,35,12615,6341,12647,12582,6341,14694,8421,8454,12582,6308,12614,12581,10533,14694,8421,12614,14727,8453,14727,12614,8421,14727,8453,14727,14695,8389,14727,12647,8421,14695,12614,14727,16840,10534,14727,12647,10534,16808,12614,14694,18920,10567,10567,18953,14727,18920,21033,16808,16840,21066,38002,25258,35921,42261,18921,16841,16841,16808,16808,16873,21098,18888,16807,16807,18856,16775,12582,14825,19244,19179,38000,29580,31661,19146,25420,31628,21161,6500,12743,31725,21225,19148,27568,31762,33874,42326,31696,14858,23309,27502,37936,21164,19083,29615,31696,38199,52884,54957,48624,36081,44372,38066,29550,21196,19083,23244,40049,37935,25419,14984,10758,17034,37968,42161,40082,33843,23244,33742,37968,42127,40016,35855,33743,31630,40147,38035,29615,21195,23244,27469,29547,21221,14948,12836,12868,12836,12869,6531,129,2273,2306,2242,21127,31659,35884,35917,35884,35917,31660,23211,33676,27339,27501,48665,40180,25454,27503,42161,46386,33743,40050,54807,42130,29550,27470,27502,33808,33841,29647,27502,27502,27502,27534,29615,29615,31728,29615,29582,46453,54904,35853,31595,33707,25418,12902,8677,8709,4484,4451,12868,21252,17060,8610,161,162,8643,17030,4421,4422,19019,25227,21131,23308,23243,255},
{36152,34072,31959,27766,25686,23573,29944,27798,25555,20935,20934,23047,25128,23048,18822,18854,12613,16774,16741,16806,16774,14694,18854,14694,16774,18855,16775,18887,16742,14695,21000,14662,14727,12614,4261,68,12615,8421,14727,14694,10501,14759,10534,10566,12647,10501,14695,14694,16806,16775,12614,14727,16839,12647,16840,16775,12647,16840,14727,16807,16808,12614,16808,16776,12615,16840,16807,16807,18920,14759,16808,16840,14695,16808,16808,14695,18953,10600,12712,14760,16840,14727,16807,14759,10534,16841,38034,21033,31728,42293,23114,20969,20969,18888,16808,14793,18953,21001,14727,14792,16840,16808,12615,12712,14921,19147,40080,35887,40048,17065,27467,29515,16999,6532,2340,29744,27566,19116,27600,29681,31761,40213,31629,25357,25357,29583,35888,19083,19084,29647,31760,42457,46450,54905,55036,38196,42293,44307,42194,25357,21131,19051,27502,42129,44210,44242,33775,31696,42129,42128,40180,31663,25356,31662,33775,35855,37936,40114,42226,31564,29451,40047,35757,33741,46321,27338,33742,21255,14948,10755,15012,12803,8547,4419,2338,193,193,4355,23240,31690,35916,40077,37997,37997,33740,23243,48300,41963,27404,31663,33777,27600,23211,37935,39983,33775,33775,46355,35823,33808,31695,27502,29615,33841,29648,29647,29615,27470,29615,25421,27535,33809,29648,31663,33774,46420,52791,37966,31595,29579,25386,16999,14951,17066,4485,2372,4484,6532,2339,2307,194,228,10696,12810,12745,12777,16970,19083,23244,29615,255},
{36184,36152,31992,27766,25654,23573,29944,29912,25588,20967,23015,25128,29353,25193,18822,18854,14694,16774,16774,14694,14662,14662,16742,14662,16742,16775,14694,16775,14694,14662,16807,14662,14695,12615,8422,4229,12615,10501,12647,12614,12614,14695,10534,10534,12614,8453,12615,12582,10501,14695,10534,10534,12647,10534,12615,10566,8421,12647,12614,8454,12615,8453,10534,14695,10502,14727,14727,12614,14727,12615,10534,14727,12582,10534,12647,10534,14760,4358,12680,10502,14727,12614,10534,14727,10566,12615,38034,29452,35921,42228,21067,16873,14728,14728,12647,12680,18953,21001,10566,12615,12679,12615,8453,10599,4292,19050,33775,37968,40048,23372,40080,27468,27436,19081,12839,27632,33841,27567,44537,40247,16939,21132,25257,29484,29550,29615,33775,19051,19083,33841,31663,38231,46518,48400,48466,44177,29387,35758,44307,35888,21164,21131,19083,35856,42129,46258,40016,29617,35856,35920,44471,29582,31695,31630,35856,33775,42194,42259,48761,42129,23113,35790,56852,29354,52627,37740,31564,23304,12803,14948,17028,12836,6563,8644,2273,193,2306,8515,25352,31658,35917,40077,37964,37997,35820,25259,31564,29484,25324,23179,21131,23310,21130,35823,35823,33743,37966,40048,33743,33776,31728,31695,29615,29615,27502,27535,29615,29648,27502,25389,29615,33841,33873,29615,29582,29582,44340,54904,42193,31595,31661,27435,25353,29679,15018,4485,8646,6597,4484,2372,2373,10761,14890,14890,14858,12809,14890,17003,21163,29549,255},
{40313,38265,34040,27766,23605,23573,32024,29944,23540,20967,23047,25095,27208,23048,10501,4228,6309,6308,4228,6341,6276,6309,8389,4261,8421,8389,6276,8389,6309,6341,8421,6309,8421,8389,4261,36,8422,4260,8454,8421,6341,10502,6341,8421,10502,8356,10502,8421,8389,12614,12581,8421,10534,8421,10502,12614,10469,12614,12615,10534,10534,8421,10566,14759,10501,10534,14727,10501,12614,12614,8421,12647,10534,8421,12647,10501,10567,2213,12679,6341,16807,14726,8454,16840,14727,8422,35888,40114,44406,40082,18889,18921,18921,18921,18921,27503,23146,20968,12582,12647,12680,12647,10566,8519,4292,16937,14826,25422,23309,27501,44273,23340,27467,23273,14887,23373,33873,21163,42327,44472,23310,8454,10565,23210,23276,25389,31663,19083,21164,33808,29583,31827,50811,46385,35787,33808,29582,29484,42194,42259,29550,21131,21164,23276,40049,42129,42064,31598,33841,38198,38263,27502,31662,31663,31695,33743,40147,40212,46617,52793,35790,27403,37902,42095,29451,40047,31563,27403,23273,17028,10691,10691,10723,8611,161,226,4452,10661,29513,33738,35884,37965,40078,44271,37900,25290,21131,23243,21163,23211,23243,16937,21163,35823,35791,31630,31662,35888,35888,31663,29582,33809,31695,27502,25357,25389,27535,29648,27535,25389,27535,35922,35921,31728,29582,29583,27502,40146,54904,40112,31660,31629,27401,27434,21129,8613,14921,19179,17034,14954,17003,19084,17003,16971,16971,16970,16970,17003,23275,29546,255},
{42425,38265,34072,27798,23605,23573,29944,29976,23540,16775,16741,18822,18822,18822,12581,8453,10533,10501,10501,10501,8421,10533,12581,12581,14662,12582,12582,14694,10533,12646,12614,12581,14694,10502,4229,3,8422,6309,10534,10501,8421,10534,6341,8454,10534,6308,10501,10501,10468,16774,14661,10501,12614,8421,14662,14694,10501,12646,12614,10566,12614,10501,12614,14727,8389,12582,16807,8421,10534,12614,8389,12614,10502,8421,12647,10501,10567,2213,14760,8421,14727,14695,12614,18920,16840,23081,29451,42195,48599,35857,16808,18888,18888,16840,16808,27470,23146,23049,14728,16840,16841,16841,14727,10599,6405,8550,8518,27470,25389,21196,23212,29453,25323,12904,8646,19147,35986,17000,31664,33679,23278,10632,10857,27531,25355,31728,31663,19051,23277,25357,29615,19117,46584,52825,44270,42159,44208,46320,40081,42227,40082,23244,21131,19051,29582,42129,46290,44177,44242,50745,31892,21163,35855,31663,31695,33776,38100,40246,38165,52923,48566,33644,29483,40015,37902,33677,42160,33644,33708,14917,8642,10724,8643,8707,2306,8614,14921,23307,29545,35819,37932,37997,42190,48496,35821,23243,25323,19050,21131,23243,25356,23243,25356,31662,33743,31630,31630,31662,40082,33775,31695,31663,31696,31695,27470,25389,29583,29615,27535,25389,27535,35954,35889,33776,27502,31695,31695,31695,42259,54937,44305,31627,31596,33774,29514,27466,25418,23276,23309,23309,21229,21164,19084,17035,17003,17003,19115,23308,27501,25320,255},
{46586,40313,36152,29847,23605,23605,29911,29976,25621,16808,16774,18855,18854,18855,18822,20999,16807,14694,14726,14726,14661,16775,16775,14694,18855,14694,14694,18855,14694,16807,14694,12614,16775,12582,4229,3,10470,4261,10534,10469,10534,12614,6341,8453,10501,6276,10533,10501,12517,16807,14726,10501,12647,8389,12582,14694,8421,12646,14694,10534,12647,12614,12615,16808,12614,14726,18920,14694,14727,14759,12615,16808,14727,12614,16808,14727,16841,10599,18953,14727,18888,18920,14727,16808,18921,25259,21098,40115,46454,33743,16808,18888,18921,18921,16840,16938,23146,23049,12615,12647,14728,14760,16873,14824,4420,227,4356,8548,19082,23277,12744,12840,8582,12841,8646,10792,38131,17032,23341,33712,23212,21132,4390,21583,23306,31663,27470,19051,16971,21230,23244,25422,46552,57083,52754,44170,18953,40212,50777,44372,44307,33775,21131,19051,19083,37936,44177,46290,42096,46420,35954,25356,35855,38099,42359,29582,40213,44472,38068,35919,50711,44275,31564,46287,58964,50513,48465,54771,35724,25386,14918,8579,6530,12869,19243,33874,29647,29615,33806,33771,37997,40109,44303,46384,33742,29549,29517,23211,21130,21163,23276,23243,25356,27469,29582,31695,31630,29550,33776,35920,31695,29550,31728,37808,31113,23276,25422,29583,27535,25422,27535,33841,35921,31696,29615,27534,29583,33808,31695,40146,56985,44338,31595,48501,37870,33740,33739,27466,29615,23309,23309,23309,21196,19116,19116,23307,27468,33709,31662,23241,255},
{48666,40313,36185,29879,23605,23605,29976,29976,23605,18888,18822,18854,18855,20903,20903,16774,16774,14694,16806,14726,14694,18855,16774,14694,18855,16774,14726,18887,20967,18887,16775,14662,18855,14694,6341,68,12582,8422,12614,12614,14727,14727,10534,12646,14695,10501,12647,12614,14662,16775,14727,16807,16808,14727,14759,16840,12647,16840,18920,16808,18921,16808,16808,18953,16840,18920,21033,18920,16840,18985,16873,16840,18921,14727,18921,18921,10632,10600,14728,14727,12647,14727,14695,12615,12647,14728,29615,40081,44405,33711,27242,29388,27307,27307,25259,27502,23113,20968,12647,14728,14728,14760,12647,10695,2307,2308,163,226,12775,23244,21162,12774,8582,6501,6566,12840,38132,19145,19147,27504,16907,19020,14825,11019,19438,31695,23244,19084,21229,23310,8519,27437,33808,54971,54904,50509,33708,44306,58999,48499,42194,44274,25389,19083,19051,25389,42129,42161,40048,40113,44404,35920,35920,40276,55003,33874,38198,48763,31761,25352,27368,48566,40048,27305,35822,50513,27403,42128,29483,25290,27403,14919,12871,21226,31694,38067,35954,31728,35986,40112,37932,42190,44303,42190,29548,33742,35921,31629,21130,21163,23276,23276,25356,27437,27469,31695,29550,29550,31663,35888,31726,31695,39953,49678,34981,21196,27535,27535,29615,27535,29615,31761,35922,31728,29583,27534,27534,29583,31695,37999,46419,56985,48531,35787,31626,33707,31626,29644,42325,31695,25357,25422,23341,21197,23275,31626,27400,27400,27434,21128,255},
{50746,40313,36185,29879,23605,23605,34137,32089,25685,16840,14694,18985,14727,14694,14694,16840,16840,18985,18952,18952,21065,18953,18953,18921,14792,12648,12680,14728,12680,14728,12680,12680,14760,14760,8487,6374,12647,8519,12647,12647,10567,12647,10567,10534,10567,8422,10535,10567,8422,12647,12679,16840,16840,16873,12679,14727,12647,16807,16840,14727,14760,16808,14727,14760,16808,14727,16840,18921,16808,14760,14760,14695,16840,16840,21099,16841,2213,10535,14694,16839,14726,12614,14694,12582,8454,10535,38002,35888,44373,29485,18888,21001,21034,18953,18986,25356,25194,21001,16840,16808,21034,16840,14760,10695,2372,2340,2307,194,2275,21163,23274,12774,10757,10693,6564,6566,38132,21258,19114,31761,27504,29681,31695,19081,23663,40112,23244,19083,23342,21229,17036,31500,37968,52857,50777,42194,44272,35854,35822,29549,25355,31759,33871,29678,25453,19114,27599,29679,19146,27566,29678,23372,27598,25485,36018,50778,40212,48534,44340,27499,19012,35919,50711,35822,29451,35789,42127,27338,40015,27370,23210,23243,31761,12679,16807,29582,38132,38067,38066,44373,44337,40109,44303,44269,35754,25356,35888,33775,29516,21130,23243,23211,23276,27469,25389,31695,29518,29550,29550,29614,33807,40080,37742,41029,28738,23309,29647,27502,27502,29648,31760,31761,31728,27535,25389,25422,27502,27502,31728,31760,35953,40114,54905,50612,35787,31594,25288,27531,46550,44373,31728,25390,25422,25455,25419,29577,25318,23205,25287,18982,255},
{50778,40345,38233,29879,23605,23638,34169,34202,27766,14892,10534,23277,17004,10534,10534,18986,19051,23244,21098,23243,25291,19018,19083,16906,12680,6472,8520,10568,8520,10568,10600,10600,10600,10601,8487,2246,10567,8487,10567,8487,8486,10567,8486,12647,12647,10534,14728,12680,10567,14760,14728,14792,16840,16873,12647,12647,12647,14727,14760,14760,12615,14760,14727,12647,16840,16840,14727,16840,16808,14760,14760,14695,14695,18921,27438,18954,101,8487,12646,16839,14758,12646,16807,12582,10502,10535,35954,35921,44373,27372,18889,16840,16808,14727,16840,25389,25194,18887,14727,14727,16873,12712,14760,10695,6565,259,259,2307,2275,14857,25420,21260,25584,8613,4485,6600,38132,27533,17001,27568,38099,33841,19114,21162,27663,31758,19115,23341,23308,23307,25519,31759,31790,29679,25485,21292,25486,19147,19115,25453,19114,21227,25486,25453,31824,23373,19114,29744,29678,21195,29744,33969,27598,31760,23373,46550,46519,31696,29713,42359,29611,27431,42225,48533,33644,29483,44240,46288,35822,48498,35821,33709,29582,25357,2081,12678,31695,42293,40179,42292,46518,44304,42158,40012,25257,27338,31629,31694,33710,23276,23243,21098,19050,27469,27502,31728,31663,27469,27502,27469,27469,35889,39952,37094,24772,23309,29615,27502,27470,27502,31728,33809,33841,29583,27502,27502,23309,25389,31760,33841,31695,31696,35954,52824,48564,31626,27433,31724,48631,48599,46518,35986,27535,29616,27502,25416,23237,23237,21094,16869,255},
{50778,40345,38265,29847,23606,25686,36249,36314,25783,19249,10502,14728,21263,10567,10535,14728,19051,21066,18953,23243,21098,19018,16971,12713,10633,8553,8553,8553,8553,10633,10666,10666,10666,10698,8585,4425,10665,8617,10665,10665,10665,12778,10665,16906,18986,16873,16841,18953,14728,16873,16841,14793,14793,18986,12647,10567,12647,14760,16872,16808,14760,18920,16872,16808,16840,18921,16840,16840,18953,16872,16840,18986,19018,21099,35922,16873,2214,10599,14727,18920,18920,16807,18920,16807,14695,14760,38002,38034,44405,23147,18921,16840,16808,16808,16873,27502,23081,16807,16840,16840,12679,10630,2244,6437,8613,2339,2340,195,291,6501,21228,31793,21260,12838,6597,10792,36019,33904,17001,27600,54904,54903,27566,19114,23340,25485,19179,19147,25453,19114,19147,27599,23340,19114,23372,17033,19146,31792,21195,23373,29711,21194,29711,36049,33969,31824,27533,29711,33905,29710,29711,33969,38227,31824,33969,31824,50777,44471,44340,40148,29615,25351,31593,50777,42162,35724,44110,58965,52561,42095,56820,33644,29484,21065,10598,4226,21097,33808,42293,42324,44405,46518,42223,29515,14824,25257,27338,33709,29549,33774,23275,19017,16905,21130,25389,31727,33775,27502,27502,25389,25357,31728,35921,35435,27307,25389,29583,31728,27502,23244,29615,31760,33808,31696,27535,27535,27502,27502,31728,33841,31728,31760,31696,35953,50679,50710,33771,31724,50711,48631,48566,48599,35920,29582,25422,27499,25352,21159,21127,23239,255},
{52858,42425,36217,29879,23638,25718,32024,38395,27831,23605,19249,19281,27732,25554,27634,27635,27732,25620,23540,27733,27733,27733,25686,21460,21461,17333,15220,13107,13075,19315,21395,25556,19347,19347,19347,21328,17102,12909,13006,15086,12973,10828,12908,14956,27406,23212,10599,18986,12647,14793,16970,14825,12647,12680,8486,8454,8454,10535,10567,8487,8455,8454,8454,8454,8487,8454,8487,8454,10567,18986,25324,33841,31794,31729,38003,14793,10665,18986,16840,16808,16808,14727,16808,14728,12615,14793,38035,35954,44373,25195,25162,23082,23049,21001,21034,29517,25161,16808,18920,12710,14824,21195,19148,21326,23373,12807,17034,17066,17098,2372,6469,10629,21194,14950,322,6566,31826,46518,29613,31793,54971,59032,46484,25517,19082,31856,31857,19146,29679,31824,21260,29679,31792,27662,29744,27598,25452,29679,29711,25484,29712,31791,25452,31824,36114,31824,33937,25420,25486,29646,23307,29711,27533,23340,27566,21260,31792,52857,37936,23243,21196,33838,35984,46388,46518,40016,25225,35790,46288,29484,37870,35821,27371,29484,25290,23145,21065,23145,35920,44470,44438,46519,46549,31596,16872,18985,25290,29483,29581,35855,27501,21098,16905,18985,19018,25389,31695,29582,29582,25389,25389,29614,33776,27534,31695,29614,29582,29615,31695,23308,27470,29647,31760,31728,29615,29615,27534,29615,29680,29615,31728,31728,33808,33808,33840,50711,50743,38097,50711,50711,50711,46517,33805,25386,25389,25422,25386,25385,23208,21126,255},
{54906,40377,36185,27799,23638,25718,27831,36314,27863,27799,29944,29911,34072,38232,46553,40312,38232,31992,27831,29944,32025,32025,29912,25686,25687,19446,17365,13172,13107,19380,23508,25556,21460,19315,29649,29583,29583,27503,31729,29680,29648,25487,25455,25422,27535,25390,10567,12615,12680,12647,14793,12680,12648,12680,12648,12680,12680,12680,12680,14761,14761,14761,14793,14793,14793,14825,16873,16873,14761,14793,21001,38067,35987,29616,27438,10632,10665,16808,14727,12615,14727,14695,12583,14696,12647,10535,35987,38067,42260,18889,18889,18888,16808,14728,10534,23211,25162,14695,12711,6469,16969,35888,33807,40114,38001,31726,29614,31760,25388,4452,2340,6502,14856,17001,8677,6597,31793,46518,35887,38099,59197,54904,56951,31759,23340,27566,29646,23307,21227,29679,27598,21227,31825,38226,36049,31760,21194,21259,33904,27630,21292,23340,14921,23372,36049,31823,31791,21228,17067,25486,21227,21227,27534,21195,23340,23373,19147,40244,44439,21228,33873,35855,27535,40080,36017,50711,37870,29418,35822,44175,27435,40015,33676,29483,31596,25290,23113,21064,25290,42292,46551,44438,46519,40147,21065,14792,21129,31626,37868,29582,33774,19017,21098,18985,16905,19018,27469,31728,29615,25357,25389,35921,35888,27502,29583,33840,31695,27502,29582,29615,27470,25389,31695,33808,31728,29615,29583,29647,29615,27502,31761,33809,33841,29615,31727,35921,48599,52824,46517,50711,52856,42226,29579,31691,27433,31629,25353,23240,25287,21093,255},
{54938,40345,34105,27798,23638,25718,29943,42620,27863,27799,32024,29911,31992,44472,52793,42392,40312,34071,29879,29911,32024,32024,29944,25686,23639,19413,17333,13172,13106,21428,23476,23476,21428,19315,35922,31695,29615,23342,25455,25487,21294,23407,19182,17068,25422,27470,23244,25325,25324,25324,23245,25293,25293,23244,23244,25325,23277,23309,25357,23309,25357,23244,23245,23277,21164,19084,19084,16971,12777,19084,25227,44373,40213,27503,21131,10730,14923,21132,25422,23309,23309,23276,25356,25389,27502,29615,42260,40179,42195,18889,18921,18921,18921,18888,16873,25357,25129,12614,12679,12776,31661,40081,31662,35952,38033,38001,35887,35953,31759,23307,8581,14888,6501,12712,14856,12777,23310,52824,37935,38067,59229,52759,59032,42291,19114,14922,27599,19114,10695,25486,27598,17066,25485,31823,27629,23340,21227,17001,23373,25453,17002,23373,19147,19114,27534,23308,21227,27599,19082,21260,29711,25452,21227,25420,19081,21293,21227,23340,46551,35987,21195,27567,27567,29645,19143,44437,48533,33677,31564,48498,52626,42127,56884,48400,44208,31596,25258,23145,23145,29516,46551,46551,44438,46551,33809,19016,14824,25322,29483,31596,27436,23210,21097,18985,16904,16937,21163,29582,29615,25389,29615,35921,29615,23276,27469,29582,29550,31663,25389,29615,31728,25389,27469,31695,29615,29647,29615,29615,29615,29615,33907,33809,31696,29583,31728,29615,31760,50711,52857,48598,48565,35919,40112,27466,33740,35820,27464,23207,23207,16869,255}
};

const bool mdb_per PROGMEM [306][78] = {
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
{0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
{0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0}
};

void disp_centered_text(String text, int h) {
  tft.drawCentreString(text, 160, h, 1);
}

void disp_centered_text_b_w(String text, int h) {
  tft.setTextColor(0x0882);
  tft.drawCentreString(text, 160, h - 1, 1);
  tft.drawCentreString(text, 160, h + 1, 1);
  tft.drawCentreString(text, 159, h, 1);
  tft.drawCentreString(text, 161, h, 1);
  tft.setTextColor(0xf7de);
  tft.drawCentreString(text, 160, h, 1);
}

int chosen_lock_screen;

void setup() {
  tft.begin();
  tft.fillScreen(0x0000);
  tft.setRotation(3);
    for (int i = 0; i < 320; i++){
      for (int j = 0; j < 240; j++){
        tft.drawPixel(i, j, Denver[i][j]);
      }
    }


  delay(1000);
  for (int i = 0; i < 306; i++){
    for (int j = 0; j < 77; j++){
      if (mdb_per[i][j] == 1)
        tft.drawPixel(i+7, j+87, 0xf7de);
    }
  }
  
  tft.setTextSize(2);
  disp_centered_text_b_w("Press Any Key", 214);
  
  mvng_bc.createSprite(306, 77);
  mvng_bc.setColorDepth(16);
  mvng_bc.fillSprite(TFT_TRANSPARENT);
}

unsigned int k = 0;
void loop() {
/*
    for (int i = 0; i < 306; i++){
      for (int j = 0; j < 77; j++){
        if (mdb_icon[i][j] == 1)
          mvng_bc.drawPixel(i, j, Denver[(i + 7 + k)%320][j+87]);
      }
    }
*/
  mvng_bc.pushSprite(7, 87, TFT_TRANSPARENT);
  k++;
}
