/* 
 *    Copyright 2007 MICS Project
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mics.architecturemaker.unit;

import java.util.regex.Pattern;


/**
 * @author Masayuki Morisita
 */
public class SingleDataBus extends HardwareUnit implements Channel {
	private static String baseID = "sbus";
	private static String defaultImageFile = "icons/unit/square_w.gif";

	public SingleDataBus(String id, int x, int y) {
		super(id, "net.wasamon.mics.bus.SingleDataBus", x, y, 16, 16,
				defaultImageFile);
		conditionTable.put("ram", Pattern.compile(".{0}&&[^.]"));
		setValue("ram", "");
	}

	public String getBaseID() {
		return baseID;
	}

	public void setBaseID(String baseID) {
		this.baseID = baseID;
	}

	public static String getDefaultImageFile() {
		return defaultImageFile;
	}

	public String getInformation() {
		return "";
	}

	public void register(HardwareUnit unit) {
		HardwareUnit destination = getConnectedUnit(getValue("ram").toString());

		if (destination == null || destination instanceof ChannelConnectable
				&& !(unit instanceof ChannelConnectable)) {
			setValue("ram", unit.getValue("id"));
		}
	}

	public void remove(HardwareUnit unit) {
		HardwareUnit destination = getConnectedUnit(getValue("ram").toString());

		if (destination == unit) {
			setValue("ram", new StringBuilder(""));
			for (int i = 0; i < connectedUnits.size(); ++i) {
				HardwareUnit connectedUnit = connectedUnits.get(i);
				if (connectedUnit != unit) {
					register(connectedUnit);
					return;
				}
			}
		}
	}

	public HardwareUnit copy() {
		SingleDataBus copy = new SingleDataBus(getID(), appearance.getX(), appearance.getY());
		copy.appearance.setSize(appearance.getWidth(), appearance.getHeight());
		copy.appearance.set("image", appearance.get("image"));

		return copy;
	}

	public boolean isConnectable(HardwareUnit unit) {
		if (!(unit instanceof DataBuffer || unit instanceof ChannelConnectable)) {
			return false;
		}

		HardwareUnit destination = getConnectedUnit(getValue("ram").toString());
		if (!(destination == null || unit instanceof ChannelConnectable || destination instanceof ChannelConnectable)) {
			return false;
		}

		return true;
	}

}
