/* 
 *    Copyright 2007 MICS Project
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mics.architecturemaker.unit;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.*;
import java.util.*;
import javax.swing.table.*;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.SwingUtilities;

/**
 * @author Masayuki Morisita
 */
public class HardwareUnitPropertyTable extends JPanel implements
		CellEditorListener {

	private JTabbedPane tabbedPane;
	private ArrayList<MicsNode> nodeList;
	private ArrayList<JTable> tableList;
	private Mediator mediator;
	static private int count = 0;
	private static HardwareUnitPropertyTable instance = new HardwareUnitPropertyTable();

	private HardwareUnitPropertyTable() {
		setLayout(new BorderLayout());

		tabbedPane = new JTabbedPane(JTabbedPane.TOP,
				JTabbedPane.SCROLL_TAB_LAYOUT);
		nodeList = new ArrayList<MicsNode>();
		tableList = new ArrayList<JTable>();
		mediator = Mediator.getInstance();
		add(tabbedPane, "Center");
	}

	public static HardwareUnitPropertyTable getInstance() {
		return instance;
	}

	public void showPropertyTable() {
		if (mediator.getSelectedUnitsCount() == 1) {
			HardwareUnit selectedUnit = mediator.getSelectedUnits()[0];
			int index = 0;
			if (nodeList.size() != 0 && nodeList.get(0) == selectedUnit) {
				index = tabbedPane.getSelectedIndex();
			}
			tabbedPane.removeAll();
			nodeList.clear();
			tableList.clear();
			getProperty(selectedUnit, tabbedPane, nodeList, tableList);
			if (0 <= index && index < tabbedPane.getTabCount()) {
				tabbedPane.setSelectedIndex(index);
			}
		} else {
			tabbedPane.removeAll();
			nodeList.clear();
			tableList.clear();
		}
	}

	private void getProperty(MicsNode node, JTabbedPane tabbedPane,
			ArrayList<MicsNode> nodeList, ArrayList<JTable> tableList) {
		JTable table = new JTable(node.attributeTable.size(), 2);
		table.setTableHeader(null);
		table.getColumnModel().getColumn(0).setMinWidth(80);
		table.getColumnModel().getColumn(0).setMaxWidth(80);
		TableColumn keyColumn = ((DefaultTableColumnModel) table
				.getColumnModel()).getColumn(0);
		TableColumn valueColumn = ((DefaultTableColumnModel) table
				.getColumnModel()).getColumn(1);
		JTextField keyField = new JTextField();
		keyField.setEditable(false);
		DefaultCellEditor keyEditor = new DefaultCellEditor(keyField);
		DefaultCellEditor valueEditor = new DefaultCellEditor(new JTextField());
		valueEditor.addCellEditorListener(this);
		valueEditor.setClickCountToStart(1);
		keyEditor.setClickCountToStart(1);
		keyColumn.setCellEditor(keyEditor);
		valueColumn.setCellEditor(valueEditor);
		table.putClientProperty("terminateEditOnFocusLost", true);

		JScrollPane scrollPane = new JScrollPane(table);
		scrollPane.setPreferredSize(new Dimension(100, 100));

		Iterator<Map.Entry<String, StringBuilder>> iterator = node.attributeTable
				.entrySet().iterator();

		int row = 0;
		while (iterator.hasNext()) {
			Map.Entry<String, StringBuilder> entry = iterator.next();
			table.setValueAt(entry.getKey(), row, 0);
			table.setValueAt(entry.getValue().toString(), row, 1);
			row++;
		}

		tabbedPane.add(node.getTag(), scrollPane);
		nodeList.add(node);
		tableList.add(table);

		for (int i = 0; i < node.childList.size(); ++i) {
			MicsNode childNode = node.childList.get(i);
			getProperty(childNode, tabbedPane, nodeList, tableList);
		}
	}

	public void editingStopped(ChangeEvent e) {
		for (int i = 0; i < nodeList.size(); ++i) {
			MicsNode node = nodeList.get(i);
			JTable table = tableList.get(i);

			for (int j = 0; j < table.getRowCount(); ++j) {
				String key = (String) table.getValueAt(j, 0);
				String value = (String) table.getValueAt(j, 1);
				if (node.get(key).equals(value)) {
					continue;
				}
				mediator.setValue(node, key, value);
				table.setValueAt(node.get(key), j, 1);
			}
		}
	}

	public void editingCanceled(ChangeEvent e) {
	}
}
