/* 
 *    Copyright 2007 MICS Project
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mics.architecturemaker.unit;

import java.util.regex.Pattern;

/**
 * @author Masayuki Morisita
 */
public class AppearanceAttribute extends MicsNode {
    
    AppearanceAttribute(int x, int y, int width, int height, String imageFile) {
	tag = "appearance";
	indent = "    ";

	conditionTable.put("x", Pattern.compile("\\p{Digit}+"));
	conditionTable.put("y", Pattern.compile("\\p{Digit}+"));
	conditionTable.put("width", Pattern.compile("\\p{Digit}{1,3}"));
	conditionTable.put("height", Pattern.compile("\\p{Digit}{1,3}"));
	conditionTable.put("image", Pattern.compile("[^<>*?|\"]+"));

	setValue("x", Integer.toString(x));
	setValue("y", Integer.toString(y));
	setValue("width", Integer.toString(width));
	setValue("height", Integer.toString(height));
	setValue("image", imageFile);
    }

	public boolean inRange(int x, int y) {
		int width = getWidth();
		int height = getHeight();
		int left = getX() - width / 2;
		int top = getY() - height / 2;
		return x >= left && x < left + width && y >= top && y < top + height;
	}

	public int getX() {
		return Integer.parseInt(get("x"));
	}

	public int getY() {
		return Integer.parseInt(get("y"));
	}

	public void setPosition(int x, int y) {
		set("x", Integer.toString(x));
		set("y", Integer.toString(y));
	}

	public int getWidth() {
		return Integer.parseInt(get("width"));
	}

	public int getHeight() {
		return Integer.parseInt(get("height"));
	}

	public void setSize(int width, int height) {
		set("width", Integer.toString(width));
		set("height", Integer.toString(height));
	}

}
