/* 
 *    Copyright 2007 MICS Project
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mics.architecturemaker;

import java.awt.*;
import javax.swing.*;
import java.awt.geom.*;

/**
 * @author Masayuki Morisita
 */
class RoundedCornerButton extends JButton {
	private static final float arcwidth = 8;
	private static final float archeight = 8;
	protected static final int focusstroke = 0;
	protected Shape shape;
	protected Shape border;
	protected Shape base;

	public RoundedCornerButton(String text) {
		super(text);
		setMargin(new Insets(2, 2, 2, 2));
		setContentAreaFilled(false);
		setBackground(new Color(250, 250, 250));
		initShape();
	}

	public RoundedCornerButton(String text, Color bgColor) {
		super(text);
		setMargin(new Insets(2, 2, 2, 2));
		setContentAreaFilled(false);
		setBackground(bgColor);
		initShape();
	}

	public RoundedCornerButton(String text, ImageIcon icon) {
		super(text, icon);
		setMargin(new Insets(2, 2, 2, 2));
		setContentAreaFilled(false);
		setBackground(new Color(250, 250, 250));
		initShape();
	}

	public RoundedCornerButton(String text, ImageIcon icon, Color bgColor) {
		super(text, icon);
		setMargin(new Insets(4, 4, 4, 4));
		setContentAreaFilled(false);
		setBackground(bgColor);
		initShape();
	}

	protected void initShape() {
		if (!getBounds().equals(base)) {
			base = getBounds();
			shape = new RoundRectangle2D.Float(0, 0, getWidth() - 1,
					getHeight() - 1, arcwidth, archeight);
			border = new RoundRectangle2D.Float(focusstroke, focusstroke,
					getWidth() - 1 - focusstroke * 2, getHeight() - 1
							- focusstroke * 2, arcwidth, archeight);
		}
	}

	protected void paintComponent(Graphics g) {
		initShape();
		Graphics2D g2 = (Graphics2D) g;
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		if (getModel().isArmed()) {
			Color bgc = getBackground();
			Color newCenterColor = new Color((int) (bgc.getRed() * 0.9),
					(int) (bgc.getGreen() * 0.9), (int) (bgc.getBlue() * 0.9));
			g2.setPaint(new GradientPaint(0, getHeight() / 2, newCenterColor,
					0, getHeight(), getBackground(), true));
			g2.fill(shape);

			g2
					.setPaint(new GradientPaint(0, getHeight() / 2, new Color(
							0, 120, 180), getWidth(), getHeight(), new Color(0,
							100, 150), true));
			g2.draw(shape);
		} else if (isRolloverEnabled() && getModel().isRollover()) {
			g2.setPaint(new GradientPaint(0, getHeight() / 2, getBackground(),
					0, getHeight(), getBackground().brighter(), true));
			g2.fill(border);

			g2
					.setPaint(new GradientPaint(0, getHeight() / 2, new Color(
							0, 120, 180), getWidth(), getHeight(), new Color(0,
							100, 150), true));
			g2.draw(shape);

		} else if (hasFocus()) {

		} else {
			g2.setColor(getBackground());
			g2.fill(shape);
		}
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_OFF);
		g2.setColor(getBackground());
		super.paintComponent(g2);
	}

	private void paintFocusAndRollover(Graphics2D g2, Color color) {
		g2.setColor(getBackground());
		g2.fill(border);

		g2.setColor(Color.BLACK);
		g2.draw(shape);
	}

	protected void paintBorder(Graphics g) {
	}

	public boolean contains(int x, int y) {
		initShape();
		return shape.contains(x, y);
	}
}
