/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker.unit;

import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.swing.ImageIcon;
import net.wasamon.mics.architecturemaker.ActionButtonPanel;
import net.wasamon.mics.architecturemaker.CanvasViewPort;
import net.wasamon.mics.architecturemaker.ConfigFileEditor;
import net.wasamon.mics.architecturemaker.unit.AppearanceAttribute;
import net.wasamon.mics.architecturemaker.unit.HardwareUnit;
import net.wasamon.mics.architecturemaker.unit.HardwareUnitManager;
import net.wasamon.mics.architecturemaker.unit.HardwareUnitPropertyTable;
import net.wasamon.mics.architecturemaker.unit.MicsNode;

public class Mediator {
    private HardwareUnit[] copyBuffer;
    private boolean modified = false;
    private HashMap<AppearanceAttribute, Image> imageTable = new HashMap();
    public static final String undefinedImageFile = "icons/unit/pw_hatena1_8.gif";
    private static Mediator instance = new Mediator();

    private Mediator() {
    }

    public static Mediator getInstance() {
        return instance;
    }

    public void setValue(MicsNode micsNode, String string, String string2) {
        if (string.equals("image") && micsNode instanceof AppearanceAttribute) {
            this.setImage((AppearanceAttribute)micsNode, string2);
        } else if ((string.equals("width") || string.equals("height")) && micsNode instanceof AppearanceAttribute) {
            HardwareUnitManager.getInstance().setValue(micsNode, string, string2);
            this.setImage((AppearanceAttribute)micsNode, string2);
        } else {
            HardwareUnitManager.getInstance().setValue(micsNode, string, string2);
        }
        this.update(false, true, true);
    }

    public Image getImage(AppearanceAttribute appearanceAttribute) {
        return this.imageTable.get(appearanceAttribute);
    }

    public void setImage(AppearanceAttribute appearanceAttribute, String string) {
        Image image = null;
        try {
            image = new ImageIcon(this.getClass().getClassLoader().getResource(string)).getImage();
            appearanceAttribute.setValue("image", string);
        }
        catch (NullPointerException nullPointerException) {
            image = new ImageIcon(this.getClass().getClassLoader().getResource(undefinedImageFile)).getImage();
            appearanceAttribute.setValue("image", undefinedImageFile);
        }
        this.imageTable.put(appearanceAttribute, new ImageIcon(image.getScaledInstance((int)((double)appearanceAttribute.getWidth() * ((double)this.getCanvasScale() / 100.0)), (int)((double)appearanceAttribute.getHeight() * ((double)this.getCanvasScale() / 100.0)), 4)).getImage());
    }

    public void removeChild(MicsNode micsNode, String string) {
        micsNode.removeChild(string);
        this.update(true, true, true);
    }

    public void addUnit(HardwareUnit hardwareUnit) {
        HardwareUnitManager.getInstance().addUnit(hardwareUnit);
        HardwareUnitManager.getInstance().clearSelectedUnits();
        HardwareUnitManager.getInstance().select(hardwareUnit);
        this.setImage(hardwareUnit.appearance, hardwareUnit.appearance.get("image"));
        this.update(true, true, true);
    }

    public HardwareUnit[] getAllUnits() {
        return HardwareUnitManager.getInstance().getAllUnits();
    }

    public HardwareUnit[] getSelectedUnits() {
        return HardwareUnitManager.getInstance().getSelectedUnits();
    }

    public void clearAllUnits() {
        HardwareUnitManager.getInstance().clearAllUnits();
        this.copyBuffer = null;
        this.update(true, true, true);
    }

    public void clearSelectedUnits() {
        HardwareUnitManager.getInstance().clearSelectedUnits();
        this.update(true, true, true);
    }

    public void deselect(HardwareUnit hardwareUnit) {
        HardwareUnitManager.getInstance().deselect(hardwareUnit);
        this.update(true, true, true);
    }

    public void select(HardwareUnit hardwareUnit) {
        HardwareUnitManager.getInstance().select(hardwareUnit);
        this.update(true, true, true);
    }

    public void selectAll() {
        HardwareUnitManager.getInstance().selectAll();
        this.update(true, true, true);
    }

    public boolean copyBufferIsEmpty() {
        return this.copyBuffer == null;
    }

    public void copyUnits(HardwareUnit[] hardwareUnitArray) {
        if (hardwareUnitArray != null && hardwareUnitArray.length != 0) {
            this.copyBuffer = HardwareUnitManager.getInstance().copy(hardwareUnitArray);
        }
        this.update(true, false, false);
    }

    public void pasteUnits() {
        int n;
        if (this.copyBufferIsEmpty() || this.copyBuffer.length == 0) {
            this.copyBuffer = null;
            return;
        }
        for (n = 0; n < this.copyBuffer.length; ++n) {
            HardwareUnit hardwareUnit = this.copyBuffer[n];
            HardwareUnitManager.getInstance().addUnit(hardwareUnit);
            this.setImage(hardwareUnit.appearance, hardwareUnit.appearance.get("image"));
        }
        HardwareUnitManager.getInstance().clearSelectedUnits();
        for (n = this.copyBuffer.length - 1; n >= 0; --n) {
            HardwareUnitManager.getInstance().select(this.copyBuffer[n]);
        }
        this.copyBuffer = null;
        this.update(true, true, true);
    }

    public void deleteUnits(HardwareUnit[] hardwareUnitArray) {
        HardwareUnitManager.getInstance().deleteUnits(hardwareUnitArray);
        this.update(true, true, true);
    }

    public void addInitFile(HardwareUnit hardwareUnit, String string, String string2) {
        HardwareUnitManager.getInstance().addInitFile(hardwareUnit, string, string2);
        this.update(false, true, false);
    }

    public int getUnitsCount() {
        return HardwareUnitManager.getInstance().getUnitsCount();
    }

    public int getSelectedUnitsCount() {
        return HardwareUnitManager.getInstance().getSelectedUnitsCount();
    }

    public boolean selectedUnit(HardwareUnit hardwareUnit) {
        return HardwareUnitManager.getInstance().selectedUnit(hardwareUnit);
    }

    public void disconnectUnits(HardwareUnit[] hardwareUnitArray) {
        HardwareUnitManager.getInstance().disconnectUnits(hardwareUnitArray);
        this.update(false, false, true);
    }

    public int getCanvasWidth() {
        return CanvasViewPort.getInstance().getSize().width;
    }

    public int getCanvasHeight() {
        return CanvasViewPort.getInstance().getSize().height;
    }

    public int getCanvasScale() {
        return CanvasViewPort.getInstance().getScale();
    }

    public void setCanvasScale(int n) {
        CanvasViewPort.getInstance().setScale(n);
        HardwareUnit[] hardwareUnitArray = this.getAllUnits();
        for (int i = 0; i < hardwareUnitArray.length; ++i) {
            this.setImage(hardwareUnitArray[i].appearance, hardwareUnitArray[i].getImageFile());
        }
        this.update(false, false, true);
    }

    public void adjustUnitPositions(HardwareUnit[] hardwareUnitArray) {
        CanvasViewPort.getInstance().adjustUnitPositions(hardwareUnitArray);
        this.update(false, true, true);
    }

    public void printXML(OutputStream outputStream) throws IOException {
        HardwareUnitManager.getInstance().printXML(outputStream);
    }

    public void convert() {
        ConfigFileEditor.getInstance().convert();
    }

    public HardwareUnit getUnit(String string) {
        return HardwareUnitManager.getInstance().getUnit(string);
    }

    public boolean modified() {
        return this.modified;
    }

    public void setModification(boolean bl) {
        this.modified = bl;
    }

    public void update(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            ActionButtonPanel.getInstance().updateButtonsState();
        }
        if (bl2) {
            HardwareUnitPropertyTable.getInstance().showPropertyTable();
        }
        if (bl3) {
            CanvasViewPort.getInstance().repaint();
        }
        this.modified = true;
    }
}

