/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.wasamon.mics.architecturemaker.CanvasViewPort;
import net.wasamon.mics.architecturemaker.Ghost;
import net.wasamon.mics.architecturemaker.HauntedMansion;
import net.wasamon.mics.architecturemaker.unit.DataBuffer;
import net.wasamon.mics.architecturemaker.unit.HardwareUnit;
import net.wasamon.mics.architecturemaker.unit.InitAttribute;
import net.wasamon.mics.architecturemaker.unit.Mediator;
import net.wasamon.mics.architecturemaker.unit.MicsNode;

public class VirtualCanvas
implements ActionListener {
    private static final int NONE_MODE = 0;
    private static final int CONNECTION_MODE = 1;
    private static final int SELECTION_MODE = 2;
    private static final int MOVEMENT_MODE = 3;
    private Point actionFrom;
    private Point actionTo;
    private Dimension canvasSize;
    private HauntedMansion mansion;
    private int currentKey = 48;
    private int pitch = 25;
    private int actionMode = 0;
    private int scale = 100;
    private Mediator mediator;

    public VirtualCanvas(int n, int n2) {
        this.canvasSize = new Dimension(n, n2);
        this.mediator = Mediator.getInstance();
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public int getWidth() {
        return this.canvasSize.width;
    }

    public int getHeight() {
        return this.canvasSize.height;
    }

    public void showPopup(JComponent jComponent, Point point) {
        JMenuItem jMenuItem = new JMenuItem("Add Init File");
        JMenuItem jMenuItem2 = new JMenuItem("Cut");
        JMenuItem jMenuItem3 = new JMenuItem("Copy");
        JMenuItem jMenuItem4 = new JMenuItem("Paste");
        JMenuItem jMenuItem5 = new JMenuItem("Delete");
        JMenuItem jMenuItem6 = new JMenuItem("Select All");
        jMenuItem.addActionListener(this);
        jMenuItem2.addActionListener(this);
        jMenuItem3.addActionListener(this);
        jMenuItem4.addActionListener(this);
        jMenuItem5.addActionListener(this);
        jMenuItem6.addActionListener(this);
        HardwareUnit[] hardwareUnitArray = this.mediator.getSelectedUnits();
        boolean bl = false;
        for (int i = 0; i < hardwareUnitArray.length; ++i) {
            if (!(hardwareUnitArray[i] instanceof DataBuffer)) continue;
            bl = true;
            break;
        }
        jMenuItem4.setEnabled(!this.mediator.copyBufferIsEmpty());
        if (hardwareUnitArray.length == 0) {
            jMenuItem2.setEnabled(false);
            jMenuItem5.setEnabled(false);
            jMenuItem3.setEnabled(false);
        }
        if (this.mediator.getUnitsCount() == 0) {
            jMenuItem6.setEnabled(false);
        }
        JMenu jMenu = new JMenu("Disconnect from");
        JMenu jMenu2 = new JMenu("Remove Init File");
        if (hardwareUnitArray.length == 1) {
            Object object;
            int n;
            if (!(hardwareUnitArray[0] instanceof DataBuffer)) {
                jMenuItem.setEnabled(false);
            }
            for (n = 0; n < hardwareUnitArray[0].connectedUnits().size(); ++n) {
                object = new JMenuItem(hardwareUnitArray[0].connectedUnits().get(n).getID());
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        HardwareUnit[] hardwareUnitArray = new HardwareUnit[]{VirtualCanvas.this.mediator.getSelectedUnits()[0], VirtualCanvas.this.mediator.getUnit(actionEvent.getActionCommand())};
                        VirtualCanvas.this.mediator.disconnectUnits(hardwareUnitArray);
                    }
                });
                jMenu.add((JMenuItem)object);
            }
            for (n = 0; n < hardwareUnitArray[0].childList().size(); ++n) {
                Object object2;
                object = hardwareUnitArray[0].childList().get(n);
                if (!(object instanceof InitAttribute)) continue;
                Iterator<Map.Entry<String, StringBuilder>> iterator = ((MicsNode)object).attributeTable().entrySet().iterator();
                String string = ((MicsNode)object).getTag() + " ";
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    string = string + (String)object2.getKey() + "=\"" + object2.getValue() + "\" ";
                }
                object2 = new JMenuItem(string);
                ((AbstractButton)object2).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        VirtualCanvas.this.mediator.removeChild(VirtualCanvas.this.mediator.getSelectedUnits()[0], actionEvent.getActionCommand());
                    }
                });
                jMenu2.add((JMenuItem)object2);
            }
            if (jMenu.getMenuComponentCount() == 0) {
                jMenu.setEnabled(false);
            }
            if (jMenu2.getMenuComponentCount() == 0) {
                jMenu2.setEnabled(false);
            }
        } else {
            jMenuItem.setEnabled(false);
            jMenu.setEnabled(false);
            jMenu2.setEnabled(false);
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenu2);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenu);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.add(jMenuItem5);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem6);
        jPopupMenu.show(jComponent, point.x, point.y);
    }

    public void adjustUnitPositions(HardwareUnit[] hardwareUnitArray) {
        for (int i = 0; i < hardwareUnitArray.length; ++i) {
            HardwareUnit hardwareUnit = hardwareUnitArray[i];
            int n = (hardwareUnit.appearance().getX() + this.pitch / 2) / this.pitch * this.pitch;
            int n2 = (hardwareUnit.appearance().getY() + this.pitch / 2) / this.pitch * this.pitch;
            this.mediator.setValue(hardwareUnit.appearance(), "x", Integer.toString(n));
            this.mediator.setValue(hardwareUnit.appearance(), "y", Integer.toString(n2));
        }
    }

    public HardwareUnit onUnit(Point point) {
        HardwareUnit[] hardwareUnitArray = this.mediator.getAllUnits();
        for (int i = 0; i < hardwareUnitArray.length; ++i) {
            HardwareUnit hardwareUnit = hardwareUnitArray[i];
            if (!hardwareUnit.inRange(point.x, point.y)) continue;
            return hardwareUnit;
        }
        return null;
    }

    public void mousePressed(Point point) {
        HardwareUnit hardwareUnit = null;
        HardwareUnit[] hardwareUnitArray = this.mediator.getAllUnits();
        for (int i = 0; i < hardwareUnitArray.length; ++i) {
            if (!hardwareUnitArray[i].inRange(point.x, point.y)) continue;
            hardwareUnit = hardwareUnitArray[i];
            break;
        }
        if (hardwareUnit == null) {
            if (this.currentKey != 17) {
                this.mediator.clearSelectedUnits();
            }
            this.actionFrom = this.actionTo = point;
            this.actionMode = 2;
            return;
        }
        if (this.currentKey == 17) {
            if (this.mediator.selectedUnit(hardwareUnit)) {
                this.mediator.deselect(hardwareUnit);
            } else {
                this.mediator.select(hardwareUnit);
            }
            return;
        }
        if (this.currentKey == 16) {
            this.mediator.clearSelectedUnits();
            this.mediator.select(hardwareUnit);
            this.actionFrom.x = this.actionTo.x = hardwareUnit.appearance().getX();
            this.actionFrom.y = this.actionTo.y = hardwareUnit.appearance().getY();
            this.actionMode = 1;
            return;
        }
        if (!this.mediator.selectedUnit(hardwareUnit)) {
            this.mediator.clearSelectedUnits();
            this.mediator.select(hardwareUnit);
        }
        this.actionFrom = point;
        this.mansion = new HauntedMansion(this.mediator.getSelectedUnits(), 128);
        this.actionMode = 3;
    }

    public void mouseDragged(Point point) {
        this.actionTo = point;
        int n = 0;
        int n2 = 0;
        Point point2 = CanvasViewPort.getInstance().getViewPoint();
        Dimension dimension = CanvasViewPort.getInstance().getViewPortSize();
        if ((int)((double)point2.x * 100.0 / (double)this.scale) > point.x) {
            n = -20;
        } else if ((int)((double)(point2.x + dimension.width) * 100.0 / (double)this.scale) <= point.x) {
            n = 20;
        }
        if ((int)((double)point2.y * 100.0 / (double)this.scale) > point.y) {
            n2 = -20;
        } else if ((int)((double)(point2.y + dimension.height) * 100.0 / (double)this.scale) <= point.y) {
            n2 = 20;
        }
        CanvasViewPort.getInstance().translateViewPoint(n, n2);
        switch (this.actionMode) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                int n3 = this.actionTo.x - this.actionFrom.x;
                int n4 = this.actionTo.y - this.actionFrom.y;
                this.mansion.setOffset(n3, n4);
            }
        }
    }

    public void mouseReleased(Point point) {
        HardwareUnit[] hardwareUnitArray = this.mediator.getAllUnits();
        block0 : switch (this.actionMode) {
            case 1: {
                for (int i = 0; i < hardwareUnitArray.length; ++i) {
                    HardwareUnit hardwareUnit = hardwareUnitArray[i];
                    if (this.mediator.selectedUnit(hardwareUnit) || !hardwareUnit.inRange(point.x, point.y)) continue;
                    this.mediator.getSelectedUnits()[0].connect(hardwareUnit);
                    this.mediator.clearSelectedUnits();
                    this.mediator.select(hardwareUnit);
                    break block0;
                }
                break;
            }
            case 2: {
                int n = Math.min(this.actionFrom.x, this.actionTo.x);
                int n2 = Math.min(this.actionFrom.y, this.actionTo.y);
                int n3 = Math.abs(this.actionFrom.x - this.actionTo.x);
                int n4 = Math.abs(this.actionFrom.y - this.actionTo.y);
                for (int i = hardwareUnitArray.length - 1; i >= 0; --i) {
                    HardwareUnit hardwareUnit = hardwareUnitArray[i];
                    int n5 = hardwareUnit.appearance().getX();
                    int n6 = hardwareUnit.appearance().getY();
                    if (n > n5 || n5 > n + n3 || n2 > n6 || n6 > n2 + n4) continue;
                    if (this.mediator.selectedUnit(hardwareUnit)) {
                        this.mediator.deselect(hardwareUnit);
                        continue;
                    }
                    this.mediator.select(hardwareUnit);
                }
                break;
            }
            case 3: {
                HardwareUnit[] hardwareUnitArray2 = this.mansion.bodyList.toArray(new HardwareUnit[this.mansion.bodyList.size()]);
                for (int i = 0; i < hardwareUnitArray2.length; ++i) {
                    Point point2 = this.mansion.getPosition(hardwareUnitArray2[i]);
                    this.mediator.setValue(hardwareUnitArray2[i].appearance(), "x", Integer.toString(point2.x));
                    this.mediator.setValue(hardwareUnitArray2[i].appearance(), "y", Integer.toString(point2.y));
                }
                this.mansion = null;
            }
        }
        this.actionMode = 0;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            this.keyPressed(keyEvent);
        } else if (keyEvent.getID() == 402) {
            this.keyReleased(keyEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.currentKey = keyEvent.getKeyCode();
        if (this.actionMode != 0) {
            return;
        }
        switch (this.currentKey) {
            case 74: {
                if (this.mediator.getSelectedUnitsCount() == 0) {
                    CanvasViewPort.getInstance().translateViewPoint(0, 10);
                    break;
                }
                this.translateUnits(this.mediator.getSelectedUnits(), 0, 1);
                break;
            }
            case 75: {
                if (this.mediator.getSelectedUnitsCount() == 0) {
                    CanvasViewPort.getInstance().translateViewPoint(0, -10);
                    break;
                }
                this.translateUnits(this.mediator.getSelectedUnits(), 0, -1);
                break;
            }
            case 76: {
                if (this.mediator.getSelectedUnitsCount() == 0) {
                    CanvasViewPort.getInstance().translateViewPoint(10, 0);
                    break;
                }
                this.translateUnits(this.mediator.getSelectedUnits(), 1, 0);
                break;
            }
            case 72: {
                if (this.mediator.getSelectedUnitsCount() == 0) {
                    CanvasViewPort.getInstance().translateViewPoint(-10, 0);
                    break;
                }
                this.translateUnits(this.mediator.getSelectedUnits(), -1, 0);
                break;
            }
            case 89: {
                this.mediator.copyUnits(this.mediator.getSelectedUnits());
                break;
            }
            case 80: {
                this.mediator.pasteUnits();
                break;
            }
            case 88: {
                HardwareUnit[] hardwareUnitArray = this.mediator.getSelectedUnits();
                this.mediator.copyUnits(hardwareUnitArray);
                this.mediator.deleteUnits(hardwareUnitArray);
                break;
            }
            case 87: {
                int n = this.mediator.getUnitsCount();
                if (n == 0) break;
                HardwareUnit hardwareUnit = this.mediator.getAllUnits()[n - 1];
                this.mediator.clearSelectedUnits();
                this.mediator.select(hardwareUnit);
                break;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.actionMode == 2) {
            this.mediator.clearSelectedUnits();
            return;
        }
        this.actionFrom = this.actionTo = new Point(0, 0);
        this.currentKey = 48;
        this.actionMode = 0;
    }

    private void translateUnits(HardwareUnit[] hardwareUnitArray, int n, int n2) {
        for (int i = 0; i < hardwareUnitArray.length; ++i) {
            HardwareUnit hardwareUnit = hardwareUnitArray[i];
            int n3 = hardwareUnit.appearance().getX();
            int n4 = hardwareUnit.appearance().getY();
            this.mediator.setValue(hardwareUnit.appearance(), "x", Integer.toString(n3 + n));
            this.mediator.setValue(hardwareUnit.appearance(), "y", Integer.toString(n4 + n2));
        }
    }

    public void paintConnectionLines(Graphics graphics, Point point) {
        graphics.setColor(Color.black);
        HardwareUnit[] hardwareUnitArray = this.mediator.getAllUnits();
        for (int i = hardwareUnitArray.length - 1; i >= 0; --i) {
            HardwareUnit hardwareUnit = hardwareUnitArray[i];
            int n = (int)((double)(hardwareUnit.appearance().getX() * this.scale) / 100.0);
            int n2 = (int)((double)(hardwareUnit.appearance().getY() * this.scale) / 100.0);
            HardwareUnit[] hardwareUnitArray2 = hardwareUnit.getConnectedUnitList();
            for (int j = 0; j < hardwareUnitArray2.length; ++j) {
                graphics.drawLine(n - point.x, n2 - point.y, (int)((double)(hardwareUnitArray2[j].appearance().getX() * this.scale) / 100.0 - (double)point.x), (int)((double)(hardwareUnitArray2[j].appearance().getY() * this.scale) / 100.0 - (double)point.y));
            }
        }
        if (this.actionMode == 1) {
            graphics.drawLine((int)((double)(this.actionFrom.x * this.scale) / 100.0 - (double)point.x), (int)((double)(this.actionFrom.y * this.scale) / 100.0 - (double)point.y), (int)((double)(this.actionTo.x * this.scale) / 100.0 - (double)point.x), (int)((double)(this.actionTo.y * this.scale) / 100.0 - (double)point.y));
        }
    }

    public void paintUnits(Graphics graphics, Point point) {
        graphics.setColor(Color.black);
        int n = 0;
        int n2 = 0;
        HardwareUnit[] hardwareUnitArray = this.mediator.getAllUnits();
        for (int i = hardwareUnitArray.length - 1; i >= 0; --i) {
            HardwareUnit hardwareUnit = hardwareUnitArray[i];
            int n3 = (int)((double)(hardwareUnit.appearance().getWidth() * this.scale) / 100.0);
            int n4 = (int)((double)(hardwareUnit.appearance().getHeight() * this.scale) / 100.0);
            int n5 = (int)((double)(hardwareUnit.appearance().getX() * this.scale) / 100.0 - (double)(n3 / 2));
            int n6 = (int)((double)(hardwareUnit.appearance().getY() * this.scale) / 100.0 - (double)(n4 / 2));
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
            int n7 = n5 + (n3 - fontMetrics.stringWidth(hardwareUnit.getID())) / 2;
            int n8 = n6 + n4 + fontMetrics.getHeight();
            n = n5 + n3 > n ? n5 + n3 : n;
            n2 = n6 + n4 > n2 ? n6 + n4 : n2;
            graphics.drawString(hardwareUnit.getID(), n7 - point.x, n8 - point.y);
            graphics.drawImage(this.mediator.getImage(hardwareUnit.appearance()), n5 - point.x, n6 - point.y, null);
            if (!this.mediator.selectedUnit(hardwareUnit)) continue;
            graphics.drawRect(n5 - point.x, n6 - point.y, n3 - 1, n4 - 1);
        }
        this.canvasSize.width = n + 100;
        this.canvasSize.height = n2 + 100;
    }

    public void paintGhosts(Graphics graphics, Point point) {
        if (this.actionMode != 3) {
            return;
        }
        graphics.setColor(new Color(128, 128, 128));
        int n = 0;
        int n2 = 0;
        Ghost[] ghostArray = this.mansion.getGhosts();
        for (int i = ghostArray.length - 1; i >= 0; --i) {
            Ghost ghost = ghostArray[i];
            int n3 = (int)((double)(ghost.size.width * this.scale) / 100.0);
            int n4 = (int)((double)(ghost.size.height * this.scale) / 100.0);
            int n5 = (int)((double)(ghost.position.x * this.scale) / 100.0 - (double)(n3 / 2));
            int n6 = (int)((double)(ghost.position.y * this.scale) / 100.0 - (double)(n4 / 2));
            n = n5 + n3 > n ? n5 + n3 : n;
            n2 = n6 + n4 > n2 ? n6 + n4 : n2;
            graphics.drawImage(ghost.image, n5 - point.x, n6 - point.y, null);
            graphics.drawRect(n5 - point.x, n6 - point.y, n3 - 1, n4 - 1);
        }
        if (n > this.canvasSize.width) {
            this.canvasSize.width = n;
        }
        if (n2 > this.canvasSize.height) {
            this.canvasSize.height = n2;
        }
    }

    public void paintGhostLines(Graphics graphics, Point point) {
        if (this.actionMode != 3) {
            return;
        }
        graphics.setColor(new Color(128, 128, 128));
        Ghost[] ghostArray = this.mansion.getGhosts();
        for (int i = ghostArray.length - 1; i >= 0; --i) {
            Ghost ghost = ghostArray[i];
            int n = (int)((double)(ghost.position.x * this.scale) / 100.0);
            int n2 = (int)((double)(ghost.position.y * this.scale) / 100.0);
            for (int j = 0; j < ghost.connectingPoints.size(); ++j) {
                int n3 = (int)((double)(ghost.connectingPoints.get((int)j).x * this.scale) / 100.0);
                int n4 = (int)((double)(ghost.connectingPoints.get((int)j).y * this.scale) / 100.0);
                graphics.drawLine(n - point.x, n2 - point.y, n3 - point.x, n4 - point.y);
            }
        }
    }

    public void paintSelectionRectangle(Graphics graphics, Point point) {
        if (this.actionMode == 2) {
            graphics.setColor(new Color(0, 64, 255, 16));
            int n = (int)((double)(Math.min(this.actionFrom.x, this.actionTo.x) * this.scale) / 100.0);
            int n2 = (int)((double)(Math.min(this.actionFrom.y, this.actionTo.y) * this.scale) / 100.0);
            int n3 = (int)((double)(Math.abs(this.actionFrom.x - this.actionTo.x) * this.scale) / 100.0);
            int n4 = (int)((double)(Math.abs(this.actionFrom.y - this.actionTo.y) * this.scale) / 100.0);
            graphics.fillRect(n - point.x, n2 - point.y, n3 - 1, n4 - 1);
            graphics.setColor(new Color(0, 100, 255));
            graphics.drawRect(n - point.x, n2 - point.y, n3 - 1, n4 - 1);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Add Init File")) {
            this.mediator.addInitFile(this.mediator.getSelectedUnits()[0], "./init_file", "0");
        } else if (string.equals("Cut")) {
            this.mediator.copyUnits(this.mediator.getSelectedUnits());
            this.mediator.deleteUnits(this.mediator.getSelectedUnits());
        } else if (string.equals("Copy")) {
            this.mediator.copyUnits(this.mediator.getSelectedUnits());
        } else if (string.equals("Paste")) {
            this.mediator.pasteUnits();
        } else if (string.equals("Delete")) {
            this.mediator.deleteUnits(this.mediator.getSelectedUnits());
        } else if (string.equals("Select All")) {
            this.mediator.selectAll();
        }
    }
}

