/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.ArrayList;
import net.wasamon.mics.architecturemaker.unit.HardwareUnit;
import net.wasamon.mics.architecturemaker.unit.Mediator;

public class Ghost {
    public Image image;
    public Point position;
    public Dimension size;
    public ArrayList<Point> connectingPoints;

    public Ghost(HardwareUnit hardwareUnit, int n) {
        this.image = this.createTransparentImage(Mediator.getInstance().getImage(hardwareUnit.appearance()), n);
        this.position = new Point(hardwareUnit.appearance().getX(), hardwareUnit.appearance().getY());
        this.size = new Dimension(hardwareUnit.appearance().getWidth(), hardwareUnit.appearance().getHeight());
    }

    private Image createTransparentImage(Image image, int n) {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        int[] nArray = new int[n2 * n3];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n2, n3, nArray, 0, n2);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return image;
        }
        int n4 = 0xFFFFFF | n << 24;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n5 = i * n2 + j;
                nArray[n5] = nArray[n5] & n4;
            }
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n2, n3, nArray, 0, n2));
    }
}

