/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import net.wasamon.mics.architecturemaker.VirtualCanvas;
import net.wasamon.mics.architecturemaker.unit.HardwareUnit;

public class CanvasViewPort
extends JComponent
implements MouseListener,
MouseMotionListener {
    private Image offimage;
    private Graphics offg;
    private Point viewPoint;
    private Dimension viewPortSize;
    private VirtualCanvas virtualCanvas;
    private JScrollBar verticalBar;
    private JScrollBar horizontalBar;
    private static CanvasViewPort instance = new CanvasViewPort();

    private CanvasViewPort() {
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setFocusTraversalKeysEnabled(false);
        this.viewPoint = new Point(0, 0);
        this.viewPortSize = new Dimension(this.getWidth(), this.getHeight());
        this.virtualCanvas = new VirtualCanvas(this.viewPortSize.width, this.viewPortSize.height);
        this.setLayout(new BorderLayout());
        this.verticalBar = new JScrollBar(1, 0, 10, 0, 100);
        this.horizontalBar = new JScrollBar(0, 0, 10, 0, 100);
        this.add((Component)this.verticalBar, "East");
        this.add((Component)this.horizontalBar, "South");
        this.horizontalBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                CanvasViewPort.this.translateViewPoint(CanvasViewPort.this.horizontalBar.getValue() - ((CanvasViewPort)CanvasViewPort.this).viewPoint.x, 0);
                CanvasViewPort.this.repaint();
            }
        });
        this.verticalBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                CanvasViewPort.this.translateViewPoint(0, CanvasViewPort.this.verticalBar.getValue() - ((CanvasViewPort)CanvasViewPort.this).viewPoint.y);
                CanvasViewPort.this.repaint();
            }
        });
    }

    public static CanvasViewPort getInstance() {
        return instance;
    }

    public Point getViewPoint() {
        return new Point(this.viewPoint);
    }

    public Dimension getViewPortSize() {
        return new Dimension(this.viewPortSize);
    }

    public void translateViewPoint(int n, int n2) {
        if (n > 0) {
            if (this.viewPoint.x + n <= this.virtualCanvas.getWidth() - this.viewPortSize.width) {
                this.viewPoint.translate(n, 0);
            }
        } else if (0 <= this.viewPoint.x + n) {
            this.viewPoint.translate(n, 0);
        }
        if (n2 > 0) {
            if (this.viewPoint.y + n2 <= this.virtualCanvas.getHeight() - this.viewPortSize.height) {
                this.viewPoint.translate(0, n2);
            }
        } else if (0 <= this.viewPoint.y + n2) {
            this.viewPoint.translate(0, n2);
        }
    }

    public void setScale(int n) {
        this.virtualCanvas.setScale(n);
    }

    public int getScale() {
        return this.virtualCanvas.getScale();
    }

    public void adjustUnitPositions(HardwareUnit[] hardwareUnitArray) {
        this.virtualCanvas.adjustUnitPositions(hardwareUnitArray);
    }

    public Point getVirtualMousePosition(Point point) {
        int n = (int)((double)(point.x + this.viewPoint.x) * 100.0 / (double)this.virtualCanvas.getScale());
        int n2 = (int)((double)(point.y + this.viewPoint.y) * 100.0 / (double)this.virtualCanvas.getScale());
        return new Point(n, n2);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.virtualCanvas.showPopup(this, point);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        mouseEvent.getPoint().move(0, 0);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
        Point point = this.getVirtualMousePosition(mouseEvent.getPoint());
        this.virtualCanvas.mousePressed(point);
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = this.getVirtualMousePosition(mouseEvent.getPoint());
        this.virtualCanvas.mouseDragged(point);
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Point point = this.getVirtualMousePosition(mouseEvent.getPoint());
        this.virtualCanvas.mouseReleased(point);
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = this.getVirtualMousePosition(mouseEvent.getPoint());
        if (this.virtualCanvas.onUnit(point) != null) {
            this.setCursor(new Cursor(12));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            this.virtualCanvas.keyPressed(keyEvent);
        } else if (keyEvent.getID() == 402) {
            this.virtualCanvas.keyReleased(keyEvent);
        }
        this.repaint();
    }

    private void paintScrollBar() {
        int n = Math.max(this.viewPoint.x + this.viewPortSize.width, this.virtualCanvas.getWidth());
        this.horizontalBar.setValues(this.viewPoint.x, this.viewPortSize.width, 0, n);
        int n2 = Math.max(this.viewPoint.y + this.viewPortSize.height, this.virtualCanvas.getHeight());
        this.verticalBar.setValues(this.viewPoint.y, this.viewPortSize.height, 0, n2);
    }

    public void update(Graphics graphics) {
        this.paintComponent(graphics);
    }

    public void paintComponent(Graphics graphics) {
        if (this.offimage == null || this.viewPortSize.width != this.getWidth() || this.viewPortSize.height != this.getHeight()) {
            this.offimage = this.createImage(this.getWidth(), this.getHeight());
            this.offg = this.offimage.getGraphics();
            this.viewPortSize.width = this.getWidth();
            this.viewPortSize.height = this.getHeight();
            this.offg.setFont(new Font("Dialog", 1, 12));
        }
        this.offg.setColor(Color.white);
        this.offg.fillRect(0, 0, this.viewPortSize.width, this.viewPortSize.height);
        this.virtualCanvas.paintConnectionLines(this.offg, this.viewPoint);
        this.virtualCanvas.paintGhostLines(this.offg, this.viewPoint);
        this.virtualCanvas.paintUnits(this.offg, this.viewPoint);
        this.virtualCanvas.paintGhosts(this.offg, this.viewPoint);
        this.virtualCanvas.paintSelectionRectangle(this.offg, this.viewPoint);
        this.paintScrollBar();
        graphics.drawImage(this.offimage, 0, 0, this);
    }
}

