/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationEditor
extends ExprEditor {
    private static final Logger log = Logger.getLogger(TranslationEditor.class);
    private final CtClass ctClass;
    private boolean isEdited;

    public TranslationEditor(CtClass ctClass) {
        this.ctClass = ctClass;
    }

    public void edit(MethodCall methodCall) throws CannotCompileException {
        String calleeClassName = methodCall.getClassName();
        String calleeMethodName = methodCall.getMethodName();
        AspectMapping mapping = AspectMapping.getInstance();
        if (!mapping.containesMethodCall(calleeClassName, calleeMethodName)) {
            return;
        }
        JointPoint calleeJP = new JointPoint();
        calleeJP.setEditPoint(JointPoint.EditPoint.CALL);
        calleeJP.setClassName(calleeClassName);
        calleeJP.setMethodName(calleeMethodName);
        try {
            CtMethod calleeMethod = methodCall.getMethod();
            calleeJP.setDescriptor(calleeMethod.getMethodInfo().getDescriptor());
        }
        catch (NotFoundException e) {
            log.warn("\u30af\u30e9\u30b9\u30d1\u30b9\u306a\u3057\u3002" + calleeClassName + " \u2190 " + this.ctClass.getName());
            return;
        }
        PointCut pointCut = mapping.getPointCut(calleeJP);
        if (pointCut == null) {
            return;
        }
        if (pointCut.getExcludeTrace().size() > 0 || pointCut.getIncludeTrace().size() > 0) {
            throw new IllegalStateException("editPoint \u304c call \u306e\u5834\u5408\u3001*cludeTrace \u5c5e\u6027\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + pointCut);
        }
        CtBehavior callerMethod = methodCall.where();
        if (this.contains(pointCut.getExcludeWheres(), callerMethod)) {
            return;
        }
        List<JointPoint> includeWheres = pointCut.getIncludeWheres();
        if (includeWheres.size() > 0 && !this.contains(includeWheres, callerMethod)) {
            return;
        }
        String advice = pointCut.getAdvice();
        if (advice.contains("?{JOINT_POINT}")) {
            JointPoint jointPoint = new JointPoint();
            jointPoint.setEditPoint(JointPoint.EditPoint.CALL);
            jointPoint.setClassName(callerMethod.getDeclaringClass().getName());
            jointPoint.setMethodName(callerMethod.getName());
            jointPoint.setDescriptor(callerMethod.getMethodInfo().getDescriptor());
            advice = this.replaceJointPoint(advice, jointPoint);
        }
        methodCall.replace(advice);
        this.isEdited = true;
    }

    private boolean contains(List<JointPoint> jointPointList, CtBehavior callerMethod) {
        String callerClassName = callerMethod.getDeclaringClass().getName();
        String callerMethodName = callerMethod.getName();
        for (JointPoint jointPoint : jointPointList) {
            String mName;
            if (!callerClassName.startsWith(jointPoint.getClassName()) || (mName = jointPoint.getMethodName()) != null && !callerMethodName.equals(mName)) continue;
            return true;
        }
        return false;
    }

    private String replaceJointPoint(String advice, JointPoint jointPoint) {
        String replacement = Matcher.quoteReplacement("new " + JointPoint.class.getName() + "(" + JointPoint.EditPoint.class.getName() + "." + jointPoint.getEditPoint().name() + ",\"" + jointPoint.getClassName() + "\"" + ",\"" + jointPoint.getMethodName() + "\"" + ",\"" + jointPoint.getDescriptor() + "\"" + ")");
        return advice.replaceAll("\\?\\{JOINT_POINT\\}", replacement);
    }

    public void editBehavior(CtBehavior ctBehavior) throws CannotCompileException {
        String className = this.ctClass.getName();
        String methodName = ctBehavior.getName();
        JointPoint jointPoint = new JointPoint();
        jointPoint.setEditPoint(JointPoint.EditPoint.EXECUTION);
        jointPoint.setClassName(className);
        jointPoint.setMethodName(methodName);
        jointPoint.setDescriptor(ctBehavior.getMethodInfo().getDescriptor());
        AspectMapping mapping = AspectMapping.getInstance();
        PointCut pointCut = mapping.getPointCut(jointPoint);
        if (pointCut == null) {
            return;
        }
        if (pointCut.getExcludeWheres().size() > 0 || pointCut.getIncludeWheres().size() > 0) {
            throw new IllegalStateException("editPoint \u304c execution \u306e\u5834\u5408\u3001*cludeWhere \u5c5e\u6027\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + pointCut);
        }
        PointCut.Timing timing = pointCut.getTiming();
        String advice = pointCut.getAdvice();
        if (advice.contains("?{JOINT_POINT}")) {
            advice = this.replaceJointPoint(advice, jointPoint);
        } else if (pointCut.getExcludeTrace().size() > 0 || pointCut.getIncludeTrace().size() > 0) {
            throw new IllegalStateException("*cludeTrace \u3092\u6307\u5b9a\u3057\u3066\u3044\u308b\u5834\u5408\u306f Advice \u306b ?{JOINT_POINT} \u304c\u542b\u307e\u308c\u3066\u3044\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" + jointPoint);
        }
        if (timing == PointCut.Timing.BEFORE) {
            ctBehavior.insertBefore(advice);
        } else if (timing == PointCut.Timing.AFTER) {
            ctBehavior.insertAfter(advice);
        } else {
            throw new IllegalStateException("\u7de8\u96c6\u30dd\u30a4\u30f3\u30c8\u304c execution \u306e\u5834\u5408\u3001timing \u306f before \u307e\u305f\u306f after \u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" + jointPoint);
        }
        this.isEdited = true;
    }

    public byte[] toBytecode() throws IOException, CannotCompileException {
        return this.isEdited ? this.ctClass.toBytecode() : null;
    }
}

