/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.awt.Toolkit;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.Instrumentation;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import jp.sourceforge.mergedoc.pleiades.aspect.ITimingLogger;
import jp.sourceforge.mergedoc.pleiades.aspect.LauncherLoggingTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.LauncherTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.PleiadesOption;
import jp.sourceforge.mergedoc.pleiades.aspect.SafetyExecutorService;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.log.PopupFileLogger;
import jp.sourceforge.mergedoc.pleiades.util.FastProperties;
import jp.sourceforge.mergedoc.pleiades.util.Files;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pleiades {
    private static Logger log;
    private static OS os;
    private static PleiadesOption pleiadesOption;
    private static File pleiadesConfigurationPath;
    private static File eclipseHome;
    private static Instrumentation instrumentation;
    private static ExecutorService executorService;
    private static List<ITimingLogger> timeingLoggers;

    public static void premain(String option, Instrumentation inst) throws Throwable {
        try {
            pleiadesOption = new PleiadesOption(option);
            instrumentation = inst;
            Pleiades.init();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        try {
            executorService = new SafetyExecutorService();
            executorService.execute(new Runnable(){

                public void run() {
                    try {
                        Pleiades.initSwingFont();
                    }
                    catch (Throwable e) {
                        log.debug("Swing \u306e LookAndFeel \u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e);
                    }
                }
            });
            if (log.isDebugEnabled()) {
                inst.addTransformer(new LauncherLoggingTransformer());
            } else {
                inst.addTransformer(new LauncherTransformer());
            }
            log.info("Pleiades AOP \u7ffb\u8a33\u30b3\u30f3\u30c6\u30ca\u30fc\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002Pleiades \u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3:" + option);
        }
        catch (Throwable e) {
            Pleiades.abort(e);
        }
    }

    private static void init() throws UnsupportedEncodingException {
        File baseDir;
        Object base;
        Matcher mat;
        String osName = System.getProperty("os.name", "").toLowerCase();
        os = osName.contains("mac") ? OS.MAC : (osName.contains("windows") ? OS.WINDOWS : OS.LINUX);
        File configIniFile = Pleiades.getConfigIniFile();
        File configPath = configIniFile.getParentFile();
        eclipseHome = configPath.getParentFile();
        String CONFIG_AREA_KEY = "osgi.configuration.area";
        FastProperties configIni = new FastProperties(configIniFile);
        String configArea = (String)configIni.get("osgi.configuration.area");
        if (configArea == null) {
            configArea = System.getProperty("osgi.configuration.area");
        }
        File userConfigPath = null;
        if (configArea != null && (mat = Pattern.compile("^@([\\w\\.]+)(.+)$").matcher(configArea)).find() && (base = System.getProperty(mat.group(1))) != null && (baseDir = new File((String)base)).exists()) {
            String childPath = mat.group(2);
            userConfigPath = new File(baseDir, childPath);
        }
        String PACKAGE_NAME = "jp.sourceforge.mergedoc.pleiades";
        if (userConfigPath != null) {
            configPath = userConfigPath;
            pleiadesConfigurationPath = new File(configPath, "jp.sourceforge.mergedoc.pleiades");
        } else if (os == OS.WINDOWS) {
            pleiadesConfigurationPath = new File(configPath, "jp.sourceforge.mergedoc.pleiades");
        } else {
            base = new File(System.getProperty("user.home"), ".eclipse/jp.sourceforge.mergedoc.pleiades");
            String instPath = eclipseHome.getPath().replace("/", "-");
            pleiadesConfigurationPath = new File((File)base, instPath);
        }
        pleiadesConfigurationPath.mkdirs();
        File logFile = new File(pleiadesConfigurationPath, "pleiades.log");
        System.setProperty("pleiades.log.file.name", logFile.getAbsolutePath());
        System.setProperty("pleiades.logger.class.name", PopupFileLogger.class.getName());
        System.setProperty("pleiades.log.level", pleiadesOption.getLogLevel());
        log = Logger.getLogger(Pleiades.class);
        String msg = "Pleiades \u69cb\u6210\u4fdd\u7ba1\u30d1\u30b9: " + pleiadesConfigurationPath;
        System.out.println(msg);
        log.info(msg);
        log.debug("Eclipse \u30db\u30fc\u30e0: " + eclipseHome);
    }

    private static File getConfigIniFile() {
        File pleiadesDir;
        String CONFIG_INI = "config.ini";
        String CONFIG_DIR_INI = "configuration/config.ini";
        File configIniFile = new File(System.getProperty("user.dir"), "configuration/config.ini");
        if (configIniFile.exists()) {
            return configIniFile;
        }
        File dir = pleiadesDir = Files.resourceRoot.getParentFile().getParentFile().getParentFile();
        while (dir != null) {
            configIniFile = new File(dir, "configuration/config.ini");
            if (configIniFile.exists()) {
                return configIniFile;
            }
            dir = dir.getParentFile();
        }
        dir = pleiadesDir;
        while (dir != null) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory() && (configIniFile = new File(f, "config.ini")).exists()) {
                    return configIniFile;
                }
                ++n2;
            }
            dir = dir.getParentFile();
        }
        throw new IllegalStateException("config.ini \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
    }

    private static void initSwingFont() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        if (os != OS.WINDOWS) {
            return;
        }
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        FontUIResource propoFont = new FontUIResource("MS UI Gothic", 0, 12);
        FontUIResource fixedFont = new FontUIResource("MS Gothic", 0, 12);
        for (Object keyObj : UIManager.getLookAndFeelDefaults().keySet()) {
            String key = keyObj.toString();
            if (!key.endsWith("font") && !key.endsWith("Font")) continue;
            UIManager.put(key, propoFont);
        }
        UIManager.put("TextPane.font", fixedFont);
        UIManager.put("TextArea.font", fixedFont);
    }

    public static void abort(Throwable e) {
        try {
            log.fatal("Pleiades AOP \u7ffb\u8a33\u30b3\u30f3\u30c6\u30ca\u30fc\u306e\u8d77\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u306b -clean \u3092\u6307\u5b9a\u3057\u3066\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\u3002", e);
            executorService.shutdownNow();
        }
        finally {
            System.exit(-1);
        }
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public static PleiadesOption getPleiadesOption() {
        return pleiadesOption;
    }

    public static File getConfigurationPath() {
        return pleiadesConfigurationPath;
    }

    public static File getEclipseHome() {
        return eclipseHome;
    }

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    public static boolean isWindows() {
        return os == OS.WINDOWS;
    }

    public static void registTimingLogger(ITimingLogger timeingLogger) {
        Pleiades.getTimeingLoggers().add(timeingLogger);
    }

    public static List<ITimingLogger> getTimeingLoggers() {
        if (timeingLoggers == null) {
            timeingLoggers = new LinkedList<ITimingLogger>();
        }
        return timeingLoggers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OS {
        LINUX,
        MAC,
        WINDOWS;

    }
}

