/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.aspect.AbstractTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.ExcludesClassNameCache;
import jp.sourceforge.mergedoc.pleiades.aspect.LauncherLoggingTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.MetadataDefaultInitializer;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.PleiadesOption;
import jp.sourceforge.mergedoc.pleiades.aspect.TranslationLoggingTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.TranslationTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationExcludeProperties;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FastProperties;
import jp.sourceforge.mergedoc.pleiades.util.Files;

public class LauncherTransformer
extends AbstractTransformer {
    private static final Logger log = Logger.getLogger(LauncherTransformer.class);
    private final String transformerClass;

    public LauncherTransformer() {
        this.load();
        this.transformerClass = this.getClass().getName();
    }

    protected void load() {
        AspectMapping.getInstance();
        Pleiades.getExecutorService().execute(new Runnable(){

            public void run() {
                TranslationExcludeProperties.getInstance();
                RegexDictionary.getInstance();
            }
        });
    }

    protected byte[] transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        if (className.endsWith(".launcher.Main")) {
            return this.transformMainClass(protectionDomain, bytecode);
        }
        if (className.equals("org.eclipse.ui.internal.Workbench")) {
            ExecutorService executorService = Pleiades.getExecutorService();
            executorService.execute(new Runnable(){

                public void run() {
                    MetadataDefaultInitializer.init();
                }
            });
            executorService.shutdown();
            return this.transformWorkbenchClass(protectionDomain, bytecode);
        }
        if (className.equals("org.eclipse.ui.internal.WorkbenchWindow")) {
            Pleiades.getInstrumentation().removeTransformer(this);
            return this.transformWorkbenchWindowClass(protectionDomain, bytecode);
        }
        return null;
    }

    protected byte[] transformMainClass(ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        String splashLocation;
        CtClass clazz = this.createCtClass(bytecode, protectionDomain);
        CtMethod method = clazz.getMethod("basicRun", "([Ljava/lang/String;)V");
        method.insertBefore("$1 = " + this.transformerClass + ".startTranslationTransformer($$);");
        PleiadesOption agentOption = Pleiades.getPleiadesOption();
        if (!agentOption.isDefaultSplash() && (splashLocation = LauncherTransformer.getSplashLocation()) != null) {
            System.setProperty("osgi.splashLocation", splashLocation);
        }
        return clazz.toBytecode();
    }

    protected byte[] transformWorkbenchClass(ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        CtClass clazz = this.createCtClass(bytecode, protectionDomain);
        CtMethod shutdown = clazz.getMethod("shutdown", "()V");
        shutdown.insertBefore(String.valueOf(this.transformerClass) + ".destroy();");
        CtMethod runEventLoop = clazz.getMethod("runEventLoop", "(Lorg/eclipse/jface/window/Window$IExceptionHandler;Lorg/eclipse/swt/widgets/Display;)V");
        runEventLoop.insertBefore(String.valueOf(this.transformerClass) + ".beforeEventLoop($0);");
        return clazz.toBytecode();
    }

    protected byte[] transformWorkbenchWindowClass(ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        CtClass clazz = this.createCtClass(bytecode, protectionDomain);
        CtMethod restore = clazz.getMethod("restoreState", "(Lorg/eclipse/ui/IMemento;Lorg/eclipse/ui/IPerspectiveDescriptor;)Lorg/eclipse/core/runtime/IStatus;");
        restore.insertBefore(String.valueOf(this.transformerClass) + ".beforeRestoreState($1);");
        return clazz.toBytecode();
    }

    public static void beforeRestoreState(Object memento) throws Exception {
        if (LauncherTransformer.isPreload()) {
            Method putInteger = memento.getClass().getMethod("putInteger", String.class, Integer.TYPE);
            putInteger.invoke(memento, "width", 200);
            putInteger.invoke(memento, "x", -199);
        }
    }

    private static boolean isPreload() {
        return System.getProperty("pleiades.preload") != null;
    }

    public static void beforeEventLoop(Object workbench) throws Exception {
        if (log.isDebugEnabled()) {
            LauncherLoggingTransformer.logUpTime();
            FastProperties systemProp = new FastProperties();
            systemProp.putProperties(System.getProperties());
            File file = new File(Pleiades.getConfigurationPath(), "system.properties");
            systemProp.store(file, "\u5b9f\u884c\u6642\u30b7\u30b9\u30c6\u30e0\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc");
        }
        if (LauncherTransformer.isPreload()) {
            try {
                try {
                    Method close = workbench.getClass().getMethod("close", new Class[0]);
                    close.invoke(workbench, new Object[0]);
                }
                catch (Throwable e) {
                    log.error("\u30d7\u30ea\u30ed\u30fc\u30c9\u81ea\u52d5\u7d42\u4e86\u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
                    System.exit(0);
                }
            }
            finally {
                System.exit(0);
            }
        }
    }

    public static String[] startTranslationTransformer(String ... args) {
        try {
            LinkedList<String> argList = new LinkedList<String>((Collection)Arrays.asList(args));
            PleiadesOption option = Pleiades.getPleiadesOption();
            option.setClean(argList.contains("-clean"));
            log.info("Eclipse \u306e\u8d77\u52d5\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002-clean:" + option.isClean());
            if (!option.isClean() && !ExcludesClassNameCache.file.exists()) {
                log.info("\u5909\u63db\u9664\u5916\u30af\u30e9\u30b9\u540d\u30ad\u30e3\u30c3\u30b7\u30e5\u304c\u5b58\u5728\u3057\u306a\u3044\u305f\u3081\u3001\u5f37\u5236\u7684\u306b -clean \u30e2\u30fc\u30c9\u3067\u8d77\u52d5\u3057\u307e\u3059\u3002");
                argList.add("-clean");
                option.setClean(true);
            }
            Instrumentation inst = Pleiades.getInstrumentation();
            if (log.isDebugEnabled()) {
                inst.addTransformer(new TranslationLoggingTransformer());
            } else {
                inst.addTransformer(new TranslationTransformer());
            }
            return argList.toArray(new String[argList.size()]);
        }
        catch (Throwable e) {
            String msg = "\u7ffb\u8a33\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u306e\u958b\u59cb\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            IllegalStateException ise = new IllegalStateException(msg, e);
            Pleiades.abort(ise);
            return null;
        }
    }

    public static void destroy() {
        TranslationTransformer.destroy();
    }

    public static String getSplashLocation() {
        File home = Pleiades.getEclipseHome();
        File eclipse = new File(home, "eclipse");
        File eclipseExe = new File(home, "eclipse.exe");
        if (!eclipse.exists() && !eclipseExe.exists()) {
            return null;
        }
        String version = "";
        File pluginsFolder = new File(home, "plugins");
        File[] fileArray = pluginsFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            String folderName = folder.getName();
            if (folderName.startsWith("org.eclipse.osgi_")) {
                version = folderName.replaceFirst(".*?_(\\d+\\.\\d+).*", "$1");
                break;
            }
            ++n2;
        }
        String fileName = "splash" + version + ".bmp";
        File file = Files.getResourceFile(fileName);
        if (!file.exists()) {
            fileName = "splash.bmp";
        }
        File splashFile = Files.getResourceFile(fileName);
        return splashFile.getAbsolutePath().replace('\\', '/');
    }
}

