// syntax_node.h c\؂̃f
#ifndef __MERCURY_SYNTAX_NODE__
#define __MERCURY_SYNTAX_NODE__

#include <cstddef>
#include "nfa.h"


namespace mercury
{
	////////////////////////////////////////////////////////////////////////////////
	// \؂̒ۃNX
	template<typename _Input>
	class syntax_node
	{
	public:
		syntax_node(void) {}

	public:
		// NFA\z
		virtual nfa<_Input> build_nfa(state_t &state) = 0;

		// 
		virtual void free(void) = 0;
	};

	////////////////////////////////////////////////////////////////////////////////
	// \؂̎
	// \؂deleteZqł͂Ȃfreeo֐gĉKv邽߁A
	// std::auto_ptȓɎNXg
	template<typename _Input>
	class auto_syntax_node_ptr
	{
	public:
		explicit auto_syntax_node_ptr(syntax_node<_Input> *ptr) { m_owner = true; m_ptr = ptr; }
		 auto_syntax_node_ptr(auto_syntax_node_ptr<_Input> &rhs) { m_owner = rhs.m_owner; m_ptr = rhs.m_ptr; rhs.m_owner = false; rhs.m_ptr = NULL; }
		~auto_syntax_node_ptr(void)
		{
			if(m_owner && m_ptr != NULL)
			{
				m_ptr->free();
			}
		}

	public:
		// Zq̎
		// std::auto_ptr̂悤ɔėpKvȂ킯ł͂Ȃ̂ŁAKvŏ̂̂̂ݎ
		syntax_node<_Input> *operator->(void) const { return m_ptr; }

	private:
		bool m_owner;
		syntax_node<_Input> *m_ptr;
	};
}

#endif // __MERCURY_SYNTAX_NODE__
