// syntaxer.h cK\̍\
#ifndef __MERCURY_SYNTAXER__
#define __MERCURY_SYNTAXER__

#include "regex_syntax_node.h"
#include "lexer.h"


namespace mercury
{
	// G[
	typedef enum tagREGEX_ERROR
	{
		REGERR_SYNTAX,                          // \G[
	} REGEX_ERROR;

	namespace _regex
	{
		////////////////////////////////////////////////////////////////////////////////
		// \
		// ȉŒ`镶R@ɂA\͂
		//  expression     subexpression EOF
		//  subexpression  sequence '|' subexpression | sequence
		//  sequence       subsequence | ''
		//  subsequence    loop subsequence | loop
		//  loop           factor '*' | factor '+' | factor '?' | factor
		//  factor         '(' subexpression ')' | CHARACTER

		template<typename _Input, typename _ConstIterator, typename _Traits = regex_traits<_Input> >
		class syntaxer
		{
		public:
			typedef syntax_node<_Input> *syntax_node_ptr;

		public:
			// RXgN^iwj
			syntaxer(_ConstIterator pattern_begin, _ConstIterator pattern_end) : m_lexer(pattern_begin, pattern_end)
			{
				_init(pattern_begin, pattern_end);
			}

			// ͂A\؂쐬
			syntax_node_ptr parse(void)
			{
				// \؂쐬
				return rule_expression();
			}

		private:
			lexer<_Input, _ConstIterator, _Traits> m_lexer;
			token<_Input>                          m_lookahead;

		private:
			// R@[

			// expression -> subexpression EOF
			syntax_node_ptr rule_expression(void)
			{
				// expression -> subexpression EOF
				syntax_node_ptr node = rule_subexpression();
				move(TOKEN_EOF);
				return node;
			}

			// subexpression -> sequence '|' subexpression | sequence
			syntax_node_ptr rule_subexpression(void)
			{
				syntax_node_ptr node = rule_sequence();
				if(m_lookahead.kind == TOKEN_DISJUNCTION)
				{
					// subexpression -> sequence '|' subexpression
					move();
					syntax_node_ptr node2 = rule_subexpression();
					node = new syntax_node_disjunction<_Input>(node, node2, NULL);
				}
				return node;
			}

			// sequence -> subsequence | ''
			syntax_node_ptr rule_sequence(void)
			{
				if(m_lookahead.kind == TOKEN_GROUP_BEGIN || m_lookahead.kind == TOKEN_CHARACTER)
				{
					// sequence -> subsequence
					return rule_subsequence();
				}
				else
				{
					// sequence -> ''
					return new syntax_node_none<_Input>();
				}
			}

			// subsequence -> loop subsequence | loop
			syntax_node_ptr rule_subsequence(void)
			{
				syntax_node_ptr node1 = rule_loop();
				if(m_lookahead.kind == TOKEN_GROUP_BEGIN || m_lookahead.kind == TOKEN_CHARACTER)
				{
					// subsequence -> loop subsequence
					syntax_node_ptr node2 = rule_subsequence();
					return new syntax_node_concatenate<_Input>(node1, node2, NULL);
				}
				else
				{
					// subsequence -> loop
					return node1;
				}
			}

			// loop -> factor '*' | factor '+' | factor '?' | factor
			syntax_node_ptr rule_loop(void)
			{
				syntax_node_ptr node = rule_factor();
				switch(m_lookahead.kind)
				{
				case TOKEN_LOOP0:
					// loop -> factor '*'
					move();
					node = new syntax_node_loop0<_Input>(node);
					break;
				case TOKEN_LOOP1:
					// loop -> factor '+'
					move();
					node = new syntax_node_loop1<_Input>(node);
					break;
				case TOKEN_LOOP01:
					// loop -> factor '?'
					move();
					node = new syntax_node_loop01<_Input>(node);
					break;
				}
				return node;
			}

			// factor -> '(' subexpression ')' | CHARACTER
			syntax_node_ptr rule_factor(void)
			{
				if(m_lookahead.kind == TOKEN_GROUP_BEGIN)
				{
					// factor -> '(' subexpression ')'
					move(TOKEN_GROUP_BEGIN);
					syntax_node_ptr node = rule_subexpression();
					move(TOKEN_GROUP_END);
					return node;
				}
				else
				{
					// factor -> CHARACTER
					syntax_node_ptr node = new syntax_node_character<_Input>(m_lookahead.value);
					move(TOKEN_CHARACTER);
					return node;
				}
			}

		private:
			void _init(_ConstIterator /* pattern_begin */, _ConstIterator /* pattern_end */)
			{
				move();
			}

			// g[Nǂݍ݁iG[`FbNȂj
			void move(void)
			{
				m_lookahead = m_lexer.get_token();
			}

			// g[Nǂݍ݁iG[`FbNj
			void move(const TOKEN_KIND k)
			{
				if(m_lookahead.kind != k)
				{
					throw REGERR_SYNTAX;
				}
				move();
			}
		};
	}
}

#endif // __MERCURY_SYNTAXER__
