// regex_syntax_node.h cK\p̍\
#ifndef __MERCURY_REGEX_SYNTAX_NODE__
#define __MERCURY_REGEX_SYNTAX_NODE__

#include <list>
#include <cstdarg>
#include "../syntax_node.h"


namespace mercury
{
	namespace _regex
	{
		////////////////////////////////////////////////////////////////////////////////
		// noneiȂj
		template<typename _Input>
		class syntax_node_none : public syntax_node<_Input>
		{
		public:
			syntax_node_none(void)
			{
			}

			// NFA\z
			nfa<_Input> build_nfa(state_t &state)
			{
				const state_t start = state++;
				nfa<_Input> frag(start);

				// JnԂeԂɉ
				frag.add_accept(start);
				return frag;
			}

			// 
			void free(void)
			{
				delete this;
			}
		};


		////////////////////////////////////////////////////////////////////////////////
		// characterij
		template<typename _Input>
		class syntax_node_character : public syntax_node<_Input>
		{
		public:
			syntax_node_character(const _Input &character) : m_character(character)
			{
			}

			// NFA\z
			nfa<_Input> build_nfa(state_t &state)
			{
				const state_t start = state++;
				nfa<_Input> frag(start);

				// m_characteȓJڂɂ
				const state_t accept = state++;
				frag.add_accept(accept);
				frag.connect(start, m_character, accept);

				return frag;
			}

			// 
			void free(void)
			{
				delete this;
			}

		private:
			_Input m_character;
		};


		////////////////////////////////////////////////////////////////////////////////
		// disjunctioniIj
		template<typename _Input>
		class syntax_node_disjunction : public syntax_node<_Input>
		{
		public:
			syntax_node_disjunction(syntax_node<_Input> *node, ...)
			{
				va_list ap;
				va_start(ap, node);

				syntax_node_ptr_t arg = node;
				do
				{
					m_nodes.push_back(arg);
					arg = va_arg(ap, syntax_node_ptr_t);
				}
				while(arg != NULL);
				va_end(ap);
			}

			// NFA\z
			nfa<_Input> build_nfa(state_t &state)
			{
				const state_t start = state++;
				nfa<_Input> frag(start);

				for(syntax_node_ptr_list_const_iterator_t p = m_nodes.begin(); p != m_nodes.end(); p++)
				{
					nfa<_Input> frag_x = (*p)->build_nfa(state);

					// Jڃ}bvƎeԂ}[W
					frag.merge_transition(frag_x);
					frag.merge_acccepts  (frag_x);

					// frag̊JnԂfrag_x̊JnԂɃÑJ
					frag.connect(start, frag_x.get_start());
				}
				return frag;
			}

			// 
			void free(void)
			{
				// qm[hSĉAg
				for(syntax_node_ptr_list_const_iterator_t p = m_nodes.begin(); p != m_nodes.end(); p++)
				{
					syntax_node_ptr_t node = *p;
					node->free();
				}
				delete this;
			}

		private:
			typedef syntax_node<_Input>                            *syntax_node_ptr_t;
			typedef std::list<syntax_node_ptr_t>                    syntax_node_ptr_list_t;
			typedef typename syntax_node_ptr_list_t::const_iterator syntax_node_ptr_list_const_iterator_t;
			syntax_node_ptr_list_t m_nodes;
		};


		////////////////////////////////////////////////////////////////////////////////
		// concatenateiAj
		template<typename _Input>
		class syntax_node_concatenate : public syntax_node<_Input>
		{
		public:
			syntax_node_concatenate(syntax_node<_Input> *node, ...)
			{
				va_list ap;
				va_start(ap, node);

				syntax_node_ptr_t arg = node;
				do
				{
					m_nodes.push_back(arg);
					arg = va_arg(ap, syntax_node_ptr_t);
				}
				while(arg != NULL);
				va_end(ap);
			}

			// NFA\z
			nfa<_Input> build_nfa(state_t &state)
			{
				// JnԂeԂփÑJڂA_~[NFA쐬
				const state_t start  = state++;
				const state_t accept = state++;
				nfa<_Input> frag(start);
				frag.add_accept(accept);
				frag.connect(start, accept);

				for(syntax_node_ptr_list_const_iterator_t p = m_nodes.begin(); p != m_nodes.end(); p++)
				{
					nfa<_Input> frag_x = (*p)->build_nfa(state);

					// frag̎eԂfrag_x̊JnԂփÑJ
					const state_set_t accepts = frag.get_accepts();
					for(state_set_t::const_iterator p2 = accepts.begin(); p2 != accepts.end(); p2++)
					{
						frag.connect(*p2, frag_x.get_start());
					}

					// Jڃ}bv}[W
					frag.merge_transition(frag_x);

					// frag̎eԂfrag_x̎eԂɂ
					frag.set_accepts(frag_x.get_accepts());
				}
				return frag;
			}

			// 
			void free(void)
			{
				// qm[hSĉAg
				for(syntax_node_ptr_list_const_iterator_t p = m_nodes.begin(); p != m_nodes.end(); p++)
				{
					syntax_node_ptr_t node = *p;
					node->free();
				}
				delete this;
			}

		private:
			typedef syntax_node<_Input>                            *syntax_node_ptr_t;
			typedef std::list<syntax_node_ptr_t>                    syntax_node_ptr_list_t;
			typedef typename syntax_node_ptr_list_t::const_iterator syntax_node_ptr_list_const_iterator_t;
			syntax_node_ptr_list_t m_nodes;
		};


		////////////////////////////////////////////////////////////////////////////////
		// loop0i0ȏ̌JԂj
		template<typename _Input>
		class syntax_node_loop0 : public syntax_node<_Input>
		{
		public:
			syntax_node_loop0(syntax_node<_Input> *node)
			{
				m_node = node;
			}

			// NFA\z
			nfa<_Input> build_nfa(state_t &state)
			{
				nfa<_Input> frag = m_node->build_nfa(state);

				// eԂJnԂփÑJ
				const state_t     start   = frag.get_start();
				const state_set_t accepts = frag.get_accepts();
				for(state_set_t::const_iterator p = accepts.begin(); p != accepts.end(); p++)
				{
					frag.connect(*p, start);
				}

				// 0̌JԂ邽߁AstarteԂɉ
				frag.add_accept(start);
				return frag;
			}

			// 
			void free(void)
			{
				m_node->free();
				delete this;
			}

		private:
			syntax_node<_Input> *m_node;
		};


		////////////////////////////////////////////////////////////////////////////////
		// loop1i1ȏ̌JԂj
		template<typename _Input>
		class syntax_node_loop1 : public syntax_node<_Input>
		{
		public:
			syntax_node_loop1(syntax_node<_Input> *node)
			{
				m_node = node;
			}

			// NFA\z
			nfa<_Input> build_nfa(state_t &state)
			{
				nfa<_Input> frag = m_node->build_nfa(state);

				// eԂJnԂփÑJ
				const state_t     start   = frag.get_start();
				const state_set_t accepts = frag.get_accepts();
				for(state_set_t::const_iterator p = accepts.begin(); p != accepts.end(); p++)
				{
					frag.connect(*p, start);
				}

				// loop0Ƃ͈ႢAstarteԂɉȂ
				return frag;
			}

			// 
			void free(void)
			{
				m_node->free();
				delete this;
			}

		private:
			syntax_node<_Input> *m_node;
		};


		////////////////////////////////////////////////////////////////////////////////
		// loop01i0܂1̌JԂj
		template<typename _Input>
		class syntax_node_loop01 : public syntax_node<_Input>
		{
		public:
			syntax_node_loop01(syntax_node<_Input> *node)
			{
				m_node = node;
			}

			// NFA\z
			nfa<_Input> build_nfa(state_t &state)
			{
				nfa<_Input> frag = m_node->build_nfa(state);

				// 0̌JԂ邽߁AstarteԂɉ
				frag.add_accept(frag.get_start());
				return frag;
			}

			// 
			void free(void)
			{
				m_node->free();
				delete this;
			}

		private:
			syntax_node<_Input> *m_node;
		};
	}
}

#endif // __MERCURY_REGEX_SYNTAX_NODE__
