// lexer.h cK\̎
#ifndef __MERCURY_LEXER__
#define __MERCURY_LEXER__


namespace mercury
{
	namespace _regex
	{
		// g[N̎
		typedef enum tagTOKEN_KIND
		{
			TOKEN_CHARACTER,                        // ʏ̕
			TOKEN_DISJUNCTION,                      // I
			TOKEN_LOOP0,                            // 0ȏ̌JԂ
			TOKEN_LOOP1,                            // 1ȏ̌JԂ
			TOKEN_LOOP01,                           // 0܂1̌JԂ
			TOKEN_GROUP_BEGIN,                      // O[vJn
			TOKEN_GROUP_END,                        // O[vI
			TOKEN_EOF,                              // EOF
		} TOKEN_KIND;


		// g[N\
		template<typename _Char>
		struct token
		{
			token(void) { kind = TOKEN_CHARACTER; value = _Char(); }
			token(const TOKEN_KIND k, const _Char v) { kind = k; value = v; }
			TOKEN_KIND kind;
			_Char      value;
		};

		template<typename _Char>
		class regex_traits
		{
		public:
			static _Char escape     (void) { return _Char('\\'); }
			static _Char disjunction(void) { return _Char('|'); }
			static _Char loop0      (void) { return _Char('*'); }
			static _Char loop1      (void) { return _Char('+'); }
			static _Char loop01     (void) { return _Char('?'); }
			static _Char group_begin(void) { return _Char('('); }
			static _Char group_end  (void) { return _Char(')'); }
		};

		// 
		template<typename _Char, typename _ConstIterator, typename _Traits = regex_traits<_Char> >
		class lexer
		{
		public:
			// RXgN^iwj
			lexer(_ConstIterator pattern_begin, _ConstIterator pattern_end)
				: m_pattern_begin(pattern_begin), m_pattern_end(pattern_end)
			{
				_init(pattern_begin, pattern_end);
			}


			// ̃g[N擾
			token<_Char> get_token(void)
			{
				// ̏I[
				if(m_now == m_pattern_end)
				{
					return token<_Char>(TOKEN_EOF, _Char());
				}

				const _Char ch = *m_now++;
				token<_Char> tk(TOKEN_CHARACTER, ch);

				// GXP[v
				if(ch == _Traits::escape())
				{
					if(m_now != m_pattern_end)
					{
						tk.value = *m_now++;
					}
				}
				// I
				if(ch == _Traits::disjunction())
				{
					tk.kind = TOKEN_DISJUNCTION;
				}
				// 0ȏ̌JԂ
				if(ch == _Traits::loop0())
				{
					tk.kind = TOKEN_LOOP0;
				}
				// 1ȏ̌JԂ
				if(ch == _Traits::loop1())
				{
					tk.kind = TOKEN_LOOP1;
				}
				// 0܂1̌JԂ
				if(ch == _Traits::loop01())
				{
					tk.kind = TOKEN_LOOP01;
				}
				// O[vJn
				if(ch == _Traits::group_begin())
				{
					tk.kind = TOKEN_GROUP_BEGIN;
				}
				// O[vI
				if(ch == _Traits::group_end())
				{
					tk.kind = TOKEN_GROUP_END;
				}
				return tk;
			}

		private:
			_ConstIterator m_pattern_begin;
			_ConstIterator m_pattern_end;
			_ConstIterator m_now;

			// 
			void _init(_ConstIterator begin, _ConstIterator end)
			{
				m_now = begin;
			}
		};
	}
}

#endif // __MERCURY_LEXER__
