/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.meema.util;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

/**
 * <strong> Pluginで使用するサービスクラス。</strong>
 * <p>
 * 
 * @author katsusuke
 * 
 */
public class Service {
	private FileOutputStream outFileStream;

	private OutputStreamWriter writer;

	private String encode = "UTF-8";

	/**
	 * ファイルパスからファイルへの書き込み用のBufferedWriterオブジェクトを得る。
	 * 
	 * @param filePath
	 * @return
	 * @throws IOException
	 */
	public BufferedWriter openFile(String filePath) throws IOException {
		outFileStream = new FileOutputStream(filePath);
		writer = new OutputStreamWriter(outFileStream, encode);
		return new BufferedWriter(writer);
	}

	/**
	 * openFileメソッドで使用したファイルを閉じる。
	 * 
	 * @param bufferedWriter
	 * @throws IOException
	 */
	public void closeFile(BufferedWriter bufferedWriter) throws IOException {
		bufferedWriter.close();
		writer.close();
		outFileStream.close();
	}

	/**
	 * ファイルのencodeを得る
	 * 
	 * @return
	 */
	public String getEncode() {
		return encode;
	}

	/**
	 * ファイルのencodeを設定する
	 * 
	 * @param encode
	 */
	public void setEncode(String encode) {
		this.encode = encode;
	}

}
