/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.meema.service;

import java.io.File;
import java.util.HashMap;

import jp.co.kpscorp.meema.engine.Analyzer;
import jp.co.kpscorp.meema.engine.plugin.Plugin;
import junit.framework.Assert;
import junit.framework.TestCase;

/**
 * <strong>テストに便利なメソッドを提供する。 </strong>
 * <p>
 * 
 * @author Katsusuke 作成日:2005/06/08
 */
public abstract class TestServiceSuper implements TestService {
	/**
	 * 
	 */
	public TestServiceSuper() {
		super();
		plugin = getPlugin();
	}

	private int maxDepth = -1;

	protected String srcPath;

	protected TestCase tc;

	protected String packageName;

	private String typeFilter[];

	private String propFilter[];


	private Plugin plugin;

	/**
	 * サブクラスから適切なPluginのインスタンスを得る
	 * 
	 * @return
	 */
	abstract protected Plugin getPlugin();



	/**
	 * @param plugin
	 * @param analyzer
	 */
	protected void setFilter(Plugin plugin,
			Analyzer analyzer) {
		// 各種Filterのセット
		if (typeFilter != null) {
			for (int i = 0; i < typeFilter.length; i++) {
				analyzer.setObjectFilter(typeFilter[i]);
			}
		}
		if (propFilter != null) {
			for (int i = 0; i < propFilter.length; i++) {
				analyzer.setPropFilter(propFilter[i]);
			}
		}
		if (maxDepth > 0) {
			analyzer.setMaxDepth(maxDepth);
		}
	}

	/**
	 * リアルパスのファイル名を得る
	 * 
	 * @param mtc
	 * @param fileName
	 * @return
	 */
	protected String getRealName(String fileName) {
		String filePath;
		filePath = new File(srcPath + "/x").getAbsolutePath();
		filePath = filePath.substring(0, filePath.length() - 1);
		File hld = new File(filePath);
		if (!hld.exists()) {
			hld.mkdirs();
		}
		return filePath + fileName;
	}

	/**
	 * @return tc を戻します。
	 */
	public TestCase getTc() {
		return tc;
	}


	/**
	 * @return typeFilter を戻します。
	 */
	public String[] getTypeFilter() {
		return typeFilter;
	}

	/**
	 * @param filter
	 *            解析を除外する型（typeFilter）を正規表現で設定。
	 */
	public void setTypeFilter(String[] filter) {
		this.typeFilter = filter;
	}

	/**
	 * @return propFilter を戻します。
	 */
	public String[] getPropFilter() {
		return propFilter;
	}

	/**
	 * @param propFilter
	 *            解析を除外するプロパティ（propFilter） を正規表現で設定。
	 */
	public void setPropFilter(String[] propFilter) {
		this.propFilter = propFilter;
	}

	/**
	 * 作成しないassert命令（assertFilter） を正規表現で設定。 TestServiceCodeがオーバーライドする
	 * 
	 * @param assertFilter
	 * @see jp.co.kpscorp.commontools.TestServiceCode#setAssertFilter(String[]
	 *      assertFilter)
	 * 
	 */
	public void setAssertFilter(String[] assertFilter) {
	}

	/**
	 * @param o
	 * @throws Exception
	 */
	public void exec(Object o) throws Exception {
		exec(o, "");
	}

	/**
	 * @param o
	 * @param sufix
	 *            修飾子
	 * @throws Exception
	 */
	public void exec(Object o, String sufix) throws Exception {
		if (o == null) {
			Assert.fail("オブジェクトがnull！！");
		} else {
			Object[] arg = { sufix };
			String fn;
			// HashMapの場合、toStringではファイル名としてまずい
			if (o instanceof HashMap) {
				fn = o.getClass().getName();
			} else {
				fn = o.toString();
			}
			fn = fn.substring(fn.lastIndexOf(".") + 1);
			fn = fn.replaceAll("\\]", "");
			fn = fn.replaceAll("\\}", "");
			String fileName = getRealName(fn);
			plugin.setFilePath(fileName);
			exec(o, plugin, arg);
		}
	}
	
	
	/**
	 * Pluginを動かす
	 * 
	 * @param o
	 * @param plugin
	 * @param fileName
	 * @throws Exception
	 */
	protected void exec(Object o, Plugin plugin,
			Object arg[]) throws Exception {
		Analyzer analyzer = new Analyzer();
		setFilter(plugin, analyzer);
		analyzer.addPlugin("key", plugin);
		analyzer.exec(o, arg);
	}


	/**
	 * @return packageName を戻します。
	 */
	public String getPackageName() {
		return packageName;
	}

	/**
	 * @param packageName
	 *            packageName を設定。
	 */
	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}

	/**
	 * @return maxDepth を戻します。
	 */
	public int getMaxDepth() {
		return maxDepth;
	}

	/**
	 * @param maxDepth
	 *            設定する maxDepth。
	 */
	public void setMaxDepth(int maxDepth) {
		this.maxDepth = maxDepth;
	}



	public String getSrcPath() {
		return srcPath;
	}



	public void setSrcPath(String srcPath) {
		this.srcPath = srcPath;
	}
}
