/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.meema.service;

import jp.co.kpscorp.meema.engine.Analyzer;
import jp.co.kpscorp.meema.engine.plugin.AssertClassMaker;
import jp.co.kpscorp.meema.engine.plugin.Plugin;

/**
 * <strong>テストに便利なメソッドを提供する。 </strong>
 * <p>
 * テストコードファイルを作成する。
 * 
 * @author Katsusuke 作成日:2005/06/09
 */
public class TestServiceCode extends TestServiceSuper {

	private String assertFilter[];

	protected AssertClassMaker classMaker;

	/**
	 * @param srcPath
	 *            作成するクラスのソースのホルダー名
	 * @param packageName
	 *            作成するクラスのパッケージ名
	 */
	public TestServiceCode(String srcPath, String packageName) {
		super();
		setSrcPath(srcPath);
		setPackageName(packageName);
		classMaker.setSrcPath(srcPath + "/" + packageName.replace('.', '/'));
	}

	/**
	 * @param srcPath
	 *            作成するクラスのソースのホルダー名
	 * @param packageName
	 *            作成するクラスのパッケージ名
	 * @param encode
	 *            作成するクラスのエンコード
	 * 
	 */
	public TestServiceCode(String srcPath, String packageName, String encode) {
		this(srcPath, packageName);
		classMaker.setEncode(encode);
	}

	/**
	 * @return assertFilter を戻します。
	 */
	public String[] getAssertFilter() {
		return assertFilter;
	}

	/**
	 * @param assertFilter
	 *            作成しないassert命令（assertFilter） を正規表現で設定。
	 */
	public void setAssertFilter(String[] assertFilter) {
		this.assertFilter = assertFilter;
	}

	/**
	 * テストコードを作成するPluginを返す
	 * 
	 * @return
	 * @see jp.co.kpscorp.commontools.TestServiceSuper#getPlugin()
	 */
	public Plugin getPlugin() {
		if (classMaker == null) {
			classMaker = new AssertClassMaker();
		}
		return classMaker;
	}

	/**
	 * AssertFilterのセット
	 * 
	 * @param plugin
	 * @param analyzer
	 * @see jp.co.kpscorp.commontools.TestServiceSuper#setFilter(jp.co.kpscorp.commontools.Plugin,
	 *      jp.co.kpscorp.commontools.Analyzer)
	 */
	protected void setFilter(Plugin plugin, Analyzer analyzer) {
		super.setFilter(plugin, analyzer);
		// AssertFilterのセット
		if (assertFilter != null) {
			for (int i = 0; i < assertFilter.length; i++) {
				((AssertClassMaker) plugin).setAsserFilter(assertFilter[i]);
			}
		}
	}

	/**
	 * @param o
	 * @param plugin
	 * @param arg
	 * @throws Exception
	 * @see jp.co.kpscorp.commontools.TestServiceSuper#makeCheckFile(java.lang.Object,
	 *      jp.co.kpscorp.commontools.Plugin, java.lang.Object[])
	 */
	protected void exec(Object o, Plugin plugin, Object[] arg) throws Exception {
		Object[] arg2 = { arg[0], packageName };
		super.exec(o, plugin, arg2);
	}

	/**
	 * @return
	 */
	public int getLineLimit() {
		return classMaker.getLineLimit();
	}

	/**
	 * @param lineLimit
	 */
	public void setLineLimit(int lineLimit) {
		classMaker.setLineLimit(lineLimit);
	}

	/**
	 * 結果を正規表現で変換した後比較する場合の正規表現を追加する
	 * 
	 * @param prop
	 * @param regex
	 */
	public void addRegex(String prop, String[] regex) {
		classMaker.addRegex(prop, regex);
	}

}
