/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.meema.selenium;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;

import junit.framework.TestCase;

import org.openqa.selenium.server.SeleniumServer;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;

public class SeleniumTestCase extends TestCase {

	private SeleniumServer seleniumServer;

	protected Selenium selenium;

	protected Properties prop = new Properties();

	protected boolean setSchema = false;

	protected String propFileName = "testconfig.properties";

	protected Connection con;

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		prop.load(this.getClass().getResourceAsStream(propFileName));
		// SeleniumServer起動
		seleniumServer = new SeleniumServer();
		seleniumServer.start();

		// seleniumインスタンス起動
		selenium = new DefaultSelenium("localhost", SeleniumServer
				.getDefaultPort(), prop.getProperty("SeleniumTest.Browser"),
				prop.getProperty("SeleniumTest.URL"));
		selenium.start();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		// Seleniumインスタンスを停止。
		selenium.stop();
		// SeleniumServerを停止する。
		seleniumServer.stop();
		// Connectionを切断する
		if (con != null && !con.isClosed()) {
			con.close();
		}
		con = null;
	}

	/**
	 * @return
	 * @throws Exception
	 */
	protected Connection getConnection() throws Exception {
		if (con == null) {
			Class.forName(prop.getProperty("driverClassName"));
			// URL のデータベースに 接続する
			con = DriverManager.getConnection(prop.getProperty("URL"), prop
					.getProperty("user"), prop.getProperty("password"));
		}
		return con;
	}

}
