/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.meema.engine.plugin;

import jp.co.kpscorp.meema.engine.BeanMethod;

/**
 * BeanPropertyGetterに導入するPluginのインターフェース
 * @version 2004/07/29
 * @author Katsusuke
 * @see 
 */
public interface Plugin {
	
	/**
	 * 処理の開始時に呼ばれる
	 * @param arg クライアントからのパラメーター
	 */
	public void setUp(Object[] arg);
	/**
	 * 発見したメソッド単位に呼ばれる
	 * @param bm
	 * @throws Exception
	 */
	public void execElement(BeanMethod bm) throws Exception;
	/**
	 * メソッドの戻り値の解析の開始時に呼ばれる
	 * @param bm
	 * @throws Exception
	 */
	public void objectBegin(BeanMethod bm) throws Exception;
	/**
	 * メソッドの戻り値の解析の終了時時に呼ばれる
	 * @param bm
	 * @throws Exception
	 */
	public void objectEnd(BeanMethod bm) throws Exception;
	/**
	 * 出力ファイルのパスを設定する
	 * @param path
	 */
	public void setFilePath(String path);
}
