// COM_XMultiLanguage.h cR[hy[W֘ÅgNX
#ifndef __COM_XMULTILANGUAGE__
#define __COM_XMULTILANGUAGE__

#include "wxc.h"
#include "../COM.h"
#include <mlang.h>                      // IMultiLanguage2


_WXC_BEGIN                              // namespace wxc {

// R[hy[W
#define CODEPAGE_ERROR          (static_cast<UINT>(-1))
#define CODEPAGE_SPECIFY        (static_cast<UINT>(-2))

#define CODEPAGE_UTF16LE        (1200)
#define CODEPAGE_UTF16BE        (1201)

#define CODEPAGE_SJIS           (932)
#define CODEPAGE_JIS            (50220)
#define CODEPAGE_JIS_KANA       (50221)
#define CODEPAGE_JIS_X          (50222)
#define CODEPAGE_AUTO_JAPANESE  (50932)

#define CODEPAGE_UTF7           (65000)
#define CODEPAGE_UTF8           (65001)


class COM_XMultiLanguage2
{
public:
	COM_XMultiLanguage2(void);
	~COM_XMultiLanguage2(void);

	HRESULT AutoDetect(LPCSTR pSrcStr, const SIZE_T cSrcSize, DetectEncodingInfo arEncoding[], INT &rnScores, const MLDETECTCP nDetectFlag = MLDETECTCP_NONE, const DWORD dwPrefWinCodePage = 0);
	UINT    AutoDetect(LPCSTR pSrcStr, const SIZE_T cSrcSize,                                                 const MLDETECTCP nDetectFlag = MLDETECTCP_NONE, const DWORD dwPrefWinCodePage = 0);

	DWORD ConvertToUnicodeSize(LPCSTR pSrcStr, const SIZE_T cSrcSize,                                        const UINT uCodePage);
	DWORD ConvertToUnicode    (LPCSTR pSrcStr, const SIZE_T cSrcSize, LPWSTR pDstStr, const SIZE_T cDstSize, const UINT uCodePage);
	DWORD ConvertToUnicode    (const wgc::string_t &rSrcStr, wgc::wstring_t &rDstStr, const UINT uCodePage);

	DWORD ConvertFromUnicodeSize(LPCWSTR pSrcStr, const SIZE_T cSrcSize,                                       const UINT uCodePage);
	DWORD ConvertFromUnicode    (LPCWSTR pSrcStr, const SIZE_T cSrcSize, LPSTR pDstStr, const SIZE_T cDstSize, const UINT uCodePage);
	DWORD ConvertFromUnicode    (const wgc::wstring_t &rSrcStr, wgc::string_t &rDstStr, const UINT uCodePage);

private:
	IMultiLanguage2 *m_pMultiLanguage2;
};

_WXC_END                                // }

#endif // __COM_XMULTILANGUAGE__
