// wgfunc.cpp cCve[Vt@C
#include "wgfunc.h"
#include <stdarg.h>                     // va_list


_WGC_BEGIN                              // namespace wgc {


////////////////////////////////////////////////////////////////////////////////
// G[

// G[R[h𓊂
void wgfThrowLastError(void)
{
	const DWORD dwLastError = ::GetLastError();
	throw dwLastError;
}


////////////////////////////////////////////////////////////////////////////////
// L[{[h

// L[Ă邩H
bool wgfIsKeyDown(const int nVirtKey)
{
	return (::GetKeyState(nVirtKey) < 0);
}

// L[gOԂH
bool wgfIsKeyToggled(const int nVirtKey)
{
	return (::GetKeyState(nVirtKey) & 1);
}


////////////////////////////////////////////////////////////////////////////////
// OSo[W

// OS̃o[W擾
void wgfGetVersionEx(OSVERSIONINFO &rVersionInfo)
{
	rVersionInfo.dwOSVersionInfoSize = sizeof(rVersionInfo);
	::GetVersionEx(&rVersionInfo);
}

// Windows NTnH
bool wgfIsWinNT(void)
{
	OSVERSIONINFO ov;
	wgfGetVersionEx(ov);
	return ov.dwPlatformId == VER_PLATFORM_WIN32_NT;
}


////////////////////////////////////////////////////////////////////////////////
// j[

// w肳ꂽj[IDqɎj[nhƏꏊ擾
HMENU wgfFindMenu(HMENU hMenu, UINT nFindID, int *pIndex /* = NULL */)
{
	int tmp;
	if(pIndex == NULL)
	{
		pIndex = &tmp;
	}

	// j[
	const int iItemCount = ::GetMenuItemCount(hMenu);
	for(int i = 0; i < iItemCount; i++)
	{
		const UINT nSubID = GetMenuItemID(hMenu, i);

		// |bvAbvj[̏ꍇ
		if(nSubID == static_cast<UINT>(-1))
		{ 
			// ċA
			HMENU hFindResult = wgfFindMenu(::GetSubMenu(hMenu, i), nFindID, pIndex);
			if(hFindResult != NULL)
			{
				return hFindResult;
			}
		}
		// j[ACeꍇ
		else
		{
			// TĂIDI
			if(nSubID == nFindID)
			{
				*pIndex = i;
				return hMenu;
			}
		}
	}

	// ȂNULLԂ
	return NULL;
}


////////////////////////////////////////////////////////////////////////////////
// 

// tH[}beBOiprintf() ݂Ȃj
DWORD wgfFormatString(tstring_t &tstr, LPCTSTR lpszFormat, ...)
{
	DWORD dwResult = 0;

	// ψ̏
	va_list va;
	va_start(va, lpszFormat);
	{
		// ::FormatMessage() ŃtH[}beBO
		LPTSTR lpBuffer = NULL;
		dwResult = ::FormatMessage(
			FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_STRING,
			lpszFormat,
			0, 0,
			reinterpret_cast<LPTSTR>(&lpBuffer), 0,
			&va);

		tstr.assign(lpBuffer, dwResult);
		::LocalFree(lpBuffer);
	}
	va_end(va);

	return dwResult;
}

// ̕ŋ؂ꂽ擾
BOOL wgfExtractSubString(tstring_t &tstr, const tstring_t &tstr_full, const int iSubString, const TCHAR chSep)
{
	tstring_t::size_type last_find_pos = 0;

	for(int i = 0; i < iSubString; i++)
	{
		tstring_t::size_type find_pos = tstr_full.find(chSep, last_find_pos);
		if(find_pos == tstring_t::npos)
		{
			return FALSE;
		}
		last_find_pos = find_pos + 1;
	}

	tstring_t::size_type find_pos = tstr_full.find(chSep, last_find_pos);
	tstr = tstr_full.substr(last_find_pos, find_pos - last_find_pos);
	return TRUE;
}

// XgO\[X當[h
int wgfLoadString(HINSTANCE hResource, const UINT uID, tstring_t &tstr)
{
	TCHAR buffer[128];
	const int nResult = ::LoadString(hResource, uID, buffer, countof(buffer));

	tstr.assign(buffer, nResult);
	return nResult;
}

// uIDiʏ ::GetLastError() ̖߂l̎G[bZ[W擾
int wgfGetErrorMessage(const UINT uID, tstring_t &tstr)
{
	LPTSTR lpString = NULL;
	const DWORD dwResult = ::FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_IGNORE_INSERTS | FORMAT_MESSAGE_FROM_SYSTEM, NULL,
		uID, 0,
		reinterpret_cast<LPTSTR>(&lpString), 0,
		NULL);

	tstr.assign(lpString, dwResult);
	::LocalFree(lpString);

	return dwResult;
}

// }`oCgChɕϊ
int wgfMultiByteToWideChar(
	const string_t &multibyte_str,
	wstring_t &widechar_str,
	const UINT uCodePage /* = CP_ACP */,
	const DWORD dwFlags  /* = 0 */)
{
	LPCSTR    lpszString = multibyte_str.c_str();
	const int nStrLength = static_cast<int>(multibyte_str.length());

	// ̒擾
	const int nLength = ::MultiByteToWideChar(
		uCodePage, dwFlags,
		lpszString, nStrLength,
		NULL, 0);

	if(nLength == 0)
	{
		return nLength;
	}

	// Chɕϊ
	wchar_t *wstr = new wchar_t[nLength];
	const int nResult = ::MultiByteToWideChar(
		uCodePage, dwFlags,
		lpszString, nStrLength,
		wstr, nLength);
	widechar_str.assign(wstr, nLength);
	delete []wstr;

	return nResult;
}

// Ch}`oCgɕϊ
int wgfWideCharToMultiByte(
	const wstring_t &widechar_str,
	string_t &multibyte_str,
	const UINT uCodePage /* = CP_ACP */,
	const DWORD dwFlags  /* = 0 */)
{
	LPCWSTR   lpszString = widechar_str.c_str();
	const int nStrLength = static_cast<int>(widechar_str.length());

	// ̒擾
	const int nLength = ::WideCharToMultiByte(
		uCodePage, dwFlags,
		lpszString, nStrLength,
		NULL, 0,
		NULL, NULL);

	if(nLength == 0)
	{
		return nLength;
	}

	// Chɕϊ
	char *str = new char[nLength];
	const int nResult = ::WideCharToMultiByte(
		uCodePage, dwFlags,
		lpszString, nStrLength,
		str, nLength,
		NULL, NULL);
	multibyte_str.assign(str, nLength);
	delete []str;

	return nResult;
}


// JgfBNg擾
DWORD wgfGetCurrentDirectory(tstring_t &tstr)
{
	TCHAR szCurrentDirectry[MAX_PATH];
	const DWORD dwResult = ::GetCurrentDirectory(MAX_PATH, szCurrentDirectry);
	tstr.assign(szCurrentDirectry, dwResult);

	return dwResult;
}

// JgfBNgݒ
BOOL wgfSetCurrentDirectory(const tstring_t &tstr)
{
	return ::SetCurrentDirectory(tstr.c_str());
}

_WGC_END                                // }
