// Window.h cEChẼTuNX
#ifndef __WGC_WINDOW__
#define __WGC_WINDOW__

#include "wgc.h"
#include "Thread.h"                     // wgc::tls<>
#include <map>


_WGC_BEGIN                              // namespace wgc {

#define WINDOW_MAX_HASH (0xff)

class Window
{
public:
	////////////////////////////////////////////////////////////////
	// RXgN^^fXgN^
	explicit Window(HWND hWnd = NULL);
	virtual ~Window(void);

	operator HWND(void) const;

	// gbvXg\
	void SetTopmost(const BOOL bTopmost);

	////////////////////////////////////////////////////////////////////////////////
	// bp֐

	BOOL IsWindow(void) const;
	BOOL IsChild(HWND hWnd) const;

	// EChEID֐
	HWND GetDlgItem(const int nIDDlgItem) const;
	WORD GetDlgCtrlID(void) const;

	// X^C֐
	BOOL  IsTopmost(void) const;
	DWORD GetStyle(void) const;
	void  SetStyle(const DWORD dwStyle);
	DWORD GetExStyle(void) const;
	void  SetExStyle(const DWORD dwExStyle);
	void  ModifyStyle(const DWORD dwRemove, const DWORD dwAdd, const DWORD dwExRemove, const DWORD dwExAdd, const BOOL bRedraw = TRUE);

	// ^C}֐
	UINT_PTR SetTimer (const UINT_PTR uIDEvent, const UINT uElapse, TIMERPROC lpTimerFunc = NULL);
	void     KillTimer(const UINT_PTR uIDEvent);

	// L/
	BOOL GetUpdateRect(RECT &rRect, const BOOL bErase = TRUE);
	BOOL GetUpdateRgn (HRGN  hRgn , const BOOL bErase = TRUE);
	void Validate    (void);
	void ValidateRect(const RECT &rRect);
	void ValidateRgn (      HRGN  hRgn);
	void Invalidate    (const BOOL bErase = TRUE);
	void InvalidateRect(const RECT &rRect, const BOOL bErase = TRUE);
	void InvalidateRgn (      HRGN  hRgn , const BOOL bErase = TRUE);

	// `֐
	HDC  BeginPaint(LPPAINTSTRUCT ps);
	void EndPaint(const PAINTSTRUCT *ps);

	// tH[JX֐
	HWND SetFocus(void);
	BOOL SetForegroundWindow(void);
	BOOL IsFocused(void) const;

	// Jbg֐
	void CreateCaret(HBITMAP hBitmap, const int nWidth, const int nHeight) const;
	void CreateSolidCaret(const int nWidth, const int nHeight) const;
	void CreateGrayCaret (const int nWidth, const int nHeight) const;
	BOOL ShowCaret(void) const;
	BOOL HideCaret(void) const;

	// eEChE֐
	HWND GetParent(void) const;
	HWND SetParent(HWND hWndNewParent);

	// j[֐
	HMENU GetMenu(void) const;
	void  SetMenu(HMENU hMenu);
	void  DrawMenuBar(void);

	// tHg֐
	HFONT GetFont(void) const;
	void  SetFont(HFONT hFont, const BOOL bRedraw = TRUE);

	// }EX֐
	HWND SetCapture(void);

	// XN[֐
	int  SetHScrollInfo(const SCROLLINFO &si, const BOOL bRedraw = TRUE);
	int  SetVScrollInfo(const SCROLLINFO &si, const BOOL bRedraw = TRUE);
	void GetHScrollInfo(SCROLLINFO &si);
	void GetVScrollInfo(SCROLLINFO &si);
	void ScrollWindow  (const int dx, const int dy, const RECT *prcScroll = NULL, const RECT *prcClip = NULL);
	int  ScrollWindowEx(const int dx, const int dy, const RECT *prcScroll = NULL, const RECT *prcClip = NULL, HRGN hrgnUpdate = NULL, LPRECT prcUpdate = NULL, const UINT flags = 0);

	// EChE֐
	void SetWindowPlacement(const WINDOWPLACEMENT &rWndPl);
	void GetWindowPlacement(      WINDOWPLACEMENT &rWndPl) const;
	void SetWindowText(const tstring_t &tstr);
	int  GetWindowText(tstring_t &tstr) const;
	int  GetWindowTextLength(void) const;
	void SetWindowPos(HWND hWndInsertAfter, const int x, const int y, const int cx, const int cy, const UINT uFlags);
	void MoveWindow(const int x, const int y, const int nWidth, int nHeight, const BOOL bRepaint = TRUE);
	void MoveWindow(const RECT &rect, const BOOL bRepaint = TRUE);
	void MoveWindow(const POINT &point, const SIZE &size, const BOOL bRepaint = TRUE);
	BOOL ShowWindow(const int nCmdShow);
	void UpdateWindow(void);
	void DestroyWindow(void);

	// EChE֐itemplateŎj
	template<typename _Ptr> _Ptr GetWindowLongPtr(const int nIndex)
	{
		const LONG_PTR lResult = ::GetWindowLongPtr(m_hWnd, nIndex);
		return reinterpret_cast<_Ptr>(lResult);
	}
	template<typename _Ptr> _Ptr SetWindowLongPtr(const int nIndex, const _Ptr pNewPtr)
	{
		const LONG_PTR lPtr    = reinterpret_cast<LONG_PTR>(pNewPtr);
		const LONG_PTR lResult = ::SetWindowLongPtr(m_hWnd, nIndex, lPtr);
		return reinterpret_cast<_Ptr>(lResult);
	}

	// EChË֐
	void GetEffectiveClientRect(RECT &rect, LPINT lpInfo) const;
	void GetClientRect(RECT &rRect) const;
	void GetWindowRect(RECT &rRect) const;
	void ScreenToClient(POINT &pt) const;
	void ClientToScreen(POINT &pt) const;

	// bZ[W֐
	LRESULT SendMessage(UINT uMsg, WPARAM wParam = 0, LPARAM lParam = 0);
	LRESULT SendMessage(UINT uMsg, WPARAM wParam = 0, LPARAM lParam = 0) const;
	void PostMessage   (UINT uMsg, WPARAM wParam = 0, LPARAM lParam = 0);
	void PostMessage   (UINT uMsg, WPARAM wParam = 0, LPARAM lParam = 0) const;
	BOOL GetMessage (LPMSG lpMsg, UINT wMsgFilterMin = 0, UINT wMsgFilterMax = 0) const;
	BOOL PeekMessage(LPMSG lpMsg, UINT wMsgFilterMin = 0, UINT wMsgFilterMax = 0, UINT wRemoveMsg = PM_REMOVE) const;
	BOOL TranslateAccelerator(HACCEL hAccTable, LPMSG lpMsg);

	// bZ[W{bNX֐
	int MessageBox(HINSTANCE hResource, const UINT uText, const UINT uCaption, const UINT uType = MB_OK);
	int MessageBox(const tstring_t &text, const tstring_t &caption, const UINT uType = MB_OK);

	// Nbv{[h
	BOOL OpenClipboard(void);

	// OLE Drag & Drop
	HRESULT RegisterDragDrop(IDropTarget *pDropTarget);
	HRESULT RevokeDragDrop(void);

	// hbv^[Qbg
	virtual DWORD OnDragEnter(IDataObject *pDataObject, const DWORD dwKeyState, const POINTL &pt);
	virtual DWORD OnDragOver(const DWORD dwKeyState, const POINTL &pt);
	virtual void  OnDragLeave(void);
	virtual DWORD OnDrop(IDataObject *pDataObject, const DWORD dwKeyState, const POINTL &pt);

protected:
	HWND m_hWnd;                            // EChEnh

	// EChE쐬
	BOOL Create(
		LPCTSTR lpszClassName, LPCTSTR lpszWindowName,
		const DWORD dwStyle, const DWORD dwExStyle,
		Window *parent,
		HMENU     hMenu     = NULL,
		HINSTANCE hInstance = NULL,
		const int x       = CW_USEDEFAULT,
		const int y       = CW_USEDEFAULT,
		const int nWidth  = CW_USEDEFAULT,
		const int nHeight = CW_USEDEFAULT,
		LPVOID lpParam = NULL);

	// TuNX
	BOOL Subclass(HWND hWnd);
	BOOL Unsubclass(void);

	// bZ[W֘A
	typedef struct _MSGPARAM
	{
		UINT uMsg;
		WPARAM wParam;
		LPARAM lParam;
	} MSGPARAM;
	void GetMessageParam(MSGPARAM &rMsgParam) const;

	// EChEvV[W
	static  LRESULT CALLBACK _WindowProcBase(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
	virtual LRESULT CALLBACK WindowProc(UINT uMsg, WPARAM wParam, LPARAM lParam);
	virtual LRESULT _Default(void);


	////////////////////////////////////////////////////////////////////////////////
	// z֐
	virtual BOOL PreCreateWindow(CREATESTRUCT &cs);
	virtual void PostNcDestroy(void);


	////////////////////////////////////////////////////////////////////////////////
	// bZ[Wnh
	virtual void OnHelp(LPHELPINFO lpHelpInfo);

	virtual void OnGetMinMaxInfo(LPMINMAXINFO lpMMI);
	virtual UINT OnGetDlgCode(LPMSG lpMsg);

	virtual BOOL OnNcCreate(LPCREATESTRUCT lpCreateStruct);
	virtual int  OnCreate(LPCREATESTRUCT lpCreateStruct);

	virtual void OnClose(void);
	virtual void OnDestroy(void);
	virtual void OnNcDestroy(void);

	virtual BOOL OnQueryEndSession(const BOOL bRequestSource, const BOOL bLogOff);
	virtual void OnEndSession(const BOOL bEnding, const BOOL bLogOff);

	virtual void OnSize  (const UINT nType, const int cx, const int cy);
	virtual void OnSizing(const UINT nSide, LPRECT lpRect);

	virtual void OnActivate(const UINT nState, const BOOL bMinimized, HWND hWndPrevious);
	virtual int  OnMouseActivate(HWND hDesktopWnd, const UINT uHitTest, const UINT uMessage);
	virtual void OnSetFocus (HWND hWndLoseFocus);
	virtual void OnKillFocus(HWND hWndGetFocus);

	virtual void  OnSetFont(HFONT hFont, const BOOL bRedraw);
	virtual HFONT OnGetFont(void);

	virtual void OnInitMenu(HMENU hMenu);
	virtual void OnInitMenuPopup(HMENU hMenu, const UINT uIndex, const BOOL bSystemMenu);
	virtual void OnMenuSelect(const UINT nItemID, const UINT nFlags, HMENU hSysMenu);
	virtual void OnEnterMenuLoop(const BOOL bIsTrackPopupMenu);
	virtual void OnExitMenuLoop (const BOOL bIsTrackPopupMenu);

	virtual void OnDropFiles(HDROP hDrop);

	virtual BOOL OnNotify(const int nIdCtrl, LPNMHDR lpNmHeader);
	virtual BOOL OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl);

	virtual UINT OnNcHitTest(const POINT &point);

	virtual void OnTimer(const UINT uIDEvent);

	virtual void OnPaint(void);
	virtual void OnNcPaint(void);
	virtual BOOL OnEraseBkgnd(HDC hDC);

	virtual void   OnSysColorChange(void);
	virtual HBRUSH OnCtlColorStatic(HDC hDC, HWND hWnd);

	virtual void OnParentNotify(const UINT message, const LPARAM lParam);
	virtual void OnHScroll(const UINT nSBCode, const UINT nPos, HWND hWndScrollBar);
	virtual void OnVScroll(const UINT nSBCode, const UINT nPos, HWND hWndScrollBar);

	virtual BOOL OnSetCursor(HWND hWnd, const UINT nHitTest, const UINT message);

	virtual void OnKeyDown (const UINT nChar, const UINT nRepeatCount, const UINT nFlags);
	virtual void OnKeyUp   (const UINT nChar, const UINT nRepeatCount, const UINT nFlags);
	virtual void OnChar    (const UINT nChar, const UINT nRepeatCount, const UINT nFlags);
	virtual void OnUniChar (const UINT nChar, const UINT nRepeatCount, const UINT nFlags);
	virtual void OnDeadChar(const UINT nChar, const UINT nRepeatCount, const UINT nFlags);

	virtual void  OnImeStartComposition(void);
	virtual void  OnImeEndComposition  (void);
	virtual void  OnImeCompositionFull (void);
	virtual void  OnImeComposition     (const WORD chDBCS, const UINT nFlags);
	virtual BOOL  OnImeRequest_CandidateWindow       (CANDIDATEFORM   *lpCf);
	virtual BOOL  OnImeRequest_CompositionFont       (LOGFONT         *lpLf);
	virtual BOOL  OnImeRequest_CompositionWindow     (COMPOSITIONFORM *lpCf);
	virtual BOOL  OnImeRequest_ConfirmReconvertString(RECONVERTSTRING *lpRs);
	virtual DWORD OnImeRequest_ReconvertString       (RECONVERTSTRING *lpRs);

	virtual BOOL OnMouseWheel(const UINT nFlags, const short zDelta, const POINT &point);
	virtual void OnMouseLeave(void);
	virtual void OnMouseMove       (const UINT nFlags  , const POINT &point);
	virtual void OnLButtonDown     (const UINT nFlags  , const POINT &point);
	virtual void OnLButtonUp       (const UINT nFlags  , const POINT &point);
	virtual void OnLButtonDblClk   (const UINT nFlags  , const POINT &point);
	virtual void OnRButtonDown     (const UINT nFlags  , const POINT &point);
	virtual void OnRButtonUp       (const UINT nFlags  , const POINT &point);
	virtual void OnRButtonDblClk   (const UINT nFlags  , const POINT &point);
	virtual void OnMButtonDown     (const UINT nFlags  , const POINT &point);
	virtual void OnMButtonUp       (const UINT nFlags  , const POINT &point);
	virtual void OnMButtonDblClk   (const UINT nFlags  , const POINT &point);
	virtual void OnXButton1Down    (const UINT nFlags  , const POINT &point);
	virtual void OnXButton1Up      (const UINT nFlags  , const POINT &point);
	virtual void OnXButton1DblClk  (const UINT nFlags  , const POINT &point);
	virtual void OnXButton2Down    (const UINT nFlags  , const POINT &point);
	virtual void OnXButton2Up      (const UINT nFlags  , const POINT &point);
	virtual void OnXButton2DblClk  (const UINT nFlags  , const POINT &point);
	virtual void OnNcLButtonDown   (const UINT nHitTest, const POINT &point);
	virtual void OnNcLButtonUp     (const UINT nHitTest, const POINT &point);
	virtual void OnNcLButtonDblClk (const UINT nHitTest, const POINT &point);
	virtual void OnNcRButtonDown   (const UINT nHitTest, const POINT &point);
	virtual void OnNcRButtonUp     (const UINT nHitTest, const POINT &point);
	virtual void OnNcRButtonDblClk (const UINT nHitTest, const POINT &point);
	virtual void OnNcMButtonDown   (const UINT nHitTest, const POINT &point);
	virtual void OnNcMButtonUp     (const UINT nHitTest, const POINT &point);
	virtual void OnNcMButtonDblClk (const UINT nHitTest, const POINT &point);
	virtual void OnNcXButton1Down  (const UINT nHitTest, const POINT &point);
	virtual void OnNcXButton1Up    (const UINT nHitTest, const POINT &point);
	virtual void OnNcXButton1DblClk(const UINT nHitTest, const POINT &point);
	virtual void OnNcXButton2Down  (const UINT nHitTest, const POINT &point);
	virtual void OnNcXButton2Up    (const UINT nHitTest, const POINT &point);
	virtual void OnNcXButton2DblClk(const UINT nHitTest, const POINT &point);

private:
	// EChEnhƃIuWFNg̑Ή}bv
	typedef std::map<HWND, Window *> handlemap_t;
	typedef struct _GLOBAL_DATA
	{
		LONG        lRefCount;
		handlemap_t mapHandle[WINDOW_MAX_HASH + 1];

		// tbNp
		HHOOK   hHook;
		Window *pWindow;
	} GLOBAL_DATA;

	// EChȄLCWP[^
	// ^C~O
	// @TRUE c_MapAttach()
	// @FALSEc_MapDetach()ARXgN^
	BOOL m_bOwner;

	// Thread Local Storage
	static tls<GLOBAL_DATA> m_tlsGlobalData;

	static WORD    _MapHash  (HWND hWnd);
	static Window *_MapFind  (HWND hWnd);
	static void    _MapAttach(HWND hWnd, Window *pWindow);
	static void    _MapDetach(Window *pWindow);

	// tbNvV[W
	static BOOL             _SetHookTarget(Window *pTargetWindow);
	static LRESULT CALLBACK _CBTProc      (int nCode, WPARAM wParam, LPARAM lParam);

	// bZ[W֘A
	MSGPARAM m_msgparam;
	WNDPROC  m_lpfnOldWndProc;              // ÂEChEvV[W

	// wgc::Dialog NX _SetHookTarget() g߁AfriendNXɐݒ肷
	friend class Dialog;

	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(Window)
};

_WGC_END                                // }

#endif // __WGC_WINDOW__
