// Registry.h cWXgNX
#ifndef __WGC_REGISTRY__
#define __WGC_REGISTRY__

#include "wgc.h"
#include <windows.h>


_WGC_BEGIN                              // namespace wgc {

class Registry
{
public:
	Registry(HKEY hKeyRoot = HKEY_CURRENT_USER);
	Registry(HKEY hKeyRoot, LPCTSTR lpszSubName, const BOOL bCreate = FALSE, const REGSAM samDesired = KEY_ALL_ACCESS);
	~Registry(void);

	operator HKEY(void);
	LONG GetErrorCode(void) const;

	HKEY CreateSubKey(LPCTSTR lpszSubName, const DWORD dwOptions = REG_OPTION_NON_VOLATILE, const REGSAM samDesired = KEY_ALL_ACCESS);
	HKEY OpenSubKey(LPCTSTR lpszSubName, const REGSAM samDesired = KEY_ALL_ACCESS);
	void DeleteSubKey(LPCTSTR lpszSubName);
	LONG EnumerateSubKey(DWORD dwIndex, LPTSTR lpName, DWORD cbName);

	void DeleteKey(LPCTSTR lpszKeyName);

	// 
	void SetValue(LPCTSTR lpszValueName, DWORD dwReserved, DWORD dwType, CONST BYTE *lpData, const DWORD cbData);
	void SetValue(LPCTSTR lpszValueName, CONST BYTE *lpData, const DWORD cbData);
	void SetValue(LPCTSTR lpszValueName, const DWORD dwData);
	void SetValue(LPCTSTR lpszValueName, const tstring_t &tstr);

	// ǂݍ
	LONG GetValue(LPCTSTR lpszValueName, LPDWORD    lpReserved, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData);
	LONG GetValue(LPCTSTR lpszValueName, LPBYTE     lpData, DWORD &rcbData);
	LONG GetValue(LPCTSTR lpszValueName, DWORD     &rdwData);
	LONG GetValue(LPCTSTR lpszValueName, tstring_t &tstr);

private:
	const BOOL m_bSubKey;

	HKEY m_hKeyRoot;

	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(Registry)
};

_WGC_END                                // }

#endif // __WGC_REGISTRY__
