// Imm.cpp cCve[Vt@C
#include "Imm.h"


// CũN
#pragma comment(lib, "imm32.lib")       // IMMpCu


_WGC_BEGIN                              // namespace wgc {

////////////////////////////////////////////////////////////////////////////////
// \z

// RXgN^
Imm::Imm(HWND hWnd)
{
	m_hWnd = hWnd;
	m_hIMC = ::ImmGetContext(m_hWnd);
}

// fXgN^
Imm::~Imm(void)
{
	::ImmReleaseContext(m_hWnd, m_hIMC);
	m_hIMC = NULL;
}


////////////////////////////////////////////////////////////////////////////////
// 

BOOL Imm::GetOpenStatus(void) const
{
	return ::ImmGetOpenStatus(m_hIMC);
}

BOOL Imm::SetOpenStatus(const BOOL bOpen /* = TRUE */)
{
	return ::ImmSetOpenStatus(m_hIMC, bOpen);
}


////////////////////////////////////////////////////////////////////////////////
// 

// IMẼJbgWݒ
BOOL Imm::SetPos(const POINT &point)
{
	COMPOSITIONFORM cf;
	cf.dwStyle = CFS_POINT;
	cf.ptCurrentPos = point;

	return ::ImmSetCompositionWindow(m_hIMC, &cf);
}


// tHg
BOOL Imm::GetCompositionFont(LPLOGFONT lplf)
{
	return ::ImmGetCompositionFont(m_hIMC, lplf);
}

BOOL Imm::SetCompositionFont(LPLOGFONT lplf)
{
	return ::ImmSetCompositionFont(m_hIMC, lplf);
}

BOOL Imm::SetCompositionFont(HFONT hFont)
{
	LOGFONT lf;
	::GetObject(hFont, sizeof(LOGFONT), &lf);
	return SetCompositionFont(&lf);
}


// ϊ
LONG Imm::GetCompositionString(const DWORD dwIndex, LPVOID lpBuf, const DWORD dwBufLen)
{
	return ::ImmGetCompositionString(m_hIMC, dwIndex, lpBuf, dwBufLen);
}

LONG Imm::GetCompositionString_ResultStr(tstring_t &tstr)
{
	// obt@TCY擾
	const LONG nSize = GetCompositionString(GCS_RESULTSTR, NULL, 0);
	if(nSize < 0)
	{
		return nSize;
	}

	// obt@m
	const size_t nLength = nSize / sizeof(TCHAR);
	TCHAR *lpString = new TCHAR[nLength];

	// ϊ擾
	const LONG lResult = GetCompositionString(GCS_RESULTSTR, lpString, nSize);
	tstr.assign(lpString, nLength);

	// ㏈
	delete []lpString;
	return lResult;
}

// Unicodeŕϊ̒l擾
LONG Imm::GetCompositionString_ResultStrWide(wstring_t &wstr)
{
	// obt@TCY擾
	const LONG nSize = ::ImmGetCompositionStringW(m_hIMC, GCS_RESULTSTR, NULL, 0);
	if(nSize < 0)
	{
		return nSize;
	}

	// obt@m
	const size_t nLength = nSize / sizeof(wchar_t);
	wchar_t *lpString = new wchar_t[nLength];

	// ϊ擾
	const LONG lResult = ::ImmGetCompositionStringW(m_hIMC, GCS_RESULTSTR, lpString, nSize);
	wstr.assign(lpString, nLength);

	// ㏈
	delete []lpString;
	return lResult;
}

BOOL Imm::SetCompositionString(const DWORD dwIndex, LPVOID lpComp, const DWORD dwCompLen, LPVOID lpRead, const DWORD dwReadLen)
{
	return ::ImmSetCompositionString(m_hIMC, dwIndex, lpComp, dwCompLen, lpRead, dwReadLen);
}

BOOL Imm::SetCompositionString_QueryReconvertString(LPRECONVERTSTRING lpRs)
{
	return SetCompositionString(SCS_QUERYRECONVERTSTRING, lpRs, lpRs->dwSize, NULL, 0);
}

BOOL Imm::SetCompositionString_SetReconvertString(LPRECONVERTSTRING lpRs)
{
	return SetCompositionString(SCS_SETRECONVERTSTRING, lpRs, lpRs->dwSize, NULL, 0);
}

_WGC_END                                // }
