// string_search.h cBoyer-Moore@ɂ镶񌟍NX
#ifndef __STRING_SEARCH__
#define __STRING_SEARCH__

#include "sgc.h"
#include <stddef.h>                     // size_t
#include <algorithm>                    // std::fill_n()

_SGC_BEGIN

// wpNX
// sgc::string_search ͌Ƀe[ugpB
// ̃e[uɒʏ̔zgpꍇAev[ǧ^ char ̂Ƃ
// e[ũCfbNXɂȂ\B
// ܂Aev[ǧ^NXɂƁAzgƂłȂB
// 邽߂ɁAe[uNXgpB
// ʏ̔zł͖̂^gpƂɁǍ^̓o[W쐬B
template<typename _Ty>
class _string_search_table
{
public:
	_string_search_table(const size_t &default_value)
	{
		// m
		const size_t size = 1 << (sizeof(_Ty) * 8);
		m_table = new size_t[size];

		// 
		std::fill_n(m_table, size, default_value);
	}
	~_string_search_table(void) { delete []m_table; }

	size_t &operator[](const _Ty &key)             { return m_table[key]; }
	const size_t &operator[](const _Ty &key) const { return m_table[key]; }

private:
	size_t *m_table;
};

// char o[W
template<>
class _string_search_table<char>
{
public:
	_string_search_table(const char &default_value)
	{ std::fill_n(m_table, 256, default_value); }

	size_t &operator[](const char &key)
	{ return m_table[static_cast<unsigned char>(key)]; }

	const size_t &operator[](const char &key) const
	{ return m_table[static_cast<unsigned char>(key)]; }

private:
	size_t m_table[256];
};

// yӁz
// Boyer-Moore@̓e[ȕsKv̂ŁA
// Ž1sȂPȒ@̂قB
// ̃ASÝAɒƂ
// ł̕Ƃ
// ifind() o֐xĂяoƂjɐ^𔭊B
template<typename _Ty, typename _Table = _string_search_table<_Ty>, const _Ty NUL = _Ty()>
class string_search
{
public:
	// RXgN^iwj
	string_search(const _Ty *search_str)
		: m_search_str(search_str), m_search_len(_Length(search_str)), m_skips(m_search_len + 1)
	{
		// search_str ̊eAꂼԍŌɏoꏊiE牽ԖڂjL
		size_t len = m_search_len;
		while(*search_str != NUL) { m_skips[*search_str++] = len--; }
	}

	// i{ƕwj
	int find(const _Ty *base_str, const int base_len) const
	{
		// forgΏZ邯ǂ킩Â炢c
		size_t pos = 0;
		while(pos + m_search_len <= base_len)
		{
			// r
			if(_IsPrefix(m_search_str, base_str + pos))
			{
				// m_search_str Sv
				return pos;
			}

			// rɎgꂽ̕Ƀqbg悤Ɉړ
			const _Ty next_char = base_str[pos + m_search_len];
			pos += m_skips[next_char];
		}

		// Ȃ
		return -1;
	}

private:
	const _Ty   *m_search_str;
	const size_t m_search_len;

	_Table m_skips;

	static bool _IsPrefix(const _Ty *strPre, const _Ty *strAll)
	{ while(*strPre != NUL) { if(*strPre++ != *strAll++) { return false; } }
		return true; }

	static size_t _Length(const _Ty *str)
	{ size_t i = 0; while(str[i] != NUL) { i++; }
		return i; }
};

_SGC_END


#endif // __STRING_SEARCH__
