// WinMain.cpp
#include "WinMain.h"
#include "EditView.h"
#include "HtmlHelp_Utility.h"
#include "Setting.h"
#include "Station.h"
#include "FrameThread.h"
#include <assert.h>                     // assert()


// pragma̐ݒ
#pragma comment(lib, "HtmlHelp.lib")


// InitApplication() ̖߂l
#define IA_ERROR            0
#define IA_EXISTSSTATION    1
#define IA_SUCCESS          2

#define IMAGELIST_WIDTH     18
#define IMAGELIST_HEIGHT    17
#define IMAGELIST_GROW      16


// anonymous namespace
namespace
{
	HINSTANCE g_hInstance     = NULL;       // CX^Xnh
	HINSTANCE g_hResource     = NULL;       // \[Xnh
	HACCEL    g_hAccelerator  = NULL;       // ANZ[^e[u

	HIMAGELIST g_hImageList         = NULL;
	HIMAGELIST g_hHotImageList      = NULL;
	HIMAGELIST g_hDisabledImageList = NULL;

	Station *g_pStation = NULL;

	// vpeB
	wgc::CriticalSection g_csWndPl;
	wgc::CriticalSection g_csMainFrame;
	wgc::CriticalSection g_csEditView;
	WINDOWPLACEMENT          g_wndpl;
	MAINFRAME_PROPERTY       g_prMainFrame;
	EDITVIEW_PROPERTY_vector g_prEditView_Array;
	KEYWORD_INFO_vector      g_prEditViewKeyword_Array;

	int  InitApplication(LPTSTR lpCmdLine, const int nCmdShow);
	BOOL ExitApplication(void);

	void LoadAccelerator(void);             // ANZ[^[h
	void FreeAccelerator(void);             // ANZ[^J

	HIMAGELIST CreateImageList (const UINT nIDResource);
	void       DestroyImageList(HIMAGELIST hImageList);

	void CreateStation (const int nCmdShow, LPTSTR lpCmdLine);
	void DestroyStation(void);

	void ConvertSystemColor(COLORREF &color);
}


// WinMain
int WINAPI _tWinMain(HINSTANCE hInstance, HINSTANCE /* hPrevInstance */, LPTSTR lpCmdLine, int nCmdShow)
{
	// WinMain() ̖߂l
	WPARAM wParam = 0;

	g_hInstance = hInstance;
	g_hResource = hInstance;

	// AvP[V̏
	switch(InitApplication(lpCmdLine, nCmdShow))
	{
	case IA_ERROR:         goto error;      // G[
	case IA_EXISTSSTATION: goto success;    // łɃXe[V݂
	case IA_SUCCESS:       break;           // 
	}

	// bZ[W[v
	for(;;)
	{
		MSG msg;

		// L[̃bZ[W擾
		const BOOL bResult = ::GetMessage(&msg, NULL, 0, 0);
		if(bResult == 0 || bResult == -1)
		{
			// WM_QUIT or APIG[
			wParam = msg.wParam;
			break;
		}

		// bZ[W
		::TranslateMessage(&msg);
		::DispatchMessage (&msg);
	}

success:
	// ɐǏ㏈Lq

error:
	// 狤ʂ̌㏈
	ExitApplication();

	return static_cast<int>(wParam);
}

// bZ[W{bNX
int AppMessageBox(HWND hWnd, const wgc::tstring_t &text, const UINT uType /* = MB_OK | MB_ICONEXCLAMATION */)
{
	// LvV擾
	wgc::tstring_t caption;
	AppLoadString(IDR_MAINFRAME, caption);

	return ::MessageBox(hWnd, text.c_str(), caption.c_str(), uType);
}

int AppMessageBox(HWND hWnd, const UINT nIDResource, const UINT uType /* = MB_OK | MB_ICONEXCLAMATION */)
{
	// bZ[W擾
	wgc::tstring_t text;
	AppLoadString(nIDResource, text);

	return AppMessageBox(hWnd, text, uType);
}

int AppMessageBoxFormat(HWND hWnd, const UINT nIDResource, const UINT uType /* = MB_OK | MB_ICONEXCLAMATION */, ...)
{
	// bZ[W擾
	wgc::tstring_t text;
	AppLoadString(nIDResource, text);

	// ψ̏
	va_list va;
	va_start(va, uType);
	{
		// ::FormatMessage() ŃtH[}beBO
		LPTSTR lpBuffer = NULL;
		::FormatMessage(
			FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_STRING,
			text.c_str(),
			0, 0,
			reinterpret_cast<LPTSTR>(&lpBuffer), 0,
			&va);

		text = lpBuffer;
		::LocalFree(lpBuffer);
	}
	va_end(va);

	return AppMessageBox(hWnd, text, uType);
}

int AppSystemMessageBox(HWND hWnd, const DWORD dwErrorCode, const UINT uType /* = MB_OK | MB_ICONEXCLAMATION */)
{
	// dwErrorCode ̎G[bZ[W擾
	wgc::tstring_t text;
	wgc::wgfGetErrorMessage(dwErrorCode, text);

	// bZ[W{bNX\
	return AppMessageBox(hWnd, text, uType);
}

// XgO\[X
int AppLoadString(const UINT uID, wgc::tstring_t &tstr)
{
	return wgc::wgfLoadString(GetResourceHandle(), uID, tstr);
}


// enh̎擾
HINSTANCE GetInstanceHandle(void)
{
	return g_hInstance;
}

HINSTANCE GetResourceHandle(void)
{
	return g_hResource;
}

void SetResourceHandle(HINSTANCE hResource)
{
	assert(hResource != NULL);
	g_hResource = hResource;
}

HACCEL GetAcceleratorHandle(void)
{
	return g_hAccelerator;
}

HIMAGELIST GetImageList_ToolBarXP(void)
{
	return g_hImageList;
}

HIMAGELIST GetImageList_ToolBarXP_Hot(void)
{
	return g_hHotImageList;
}

HIMAGELIST GetImageList_ToolBarXP_Disabled(void)
{
	return g_hDisabledImageList;
}

// vpeB̎擾/ݒ
void GetWindowPlacementParameter(WINDOWPLACEMENT &rWndPl)
{
	wgc::CriticalSection::Lock lock(g_csWndPl);
	rWndPl = g_wndpl;
}

void SetWindowPlacementParameter(const WINDOWPLACEMENT &rWndPl)
{
	wgc::CriticalSection::Lock lock(g_csWndPl);
	g_wndpl = rWndPl;
}

void GetMainFrameProperty(MAINFRAME_PROPERTY &prMainFrame)
{
	wgc::CriticalSection::Lock lock(g_csMainFrame);
	prMainFrame = g_prMainFrame;
}

void SetMainFrameProperty(const MAINFRAME_PROPERTY &prMainFrame)
{
	wgc::CriticalSection::Lock lock(g_csMainFrame);
	g_prMainFrame = prMainFrame;
}

void GetEditViewProperty(EDITVIEW_PROPERTY &prEditView, KEYWORD_INFO &prKeyword, const UINT_PTR nIndex /* = 0 */)
{
	wgc::CriticalSection::Lock lock(g_csEditView);
	prEditView = g_prEditView_Array[nIndex];
	prKeyword  = g_prEditViewKeyword_Array[nIndex];

	// VXeJ[̏
	ConvertSystemColor(prEditView.infoText.colorLine);
	ConvertSystemColor(prEditView.fcDefault.colorText);
	ConvertSystemColor(prEditView.fcDefault.colorBack);
	ConvertSystemColor(prEditView.fcSelect.colorText);
	ConvertSystemColor(prEditView.fcSelect.colorBack);
	ConvertSystemColor(prEditView.fcMark.colorText);
	ConvertSystemColor(prEditView.fcMark.colorBack);
	ConvertSystemColor(prEditView.fcLineNumber.colorText);
	ConvertSystemColor(prEditView.fcLineNumber.colorBack);
	ConvertSystemColor(prEditView.fcRuler.colorText);
	ConvertSystemColor(prEditView.fcRuler.colorBack);
}

void SetEditViewProperty(const EDITVIEW_PROPERTY &prEditView, const KEYWORD_INFO &prKeyword, const UINT_PTR nIndex /* = 0 */)
{
	wgc::CriticalSection::Lock lock(g_csEditView);
	g_prEditView_Array[nIndex] = prEditView;
	g_prEditViewKeyword_Array[nIndex] = prKeyword;
}

UINT_PTR GetEditViewPropertySize(void)
{
	wgc::CriticalSection::Lock lock(g_csEditView);
	return g_prEditView_Array.size();
}

// Xe[VɃTuXbhĨbZ[W𑗂
void Station_NotifyExitFrameThread(FrameThread *pFrameThread)
{
	assert(g_pStation != NULL);
	g_pStation->NotifyExitFrameThread(pFrameThread);
}

// HTMLwv APIĂяo
void Station_SendHelpMessage(const UINT uCommand)
{
	g_pStation->SendHelpMessage(uCommand);
}


////////////////////////////////////////////////////////////
// anonymous namespace
namespace
{

// AvP[V̏iXe[V̍쐬j
int InitApplication(LPTSTR lpCmdLine, const int nCmdShow)
{
	try
	{
		// {block}
		// łɋNĂXe[VΊۓ
		{
			HWND hWnd = Station::FindStation();
			if(hWnd != NULL)
			{
				Station::PostCommandLine(hWnd, lpCmdLine);
				return IA_EXISTSSTATION;
			}
		}

		sgc::init();

		// e평
		HtmlHelp_Init();
		::OleInitialize(NULL);

		// EChENX̓o^
		Station  ::Register();
		MainFrame::Register();
		EditView ::Register();

		// ݒ̃[h
		Setting_LoadStatus         ();
		Setting_LoadWindowPlacement(g_wndpl);
		Setting_LoadProperty       (g_prMainFrame);
		Setting_LoadViewProperty   (g_prEditView_Array, g_prEditViewKeyword_Array);

		// e탊\[X̊m
		LoadAccelerator();                      // ANZ[^

		// C[WXg̍쐬
		g_hImageList         = CreateImageList(IDB_TOOLBAR_XP);
		g_hHotImageList      = CreateImageList(IDB_TOOLBAR_XP_HOT);
		g_hDisabledImageList = CreateImageList(IDB_TOOLBAR_XP_DISABLED);

		// Xe[V쐬
		CreateStation(nCmdShow, lpCmdLine);
		return IA_SUCCESS;
	}
	catch(const DWORD dwLastError)
	{
		AppSystemMessageBox(NULL, dwLastError);
		return IA_ERROR;
	}
}

// CX^X̏I
BOOL ExitApplication(void)
{
	DestroyStation();                       // Xe[Vj

	// C[WXg̔j
	DestroyImageList(g_hImageList        ); g_hImageList         = NULL;
	DestroyImageList(g_hHotImageList     ); g_hHotImageList      = NULL;
	DestroyImageList(g_hDisabledImageList); g_hDisabledImageList = NULL;

	FreeAccelerator();                      // ANZ[^J

	// ݒ̃Z[u
	Setting_SaveViewProperty   (g_prEditView_Array, g_prEditViewKeyword_Array);
	Setting_SaveProperty       (g_prMainFrame);
	Setting_SaveWindowPlacement(g_wndpl);
	Setting_SaveStatus         ();

	// I
	::OleUninitialize();
	HtmlHelp_End();                         // ȍ~APIĂ΂Ȃ
	return TRUE;
}


// e평/I

// ANZ[^[h
void LoadAccelerator(void)
{
	g_hAccelerator = ::LoadAccelerators(
		GetResourceHandle(),
		MAKEINTRESOURCE(IDR_MAINFRAME));
	if(g_hAccelerator == NULL)
	{
		wgc::wgfThrowLastError();
	}
}

// ANZ[^J
void FreeAccelerator(void)
{
	// Ƃ肠邱ƂȂ
}

// C[WXg쐬
HIMAGELIST CreateImageList(const UINT nIDResource)
{
	// ̃C[WXg쐬
	HIMAGELIST hImageList = ::ImageList_Create(
		IMAGELIST_WIDTH, IMAGELIST_HEIGHT,
		ILC_COLOR32 | ILC_MASK,
		0, IMAGELIST_GROW);

	// {block}
	// rbg}bvǉ
	{
		HINSTANCE  hResource = GetResourceHandle();
		HBITMAP    hBitmap   = ::LoadBitmap(hResource, MAKEINTRESOURCE(nIDResource));

		RGBQUAD mask;
		::GetBitmapBits(hBitmap, sizeof(mask), &mask);
		ImageList_AddMasked(hImageList, hBitmap, RGB(mask.rgbRed, mask.rgbGreen, mask.rgbBlue));

		::DeleteObject(hBitmap);
	}
	return hImageList;
}

// C[WXgj
void DestroyImageList(HIMAGELIST hImageList)
{
	::ImageList_Destroy(hImageList);
}


// Xe[V쐬
void CreateStation(const int nCmdShow, LPTSTR lpCmdLine)
{
	g_pStation = Station::CreateStation(nCmdShow, lpCmdLine);
}

// Xe[Vj
void DestroyStation(void)
{
	// ̎_ł̓Xe[V͔jĂ͂
	delete g_pStation;
	g_pStation = NULL;
}

void ConvertSystemColor(COLORREF &color)
{
	if(color & 0xff000000)
	{
		const int index = color & 0x00ffffff;
		color = ::GetSysColor(index);
	}
}

}
