// MainFrame.cpp
#include "MainFrame.h"
#include "Station.h"
#include "HtmlHelp_Utility.h"           // HtmlHelp_Execute()
#include "Setting.h"                    // Setting_SaveWindowPlacement()
#include "CodePage.h"                   // CodePage_AutoDetect()
#include "Dialog/About.h"
#include "Dialog/Jump.h"
#include "Dialog/Property.h"
#include "Dialog/Customize.h"
#include <assert.h>                     // assert()
#include <shlwapi.h>                    // ::PathFindFileName()


#define CLASSNAME_MAINFRAME     _T("MaxyMainFrame")

#define STR_MODIFIED    _T(" *")
#define STR_HYPHEN      _T(" - ")
#define STR_URL         _T("http://maxy.sourceforge.jp/")
#define STR_FILTER_ALL  _T("*.*")

#define STR_EXT_BACKUP  _T(".mbk");

// EChEbZ[W
#define MAXY_GETPATHNAME    (WM_USER + 100)
#define MAXY_REFRECT_FRAME  (WM_USER + 101)
#define MAXY_REFRECT_VIEW   (WM_USER + 102)

// Rg[ID
#define IDW_EDIT_VIEW   550

// ^C}ID
#define IDT_UPDATE_COMMAND_UI       100 // R}hUIXV

// ^C}Ԋu
#define ELAPSE_UPDATE_COMMAND_UI    50  // R}hUIXV

// Xe[^Xo[̃yCԍ
#define STATUS_PANE_IDLE        0       // ACh
#define STATUS_PANE_READONLY    1       // 
#define STATUS_PANE_OVERWRITE   2       // ㏑
#define STATUS_PANE_SIMPLE      255     // Vv[h̃yCԍ


// RXgNV
MainFrame::MainFrame(void)
	: m_hFile(INVALID_HANDLE_VALUE),
	m_uViewPropertyType(0),
	m_uCodePage(CP_ACP),
	m_bActive(FALSE), m_bCloseAll(FALSE)
{
	m_ftUpdate.dwLowDateTime  = 0;
	m_ftUpdate.dwHighDateTime = 0;

	// {block}
	// GfBbgR|[lg̃hLg쐬
	{
		EDITVIEW_PROPERTY prView;
		KEYWORD_INFO      prKeyword;
		GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);

		HCURSOR hCursorMargin = ::LoadCursor(GetResourceHandle(), MAKEINTRESOURCE(IDC_MARGIN));
		EditDocPtr pEditDoc(new EditDoc(this, prView, hCursorMargin));

		m_pEditDoc = pEditDoc;
	}
}

MainFrame::~MainFrame(void)
{
	if(m_hFile != INVALID_HANDLE_VALUE)
	{
		::CloseHandle(m_hFile);
		m_hFile = INVALID_HANDLE_VALUE;
	}
}


// EChENX̓o^(static)
void MainFrame::Register(void)
{
	HINSTANCE hInstance = ::GetModuleHandle(NULL);
	HICON     hIcon     = ::LoadIcon  (GetResourceHandle(), MAKEINTRESOURCE(IDR_MAINFRAME));
	HCURSOR   hCursor   = ::LoadCursor(NULL, IDC_ARROW);

	WNDCLASS wc;
	wc.style         = CS_BYTEALIGNCLIENT | CS_BYTEALIGNWINDOW;
	wc.lpfnWndProc   = _WindowProcBase;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = hInstance;
	wc.hIcon         = hIcon;
	wc.hCursor       = hCursor;
	wc.hbrBackground = NULL;
	wc.lpszMenuName  = MAKEINTRESOURCE(IDR_MAINFRAME);
	wc.lpszClassName = CLASSNAME_MAINFRAME;
	if(::RegisterClass(&wc) == 0)
	{
		wgc::wgfThrowLastError();
	}
}

// wEChECt[H
BOOL MainFrame::IsMainFrame(HWND hWnd)
{
	// EChENX擾
	TCHAR szClassName[256];
	::GetClassName(hWnd, szClassName, countof(szClassName));

	// NXCt[łȂΌs
	return ::lstrcmpi(szClassName, CLASSNAME_MAINFRAME) == 0;
}


// VKt[̍쐬(static)
MainFrame *MainFrame::CreateFrame(const CREATEFRAME_PARAMETER *lpParameter, const LPWINDOWPLACEMENT lpWndPl)
{
	// Ct[IuWFNg쐬
	MainFrame *pMainFrame = new MainFrame;

	// Ct[쐬
	const BOOL bResult = pMainFrame->Create(
		CLASSNAME_MAINFRAME, _T(""),
		WS_OVERLAPPEDWINDOW,
		WS_EX_ACCEPTFILES,
		NULL, NULL, NULL,
		CW_USEDEFAULT, CW_USEDEFAULT,
		CW_USEDEFAULT, CW_USEDEFAULT);
	if(!bResult)
	{
		DeleteFrame(pMainFrame);
		wgc::wgfThrowLastError();
	}

	if(lpWndPl)
	{
		pMainFrame->SetWindowPlacement(*lpWndPl);
	}
	else
	{
		// Ct[\
		pMainFrame->ShowWindow(lpParameter->nCmdShow);
	}
	pMainFrame->UpdateWindow();

	// t@Cw肳ĂJ
	if(lpParameter->szPathName[0] != wgc::tNUL)
	{
		pMainFrame->OpenDocumentFile(lpParameter->szPathName, -1, lpParameter->bReadOnly, lpParameter->nCodePage);
		pMainFrame->m_pEditDoc->JumpToLine(lpParameter->nLineNumber);
	}
	return pMainFrame;
}

// t[̍폜(static)
void MainFrame::DeleteFrame(MainFrame *pMainFrame)
{
	delete pMainFrame;
}


// wt@CҏW̃t[擾
HWND MainFrame::GetEditingFrame(LPCTSTR lpszPathName)
{
	FINDWINDOW fw = {NULL, lpszPathName};
	const BOOL bResult = ::EnumWindows(FindWindowProc, reinterpret_cast<LPARAM>(&fw));
	if(bResult)
	{
		return NULL;
	}

	return fw.hWnd;
}


////////////////////////////////////////////////////////////
// EChEvV[W
LRESULT CALLBACK MainFrame::WindowProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case MAXY_GETPATHNAME:                  // LփCt[
		OnMaxyGetPathName(reinterpret_cast<LPTSTR>(lParam), wParam);
		return 0;

	case MAXY_REFRECT_FRAME:
		OnMaxyRefrectFrame();
		return 0;

	case MAXY_REFRECT_VIEW:
		OnMaxyRefrectView(wParam);
		return 0;
	}
	return Window::WindowProc(uMsg, wParam, lParam);
}


////////////////////////////////////////////////////////////
// z֐

void MainFrame::PostNcDestroy(void)
{
	// uׂĕvȂÃt[ IDM_FILE_CLOSE_ALL R}h𑗂
	if(m_bCloseAll)
	{
		// ̎_ł̓EChEjIĂ̂
		// ::FindWindow() ݂̃vZX̃Ct[wƂ͂Ȃ
		HWND hWnd = ::FindWindow(CLASSNAME_MAINFRAME, NULL);
		if(hWnd != NULL)
		{
			::PostMessage(
				hWnd,
				WM_COMMAND,
				MAKEWPARAM(IDM_FILE_CLOSE_ALL, 0),
				0);
		}
	}
}


////////////////////////////////////////////////////////////
// bZ[Wnh

////////////////////////////////////////
// RXgNV

// EChE쐬Ej
int MainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if(Window::OnCreate(lpCreateStruct) == -1)
	{
		return -1;
	}

	// ^C}ݒ
	SetTimer(IDT_UPDATE_COMMAND_UI, ELAPSE_UPDATE_COMMAND_UI);

	// R|[lg쐬
	if(!CreateControlBar   ()) { return -1; }
	if(!CreateEditComponent()) { return -1; }

	AppendSettingMenu();

	// ftHg̃^Cg쐬
	UpdateFrameTitle();
	return 0;
}

void MainFrame::OnClose(void)
{
	try
	{
		// ύXꍇ
		if(m_pEditDoc->IsModified())
		{
			switch(MessageBox_AskToSave())
			{
			case IDYES:
				// YESȂۑ
				if(!Save())
				{
					// ۑɎs璆~
					m_bCloseAll = FALSE;
					return;
				}
				break;

			case IDNO:
				// NOȂ疳ɕ
				break;

			case IDCANCEL:
				// LZȂ璆~
				m_bCloseAll = FALSE;
				return;
			}
		}
		DestroyWindow();
	}
	catch(const DWORD dwLastError)
	{
		AppSystemMessageBox(m_hWnd, dwLastError);
	}
}

void MainFrame::OnDestroy(void)
{
	// {block}
	// EChȄԂL^
	{
		WINDOWPLACEMENT wndpl;
		GetWindowPlacement(wndpl);
		SetWindowPlacementParameter(wndpl);
	}

	// c[o[ۑ
	ToolSaveRestore(TRUE);

	// ^C}
	KillTimer(IDT_UPDATE_COMMAND_UI);

	::PostQuitMessage(0);
}


// ZbVI
void MainFrame::OnEndSession(const BOOL bEnding, const BOOL /* bLogOff */)
{
	// IȂ or t@CȂ牽Ȃ
	if(!bEnding || m_strPathName.empty())
	{
		return;
	}

	// ҏW̃t@C".mbk"t@CŃobNAbvۑ
	wgc::tstring_t strPathName = m_strPathName + STR_EXT_BACKUP;
	wgc::File file(strPathName.c_str(), GENERIC_WRITE);
	WriteTextData(file);
}


// TCYύX
void MainFrame::OnSize(const UINT nType, const int cx, const int cy)
{
	Window::OnSize(nType, cx, cy);

	// c[o[AXe[^Xo[̒
	m_cToolBar  .SendMessage(WM_SIZE);
	m_cStatusBar.SendMessage(WM_SIZE);

	// GfBbgR|[lg̒
	RecalcEditLayout();
}


// ^C}
void MainFrame::OnTimer(const UINT uIDEvent)
{
	switch(uIDEvent)
	{
	case IDT_UPDATE_COMMAND_UI:
		// c[o[XV
		UpdateCommand(command_interface_toolbar(m_cToolBar));
		break;
	}
}


// ANeBu/ANeBu
void MainFrame::OnActivate(const UINT nState, const BOOL /* bMinimized */, HWND /* hWndPrevious */)
{
	m_bActive = (nState != WA_INACTIVE);

	// Ct[̃vpeB擾
	MAINFRAME_PROPERTY prFrame;
	GetMainFrameProperty(prFrame);

	// ^Cgo[XV
	UpdateFrameTitle();

	// XV`FbN
	if(m_bActive && prFrame.flags.elements.bCheckTimeStampOnActive)
	{
		if(IsUpdated())
		{
			if(MessageBox_AskToReload() == IDYES)
			{
				// ēǂݍ
				OpenDocumentFile(m_strPathName.c_str(), m_uViewPropertyType, TRUE, CODEPAGE_ERROR);
			}
		}
	}
}

// tH[JX
void MainFrame::OnSetFocus(HWND /* hWndLoseFocus */)
{
	// ANeBuȃr[ɃtH[JXݒ
	m_pEditDoc->SetFocusTo();
}


// j[
void MainFrame::OnInitMenu(HMENU hMenu)
{
	UpdateCommand(command_interface_menu(hMenu));
}

// j[̍ڂ̑I
void MainFrame::OnMenuSelect(const UINT nItemID, const UINT nFlags, HMENU /* hSysMenu */)
{
	// Xe[^Xo[Ƀj[R}h\
	SetStatusMessageCommand(nItemID, nFlags);
}

// j[[v̊Jn
void MainFrame::OnEnterMenuLoop(const BOOL /* bIsTrackPopupMenu */)
{
	// Xe[^Xo[Vv[hɂ
	m_cStatusBar.SetSimple();
}

// j[[v̏I
void MainFrame::OnExitMenuLoop(const BOOL /* bIsTrackPopupMenu */)
{
	// Xe[^Xo[ɖ߂
	m_cStatusBar.SetSimple(FALSE);

	// Xe[^Xo[ɃAChbZ[W\
	SetStatusMessageIdle();
}


// t@C̃hbv
void MainFrame::OnDropFiles(HDROP hDrop)
{
	try
	{
		// hbvꂽt@C擾
		const UINT uFileCount = ::DragQueryFile(hDrop, static_cast<UINT>(-1), NULL, 0);
		for(UINT i = 0; i < uFileCount; i++)
		{
			// hbvꂽt@C擾
			const UINT uNameLength = ::DragQueryFile(hDrop, i, NULL, 0);

			sgc::array<TCHAR> name_buffer(uNameLength + 1);
			::DragQueryFile(
				hDrop,
				i,
				name_buffer, static_cast<UINT>(name_buffer.size()));

			Open(name_buffer);
		}

		::DragFinish(hDrop);
	}
	catch(const DWORD dwLastError)
	{
		AppSystemMessageBox(m_hWnd, dwLastError);
	}
}


// ʒmbZ[W
BOOL MainFrame::OnNotify(const int nIdCtrl, LPNMHDR lpNmHeader)
{
	// c[`bv
	if(lpNmHeader->code == TTN_NEEDTEXT)
	{
		SetToolTip(nIdCtrl, reinterpret_cast<LPTOOLTIPTEXT>(lpNmHeader));
		return TRUE;
	}

	BOOL bResult = TRUE;
	switch(nIdCtrl)
	{
	case 0:                                 // GfBbgR|[lg
		switch(lpNmHeader->code)
		{
		case XEN_READONLYCHANGED:               // ֎~ύXꂽ
			OnNotifyXENReadonlyChanged();
			return FALSE;

		case XEN_OVERWRITECHANGED:              // ㏑ύXꂽ
			OnNotifyXENOverwriteChanged();
			return FALSE;

		case XEN_MODIFYCHANGED:                 // _[eBtOύXꂽ
			OnNotifyXENModifyChanged();
			return FALSE;
		}
		break;

	case IDW_STD_TOOLBAR:                   // c[o[̒ʒmbZ[W
		if(m_cToolBar.HandleNotifyMessage(lpNmHeader, bResult))
		{
			return bResult;
		}
		break;
	}

	return Window::OnNotify(nIdCtrl, lpNmHeader);
}

// R}h
BOOL MainFrame::OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl)
{
	// R}hbZ[W
	switch(wID)
	{
	// t@C
	case IDM_FILE_NEW:       OnCommandFileNew     (); return FALSE;
	case IDM_FILE_OPEN:      OnCommandFileOpen    (); return FALSE;
	case IDM_FILE_SAVE:      OnCommandFileSave    (); return FALSE;
	case IDM_FILE_SAVE_AS:   OnCommandFileSaveAs  (); return FALSE;
	case IDM_FILE_CLOSE:     OnCommandFileClose   (); return FALSE;
	case IDM_FILE_CLOSE_ALL: OnCommandFileCloseAll(); return FALSE;


	// ҏW
	case IDM_EDIT_UNDO: OnCommandEditUndo(); return FALSE;
	case IDM_EDIT_REDO: OnCommandEditRedo(); return FALSE;

	case IDM_EDIT_CUT:   OnCommandEditCut  (); return FALSE;
	case IDM_EDIT_COPY:  OnCommandEditCopy (); return FALSE;
	case IDM_EDIT_CLEAR: OnCommandEditClear(); return FALSE;
	case IDM_EDIT_PASTE: OnCommandEditPaste(); return FALSE;

	case IDM_EDIT_RECONVERT: OnCommandEditReconvert(); return FALSE;

	case IDM_EDIT_JUMP: OnCommandEditJump(); return FALSE;

	case IDM_EDIT_READONLY: OnCommandEditReadonly(); return FALSE;

	// \
	case IDM_VIEW_BAR_TOOLBAR:   OnCommandViewBarToolbar  (); return FALSE;
	case IDM_VIEW_BAR_STATUSBAR: OnCommandViewBarStatusbar(); return FALSE;

	case IDM_VIEW_TOPMOST: OnCommandViewTopmost(); return FALSE;


	// ݒ
	case IDM_SETTING_PROPERTY:  OnCommandSettingProperty();  return FALSE;
	case IDM_SETTING_CUSTOMIZE: OnCommandSettingCustomize(); return FALSE;


	// wv
	case IDM_HELP_INDEX:   OnCommandHelpIndex  (); return FALSE;
	case IDM_HELP_KEYWORD: OnCommandHelpKeyword(); return FALSE;
	case IDM_HELP_FINDER:  OnCommandHelpFinder (); return FALSE;
	case IDM_HELP_WEBPAGE: OnCommandHelpWebpage(); return FALSE;
	case IDM_HELP_ABOUT:   OnCommandHelpAbout  (); return FALSE;

	default:
		// ͈͎w肳ꂽR}h
		if(IDM_SETTING_CHANGE_NONE <= wID && wID < IDM_SETTING_CHANGE_NONE + MAX_SETTING_COUNT)
		{
			OnCommandSettingChange(wID);
			return FALSE;
		}
	}

	return Window::OnCommand(wNotifyCode, wID, hWndCtrl);
}

void MainFrame::OnSysColorChange(void)
{
	ReloadSetting();
}


////////////////////////////////////////////////////////////
// ƎbZ[W

// LփCt[
BOOL MainFrame::OnMaxyGetPathName(LPTSTR lpszPathName, const SIZE_T cchPathName) const
{
	try
	{
		::lstrcpyn(
			lpszPathName,
			m_strPathName.c_str(),
			static_cast<int>(cchPathName));

		return TRUE;
	}
	catch(const DWORD /* dwLastError */)
	{
		return FALSE;
	}
}

void MainFrame::OnMaxyRefrectFrame(void)
{
	UpdateFrameTitle();
}

void MainFrame::OnMaxyRefrectView(const UINT_PTR uIndex)
{
	if(uIndex == m_uViewPropertyType)
	{
		ReloadSetting();
	}
}


////////////////////////////////////////////////////////////
// R}hnh

// [t@C]
// VK쐬
void MainFrame::OnCommandFileNew(void)
{
	try
	{
		Station::CreateFrameThread();
	}
	catch(const DWORD dwLastError)
	{
		AppSystemMessageBox(m_hWnd, dwLastError);
	}
}

// J
void MainFrame::OnCommandFileOpen(void)
{
	try
	{
		Open();
	}
	catch(const DWORD dwLastError)
	{
		AppSystemMessageBox(m_hWnd, dwLastError);
	}
}

// ۑ
void MainFrame::OnCommandFileSave(void)
{
	try
	{
		// t@CɓǂݎpĂ疼Otĕۑ
		Save(wgc::File::IsReadOnly(m_strPathName.c_str()));
	}
	catch(const DWORD dwLastError)
	{
		AppSystemMessageBox(m_hWnd, dwLastError);
	}
}

// Otĕۑ
void MainFrame::OnCommandFileSaveAs(void)
{
	try
	{
		Save(TRUE);
	}
	catch(const DWORD dwLastError)
	{
		AppSystemMessageBox(m_hWnd, dwLastError);
	}
}

// 
void MainFrame::OnCommandFileClose(void)
{
	PostMessage(WM_CLOSE);
}

// ׂĕ
void MainFrame::OnCommandFileCloseAll(void)
{
	m_bCloseAll = TRUE;
	PostMessage(WM_CLOSE);
}

void MainFrame::OnUpdateFileSave(const command_interface &ci) const
{
	ci.enable(IDM_FILE_SAVE, m_pEditDoc->IsModified());
}


// [ҏW]
// AhD
void MainFrame::OnCommandEditUndo(void)
{
	m_pEditDoc->Undo();
}

// hD
void MainFrame::OnCommandEditRedo(void)
{
	m_pEditDoc->Redo();
}

// Jbgi؂j
void MainFrame::OnCommandEditCut(void)
{
	m_pEditDoc->Cut();
}

// Rs[
void MainFrame::OnCommandEditCopy(void)
{
	m_pEditDoc->Copy();
}

// NAi폜j
void MainFrame::OnCommandEditClear(void)
{
	m_pEditDoc->Clear();
}

// \t
void MainFrame::OnCommandEditPaste(void)
{
	m_pEditDoc->Paste();
}

// ĕϊ
void MainFrame::OnCommandEditReconvert(void)
{
	m_pEditDoc->Reconvert();
}

// Wv
void MainFrame::OnCommandEditJump(void)
{
	DIALOGPROPERTY_JUMP property = { m_pEditDoc->GetNowLine() };

	DialogJump dlg(property, m_hWnd);
	if(dlg.DoModal() == IDOK)
	{
		// wsփWv
		m_pEditDoc->JumpToLine(property.nLineNumber);
	}
}

// ֎~
void MainFrame::OnCommandEditReadonly(void)
{
	m_pEditDoc->ToggleReadOnly();
}


void MainFrame::OnUpdateEditUndo(const command_interface &ci) const
{
	ci.enable(IDM_EDIT_UNDO, m_pEditDoc->CanUndo());
}

void MainFrame::OnUpdateEditRedo(const command_interface &ci) const
{
	ci.enable(IDM_EDIT_REDO, m_pEditDoc->CanRedo());
}

void MainFrame::OnUpdateEditCut(const command_interface &ci) const
{
	ci.enable(IDM_EDIT_CUT, m_pEditDoc->IsSelected());
}

void MainFrame::OnUpdateEditCopy(const command_interface &ci) const
{
	ci.enable(IDM_EDIT_COPY, m_pEditDoc->IsSelected());
}

void MainFrame::OnUpdateEditPaste(const command_interface &ci) const
{
	ci.enable(IDM_EDIT_PASTE, m_pEditDoc->CanPaste());
}

void MainFrame::OnUpdateEditClear(const command_interface &ci) const
{
	ci.enable(IDM_EDIT_CLEAR, m_pEditDoc->IsSelected());
}

void MainFrame::OnUpdateEditReadonly(const command_interface &ci) const
{
	// JĂt@CAobt@ύXĂȂΕύX
	ci.enable(IDM_EDIT_READONLY, !m_strPathName.empty() && !m_pEditDoc->IsModified());
	ci.check (IDM_EDIT_READONLY, m_pEditDoc->IsReadOnly());
}


// [\]
// c[o[
void MainFrame::OnCommandViewBarToolbar(void)
{
	const DWORD dwStyle = m_cToolBar.GetStyle();
	m_cToolBar.SetStyle(dwStyle ^ WS_VISIBLE);

	RecalcEditLayout();
}

// Xe[^Xo[
void MainFrame::OnCommandViewBarStatusbar(void)
{
	const DWORD dwStyle = m_cStatusBar.GetStyle();
	m_cStatusBar.SetStyle(dwStyle ^ WS_VISIBLE);

	RecalcEditLayout();
}

// ɎOɕ\
void MainFrame::OnCommandViewTopmost(void)
{
	SetTopmost(!IsTopmost());
}

void MainFrame::OnUpdateViewBar(const command_interface &ci) const
{
	ci.check(IDM_VIEW_BAR_TOOLBAR  , m_cToolBar.GetStyle  () & WS_VISIBLE);
	ci.check(IDM_VIEW_BAR_STATUSBAR, m_cStatusBar.GetStyle() & WS_VISIBLE);
}

void MainFrame::OnUpdateViewTopmost(const command_interface &ci) const
{
	ci.check(IDM_VIEW_TOPMOST, IsTopmost());
}


// [ݒ]

// ݒ̕ύX
void MainFrame::OnCommandSettingChange(const int nID)
{
	m_uViewPropertyType = nID - IDM_SETTING_CHANGE_NONE;

	EDITVIEW_PROPERTY prView;
	KEYWORD_INFO      prKeyword;
	GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);

	m_pEditDoc->SetViewProperty(prView, prKeyword);
}

// vpeB
void MainFrame::OnCommandSettingProperty(void)
{
	EDITVIEW_PROPERTY prView;
	KEYWORD_INFO      prKeyword;
	GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);

	DIALOGPROPERTY_PROPERTY property =
	{
		// {
		{
			prView.infoText.flags.elements.bOpenIME,
		},

		// \
		{
			prView.flags.elements.bDisplayRuler,
			prView.flags.elements.bDisplayLineNumber,
			prView.flags.elements.bDisplayUnderline,
		},
	};

	DialogProperty dlg(property, m_hWnd);
	if(dlg.DoModal() == IDOK)
	{
		// {
		prView.infoText.flags.elements.bOpenIME = property.basic.bOpenIME;

		// \
		prView.flags.elements.bDisplayRuler      = property.display.bDisplayRuler;
		prView.flags.elements.bDisplayLineNumber = property.display.bDisplayLineNumber;
		prView.flags.elements.bDisplayUnderline  = property.display.bDisplayUnderline;

		SetEditViewProperty(prView, prKeyword, m_uViewPropertyType);
		RefrectSetting_View();
	}
}

// JX^}CY
void MainFrame::OnCommandSettingCustomize(void)
{
	MAINFRAME_PROPERTY prFrame;
	GetMainFrameProperty(prFrame);

	DIALOGPROPERTY_CUSTOMIZE property =
	{
		prFrame.dwExclusionMode,
		prFrame.flags.elements.bCheckTimeStampOnActive,
		prFrame.flags.elements.bOpenByThisFrame,

		prFrame.flags.elements.bRestorePlacement,
		prFrame.flags.elements.bDisplayFullpathOnActive,
		prFrame.flags.elements.bDisplayFullpathOnInactive,
	};

	DialogCustomize dlg(property, m_hWnd);
	if(dlg.DoModal() == IDOK)
	{
		prFrame.dwExclusionMode = property.nExclution;
		prFrame.flags.elements.bCheckTimeStampOnActive = property.bCheckTimeStampOnActive;
		prFrame.flags.elements.bOpenByThisFrame        = property.bOpenByThisFrame;

		prFrame.flags.elements.bRestorePlacement          = property.bRestorePlacement;
		prFrame.flags.elements.bDisplayFullpathOnActive   = property.bDisplayFullpathOnActive;
		prFrame.flags.elements.bDisplayFullpathOnInactive = property.bDisplayFullpathOnInactive;

		SetMainFrameProperty(prFrame);
		RefrectSetting_Frame();
	}
}

void MainFrame::OnUpdateSettingChange(const command_interface &ci) const
{
	ci.radio(
		IDM_SETTING_CHANGE_NONE,
		IDM_SETTING_CHANGE_NONE + static_cast<UINT>(GetEditViewPropertySize()),
		IDM_SETTING_CHANGE_NONE + static_cast<UINT>(m_uViewPropertyType));
}

void MainFrame::OnUpdateSettingProperty(const command_interface &ci) const
{
	const BOOL bEnable = (m_uViewPropertyType != 0);
	ci.enable(IDM_SETTING_PROPERTY, bEnable);
}


// [wv]
// ڎ
void MainFrame::OnCommandHelpIndex(void)
{
	SendHelpMessage(HH_DISPLAY_TOC);
}

// L[[h
void MainFrame::OnCommandHelpKeyword(void)
{
	SendHelpMessage(HH_DISPLAY_INDEX);
}

// 
void MainFrame::OnCommandHelpFinder(void)
{
	SendHelpMessage(HH_DISPLAY_SEARCH);
}

// ҂̃z[y[W\
void MainFrame::OnCommandHelpWebpage(void)
{
	::ShellExecute(NULL, NULL, STR_URL, NULL, NULL, SW_SHOWNORMAL);
}

// Maxyɂ
void MainFrame::OnCommandHelpAbout()
{
	DialogAbout dlg(m_hWnd);
	dlg.DoModal();
}


// ʒmbZ[W

// GfBbgR|[lg̏֎~̐ݒ/
void MainFrame::OnNotifyXENReadonlyChanged(void)
{
	SetStatusMessageReadonly();
}

// GfBbgR|[lg̏㏑̐ݒ/
void MainFrame::OnNotifyXENOverwriteChanged(void)
{
	SetStatusMessageOverwrite();
}

// GfBbgR|[lg̃_[eBtO̕ύX
void MainFrame::OnNotifyXENModifyChanged(void)
{
	UpdateFrameTitle();
}


////////////////////////////////////////////////////////////
// private o֐

// r[IDvZ
UINT MainFrame::GetNewViewID(void) const
{
	for(UINT uID = IDW_EDIT_VIEW; ; uID++)
	{
		if(GetDlgItem(uID) == NULL)
		{
			return uID;
		}
	}
}


// Rg[o[̍쐬
BOOL MainFrame::CreateControlBar(void)
{
	if(!CreateToolBarStandard()) { return FALSE; }
	if(!CreateStatusBar      ()) { return FALSE; }

	return TRUE;
}

// Wc[o[쐬
BOOL MainFrame::CreateToolBarStandard(void)
{
	// R}hIDꗗ
	const int arCommand[] =
	{
		IDM_FILE_NEW    , IDM_FILE_OPEN         , IDM_FILE_SAVE  , IDM_FILE_SAVE_ALL, IDM_FILE_CLOSE, IDM_FILE_CLOSE_ALL, 0,
		IDM_FILE_PRINT  , IDM_FILE_PRINT_PREVIEW, 0,
		IDM_EDIT_UNDO   , IDM_EDIT_REDO         , 0,
		IDM_EDIT_CUT    , IDM_EDIT_COPY         , IDM_EDIT_PASTE , IDM_EDIT_CLEAR   , 0,
		IDM_VIEW_TOPMOST, 0,
		IDM_HELP_INDEX  , IDM_HELP_WEBPAGE      , IDM_HELP_ABOUT,
	};

	m_cToolBar.Create(
		this,
		GetImageList_ToolBarXP(), GetImageList_ToolBarXP_Hot(), GetImageList_ToolBarXP_Disabled(),
		GetResourceHandle(),
		arCommand, countof(arCommand));

	// c[o[𕜌
	ToolSaveRestore(FALSE);

	return TRUE;
}

// Xe[^Xo[쐬
BOOL MainFrame::CreateStatusBar(void)
{
	// Xe[^Xo[쐬
	m_cStatusBar.Create(this, _T(""));

	// CWP[^쐬
	if(!SetStatusIndicator())
	{
		return FALSE;
	}

	// ACh\
	return SetStatusMessageIdle();
}

// GfBbgR|[lg쐬
BOOL MainFrame::CreateEditComponent(void)
{
	// 쐬
	const BOOL bResult = m_pEditDoc->CreateView(
		FALSE,
		WS_CHILD | WS_VISIBLE | WS_OVERLAPPED | WS_VSCROLL,
		WS_EX_CLIENTEDGE,
		IDW_EDIT_VIEW);
	if(!bResult)
	{
		return FALSE;
	}

	// TCY
	RecalcEditLayout();

	return TRUE;
}

// ݒ薼j[ɒǉ
BOOL MainFrame::AppendSettingMenu(void)
{
	HMENU hMenu = wgc::wgfFindMenu(GetMenu(), IDM_SETTING_CHANGE_NONE);
	if(hMenu == NULL)
	{
		return FALSE;
	}

	const UINT_PTR nViewPropertySize = GetEditViewPropertySize();
	for(size_t i = 1; i < nViewPropertySize; i++)
	{
		EDITVIEW_PROPERTY prView;
		KEYWORD_INFO      prKeyword;
		GetEditViewProperty(prView, prKeyword, i);

		::InsertMenu(
			hMenu,
			static_cast<UINT>(i),
			MF_BYPOSITION | MF_STRING,
			IDM_SETTING_CHANGE_NONE + i,
			prView.szSettingName);
	}

	DrawMenuBar();
	return TRUE;
}

BOOL MainFrame::DeleteSettingMenu(void)
{
	HMENU hMenu = GetMenu();
	if(hMenu == NULL)
	{
		return FALSE;
	}

	for(int i = IDM_SETTING_CHANGE_NONE + 1; i < IDM_SETTING_CHANGE_CREATE; i++)
	{
		::DeleteMenu(hMenu, i, MF_BYCOMMAND);
	}

	DrawMenuBar();
	return TRUE;
}


// c[`bvݒ
void MainFrame::SetToolTip(const int nIdCtrl, LPTOOLTIPTEXT lpToolTipText)
{
	// XgO\[X當擾
	wgc::tstring_t tstr;
	AppLoadString(nIdCtrl, tstr);

	// '\n'ȍ~̕擾
	wgc::tstring_t text;
	wgc::wgfExtractSubString(text, tstr, 1, wgc::tLF);

	// 擾ݒ
	const size_t size = countof(lpToolTipText->szText);
	::lstrcpyn(lpToolTipText->szText, text.c_str(), size);
}

// c[o[̑
void MainFrame::ToolSaveRestore(const BOOL bSave /* = TRUE */)
{
	TBSAVEPARAMS tbs;
	tbs.hkr          = HKEY_CURRENT_USER;
	tbs.pszSubKey    = REGKEY_SECTION_CUSTOMIZE;
	tbs.pszValueName = REGKEY_ENTRY_CUSTOMIZE_TOOLBAR;
	m_cToolBar.SaveRestore(bSave, tbs);
}

// Xe[^Xo[̑
BOOL MainFrame::SetStatusIndicator(void)
{
	// CWP[^
	const UINT indicators[] =
	{
		IDS_STATUS_INDICATOR_READONLY,      // 
		IDS_STATUS_INDICATOR_OVERWRITE,     // ㏑
	};

	return m_cStatusBar.SetIndicators(
		GetResourceHandle(),
		indicators,
		countof(indicators));
}

// Xe[^Xo[ɃACh\
BOOL MainFrame::SetStatusMessageIdle(void)
{
	wgc::tstring_t text;
	AppLoadString(IDS_STATUS_IDLE, text);

	return m_cStatusBar.SetText(STATUS_PANE_IDLE, SBT_NOBORDERS, text);
}

// Xe[^Xo[Ƀj[R}h̕\
BOOL MainFrame::SetStatusMessageCommand(const UINT nID, const UINT nFlags)
{
	wgc::tstring_t status;
	if(!(nFlags & MF_POPUP))
	{
		wgc::tstring_t text;
		AppLoadString(nID, text);

		// '\n'O̕擾
		wgc::wgfExtractSubString(status, text, 0, wgc::tLF);
	}

	return m_cStatusBar.SetText(STATUS_PANE_SIMPLE, SBT_NOBORDERS, status);
}

// Xe[^Xo[Ɂuցv\
BOOL MainFrame::SetStatusMessageReadonly(void)
{
	wgc::tstring_t text;
	if(m_pEditDoc->IsReadOnly())
	{
		// ǂݍݐpȂXe[^Xo[ɕ\镶擾
		AppLoadString(IDS_STATUS_INDICATOR_READONLY, text);
	}
	// Xe[^Xo[XV
	return m_cStatusBar.SetText(STATUS_PANE_READONLY, 0, text);
}

// Xe[^Xo[Ɂu㏑v\
BOOL MainFrame::SetStatusMessageOverwrite(void)
{
	wgc::tstring_t text;
	if(m_pEditDoc->IsOverwrite())
	{
		// ㏑[hȂXe[^Xo[ɕ\镶擾
		AppLoadString(IDS_STATUS_INDICATOR_OVERWRITE, text);
	}
	// Xe[^Xo[XV
	return m_cStatusBar.SetText(STATUS_PANE_OVERWRITE, 0, text);
}



////////////////////////////////////////////////////////////
// t@C

// uJv_CAO쐬
// IꂽtB^̃CfbNXԂiLZꂽꍇ0Ԃj
DWORD MainFrame::CreateOpenDialog(LPTSTR lpBuffer, const int nBufferSize, BOOL *pbReadOnly) const
{
	// OPENFILENAME\̂̐ݒ
	OPENFILENAME ofn = {sizeof(ofn)};
	ofn.hwndOwner    = m_hWnd;
	ofn.nFilterIndex = static_cast<DWORD>(GetEditViewPropertySize());
	ofn.lpstrFile    = lpBuffer;
	ofn.nMaxFile     = nBufferSize;
	ofn.Flags        = OFN_LONGNAMES | OFN_EXPLORER | OFN_FILEMUSTEXIST;

	// tB^
	const wgc::tstring_t strFilter = CreateDialogFilter();
	ofn.lpstrFilter = strFilter.c_str();

	// _CAO\
	if(!::GetOpenFileName(&ofn))
	{
		return 0;
	}

	// ǂݎptO
	assert(pbReadOnly != NULL);
	*pbReadOnly = ofn.Flags & OFN_READONLY;

	return ofn.nFilterIndex;
}

// uۑv_CAO쐬
// IꂽtB^̃CfbNXԂiLZꂽꍇ0Ԃj
DWORD MainFrame::CreateSaveDialog(LPTSTR lpBuffer, const int nBufferSize) const
{
	EDITVIEW_PROPERTY prView;
	KEYWORD_INFO      prKeyword;
	GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);

	// OPENFILENAME\̂̐ݒ
	OPENFILENAME ofn = {sizeof(ofn)};
	ofn.hwndOwner    = m_hWnd;
	ofn.nFilterIndex = static_cast<DWORD>(GetEditViewPropertySize());
	ofn.lpstrFile    = lpBuffer;
	ofn.lpstrDefExt  = prView.szDefaultExt;
	ofn.nMaxFile     = nBufferSize;
	ofn.Flags        = OFN_LONGNAMES | OFN_EXPLORER | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;

	// tB^
	const wgc::tstring_t strFilter = CreateDialogFilter();
	ofn.lpstrFilter = strFilter.c_str();

	// _CAO\
	if(!::GetSaveFileName(&ofn))
	{
		return 0;
	}

	return ofn.nFilterIndex;
}

// uJvuۑv_CAÕtB^쐬
wgc::tstring_t MainFrame::CreateDialogFilter(const BOOL bAddAllFiles /* = TRUE */) const
{
	const UINT_PTR nViewPropertySize = GetEditViewPropertySize();

	// tB^쐬
	wgc::tstring_t strFilter;
	for(size_t i = 1; i < nViewPropertySize; i++)
	{
		EDITVIEW_PROPERTY prView;
		KEYWORD_INFO      prKeyword;
		GetEditViewProperty(prView, prKeyword, i);

		strFilter += prView.szSettingName;
		strFilter += wgc::tNUL;
		strFilter += prView.szFilter;
		strFilter += wgc::tNUL;
	}

	// uׂẴt@CvŌɒǉ
	if(bAddAllFiles)
	{
		wgc::tstring_t strAllFiles;
		AppLoadString(IDS_FILTER_ALLFILES, strAllFiles);

		strFilter += strAllFiles;
		strFilter += wgc::tNUL;
		strFilter += STR_FILTER_ALL;
		strFilter += wgc::tNUL;
	}
	return strFilter;
}

// t@CAΉtB^̃CfbNXԂ
// ΉtB^Ȃ0Ԃ
UINT_PTR MainFrame::FindFilterIndex(LPCTSTR lpszFileName)
{
	const UINT_PTR nViewPropertySize = GetEditViewPropertySize();

	// ݒ̐JԂi0Ԗڂ̓ftHgݒȂ̂Ŕ΂j
	for(UINT_PTR i = 1; i < nViewPropertySize; i++)
	{
		EDITVIEW_PROPERTY prView;
		KEYWORD_INFO      prKeyword;
		GetEditViewProperty(prView, prKeyword, i);

		// t@Cƃ}b`炱̐ݒ̃CfbNXԂ
		if(::PathMatchSpec(lpszFileName, prView.szFilter))
		{
			return i;
		}
	}

	// Ȃ0Ԃ
	return 0;
}


// r[hw肵ăt@CJ
HANDLE MainFrame::OpenForExclusion(LPCTSTR lpszPathName, const DWORD dwExclusion)
{
	// L[hw
	DWORD dwShareMode = FILE_SHARE_READ;
	switch(dwExclusion)
	{
	case EXCLUSION_NONE:             dwShareMode = FILE_SHARE_READ | FILE_SHARE_WRITE; break;
	case EXCLUSION_DISABLEWRITE:     dwShareMode = FILE_SHARE_READ; break;
	case EXCLUSION_DISABLEREADWRITE: dwShareMode = 0; break;
	}

	HANDLE hFile = ::CreateFile(
		lpszPathName,
		GENERIC_READ,
		dwShareMode,
		NULL,
		OPEN_ALWAYS,
		FILE_ATTRIBUTE_NORMAL,
		NULL);
	if(hFile == INVALID_HANDLE_VALUE)
	{
		wgc::wgfThrowLastError();
	}
	return hFile;
}


// t@CJ
// 󋵂ɉāuJv_CAOoÃt[ANeBuɂ肷
BOOL MainFrame::Open(LPCTSTR lpszPathName /* = NULL */)
{
	BOOL    bReadOnly = FALSE;
	INT_PTR nIndex    = -1;
	int     nCodePage = -2;

	// t@Ci[obt@
	TCHAR buffer[1024] = {wgc::tNUL};

	// vpeB擾
	MAINFRAME_PROPERTY prFrame;
	GetMainFrameProperty(prFrame);

	// ũt[ŊJvobt@ύXĂۑ邩q˂
	if(prFrame.flags.elements.bOpenByThisFrame && m_pEditDoc->IsModified())
	{
		switch(MessageBox_AskToSave())
		{
		case IDYES:    if(!Save()) { return FALSE; }    // no break
		case IDNO:     break;
		case IDCANCEL: return FALSE;
		}
	}

	// Jt@Cw肳ĂȂ΁A_CAOoĖ₢킹
	if(lpszPathName == NULL)
	{
		lpszPathName = buffer;
		nIndex = CreateOpenDialog(buffer, countof(buffer), &bReadOnly);
		if(nIndex == 0)
		{
			// LZ
			return FALSE;
		}
	}

	// {block}
	// łɂ̃t@CJĂt[΁AANeBuɂ
	{
		HWND hWnd = GetEditingFrame(lpszPathName);
		if(hWnd != NULL)
		{
			::SetForegroundWindow(hWnd);
			return TRUE;
		}
	}

	// ũt[ŊJv܂́u肩ύXvȂ炱̃t[ŊJ
	if(prFrame.flags.elements.bOpenByThisFrame || (m_strPathName.empty() && !m_pEditDoc->IsModified()))
	{
		OpenDocumentFile(lpszPathName, nIndex, bReadOnly, nCodePage);
		return TRUE;
	}

	// {block}
	// ǂłȂΐVXbhŊJ
	{
		CREATEFRAME_PARAMETER *lpParameter = new CREATEFRAME_PARAMETER;
		::lstrcpyn(lpParameter->szPathName, lpszPathName, countof(lpParameter->szPathName));
		lpParameter->bReadOnly   = bReadOnly;
		lpParameter->nLineNumber = 0;
		lpParameter->nCodePage   = -1;
		lpParameter->nCmdShow    = SW_NORMAL;
		lpParameter->nCodePage   = nCodePage;

		Station::CreateFrameThread(lpParameter);
	}

	return TRUE;
}

// w肳ꂽpX̃t@C݂̃t[ŊJ
void MainFrame::OpenDocumentFile(LPCTSTR lpszPathName, const INT_PTR nIndex /* = -1 */, const BOOL bReadOnly /* = TRUE */, const UINT uCodePage /* = CODEPAGE_ERROR */)
{
	assert(lpszPathName != NULL);

	// JĂt@CΕ
	if(m_hFile != INVALID_HANDLE_VALUE)
	{
		::CloseHandle(m_hFile);
		m_hFile = INVALID_HANDLE_VALUE;
	}

	// {block}
	// t@Cǂݍ
	{
		MAINFRAME_PROPERTY prFrame;
		GetMainFrameProperty(prFrame);

		m_hFile = OpenForExclusion(lpszPathName, prFrame.dwExclusionMode);

		wgc::File File(m_hFile);
		ReadTextData(File, uCodePage);

		// ǂݎpw肪邩At@Cǂݎp瑮ݒ
		m_pEditDoc->SetReadOnly(bReadOnly || wgc::File::IsReadOnly(lpszPathName));
	}

	// {block}
	// ݒ̃^Cv
	{
		const UINT_PTR uIndex = nIndex;
		if(uIndex < GetEditViewPropertySize())
		{
			m_uViewPropertyType = uIndex;
		}
		else
		{
			m_uViewPropertyType = FindFilterIndex(lpszPathName);
		}
	}

	// {block}
	// hLg
	{
		EDITVIEW_PROPERTY prView;
		KEYWORD_INFO      prKeyword;
		GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);
		m_pEditDoc->SetViewProperty(prView, prKeyword);
	}

	// t@Cƃ^CX^vݒ
	SetPathName(lpszPathName);
	GetTimeStamp(m_ftUpdate);
}

// w肳ꂽpX̃t@C݂̃t[ŊJ
void MainFrame::ReadTextData(wgc::File &rFile, const UINT uCodePage)
{
	// IuWFNgj̏𖾊mɂ邽߂ɃlXg
	rFile.SeekToBegin();
	{
		const DWORD dwFileSize = rFile.GetSize();
		if(dwFileSize == 0)
		{
			// t@CTCY0̏ꍇ
			m_pEditDoc->SetText(NULL, 0);
			m_uCodePage = ::GetACP();
			return;
		}

		// t@C}bsO
		wgc::mapping_object mapping_object(rFile);
		{
			// }bsOf[^̎擾
			wgc::mapping_object::mapping_data<char> mapping_data(mapping_object);
			{
				LPCSTR lpszData       = mapping_data.GetData();
				UINT   uCodePage_Copy = uCodePage;

				try
				{
					wxc::COM_XMultiLanguage2 xMultiLanguage2;
					UINT uOffset = 0;

					// w肳ꂽGR[h
					if(uCodePage_Copy == CODEPAGE_SPECIFY)
					{
						EDITVIEW_PROPERTY prView;
						KEYWORD_INFO      prKeyword;
						GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);

						uCodePage_Copy = prView.csDefault;
					}

					// F
					if(uCodePage_Copy == CODEPAGE_ERROR)
					{
						uCodePage_Copy = CodePage_AutoDetect(xMultiLanguage2, lpszData, dwFileSize, uOffset, CPAD_DETECTBOM, ::GetACP());
						m_bBom = (uOffset > 0) ? TRUE : FALSE;
					}

					// obt@փZbg
					SetText_Interface(xMultiLanguage2, lpszData + uOffset, dwFileSize - uOffset, uCodePage_Copy);
				}
				catch(const DWORD /* dwLastError */)
				{
					if(MessageBox_NoInterface(TRUE) == IDOK)
					{
						uCodePage_Copy = CODEPAGE_UTF16LE;
						SetText_NoInterface(lpszData, dwFileSize);
					}
					else
					{
						throw;
					}
				}
				m_uCodePage = uCodePage_Copy;
			}
		}
	}
}

void MainFrame::SetText_Interface(wxc::COM_XMultiLanguage2 &rMultiLanguage2, LPCSTR lpszData, const DWORD dwFileSize, const UINT uCodePage)
{
	// TCYvZ
	const DWORD dwSizeTotal = rMultiLanguage2.ConvertToUnicodeSize(lpszData, dwFileSize, uCodePage);

	// R[hϊ
	std::vector<WCHAR> buf(dwSizeTotal);
	rMultiLanguage2.ConvertToUnicode(
		lpszData, dwFileSize,
		&buf[0], dwSizeTotal,
		uCodePage);

	// obt@ɃZbg
	m_pEditDoc->SetText(&buf[0], buf.size());
}

void MainFrame::SetText_NoInterface(LPCSTR lpszData, const DWORD dwFileSize)
{
	m_pEditDoc->SetText(
		reinterpret_cast<LPCWSTR>(lpszData),
		dwFileSize / sizeof(WCHAR));
}


// t@CۑiKvɉă_CAO\j
BOOL MainFrame::Save(const BOOL bSaveAs /* = FALSE */)
{
	wgc::tstring_t strPathName = m_strPathName;

	// uOtĕۑv́uvȂ΃t@C擾
	if(bSaveAs || strPathName.empty())
	{
		// t@Ci[obt@
		TCHAR buffer[1024];
		buffer[0] = wgc::tNUL;

		if(!CreateSaveDialog(buffer, countof(buffer)))
		{
			// LZ
			return FALSE;
		}

		strPathName = buffer;
	}

	SaveDocumentFile(strPathName.c_str());
	return TRUE;
}

void MainFrame::SaveDocumentFile(LPCTSTR lpszPathName)
{
	MAINFRAME_PROPERTY prFrame;
	GetMainFrameProperty(prFrame);

	// JĂt@CΕ
	if(m_hFile != INVALID_HANDLE_VALUE)
	{
		::CloseHandle(m_hFile);
		m_hFile = INVALID_HANDLE_VALUE;
	}

	try
	{
		// {block}
		// t@Cɏ
		{
			wgc::File File(lpszPathName, GENERIC_WRITE);
			WriteTextData(File);
		}

		// rpɃt@CJ
		m_hFile = OpenForExclusion(lpszPathName, prFrame.dwExclusionMode);

		m_pEditDoc->SetModify(FALSE);           // _[eB[tONA
		m_pEditDoc->SetReadOnly(FALSE);         // ǂݎpiۑɐ݂ɐǂݎpł͂Ȃj

		// ^CX^vXV
		GetTimeStamp(m_ftUpdate);
		SetPathName(lpszPathName);
	}
	catch(const DWORD /* dwLastError */)
	{
		// ̃t@CJ
		m_hFile = OpenForExclusion(m_strPathName.c_str(), prFrame.dwExclusionMode);
		throw;
	}
}

// w肳ꂽnhɃt@Cۑ
void MainFrame::WriteTextData(wgc::File &rFile)
{
	EDITVIEW_PROPERTY prView;
	KEYWORD_INFO      prKeyword;
	GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);

	const BOOL      bAlwaysUseDefaultLFCode  = prView.flags.elements.bAlwaysUseDefaultLFCode;
	const sgc::charcode_linefeed_t lfDefault = prView.lfDefault;

	try
	{
		// BOM
		if(m_bBom)
		{
			BYTE bom[4];
			UINT bom_size;
			if(CodePage_GetBOM(m_uCodePage, bom, bom_size))
			{
				rFile.Write(bom, bom_size);
			}
		}
		SetBuffer_Interface(rFile, bAlwaysUseDefaultLFCode, lfDefault);
	}
	catch(const DWORD /* dwLastError */)
	{
		if(MessageBox_NoInterface(FALSE) == IDOK)
		{
			m_uCodePage = CODEPAGE_UTF16LE;
			SetBuffer_NoInterface(rFile, bAlwaysUseDefaultLFCode, lfDefault);
		}
		else
		{
			throw;
		}
	}
}

void MainFrame::SetBuffer_Interface(wgc::File &rFile, const BOOL bAlwaysUseDefaultLFCode, const sgc::charcode_linefeed_t lfDefault) const
{
	wxc::COM_XMultiLanguage2 xMultiLanguage2;

	EditDoc::const_iterator_t p = m_pEditDoc->GetIteratorBegin();
	for(;;)
	{
		// {block}
		// f[^R[hy[Wϊď
		{
			wgc::string_t str;
			const SIZE_T nSize = xMultiLanguage2.ConvertFromUnicodeSize(p->c_str(), p->length(), m_uCodePage);

			sgc::array<char> buffer(nSize);
			xMultiLanguage2.ConvertFromUnicode(
				p->c_str(), static_cast<int>(p->length()),
				buffer    , static_cast<int>(buffer.size()),
				m_uCodePage);
			rFile.Write(buffer, static_cast<DWORD>(buffer.size()));
		}

		// obt@̍ŌȂI
		EditDoc::const_iterator_t tmp = p;
		if(++p == m_pEditDoc->GetIteratorEnd())
		{
			rFile.Flush();
			return;
		}

		// {block}
		// sR[h
		{
			// sR[h擾
			sgc::charcode_linefeed_t lf_type = tmp->lf_type();
			if(bAlwaysUseDefaultLFCode || lf_type == sgc::CL_DEFAULT)
			{
				lf_type = lfDefault;
			}

			// ۂ̃R[hɕϊ
			wgc::string_t lf;
			xMultiLanguage2.ConvertFromUnicode(
				sgc::charcode_get_linefeed_string(lf_type),
				lf,
				m_uCodePage);

			rFile.Write(lf.c_str(), static_cast<DWORD>(lf.length()));
		}
	}
}

void MainFrame::SetBuffer_NoInterface(wgc::File &rFile, const BOOL bAlwaysUseDefaultLFCode, const sgc::charcode_linefeed_t lfDefault) const
{
	EditDoc::const_iterator_t p = m_pEditDoc->GetIteratorBegin();
	for(;;)
	{
		rFile.Write(p->c_str(), static_cast<DWORD>(p->length() * sizeof(WCHAR)));

		// obt@̍ŌȂI
		EditDoc::const_iterator_t tmp = p;
		if(++p == m_pEditDoc->GetIteratorEnd())
		{
			rFile.Flush();
			return;
		}

		// {block}
		// sR[h
		{
			// sR[h擾
			sgc::charcode_linefeed_t lf_type = tmp->lf_type();
			if(bAlwaysUseDefaultLFCode || lf_type == sgc::CL_DEFAULT)
			{
				lf_type = lfDefault;
			}

			// ۂ̃R[hɕϊ
			wgc::wstring_t lf = sgc::charcode_get_linefeed_string(lf_type);
			rFile.Write(lf.c_str(), static_cast<DWORD>(lf.length() * sizeof(WCHAR)));
		}
	}
}


// ύXꂽt@Cۑ邩˂
int MainFrame::MessageBox_AskToSave(void) const
{
	wgc::tstring_t title = m_strFileName;
	if(title.empty())
	{
		wgc::wgfLoadString(GetResourceHandle(), IDS_FILENAME_DEFAULT, title);
	}

	// ۑ邩q˂
	return AppMessageBoxFormat(
		m_hWnd,
		IDS_MSGBOX_ASKTOSAVE,
		MB_YESNOCANCEL | MB_ICONEXCLAMATION,
		title.c_str());
}

int MainFrame::MessageBox_AskToReload(void) const
{
	return AppMessageBoxFormat(
		m_hWnd,
		IDS_MSGBOX_ASKTORELOAD,
		MB_YESNO | MB_ICONEXCLAMATION,
		m_strFileName.c_str());
}

int MainFrame::MessageBox_NoInterface(const BOOL bOpen) const
{
	const UINT nIDResource = bOpen ? IDS_MSGBOX_NOINTERFACE_OPEN : IDS_MSGBOX_NOINTERFACE_SAVE;
	return AppMessageBox(m_hWnd, nIDResource, MB_OKCANCEL | MB_ICONEXCLAMATION);
}


// ҏW̃t@C̃^CX^viŏIXVj擾
void MainFrame::GetTimeStamp(FILETIME &rStamp) const
{
	assert(m_hFile != INVALID_HANDLE_VALUE);

	wgc::File File(m_hFile);
	File.GetTime(NULL, NULL, &rStamp);
}

// t@CXVĂ邩H
BOOL MainFrame::IsUpdated(const BOOL bUpdateTimeStamp /* = TRUE */)
{
	// t@CJĂȂFALSE
	if(m_hFile == INVALID_HANDLE_VALUE)
	{
		return FALSE;
	}

	try
	{
		// ^CX^v擾
		FILETIME ft;
		GetTimeStamp(ft);

		// ^CX^vOƓȂFALSE
		if(::CompareFileTime(&m_ftUpdate, &ft) == 0)
		{
			return FALSE;
		}

		// ^CX^vXV
		if(bUpdateTimeStamp)
		{
			m_ftUpdate = ft;
		}
		return TRUE;
	}
	catch(const DWORD dwLastError)
	{
		// G[NFALSE
		AppSystemMessageBox(m_hWnd, dwLastError, MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
}


////////////////////////////////////////////////////////////

// GfBbgR|[lg̗̈vZ
void MainFrame::GetEditRect(RECT &rect)
{
	// NCAg̈悩珜ORg[ID
	INT id[] =                              // {mask, id}
	{
		1, 1,
		1, IDW_STD_TOOLBAR,                     // c[o[
		1, IDW_STD_STATUSBAR,                   // Xe[^Xo[
		0, 0,
	};

	GetEffectiveClientRect(rect, id);
}

// GfBbgR|[lg̃CAEg̍ČvZ
void MainFrame::RecalcEditLayout(void)
{
	RECT rect;
	GetEditRect(rect);

	// TCYύX
	m_pEditDoc->ResizeWindow(IDW_EDIT_VIEW, rect);
}


// t[̃pXݒ
void MainFrame::SetPathName(LPCTSTR lpszPathName)
{
	m_strPathName = lpszPathName;
	m_strFileName = ::PathFindFileName(lpszPathName);

	UpdateFrameTitle();
}


// t[̃^CgXV
void MainFrame::UpdateFrameTitle(void)
{
	wgc::tstring_t title;

	// t@C擾
	if(m_strPathName.empty())
	{
		// JĂt@CȂ΃ftHg̖Oi{ł́uvj擾
		wgc::tstring_t file_default;
		AppLoadString(IDS_FILENAME_DEFAULT, file_default);
		title = file_default;
	}
	else
	{
		MAINFRAME_PROPERTY prFrame;
		GetMainFrameProperty(prFrame);

		BOOL bDisplayFullpath;
		if(m_bActive) { bDisplayFullpath = prFrame.flags.elements.bDisplayFullpathOnActive ; }
		else          { bDisplayFullpath = prFrame.flags.elements.bDisplayFullpathOnInactive; }

		if(bDisplayFullpath) { title = m_strPathName; }
		else                 { title = m_strFileName; }
	}

	// ύXĂ}[Nt
	if(m_pEditDoc->IsModified())
	{
		title += STR_MODIFIED;
	}

	title += STR_HYPHEN;

	// {block}
	// ̌ɃAvP[Vǉ
	{
		wgc::tstring_t app_name;
		AppLoadString(IDR_MAINFRAME, app_name);
		title += app_name;
	}

	SetWindowText(title);
}

// R}hC^[tF[XXV
void MainFrame::UpdateCommand(const command_interface &ci)
{
	OnUpdateFileSave(ci);

	OnUpdateEditUndo    (ci);
	OnUpdateEditRedo    (ci);
	OnUpdateEditCut     (ci);
	OnUpdateEditCopy    (ci);
	OnUpdateEditClear   (ci);
	OnUpdateEditPaste   (ci);
	OnUpdateEditReadonly(ci);

	OnUpdateViewBar    (ci);
	OnUpdateViewTopmost(ci);

	OnUpdateSettingChange  (ci);
	OnUpdateSettingProperty(ci);
}


// Xe[VɃwvbZ[W𑗂
void MainFrame::SendHelpMessage(const UINT uCommand)
{
	Station_SendHelpMessage(uCommand);
}


// ݒ𔽉f
void MainFrame::ReloadSetting(void)
{
	// vpeB擾āc
	EDITVIEW_PROPERTY prView;
	KEYWORD_INFO      prKeyword;
	GetEditViewProperty(prView, prKeyword, m_uViewPropertyType);

	// Đݒ
	m_pEditDoc->SetViewProperty(prView, prKeyword);
}

void MainFrame::RefrectSetting_Frame(void)
{
	::EnumWindows(RefrectFrameProc, 0);
}

void MainFrame::RefrectSetting_View(void)
{
	::EnumWindows(RefrectViewProc, m_uViewPropertyType);
}


// ::EnumWindows() ɓnvV[W

// łɕҏW̃t[邩H
BOOL CALLBACK MainFrame::FindWindowProc(HWND hWnd, LPARAM lParam)
{
	// NXCt[łȂΌs
	if(!IsMainFrame(hWnd))
	{
		return TRUE;
	}

	// ҏWt@C擾
	TCHAR szPathName[MAX_PATH];
	LPTSTR lpszPathName = szPathName;
	::SendMessage(hWnd, MAXY_GETPATHNAME, countof(szPathName), reinterpret_cast<LPARAM>(lpszPathName));

	// t@Cr
	LPFINDWINDOW lpfw = reinterpret_cast<LPFINDWINDOW>(lParam);

	// t@CvȂΌs
	if(::lstrcmpi(szPathName, lpfw->lpszPathName) != 0)
	{
		return TRUE;
	}

	// t@Cv΃EChEi[ČI
	lpfw->hWnd = hWnd;
	return FALSE;
}

BOOL MainFrame::RefrectFrameProc(HWND hWnd, LPARAM /* lParam */)
{
	// EChECt[Ȃ烁bZ[Ws
	if(IsMainFrame(hWnd))
	{
		::SendMessage(hWnd, MAXY_REFRECT_FRAME, 0, 0);
	}
	return TRUE;
}

BOOL MainFrame::RefrectViewProc(HWND hWnd, LPARAM lParam)
{
	// EChECt[Ȃ烁bZ[Ws
	if(IsMainFrame(hWnd))
	{
		::SendMessage(hWnd, MAXY_REFRECT_VIEW, lParam, 0);
	}
	return TRUE;
}
