// Customize.cpp cCve[Vt@C
#include "Customize.h"


////////////////////////////////////////////////////////////////////////////////
// RXgN^
DialogCustomize::DialogCustomize(DIALOGPROPERTY_CUSTOMIZE &rProperty, HWND hWndParent)
	: Dialog(GetResourceHandle(), MAKEINTRESOURCE(IDD), hWndParent),
	m_rProperty(rProperty)
{
}

// fXgN^
DialogCustomize::~DialogCustomize(void)
{
}


void DialogCustomize::AssociateDialogControls(void)
{
	m_cExclusion.SubclassDlgItem(IDC_CUSTOMIZE_EXCLUSION, this);
}

void DialogCustomize::UpdateData(const BOOL bUpdate /* = TRUE */)
{
	// _CAOIuWFNg
	if(bUpdate)
	{
		// t@C
		m_rProperty.nExclution = m_cExclusion.GetCurSel();
		m_rProperty.bCheckTimeStampOnActive = IsDlgButtonChecked(IDC_CUSTOMIZE_CHECKTIMESTAMPONACTIVE);
		m_rProperty.bOpenByThisFrame        = IsDlgButtonChecked(IDC_CUSTOMIZE_OPENBYTHISFRAME);

		// \
		m_rProperty.bRestorePlacement          = IsDlgButtonChecked(IDC_CUSTOMIZE_RESTOREPLACEMENT);
		m_rProperty.bDisplayFullpathOnActive   = IsDlgButtonChecked(IDC_CUSTOMIZE_DISPLAYFULLPATHONACTIVE);
		m_rProperty.bDisplayFullpathOnInactive = IsDlgButtonChecked(IDC_CUSTOMIZE_DISPLAYFULLPATHONINACTIVE);
	}
	// IuWFNg_CAO
	else
	{
		// t@C
		m_cExclusion.SetCurSel(m_rProperty.nExclution);
		CheckDlgButton(IDC_CUSTOMIZE_CHECKTIMESTAMPONACTIVE, m_rProperty.bCheckTimeStampOnActive);
		CheckDlgButton(IDC_CUSTOMIZE_OPENBYTHISFRAME       , m_rProperty.bOpenByThisFrame);

		// \
		CheckDlgButton(IDC_CUSTOMIZE_RESTOREPLACEMENT         , m_rProperty.bRestorePlacement);
		CheckDlgButton(IDC_CUSTOMIZE_DISPLAYFULLPATHONACTIVE  , m_rProperty.bDisplayFullpathOnActive);
		CheckDlgButton(IDC_CUSTOMIZE_DISPLAYFULLPATHONINACTIVE, m_rProperty.bDisplayFullpathOnInactive);
	}
}


// _CAO
BOOL DialogCustomize::OnInitDialog(HWND hWndFocus, const LPARAM dwInitParam)
{
	Dialog::OnInitDialog(hWndFocus, dwInitParam);

	// {block}
	// c[`bvݒ
	{
		const UINT array[] =
		{
			IDC_CUSTOMIZE_EXCLUSION,
			IDC_CUSTOMIZE_CHECKTIMESTAMPONACTIVE,
			IDC_CUSTOMIZE_OPENBYTHISFRAME,
			IDC_CUSTOMIZE_RESTOREPLACEMENT,
			IDC_CUSTOMIZE_DISPLAYFULLPATHONACTIVE,
			IDC_CUSTOMIZE_DISPLAYFULLPATHONINACTIVE,
		};
		SetToolTips(array, countof(array));
	}

	// {block}
	// r[h̃R{{bNXݒ
	{
		const UINT uIDArray[] =
		{
			IDS_COMBO_CUSTOMIZE_EXCLUSION_NONE,
			IDS_COMBO_CUSTOMIZE_EXCLUSION_DISABLEWRITE,
			IDS_COMBO_CUSTOMIZE_EXCLUSION_DISABLEREADWRITE,
		};
		for(int i = 0; i < countof(uIDArray); i++)
		{
			wgc::tstring_t strAddData;
			wgc::wgfLoadString(m_hResource, uIDArray[i], strAddData);
			m_cExclusion.AddString(strAddData);
		}
	}

	UpdateData(FALSE);
	return FALSE;
}

// R}h
BOOL DialogCustomize::OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl)
{
	return Dialog::OnCommand(wNotifyCode, wID, hWndCtrl);
}


////////////////////////////////////////////////////////////
// R}hnh
