<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">

   <xsl:output method="xml" omit-xml-declaration="yes" media-type="text/xml" encoding="UTF-8"/>

    <xsl:template match="alert">
        <xsl:element name="alert">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="@mess"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="button">
        <xsl:element name="button">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="alt">
                <xsl:value-of select="@alt"/>
            </xsl:attribute>
            <xsl:attribute name="parent">
                <xsl:value-of select="@parent"/>
            </xsl:attribute>
            <xsl:attribute name="position">
                <xsl:value-of select="@position"/>
            </xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="@title"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="checkbox">
        <xsl:element name="checkbox">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="checked">
                <xsl:value-of select="@checked"/>
            </xsl:attribute>
            <xsl:attribute name="className">
                <xsl:value-of select="@className"/>
            </xsl:attribute>
            <xsl:attribute name="parent">
                <xsl:value-of select="@parent"/>
            </xsl:attribute>
            <xsl:attribute name="text">
                <xsl:value-of select="@text"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="codeLib">
        <xsl:element name="codeLabel">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="alwaysRefresh">
                <xsl:value-of select="@alwaysRefresh"/>
            </xsl:attribute>
            <xsl:attribute name="codeWidth">
                <xsl:value-of select="@codeWidth"/>
            </xsl:attribute>
            <xsl:attribute name="parent">
                <xsl:value-of select="@parent"/>
            </xsl:attribute>
            <xsl:attribute name="submitOnload">
                <xsl:value-of select="@submitOnload"/>
            </xsl:attribute>
            <xsl:attribute name="url">
                <xsl:value-of select="@url"/>
            </xsl:attribute>
            <xsl:attribute name="width">
                <xsl:value-of select="@width"/>
            </xsl:attribute>
            <xsl:attribute name="withLabel">
                <xsl:value-of select="@boolWithLabel"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="combo">
        <xsl:element name="combo">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="enable">
                <xsl:value-of select="@enable"/>
            </xsl:attribute>
            <xsl:attribute name="heightItem">
                <xsl:value-of select="@heightItem"/>
            </xsl:attribute>
            <xsl:attribute name="parent">
                <xsl:value-of select="@parent"/>
            </xsl:attribute>
            <xsl:attribute name="position">
                <xsl:value-of select="@position"/>
            </xsl:attribute>
            <xsl:attribute name="suggest">
                <xsl:value-of select="@suggest"/>
            </xsl:attribute>
            <xsl:attribute name="width">
                <xsl:value-of select="@width"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="form">
        <xsl:element name="form">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="autoSubmit">
                <xsl:value-of select="@autoSubmit"/>
            </xsl:attribute>
            <xsl:attribute name="boolAsynch">
                <xsl:value-of select="@boolAsynch"/>
            </xsl:attribute>
            <xsl:attribute name="boolIframe">
                <xsl:value-of select="@boolIframe"/>
            </xsl:attribute>
            <xsl:attribute name="boolWithFenWait">
                <xsl:value-of select="@boolWithFenWait"/>
            </xsl:attribute>
            <xsl:attribute name="callBackObjectOnSuccess">
                <xsl:value-of select="@callBackObjectOnSuccess"/>
            </xsl:attribute>
            <xsl:attribute name="canBeCancel">
                <xsl:value-of select="@canBeCancel"/>
            </xsl:attribute>
            <xsl:attribute name="method">
                <xsl:value-of select="@method"/>
            </xsl:attribute>
            <xsl:attribute name="onSuccess">
                <xsl:value-of select="@onSuccess"/>
            </xsl:attribute>
            <xsl:attribute name="parent">
                <xsl:value-of select="@parent"/>
            </xsl:attribute>
            <xsl:attribute name="url">
                <xsl:value-of select="@url"/>
            </xsl:attribute>
            <xsl:apply-templates select="*"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="frame">
        <xsl:element name="frame">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="draggable">
                <xsl:value-of select="@draggable"/>
            </xsl:attribute>
            <xsl:attribute name="dynamic">
                <xsl:value-of select="@dynamic"/>
            </xsl:attribute>
            <xsl:attribute name="height">
                <xsl:value-of select="@height"/>
            </xsl:attribute>
            <xsl:attribute name="open">
                <xsl:value-of select="@open"/>
            </xsl:attribute>
            <xsl:attribute name="parent">
                <xsl:value-of select="@parent"/>
            </xsl:attribute>
            <xsl:attribute name="position">
                <xsl:value-of select="@position"/>
            </xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="@title"/>
            </xsl:attribute>
            <xsl:attribute name="width">
                <xsl:value-of select="@width"/>
            </xsl:attribute>
            <xsl:apply-templates select="*"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="grid">
        <xsl:element name="grid">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="TabEntete">
                <xsl:value-of select="@TabEntete"/>
            </xsl:attribute>
            <xsl:attribute name="actifClic">
                <xsl:value-of select="@actifClic"/>
            </xsl:attribute>
            <xsl:attribute name="bNavig">
                <xsl:value-of select="@bNavig"/>
            </xsl:attribute>
            <xsl:attribute name="cellActive">
                <xsl:value-of select="@cellActive"/>
            </xsl:attribute>
            <xsl:attribute name="height">
                <xsl:value-of select="@height"/>
            </xsl:attribute>
            <xsl:attribute name="lineHeight">
                <xsl:value-of select="@lineHeight"/>
            </xsl:attribute>
            <xsl:attribute name="multiSelect">
                <xsl:value-of select="@multiSelect"/>
            </xsl:attribute>
            <xsl:attribute name="parent">
                <xsl:value-of select="@parent"/>
            </xsl:attribute>
            <xsl:attribute name="position">
                <xsl:value-of select="@position"/>
            </xsl:attribute>
            <xsl:attribute name="rang">
                <xsl:value-of select="@rang"/>
            </xsl:attribute>
            <xsl:attribute name="sortable">
                <xsl:value-of select="@sortable"/>
            </xsl:attribute>
            <xsl:attribute name="switchable">
                <xsl:value-of select="@switchable"/>
            </xsl:attribute>
            <xsl:attribute name="tabTypeCol">
                <xsl:value-of select="@tabTypeCol"/>
            </xsl:attribute>
            <xsl:attribute name="writable">
                <xsl:value-of select="@writable"/>
            </xsl:attribute>
            <xsl:apply-templates select="*"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="gridHeader">
        <xsl:element name="gridHeader">
            <xsl:attribute name="title">
                <xsl:value-of select="@title"/>
            </xsl:attribute>
            <xsl:attribute name="type">
                <xsl:value-of select="@type"/>
            </xsl:attribute>
            <xsl:attribute name="width">
                <xsl:value-of select="@width"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="image">
        <xsl:element name="image">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="alt">
                <xsl:value-of select="@alternateText"/>
            </xsl:attribute>
            <xsl:attribute name="boolFloatLeft">
                <xsl:value-of select="@boolFloatLeft"/>
            </xsl:attribute>
            <xsl:attribute name="boolFloatRight">
                <xsl:value-of select="@boolFloatRight"/>
            </xsl:attribute>
            <xsl:attribute name="imageDisabled">
                <xsl:value-of select="@imageDisabled"/>
            </xsl:attribute>
            <xsl:attribute name="imageOn">
                <xsl:value-of select="@imageOn"/>
            </xsl:attribute>
            <xsl:attribute name="imageOut">
                <xsl:value-of select="@imageOut"/>
            </xsl:attribute>
            <xsl:attribute name="parent">
                <xsl:value-of select="@parent"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="label">
        <xsl:element name="label">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="className">
                <xsl:value-of select="@className"/>
            </xsl:attribute>
            <xsl:attribute name="text">
                <xsl:value-of select="@text"/>
            </xsl:attribute>
            <xsl:attribute name="parent">
                <xsl:value-of select="@parent"/>
            </xsl:attribute>
            <xsl:attribute name="position">
                <xsl:value-of select="@position"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="popup">
        <xsl:element name="popup">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="fond">
                <xsl:value-of select="@suffFond"/>
            </xsl:attribute>
            <xsl:attribute name="height">
                <xsl:value-of select="@height"/>
            </xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="@title"/>
            </xsl:attribute>
            <xsl:attribute name="width">
                <xsl:value-of select="@width"/>
            </xsl:attribute>
            <xsl:apply-templates select="*"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="radio">
        <xsl:element name="radio">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="checked">
                <xsl:value-of select="@checked"/>
            </xsl:attribute>
            <xsl:attribute name="className">
                <xsl:value-of select="@className"/>
            </xsl:attribute>
            <xsl:attribute name="group">
                <xsl:value-of select="@group"/>
            </xsl:attribute>
            <xsl:attribute name="parent">
                <xsl:value-of select="@parent"/>
            </xsl:attribute>
            <xsl:attribute name="text">
                <xsl:value-of select="@text"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="window">
        <xsl:element name="simpleWindow">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="height">
                <xsl:value-of select="@height"/>
            </xsl:attribute>
            <xsl:attribute name="icone">
                <xsl:value-of select="@icone"/>
            </xsl:attribute>
            <xsl:attribute name="parent">
                <xsl:value-of select="@parent"/>
            </xsl:attribute>
            <xsl:attribute name="position">
                <xsl:value-of select="@position"/>
            </xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="@title"/>
            </xsl:attribute>
            <xsl:attribute name="width">
                <xsl:value-of select="@width"/>
            </xsl:attribute>
            <xsl:apply-templates select="*"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="splitter">
        <xsl:element name="splitter">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="autoResizableH">
                <xsl:value-of select="@autoResizableH"/>
            </xsl:attribute>
            <xsl:attribute name="autoResizableW">
                <xsl:value-of select="@autoResizableW"/>
            </xsl:attribute>
            <xsl:attribute name="height">
                <xsl:value-of select="@height"/>
            </xsl:attribute>
            <xsl:attribute name="limInf">
                <xsl:value-of select="@limInf"/>
            </xsl:attribute>
            <xsl:attribute name="limSup">
                <xsl:value-of select="@limSup"/>
            </xsl:attribute>
            <xsl:attribute name="orientation">
                <xsl:value-of select="@orientation"/>
            </xsl:attribute>
            <xsl:attribute name="parent">
                <xsl:value-of select="@parent"/>
            </xsl:attribute>
            <xsl:attribute name="position">
                <xsl:value-of select="@position"/>
            </xsl:attribute>
            <xsl:attribute name="prop">
                <xsl:value-of select="@prop"/>
            </xsl:attribute>
            <xsl:attribute name="reverseClose">
                <xsl:value-of select="@reverseClose"/>
            </xsl:attribute>
            <xsl:attribute name="style">
                <xsl:value-of select="@style"/>
            </xsl:attribute>
            <xsl:attribute name="taileCurs">
                <xsl:value-of select="@tailleCurs"/>
            </xsl:attribute>
            <xsl:attribute name="width">
                <xsl:value-of select="@width"/>
            </xsl:attribute>
            <xsl:attribute name="withImg">
                <xsl:value-of select="@withImg"/>
            </xsl:attribute>
            <xsl:apply-templates select="*"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="divSplit">
        <xsl:element name="divSplitter">
            <xsl:apply-templates select="*"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tabFolder">
        <xsl:element name="tabfolder">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="autoRedimTab">
                <xsl:value-of select="@autoRedimTab"/>
            </xsl:attribute>
            <xsl:attribute name="draggableItem">
                <xsl:value-of select="@draggableItem"/>
            </xsl:attribute>
            <xsl:attribute name="height">
                <xsl:value-of select="@height"/>
            </xsl:attribute>
            <xsl:attribute name="isClosable">
                <xsl:value-of select="@isClosable"/>
            </xsl:attribute>
            <xsl:attribute name="parent">
                <xsl:value-of select="@parent"/>
            </xsl:attribute>
            <xsl:attribute name="position">
                <xsl:value-of select="@position"/>
            </xsl:attribute>
            <xsl:attribute name="width">
                <xsl:value-of select="@width"/>
            </xsl:attribute>
            <xsl:attribute name="widthTabName">
                <xsl:value-of select="@widthTabName"/>
            </xsl:attribute>
            <xsl:apply-templates select="*"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tabItem">
        <xsl:element name="tabitem">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="@title"/>
            </xsl:attribute>
            <xsl:apply-templates select="*"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="text">
        <xsl:element name="text">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="accessKey">
                <xsl:value-of select="@accessKey"/>
            </xsl:attribute>
            <xsl:attribute name="autoUp">
                <xsl:value-of select="@autoUp"/>
            </xsl:attribute>
            <xsl:attribute name="datatype">
                <xsl:value-of select="@datatype"/>
            </xsl:attribute>
            <xsl:attribute name="disable">
                <xsl:value-of select="@disable"/>
            </xsl:attribute>
            <xsl:attribute name="initValue">
                <xsl:value-of select="@initValue"/>
            </xsl:attribute>
            <xsl:attribute name="isRequired">
                <xsl:value-of select="@isRequired"/>
            </xsl:attribute>
            <xsl:attribute name="nbChar">
                <xsl:value-of select="@nbchar"/>
            </xsl:attribute>
            <xsl:attribute name="parent">
                <xsl:value-of select="@parent"/>
            </xsl:attribute>
            <xsl:attribute name="rows">
                <xsl:value-of select="@rows"/>
            </xsl:attribute>
            <xsl:attribute name="tabIndex">
                <xsl:value-of select="@tabIndex"/>
            </xsl:attribute>
            <xsl:attribute name="width">
                <xsl:value-of select="@width"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="treeview">
        <xsl:element name="treeview">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="boolSelActive">
                <xsl:value-of select="@boolSelActive"/>
            </xsl:attribute>
            <xsl:attribute name="draggableNode">
                <xsl:value-of select="@draggableNode"/>
            </xsl:attribute>
            <xsl:attribute name="height">
                <xsl:value-of select="@height"/>
            </xsl:attribute>
            <xsl:attribute name="parent">
                <xsl:value-of select="@parent"/>
            </xsl:attribute>
            <xsl:attribute name="position">
                <xsl:value-of select="@position"/>
            </xsl:attribute>
            <xsl:attribute name="rootOpen">
                <xsl:value-of select="@rootOpen"/>
            </xsl:attribute>
            <xsl:attribute name="width">
                <xsl:value-of select="@width"/>
            </xsl:attribute>
            <xsl:attribute name="withRoot">
                <xsl:value-of select="@withRoot"/>
            </xsl:attribute>
            <xsl:attribute name="withT">
                <xsl:value-of select="@withT"/>
            </xsl:attribute>
            <xsl:apply-templates select="*"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="treeNode">
        <xsl:element name="treenode">
            <xsl:attribute name="name">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:attribute name="left">
                <xsl:value-of select="@left"/>
            </xsl:attribute>
            <xsl:attribute name="top">
                <xsl:value-of select="@top"/>
            </xsl:attribute>
            <xsl:attribute name="icon">
                <xsl:value-of select="@sIcon"/>
            </xsl:attribute>
            <xsl:attribute name="icon2">
                <xsl:value-of select="@sIcon2"/>
            </xsl:attribute>
            <xsl:attribute name="onclick">
                <xsl:value-of select="@onclick"/>
            </xsl:attribute>
            <xsl:attribute name="open">
                <xsl:value-of select="@open"/>
            </xsl:attribute>
            <xsl:attribute name="reload">
                <xsl:value-of select="@reload"/>
            </xsl:attribute>
            <xsl:attribute name="text">
                <xsl:value-of select="@sText"/>
            </xsl:attribute>
            <xsl:attribute name="url">
                <xsl:value-of select="@url"/>
            </xsl:attribute>
            <xsl:apply-templates select="*"/>
        </xsl:element>
    </xsl:template>

   <xsl:template match="/layoutDef/layout">
      <xsl:element name="rialto">
         <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   
   <!-- 以下のノードを無視 -->
   <xsl:template match="javaScript">
   </xsl:template>
   <xsl:template match="javaScriptGlobal">
   </xsl:template>
   <xsl:template match="desc">
   </xsl:template>

   <xsl:template match="text()"> </xsl:template><!-- テキストノードを無視する -->
</xsl:stylesheet>