/*
 * Copyright 2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.codeLabelTeleConsumer={};

/**
 * 以下のような電文のconsumerです：
 * <param><code>1</code><label>ラベル</label></param>
 */
maskat.codeLabelTeleConsumer.consume=function(targetObj,teleNode){
    if ((targetObj==null) || !(targetObj instanceof rialto.widget.codeLabel)){
        throw new MaskatError({name: "codeLabelTeleConsumerエラー",
                         message: "targetObjはrialto.widget.codeLabelではありません",
                         fileName: "codeLabelWrapper.js",
                         functionName: "maskat.codeLabelTeleConsumer.consume"});
    }
    //電文にteleNodeは一個しかないであるはず
    var code = maskat.xpath(teleNode[0], 'code/text()');
    var theLabel = maskat.xpath(teleNode[0], 'label/text()');
    targetObj.setValue(code,theLabel);
}

ObjWrapper.registerTeleConsumer("codeLabel.codeLabel",maskat.codeLabelTeleConsumer);
