/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.tabbedproperties;

import java.lang.reflect.InvocationTargetException;

import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.maskat.framework.BasicDef;
import org.maskat.ide.editors.MaskatEditor;

public class TableKeyListenerForEditor extends KeyAdapter {

	private Table table;

	private String[] propNames;

	private BasicDef basicDef;

	private Class childClass;

	/** TODO should have a instance of CommandStack instead of an editor */
	protected MaskatEditor editor;

	public TableKeyListenerForEditor(Table table, String[] propNames, BasicDef def,
			Class childClass, MaskatEditor editor) {
		this.table = table;
		this.propNames = propNames;
		this.basicDef = def;
		this.childClass = childClass;
		this.editor = editor;

	}

	public void keyReleased(KeyEvent e) {
		if (e.keyCode == SWT.DEL) {
			TableItem item = table.getItem(table.getSelectionIndex());
			for (int i = 0; i < table.getColumnCount(); i++) {
				item.setText(i, "");
			}

			Object obj = (Object) basicDef.getChildByTypeIdx(childClass, table
					.getSelectionIndex());
			for (int i = 0; i < propNames.length; i++) {
				try {
					// Set the newValue to the object.
					// TODO should be command here(CommandStack)
					PropertyUtils.setProperty(obj, propNames[i], "");
					editor.makeDirty();
				} catch (IllegalAccessException e1) {
					e1.printStackTrace();
				} catch (InvocationTargetException e1) {
					e1.printStackTrace();
				} catch (NoSuchMethodException e1) {
					e1.printStackTrace();
				}
			}
		}
		super.keyReleased(e);
	}
}
