/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.commands;

import org.eclipse.gef.commands.Command;
import org.maskat.framework.screendef.ComboDef;
import org.maskat.framework.screendef.ComboItemDef;

public class DelComboItemCommand extends Command {
	private ComboDef parent;

	private ComboItemDef component;

	private int idx;

	public DelComboItemCommand(ComboDef parent, ComboItemDef child) {
		super("R{ACe폜");
		this.parent = parent;
		this.component = child;
	}

	public void execute() {
		idx = parent.getChildIdx(component);
		if (idx == -1) {
			throw new IllegalStateException(
					"The comboitem is not a child of the combobox.");
		}
		parent.removeChild(component);
	}

	public void undo() {
		parent.addChildToIdx(component, idx);
	}

	public boolean canUndo() {
		return true;
	}
}
