/*
 * Copyright 2006 Mask@ Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 maskat.RadioGroup = function(group){
  this.group = group;
  this.type = "radioGroup";
  this.base = rialto.widget.AbstractComponent;
  this.radioMemberArray = new Array();
  this.radioMemberNameArray = new Array();
}

maskat.RadioGroup.prototype = new rialto.widget.AbstractComponent;

maskat.RadioGroup.prototype.addRadioMemberName = function(radioMemberName){
  this.radioMemberNameArray.push(radioMemberName);
}

maskat.RadioGroup.prototype.addRadioMember = function(radioMember){
  this.radioMemberArray.push(radioMember);
}

maskat.RadioGroup.prototype.getSelValue = function(){
  for (var i = 0; i < this.radioMemberArray.length; i++){
    if (this.radioMemberArray[i].getCheck()){
      return this.radioMemberArray[i].name;
    }
  }
  return "";
}

maskat.RadioGroup.prototype.setSelValue = function(radioName){
  for (var i = 0; i < this.radioMemberArray.length; i++){
    if (this.radioMemberArray[i].name == radioName){
      this.radioMemberArray[i].setCheck(true);
      return;
    }
  }
}

maskat.RadioGroup.prototype.initRadio = function(){
  for (var i = 0; i < this.radioMemberArray.length; i++){
    this.radioMemberArray[i].setCheck(false);
  }
}