/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.m4hv.extensions.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.maru.m4hv.extensions.constraints.AlphabetNumber;
import org.maru.m4hv.extensions.constraints.CasePattern;

public class AlphabetNumberValidator implements ConstraintValidator<AlphabetNumber, String> {

    private static final String BOTH_ALPHABET_NUMBER_PATTERN = "[a-zA-Z0-9]*";
    private static final String UPPER_ALPHABET_NUMBER_PATTERN = "[A-Z0-9]*";
    private static final String LOWER_ALPHABET_NUMBER_PATTERN = "[a-z0-9]*";

    private CasePattern casePattern;

    public void initialize(AlphabetNumber alphabetNumber) {
        this.casePattern = alphabetNumber.value();
    }

    /**
     * Validates string passed as the first paramenter whether to match the alhabet or number.
     */
    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }

        Pattern pattern = createPattern(casePattern);
        Matcher matcher = pattern.matcher(object);
        return matcher.matches();
    }

    private static Pattern createPattern(CasePattern casePattern) {
        switch (casePattern) {
            case BOTH:
                return Pattern.compile(BOTH_ALPHABET_NUMBER_PATTERN);
            case UPPER:
                return Pattern.compile(UPPER_ALPHABET_NUMBER_PATTERN);
            case LOWER:
                return Pattern.compile(LOWER_ALPHABET_NUMBER_PATTERN);
            default : // unreachable.
                throw new IllegalArgumentException("Unexpected pattern :" + casePattern);
        }
    }

}
