package org.maru.m4hv.extensions.constraints;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.CONSTRUCTOR;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

import org.maru.m4hv.extensions.validator.HalfwidthKatakanaValidator;

/**
 * Halfwidth katakana validator<br>
 *
 * This validates that the string value is halfwidth katakana. If it's so, the
 * result of the validation is valid. Allowing halfwidth space is optional when
 * you set enableSpace flag on this annotation is true, default is false.
 *
 *
 */
@Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER })
@Retention(RUNTIME)
@Constraint(validatedBy = HalfwidthKatakanaValidator.class)
@Documented
public @interface HalfwidthKatakana {
    String message() default "{org.maru.m4hv.extensions.HalfwidthKatakana.message}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

    boolean enableSpace() default false;

    @Target({ METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER })
    @Retention(RUNTIME)
    @Documented
    @interface List {
        HalfwidthKatakana[] value();
    }
}
